/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.inmemory;

import com.google.common.util.concurrent.AbstractService;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.tephra.TransactionManager;
import org.apache.twill.common.Cancellable;
import org.apache.twill.discovery.Discoverable;
import org.apache.twill.discovery.DiscoveryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryTransactionService
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryTransactionService.class);
    private final DiscoveryService discoveryService;
    private final String serviceName;
    protected final Provider<TransactionManager> txManagerProvider;
    private Cancellable cancelDiscovery;
    protected TransactionManager txManager;
    protected final String address;
    protected final int port;
    protected final int threads;
    protected final int ioThreads;
    protected final int maxReadBufferBytes;

    @Inject
    public InMemoryTransactionService(Configuration conf, DiscoveryService discoveryService, Provider<TransactionManager> txManagerProvider) {
        this.discoveryService = discoveryService;
        this.txManagerProvider = txManagerProvider;
        this.serviceName = conf.get("data.tx.discovery.service.name", "transaction");
        this.address = conf.get("data.tx.bind.address", "0.0.0.0");
        this.port = conf.getInt("data.tx.bind.port", 15165);
        this.threads = conf.getInt("data.tx.server.threads", 20);
        this.ioThreads = conf.getInt("data.tx.server.io.threads", 2);
        this.maxReadBufferBytes = conf.getInt("data.tx.thrift.max.read.buffer", 0x1000000);
        LOG.info("Configuring TransactionService, address: " + this.address + ", port: " + this.port + ", threads: " + this.threads + ", io threads: " + this.ioThreads + ", max read buffer (bytes): " + this.maxReadBufferBytes);
    }

    protected void undoRegister() {
        if (this.cancelDiscovery != null) {
            this.cancelDiscovery.cancel();
        }
    }

    protected void doRegister() {
        this.cancelDiscovery = this.discoveryService.register(new Discoverable(this.serviceName, this.getAddress()));
    }

    protected InetSocketAddress getAddress() {
        return new InetSocketAddress(1);
    }

    protected void doStart() {
        try {
            this.txManager = (TransactionManager)((Object)this.txManagerProvider.get());
            this.txManager.startAndWait();
            this.doRegister();
            LOG.info("Transaction Thrift service started successfully on " + this.getAddress());
            this.notifyStarted();
        }
        catch (Throwable t) {
            LOG.info("Transaction Thrift service didn't start on " + this.getAddress());
            this.notifyFailed(t);
        }
    }

    protected void doStop() {
        this.undoRegister();
        this.txManager.stopAndWait();
        this.notifyStopped();
    }
}

