/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.omid.committable.hbase.HBaseCommitTableStorageModule;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.tso.LeaseManagement;
import org.apache.omid.tso.LeaseManager;
import org.apache.omid.tso.LowWatermarkWriter;
import org.apache.omid.tso.PersistenceProcessor;
import org.apache.omid.tso.ReplyProcessor;
import org.apache.omid.tso.RequestProcessor;
import org.apache.omid.tso.RetryProcessor;
import org.apache.omid.tso.TSOModule;
import org.apache.omid.tso.TSOServerConfig;
import org.apache.omid.tso.TSOStateManager;
import org.apache.omid.tso.VoidLeaseManager;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.AbstractIdleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TSOServer
extends AbstractIdleService {
    private static final Logger LOG = LoggerFactory.getLogger(TSOServer.class);
    public static final String DASH_SEPARATOR_80_CHARS = "--------------------------------------------------------------------------------";
    public static final String TSO_HOST_AND_PORT_KEY = "tso.hostandport";
    @Inject
    private TSOStateManager tsoStateManager;
    @Inject
    private RequestProcessor requestProcessor;
    @Inject
    private PersistenceProcessor persistenceProcessor;
    @Inject
    private RetryProcessor retryProcessor;
    @Inject
    public ReplyProcessor replyProcessor;
    @Inject
    private LowWatermarkWriter lowWatermarkWriter;
    @Inject
    private LeaseManagement leaseManagement;

    public static TSOServer getInitializedTsoServer(TSOServerConfig config) throws IOException {
        LOG.info("Configuring TSO Server...");
        Injector injector = Guice.createInjector(TSOServer.buildModuleList(config));
        LOG.info("TSO Server configured. Creating instance...");
        return (TSOServer)((Object)injector.getInstance(TSOServer.class));
    }

    private static List<Module> buildModuleList(final TSOServerConfig config) throws IOException {
        ArrayList<Module> guiceModules = new ArrayList<Module>();
        guiceModules.add(config.getTimestampStoreModule());
        guiceModules.add(config.getCommitTableStoreModule());
        guiceModules.add(config.getLeaseModule());
        guiceModules.add((Module)new TSOModule(config));
        guiceModules.add(new Module(){

            public void configure(Binder binder) {
                LOG.info("\t* Metrics provider module set to {}", config.getMetrics().getClass());
                binder.bind(MetricsRegistry.class).toInstance((Object)config.getMetrics());
            }
        });
        return guiceModules;
    }

    protected void startUp() throws Exception {
        LOG.info("{}", (Object)DASH_SEPARATOR_80_CHARS);
        LOG.info("Starting TSO Server");
        LOG.info("{}", (Object)DASH_SEPARATOR_80_CHARS);
        this.tsoStateManager.register(this.requestProcessor);
        this.leaseManagement.startService();
        LOG.info("{}", (Object)DASH_SEPARATOR_80_CHARS);
        if (this.leaseManagement instanceof VoidLeaseManager) {
            LOG.info("TSO Server running and accepting connections");
        } else if (this.leaseManagement instanceof LeaseManager) {
            LOG.info("TSO Server running on HA mode. Waiting to be signaled as the Master replica...");
        } else {
            throw new RuntimeException("Wrong TSO mode");
        }
        LOG.info("{}", (Object)DASH_SEPARATOR_80_CHARS);
    }

    protected void shutDown() throws Exception {
        LOG.info("{}", (Object)DASH_SEPARATOR_80_CHARS);
        LOG.info("Shutting Down TSO Server");
        LOG.info("{}", (Object)DASH_SEPARATOR_80_CHARS);
        this.leaseManagement.stopService();
        this.tsoStateManager.unregister(this.requestProcessor);
        this.requestProcessor.close();
        this.persistenceProcessor.close();
        this.retryProcessor.close();
        this.replyProcessor.close();
        LOG.info("{}", (Object)DASH_SEPARATOR_80_CHARS);
        LOG.info("TSO Server stopped");
        LOG.info("{}", (Object)DASH_SEPARATOR_80_CHARS);
    }

    private void attachShutDownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                TSOServer.this.stopAsync();
                TSOServer.this.awaitTerminated();
            }
        });
        LOG.info("Shutdown Hook Attached");
    }

    public static void main(String[] args) {
        TSOServerConfig config = new TSOServerConfig();
        try {
            TSOServer tsoServer = TSOServer.getInitializedTsoServer(config);
            tsoServer.attachShutDownHook();
            tsoServer.startAsync();
            tsoServer.awaitRunning();
            if (config.getLowLatency().booleanValue() && !(config.getCommitTableStoreModule() instanceof HBaseCommitTableStorageModule)) {
                LOG.error("Running low latency mode with memory commit table. Use only with testing!");
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.exit(-1);
        }
    }
}

