/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.metrics;

import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.hadoop.metrics2.lib.MutableHistogram;
import org.apache.phoenix.hbase.index.metrics.MetricsIndexerSource;

public class MetricsIndexerSourceImpl
extends BaseSourceImpl
implements MetricsIndexerSource {
    private final MetricHistogram indexPrepareTimeHisto = this.getMetricsRegistry().newHistogram("indexPrepareTime", "Histogram for the time in milliseconds for preparing an index write");
    private final MutableFastCounter slowIndexPrepareCalls = this.getMetricsRegistry().newCounter("slowIndexPrepareCalls", "The number of index preparations slower than the configured threshold", 0L);
    private final MetricHistogram indexWriteTimeHisto = this.getMetricsRegistry().newHistogram("indexWriteTime", "Histogram for the time in milliseconds for writing an index update");
    private final MutableFastCounter slowIndexWriteCalls = this.getMetricsRegistry().newCounter("slowIndexWriteCalls", "The number of index writes slower than the configured threshold", 0L);
    private final MetricHistogram preWALRestoreTimeHisto = this.getMetricsRegistry().newHistogram("preWALRestoreTime", "Histogram for the time in milliseconds for Indexer's preWALRestore");
    private final MutableFastCounter slowPreWALRestoreCalls = this.getMetricsRegistry().newCounter("slowPreWALRestoreCalls", "The number of preWALRestore calls slower than the configured threshold", 0L);
    private final MetricHistogram postPutTimeHisto = this.getMetricsRegistry().newHistogram("postPutTime", "Histogram for the time in milliseconds for Indexer's postPut");
    private final MutableFastCounter slowPostPutCalls = this.getMetricsRegistry().newCounter("slowPostPutCalls", "The number of postPut calls slower than the configured threshold", 0L);
    private final MetricHistogram postDeleteTimeHisto = this.getMetricsRegistry().newHistogram("postDeleteTime", "Histogram for the time in milliseconds for Indexer's postDelete");
    private final MutableFastCounter slowPostDeleteCalls = this.getMetricsRegistry().newCounter("slowPostDeleteCalls", "The number of postDelete calls slower than the configured threshold", 0L);
    private final MetricHistogram postOpenTimeHisto = this.getMetricsRegistry().newHistogram("postOpenTime", "Histogram for the time in milliseconds for Indexer's postOpen");
    private final MutableFastCounter slowPostOpenCalls = this.getMetricsRegistry().newCounter("slowPostOpenCalls", "The number of postOpen calls slower than the configured threshold", 0L);
    private final MetricHistogram duplicateKeyTimeHisto = this.getMetricsRegistry().newHistogram("duplicateKeyCheckTime", "Histogram for the time in milliseconds to handle ON DUPLICATE keywords");
    private final MutableFastCounter slowDuplicateKeyCalls = this.getMetricsRegistry().newCounter("slowDuplicateKeyCheckCalls", "The number of on duplicate key checks slower than the configured threshold", 0L);
    private final MetricHistogram preIndexUpdateTimeHisto;
    private final MetricHistogram postIndexUpdateTimeHisto = this.getMetricsRegistry().newHistogram("postIndexUpdateTime", "Histogram for the time in milliseconds for index updates post data updates");
    private final MetricHistogram preIndexUpdateFailureTimeHisto;
    private final MetricHistogram postIndexUpdateFailureTimeHisto;
    private final MutableFastCounter preIndexUpdateFailures;
    private final MutableFastCounter postIndexUpdateFailures;

    public MetricsIndexerSourceImpl() {
        this("PhoenixIndexer", "Metrics about the Phoenix Indexer", "phoenix", "RegionServer,sub=PhoenixIndexer");
    }

    public MetricsIndexerSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.preIndexUpdateTimeHisto = this.getMetricsRegistry().newHistogram("preIndexUpdateTime", "Histogram for the time in milliseconds for index updates pre data updates");
        this.postIndexUpdateFailureTimeHisto = this.getMetricsRegistry().newHistogram("postIndexUpdateFailureTime", "Histogram for the time in milliseconds on failures of index updates post data updates");
        this.preIndexUpdateFailureTimeHisto = this.getMetricsRegistry().newHistogram("preIndexUpdateFailureTime", "Histogram for the time in milliseconds on failures of index updates pre data updates");
        this.postIndexUpdateFailures = this.getMetricsRegistry().newCounter("postIndexUpdateFailure", "The number of failures of index updates post data updates", 0L);
        this.preIndexUpdateFailures = this.getMetricsRegistry().newCounter("preIndexUpdateFailure", "The number of failures of index updates pre data updates", 0L);
    }

    @Override
    public void updateIndexPrepareTime(String dataTableName, long t) {
        this.incrementTableSpecificHistogram("indexPrepareTime", dataTableName, t);
        this.indexPrepareTimeHisto.add(t);
    }

    @Override
    public void updateIndexWriteTime(String dataTableName, long t) {
        this.incrementTableSpecificHistogram("indexWriteTime", dataTableName, t);
        this.indexWriteTimeHisto.add(t);
    }

    @Override
    public void updatePreWALRestoreTime(String dataTableName, long t) {
        this.incrementTableSpecificHistogram("preWALRestoreTime", dataTableName, t);
        this.preWALRestoreTimeHisto.add(t);
    }

    @Override
    public void updatePostPutTime(String dataTableName, long t) {
        this.incrementTableSpecificHistogram("postPutTime", dataTableName, t);
        this.postPutTimeHisto.add(t);
    }

    @Override
    public void updatePostDeleteTime(String dataTableName, long t) {
        this.incrementTableSpecificHistogram("postDeleteTime", dataTableName, t);
        this.postDeleteTimeHisto.add(t);
    }

    @Override
    public void updatePostOpenTime(String dataTableName, long t) {
        this.incrementTableSpecificHistogram("postOpenTime", dataTableName, t);
        this.postOpenTimeHisto.add(t);
    }

    @Override
    public void incrementNumSlowIndexPrepareCalls(String dataTableName) {
        this.incrementTableSpecificCounter("slowIndexPrepareCalls", dataTableName);
        this.slowIndexPrepareCalls.incr();
    }

    @Override
    public void incrementNumSlowIndexWriteCalls(String dataTableName) {
        this.incrementTableSpecificCounter("slowIndexWriteCalls", dataTableName);
        this.slowIndexWriteCalls.incr();
    }

    @Override
    public void incrementNumSlowPreWALRestoreCalls(String dataTableName) {
        this.incrementTableSpecificCounter("slowPreWALRestoreCalls", dataTableName);
        this.slowPreWALRestoreCalls.incr();
    }

    @Override
    public void incrementNumSlowPostPutCalls(String dataTableName) {
        this.incrementTableSpecificCounter("slowPostPutCalls", dataTableName);
        this.slowPostPutCalls.incr();
    }

    @Override
    public void incrementNumSlowPostDeleteCalls(String dataTableName) {
        this.incrementTableSpecificCounter("slowPostDeleteCalls", dataTableName);
        this.slowPostDeleteCalls.incr();
    }

    @Override
    public void incrementNumSlowPostOpenCalls(String dataTableName) {
        this.incrementTableSpecificCounter("slowPostOpenCalls", dataTableName);
        this.slowPostOpenCalls.incr();
    }

    @Override
    public void updateDuplicateKeyCheckTime(String dataTableName, long t) {
        this.incrementTableSpecificHistogram("duplicateKeyCheckTime", dataTableName, t);
        this.duplicateKeyTimeHisto.add(t);
    }

    @Override
    public void incrementSlowDuplicateKeyCheckCalls(String dataTableName) {
        this.incrementTableSpecificCounter("slowDuplicateKeyCheckCalls", dataTableName);
        this.slowDuplicateKeyCalls.incr();
    }

    @Override
    public void updatePreIndexUpdateTime(String dataTableName, long t) {
        this.incrementTableSpecificHistogram("preIndexUpdateTime", dataTableName, t);
        this.preIndexUpdateTimeHisto.add(t);
    }

    @Override
    public void updatePostIndexUpdateTime(String dataTableName, long t) {
        this.incrementTableSpecificHistogram("postIndexUpdateTime", dataTableName, t);
        this.postIndexUpdateTimeHisto.add(t);
    }

    @Override
    public void updatePreIndexUpdateFailureTime(String dataTableName, long t) {
        this.incrementTableSpecificHistogram("preIndexUpdateFailureTime", dataTableName, t);
        this.preIndexUpdateFailureTimeHisto.add(t);
    }

    @Override
    public void updatePostIndexUpdateFailureTime(String dataTableName, long t) {
        this.incrementTableSpecificHistogram("postIndexUpdateFailureTime", dataTableName, t);
        this.postIndexUpdateFailureTimeHisto.add(t);
    }

    @Override
    public void incrementPreIndexUpdateFailures(String dataTableName) {
        this.incrementTableSpecificCounter("preIndexUpdateFailure", dataTableName);
        this.preIndexUpdateFailures.incr();
    }

    @Override
    public void incrementPostIndexUpdateFailures(String dataTableName) {
        this.incrementTableSpecificCounter("postIndexUpdateFailure", dataTableName);
        this.postIndexUpdateFailures.incr();
    }

    private void incrementTableSpecificCounter(String baseCounterName, String tableName) {
        MutableFastCounter indexSpecificCounter = this.getMetricsRegistry().getCounter(this.getCounterName(baseCounterName, tableName), 0L);
        indexSpecificCounter.incr();
    }

    private void incrementTableSpecificHistogram(String baseCounterName, String tableName, long t) {
        MutableHistogram tableSpecificHistogram = this.getMetricsRegistry().getHistogram(this.getCounterName(baseCounterName, tableName));
        tableSpecificHistogram.add(t);
    }

    private String getCounterName(String baseCounterName, String tableName) {
        return baseCounterName + "." + tableName;
    }
}

