/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.MutableStatement;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.TableName;

public class CreateSequenceStatement
extends MutableStatement {
    private final TableName sequenceName;
    private final ParseNode startWith;
    private final ParseNode incrementBy;
    private final ParseNode cacheSize;
    private final ParseNode minValue;
    private final ParseNode maxValue;
    private final boolean cycle;
    private final boolean ifNotExists;
    private final int bindCount;

    public static CreateSequenceStatement create(TableName sequenceName) {
        return new CreateSequenceStatement(sequenceName, null, null, null, null, null, false, true, 0);
    }

    protected CreateSequenceStatement(TableName sequenceName, ParseNode startWith, ParseNode incrementBy, ParseNode cacheSize, ParseNode minValue, ParseNode maxValue, boolean cycle, boolean ifNotExists, int bindCount) {
        this.sequenceName = sequenceName;
        this.startWith = minValue == null && maxValue == null && startWith == null ? LiteralParseNode.ONE : startWith;
        this.minValue = minValue == null ? new LiteralParseNode(Long.MIN_VALUE) : minValue;
        this.maxValue = maxValue == null ? new LiteralParseNode(Long.MAX_VALUE) : maxValue;
        this.incrementBy = incrementBy == null ? LiteralParseNode.ONE : incrementBy;
        this.cacheSize = cacheSize;
        this.cycle = cycle;
        this.ifNotExists = ifNotExists;
        this.bindCount = bindCount;
    }

    @Override
    public int getBindCount() {
        return this.bindCount;
    }

    public ParseNode getIncrementBy() {
        return this.incrementBy;
    }

    public TableName getSequenceName() {
        return this.sequenceName;
    }

    public ParseNode getCacheSize() {
        return this.cacheSize;
    }

    public ParseNode getMinValue() {
        return this.minValue;
    }

    public ParseNode getMaxValue() {
        return this.maxValue;
    }

    public boolean getCycle() {
        return this.cycle;
    }

    public ParseNode getStartWith() {
        return this.startWith;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }
}

