/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.tuple;

import java.util.Collections;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.util.GenericKeyValueBuilder;
import org.apache.phoenix.schema.tuple.BaseTuple;
import org.apache.phoenix.util.KeyValueUtil;

public class ResultTuple
extends BaseTuple {
    private final Result result;
    public static final ResultTuple EMPTY_TUPLE = new ResultTuple(Result.create(Collections.emptyList()));

    public ResultTuple(Result result) {
        this.result = result;
    }

    public Result getResult() {
        return this.result;
    }

    @Override
    public void getKey(ImmutableBytesWritable ptr) {
        ptr.set(this.result.getRow());
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    public KeyValue getValue(byte[] family, byte[] qualifier) {
        Cell cell = KeyValueUtil.getColumnLatest(GenericKeyValueBuilder.INSTANCE, this.result.rawCells(), family, qualifier);
        return org.apache.hadoop.hbase.KeyValueUtil.ensureKeyValue((Cell)cell);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("keyvalues=");
        if (this.result == null || this.result.isEmpty()) {
            sb.append("NONE");
            return sb.toString();
        }
        sb.append("{");
        boolean moreThanOne = false;
        for (Cell kv : this.result.listCells()) {
            if (moreThanOne) {
                sb.append(", \n");
            } else {
                moreThanOne = true;
            }
            sb.append(kv.toString() + "/value=" + Bytes.toString((byte[])kv.getValueArray(), (int)kv.getValueOffset(), (int)kv.getValueLength()));
        }
        sb.append("}\n");
        return sb.toString();
    }

    @Override
    public int size() {
        return this.result.size();
    }

    public KeyValue getValue(int index) {
        return org.apache.hadoop.hbase.KeyValueUtil.ensureKeyValue((Cell)this.result.rawCells()[index]);
    }

    @Override
    public boolean getValue(byte[] family, byte[] qualifier, ImmutableBytesWritable ptr) {
        KeyValue kv = this.getValue(family, qualifier);
        if (kv == null) {
            return false;
        }
        ptr.set(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength());
        return true;
    }
}

