/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.distributed;

import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.tephra.distributed.AbstractClientProvider;
import org.apache.tephra.distributed.CloseableThriftClient;
import org.apache.tephra.distributed.TransactionServiceThriftClient;
import org.apache.thrift.TException;
import org.apache.twill.discovery.DiscoveryServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleUseClientProvider
extends AbstractClientProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SingleUseClientProvider.class);
    final int timeout;

    public SingleUseClientProvider(Configuration conf, DiscoveryServiceClient discoveryServiceClient, int timeout) {
        super(conf, discoveryServiceClient);
        this.timeout = timeout;
    }

    @Override
    public CloseableThriftClient getCloseableClient() throws TException, TimeoutException, InterruptedException {
        return new CloseableThriftClient(this, this.newClient(this.timeout));
    }

    @Override
    public void returnClient(TransactionServiceThriftClient client) {
        client.close();
    }

    public String toString() {
        return "Single-use(timeout = " + this.timeout + ")";
    }
}

