/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.export;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.protocol.body.SubscriptionGroupWrapper;
import org.apache.rocketmq.remoting.protocol.body.TopicConfigSerializeWrapper;
import org.apache.rocketmq.remoting.protocol.subscription.SubscriptionGroupConfig;
import org.apache.rocketmq.srvutil.ServerUtil;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.command.CommandUtil;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class ExportMetadataCommand
implements SubCommand {
    private static final String DEFAULT_FILE_PATH = "/tmp/rocketmq/export";

    @Override
    public String commandName() {
        return "exportMetadata";
    }

    @Override
    public String commandDesc() {
        return "Export metadata";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("c", "clusterName", true, "choose a cluster to export");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("b", "brokerAddr", true, "choose a broker to export");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("f", "filePath", true, "export metadata.json path | default /tmp/rocketmq/export");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("t", "topic", false, "only export topic metadata");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("g", "subscriptionGroup", false, "only export subscriptionGroup metadata");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("s", "specialTopic", false, "need retryTopic and dlqTopic");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            defaultMQAdminExt.start();
            String filePath = !commandLine.hasOption('f') ? DEFAULT_FILE_PATH : commandLine.getOptionValue('f').trim();
            boolean specialTopic = commandLine.hasOption('s');
            if (commandLine.hasOption('b')) {
                String brokerAddr = commandLine.getOptionValue('b').trim();
                if (commandLine.hasOption('t')) {
                    filePath = filePath + "/topic.json";
                    TopicConfigSerializeWrapper topicConfigSerializeWrapper = defaultMQAdminExt.getUserTopicConfig(brokerAddr, specialTopic, 10000L);
                    MixAll.string2FileNotSafe((String)JSON.toJSONString((Object)topicConfigSerializeWrapper, (boolean)true), (String)filePath);
                    System.out.printf("export %s success", filePath);
                } else if (commandLine.hasOption('g')) {
                    filePath = filePath + "/subscriptionGroup.json";
                    SubscriptionGroupWrapper subscriptionGroupWrapper = defaultMQAdminExt.getUserSubscriptionGroup(brokerAddr, 10000L);
                    MixAll.string2FileNotSafe((String)JSON.toJSONString((Object)subscriptionGroupWrapper, (boolean)true), (String)filePath);
                    System.out.printf("export %s success", filePath);
                }
            } else if (commandLine.hasOption('c')) {
                String exportPath;
                String clusterName = commandLine.getOptionValue('c').trim();
                Set<String> masterSet = CommandUtil.fetchMasterAddrByClusterName(defaultMQAdminExt, clusterName);
                HashMap topicConfigMap = new HashMap();
                HashMap subGroupConfigMap = new HashMap();
                HashMap<String, Serializable> result = new HashMap<String, Serializable>();
                for (String addr : masterSet) {
                    TopicConfigSerializeWrapper topicConfigSerializeWrapper = defaultMQAdminExt.getUserTopicConfig(addr, specialTopic, 10000L);
                    SubscriptionGroupWrapper subscriptionGroupWrapper = defaultMQAdminExt.getUserSubscriptionGroup(addr, 10000L);
                    for (Map.Entry entry : topicConfigSerializeWrapper.getTopicConfigTable().entrySet()) {
                        TopicConfig topicConfig = (TopicConfig)topicConfigMap.get(entry.getKey());
                        if (null != topicConfig) {
                            ((TopicConfig)entry.getValue()).setWriteQueueNums(topicConfig.getWriteQueueNums() + ((TopicConfig)entry.getValue()).getWriteQueueNums());
                            ((TopicConfig)entry.getValue()).setReadQueueNums(topicConfig.getReadQueueNums() + ((TopicConfig)entry.getValue()).getReadQueueNums());
                        }
                        topicConfigMap.put(entry.getKey(), entry.getValue());
                    }
                    for (Map.Entry entry : subscriptionGroupWrapper.getSubscriptionGroupTable().entrySet()) {
                        SubscriptionGroupConfig subscriptionGroupConfig = (SubscriptionGroupConfig)subGroupConfigMap.get(entry.getKey());
                        if (null != subscriptionGroupConfig) {
                            ((SubscriptionGroupConfig)entry.getValue()).setRetryQueueNums(subscriptionGroupConfig.getRetryQueueNums() + ((SubscriptionGroupConfig)entry.getValue()).getRetryQueueNums());
                        }
                        subGroupConfigMap.put(entry.getKey(), entry.getValue());
                    }
                }
                if (commandLine.hasOption('t')) {
                    result.put("topicConfigTable", topicConfigMap);
                    exportPath = filePath + "/topic.json";
                } else if (commandLine.hasOption('g')) {
                    result.put("subscriptionGroupTable", subGroupConfigMap);
                    exportPath = filePath + "/subscriptionGroup.json";
                } else {
                    result.put("topicConfigTable", topicConfigMap);
                    result.put("subscriptionGroupTable", subGroupConfigMap);
                    exportPath = filePath + "/metadata.json";
                }
                result.put("exportTime", Long.valueOf(System.currentTimeMillis()));
                MixAll.string2FileNotSafe((String)JSON.toJSONString(result, (boolean)true), (String)exportPath);
                System.out.printf("export %s success%n", exportPath);
            } else {
                ServerUtil.printCommandLineHelp((String)("mqadmin " + this.commandName()), (Options)options);
            }
        }
        catch (Exception e) {
            throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }
}

