/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffle.parser.node;

import it.geosolutions.jaiext.jiffle.Jiffle;
import it.geosolutions.jaiext.jiffle.JiffleProperties;
import it.geosolutions.jaiext.jiffle.parser.node.Expression;
import it.geosolutions.jaiext.jiffle.parser.node.Node;
import it.geosolutions.jaiext.jiffle.runtime.AbstractDirectRuntime;
import it.geosolutions.jaiext.jiffle.runtime.AbstractIndirectRuntime;
import java.util.Arrays;

public class SourceWriter {
    private Jiffle.RuntimeModel runtimeModel;
    private StringBuilder sb = new StringBuilder();
    private int indentStep = 4;
    private int indentAmount = 0;
    private String indentation = "";
    private String script;
    private String baseClassName;

    public SourceWriter(Jiffle.RuntimeModel model) {
        this.runtimeModel = model;
    }

    public Jiffle.RuntimeModel getRuntimeModel() {
        return this.runtimeModel;
    }

    public String writeToString(Expression node) {
        SourceWriter sw = new SourceWriter(this.runtimeModel);
        node.write(sw);
        return sw.getSource();
    }

    public void inc() {
        this.indentAmount += this.indentStep;
    }

    public void dec() {
        this.indentAmount = this.indentStep < this.indentAmount ? (this.indentAmount -= this.indentStep) : 0;
    }

    public SourceWriter line(String line) {
        String indentation = this.getIndentation();
        this.sb.append(indentation).append(line).append("\n");
        return this;
    }

    public SourceWriter append(String text) {
        this.sb.append(text);
        return this;
    }

    public String getSource() {
        return this.sb.toString();
    }

    private String getIndentation() {
        if (this.indentation.length() < this.indentAmount) {
            char[] charArray = new char[this.indentAmount];
            Arrays.fill(charArray, ' ');
            this.indentation = new String(charArray);
        } else if (this.indentation.length() > this.indentAmount) {
            this.indentation = this.indentation.substring(0, this.indentAmount);
        }
        return this.indentation;
    }

    public void newLine() {
        this.sb.append("\n");
    }

    public SourceWriter indent() {
        this.sb.append(this.getIndentation());
        return this;
    }

    public SourceWriter append(Node node) {
        node.write(this);
        return this;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    public void setBaseClassName(String baseClassName) {
        this.baseClassName = baseClassName;
    }

    public String getBaseClassName() {
        if (this.baseClassName == null) {
            if (this.runtimeModel == Jiffle.RuntimeModel.DIRECT) {
                return JiffleProperties.DEFAULT_DIRECT_BASE_CLASS.getName();
            }
            return JiffleProperties.DEFAULT_INDIRECT_BASE_CLASS.getName();
        }
        return this.baseClassName;
    }

    public boolean isInternalBaseClass() {
        String baseClassName = this.getBaseClassName();
        return AbstractDirectRuntime.class.getName().equals(baseClassName) || AbstractIndirectRuntime.class.getName().equals(baseClassName);
    }
}

