/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetRecordMaterializer;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001df\u0001B\t\u0013\u0001\u0005B\u0001\u0002\f\u0001\u0003\u0006\u0004%\t%\f\u0005\ty\u0001\u0011\t\u0011)A\u0005]!AQ\b\u0001B\u0001B\u0003%a\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011!a\u0006A!A!\u0002\u0013\u0011\u0005\"B/\u0001\t\u0003q\u0006\"\u00033\u0001\u0001\u0004\u0005\r\u0011\"\u0003f\u0011%a\u0007\u00011AA\u0002\u0013%Q\u000eC\u0005t\u0001\u0001\u0007\t\u0011)Q\u0005M\")A\u000f\u0001C!k\"9\u0011Q\u0004\u0001\u0005B\u0005}qaBA@%!\u0005\u0011\u0011\u0011\u0004\u0007#IA\t!a!\t\rukA\u0011AAF\u0011\u001d\ti)\u0004C\u0005\u0003\u001fCq!!)\u000e\t\u0003\t\u0019KA\u000bHK>\u0004\u0016M]9vKR\u0014V-\u00193TkB\u0004xN\u001d;\u000b\u0005M!\u0012a\u00029beF,X\r\u001e\u0006\u0003+Y\t1\u0002Z1uCN|WO]2fg*\u0011q\u0003G\u0001\nKb,7-\u001e;j_:T!!\u0007\u000e\u0002\u0007M\fHN\u0003\u0002\u001c9\u0005)1\u000f]1sW*\u0011QDH\u0001\u0007CB\f7\r[3\u000b\u0003}\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0012'!\t\u0019C%D\u0001\u0013\u0013\t)#C\u0001\nQCJ\fX/\u001a;SK\u0006$7+\u001e9q_J$\bCA\u0014+\u001b\u0005A#BA\u0015\u001b\u0003!Ig\u000e^3s]\u0006d\u0017BA\u0016)\u0005\u001daunZ4j]\u001e\f\u0011bY8om\u0016\u0014H\u000f\u0016>\u0016\u00039\u00022a\f\u001a5\u001b\u0005\u0001$\"A\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0002$AB(qi&|g\u000e\u0005\u00026u5\taG\u0003\u00028q\u0005!A/[7f\u0015\u0005I\u0014\u0001\u00026bm\u0006L!a\u000f\u001c\u0003\ri{g.Z%e\u0003)\u0019wN\u001c<feR$&\u0010I\u0001\u0017K:\f'\r\\3WK\u000e$xN]5{K\u0012\u0014V-\u00193feB\u0011qfP\u0005\u0003\u0001B\u0012qAQ8pY\u0016\fg.\u0001\neCR,G/[7f%\u0016\u0014\u0017m]3N_\u0012,\u0007CA\"Y\u001d\t!UK\u0004\u0002F%:\u0011a)\u0015\b\u0003\u000fBs!\u0001S(\u000f\u0005%seB\u0001&N\u001b\u0005Y%B\u0001'!\u0003\u0019a$o\\8u}%\tq$\u0003\u0002\u001e=%\u00111\u0004H\u0005\u00033iI!!\u000b\r\n\u0005M#\u0016aB*R\u0019\u000e{gN\u001a\u0006\u0003SaI!AV,\u0002)1+w-Y2z\u0005\u0016D\u0017M^5peB{G.[2z\u0015\t\u0019F+\u0003\u0002Z5\n)a+\u00197vK&\u00111\f\r\u0002\f\u000b:,X.\u001a:bi&|g.A\bj]RLdGU3cCN,Wj\u001c3f\u0003\u0019a\u0014N\\5u}Q)q\fY1cGB\u00111\u0005\u0001\u0005\u0006Y\u0019\u0001\rA\f\u0005\u0006{\u0019\u0001\rA\u0010\u0005\u0006\u0003\u001a\u0001\rA\u0011\u0005\u00069\u001a\u0001\rAQ\u0001\u0018G\u0006$\u0018\r\\=tiJ+\u0017/^3ti\u0016$7k\u00195f[\u0006,\u0012A\u001a\t\u0003O*l\u0011\u0001\u001b\u0006\u0003Sb\tQ\u0001^=qKNL!a\u001b5\u0003\u0015M#(/^2u)f\u0004X-A\u000edCR\fG._:u%\u0016\fX/Z:uK\u0012\u001c6\r[3nC~#S-\u001d\u000b\u0003]F\u0004\"aL8\n\u0005A\u0004$\u0001B+oSRDqA\u001d\u0005\u0002\u0002\u0003\u0007a-A\u0002yIE\n\u0001dY1uC2L8\u000f\u001e*fcV,7\u000f^3e'\u000eDW-\\1!\u0003\u0011Ig.\u001b;\u0015\u0007Y\f\t\u0002E\u0002x\u0003\u0017q1\u0001_A\u0003\u001d\tIxP\u0004\u0002{y:\u0011\u0001j_\u0005\u0003'qI!! @\u0002\r!\fGm\\8q\u0015\t\u0019B$\u0003\u0003\u0002\u0002\u0005\r\u0011aA1qS*\u0011QP`\u0005\u0005\u0003\u000f\tI!A\u0006SK\u0006$7+\u001e9q_J$(\u0002BA\u0001\u0003\u0007IA!!\u0004\u0002\u0010\tY!+Z1e\u0007>tG/\u001a=u\u0015\u0011\t9!!\u0003\t\u000f\u0005M!\u00021\u0001\u0002\u0016\u000591m\u001c8uKb$\b\u0003BA\f\u00033i!!!\u0003\n\t\u0005m\u0011\u0011\u0002\u0002\f\u0013:LGoQ8oi\u0016DH/\u0001\bqe\u0016\u0004\u0018M]3G_J\u0014V-\u00193\u0015\u0015\u0005\u0005\u00121HA&\u0003W\nY\b\u0005\u0004\u0002$\u0005-\u0012qF\u0007\u0003\u0003KQA!!\u0001\u0002()\u0019\u0011\u0011\u0006@\u0002\u0005%|\u0017\u0002BA\u0017\u0003K\u0011!CU3d_J$W*\u0019;fe&\fG.\u001b>feB!\u0011\u0011GA\u001c\u001b\t\t\u0019DC\u0002\u00026a\t\u0001bY1uC2L8\u000f^\u0005\u0005\u0003s\t\u0019DA\u0006J]R,'O\\1m%><\bbBA\u001f\u0017\u0001\u0007\u0011qH\u0001\u0005G>tg\r\u0005\u0003\u0002B\u0005\u001dSBAA\"\u0015\u0011\ti$!\u0012\u000b\u0005ud\u0012\u0002BA%\u0003\u0007\u0012QbQ8oM&<WO]1uS>t\u0007bBA'\u0017\u0001\u0007\u0011qJ\u0001\u0011W\u0016Lh+\u00197vK6+G/\u0019#bi\u0006\u0004\u0002\"!\u0015\u0002X\u0005m\u00131L\u0007\u0003\u0003'R1!!\u00169\u0003\u0011)H/\u001b7\n\t\u0005e\u00131\u000b\u0002\u0004\u001b\u0006\u0004\b\u0003BA/\u0003KrA!a\u0018\u0002bA\u0011!\nM\u0005\u0004\u0003G\u0002\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002h\u0005%$AB*ue&twMC\u0002\u0002dABq!!\u001c\f\u0001\u0004\ty'\u0001\u0006gS2,7k\u00195f[\u0006\u0004B!!\u001d\u0002x5\u0011\u00111\u000f\u0006\u0004\u0003kr\u0018AB:dQ\u0016l\u0017-\u0003\u0003\u0002z\u0005M$aC'fgN\fw-\u001a+za\u0016Da!! \f\u0001\u00041\u0018a\u0003:fC\u0012\u001cuN\u001c;fqR\fQcR3p!\u0006\u0014\u0018/^3u%\u0016\fGmU;qa>\u0014H\u000f\u0005\u0002$\u001bM!Q\"!\"'!\ry\u0013qQ\u0005\u0004\u0003\u0013\u0003$AB!osJ+g\r\u0006\u0002\u0002\u0002\u00061\u0012N\u001c;feN,7\r\u001e)beF,X\r^$s_V\u00048\u000f\u0006\u0004\u0002\u0012\u0006e\u0015Q\u0014\t\u0005_I\n\u0019\n\u0005\u0003\u0002r\u0005U\u0015\u0002BAL\u0003g\u0012\u0011b\u0012:pkB$\u0016\u0010]3\t\u000f\u0005mu\u00021\u0001\u0002\u0014\u0006QqM]8vaRK\b/Z\u0019\t\u000f\u0005}u\u00021\u0001\u0002\u0014\u0006QqM]8vaRK\b/\u001a\u001a\u0002\u0013\u0015D\b/\u00198e+\u0012#Fc\u00014\u0002&\"1\u0011Q\u000f\tA\u0002\u0019\u0004")
public class GeoParquetReadSupport
extends ParquetReadSupport {
    private final Option<ZoneId> convertTz;
    private final boolean enableVectorizedReader;
    private final Enumeration.Value datetimeRebaseMode;
    private final Enumeration.Value int96RebaseMode;
    private StructType catalystRequestedSchema;

    public static StructType expandUDT(StructType schema) {
        return GeoParquetReadSupport$.MODULE$.expandUDT(schema);
    }

    public Option<ZoneId> convertTz() {
        return this.convertTz;
    }

    private StructType catalystRequestedSchema() {
        return this.catalystRequestedSchema;
    }

    private void catalystRequestedSchema_$eq(StructType x$1) {
        this.catalystRequestedSchema = x$1;
    }

    public ReadSupport.ReadContext init(InitContext context) {
        Configuration conf = context.getConfiguration();
        String schemaString = conf.get(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA());
        Predef$.MODULE$.assert(schemaString != null, (Function0 & Serializable)() -> "Parquet requested schema not set.");
        this.catalystRequestedSchema_$eq(StructType$.MODULE$.fromString(schemaString));
        boolean caseSensitive = conf.getBoolean(SQLConf$.MODULE$.CASE_SENSITIVE().key(), BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.CASE_SENSITIVE().defaultValue().get()));
        boolean schemaPruningEnabled = conf.getBoolean(SQLConf$.MODULE$.NESTED_SCHEMA_PRUNING_ENABLED().key(), BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.NESTED_SCHEMA_PRUNING_ENABLED().defaultValue().get()));
        boolean useFieldId = conf.getBoolean(SQLConf$.MODULE$.PARQUET_FIELD_ID_READ_ENABLED().key(), BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.PARQUET_FIELD_ID_READ_ENABLED().defaultValue().get()));
        MessageType parquetFileSchema = context.getFileSchema();
        MessageType parquetClippedSchema = ParquetReadSupport$.MODULE$.clipParquetSchema(parquetFileSchema, this.catalystRequestedSchema(), caseSensitive, useFieldId);
        MessageType parquetRequestedSchema = schemaPruningEnabled && !this.enableVectorizedReader ? (MessageType)GeoParquetReadSupport$.MODULE$.org$apache$spark$sql$execution$datasources$parquet$GeoParquetReadSupport$$intersectParquetGroups((GroupType)parquetClippedSchema, (GroupType)parquetFileSchema).map((Function1 & Serializable)groupType -> new MessageType(groupType.getName(), groupType.getFields())).getOrElse((Function0 & Serializable)() -> ParquetSchemaConverter$.MODULE$.EMPTY_MESSAGE()) : parquetClippedSchema;
        this.logDebug((Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(273).append("Going to read the following fields from the Parquet file with the following schema:\n         |Parquet file schema:\n         |").append(parquetFileSchema).append("\n         |Parquet clipped schema:\n         |").append(parquetClippedSchema).append("\n         |Parquet requested schema:\n         |").append(parquetRequestedSchema).append("\n         |Catalyst requested schema:\n         |").append(this.catalystRequestedSchema().treeString()).append("\n       ").toString())));
        return new ReadSupport.ReadContext(parquetRequestedSchema, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava());
    }

    public RecordMaterializer<InternalRow> prepareForRead(Configuration conf, java.util.Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        MessageType parquetRequestedSchema = readContext.getRequestedSchema();
        return new GeoParquetRecordMaterializer(parquetRequestedSchema, GeoParquetReadSupport$.MODULE$.expandUDT(this.catalystRequestedSchema()), new GeoParquetToSparkSchemaConverter(keyValueMetaData, conf), this.convertTz(), this.datetimeRebaseMode, this.int96RebaseMode);
    }

    public GeoParquetReadSupport(Option<ZoneId> convertTz, boolean enableVectorizedReader, Enumeration.Value datetimeRebaseMode, Enumeration.Value int96RebaseMode) {
        this.convertTz = convertTz;
        this.enableVectorizedReader = enableVectorizedReader;
        this.datetimeRebaseMode = datetimeRebaseMode;
        this.int96RebaseMode = int96RebaseMode;
    }
}

