/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.spy;

import com.p6spy.engine.spy.P6LoadableOptions;
import com.p6spy.engine.spy.P6SpyOptions;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;

public class P6MBeansRegistry {
    private final Collection<ObjectName> mBeans = new ArrayList<ObjectName>();
    public static final String PACKAGE_NAME = "com.p6spy";

    public void registerMBeans(Collection<P6LoadableOptions> allOptions) throws MBeanRegistrationException, InstanceNotFoundException, MalformedObjectNameException, NotCompliantMBeanException {
        boolean jmx = true;
        String jmxPrefix = "";
        for (P6LoadableOptions options : allOptions) {
            if (!(options instanceof P6SpyOptions)) continue;
            jmx = ((P6SpyOptions)options).getJmx();
            jmxPrefix = ((P6SpyOptions)options).getJmxPrefix();
            break;
        }
        if (!jmx) {
            return;
        }
        this.unregisterAllMBeans(jmxPrefix);
        for (P6LoadableOptions options : allOptions) {
            try {
                this.registerMBean(options, jmxPrefix);
            }
            catch (InstanceAlreadyExistsException e) {
                this.registerMBeans(allOptions);
            }
        }
    }

    protected void registerMBean(P6LoadableOptions mBean, String jmxPrefix) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, MalformedObjectNameException {
        this.checkMBean(mBean);
        ObjectName mBeanObjectName = this.getObjectName(mBean, jmxPrefix);
        ManagementFactory.getPlatformMBeanServer().registerMBean(mBean, mBeanObjectName);
        this.mBeans.add(mBeanObjectName);
    }

    public void unregisterAllMBeans(String jmxPrefix) throws MBeanRegistrationException, MalformedObjectNameException {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        for (ObjectName mBeanObjectName : this.mBeans) {
            try {
                mbs.unregisterMBean(mBeanObjectName);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {}
        }
        this.mBeans.clear();
        for (ObjectName objectName : mbs.queryNames(new ObjectName(P6MBeansRegistry.getPackageName(jmxPrefix) + ":name=com.p6spy.*"), null)) {
            try {
                mbs.unregisterMBean(objectName);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {}
        }
    }

    private void checkMBean(P6LoadableOptions mBean) {
        if (null == mBean) {
            throw new IllegalArgumentException("mBean is null!");
        }
        if (!(mBean instanceof StandardMBean)) {
            throw new IllegalArgumentException("mBean has to be instance of the StandardMBean class! But is not: " + mBean);
        }
    }

    protected ObjectName getObjectName(P6LoadableOptions mBean, String jmxPrefix) throws MalformedObjectNameException {
        return new ObjectName(P6MBeansRegistry.getPackageName(jmxPrefix) + ":name=" + mBean.getClass().getName());
    }

    protected static String getPackageName(String jmxPrefix) {
        return PACKAGE_NAME + (null == jmxPrefix || jmxPrefix.isEmpty() ? "" : "." + jmxPrefix);
    }
}

