/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.cache;

import io.fabric8.kubernetes.client.informers.cache.Cache;
import io.fabric8.kubernetes.client.informers.cache.ProcessorListener;
import io.fabric8.kubernetes.client.informers.cache.SharedProcessor;
import io.fabric8.kubernetes.client.informers.cache.SyncableStore;
import java.util.List;
import java.util.Map;

public class ProcessorStore<T>
implements SyncableStore<T> {
    private Cache<T> cache;
    private SharedProcessor<T> processor;

    public ProcessorStore(Cache<T> cache, SharedProcessor<T> processor) {
        this.cache = cache;
        this.processor = processor;
    }

    @Override
    public void add(T obj) {
        this.update(obj);
    }

    @Override
    public void update(T obj) {
        T oldObj = this.cache.put(obj);
        if (oldObj != null) {
            this.processor.distribute(new ProcessorListener.UpdateNotification<T>(oldObj, obj), false);
        } else {
            this.processor.distribute(new ProcessorListener.AddNotification<T>(obj), false);
        }
    }

    @Override
    public void delete(T obj) {
        T oldObj = this.cache.remove(obj);
        if (oldObj != null) {
            this.processor.distribute(new ProcessorListener.DeleteNotification<T>(obj, false), false);
        }
    }

    @Override
    public List<T> list() {
        return this.cache.list();
    }

    @Override
    public List<String> listKeys() {
        return this.cache.listKeys();
    }

    @Override
    public T get(T object) {
        return this.cache.get(object);
    }

    @Override
    public T getByKey(String key) {
        return this.cache.getByKey(key);
    }

    @Override
    public void replace(List<T> list) {
        Map<String, T> oldState = this.cache.replace(list);
        for (T newValue : list) {
            T old2 = oldState.remove(this.cache.getKey(newValue));
            if (old2 == null) {
                this.processor.distribute(new ProcessorListener.AddNotification<T>(newValue), true);
                continue;
            }
            this.processor.distribute(new ProcessorListener.UpdateNotification<T>(old2, newValue), true);
        }
        oldState.values().forEach(old -> this.processor.distribute(new ProcessorListener.DeleteNotification<Object>(old, true), false));
    }

    @Override
    public void resync() {
        this.cache.list().forEach(i -> this.processor.distribute(new ProcessorListener.UpdateNotification<Object>(i, i), true));
    }
}

