/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.time.LocalTime;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public final class LocalTimeSerializer
extends TypeSerializerSingleton<LocalTime> {
    private static final long serialVersionUID = 1L;
    public static final LocalTimeSerializer INSTANCE = new LocalTimeSerializer();

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public LocalTime createInstance() {
        return LocalTime.MIDNIGHT;
    }

    @Override
    public LocalTime copy(LocalTime from) {
        return from;
    }

    @Override
    public LocalTime copy(LocalTime from, LocalTime reuse) {
        return from;
    }

    @Override
    public int getLength() {
        return 7;
    }

    @Override
    public void serialize(LocalTime record, DataOutputView target) throws IOException {
        if (record == null) {
            target.writeByte(-128);
            target.writeShort(Short.MIN_VALUE);
            target.writeInt(Integer.MIN_VALUE);
        } else {
            target.writeByte(record.getHour());
            target.writeByte(record.getMinute());
            target.writeByte(record.getSecond());
            target.writeInt(record.getNano());
        }
    }

    @Override
    public LocalTime deserialize(DataInputView source) throws IOException {
        byte hour = source.readByte();
        if (hour == -128) {
            source.readShort();
            source.readInt();
            return null;
        }
        return LocalTime.of(hour, source.readByte(), source.readByte(), source.readInt());
    }

    @Override
    public LocalTime deserialize(LocalTime reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeByte(source.readByte());
        target.writeShort(source.readShort());
        target.writeInt(source.readInt());
    }

    @Override
    public TypeSerializerSnapshot<LocalTime> snapshotConfiguration() {
        return new LocalTimeSerializerSnapshot();
    }

    public static final class LocalTimeSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<LocalTime> {
        public LocalTimeSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

