/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.streampark.common.util.AssertUtils;
import org.apache.streampark.common.util.YamlParserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlinkGlobalConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkGlobalConfiguration.class);
    public static final String LEGACY_FLINK_CONF_FILENAME = "flink-conf.yaml";
    public static final String FLINK_CONF_FILENAME = "config.yaml";
    private static final String KEY_SEPARATOR = ".";
    private static final String[] SENSITIVE_KEYS = new String[]{"password", "secret", "fs.azure.account.key", "apikey", "auth-params", "service-key", "token", "basic-auth", "jaas.config", "http-headers"};
    public static final String HIDDEN_CONTENT = "******";
    private static boolean standardYaml = true;

    private FlinkGlobalConfiguration() {
    }

    public static Configuration loadConfiguration() {
        return FlinkGlobalConfiguration.loadConfiguration(new Configuration());
    }

    public static Configuration loadConfiguration(Configuration dynamicProperties) {
        String configDir = System.getenv("FLINK_CONF_DIR");
        if (configDir == null) {
            return new Configuration(dynamicProperties);
        }
        return FlinkGlobalConfiguration.loadConfiguration(configDir, dynamicProperties);
    }

    public static Configuration loadConfiguration(String configDir) {
        return FlinkGlobalConfiguration.loadConfiguration(configDir, null);
    }

    public static Configuration loadConfiguration(String configDir, @Nullable Configuration dynamicProperties) {
        Configuration configuration;
        if (configDir == null) {
            throw new IllegalArgumentException("Given configuration directory is null, cannot load configuration");
        }
        File confDirFile = new File(configDir);
        if (!confDirFile.exists()) {
            throw new IllegalConfigurationException("The given configuration directory name '" + configDir + "' (" + confDirFile.getAbsolutePath() + ") does not describe an existing directory.");
        }
        File yamlConfigFile = new File(confDirFile, LEGACY_FLINK_CONF_FILENAME);
        if (!yamlConfigFile.exists()) {
            yamlConfigFile = new File(confDirFile, FLINK_CONF_FILENAME);
            if (!yamlConfigFile.exists()) {
                throw new IllegalConfigurationException("The Flink config file '" + yamlConfigFile + "' (" + yamlConfigFile.getAbsolutePath() + ") does not exist.");
            }
            standardYaml = true;
            LOG.info("Using standard YAML parser to load flink configuration file from {}.", (Object)yamlConfigFile.getAbsolutePath());
            configuration = FlinkGlobalConfiguration.loadYAMLResource(yamlConfigFile);
        } else {
            standardYaml = false;
            LOG.info("Using legacy YAML parser to load flink configuration file from {}.", (Object)yamlConfigFile.getAbsolutePath());
            configuration = FlinkGlobalConfiguration.loadLegacyYAMLResource(yamlConfigFile);
        }
        FlinkGlobalConfiguration.logConfiguration("Loading", configuration);
        if (dynamicProperties != null) {
            FlinkGlobalConfiguration.logConfiguration("Loading dynamic", dynamicProperties);
            configuration.addAll(dynamicProperties);
        }
        return configuration;
    }

    private static void logConfiguration(String prefix, Configuration config) {
        config.confData.forEach((key, value) -> LOG.info("{} configuration property: {}, {}", new Object[]{prefix, key, FlinkGlobalConfiguration.isSensitive(key) ? HIDDEN_CONTENT : value}));
    }

    private static Configuration loadLegacyYAMLResource(File file) {
        Configuration config = new Configuration();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line;
            int lineNo = 0;
            while ((line = reader.readLine()) != null) {
                ++lineNo;
                String[] comments = line.split("#", 2);
                String conf = comments[0].trim();
                if (conf.length() <= 0) continue;
                String[] kv = conf.split(": ", 2);
                if (kv.length == 1) {
                    LOG.warn("Error while trying to split key and value in configuration file " + file + ":" + lineNo + ": Line is not a key-value pair (missing space after ':'?)");
                    continue;
                }
                String key = kv[0].trim();
                String value = kv[1].trim();
                if (key.length() == 0 || value.length() == 0) {
                    LOG.warn("Error after splitting key and value in configuration file " + file + ":" + lineNo + ": Key or value was empty");
                    continue;
                }
                config.setString(key, value);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error parsing YAML configuration.", e);
        }
        return config;
    }

    private static Map<String, Object> flatten(Map<String, Object> config, String keyPrefix) {
        HashMap<String, Object> flattenedMap = new HashMap<String, Object>();
        config.forEach((key, value) -> {
            String flattenedKey = keyPrefix + key;
            if (value instanceof Map) {
                Map e = (Map)value;
                flattenedMap.putAll(FlinkGlobalConfiguration.flatten(e, flattenedKey + KEY_SEPARATOR));
            } else if (value instanceof List) {
                flattenedMap.put(flattenedKey, YamlParserUtils.toYAMLString((Object)value));
            } else {
                flattenedMap.put(flattenedKey, value);
            }
        });
        return flattenedMap;
    }

    private static Map<String, Object> flatten(Map<String, Object> config) {
        return FlinkGlobalConfiguration.flatten(config, "");
    }

    private static Configuration loadYAMLResource(File file) {
        Configuration config = new Configuration();
        try {
            Map<String, Object> configDocument = FlinkGlobalConfiguration.flatten(YamlParserUtils.loadYamlFile((File)file));
            configDocument.forEach((k, v) -> config.setValueInternal(k, v, false));
            return config;
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing YAML configuration.", e);
        }
    }

    public static boolean isSensitive(String key) {
        AssertUtils.notNull((Object)key, (String)"key");
        String keyInLower = key.toLowerCase();
        for (String hideKey : SENSITIVE_KEYS) {
            if (keyInLower.length() < hideKey.length() || !keyInLower.contains(hideKey)) continue;
            return true;
        }
        return false;
    }

    public static String getFlinkConfFilename() {
        if (FlinkGlobalConfiguration.isStandardYaml()) {
            return FLINK_CONF_FILENAME;
        }
        return LEGACY_FLINK_CONF_FILENAME;
    }

    public static boolean isStandardYaml() {
        return standardYaml;
    }

    public static void setStandardYaml(boolean standardYaml) {
        FlinkGlobalConfiguration.standardYaml = standardYaml;
    }
}

