/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;

public class CompressionStatistics {
    public long estimatedSizeCoCoded;
    public long estimatedSizeCols;
    public long compressedInitialSize;
    public long originalSize;
    public long denseSize;
    public long size;
    private Map<String, int[]> colGroupCounts;

    protected void setColGroupsCounts(List<AColGroup> colGroups) {
        HashMap<String, int[]> ret = new HashMap<String, int[]>();
        for (AColGroup c : colGroups) {
            int[] values;
            String ct = c.getClass().getSimpleName();
            int colCount = c.getNumCols();
            if (ret.containsKey(ct)) {
                values = ret.get(ct);
                values[0] = values[0] + 1;
                values[1] = values[1] + colCount;
            } else {
                values = new int[]{1, colCount};
            }
            ret.put(ct, values);
        }
        this.colGroupCounts = ret;
    }

    public Map<String, int[]> getColGroups() {
        return this.colGroupCounts;
    }

    public String getGroupsTypesString() {
        StringBuilder sb = new StringBuilder();
        for (String ctKey : this.colGroupCounts.keySet()) {
            sb.append(ctKey + ":" + this.colGroupCounts.get(ctKey)[0] + " ");
        }
        return sb.toString();
    }

    public String getGroupsSizesString() {
        StringBuilder sb = new StringBuilder();
        for (String ctKey : this.colGroupCounts.keySet()) {
            sb.append(ctKey + ":" + this.colGroupCounts.get(ctKey)[1] + " ");
        }
        return sb.toString();
    }

    public double getRatio() {
        return (double)this.size == 0.0 ? Double.POSITIVE_INFINITY : (double)this.originalSize / (double)this.size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CompressionStatistics:\n");
        sb.append("Dense Size       : " + this.denseSize);
        sb.append("Original Size    : " + this.originalSize);
        sb.append("Compressed Size  : " + this.size);
        sb.append("CompressionRatio : " + this.getRatio());
        if (this.colGroupCounts != null) {
            sb.append("\t" + this.getGroupsTypesString() + "\n");
            sb.append("\t" + this.getGroupsSizesString() + "\n");
        }
        return sb.toString();
    }
}

