/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.meta;

import java.util.Arrays;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.util.UtilFunctions;

public class TensorCharacteristics
extends DataCharacteristics {
    private static final long serialVersionUID = 8300479822915546000L;
    public static final int[] DEFAULT_BLOCK_SIZE = new int[]{1024, 128, 32, 16, 8, 8};
    private long[] _dims;
    private long _nnz = -1L;

    public TensorCharacteristics() {
    }

    public TensorCharacteristics(long[] dims, long nnz) {
        this.set(dims, DEFAULT_BLOCK_SIZE[dims.length - 2], nnz);
    }

    public TensorCharacteristics(long[] dims, int blocksize) {
        this.set(dims, blocksize, -1L);
    }

    public TensorCharacteristics(long[] dims, int blocksize, long nnz) {
        this.set(dims, blocksize, nnz);
    }

    public TensorCharacteristics(DataCharacteristics that) {
        this.set(that);
    }

    @Override
    public DataCharacteristics set(long[] dims, int blocksize) {
        this.set(dims, blocksize, -1L);
        return this;
    }

    @Override
    public DataCharacteristics set(long[] dims, int blocksize, long nnz) {
        this._dims = dims;
        this._blocksize = blocksize;
        return this;
    }

    @Override
    public DataCharacteristics set(DataCharacteristics that) {
        long[] dims = (long[])that.getDims().clone();
        this.set(dims, that.getBlocksize(), that.getNonZeros());
        return this;
    }

    @Override
    public DataCharacteristics setNonZeros(long nnz) {
        this._nnz = nnz;
        return this;
    }

    @Override
    public boolean dimsKnown() {
        for (long dim : this._dims) {
            if (dim >= 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean dimsKnown(boolean includeNnz) {
        return this.dimsKnown() && (!includeNnz || this.nnzKnown());
    }

    @Override
    public boolean nnzKnown() {
        return this._nnz >= 0L;
    }

    @Override
    public int getNumDims() {
        return this._dims.length;
    }

    @Override
    public long getDim(int i) {
        return this._dims[i];
    }

    @Override
    public long[] getLongDims() {
        return this._dims;
    }

    @Override
    public int[] getIntDims() {
        return Arrays.stream(this.getLongDims()).mapToInt(i -> (int)i).toArray();
    }

    @Override
    public DataCharacteristics setDim(int i, long dim) {
        this._dims[i] = dim;
        return this;
    }

    @Override
    public DataCharacteristics setDims(long[] dims) {
        this._dims = dims;
        return this;
    }

    @Override
    public long getLength() {
        return UtilFunctions.prod(this._dims);
    }

    @Override
    public long getNumBlocks() {
        long ret = 1L;
        for (int i = 0; i < this.getNumDims(); ++i) {
            ret *= this.getNumBlocks(i);
        }
        return ret;
    }

    @Override
    public long getNumBlocks(int i) {
        return Math.max((long)Math.ceil((double)this.getDim(i) / (double)this.getBlocksize()), 1L);
    }

    @Override
    public long getNonZeros() {
        return this._nnz;
    }

    public String toString() {
        return "[" + Arrays.toString(this._dims) + ", nnz=" + this._nnz + ", blocksize= " + this._blocksize + "]";
    }

    @Override
    public boolean equalDims(Object anObject) {
        if (!(anObject instanceof TensorCharacteristics)) {
            return false;
        }
        TensorCharacteristics tc = (TensorCharacteristics)anObject;
        return this.dimsKnown() && tc.dimsKnown() && Arrays.equals(this._dims, tc._dims);
    }

    @Override
    public boolean equals(Object anObject) {
        if (!(anObject instanceof TensorCharacteristics)) {
            return false;
        }
        TensorCharacteristics tc = (TensorCharacteristics)anObject;
        return Arrays.equals(this._dims, tc._dims) && this._blocksize == tc._blocksize && this._nnz == tc._nnz;
    }

    @Override
    public int hashCode() {
        return UtilFunctions.intHashCode(UtilFunctions.intHashCode(Arrays.hashCode(this._dims), this._blocksize), Long.hashCode(this._nnz));
    }
}

