/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.client.http;

import org.spark_project.jetty.client.HttpChannel;
import org.spark_project.jetty.client.HttpExchange;
import org.spark_project.jetty.client.HttpReceiver;
import org.spark_project.jetty.client.HttpSender;
import org.spark_project.jetty.client.api.Response;
import org.spark_project.jetty.client.api.Result;
import org.spark_project.jetty.client.http.HttpConnectionOverHTTP;
import org.spark_project.jetty.client.http.HttpReceiverOverHTTP;
import org.spark_project.jetty.client.http.HttpSenderOverHTTP;
import org.spark_project.jetty.http.HttpFields;
import org.spark_project.jetty.http.HttpHeader;
import org.spark_project.jetty.http.HttpHeaderValue;
import org.spark_project.jetty.http.HttpVersion;

public class HttpChannelOverHTTP
extends HttpChannel {
    private final HttpConnectionOverHTTP connection;
    private final HttpSenderOverHTTP sender;
    private final HttpReceiverOverHTTP receiver;

    public HttpChannelOverHTTP(HttpConnectionOverHTTP connection) {
        super(connection.getHttpDestination());
        this.connection = connection;
        this.sender = this.newHttpSender();
        this.receiver = this.newHttpReceiver();
    }

    protected HttpSenderOverHTTP newHttpSender() {
        return new HttpSenderOverHTTP(this);
    }

    protected HttpReceiverOverHTTP newHttpReceiver() {
        return new HttpReceiverOverHTTP(this);
    }

    @Override
    protected HttpSender getHttpSender() {
        return this.sender;
    }

    @Override
    protected HttpReceiver getHttpReceiver() {
        return this.receiver;
    }

    public HttpConnectionOverHTTP getHttpConnection() {
        return this.connection;
    }

    @Override
    public void send() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            this.sender.send(exchange);
        }
    }

    @Override
    public void release() {
        this.connection.release();
    }

    public void receive() {
        this.receiver.receive();
    }

    @Override
    public void exchangeTerminated(HttpExchange exchange, Result result2) {
        boolean close2;
        super.exchangeTerminated(exchange, result2);
        Response response = result2.getResponse();
        HttpFields responseHeaders = response.getHeaders();
        boolean bl = close2 = result2.isFailed() || this.receiver.isShutdown();
        if (!close2) {
            close2 = response.getVersion().compareTo(HttpVersion.HTTP_1_1) < 0 ? !responseHeaders.contains(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE.asString()) : responseHeaders.contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString());
        }
        if (close2) {
            this.connection.close();
        } else {
            this.release();
        }
    }

    @Override
    public String toString() {
        return String.format("%s[send=%s,recv=%s]", super.toString(), this.sender, this.receiver);
    }
}

