/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.lineage;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysds.runtime.lineage.BooleanArray32;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.util.UtilFunctions;

public class LineageItem {
    private static IDSequence _idSeq = new IDSequence();
    private final long _id;
    private final String _opcode;
    private final String _data;
    private LineageItem[] _inputs;
    private int _hash = 0;
    private LineageItem _dedupPatch;
    private long _distLeaf2Node;
    private final BooleanArray32 _specialValueBits;
    private boolean _visited = true;
    public static final String dedupItemOpcode = "dedup";

    public LineageItem() {
        this("");
    }

    public LineageItem(String data) {
        this(_idSeq.getNextID(), data);
    }

    public LineageItem(long id, String data) {
        this(id, data, "", null, 0);
    }

    public LineageItem(String data, String opcode) {
        this(_idSeq.getNextID(), data, opcode, null, 0);
    }

    public LineageItem(String opcode, LineageItem[] inputs) {
        this(_idSeq.getNextID(), "", opcode, inputs, 0);
    }

    public LineageItem(String data, String opcode, LineageItem[] inputs) {
        this(_idSeq.getNextID(), data, opcode, inputs, 0);
    }

    public LineageItem(String opcode, LineageItem dedupPatch, LineageItem[] inputs) {
        this(_idSeq.getNextID(), "", opcode, inputs, 0);
        this._dedupPatch = dedupPatch;
        this._hash = this._dedupPatch._hash;
    }

    public LineageItem(String opcode, LineageItem dedupPatch, int dpatchHash, LineageItem[] inputs) {
        this(_idSeq.getNextID(), "", opcode, inputs, 0);
        this._dedupPatch = dedupPatch;
        this._hash = dpatchHash;
    }

    public LineageItem(LineageItem li) {
        this(_idSeq.getNextID(), li);
    }

    public LineageItem(long id, LineageItem li) {
        this(id, li._data, li._opcode, li._inputs, 0);
    }

    public LineageItem(long id, String data, String opcode) {
        this(id, data, opcode, null, 0);
    }

    public LineageItem(long id, String data, String opcode, LineageItem[] inputs, int specialValueBits) {
        this._id = id;
        this._opcode = opcode;
        this._data = data;
        this._inputs = inputs;
        this._hash = this.hashCode();
        this._distLeaf2Node = this.distLeaf2Node();
        this._specialValueBits = new BooleanArray32(specialValueBits);
    }

    public LineageItem[] getInputs() {
        return this._inputs;
    }

    public void resetInputs() {
        this._inputs = null;
    }

    public void setInput(int i, LineageItem item) {
        this._inputs[i] = item;
        this._hash = 0;
    }

    public String getData() {
        return this._data;
    }

    public void fixHash() {
        this._hash = 0;
        this._hash = this.hashCode();
    }

    public boolean isVisited() {
        return this._visited;
    }

    public void setVisited() {
        this.setVisited(true);
    }

    public void setVisited(boolean flag) {
        this._visited = flag;
    }

    public void setSpecialValueBit(int pos, boolean flag) {
        this._specialValueBits.set(pos, flag);
    }

    public void setSpecialValueBits(int value) {
        this._specialValueBits.setValue(value);
    }

    private long distLeaf2Node() {
        if (LineageCacheConfig.ReuseCacheType.isNone() || !LineageCacheConfig.isDagHeightBased()) {
            return -1L;
        }
        if (this._inputs != null && this._inputs.length > 0) {
            long maxDistance = this._inputs[0].getDistLeaf2Node();
            for (int i = 1; i < this._inputs.length; ++i) {
                if (this._inputs[i].getDistLeaf2Node() <= maxDistance) continue;
                maxDistance = this._inputs[i].getDistLeaf2Node();
            }
            return maxDistance + 1L;
        }
        return 1L;
    }

    public long getId() {
        return this._id;
    }

    public String getOpcode() {
        return this._opcode;
    }

    public boolean getSpecialValueBit(int pos) {
        return this._specialValueBits.get(pos);
    }

    public int getSpecialValueBits() {
        return this._specialValueBits.getValue();
    }

    public boolean isPlaceholder() {
        return this._opcode.startsWith("IN#");
    }

    public void setDistLeaf2Node(long d) {
        this._distLeaf2Node = d;
    }

    public long getDistLeaf2Node() {
        return this._distLeaf2Node;
    }

    public LineageItem getDedupPatch() {
        return this._dedupPatch;
    }

    public LineageItemType getType() {
        if (this._opcode.startsWith(dedupItemOpcode)) {
            return LineageItemType.Dedup;
        }
        if (this.isLeaf() && this.isInstruction()) {
            return LineageItemType.Creation;
        }
        if (this.isLeaf() && !this.isInstruction()) {
            return LineageItemType.Literal;
        }
        if (!this.isLeaf() && this.isInstruction()) {
            return LineageItemType.Instruction;
        }
        throw new DMLRuntimeException("An inner node could not be a literal!");
    }

    public String toString() {
        return LineageItemUtils.explainSingleLineageItem(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof LineageItem)) {
            return false;
        }
        this.resetVisitStatusNR();
        boolean ret = this.equalsLINR_dedup((LineageItem)o);
        this.resetVisitStatusNR();
        return ret;
    }

    private boolean equalsLI(LineageItem that) {
        if (this.isVisited() || this == that) {
            return true;
        }
        boolean ret = this._opcode.equals(that._opcode);
        ret &= this._data.equals(that._data);
        if ((ret &= this.hashCode() == that.hashCode()) && this._inputs != null && this._inputs.length == that._inputs.length) {
            for (int i = 0; i < this._inputs.length; ++i) {
                ret &= this._inputs[i].equalsLI(that._inputs[i]);
            }
        }
        this.setVisited();
        return ret;
    }

    private boolean equalsLINR(LineageItem that) {
        Stack<LineageItem> s1 = new Stack<LineageItem>();
        Stack<LineageItem> s2 = new Stack<LineageItem>();
        s1.push(this);
        s2.push(that);
        boolean ret = false;
        while (!s1.empty() && !s2.empty()) {
            LineageItem li1 = (LineageItem)s1.pop();
            LineageItem li2 = (LineageItem)s2.pop();
            if (li1.isVisited() || li1 == li2) {
                return true;
            }
            ret = li1._opcode.equals(li2._opcode);
            ret &= li1._data.equals(li2._data);
            if (!(ret &= li1.hashCode() == li2.hashCode())) break;
            if (ret && li1._inputs != null && li1._inputs.length == li2._inputs.length) {
                for (int i = 0; i < li1._inputs.length; ++i) {
                    s1.push(li1.getInputs()[i]);
                    s2.push(li2.getInputs()[i]);
                }
            }
            li1.setVisited();
        }
        return ret;
    }

    private boolean equalsLINR_dedup(LineageItem that) {
        Stack<LineageItem> s1 = new Stack<LineageItem>();
        Stack<LineageItem> s2 = new Stack<LineageItem>();
        s1.push(this);
        s2.push(that);
        boolean ret = true;
        while (!s1.empty() && !s2.empty()) {
            LineageItem li1 = (LineageItem)s1.pop();
            LineageItem li2 = (LineageItem)s2.pop();
            if (li1.isVisited() || li1 == li2) continue;
            if (!li1.isDedup() && !li2.isDedup()) {
                ret = li1._opcode.equals(li2._opcode);
                ret &= li1._data.equals(li2._data);
            }
            if (!(ret &= li1.hashCode() == li2.hashCode())) break;
            if (ret && li1._inputs != null && li1._inputs.length == li2._inputs.length || li1.isDedup() || li2.isDedup()) {
                for (int i = 0; i < li1._inputs.length; ++i) {
                    LineageItem in2;
                    LineageItem in1;
                    LineageItem lineageItem = li1._inputs[i].isPlaceholder() ? (li1._inputs[i]._inputs != null ? li1._inputs[i]._inputs[0] : li1._inputs[i]) : (in1 = li1._inputs[i]);
                    LineageItem lineageItem2 = li2._inputs[i].isPlaceholder() ? (li2._inputs[i]._inputs != null ? li2._inputs[i]._inputs[0] : li2._inputs[i]) : (in2 = li2._inputs[i]);
                    if (in1.isDedup() && !in2.isDedup()) {
                        HashMap<Integer, LineageItem> phMap = new HashMap<Integer, LineageItem>();
                        in1._dedupPatch.resetVisitStatusNR();
                        ret = LineageItem.equalsDedupPatch(in1._dedupPatch, in2, phMap);
                        in1.setVisited();
                        if (!ret) {
                            li1.setVisited();
                            return false;
                        }
                        for (Map.Entry ph : phMap.entrySet()) {
                            s1.push(in1._inputs[(Integer)ph.getKey()]);
                            s2.push((LineageItem)ph.getValue());
                        }
                        continue;
                    }
                    if (in2.isDedup() && !in1.isDedup()) {
                        HashMap<Integer, LineageItem> phMap = new HashMap<Integer, LineageItem>();
                        ret = LineageItem.equalsDedupPatch(in1, in2._dedupPatch, phMap);
                        if (!ret) {
                            li1.setVisited();
                            return false;
                        }
                        for (Map.Entry ph : phMap.entrySet()) {
                            s1.push((LineageItem)ph.getValue());
                            s1.push(in2._inputs[(Integer)ph.getKey()]);
                        }
                        continue;
                    }
                    if (in1.isDedup() && in2.isDedup()) {
                        in1._dedupPatch.resetVisitStatusNR();
                        in2._dedupPatch.resetVisitStatusNR();
                        ret = in1._dedupPatch.equalsLINR(in2._dedupPatch);
                        in1.setVisited();
                        if (!ret) {
                            li1.setVisited();
                            return false;
                        }
                        if (in1._inputs.length == in2._inputs.length) {
                            for (int j = 0; j < in1._inputs.length; ++j) {
                                s1.push(in1.getInputs()[j]);
                                s2.push(in2.getInputs()[j]);
                            }
                            continue;
                        }
                        li1.setVisited();
                        return false;
                    }
                    s1.push(in1);
                    s2.push(in2);
                }
            }
            li1.setVisited();
        }
        return ret;
    }

    private static boolean equalsDedupPatch(LineageItem dli1, LineageItem dli2, Map<Integer, LineageItem> phMap) {
        Stack<LineageItem> s1 = new Stack<LineageItem>();
        Stack<LineageItem> s2 = new Stack<LineageItem>();
        s1.push(dli1);
        s2.push(dli2);
        boolean ret = true;
        while (!s1.empty() && !s2.empty()) {
            LineageItem li1 = (LineageItem)s1.pop();
            LineageItem li2 = (LineageItem)s2.pop();
            if (li1.isVisited() || li1 == li2) continue;
            ret = li1._opcode.equals(li2._opcode);
            if (!(ret &= li1._data.equals(li2._data))) break;
            if (ret && li1._inputs != null && li1._inputs.length == li2._inputs.length) {
                for (int i = 0; i < li1._inputs.length; ++i) {
                    int phId;
                    LineageItem in1 = li1.getInputs()[i];
                    LineageItem in2 = li2.getInputs()[i];
                    LineageItem lineageItem = in1.isPlaceholder() ? (in1._inputs != null ? in1.getInputs()[0] : in1) : (in1 = in1);
                    LineageItem lineageItem2 = in2.isPlaceholder() ? (in2._inputs != null ? in2.getInputs()[0] : in2) : (in2 = in2);
                    if (in1.isPlaceholder() && in1._inputs == null && !in2.isPlaceholder()) {
                        phId = Integer.parseInt(in1.getOpcode().substring(3));
                        phMap.put(phId, in2);
                        continue;
                    }
                    if (in2.isPlaceholder() && in2._inputs == null && !in1.isPlaceholder()) {
                        phId = Integer.parseInt(in2.getOpcode().substring(3));
                        phMap.put(phId, in1);
                        continue;
                    }
                    if (in1.isPlaceholder() && in2.isPlaceholder()) continue;
                    s1.push(in1);
                    s2.push(in2);
                }
            }
            li1.setVisited();
        }
        return ret;
    }

    public int hashCode() {
        if (this._hash == 0) {
            if (this.isPlaceholder() && this._inputs != null) {
                return this._inputs[0].hashCode();
            }
            int h = UtilFunctions.intHashCode(this._opcode.hashCode(), this._data.hashCode());
            if (this._inputs != null) {
                for (LineageItem li : this._inputs) {
                    h = UtilFunctions.intHashCodeRobust(li.hashCode(), h);
                }
            }
            this._hash = h;
        }
        return this._hash;
    }

    public LineageItem deepCopy() {
        if (this.isLeaf()) {
            return new LineageItem(this);
        }
        LineageItem[] copyInputs = new LineageItem[this.getInputs().length];
        for (int i = 0; i < this._inputs.length; ++i) {
            copyInputs[i] = this._inputs[i].deepCopy();
        }
        return new LineageItem(this._opcode, copyInputs);
    }

    public boolean isLeaf() {
        return this._inputs == null || this._inputs.length == 0;
    }

    public boolean isInstruction() {
        return !this._opcode.isEmpty();
    }

    public boolean isDedup() {
        return this._opcode.startsWith(dedupItemOpcode);
    }

    public void resetVisitStatusNR() {
        Stack<LineageItem> q = new Stack<LineageItem>();
        q.push(this);
        while (!q.empty()) {
            LineageItem tmp = (LineageItem)q.pop();
            if (!tmp.isVisited()) continue;
            if (tmp.getInputs() != null) {
                for (LineageItem li : tmp.getInputs()) {
                    q.push(li);
                }
            }
            tmp.setVisited(false);
        }
    }

    public static void resetVisitStatusNR(LineageItem[] lis) {
        if (lis != null) {
            for (LineageItem liRoot : lis) {
                liRoot.resetVisitStatusNR();
            }
        }
    }

    @Deprecated
    public void resetVisitStatus() {
        if (!this.isVisited()) {
            return;
        }
        if (this._inputs != null) {
            for (LineageItem li : this.getInputs()) {
                li.resetVisitStatus();
            }
        }
        this.setVisited(false);
    }

    @Deprecated
    public static void resetVisitStatus(LineageItem[] lis) {
        if (lis != null) {
            for (LineageItem liRoot : lis) {
                liRoot.resetVisitStatus();
            }
        }
    }

    public static void resetIDSequence() {
        _idSeq.reset(-1L);
    }

    public static enum LineageItemType {
        Literal,
        Creation,
        Instruction,
        Dedup;

    }
}

