/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.io.FrameWriter;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.util.HDFSTool;

public class FrameWriterBinaryBlock
extends FrameWriter {
    @Override
    public final void writeFrameToHDFS(FrameBlock src, String fname, long rlen, long clen) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        HDFSTool.deleteFileIfExistOnHDFS(fname);
        if ((long)src.getNumRows() > rlen || (long)src.getNumColumns() > clen) {
            throw new IOException("Frame block [1:" + src.getNumRows() + ",1:" + src.getNumColumns() + "] out of overall frame range [1:" + rlen + ",1:" + clen + "].");
        }
        this.writeBinaryBlockFrameToHDFS(path, job, src, rlen, clen);
    }

    protected void writeBinaryBlockFrameToHDFS(Path path, JobConf job, FrameBlock src, long rlen, long clen) throws IOException, DMLRuntimeException {
        FileSystem fs = IOUtilFunctions.getFileSystem(path);
        int blen = ConfigurationManager.getBlocksize();
        FrameWriterBinaryBlock.writeBinaryBlockFrameToSequenceFile(path, job, fs, src, blen, 0, (int)rlen);
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeBinaryBlockFrameToSequenceFile(Path path, JobConf job, FileSystem fs, FrameBlock src, int blen, int rl, int ru) throws IOException {
        SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)job, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)path), SequenceFile.Writer.bufferSize((int)4096), SequenceFile.Writer.blockSize((long)4096L), SequenceFile.Writer.keyClass(LongWritable.class), SequenceFile.Writer.valueClass(FrameBlock.class), SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.NONE), SequenceFile.Writer.replication((short)1)});
        int rlen = src.getNumRows();
        int clen = src.getNumColumns();
        try {
            LongWritable index = new LongWritable();
            if (rlen <= blen) {
                index.set(1L);
                writer.append((Writable)index, (Writable)src);
            } else {
                for (int bi = rl; bi < ru; bi += blen) {
                    int len = Math.min(blen, rlen - bi);
                    FrameBlock block = src.slice(bi, bi + len - 1, 0, clen - 1);
                    if (bi == 0) {
                        block.setColumnMetadata(src.getColumnMetadata());
                    }
                    index.set((long)(bi + 1));
                    writer.append((Writable)index, (Writable)block);
                }
            }
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)writer);
        }
    }
}

