/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.lib;

import java.util.ArrayList;
import java.util.List;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.matrix.data.LibMatrixAgg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixValue;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public class CLALibUnary {
    public static MatrixBlock unaryOperations(CompressedMatrixBlock m, UnaryOperator op, MatrixValue result) {
        boolean overlapping = m.isOverlapping();
        int r = m.getNumRows();
        int c = m.getNumColumns();
        if (m.isEmpty()) {
            return new MatrixBlock(r, c, 0L).unaryOperations(op, result);
        }
        if (overlapping) {
            if (Builtin.isBuiltinCode(op.fn, Builtin.BuiltinCode.ISINF, Builtin.BuiltinCode.ISNA, Builtin.BuiltinCode.ISNAN)) {
                return new MatrixBlock(r, c, 0L);
            }
            if (op.fn instanceof Builtin) {
                return m.getUncompressed("Unary Op not supported Overlapping builtin: " + ((Builtin)op.fn).getBuiltinCode(), op.getNumThreads()).unaryOperations(op, null);
            }
            return m.getUncompressed("Unary Op not supported Overlapping: " + op.fn.getClass().getSimpleName(), op.getNumThreads()).unaryOperations(op, null);
        }
        if (Builtin.isBuiltinCode(op.fn, Builtin.BuiltinCode.ISINF, Builtin.BuiltinCode.ISNAN, Builtin.BuiltinCode.ISNA) && !m.containsValue(op.getPattern())) {
            return new MatrixBlock(r, c, 0L);
        }
        if (LibMatrixAgg.isSupportedUnaryOperator(op)) {
            return m.getUncompressed("Unary Op not supported: " + op.fn.getClass().getSimpleName(), op.getNumThreads()).unaryOperations(op, null);
        }
        List<AColGroup> groups = m.getColGroups();
        ArrayList<AColGroup> retG = new ArrayList<AColGroup>(groups.size());
        for (AColGroup g : groups) {
            retG.add(g.unaryOperation(op));
        }
        CompressedMatrixBlock ret = new CompressedMatrixBlock(m.getNumRows(), m.getNumColumns());
        ret.allocateColGroupList(retG);
        ret.recomputeNonZeros();
        return ret;
    }
}

