/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import java.io.IOException;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.TrackableComponentEventCallback;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.http.Link;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.compatibility.DeprecationWarning;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@SupportsInformalParameters
public class ProgressiveDisplay {
    @Parameter(defaultPrefix="literal", value="block:defaultInitial")
    private Block initial;
    @Parameter
    private Object[] context;
    @Inject
    private ComponentResources resources;
    @Environmental
    private JavaScriptSupport jsSupport;
    @Environmental
    private TrackableComponentEventCallback eventCallback;
    @Inject
    private DeprecationWarning deprecationWarning;
    @Parameter(defaultPrefix="literal")
    private String update;

    void pageLoaded() {
        this.deprecationWarning.ignoredComponentParameters(this.resources, "update");
    }

    Block beginRender(MarkupWriter writer) {
        String clientId = this.jsSupport.allocateClientId(this.resources);
        String elementName = this.resources.getElementName("div");
        writer.element(elementName, "id", clientId, "data-container-type", "zone");
        this.resources.renderInformalParameters(writer);
        Link link = this.resources.createEventLink("action", this.context);
        this.jsSupport.require("t5/core/zone").invoke("deferredZoneUpdate").with(clientId, link.toURI());
        return this.initial;
    }

    Object onAction(EventContext context) throws IOException {
        this.resources.triggerContextEvent("progressiveDisplay", context, this.eventCallback);
        if (this.eventCallback.isAborted()) {
            return null;
        }
        return this.getBody();
    }

    boolean beforeRenderBody() {
        return false;
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
    }

    public Block getBody() {
        return this.resources.getBody();
    }
}

