; The GIMP -- an image manipulation program

; Copyright (C) 1995 Spencer Kimball and Peter Mattis

; 

; www.gimp.org web big header

; Copyright (c) 1997 Jens Lautenbacher

; jens@www.gimp.org

;

;

; This program is free software; you can redistribute it and/or modify

; it under the terms of the GNU General Public License as published by

; the Free Software Foundation; either version 2 of the License, or

; (at your option) any later version.

; 

; This program is distributed in the hope that it will be useful,

; but WITHOUT ANY WARRANTY; without even the implied warranty of

; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

; GNU General Public License for more details.

; 

; You should have received a copy of the GNU General Public License

; along with this program; if not, write to the Free Software

; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.



(define (net-fu-old-stone text font font-size fg-color bg-color age)

  (let* ((img (car (gimp-image-new 256 256 RGB)))

         (foundry "*")
         (weight "*")
         (slant "*")
         (width "*")

	 (text-layer (car (gimp-text img -1 0 0

				     text 20 TRUE font-size PIXELS

				     foundry font weight slant width "*")))

	 (width (car (gimp-drawable-width text-layer)))

	 (height (car (gimp-drawable-height text-layer)))

	 (bg-layer (car (gimp-layer-new img width

					height RGB_IMAGE

					"Background" 100 NORMAL)))

	 (fg-layer (car (gimp-layer-new img width

					height RGB_IMAGE

					"fg" 100 NORMAL)))

	 (map-layer (car (gimp-layer-new img width

					height RGB_IMAGE

					"map" 100 NORMAL)))

	 (plasma-layer (car (gimp-layer-new img width

					height RGB_IMAGE

					"plasma" 100 NORMAL)))

    

	 (old-fg (car (gimp-palette-get-foreground)))

	 (old-bg (car (gimp-palette-get-background)))

	 mask)



    (gimp-image-disable-undo img)



    ;; prepare the layers

    (gimp-image-resize img width height 0 0)

    (gimp-image-add-layer img bg-layer 1)

    (gimp-palette-set-background bg-color)

    (gimp-edit-fill img bg-layer)

    

    (gimp-layer-set-preserve-trans text-layer TRUE)

    (gimp-palette-set-background '(0 0 0))

    (gimp-edit-fill img text-layer)

    (gimp-layer-set-preserve-trans text-layer FALSE)



    (gimp-image-add-layer img map-layer 1)

    (gimp-image-add-layer img plasma-layer 1)

    (gimp-image-add-layer img fg-layer 1)



    (gimp-layer-add-alpha map-layer)

    (gimp-layer-add-alpha plasma-layer)

    (gimp-layer-add-alpha fg-layer)

    (gimp-image-lower-layer img text-layer)

    (gimp-layer-set-visible plasma-layer FALSE)

    (gimp-layer-set-visible map-layer FALSE)

    

    (gimp-palette-set-background '(255 255 255))

    (gimp-edit-fill img map-layer)



    (gimp-palette-set-background fg-color)

    (gimp-edit-fill img fg-layer)



    ;;start with plasma

    (plug-in-plasma 1 img plasma-layer 1 1.5)

    (gimp-desaturate img plasma-layer)

    (plug-in-c-astretch 1 img plasma-layer)



    ;; to generate the "stoney" texture...

    (plug-in-blur 1 img plasma-layer)

    (plug-in-oilify 1 img plasma-layer 4)

    ;; ..which is used to generate the final map

    (plug-in-bump-map 1 img map-layer plasma-layer 135 45 5 0 0 0 0

		      TRUE FALSE 2)



    ;; now preparing the text

    (plug-in-spread 1 img text-layer age age)

;;    (plug-in-gauss-iir 1 img text-layer 5 TRUE TRUE)

    (plug-in-oilify 1 img text-layer age)

    (plug-in-gauss-iir 1 img text-layer (/ font-size 17.) TRUE TRUE)



    (plug-in-bump-map 1 img fg-layer text-layer 135 45 5 0 0 255 0

		     TRUE TRUE 0)



    (set! mask (car (gimp-layer-create-mask fg-layer 0)))

    (gimp-image-add-layer-mask img fg-layer mask)

    (gimp-edit-copy img text-layer)

    (gimp-floating-sel-anchor (car (gimp-edit-paste img mask TRUE)))

    (gimp-invert img mask)

    (gimp-levels img mask 0 0 100 0.35 0 255)



    (gimp-channel-ops-offset img text-layer TRUE 1 5 5)

    (gimp-layer-set-opacity text-layer 50)



    (plug-in-bump-map 1 img fg-layer map-layer  135 45 age 0 0 0 0 TRUE FALSE 2)





;    (if (or (= rm-bg TRUE) (= crop TRUE) (= index TRUE))

;	(begin

;	  (set! text-layer (car (gimp-image-flatten img)))

;	  (gimp-layer-add-alpha text-layer)))	   

	  



;   (if (= rm-bg TRUE)

;	(begin   

;	  (gimp-by-color-select img text-layer bg-color

;				1 REPLACE TRUE FALSE 0 FALSE)

;	  (gimp-edit-clear img text-layer)

;	  (gimp-selection-clear img)))

        

;    (if (= crop TRUE)

;	 (plug-in-autocrop 1 img text-layer))



;    (if (= index TRUE)

;	(gimp-convert-indexed img TRUE num-colors))


    (set! final-layer (car (gimp-image-flatten img)))
    (gimp-levels img final-layer 0 0 255 1.6 0 255)
    (set! filename (car (gimp-temp-name "jpg")))
    (file-jpeg-save 1 img final-layer filename filename 0.7 0 TRUE)

    (gimp-palette-set-foreground old-fg)
    (gimp-palette-set-background old-bg)
    (gimp-image-enable-undo img)

;    (gimp-display-new img)
;    ))

    filename))





(script-fu-register "script-fu-old-stone"

		    "<Toolbox>/Xtns/Script-Fu/Logos/Old Stone"

		    "A text logo"

		    "Jens Lautenbacher"

		    "Jens Lautenbacher"

		    "1997"

		    ""

		    SF-VALUE "Text String" "\"The Gimp\""

;		    SF-VALUE "Foundry" "\"adobe\""

		    SF-VALUE "Family"  "\"utopia\""

;		    SF-VALUE "Weight"  "\"bold\""

;		    SF-VALUE "Slant"   "\"r\""

;		    SF-VALUE "Width"   "\"normal\""

		    SF-VALUE "Size"    "85"

		    SF-COLOR "Text Color"  '(82 121 158)

		    SF-COLOR "Background Color" '(255 255 255)

		    SF-VALUE "Age (in whole Centuries)" "5"

;		    SF-TOGGLE "AutoCrop?" FALSE

;		    SF-TOGGLE "Remove Background?" FALSE

;		    SF-TOGGLE "Index image?" FALSE

;		    SF-VALUE "# of colors" "31"

		    )

