/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl. */

#include "config.h"


#include <glib-object.h>

#include "pdb-types.h"
#include "gimppdb.h"
#include "gimpprocedure.h"
#include "core/gimpparamspecs.h"

#include "config/gimpcoreconfig.h"
#include "core/gimp.h"
#include "core/gimpdrawable.h"
#include "core/gimpimage-undo.h"
#include "core/gimpimage.h"
#include "core/gimpitem-linked.h"
#include "core/gimplayer.h"
#include "core/gimplayermask.h"
#include "gimp-intl.h"


static GValueArray *
layer_new_invoker (GimpProcedure     *procedure,
                   Gimp              *gimp,
                   GimpContext       *context,
                   GimpProgress      *progress,
                   const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpImage *image;
  gint32 width;
  gint32 height;
  gint32 type;
  const gchar *name;
  gdouble opacity;
  gint32 mode;
  GimpLayer *layer = NULL;

  image = gimp_value_get_image (&args->values[0], gimp);
  width = g_value_get_int (&args->values[1]);
  height = g_value_get_int (&args->values[2]);
  type = g_value_get_enum (&args->values[3]);
  name = g_value_get_string (&args->values[4]);
  opacity = g_value_get_double (&args->values[5]);
  mode = g_value_get_enum (&args->values[6]);

  if (success)
    {
      layer = gimp_layer_new (image, width, height, type, name,
                              opacity / 100.0, mode);

      if (! layer)
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    gimp_value_set_layer (&return_vals->values[1], layer);

  return return_vals;
}

static GValueArray *
layer_new_from_drawable_invoker (GimpProcedure     *procedure,
                                 Gimp              *gimp,
                                 GimpContext       *context,
                                 GimpProgress      *progress,
                                 const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpDrawable *drawable;
  GimpImage *dest_image;
  GimpLayer *layer_copy = NULL;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  dest_image = gimp_value_get_image (&args->values[1], gimp);

  if (success)
    {
      GType     new_type;
      GimpItem *new_item;

      if (GIMP_IS_LAYER (drawable))
        new_type = G_TYPE_FROM_INSTANCE (drawable);
      else
        new_type = GIMP_TYPE_LAYER;

      if (dest_image == gimp_item_get_image (GIMP_ITEM (drawable)))
        new_item = gimp_item_duplicate (GIMP_ITEM (drawable), new_type, TRUE);
      else
        new_item = gimp_item_convert (GIMP_ITEM (drawable), dest_image, new_type, TRUE);

      if (new_item)
        layer_copy = GIMP_LAYER (new_item);
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    gimp_value_set_layer (&return_vals->values[1], layer_copy);

  return return_vals;
}

static GValueArray *
layer_copy_invoker (GimpProcedure     *procedure,
                    Gimp              *gimp,
                    GimpContext       *context,
                    GimpProgress      *progress,
                    const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpLayer *layer;
  gboolean add_alpha;
  GimpLayer *layer_copy = NULL;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  add_alpha = g_value_get_boolean (&args->values[1]);

  if (success)
    {
      layer_copy = GIMP_LAYER (gimp_item_duplicate (GIMP_ITEM (layer),
                                                    G_TYPE_FROM_INSTANCE (layer),
                                                    add_alpha));
      if (! layer_copy)
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    gimp_value_set_layer (&return_vals->values[1], layer_copy);

  return return_vals;
}

static GValueArray *
layer_add_alpha_invoker (GimpProcedure     *procedure,
                         Gimp              *gimp,
                         GimpContext       *context,
                         GimpProgress      *progress,
                         const GValueArray *args)
{
  gboolean success = TRUE;
  GimpLayer *layer;

  layer = gimp_value_get_layer (&args->values[0], gimp);

  if (success)
    {
      gimp_layer_add_alpha (layer);
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
layer_scale_invoker (GimpProcedure     *procedure,
                     Gimp              *gimp,
                     GimpContext       *context,
                     GimpProgress      *progress,
                     const GValueArray *args)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gint32 new_width;
  gint32 new_height;
  gboolean local_origin;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  new_width = g_value_get_int (&args->values[1]);
  new_height = g_value_get_int (&args->values[2]);
  local_origin = g_value_get_boolean (&args->values[3]);

  if (success)
    {
      if (gimp_item_is_attached (GIMP_ITEM (layer)))
        gimp_item_scale_by_origin (GIMP_ITEM (layer), new_width, new_height,
                                   gimp->config->interpolation_type, NULL,
                                   local_origin);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
layer_resize_invoker (GimpProcedure     *procedure,
                      Gimp              *gimp,
                      GimpContext       *context,
                      GimpProgress      *progress,
                      const GValueArray *args)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gint32 new_width;
  gint32 new_height;
  gint32 offx;
  gint32 offy;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  new_width = g_value_get_int (&args->values[1]);
  new_height = g_value_get_int (&args->values[2]);
  offx = g_value_get_int (&args->values[3]);
  offy = g_value_get_int (&args->values[4]);

  if (success)
    {
      if (gimp_item_is_attached (GIMP_ITEM (layer)))
        gimp_item_resize (GIMP_ITEM (layer), context,
                          new_width, new_height, offx, offy);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
layer_resize_to_image_size_invoker (GimpProcedure     *procedure,
                                    Gimp              *gimp,
                                    GimpContext       *context,
                                    GimpProgress      *progress,
                                    const GValueArray *args)
{
  gboolean success = TRUE;
  GimpLayer *layer;

  layer = gimp_value_get_layer (&args->values[0], gimp);

  if (success)
    {
      if (gimp_item_is_attached (GIMP_ITEM (layer)))
        gimp_layer_resize_to_image (layer, context);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
layer_translate_invoker (GimpProcedure     *procedure,
                         Gimp              *gimp,
                         GimpContext       *context,
                         GimpProgress      *progress,
                         const GValueArray *args)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gint32 offx;
  gint32 offy;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  offx = g_value_get_int (&args->values[1]);
  offy = g_value_get_int (&args->values[2]);

  if (success)
    {
      GimpImage *image = gimp_item_get_image (GIMP_ITEM (layer));

      gimp_image_undo_group_start (image, GIMP_UNDO_GROUP_ITEM_DISPLACE,
                                   _("Move Layer"));

      gimp_item_translate (GIMP_ITEM (layer), offx, offy, TRUE);

      if (gimp_item_get_linked (GIMP_ITEM (layer)))
        gimp_item_linked_translate (GIMP_ITEM (layer), offx, offy, TRUE);

      gimp_image_undo_group_end (image);
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
layer_set_offsets_invoker (GimpProcedure     *procedure,
                           Gimp              *gimp,
                           GimpContext       *context,
                           GimpProgress      *progress,
                           const GValueArray *args)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gint32 offx;
  gint32 offy;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  offx = g_value_get_int (&args->values[1]);
  offy = g_value_get_int (&args->values[2]);

  if (success)
    {
      GimpImage *image = gimp_item_get_image (GIMP_ITEM (layer));

      gimp_image_undo_group_start (image, GIMP_UNDO_GROUP_ITEM_DISPLACE,
                                   _("Move Layer"));

      offx -= GIMP_ITEM (layer)->offset_x;
      offy -= GIMP_ITEM (layer)->offset_y;

      gimp_item_translate (GIMP_ITEM (layer), offx, offy, TRUE);

      if (gimp_item_get_linked (GIMP_ITEM (layer)))
        gimp_item_linked_translate (GIMP_ITEM (layer), offx, offy, TRUE);

      gimp_image_undo_group_end (image);
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
layer_create_mask_invoker (GimpProcedure     *procedure,
                           Gimp              *gimp,
                           GimpContext       *context,
                           GimpProgress      *progress,
                           const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpLayer *layer;
  gint32 mask_type;
  GimpLayerMask *mask = NULL;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  mask_type = g_value_get_enum (&args->values[1]);

  if (success)
    {
      GimpChannel *channel = NULL;

      if (mask_type == GIMP_ADD_CHANNEL_MASK)
        {
          channel = gimp_image_get_active_channel (GIMP_ITEM (layer)->image);

          if (! channel)
            success = FALSE;
        }

      if (success)
        {
          mask = gimp_layer_create_mask (layer, mask_type, channel);

          if (! mask)
            success = FALSE;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    gimp_value_set_layer_mask (&return_vals->values[1], mask);

  return return_vals;
}

static GValueArray *
layer_get_mask_invoker (GimpProcedure     *procedure,
                        Gimp              *gimp,
                        GimpContext       *context,
                        GimpProgress      *progress,
                        const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpLayer *layer;
  GimpLayerMask *mask = NULL;

  layer = gimp_value_get_layer (&args->values[0], gimp);

  if (success)
    {
      mask = gimp_layer_get_mask (layer);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    gimp_value_set_layer_mask (&return_vals->values[1], mask);

  return return_vals;
}

static GValueArray *
layer_from_mask_invoker (GimpProcedure     *procedure,
                         Gimp              *gimp,
                         GimpContext       *context,
                         GimpProgress      *progress,
                         const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpLayerMask *mask;
  GimpLayer *layer = NULL;

  mask = gimp_value_get_layer_mask (&args->values[0], gimp);

  if (success)
    {
      layer = gimp_layer_mask_get_layer (mask);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    gimp_value_set_layer (&return_vals->values[1], layer);

  return return_vals;
}

static GValueArray *
layer_add_mask_invoker (GimpProcedure     *procedure,
                        Gimp              *gimp,
                        GimpContext       *context,
                        GimpProgress      *progress,
                        const GValueArray *args)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  GimpLayerMask *mask;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  mask = gimp_value_get_layer_mask (&args->values[1], gimp);

  if (success)
    {
      if (gimp_item_is_attached (GIMP_ITEM (layer)))
        gimp_layer_add_mask (layer, mask, TRUE);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
layer_remove_mask_invoker (GimpProcedure     *procedure,
                           Gimp              *gimp,
                           GimpContext       *context,
                           GimpProgress      *progress,
                           const GValueArray *args)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gint32 mode;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  mode = g_value_get_enum (&args->values[1]);

  if (success)
    {
      if (gimp_item_is_attached (GIMP_ITEM (layer)))
        gimp_layer_apply_mask (layer, mode, TRUE);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
layer_is_floating_sel_invoker (GimpProcedure     *procedure,
                               Gimp              *gimp,
                               GimpContext       *context,
                               GimpProgress      *progress,
                               const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpLayer *layer;
  gboolean is_floating_sel = FALSE;

  layer = gimp_value_get_layer (&args->values[0], gimp);

  if (success)
    {
      is_floating_sel = gimp_layer_is_floating_sel (layer);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_set_boolean (&return_vals->values[1], is_floating_sel);

  return return_vals;
}

static GValueArray *
layer_get_lock_alpha_invoker (GimpProcedure     *procedure,
                              Gimp              *gimp,
                              GimpContext       *context,
                              GimpProgress      *progress,
                              const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpLayer *layer;
  gboolean lock_alpha = FALSE;

  layer = gimp_value_get_layer (&args->values[0], gimp);

  if (success)
    {
      lock_alpha = gimp_layer_get_lock_alpha (layer);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_set_boolean (&return_vals->values[1], lock_alpha);

  return return_vals;
}

static GValueArray *
layer_set_lock_alpha_invoker (GimpProcedure     *procedure,
                              Gimp              *gimp,
                              GimpContext       *context,
                              GimpProgress      *progress,
                              const GValueArray *args)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gboolean lock_alpha;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  lock_alpha = g_value_get_boolean (&args->values[1]);

  if (success)
    {
      gimp_layer_set_lock_alpha (layer, lock_alpha, TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
layer_get_apply_mask_invoker (GimpProcedure     *procedure,
                              Gimp              *gimp,
                              GimpContext       *context,
                              GimpProgress      *progress,
                              const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpLayer *layer;
  gboolean apply_mask = FALSE;

  layer = gimp_value_get_layer (&args->values[0], gimp);

  if (success)
    {
      if (layer->mask)
        apply_mask = gimp_layer_mask_get_apply (layer->mask);
      else
        apply_mask = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_set_boolean (&return_vals->values[1], apply_mask);

  return return_vals;
}

static GValueArray *
layer_set_apply_mask_invoker (GimpProcedure     *procedure,
                              Gimp              *gimp,
                              GimpContext       *context,
                              GimpProgress      *progress,
                              const GValueArray *args)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gboolean apply_mask;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  apply_mask = g_value_get_boolean (&args->values[1]);

  if (success)
    {
      if (layer->mask)
        gimp_layer_mask_set_apply (layer->mask, apply_mask, TRUE);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
layer_get_show_mask_invoker (GimpProcedure     *procedure,
                             Gimp              *gimp,
                             GimpContext       *context,
                             GimpProgress      *progress,
                             const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpLayer *layer;
  gboolean show_mask = FALSE;

  layer = gimp_value_get_layer (&args->values[0], gimp);

  if (success)
    {
      if (layer->mask)
        show_mask = gimp_layer_mask_get_show (layer->mask);
      else
        show_mask = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_set_boolean (&return_vals->values[1], show_mask);

  return return_vals;
}

static GValueArray *
layer_set_show_mask_invoker (GimpProcedure     *procedure,
                             Gimp              *gimp,
                             GimpContext       *context,
                             GimpProgress      *progress,
                             const GValueArray *args)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gboolean show_mask;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  show_mask = g_value_get_boolean (&args->values[1]);

  if (success)
    {
      if (layer->mask)
        gimp_layer_mask_set_show (layer->mask, show_mask, TRUE);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
layer_get_edit_mask_invoker (GimpProcedure     *procedure,
                             Gimp              *gimp,
                             GimpContext       *context,
                             GimpProgress      *progress,
                             const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpLayer *layer;
  gboolean edit_mask = FALSE;

  layer = gimp_value_get_layer (&args->values[0], gimp);

  if (success)
    {
      if (layer->mask)
        edit_mask = gimp_layer_mask_get_edit (layer->mask);
      else
        edit_mask = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_set_boolean (&return_vals->values[1], edit_mask);

  return return_vals;
}

static GValueArray *
layer_set_edit_mask_invoker (GimpProcedure     *procedure,
                             Gimp              *gimp,
                             GimpContext       *context,
                             GimpProgress      *progress,
                             const GValueArray *args)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gboolean edit_mask;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  edit_mask = g_value_get_boolean (&args->values[1]);

  if (success)
    {
      if (layer->mask)
        gimp_layer_mask_set_edit (layer->mask, edit_mask);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
layer_get_opacity_invoker (GimpProcedure     *procedure,
                           Gimp              *gimp,
                           GimpContext       *context,
                           GimpProgress      *progress,
                           const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpLayer *layer;
  gdouble opacity = 0.0;

  layer = gimp_value_get_layer (&args->values[0], gimp);

  if (success)
    {
      opacity = gimp_layer_get_opacity (layer) * 100.0;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_set_double (&return_vals->values[1], opacity);

  return return_vals;
}

static GValueArray *
layer_set_opacity_invoker (GimpProcedure     *procedure,
                           Gimp              *gimp,
                           GimpContext       *context,
                           GimpProgress      *progress,
                           const GValueArray *args)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gdouble opacity;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  opacity = g_value_get_double (&args->values[1]);

  if (success)
    {
      gimp_layer_set_opacity (layer, opacity / 100.0, TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
layer_get_mode_invoker (GimpProcedure     *procedure,
                        Gimp              *gimp,
                        GimpContext       *context,
                        GimpProgress      *progress,
                        const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpLayer *layer;
  gint32 mode = 0;

  layer = gimp_value_get_layer (&args->values[0], gimp);

  if (success)
    {
      mode = gimp_layer_get_mode (layer);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_set_enum (&return_vals->values[1], mode);

  return return_vals;
}

static GValueArray *
layer_set_mode_invoker (GimpProcedure     *procedure,
                        Gimp              *gimp,
                        GimpContext       *context,
                        GimpProgress      *progress,
                        const GValueArray *args)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gint32 mode;

  layer = gimp_value_get_layer (&args->values[0], gimp);
  mode = g_value_get_enum (&args->values[1]);

  if (success)
    {
      gimp_layer_set_mode (layer, mode, TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success);
}

void
register_layer_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-layer-new
   */
  procedure = gimp_procedure_new (layer_new_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-layer-new");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-layer-new",
                                     "Create a new layer.",
                                     "This procedure creates a new layer with the specified width, height, and type. Name, opacity, and mode are also supplied parameters. The new layer still needs to be added to the image, as this is not automatic. Add the new layer with the 'gimp_image_add_layer' command. Other attributes such as layer mask modes, and offsets should be set with explicit procedure calls.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image to which to add the layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("width",
                                                      "width",
                                                      "The layer width",
                                                      1, G_MAXINT32, 1,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("height",
                                                      "height",
                                                      "The layer height",
                                                      1, G_MAXINT32, 1,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("type",
                                                  "type",
                                                  "The layer type",
                                                  GIMP_TYPE_IMAGE_TYPE,
                                                  GIMP_RGB_IMAGE,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The layer name",
                                                       FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("opacity",
                                                    "opacity",
                                                    "The layer opacity",
                                                    0, 100, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("mode",
                                                  "mode",
                                                  "The layer combination mode",
                                                  GIMP_TYPE_LAYER_MODE_EFFECTS,
                                                  GIMP_NORMAL_MODE,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_layer_id ("layer",
                                                             "layer",
                                                             "The newly created layer",
                                                             pdb->gimp, FALSE,
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-layer-new-from-drawable
   */
  procedure = gimp_procedure_new (layer_new_from_drawable_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-layer-new-from-drawable");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-layer-new-from-drawable",
                                     "Create a new layer by copying an existing drawable.",
                                     "This procedure creates a new layer as a copy of the specified drawable. The new layer still needs to be added to the image, as this is not automatic. Add the new layer with the 'gimp_image_add_layer' command. Other attributes such as layer mask modes, and offsets should be set with explicit procedure calls.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The source drawable from where the new layer is copied",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("dest-image",
                                                         "dest image",
                                                         "The destination image to which to add the layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_layer_id ("layer-copy",
                                                             "layer copy",
                                                             "The newly copied layer",
                                                             pdb->gimp, FALSE,
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-layer-copy
   */
  procedure = gimp_procedure_new (layer_copy_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-layer-copy");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-layer-copy",
                                     "Copy a layer.",
                                     "This procedure copies the specified layer and returns the copy. The newly copied layer is for use within the original layer's image. It should not be subsequently added to any other image. The copied layer can optionally have an added alpha channel. This is useful if the background layer in an image is being copied and added to the same image.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The layer to copy",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("add-alpha",
                                                     "add alpha",
                                                     "Add an alpha channel to the copied layer",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_layer_id ("layer-copy",
                                                             "layer copy",
                                                             "The newly copied layer",
                                                             pdb->gimp, FALSE,
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-layer-add-alpha
   */
  procedure = gimp_procedure_new (layer_add_alpha_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-layer-add-alpha");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-layer-add-alpha",
                                     "Add an alpha channel to the layer if it doesn't already have one.",
                                     "This procedure adds an additional component to the specified layer if it does not already possess an alpha channel. An alpha channel makes it possible to move a layer from the bottom of the layer stack and to clear and erase to transparency, instead of the background color. This transforms images of type RGB to RGBA, GRAY to GRAYA, and INDEXED to INDEXEDA.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-layer-scale
   */
  procedure = gimp_procedure_new (layer_scale_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-layer-scale");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-layer-scale",
                                     "Scale the layer to the specified extents.",
                                     "This procedure scales the layer so that its new width and height are equal to the supplied parameters. The \"local_origin\" parameter specifies whether to scale from the center of the layer, or from the image origin. This operation only works if the layer has been added to an image.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("new-width",
                                                      "new width",
                                                      "New layer width",
                                                      1, G_MAXINT32, 1,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("new-height",
                                                      "new height",
                                                      "New layer height",
                                                      1, G_MAXINT32, 1,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("local-origin",
                                                     "local origin",
                                                     "Use a local origin (as opposed to the image origin)",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-layer-resize
   */
  procedure = gimp_procedure_new (layer_resize_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-layer-resize");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-layer-resize",
                                     "Resize the layer to the specified extents.",
                                     "This procedure resizes the layer so that its new width and height are equal to the supplied parameters. Offsets are also provided which describe the position of the previous layer's content. This operation only works if the layer has been added to an image.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("new-width",
                                                      "new width",
                                                      "New layer width",
                                                      1, G_MAXINT32, 1,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("new-height",
                                                      "new height",
                                                      "New layer height",
                                                      1, G_MAXINT32, 1,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("offx",
                                                      "offx",
                                                      "x offset between upper left corner of old and new layers: (old - new)",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("offy",
                                                      "offy",
                                                      "y offset between upper left corner of old and new layers: (old - new)",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-layer-resize-to-image-size
   */
  procedure = gimp_procedure_new (layer_resize_to_image_size_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-layer-resize-to-image-size");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-layer-resize-to-image-size",
                                     "Resize a layer to the image size.",
                                     "This procedure resizes the layer so that it's new width and height are equal to the width and height of its image container.",
                                     "Manish Singh",
                                     "Manish Singh",
                                     "2003",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The layer to resize",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-layer-translate
   */
  procedure = gimp_procedure_new (layer_translate_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-layer-translate");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-layer-translate",
                                     "Translate the layer by the specified offsets.",
                                     "This procedure translates the layer by the amounts specified in the x and y arguments. These can be negative, and are considered offsets from the current position. This command only works if the layer has been added to an image. All additional layers contained in the image which have the linked flag set to TRUE w ill also be translated by the specified offsets.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("offx",
                                                      "offx",
                                                      "Offset in x direction",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("offy",
                                                      "offy",
                                                      "Offset in y direction",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-layer-set-offsets
   */
  procedure = gimp_procedure_new (layer_set_offsets_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-layer-set-offsets");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-layer-set-offsets",
                                     "Set the layer offsets.",
                                     "This procedure sets the offsets for the specified layer. The offsets are relative to the image origin and can be any values. This operation is valid only on layers which have been added to an image.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("offx",
                                                      "offx",
                                                      "Offset in x direction",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("offy",
                                                      "offy",
                                                      "Offset in y direction",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-layer-create-mask
   */
  procedure = gimp_procedure_new (layer_create_mask_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-layer-create-mask");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-layer-create-mask",
                                     "Create a layer mask for the specified specified layer.",
                                     "This procedure creates a layer mask for the specified layer. Layer masks serve as an additional alpha channel for a layer. A number of ifferent types of masks are allowed for initialisation: completely white masks (which will leave the layer fully visible), completely black masks (which will give the layer complete transparency, the layer's already existing alpha channel (which will leave the layer fully visible, but which may be more useful than a white mask), the current selection or a grayscale copy of the layer. The layer mask still needs to be added to the layer. This can be done with a call to 'gimp_layer_add_mask'.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The layer to which to add the mask",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("mask-type",
                                                  "mask type",
                                                  "The type of mask",
                                                  GIMP_TYPE_ADD_MASK_TYPE,
                                                  GIMP_ADD_WHITE_MASK,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_layer_mask_id ("mask",
                                                                  "mask",
                                                                  "The newly created mask",
                                                                  pdb->gimp, FALSE,
                                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-layer-get-mask
   */
  procedure = gimp_procedure_new (layer_get_mask_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-layer-get-mask");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-layer-get-mask",
                                     "Get the specified layer's mask if it exists.",
                                     "This procedure returns the specified layer's mask, or -1 if none exists.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_layer_mask_id ("mask",
                                                                  "mask",
                                                                  "The layer mask",
                                                                  pdb->gimp, FALSE,
                                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-layer-from-mask
   */
  procedure = gimp_procedure_new (layer_from_mask_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-layer-from-mask");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-layer-from-mask",
                                     "Get the specified mask's layer.",
                                     "This procedure returns the specified mask's layer , or -1 if none exists.",
                                     "Geert Jordaens",
                                     "Geert Jordaens",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_mask_id ("mask",
                                                              "mask",
                                                              "Mask for which to return the layer",
                                                              pdb->gimp, FALSE,
                                                              GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_layer_id ("layer",
                                                             "layer",
                                                             "The mask's layer",
                                                             pdb->gimp, FALSE,
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-layer-add-mask
   */
  procedure = gimp_procedure_new (layer_add_mask_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-layer-add-mask");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-layer-add-mask",
                                     "Add a layer mask to the specified layer.",
                                     "This procedure adds a layer mask to the specified layer. Layer masks serve as an additional alpha channel for a layer. This procedure will fail if a number of prerequisites aren't met. The layer cannot already have a layer mask. The specified mask must exist and have the same dimensions as the layer. Both the mask and the layer must have been created for use with the specified image.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The layer to receive the mask",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_mask_id ("mask",
                                                              "mask",
                                                              "The mask to add to the layer",
                                                              pdb->gimp, FALSE,
                                                              GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-layer-remove-mask
   */
  procedure = gimp_procedure_new (layer_remove_mask_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-layer-remove-mask");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-layer-remove-mask",
                                     "Remove the specified layer mask from the layer.",
                                     "This procedure removes the specified layer mask from the layer. If the mask doesn't exist, an error is returned.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The layer from which to remove mask",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("mode",
                                                  "mode",
                                                  "Removal mode",
                                                  GIMP_TYPE_MASK_APPLY_MODE,
                                                  GIMP_MASK_APPLY,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-layer-is-floating-sel
   */
  procedure = gimp_procedure_new (layer_is_floating_sel_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-layer-is-floating-sel");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-layer-is-floating-sel",
                                     "Is the specified layer a floating selection?",
                                     "This procedure returns whether the layer is a floating selection. Floating selections are special cases of layers which are attached to a specific drawable.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("is-floating-sel",
                                                         "is floating sel",
                                                         "TRUE if the layer is a floating selection",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-layer-get-lock-alpha
   */
  procedure = gimp_procedure_new (layer_get_lock_alpha_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-layer-get-lock-alpha");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-layer-get-lock-alpha",
                                     "Get the lock alpha channel setting of the specified layer.",
                                     "This procedure returns the specified layer's lock alpha channel setting.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("lock-alpha",
                                                         "lock alpha",
                                                         "The layer's lock alpha channel setting",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-layer-set-lock-alpha
   */
  procedure = gimp_procedure_new (layer_set_lock_alpha_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-layer-set-lock-alpha");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-layer-set-lock-alpha",
                                     "Set the lock alpha channel setting of the specified layer.",
                                     "This procedure sets the specified layer's lock alpha channel setting.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("lock-alpha",
                                                     "lock alpha",
                                                     "The new layer's lock alpha channel setting",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-layer-get-apply-mask
   */
  procedure = gimp_procedure_new (layer_get_apply_mask_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-layer-get-apply-mask");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-layer-get-apply-mask",
                                     "Get the apply mask setting of the specified layer.",
                                     "This procedure returns the specified layer's apply mask setting. If the value is TRUE, then the layer mask for this layer is currently being composited with the layer's alpha channel.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("apply-mask",
                                                         "apply mask",
                                                         "The layer's apply mask setting",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-layer-set-apply-mask
   */
  procedure = gimp_procedure_new (layer_set_apply_mask_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-layer-set-apply-mask");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-layer-set-apply-mask",
                                     "Set the apply mask setting of the specified layer.",
                                     "This procedure sets the specified layer's apply mask setting. This controls whether the layer's mask is currently affecting the alpha channel. If there is no layer mask, this function will return an error.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("apply-mask",
                                                     "apply mask",
                                                     "The new layer's apply mask setting",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-layer-get-show-mask
   */
  procedure = gimp_procedure_new (layer_get_show_mask_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-layer-get-show-mask");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-layer-get-show-mask",
                                     "Get the show mask setting of the specified layer.",
                                     "This procedure returns the specified layer's show mask setting. This controls whether the layer or its mask is visible. TRUE indicates that the mask should be visible. If the layer has no mask, then this function returns an error.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("show-mask",
                                                         "show mask",
                                                         "The layer's show mask setting",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-layer-set-show-mask
   */
  procedure = gimp_procedure_new (layer_set_show_mask_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-layer-set-show-mask");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-layer-set-show-mask",
                                     "Set the show mask setting of the specified layer.",
                                     "This procedure sets the specified layer's show mask setting. This controls whether the layer's mask is currently affecting the alpha channel. If there is no layer mask, this function will return an error.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("show-mask",
                                                     "show mask",
                                                     "The new layer's show mask setting",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-layer-get-edit-mask
   */
  procedure = gimp_procedure_new (layer_get_edit_mask_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-layer-get-edit-mask");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-layer-get-edit-mask",
                                     "Get the edit mask setting of the specified layer.",
                                     "This procedure returns the specified layer's edit mask setting. If the value is TRUE, then the layer mask for this layer is currently active, and not the layer.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("edit-mask",
                                                         "edit mask",
                                                         "The layer's edit mask setting",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-layer-set-edit-mask
   */
  procedure = gimp_procedure_new (layer_set_edit_mask_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-layer-set-edit-mask");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-layer-set-edit-mask",
                                     "Set the edit mask setting of the specified layer.",
                                     "This procedure sets the specified layer's edit mask setting. This controls whether the layer or it's mask is currently active for editing. If the specified layer has no layer mask, then this procedure will return an error.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("edit-mask",
                                                     "edit mask",
                                                     "The new layer's edit mask setting",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-layer-get-opacity
   */
  procedure = gimp_procedure_new (layer_get_opacity_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-layer-get-opacity");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-layer-get-opacity",
                                     "Get the opacity of the specified layer.",
                                     "This procedure returns the specified layer's opacity.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("opacity",
                                                        "opacity",
                                                        "The layer opacity",
                                                        0, 100, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-layer-set-opacity
   */
  procedure = gimp_procedure_new (layer_set_opacity_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-layer-set-opacity");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-layer-set-opacity",
                                     "Set the opacity of the specified layer.",
                                     "This procedure sets the specified layer's opacity.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("opacity",
                                                    "opacity",
                                                    "The new layer opacity",
                                                    0, 100, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-layer-get-mode
   */
  procedure = gimp_procedure_new (layer_get_mode_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-layer-get-mode");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-layer-get-mode",
                                     "Get the combination mode of the specified layer.",
                                     "This procedure returns the specified layer's combination mode.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("mode",
                                                      "mode",
                                                      "The layer combination mode",
                                                      GIMP_TYPE_LAYER_MODE_EFFECTS,
                                                      GIMP_NORMAL_MODE,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-layer-set-mode
   */
  procedure = gimp_procedure_new (layer_set_mode_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-layer-set-mode");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-layer-set-mode",
                                     "Set the combination mode of the specified layer.",
                                     "This procedure sets the specified layer's combination mode.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "The layer",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("mode",
                                                  "mode",
                                                  "The new layer combination mode",
                                                  GIMP_TYPE_LAYER_MODE_EFFECTS,
                                                  GIMP_NORMAL_MODE,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
