/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpmisc_pdb.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl */

#include "config.h"

#include "gimp.h"

/**
 * gimp_version:
 *
 * Returns the host gimp version.
 *
 * This procedure returns the version number of the currently running
 * gimp.
 *
 * Returns: The gimp version.
 */
gchar *
gimp_version (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *version = NULL;

  return_vals = gimp_run_procedure ("gimp-version",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    version = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return version;
}

/**
 * gimp_getpid:
 *
 * Returns the PID of the host gimp process.
 *
 * This procedure returns the process ID of the currently running gimp.
 *
 * Returns: The PID.
 *
 * Since: GIMP 2.4
 */
gint
gimp_getpid (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint pid = 0;

  return_vals = gimp_run_procedure ("gimp-getpid",
                                    &nreturn_vals,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    pid = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return pid;
}
