/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpimagegrid_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "stamp-pdbgen.h"

#include "gimp.h"


/**
 * SECTION: gimpimagegrid
 * @title: gimpimagegrid
 * @short_description: Functions manuipulating an image's grid.
 *
 * Functions manuipulating an image's grid.
 **/


/**
 * gimp_image_grid_get_spacing:
 * @image: The image.
 * @xspacing: (out): The image's grid horizontal spacing.
 * @yspacing: (out): The image's grid vertical spacing.
 *
 * Gets the spacing of an image's grid.
 *
 * This procedure retrieves the horizontal and vertical spacing of an
 * image's grid. It takes the image as parameter.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_grid_get_spacing (GimpImage *image,
                             gdouble   *xspacing,
                             gdouble   *yspacing)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-grid-get-spacing",
                                              args);
  gimp_value_array_unref (args);

  *xspacing = 0.0;
  *yspacing = 0.0;

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    {
      *xspacing = GIMP_VALUES_GET_DOUBLE (return_vals, 1);
      *yspacing = GIMP_VALUES_GET_DOUBLE (return_vals, 2);
    }

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_grid_set_spacing:
 * @image: The image.
 * @xspacing: The image's grid horizontal spacing.
 * @yspacing: The image's grid vertical spacing.
 *
 * Sets the spacing of an image's grid.
 *
 * This procedure sets the horizontal and vertical spacing of an
 * image's grid.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_grid_set_spacing (GimpImage *image,
                             gdouble    xspacing,
                             gdouble    yspacing)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_DOUBLE, xspacing,
                                          G_TYPE_DOUBLE, yspacing,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-grid-set-spacing",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_grid_get_offset:
 * @image: The image.
 * @xoffset: (out): The image's grid horizontal offset.
 * @yoffset: (out): The image's grid vertical offset.
 *
 * Gets the offset of an image's grid.
 *
 * This procedure retrieves the horizontal and vertical offset of an
 * image's grid. It takes the image as parameter.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_grid_get_offset (GimpImage *image,
                            gdouble   *xoffset,
                            gdouble   *yoffset)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-grid-get-offset",
                                              args);
  gimp_value_array_unref (args);

  *xoffset = 0.0;
  *yoffset = 0.0;

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    {
      *xoffset = GIMP_VALUES_GET_DOUBLE (return_vals, 1);
      *yoffset = GIMP_VALUES_GET_DOUBLE (return_vals, 2);
    }

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_grid_set_offset:
 * @image: The image.
 * @xoffset: The image's grid horizontal offset.
 * @yoffset: The image's grid vertical offset.
 *
 * Sets the offset of an image's grid.
 *
 * This procedure sets the horizontal and vertical offset of an image's
 * grid.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_grid_set_offset (GimpImage *image,
                            gdouble    xoffset,
                            gdouble    yoffset)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_DOUBLE, xoffset,
                                          G_TYPE_DOUBLE, yoffset,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-grid-set-offset",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_grid_get_foreground_color:
 * @image: The image.
 * @fgcolor: (out caller-allocates): The image's grid foreground color.
 *
 * Sets the foreground color of an image's grid.
 *
 * This procedure gets the foreground color of an image's grid.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_grid_get_foreground_color (GimpImage *image,
                                      GimpRGB   *fgcolor)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-grid-get-foreground-color",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    GIMP_VALUES_GET_RGB (return_vals, 1, &*fgcolor);

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_grid_set_foreground_color:
 * @image: The image.
 * @fgcolor: The new foreground color.
 *
 * Gets the foreground color of an image's grid.
 *
 * This procedure sets the foreground color of an image's grid.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_grid_set_foreground_color (GimpImage     *image,
                                      const GimpRGB *fgcolor)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          GIMP_TYPE_RGB, fgcolor,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-grid-set-foreground-color",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_grid_get_background_color:
 * @image: The image.
 * @bgcolor: (out caller-allocates): The image's grid background color.
 *
 * Sets the background color of an image's grid.
 *
 * This procedure gets the background color of an image's grid.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_grid_get_background_color (GimpImage *image,
                                      GimpRGB   *bgcolor)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-grid-get-background-color",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    GIMP_VALUES_GET_RGB (return_vals, 1, &*bgcolor);

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_grid_set_background_color:
 * @image: The image.
 * @bgcolor: The new background color.
 *
 * Gets the background color of an image's grid.
 *
 * This procedure sets the background color of an image's grid.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_grid_set_background_color (GimpImage     *image,
                                      const GimpRGB *bgcolor)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          GIMP_TYPE_RGB, bgcolor,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-grid-set-background-color",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_grid_get_style:
 * @image: The image.
 *
 * Gets the style of an image's grid.
 *
 * This procedure retrieves the style of an image's grid.
 *
 * Returns: The image's grid style.
 *
 * Since: 2.4
 **/
GimpGridStyle
gimp_image_grid_get_style (GimpImage *image)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpGridStyle style = 0;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-grid-get-style",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    style = GIMP_VALUES_GET_ENUM (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return style;
}

/**
 * gimp_image_grid_set_style:
 * @image: The image.
 * @style: The image's grid style.
 *
 * Sets the style unit of an image's grid.
 *
 * This procedure sets the style of an image's grid. It takes the image
 * and the new style as parameters.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_image_grid_set_style (GimpImage     *image,
                           GimpGridStyle  style)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          GIMP_TYPE_GRID_STYLE, style,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-grid-set-style",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}
