/* plugin.c generated by valac 0.11.7, the Vala compiler
 * generated from plugin.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Abderrahim Kitouni
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libanjuta/libanjuta.h>
#include <libanjuta/interfaces/libanjuta-interfaces.h>
#include <gio/gio.h>
#include <vala.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_VALA_PLUGIN (vala_plugin_get_type ())
#define VALA_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALA_PLUGIN, ValaPlugin))
#define VALA_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALA_PLUGIN, ValaPluginClass))
#define IS_VALA_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALA_PLUGIN))
#define IS_VALA_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALA_PLUGIN))
#define VALA_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALA_PLUGIN, ValaPluginClass))

typedef struct _ValaPlugin ValaPlugin;
typedef struct _ValaPluginClass ValaPluginClass;
typedef struct _ValaPluginPrivate ValaPluginPrivate;

#define TYPE_BLOCK_LOCATOR (block_locator_get_type ())
#define BLOCK_LOCATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLOCK_LOCATOR, BlockLocator))
#define BLOCK_LOCATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLOCK_LOCATOR, BlockLocatorClass))
#define IS_BLOCK_LOCATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLOCK_LOCATOR))
#define IS_BLOCK_LOCATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLOCK_LOCATOR))
#define BLOCK_LOCATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLOCK_LOCATOR, BlockLocatorClass))

typedef struct _BlockLocator BlockLocator;
typedef struct _BlockLocatorClass BlockLocatorClass;

#define TYPE_ANJUTA_REPORT (anjuta_report_get_type ())
#define ANJUTA_REPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANJUTA_REPORT, AnjutaReport))
#define ANJUTA_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANJUTA_REPORT, AnjutaReportClass))
#define IS_ANJUTA_REPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANJUTA_REPORT))
#define IS_ANJUTA_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANJUTA_REPORT))
#define ANJUTA_REPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANJUTA_REPORT, AnjutaReportClass))

typedef struct _AnjutaReport AnjutaReport;
typedef struct _AnjutaReportClass AnjutaReportClass;

#define TYPE_VALA_PROVIDER (vala_provider_get_type ())
#define VALA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALA_PROVIDER, ValaProvider))
#define VALA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALA_PROVIDER, ValaProviderClass))
#define IS_VALA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALA_PROVIDER))
#define IS_VALA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALA_PROVIDER))
#define VALA_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALA_PROVIDER, ValaProviderClass))

typedef struct _ValaProvider ValaProvider;
typedef struct _ValaProviderClass ValaProviderClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define __g_list_free__vala_code_node_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__vala_code_node_unref0_ (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))

struct _ValaPlugin {
	AnjutaPlugin parent_instance;
	ValaPluginPrivate * priv;
	IAnjutaEditor* current_editor;
	GSettings* settings;
};

struct _ValaPluginClass {
	AnjutaPluginClass parent_class;
};

struct _ValaPluginPrivate {
	guint editor_watch_id;
	gulong project_loaded_id;
	ValaCodeContext* context;
	GStaticRecMutex __lock_context;
	GCancellable* cancel;
	BlockLocator* locator;
	AnjutaReport* report;
	ValaProvider* provider;
	ValaParser* parser;
	ValaGenieParser* genie_parser;
	ValaSet* current_sources;
};


static gpointer vala_plugin_parent_class = NULL;
static GType vala_plugin_type_id = 0;

GType vala_plugin_get_type (void) G_GNUC_CONST;
GType vala_plugin_register_type (GTypeModule * module);
GType block_locator_get_type (void) G_GNUC_CONST;
GType block_locator_register_type (GTypeModule * module);
GType anjuta_report_get_type (void) G_GNUC_CONST;
GType anjuta_report_register_type (GTypeModule * module);
GType vala_provider_get_type (void) G_GNUC_CONST;
GType vala_provider_register_type (GTypeModule * module);
#define VALA_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VALA_PLUGIN, ValaPluginPrivate))
enum  {
	VALA_PLUGIN_DUMMY_PROPERTY
};
BlockLocator* block_locator_new (void);
BlockLocator* block_locator_construct (GType object_type);
static ValaPlugin* vala_plugin_new (void);
static ValaPlugin* vala_plugin_construct (GType object_type);
static gboolean vala_plugin_real_activate (AnjutaPlugin* base);
AnjutaReport* anjuta_report_new (void);
AnjutaReport* anjuta_report_construct (GType object_type);
void anjuta_report_set_docman (AnjutaReport* self, IAnjutaDocumentManager* value);
static void vala_plugin_init_context (ValaPlugin* self);
ValaProvider* vala_provider_new (ValaPlugin* plugin);
ValaProvider* vala_provider_construct (GType object_type, ValaPlugin* plugin);
void vala_plugin_editor_value_added (ValaPlugin* self, AnjutaPlugin* plugin, const gchar* name, GValue* value);
static void _vala_plugin_editor_value_added_anjuta_plugin_value_added (AnjutaPlugin* plugin, const gchar* name, GValue* value, gpointer self);
void vala_plugin_editor_value_removed (ValaPlugin* self, AnjutaPlugin* plugin, const gchar* name);
static void _vala_plugin_editor_value_removed_anjuta_plugin_value_removed (AnjutaPlugin* plugin, const gchar* name, gpointer self);
static gboolean vala_plugin_real_deactivate (AnjutaPlugin* base);
void anjuta_report_clear_error_indicators (AnjutaReport* self);
static void vala_plugin_parse (ValaPlugin* self);
static void _lambda0_ (ValaPlugin* self);
gboolean anjuta_report_errors_found (AnjutaReport* self);
static gpointer __lambda0__gthread_func (gpointer self);
static void vala_plugin_add_project_files (ValaPlugin* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void vala_plugin_on_project_loaded (ValaPlugin* self, IAnjutaProjectManager* pm, GError* e);
static void _vala_plugin_on_project_loaded_ianjuta_project_manager_project_loaded (IAnjutaProjectManager* _sender, GError* _error_, gpointer self);
void vala_plugin_on_char_added (ValaPlugin* self, IAnjutaEditor* editor, IAnjutaIterable* position, gchar ch);
static void _vala_plugin_on_char_added_ianjuta_editor_char_added (IAnjutaEditor* _sender, IAnjutaIterable* position, gchar ch, gpointer self);
void vala_plugin_on_file_saved (ValaPlugin* self, IAnjutaFileSavable* savable, GFile* file);
static void _vala_plugin_on_file_saved_ianjuta_file_savable_saved (IAnjutaFileSavable* _sender, GFile* file, gpointer self);
gboolean vala_plugin_on_drop_possible (ValaPlugin* self, IAnjutaEditorGladeSignal* editor, IAnjutaIterable* position);
static gboolean _vala_plugin_on_drop_possible_ianjuta_editor_glade_signal_drop_possible (IAnjutaEditorGladeSignal* _sender, IAnjutaIterable* iterator, gpointer self);
void vala_plugin_on_drop (ValaPlugin* self, IAnjutaEditorGladeSignal* editor, IAnjutaIterable* position, const gchar* signal_data);
static void _vala_plugin_on_drop_ianjuta_editor_glade_signal_drop (IAnjutaEditorGladeSignal* _sender, IAnjutaIterable* iterator, const gchar* signal_data, gpointer self);
void anjuta_report_update_errors (AnjutaReport* self, IAnjutaEditor* editor);
static void vala_plugin_update_file (ValaPlugin* self, ValaSourceFile* file);
#define VALA_PROVIDER_PREF_CALLTIP_ENABLE "cpp-calltip-enable"
void vala_provider_show_call_tip (ValaProvider* self, IAnjutaEditorTip* editor);
static ValaSymbol* vala_plugin_get_scope (ValaPlugin* self, IAnjutaEditor* editor, IAnjutaIterable* position);
ValaSymbol* vala_plugin_get_current_context (ValaPlugin* self, IAnjutaEditor* editor, IAnjutaIterable* position);
static ValaSymbol* vala_plugin_lookup_symbol_by_cname (ValaPlugin* self, const gchar* cname, ValaSymbol* parent);
static GList* vala_plugin_symbol_lookup_inherited (ValaPlugin* self, ValaSymbol* sym, const gchar* name, gboolean prefix_match, gboolean invocation);
static void _vala_code_node_unref0_ (gpointer var);
static void _g_list_free__vala_code_node_unref0_ (GList* self);
ValaSymbol* block_locator_locate (BlockLocator* self, ValaSourceFile* file, gint line, gint column);
GList* vala_plugin_lookup_symbol (ValaPlugin* self, ValaExpression* inner, const gchar* name, gboolean prefix_match, ValaBlock* block);
static void vala_plugin_finalize (GObject* obj);
GType anjuta_glue_register_components (GTypeModule* module);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static ValaPlugin* vala_plugin_construct (GType object_type) {
	ValaPlugin * self = NULL;
	self = (ValaPlugin*) g_object_new (object_type, NULL);
	return self;
}


static ValaPlugin* vala_plugin_new (void) {
	return vala_plugin_construct (TYPE_VALA_PLUGIN);
}


static void _vala_plugin_editor_value_added_anjuta_plugin_value_added (AnjutaPlugin* plugin, const gchar* name, GValue* value, gpointer self) {
	vala_plugin_editor_value_added (self, plugin, name, value);
}


static void _vala_plugin_editor_value_removed_anjuta_plugin_value_removed (AnjutaPlugin* plugin, const gchar* name, gpointer self) {
	vala_plugin_editor_value_removed (self, plugin, name);
}


static gboolean vala_plugin_real_activate (AnjutaPlugin* base) {
	ValaPlugin * self;
	gboolean result = FALSE;
	AnjutaReport* _tmp0_ = NULL;
	AnjutaShell* _tmp1_ = NULL;
	AnjutaShell* _tmp2_;
	GObject* _tmp3_ = NULL;
	GObject* _tmp4_;
	GObject* _tmp5_;
	ValaParser* _tmp6_ = NULL;
	ValaGenieParser* _tmp7_ = NULL;
	ValaProvider* _tmp8_ = NULL;
	guint _tmp9_;
	GError * _inner_error_ = NULL;
	self = (ValaPlugin*) base;
	g_debug ("plugin.vala:42: Activating ValaPlugin");
	_tmp0_ = anjuta_report_new ();
	_g_object_unref0 (self->priv->report);
	self->priv->report = _tmp0_;
	g_object_get ((AnjutaPlugin*) self, "shell", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = anjuta_shell_get_object (_tmp2_, "IAnjutaDocumentManager", &_inner_error_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	anjuta_report_set_docman (self->priv->report, IANJUTA_DOCUMENT_MANAGER (_tmp5_));
	_tmp6_ = vala_parser_new ();
	_vala_code_visitor_unref0 (self->priv->parser);
	self->priv->parser = _tmp6_;
	_tmp7_ = vala_genie_parser_new ();
	_vala_code_visitor_unref0 (self->priv->genie_parser);
	self->priv->genie_parser = _tmp7_;
	vala_plugin_init_context (self);
	_tmp8_ = vala_provider_new (self);
	_g_object_unref0 (self->priv->provider);
	self->priv->provider = _tmp8_;
	_tmp9_ = anjuta_plugin_add_watch ((AnjutaPlugin*) self, "document_manager_current_document", _vala_plugin_editor_value_added_anjuta_plugin_value_added, _vala_plugin_editor_value_removed_anjuta_plugin_value_removed, self);
	self->priv->editor_watch_id = _tmp9_;
	result = TRUE;
	return result;
}


static gboolean vala_plugin_real_deactivate (AnjutaPlugin* base) {
	ValaPlugin * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (ValaPlugin*) base;
	g_debug ("plugin.vala:59: Deactivating ValaPlugin");
	anjuta_plugin_remove_watch ((AnjutaPlugin*) self, self->priv->editor_watch_id, TRUE);
	g_cancellable_cancel (self->priv->cancel);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_context);
		_vala_code_context_unref0 (self->priv->context);
		self->priv->context = NULL;
		__finally0:
		g_static_rec_mutex_unlock (&self->priv->__lock_context);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	return result;
}


static void vala_plugin_init_context (ValaPlugin* self) {
	ValaCodeContext* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	ValaHashSet* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	vala_code_context_set_profile (self->priv->context, VALA_PROFILE_GOBJECT);
	vala_code_context_set_report (self->priv->context, (ValaReport*) self->priv->report);
	anjuta_report_clear_error_indicators (self->priv->report);
	_tmp1_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancel);
	self->priv->cancel = _tmp1_;
	vala_parser_parse (self->priv->parser, self->priv->context);
	vala_genie_parser_parse (self->priv->genie_parser, self->priv->context);
	_tmp2_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	_vala_iterable_unref0 (self->priv->current_sources);
	self->priv->current_sources = (ValaSet*) _tmp2_;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda0_ (ValaPlugin* self) {
	GError * _inner_error_ = NULL;
	{
		ValaReport* _tmp0_ = NULL;
		ValaReport* _tmp1_;
		AnjutaReport* _tmp2_;
		AnjutaReport* report;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_;
		g_static_rec_mutex_lock (&self->priv->__lock_context);
		vala_code_context_push (self->priv->context);
		_tmp0_ = vala_code_context_get_report (self->priv->context);
		_tmp1_ = _tmp0_;
		_tmp2_ = _g_object_ref0 (IS_ANJUTA_REPORT (_tmp1_) ? ((AnjutaReport*) _tmp1_) : NULL);
		report = _tmp2_;
		{
			ValaList* _tmp3_ = NULL;
			ValaList* _src_list;
			gint _tmp4_;
			gint _src_size;
			gint _src_index;
			_tmp3_ = vala_code_context_get_source_files (self->priv->context);
			_src_list = _tmp3_;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) _src_list);
			_src_size = _tmp4_;
			_src_index = -1;
			while (TRUE) {
				gpointer _tmp5_ = NULL;
				ValaSourceFile* src;
				ValaList* _tmp6_ = NULL;
				ValaList* _tmp7_;
				gint _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp11_;
				_src_index = _src_index + 1;
				if (!(_src_index < _src_size)) {
					break;
				}
				_tmp5_ = vala_list_get (_src_list, _src_index);
				src = (ValaSourceFile*) _tmp5_;
				_tmp6_ = vala_source_file_get_nodes (src);
				_tmp7_ = _tmp6_;
				_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
				_tmp9_ = _tmp8_ == 0;
				_vala_iterable_unref0 (_tmp7_);
				if (_tmp9_) {
					const gchar* _tmp10_ = NULL;
					_tmp10_ = vala_source_file_get_filename (src);
					g_debug ("plugin.vala:96: parsing file %s", _tmp10_);
					vala_code_visitor_visit_source_file ((ValaCodeVisitor*) self->priv->genie_parser, src);
					vala_code_visitor_visit_source_file ((ValaCodeVisitor*) self->priv->parser, src);
				}
				_tmp11_ = g_cancellable_is_cancelled (self->priv->cancel);
				if (_tmp11_) {
					vala_code_context_pop ();
					_vala_source_file_unref0 (src);
					_vala_iterable_unref0 (_src_list);
					g_static_rec_mutex_unlock (&self->priv->__lock_context);
					_g_object_unref0 (report);
					return;
				}
				_vala_source_file_unref0 (src);
			}
			_vala_iterable_unref0 (_src_list);
		}
		_tmp13_ = anjuta_report_errors_found (report);
		if (_tmp13_) {
			_tmp12_ = TRUE;
		} else {
			gboolean _tmp14_;
			_tmp14_ = g_cancellable_is_cancelled (self->priv->cancel);
			_tmp12_ = _tmp14_;
		}
		if (_tmp12_) {
			vala_code_context_pop ();
			g_static_rec_mutex_unlock (&self->priv->__lock_context);
			_g_object_unref0 (report);
			return;
		}
		vala_code_context_check (self->priv->context);
		vala_code_context_pop ();
		_g_object_unref0 (report);
		__finally2:
		g_static_rec_mutex_unlock (&self->priv->__lock_context);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static gpointer __lambda0__gthread_func (gpointer self) {
	_lambda0_ (self);
}


static void vala_plugin_parse (ValaPlugin* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_thread_create (__lambda0__gthread_func, self, FALSE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_THREAD_ERROR) {
			goto __catch1_g_thread_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	goto __finally1;
	__catch1_g_thread_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("plugin.vala:117: cannot create thread : %s", err->message);
		_g_error_free0 (err);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void vala_plugin_add_project_files (ValaPlugin* self) {
	AnjutaShell* _tmp0_ = NULL;
	AnjutaShell* _tmp1_;
	GObject* _tmp2_ = NULL;
	GObject* _tmp3_;
	GObject* _tmp4_;
	IAnjutaProjectManager* _tmp5_;
	IAnjutaProjectManager* project;
	GList* _tmp6_ = NULL;
	GList* sources;
	gboolean _tmp15_;
	GList* _tmp16_ = NULL;
	GList* packages;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_object_get ((AnjutaPlugin*) self, "shell", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = anjuta_shell_get_object (_tmp1_, "IAnjutaProjectManager", &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp5_ = _g_object_ref0 (IANJUTA_PROJECT_MANAGER (_tmp4_));
	project = _tmp5_;
	vala_code_context_push (self->priv->context);
	_tmp6_ = ianjuta_project_manager_get_elements (project, ANJUTA_PROJECT_SOURCE, &_inner_error_);
	sources = _tmp6_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (project);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		GList* src_collection;
		GList* src_it;
		src_collection = sources;
		for (src_it = src_collection; src_it != NULL; src_it = src_it->next) {
			GFile* _tmp7_;
			GFile* src;
			_tmp7_ = _g_object_ref0 ((GFile*) src_it->data);
			src = _tmp7_;
			{
				gchar* _tmp8_ = NULL;
				gchar* path;
				gboolean _tmp9_ = FALSE;
				gboolean _tmp10_ = FALSE;
				gboolean _tmp11_;
				_tmp8_ = g_file_get_path (src);
				path = _tmp8_;
				if (path == NULL) {
					_g_free0 (path);
					_g_object_unref0 (src);
					continue;
				}
				_tmp11_ = g_str_has_suffix (path, ".vala");
				if (_tmp11_) {
					_tmp10_ = TRUE;
				} else {
					gboolean _tmp12_;
					_tmp12_ = g_str_has_suffix (path, ".vapi");
					_tmp10_ = _tmp12_;
				}
				if (_tmp10_) {
					_tmp9_ = TRUE;
				} else {
					gboolean _tmp13_;
					_tmp13_ = g_str_has_suffix (path, ".gs");
					_tmp9_ = _tmp13_;
				}
				if (_tmp9_) {
					gboolean _tmp14_;
					_tmp14_ = vala_collection_contains ((ValaCollection*) self->priv->current_sources, path);
					if (_tmp14_) {
						g_debug ("plugin.vala:132: file %s already added", path);
					} else {
						vala_code_context_add_source_filename (self->priv->context, path, FALSE);
						vala_collection_add ((ValaCollection*) self->priv->current_sources, path);
						g_debug ("plugin.vala:136: file %s added", path);
					}
				} else {
					g_debug ("plugin.vala:139: file %s skipped", path);
				}
				_g_free0 (path);
				_g_object_unref0 (src);
			}
		}
	}
	_tmp15_ = vala_code_context_has_package (self->priv->context, "gobject-2.0");
	if (!_tmp15_) {
		vala_code_context_add_external_package (self->priv->context, "glib-2.0");
		vala_code_context_add_external_package (self->priv->context, "gobject-2.0");
		g_debug ("plugin.vala:145: standard packages added");
	} else {
		g_debug ("plugin.vala:147: standard packages already added");
	}
	_tmp16_ = ianjuta_project_manager_get_packages (project, &_inner_error_);
	packages = _tmp16_;
	if (_inner_error_ != NULL) {
		__g_list_free__g_object_unref0_0 (sources);
		_g_object_unref0 (project);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		GList* pkg_collection;
		GList* pkg_it;
		pkg_collection = packages;
		for (pkg_it = pkg_collection; pkg_it != NULL; pkg_it = pkg_it->next) {
			const gchar* pkg;
			pkg = (const gchar*) pkg_it->data;
			{
				gboolean _tmp17_;
				_tmp17_ = vala_code_context_has_package (self->priv->context, pkg);
				if (_tmp17_) {
					g_debug ("plugin.vala:153: package %s skipped", pkg);
				} else {
					gboolean _tmp18_;
					_tmp18_ = vala_code_context_add_external_package (self->priv->context, pkg);
					if (_tmp18_) {
						g_debug ("plugin.vala:155: package %s added", pkg);
					} else {
						g_debug ("plugin.vala:158: package %s not found", pkg);
					}
				}
			}
		}
	}
	vala_code_context_pop ();
	_g_list_free0 (packages);
	__g_list_free__g_object_unref0_0 (sources);
	_g_object_unref0 (project);
}


void vala_plugin_on_project_loaded (ValaPlugin* self, IAnjutaProjectManager* pm, GError* e) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (pm != NULL);
	if (self->priv->context == NULL) {
		return;
	}
	vala_plugin_add_project_files (self);
	vala_plugin_parse (self);
	g_signal_handler_disconnect ((GObject*) pm, self->priv->project_loaded_id);
	self->priv->project_loaded_id = (gulong) 0;
}


static void _vala_plugin_on_project_loaded_ianjuta_project_manager_project_loaded (IAnjutaProjectManager* _sender, GError* _error_, gpointer self) {
	vala_plugin_on_project_loaded (self, _sender, _error_);
}


static void _vala_plugin_on_char_added_ianjuta_editor_char_added (IAnjutaEditor* _sender, IAnjutaIterable* position, gchar ch, gpointer self) {
	vala_plugin_on_char_added (self, _sender, position, ch);
}


static void _vala_plugin_on_file_saved_ianjuta_file_savable_saved (IAnjutaFileSavable* _sender, GFile* file, gpointer self) {
	vala_plugin_on_file_saved (self, _sender, file);
}


static gboolean _vala_plugin_on_drop_possible_ianjuta_editor_glade_signal_drop_possible (IAnjutaEditorGladeSignal* _sender, IAnjutaIterable* iterator, gpointer self) {
	gboolean result;
	result = vala_plugin_on_drop_possible (self, _sender, iterator);
	return result;
}


static void _vala_plugin_on_drop_ianjuta_editor_glade_signal_drop (IAnjutaEditorGladeSignal* _sender, IAnjutaIterable* iterator, const gchar* signal_data, gpointer self) {
	vala_plugin_on_drop (self, _sender, iterator, signal_data);
}


void vala_plugin_editor_value_added (ValaPlugin* self, AnjutaPlugin* plugin, const gchar* name, GValue* value) {
	GObject* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	GObject* _tmp2_;
	GObject* _tmp3_ = NULL;
	GObject* _tmp4_;
	IAnjutaFile* _tmp5_;
	IAnjutaFile* current_file;
	AnjutaShell* _tmp6_ = NULL;
	AnjutaShell* _tmp7_;
	GObject* _tmp8_ = NULL;
	GObject* _tmp9_;
	GObject* _tmp10_;
	IAnjutaProjectManager* _tmp11_;
	IAnjutaProjectManager* pm;
	IAnjutaProject* _tmp12_ = NULL;
	IAnjutaProject* _tmp13_;
	IAnjutaProject* project;
	gboolean _tmp14_;
	gboolean _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin != NULL);
	g_return_if_fail (name != NULL);
	g_debug ("plugin.vala:175: editor value added");
	g_assert (self->current_editor == NULL);
	_tmp0_ = g_value_get_object (value);
	if (!IANJUTA_IS_EDITOR (_tmp0_)) {
		return;
	}
	_tmp1_ = g_value_get_object (value);
	_tmp2_ = _tmp1_;
	self->current_editor = IANJUTA_IS_EDITOR (_tmp2_) ? ((IAnjutaEditor*) _tmp2_) : NULL;
	_tmp3_ = g_value_get_object (value);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (IANJUTA_IS_FILE (_tmp4_) ? ((IAnjutaFile*) _tmp4_) : NULL);
	current_file = _tmp5_;
	g_object_get ((AnjutaPlugin*) self, "shell", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = anjuta_shell_get_object (_tmp7_, "IAnjutaProjectManager", &_inner_error_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp7_);
	_tmp10_ = _tmp9_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (current_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp11_ = _g_object_ref0 (IANJUTA_PROJECT_MANAGER (_tmp10_));
	pm = _tmp11_;
	_tmp12_ = ianjuta_project_manager_get_current_project (pm, &_inner_error_);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	project = _tmp13_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (pm);
		_g_object_unref0 (current_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp14_ = ianjuta_project_is_loaded (project, &_inner_error_);
	_tmp15_ = _tmp14_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (project);
		_g_object_unref0 (pm);
		_g_object_unref0 (current_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (!_tmp15_) {
		if (self->priv->project_loaded_id == 0) {
			gulong _tmp16_;
			_tmp16_ = g_signal_connect_object (pm, "project-loaded", (GCallback) _vala_plugin_on_project_loaded_ianjuta_project_manager_project_loaded, self, 0);
			self->priv->project_loaded_id = _tmp16_;
		}
	} else {
		GFile* _tmp17_ = NULL;
		GFile* cur_gfile;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gboolean _tmp20_;
		gboolean _tmp21_;
		_tmp17_ = ianjuta_file_get_file (current_file, &_inner_error_);
		cur_gfile = _tmp17_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (project);
			_g_object_unref0 (pm);
			_g_object_unref0 (current_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		if (cur_gfile == NULL) {
			_g_object_unref0 (cur_gfile);
			_g_object_unref0 (project);
			_g_object_unref0 (pm);
			_g_object_unref0 (current_file);
			return;
		}
		_tmp18_ = g_file_get_path (cur_gfile);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_collection_contains ((ValaCollection*) self->priv->current_sources, _tmp19_);
		_tmp21_ = !_tmp20_;
		_g_free0 (_tmp19_);
		if (_tmp21_) {
			g_cancellable_cancel (self->priv->cancel);
			{
				g_static_rec_mutex_lock (&self->priv->__lock_context);
				vala_plugin_init_context (self);
				vala_plugin_add_project_files (self);
				__finally3:
				g_static_rec_mutex_unlock (&self->priv->__lock_context);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (cur_gfile);
					_g_object_unref0 (project);
					_g_object_unref0 (pm);
					_g_object_unref0 (current_file);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			vala_plugin_parse (self);
		}
		_g_object_unref0 (cur_gfile);
	}
	if (self->current_editor != NULL) {
		if (IANJUTA_IS_EDITOR_ASSIST (self->current_editor)) {
			IAnjutaEditor* _tmp22_;
			_tmp22_ = self->current_editor;
			ianjuta_editor_assist_add (IANJUTA_IS_EDITOR_ASSIST (_tmp22_) ? ((IAnjutaEditorAssist*) _tmp22_) : NULL, (IAnjutaProvider*) self->priv->provider, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (project);
				_g_object_unref0 (pm);
				_g_object_unref0 (current_file);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (IANJUTA_IS_EDITOR_TIP (self->current_editor)) {
			g_signal_connect_object (self->current_editor, "char-added", (GCallback) _vala_plugin_on_char_added_ianjuta_editor_char_added, self, 0);
		}
		if (IANJUTA_IS_FILE_SAVABLE (self->current_editor)) {
			IAnjutaFileSavable* _tmp23_;
			IAnjutaFileSavable* file_savable;
			_tmp23_ = _g_object_ref0 (IANJUTA_FILE_SAVABLE (self->current_editor));
			file_savable = _tmp23_;
			g_signal_connect_object (file_savable, "saved", (GCallback) _vala_plugin_on_file_saved_ianjuta_file_savable_saved, self, 0);
			_g_object_unref0 (file_savable);
		}
		if (IANJUTA_IS_EDITOR_GLADE_SIGNAL (self->current_editor)) {
			IAnjutaEditor* _tmp24_;
			IAnjutaEditorGladeSignal* _tmp25_;
			IAnjutaEditorGladeSignal* gladesig;
			_tmp24_ = self->current_editor;
			_tmp25_ = _g_object_ref0 (IANJUTA_IS_EDITOR_GLADE_SIGNAL (_tmp24_) ? ((IAnjutaEditorGladeSignal*) _tmp24_) : NULL);
			gladesig = _tmp25_;
			g_signal_connect_object (gladesig, "drop-possible", (GCallback) _vala_plugin_on_drop_possible_ianjuta_editor_glade_signal_drop_possible, self, 0);
			g_signal_connect_object (gladesig, "drop", (GCallback) _vala_plugin_on_drop_ianjuta_editor_glade_signal_drop, self, 0);
			_g_object_unref0 (gladesig);
		}
	}
	anjuta_report_update_errors (self->priv->report, self->current_editor);
	_g_object_unref0 (project);
	_g_object_unref0 (pm);
	_g_object_unref0 (current_file);
}


void vala_plugin_editor_value_removed (ValaPlugin* self, AnjutaPlugin* plugin, const gchar* name) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin != NULL);
	g_return_if_fail (name != NULL);
	g_debug ("plugin.vala:226: editor value removed");
	if (IANJUTA_IS_EDITOR_ASSIST (self->current_editor)) {
		IAnjutaEditor* _tmp0_;
		_tmp0_ = self->current_editor;
		ianjuta_editor_assist_remove (IANJUTA_IS_EDITOR_ASSIST (_tmp0_) ? ((IAnjutaEditorAssist*) _tmp0_) : NULL, (IAnjutaProvider*) self->priv->provider, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (IANJUTA_IS_EDITOR_TIP (self->current_editor)) {
		guint _tmp1_;
		g_signal_parse_name ("char-added", IANJUTA_TYPE_EDITOR, &_tmp1_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (self->current_editor, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _vala_plugin_on_char_added_ianjuta_editor_char_added, self);
	}
	if (IANJUTA_IS_FILE_SAVABLE (self->current_editor)) {
		IAnjutaFileSavable* _tmp2_;
		IAnjutaFileSavable* file_savable;
		guint _tmp3_;
		_tmp2_ = _g_object_ref0 (IANJUTA_FILE_SAVABLE (self->current_editor));
		file_savable = _tmp2_;
		g_signal_parse_name ("saved", IANJUTA_TYPE_FILE_SAVABLE, &_tmp3_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (file_savable, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _vala_plugin_on_file_saved_ianjuta_file_savable_saved, self);
		_g_object_unref0 (file_savable);
	}
	if (IANJUTA_IS_EDITOR_GLADE_SIGNAL (self->current_editor)) {
		IAnjutaEditor* _tmp4_;
		IAnjutaEditorGladeSignal* _tmp5_;
		IAnjutaEditorGladeSignal* gladesig;
		guint _tmp6_;
		guint _tmp7_;
		_tmp4_ = self->current_editor;
		_tmp5_ = _g_object_ref0 (IANJUTA_IS_EDITOR_GLADE_SIGNAL (_tmp4_) ? ((IAnjutaEditorGladeSignal*) _tmp4_) : NULL);
		gladesig = _tmp5_;
		g_signal_parse_name ("drop-possible", IANJUTA_TYPE_EDITOR_GLADE_SIGNAL, &_tmp6_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (gladesig, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _vala_plugin_on_drop_possible_ianjuta_editor_glade_signal_drop_possible, self);
		g_signal_parse_name ("drop", IANJUTA_TYPE_EDITOR_GLADE_SIGNAL, &_tmp7_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (gladesig, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _vala_plugin_on_drop_ianjuta_editor_glade_signal_drop, self);
		_g_object_unref0 (gladesig);
	}
	self->current_editor = NULL;
}


void vala_plugin_on_file_saved (ValaPlugin* self, IAnjutaFileSavable* savable, GFile* file) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (savable != NULL);
	g_return_if_fail (file != NULL);
	{
		ValaList* _tmp0_ = NULL;
		ValaList* _source_file_list;
		gint _tmp1_;
		gint _source_file_size;
		gint _source_file_index;
		_tmp0_ = vala_code_context_get_source_files (self->priv->context);
		_source_file_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _source_file_list);
		_source_file_size = _tmp1_;
		_source_file_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			ValaSourceFile* source_file;
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			gboolean _tmp6_;
			gchar* contents = NULL;
			gchar* _tmp7_ = NULL;
			_source_file_index = _source_file_index + 1;
			if (!(_source_file_index < _source_file_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_source_file_list, _source_file_index);
			source_file = (ValaSourceFile*) _tmp2_;
			_tmp3_ = vala_source_file_get_filename (source_file);
			_tmp4_ = g_file_get_path (file);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strcmp0 (_tmp3_, _tmp5_) != 0;
			_g_free0 (_tmp5_);
			if (_tmp6_) {
				_vala_source_file_unref0 (source_file);
				continue;
			}
			g_file_load_contents (file, NULL, &_tmp7_, NULL, NULL, &_inner_error_);
			_g_free0 (contents);
			contents = _tmp7_;
			if (_inner_error_ != NULL) {
				goto __catch4_g_error;
			}
			vala_source_file_set_content (source_file, contents);
			vala_plugin_update_file (self, source_file);
			goto __finally4;
			__catch4_g_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (e);
			}
			__finally4:
			if (_inner_error_ != NULL) {
				_g_free0 (contents);
				_vala_source_file_unref0 (source_file);
				_vala_iterable_unref0 (_source_file_list);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_free0 (contents);
			_vala_source_file_unref0 (source_file);
			_vala_iterable_unref0 (_source_file_list);
			return;
		}
		_vala_iterable_unref0 (_source_file_list);
	}
}


void vala_plugin_on_char_added (ValaPlugin* self, IAnjutaEditor* editor, IAnjutaIterable* position, gchar ch) {
	gboolean _tmp0_;
	IAnjutaEditor* _tmp1_;
	IAnjutaEditorTip* _tmp2_;
	IAnjutaEditorTip* editortip;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editor != NULL);
	g_return_if_fail (position != NULL);
	_tmp0_ = g_settings_get_boolean (self->settings, VALA_PROVIDER_PREF_CALLTIP_ENABLE);
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = editor;
	_tmp2_ = _g_object_ref0 (IANJUTA_IS_EDITOR_TIP (_tmp1_) ? ((IAnjutaEditorTip*) _tmp1_) : NULL);
	editortip = _tmp2_;
	if (ch == '(') {
		vala_provider_show_call_tip (self->priv->provider, editortip);
	} else {
		if (ch == ')') {
			ianjuta_editor_tip_cancel (editortip, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (editortip);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_g_object_unref0 (editortip);
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = g_utf8_get_char (((gchar*) self) + index);
	result = _tmp0_;
	return result;
}


static ValaSymbol* vala_plugin_get_scope (ValaPlugin* self, IAnjutaEditor* editor, IAnjutaIterable* position) {
	ValaSymbol* result = NULL;
	gint depth;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (editor != NULL, NULL);
	g_return_val_if_fail (position != NULL, NULL);
	depth = 0;
	{
		gboolean _tmp0_;
		_tmp0_ = TRUE;
		while (TRUE) {
			IAnjutaIterable* _tmp3_;
			gchar* _tmp4_ = NULL;
			gchar* current_char;
			if (!_tmp0_) {
				gboolean _tmp1_;
				gboolean _tmp2_;
				_tmp1_ = ianjuta_iterable_previous (position, &_inner_error_);
				_tmp2_ = _tmp1_;
				if (_inner_error_ != NULL) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				if (!_tmp2_) {
					break;
				}
			}
			_tmp0_ = FALSE;
			_tmp3_ = position;
			_tmp4_ = ianjuta_editor_cell_get_character (IANJUTA_IS_EDITOR_CELL (_tmp3_) ? ((IAnjutaEditorCell*) _tmp3_) : NULL, &_inner_error_);
			current_char = _tmp4_;
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			if (g_strcmp0 (current_char, "}") == 0) {
				depth++;
			} else {
				if (g_strcmp0 (current_char, "{") == 0) {
					if (depth > 0) {
						depth--;
					} else {
						ValaSymbol* _tmp11_ = NULL;
						{
							gboolean _tmp5_;
							_tmp5_ = TRUE;
							while (TRUE) {
								IAnjutaIterable* _tmp8_;
								gchar* _tmp9_ = NULL;
								gchar* _tmp10_;
								if (!_tmp5_) {
									gunichar _tmp6_;
									gboolean _tmp7_;
									_tmp6_ = string_get_char (current_char, (glong) 0);
									_tmp7_ = g_unichar_isalnum (_tmp6_);
									if (!(!_tmp7_)) {
										break;
									}
								}
								_tmp5_ = FALSE;
								ianjuta_iterable_previous (position, &_inner_error_);
								if (_inner_error_ != NULL) {
									_g_free0 (current_char);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return NULL;
								}
								_tmp8_ = position;
								_tmp9_ = ianjuta_editor_cell_get_character (IANJUTA_IS_EDITOR_CELL (_tmp8_) ? ((IAnjutaEditorCell*) _tmp8_) : NULL, &_inner_error_);
								_tmp10_ = _tmp9_;
								if (_inner_error_ != NULL) {
									_g_free0 (current_char);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return NULL;
								}
								_g_free0 (current_char);
								current_char = _tmp10_;
							}
						}
						_tmp11_ = vala_plugin_get_current_context (self, editor, position);
						result = _tmp11_;
						_g_free0 (current_char);
						return result;
					}
				}
			}
			_g_free0 (current_char);
		}
	}
	result = NULL;
	return result;
}


gboolean vala_plugin_on_drop_possible (ValaPlugin* self, IAnjutaEditorGladeSignal* editor, IAnjutaIterable* position) {
	gboolean result = FALSE;
	gint _tmp0_;
	gint line;
	IAnjutaIterable* _tmp1_ = NULL;
	IAnjutaIterable* _tmp2_;
	IAnjutaIterable* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint column;
	IAnjutaIterable* _tmp6_ = NULL;
	IAnjutaIterable* _tmp7_;
	IAnjutaIterable* _tmp8_;
	ValaSymbol* _tmp9_ = NULL;
	ValaSymbol* _tmp10_;
	ValaSymbol* scope;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (editor != NULL, FALSE);
	g_return_val_if_fail (position != NULL, FALSE);
	_tmp0_ = ianjuta_editor_get_line_from_position ((IAnjutaEditor*) editor, position, &_inner_error_);
	line = _tmp0_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp1_ = ianjuta_editor_get_line_begin_position ((IAnjutaEditor*) editor, line, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp3_ = _tmp2_;
	_tmp4_ = ianjuta_iterable_diff (_tmp3_, position, &_inner_error_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	column = _tmp5_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	g_debug ("plugin.vala:300: line %d, column %d", line, column);
	_tmp6_ = ianjuta_iterable_clone (position, &_inner_error_);
	_tmp7_ = _tmp6_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_plugin_get_scope (self, (IAnjutaEditor*) editor, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	scope = _tmp10_;
	if (scope != NULL) {
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		_tmp11_ = vala_symbol_get_full_name (scope);
		_tmp12_ = _tmp11_;
		g_debug ("plugin.vala:304: drag is inside %s", _tmp12_);
		_g_free0 (_tmp12_);
	}
	if (scope == NULL) {
		_tmp14_ = TRUE;
	} else {
		_tmp14_ = VALA_IS_NAMESPACE (scope);
	}
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		_tmp13_ = VALA_IS_CLASS (scope);
	}
	if (_tmp13_) {
		result = TRUE;
		_vala_code_node_unref0 (scope);
		return result;
	}
	result = FALSE;
	_vala_code_node_unref0 (scope);
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	regex = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch5_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch5_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally5;
	__catch5_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static void _vala_code_node_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL));
}


static void _g_list_free__vala_code_node_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _vala_code_node_unref0_, NULL);
	g_list_free (self);
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_plugin_on_drop (ValaPlugin* self, IAnjutaEditorGladeSignal* editor, IAnjutaIterable* position, const gchar* signal_data) {
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** data;
	gint data_length1;
	gint _data_size_;
	gchar* _tmp2_;
	gchar* widget_name;
	gchar* _tmp3_ = NULL;
	gchar* signal_name;
	gchar* _tmp4_;
	gchar* handler_name;
	gboolean swapped;
	IAnjutaIterable* _tmp5_ = NULL;
	IAnjutaIterable* _tmp6_;
	IAnjutaIterable* _tmp7_;
	ValaSymbol* _tmp8_ = NULL;
	ValaSymbol* _tmp9_;
	ValaSymbol* scope;
	GString* _tmp10_ = NULL;
	GString* builder;
	gchar* _tmp11_;
	gchar* scope_prefix;
	gchar* _tmp16_;
	gchar* handler_cname;
	gboolean _tmp17_ = FALSE;
	ValaNamespace* _tmp18_ = NULL;
	ValaSymbol* _tmp19_ = NULL;
	ValaSymbol* widget;
	GList* _tmp20_ = NULL;
	GList* sigs;
	gboolean _tmp21_ = FALSE;
	ValaSignal* _tmp22_;
	ValaSignal* sig;
	AnjutaShell* _tmp43_ = NULL;
	AnjutaShell* _tmp44_;
	GObject* _tmp45_ = NULL;
	GObject* _tmp46_;
	GObject* _tmp47_;
	GObject* _tmp48_;
	IAnjutaIndenter* _tmp49_;
	IAnjutaIndenter* indenter;
	gint _tmp54_;
	gint _tmp55_;
	IAnjutaIterable* _tmp56_ = NULL;
	IAnjutaIterable* inside;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editor != NULL);
	g_return_if_fail (position != NULL);
	g_return_if_fail (signal_data != NULL);
	_tmp1_ = _tmp0_ = g_strsplit (signal_data, ":", 0);
	data = _tmp1_;
	data_length1 = _vala_array_length (_tmp0_);
	_data_size_ = _vala_array_length (_tmp0_);
	_tmp2_ = g_strdup (data[0]);
	widget_name = _tmp2_;
	_tmp3_ = string_replace (data[1], "-", "_");
	signal_name = _tmp3_;
	_tmp4_ = g_strdup (data[2]);
	handler_name = _tmp4_;
	swapped = g_strcmp0 (data[4], "1") == 0;
	_tmp5_ = ianjuta_iterable_clone (position, &_inner_error_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		_g_free0 (handler_name);
		_g_free0 (signal_name);
		_g_free0 (widget_name);
		data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_plugin_get_scope (self, (IAnjutaEditor*) editor, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp7_);
	scope = _tmp9_;
	_tmp10_ = g_string_new ("");
	builder = _tmp10_;
	_tmp11_ = g_strdup ("");
	scope_prefix = _tmp11_;
	if (scope != NULL) {
		gchar* _tmp12_ = NULL;
		gboolean _tmp13_;
		_tmp12_ = vala_symbol_get_lower_case_cprefix (scope);
		_g_free0 (scope_prefix);
		scope_prefix = _tmp12_;
		_tmp13_ = g_str_has_prefix (handler_name, scope_prefix);
		if (_tmp13_) {
			gint _tmp14_;
			gchar* _tmp15_ = NULL;
			_tmp14_ = strlen (scope_prefix);
			_tmp15_ = string_substring (handler_name, (glong) _tmp14_, (glong) (-1));
			_g_free0 (handler_name);
			handler_name = _tmp15_;
		}
	}
	_tmp16_ = g_strconcat (scope_prefix, handler_name, NULL);
	handler_cname = _tmp16_;
	if (g_strcmp0 (data[2], handler_cname) != 0) {
		_tmp17_ = !swapped;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		g_string_append_printf (builder, "[CCode (cname=\"%s\", instance_pos=-1)]\n", data[2]);
	} else {
		if (g_strcmp0 (data[2], handler_cname) != 0) {
			g_string_append_printf (builder, "[CCode (cname=\"%s\")]\n", data[2]);
		} else {
			if (!swapped) {
				g_string_append (builder, "[CCode (instance_pos=-1)]\n");
			}
		}
	}
	_tmp18_ = vala_code_context_get_root (self->priv->context);
	_tmp19_ = vala_plugin_lookup_symbol_by_cname (self, widget_name, (ValaSymbol*) _tmp18_);
	widget = _tmp19_;
	_tmp20_ = vala_plugin_symbol_lookup_inherited (self, widget, signal_name, FALSE, FALSE);
	sigs = _tmp20_;
	if (sigs == NULL) {
		_tmp21_ = TRUE;
	} else {
		_tmp21_ = !VALA_IS_SIGNAL ((ValaSymbol*) sigs->data);
	}
	if (_tmp21_) {
		__g_list_free__vala_code_node_unref0_0 (sigs);
		_vala_code_node_unref0 (widget);
		_g_free0 (handler_cname);
		_g_free0 (scope_prefix);
		_g_string_free0 (builder);
		_vala_code_node_unref0 (scope);
		_g_free0 (handler_name);
		_g_free0 (signal_name);
		_g_free0 (widget_name);
		data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp22_ = _vala_code_node_ref0 (VALA_SIGNAL ((ValaSymbol*) sigs->data));
	sig = _tmp22_;
	g_string_append_printf (builder, "public void %s (", handler_name);
	if (swapped) {
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_;
		_tmp23_ = vala_symbol_get_full_name (widget);
		_tmp24_ = _tmp23_;
		g_string_append_printf (builder, "%s sender", _tmp24_);
		_g_free0 (_tmp24_);
		{
			ValaList* _tmp25_ = NULL;
			ValaList* _param_list;
			gint _tmp26_;
			gint _param_size;
			gint _param_index;
			_tmp25_ = vala_signal_get_parameters (sig);
			_param_list = _tmp25_;
			_tmp26_ = vala_collection_get_size ((ValaCollection*) _param_list);
			_param_size = _tmp26_;
			_param_index = -1;
			while (TRUE) {
				gpointer _tmp27_ = NULL;
				ValaParameter* param;
				ValaDataType* _tmp28_ = NULL;
				ValaTypeSymbol* _tmp29_ = NULL;
				gchar* _tmp30_ = NULL;
				gchar* _tmp31_;
				const gchar* _tmp32_ = NULL;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp27_ = vala_list_get (_param_list, _param_index);
				param = (ValaParameter*) _tmp27_;
				_tmp28_ = vala_variable_get_variable_type ((ValaVariable*) param);
				_tmp29_ = vala_data_type_get_data_type (_tmp28_);
				_tmp30_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = vala_symbol_get_name ((ValaSymbol*) param);
				g_string_append_printf (builder, ", %s %s", _tmp31_, _tmp32_);
				_g_free0 (_tmp31_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
	} else {
		gchar* _tmp41_ = NULL;
		gchar* _tmp42_;
		{
			ValaList* _tmp33_ = NULL;
			ValaList* _param_list;
			gint _tmp34_;
			gint _param_size;
			gint _param_index;
			_tmp33_ = vala_signal_get_parameters (sig);
			_param_list = _tmp33_;
			_tmp34_ = vala_collection_get_size ((ValaCollection*) _param_list);
			_param_size = _tmp34_;
			_param_index = -1;
			while (TRUE) {
				gpointer _tmp35_ = NULL;
				ValaParameter* param;
				ValaDataType* _tmp36_ = NULL;
				ValaTypeSymbol* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				gchar* _tmp39_;
				const gchar* _tmp40_ = NULL;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp35_ = vala_list_get (_param_list, _param_index);
				param = (ValaParameter*) _tmp35_;
				_tmp36_ = vala_variable_get_variable_type ((ValaVariable*) param);
				_tmp37_ = vala_data_type_get_data_type (_tmp36_);
				_tmp38_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = vala_symbol_get_name ((ValaSymbol*) param);
				g_string_append_printf (builder, "%s %s, ", _tmp39_, _tmp40_);
				_g_free0 (_tmp39_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp41_ = vala_symbol_get_full_name (widget);
		_tmp42_ = _tmp41_;
		g_string_append_printf (builder, "%s sender", _tmp42_);
		_g_free0 (_tmp42_);
	}
	g_string_append_printf (builder, ") {\n\n}\n");
	ianjuta_editor_insert ((IAnjutaEditor*) editor, position, builder->str, -1, &_inner_error_);
	if (_inner_error_ != NULL) {
		_vala_code_node_unref0 (sig);
		__g_list_free__vala_code_node_unref0_0 (sigs);
		_vala_code_node_unref0 (widget);
		_g_free0 (handler_cname);
		_g_free0 (scope_prefix);
		_g_string_free0 (builder);
		_vala_code_node_unref0 (scope);
		_g_free0 (handler_name);
		_g_free0 (signal_name);
		_g_free0 (widget_name);
		data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_object_get ((AnjutaPlugin*) self, "shell", &_tmp43_, NULL);
	_tmp44_ = _tmp43_;
	_tmp45_ = anjuta_shell_get_object (_tmp44_, "IAnjutaIndenter", &_inner_error_);
	_tmp46_ = _tmp45_;
	_g_object_unref0 (_tmp44_);
	_tmp47_ = _tmp46_;
	if (_inner_error_ != NULL) {
		_vala_code_node_unref0 (sig);
		__g_list_free__vala_code_node_unref0_0 (sigs);
		_vala_code_node_unref0 (widget);
		_g_free0 (handler_cname);
		_g_free0 (scope_prefix);
		_g_string_free0 (builder);
		_vala_code_node_unref0 (scope);
		_g_free0 (handler_name);
		_g_free0 (signal_name);
		_g_free0 (widget_name);
		data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp48_ = _tmp47_;
	_tmp49_ = _g_object_ref0 (IANJUTA_IS_INDENTER (_tmp48_) ? ((IAnjutaIndenter*) _tmp48_) : NULL);
	indenter = _tmp49_;
	if (indenter != NULL) {
		IAnjutaIterable* _tmp50_ = NULL;
		IAnjutaIterable* end;
		gint _tmp51_;
		gint _tmp52_;
		gint _tmp53_;
		_tmp50_ = ianjuta_iterable_clone (position, &_inner_error_);
		end = _tmp50_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (indenter);
			_vala_code_node_unref0 (sig);
			__g_list_free__vala_code_node_unref0_0 (sigs);
			_vala_code_node_unref0 (widget);
			_g_free0 (handler_cname);
			_g_free0 (scope_prefix);
			_g_string_free0 (builder);
			_vala_code_node_unref0 (scope);
			_g_free0 (handler_name);
			_g_free0 (signal_name);
			_g_free0 (widget_name);
			data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp51_ = ianjuta_iterable_get_position (end, &_inner_error_);
		_tmp52_ = _tmp51_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (end);
			_g_object_unref0 (indenter);
			_vala_code_node_unref0 (sig);
			__g_list_free__vala_code_node_unref0_0 (sigs);
			_vala_code_node_unref0 (widget);
			_g_free0 (handler_cname);
			_g_free0 (scope_prefix);
			_g_string_free0 (builder);
			_vala_code_node_unref0 (scope);
			_g_free0 (handler_name);
			_g_free0 (signal_name);
			_g_free0 (widget_name);
			data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp53_ = g_utf8_strlen (builder->str, (gssize) (-1));
		ianjuta_iterable_set_position (end, (_tmp52_ + _tmp53_) - 1, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (end);
			_g_object_unref0 (indenter);
			_vala_code_node_unref0 (sig);
			__g_list_free__vala_code_node_unref0_0 (sigs);
			_vala_code_node_unref0 (widget);
			_g_free0 (handler_cname);
			_g_free0 (scope_prefix);
			_g_string_free0 (builder);
			_vala_code_node_unref0 (scope);
			_g_free0 (handler_name);
			_g_free0 (signal_name);
			_g_free0 (widget_name);
			data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		ianjuta_indenter_indent (indenter, position, end, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (end);
			_g_object_unref0 (indenter);
			_vala_code_node_unref0 (sig);
			__g_list_free__vala_code_node_unref0_0 (sigs);
			_vala_code_node_unref0 (widget);
			_g_free0 (handler_cname);
			_g_free0 (scope_prefix);
			_g_string_free0 (builder);
			_vala_code_node_unref0 (scope);
			_g_free0 (handler_name);
			_g_free0 (signal_name);
			_g_free0 (widget_name);
			data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (end);
	}
	_tmp54_ = ianjuta_editor_get_line_from_position ((IAnjutaEditor*) editor, position, &_inner_error_);
	_tmp55_ = _tmp54_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (indenter);
		_vala_code_node_unref0 (sig);
		__g_list_free__vala_code_node_unref0_0 (sigs);
		_vala_code_node_unref0 (widget);
		_g_free0 (handler_cname);
		_g_free0 (scope_prefix);
		_g_string_free0 (builder);
		_vala_code_node_unref0 (scope);
		_g_free0 (handler_name);
		_g_free0 (signal_name);
		_g_free0 (widget_name);
		data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp56_ = ianjuta_editor_get_line_end_position ((IAnjutaEditor*) editor, _tmp55_ + 2, &_inner_error_);
	inside = _tmp56_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (indenter);
		_vala_code_node_unref0 (sig);
		__g_list_free__vala_code_node_unref0_0 (sigs);
		_vala_code_node_unref0 (widget);
		_g_free0 (handler_cname);
		_g_free0 (scope_prefix);
		_g_string_free0 (builder);
		_vala_code_node_unref0 (scope);
		_g_free0 (handler_name);
		_g_free0 (signal_name);
		_g_free0 (widget_name);
		data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	ianjuta_editor_goto_position ((IAnjutaEditor*) editor, inside, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (inside);
		_g_object_unref0 (indenter);
		_vala_code_node_unref0 (sig);
		__g_list_free__vala_code_node_unref0_0 (sigs);
		_vala_code_node_unref0 (widget);
		_g_free0 (handler_cname);
		_g_free0 (scope_prefix);
		_g_string_free0 (builder);
		_vala_code_node_unref0 (scope);
		_g_free0 (handler_name);
		_g_free0 (signal_name);
		_g_free0 (widget_name);
		data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (indenter != NULL) {
		ianjuta_indenter_indent (indenter, inside, inside, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (inside);
			_g_object_unref0 (indenter);
			_vala_code_node_unref0 (sig);
			__g_list_free__vala_code_node_unref0_0 (sigs);
			_vala_code_node_unref0 (widget);
			_g_free0 (handler_cname);
			_g_free0 (scope_prefix);
			_g_string_free0 (builder);
			_vala_code_node_unref0 (scope);
			_g_free0 (handler_name);
			_g_free0 (signal_name);
			_g_free0 (widget_name);
			data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (inside);
	_g_object_unref0 (indenter);
	_vala_code_node_unref0 (sig);
	__g_list_free__vala_code_node_unref0_0 (sigs);
	_vala_code_node_unref0 (widget);
	_g_free0 (handler_cname);
	_g_free0 (scope_prefix);
	_g_string_free0 (builder);
	_vala_code_node_unref0 (scope);
	_g_free0 (handler_name);
	_g_free0 (signal_name);
	_g_free0 (widget_name);
	data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
}


static ValaSymbol* vala_plugin_lookup_symbol_by_cname (ValaPlugin* self, const gchar* cname, ValaSymbol* parent) {
	ValaSymbol* result = NULL;
	ValaScope* _tmp0_ = NULL;
	ValaSymbol* _tmp1_ = NULL;
	ValaSymbol* sym;
	ValaScope* _tmp2_ = NULL;
	ValaMap* _tmp3_ = NULL;
	ValaMap* symtab;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cname != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	_tmp0_ = vala_symbol_get_scope (parent);
	_tmp1_ = vala_scope_lookup (_tmp0_, cname);
	sym = _tmp1_;
	if (sym != NULL) {
		result = sym;
		return result;
	}
	_tmp2_ = vala_symbol_get_scope (parent);
	_tmp3_ = vala_scope_get_symbol_table (_tmp2_);
	symtab = _tmp3_;
	{
		ValaSet* _tmp4_ = NULL;
		ValaSet* _tmp5_;
		ValaIterator* _tmp6_ = NULL;
		ValaIterator* _tmp7_;
		ValaIterator* _name_it;
		_tmp4_ = vala_map_get_keys (symtab);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_iterable_iterator ((ValaIterable*) _tmp5_);
		_tmp7_ = _tmp6_;
		_vala_iterable_unref0 (_tmp5_);
		_name_it = _tmp7_;
		while (TRUE) {
			gboolean _tmp8_;
			gpointer _tmp9_ = NULL;
			gchar* name;
			gboolean _tmp10_;
			_tmp8_ = vala_iterator_next (_name_it);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = vala_iterator_get (_name_it);
			name = (gchar*) _tmp9_;
			_tmp10_ = g_str_has_prefix (cname, name);
			if (_tmp10_) {
				gint _tmp11_;
				gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				ValaScope* _tmp14_ = NULL;
				ValaSymbol* _tmp15_ = NULL;
				ValaSymbol* _tmp16_;
				ValaSymbol* _tmp17_ = NULL;
				ValaSymbol* _tmp18_;
				_tmp11_ = strlen (name);
				_tmp12_ = string_substring (cname, (glong) _tmp11_, (glong) (-1));
				_tmp13_ = _tmp12_;
				_tmp14_ = vala_symbol_get_scope (parent);
				_tmp15_ = vala_scope_lookup (_tmp14_, name);
				_tmp16_ = _tmp15_;
				_tmp17_ = vala_plugin_lookup_symbol_by_cname (self, _tmp13_, _tmp16_);
				_tmp18_ = _tmp17_;
				_vala_code_node_unref0 (_tmp16_);
				_g_free0 (_tmp13_);
				result = _tmp18_;
				_g_free0 (name);
				_vala_iterator_unref0 (_name_it);
				_vala_map_unref0 (symtab);
				_vala_code_node_unref0 (sym);
				return result;
			}
			_g_free0 (name);
		}
		_vala_iterator_unref0 (_name_it);
	}
	result = NULL;
	_vala_map_unref0 (symtab);
	_vala_code_node_unref0 (sym);
	return result;
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


ValaSymbol* vala_plugin_get_current_context (ValaPlugin* self, IAnjutaEditor* editor, IAnjutaIterable* position) {
	ValaSymbol* result = NULL;
	IAnjutaEditor* _tmp0_;
	IAnjutaFile* _tmp1_;
	IAnjutaFile* file;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* path;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (editor != NULL, NULL);
	g_return_val_if_fail (IANJUTA_IS_FILE (editor), NULL);
	_tmp0_ = editor;
	_tmp1_ = _g_object_ref0 (IANJUTA_IS_FILE (_tmp0_) ? ((IAnjutaFile*) _tmp0_) : NULL);
	file = _tmp1_;
	_tmp2_ = ianjuta_file_get_file (file, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_get_path (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	path = _tmp6_;
	{
		ValaSourceFile* source;
		gint line = 0;
		gint column = 0;
		ValaSymbol* _tmp27_ = NULL;
		g_static_rec_mutex_lock (&self->priv->__lock_context);
		source = NULL;
		{
			ValaList* _tmp7_ = NULL;
			ValaList* _src_list;
			gint _tmp8_;
			gint _src_size;
			gint _src_index;
			_tmp7_ = vala_code_context_get_source_files (self->priv->context);
			_src_list = _tmp7_;
			_tmp8_ = vala_collection_get_size ((ValaCollection*) _src_list);
			_src_size = _tmp8_;
			_src_index = -1;
			while (TRUE) {
				gpointer _tmp9_ = NULL;
				ValaSourceFile* src;
				const gchar* _tmp10_ = NULL;
				_src_index = _src_index + 1;
				if (!(_src_index < _src_size)) {
					break;
				}
				_tmp9_ = vala_list_get (_src_list, _src_index);
				src = (ValaSourceFile*) _tmp9_;
				_tmp10_ = vala_source_file_get_filename (src);
				if (g_strcmp0 (_tmp10_, path) == 0) {
					ValaSourceFile* _tmp11_;
					_tmp11_ = _vala_source_file_ref0 (src);
					_vala_source_file_unref0 (source);
					source = _tmp11_;
					_vala_source_file_unref0 (src);
					break;
				}
				_vala_source_file_unref0 (src);
			}
			_vala_iterable_unref0 (_src_list);
		}
		if (source == NULL) {
			ValaSourceFileType _tmp12_ = 0;
			gboolean _tmp13_;
			ValaSourceFile* _tmp14_ = NULL;
			_tmp13_ = g_str_has_suffix (path, "vapi");
			if (_tmp13_) {
				_tmp12_ = VALA_SOURCE_FILE_TYPE_PACKAGE;
			} else {
				_tmp12_ = VALA_SOURCE_FILE_TYPE_SOURCE;
			}
			_tmp14_ = vala_source_file_new (self->priv->context, _tmp12_, path, NULL);
			_vala_source_file_unref0 (source);
			source = _tmp14_;
			vala_code_context_add_source_file (self->priv->context, source);
			vala_plugin_update_file (self, source);
		}
		if (position == NULL) {
			gint _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			_tmp15_ = ianjuta_editor_get_lineno (editor, &_inner_error_);
			_tmp16_ = _tmp15_;
			if (_inner_error_ != NULL) {
				_vala_source_file_unref0 (source);
				goto __finally6;
			}
			line = _tmp16_;
			_tmp17_ = ianjuta_editor_get_column (editor, &_inner_error_);
			_tmp18_ = _tmp17_;
			if (_inner_error_ != NULL) {
				_vala_source_file_unref0 (source);
				goto __finally6;
			}
			column = _tmp18_;
		} else {
			gint _tmp19_;
			gint _tmp20_;
			IAnjutaIterable* _tmp21_ = NULL;
			IAnjutaIterable* _tmp22_;
			IAnjutaIterable* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			_tmp19_ = ianjuta_editor_get_line_from_position (editor, position, &_inner_error_);
			_tmp20_ = _tmp19_;
			if (_inner_error_ != NULL) {
				_vala_source_file_unref0 (source);
				goto __finally6;
			}
			line = _tmp20_;
			_tmp21_ = ianjuta_editor_get_line_begin_position (editor, line, &_inner_error_);
			_tmp22_ = _tmp21_;
			if (_inner_error_ != NULL) {
				_vala_source_file_unref0 (source);
				goto __finally6;
			}
			_tmp23_ = _tmp22_;
			_tmp24_ = ianjuta_iterable_diff (_tmp23_, position, &_inner_error_);
			_tmp25_ = _tmp24_;
			_g_object_unref0 (_tmp23_);
			_tmp26_ = _tmp25_;
			if (_inner_error_ != NULL) {
				_vala_source_file_unref0 (source);
				goto __finally6;
			}
			column = _tmp26_;
		}
		_tmp27_ = block_locator_locate (self->priv->locator, source, line, column);
		result = _tmp27_;
		g_static_rec_mutex_unlock (&self->priv->__lock_context);
		_vala_source_file_unref0 (source);
		_g_free0 (path);
		_g_object_unref0 (file);
		return result;
		_vala_source_file_unref0 (source);
		__finally6:
		g_static_rec_mutex_unlock (&self->priv->__lock_context);
		_g_free0 (path);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (path);
	_g_object_unref0 (file);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


GList* vala_plugin_lookup_symbol (ValaPlugin* self, ValaExpression* inner, const gchar* name, gboolean prefix_match, ValaBlock* block) {
	GList* result = NULL;
	GList* matching_symbols;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (block != NULL, NULL);
	matching_symbols = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_context);
		if (inner == NULL) {
			{
				ValaSymbol* _tmp0_;
				ValaSymbol* sym;
				_tmp0_ = _vala_code_node_ref0 (VALA_SYMBOL (block));
				sym = _tmp0_;
				{
					gboolean _tmp1_;
					_tmp1_ = TRUE;
					while (TRUE) {
						GList* _tmp4_ = NULL;
						if (!_tmp1_) {
							ValaSymbol* _tmp2_ = NULL;
							ValaSymbol* _tmp3_;
							_tmp2_ = vala_symbol_get_parent_symbol (sym);
							_tmp3_ = _vala_code_node_ref0 (_tmp2_);
							_vala_code_node_unref0 (sym);
							sym = _tmp3_;
						}
						_tmp1_ = FALSE;
						if (!(sym != NULL)) {
							break;
						}
						_tmp4_ = vala_plugin_symbol_lookup_inherited (self, sym, name, prefix_match, FALSE);
						matching_symbols = g_list_concat (matching_symbols, _tmp4_);
					}
				}
				_vala_code_node_unref0 (sym);
			}
			{
				ValaSourceReference* _tmp5_ = NULL;
				ValaSourceFile* _tmp6_ = NULL;
				ValaList* _tmp7_ = NULL;
				ValaList* _tmp8_;
				ValaList* _ns_list;
				gint _tmp9_;
				gint _ns_size;
				gint _ns_index;
				_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) block);
				_tmp6_ = vala_source_reference_get_file (_tmp5_);
				_tmp7_ = vala_source_file_get_current_using_directives (_tmp6_);
				_tmp8_ = _vala_iterable_ref0 (_tmp7_);
				_ns_list = _tmp8_;
				_tmp9_ = vala_collection_get_size ((ValaCollection*) _ns_list);
				_ns_size = _tmp9_;
				_ns_index = -1;
				while (TRUE) {
					gpointer _tmp10_ = NULL;
					ValaUsingDirective* ns;
					ValaSymbol* _tmp11_ = NULL;
					GList* _tmp12_ = NULL;
					_ns_index = _ns_index + 1;
					if (!(_ns_index < _ns_size)) {
						break;
					}
					_tmp10_ = vala_list_get (_ns_list, _ns_index);
					ns = (ValaUsingDirective*) _tmp10_;
					_tmp11_ = vala_using_directive_get_namespace_symbol (ns);
					_tmp12_ = vala_plugin_symbol_lookup_inherited (self, _tmp11_, name, prefix_match, FALSE);
					matching_symbols = g_list_concat (matching_symbols, _tmp12_);
					_vala_code_node_unref0 (ns);
				}
				_vala_iterable_unref0 (_ns_list);
			}
		} else {
			ValaSymbol* _tmp13_ = NULL;
			_tmp13_ = vala_expression_get_symbol_reference (inner);
			if (_tmp13_ != NULL) {
				ValaSymbol* _tmp14_ = NULL;
				GList* _tmp15_ = NULL;
				_tmp14_ = vala_expression_get_symbol_reference (inner);
				_tmp15_ = vala_plugin_symbol_lookup_inherited (self, _tmp14_, name, prefix_match, FALSE);
				matching_symbols = g_list_concat (matching_symbols, _tmp15_);
			} else {
				if (VALA_IS_MEMBER_ACCESS (inner)) {
					ValaMemberAccess* _tmp16_;
					ValaMemberAccess* inner_ma;
					ValaExpression* _tmp17_ = NULL;
					const gchar* _tmp18_ = NULL;
					GList* _tmp19_ = NULL;
					GList* matching;
					_tmp16_ = _vala_code_node_ref0 (VALA_MEMBER_ACCESS (inner));
					inner_ma = _tmp16_;
					_tmp17_ = vala_member_access_get_inner (inner_ma);
					_tmp18_ = vala_member_access_get_member_name (inner_ma);
					_tmp19_ = vala_plugin_lookup_symbol (self, _tmp17_, _tmp18_, FALSE, block);
					matching = _tmp19_;
					if (matching != NULL) {
						GList* _tmp20_ = NULL;
						_tmp20_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) matching->data, name, prefix_match, FALSE);
						matching_symbols = g_list_concat (matching_symbols, _tmp20_);
					}
					__g_list_free__vala_code_node_unref0_0 (matching);
					_vala_code_node_unref0 (inner_ma);
				} else {
					if (VALA_IS_METHOD_CALL (inner)) {
						ValaMethodCall* _tmp21_;
						ValaMethodCall* inner_inv;
						ValaExpression* _tmp22_ = NULL;
						ValaExpression* _tmp23_;
						ValaMemberAccess* _tmp24_;
						ValaMemberAccess* inner_ma;
						_tmp21_ = _vala_code_node_ref0 (VALA_METHOD_CALL (inner));
						inner_inv = _tmp21_;
						_tmp22_ = vala_method_call_get_call (inner_inv);
						_tmp23_ = _tmp22_;
						_tmp24_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp23_) ? ((ValaMemberAccess*) _tmp23_) : NULL);
						inner_ma = _tmp24_;
						if (inner_ma != NULL) {
							ValaExpression* _tmp25_ = NULL;
							const gchar* _tmp26_ = NULL;
							GList* _tmp27_ = NULL;
							GList* matching;
							_tmp25_ = vala_member_access_get_inner (inner_ma);
							_tmp26_ = vala_member_access_get_member_name (inner_ma);
							_tmp27_ = vala_plugin_lookup_symbol (self, _tmp25_, _tmp26_, FALSE, block);
							matching = _tmp27_;
							if (matching != NULL) {
								GList* _tmp28_ = NULL;
								_tmp28_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) matching->data, name, prefix_match, TRUE);
								matching_symbols = g_list_concat (matching_symbols, _tmp28_);
							}
							__g_list_free__vala_code_node_unref0_0 (matching);
						}
						_vala_code_node_unref0 (inner_ma);
						_vala_code_node_unref0 (inner_inv);
					}
				}
			}
		}
		__finally7:
		g_static_rec_mutex_unlock (&self->priv->__lock_context);
		if (_inner_error_ != NULL) {
			__g_list_free__vala_code_node_unref0_0 (matching_symbols);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = matching_symbols;
	return result;
}


static GList* vala_plugin_symbol_lookup_inherited (ValaPlugin* self, ValaSymbol* sym, const gchar* name, gboolean prefix_match, gboolean invocation) {
	GList* result = NULL;
	GList* _result_;
	ValaScope* _tmp0_ = NULL;
	ValaMap* _tmp1_ = NULL;
	ValaMap* symbol_table;
	gboolean _tmp12_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_result_ = NULL;
	if (sym == NULL) {
		result = _result_;
		return result;
	}
	_tmp0_ = vala_symbol_get_scope (sym);
	_tmp1_ = vala_scope_get_symbol_table (_tmp0_);
	symbol_table = _tmp1_;
	if (symbol_table != NULL) {
		{
			ValaSet* _tmp2_ = NULL;
			ValaSet* _tmp3_;
			ValaIterator* _tmp4_ = NULL;
			ValaIterator* _tmp5_;
			ValaIterator* _key_it;
			_tmp2_ = vala_map_get_keys (symbol_table);
			_tmp3_ = _tmp2_;
			_tmp4_ = vala_iterable_iterator ((ValaIterable*) _tmp3_);
			_tmp5_ = _tmp4_;
			_vala_iterable_unref0 (_tmp3_);
			_key_it = _tmp5_;
			while (TRUE) {
				gboolean _tmp6_;
				gpointer _tmp7_ = NULL;
				gchar* key;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				_tmp6_ = vala_iterator_next (_key_it);
				if (!_tmp6_) {
					break;
				}
				_tmp7_ = vala_iterator_get (_key_it);
				key = (gchar*) _tmp7_;
				if (prefix_match) {
					gboolean _tmp10_;
					_tmp10_ = g_str_has_prefix (key, name);
					_tmp9_ = _tmp10_;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					_tmp8_ = TRUE;
				} else {
					_tmp8_ = g_strcmp0 (key, name) == 0;
				}
				if (_tmp8_) {
					gpointer _tmp11_ = NULL;
					_tmp11_ = vala_map_get (symbol_table, key);
					_result_ = g_list_append (_result_, (ValaSymbol*) _tmp11_);
				}
				_g_free0 (key);
			}
			_vala_iterator_unref0 (_key_it);
		}
	}
	if (invocation) {
		_tmp12_ = VALA_IS_METHOD (sym);
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		ValaMethod* _tmp13_;
		ValaMethod* func;
		ValaDataType* _tmp14_ = NULL;
		ValaTypeSymbol* _tmp15_ = NULL;
		GList* _tmp16_ = NULL;
		_tmp13_ = _vala_code_node_ref0 (VALA_METHOD (sym));
		func = _tmp13_;
		_tmp14_ = vala_method_get_return_type (func);
		_tmp15_ = vala_data_type_get_data_type (_tmp14_);
		_tmp16_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp15_, name, prefix_match, FALSE);
		_result_ = g_list_concat (_result_, _tmp16_);
		_vala_code_node_unref0 (func);
	} else {
		if (VALA_IS_CLASS (sym)) {
			ValaClass* _tmp17_;
			ValaClass* cl;
			_tmp17_ = _vala_code_node_ref0 (VALA_CLASS (sym));
			cl = _tmp17_;
			{
				ValaList* _tmp18_ = NULL;
				ValaList* _base_type_list;
				gint _tmp19_;
				gint _base_type_size;
				gint _base_type_index;
				_tmp18_ = vala_class_get_base_types (cl);
				_base_type_list = _tmp18_;
				_tmp19_ = vala_collection_get_size ((ValaCollection*) _base_type_list);
				_base_type_size = _tmp19_;
				_base_type_index = -1;
				while (TRUE) {
					gpointer _tmp20_ = NULL;
					ValaDataType* base_type;
					ValaTypeSymbol* _tmp21_ = NULL;
					GList* _tmp22_ = NULL;
					_base_type_index = _base_type_index + 1;
					if (!(_base_type_index < _base_type_size)) {
						break;
					}
					_tmp20_ = vala_list_get (_base_type_list, _base_type_index);
					base_type = (ValaDataType*) _tmp20_;
					_tmp21_ = vala_data_type_get_data_type (base_type);
					_tmp22_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp21_, name, prefix_match, FALSE);
					_result_ = g_list_concat (_result_, _tmp22_);
					_vala_code_node_unref0 (base_type);
				}
				_vala_iterable_unref0 (_base_type_list);
			}
			_vala_code_node_unref0 (cl);
		} else {
			if (VALA_IS_STRUCT (sym)) {
				ValaStruct* _tmp23_;
				ValaStruct* st;
				ValaDataType* _tmp24_ = NULL;
				ValaTypeSymbol* _tmp25_ = NULL;
				GList* _tmp26_ = NULL;
				_tmp23_ = _vala_code_node_ref0 (VALA_STRUCT (sym));
				st = _tmp23_;
				_tmp24_ = vala_struct_get_base_type (st);
				_tmp25_ = vala_data_type_get_data_type (_tmp24_);
				_tmp26_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp25_, name, prefix_match, FALSE);
				_result_ = g_list_concat (_result_, _tmp26_);
				_vala_code_node_unref0 (st);
			} else {
				if (VALA_IS_INTERFACE (sym)) {
					ValaInterface* _tmp27_;
					ValaInterface* iface;
					_tmp27_ = _vala_code_node_ref0 (VALA_INTERFACE (sym));
					iface = _tmp27_;
					{
						ValaList* _tmp28_ = NULL;
						ValaList* _prerequisite_list;
						gint _tmp29_;
						gint _prerequisite_size;
						gint _prerequisite_index;
						_tmp28_ = vala_interface_get_prerequisites (iface);
						_prerequisite_list = _tmp28_;
						_tmp29_ = vala_collection_get_size ((ValaCollection*) _prerequisite_list);
						_prerequisite_size = _tmp29_;
						_prerequisite_index = -1;
						while (TRUE) {
							gpointer _tmp30_ = NULL;
							ValaDataType* prerequisite;
							ValaTypeSymbol* _tmp31_ = NULL;
							GList* _tmp32_ = NULL;
							_prerequisite_index = _prerequisite_index + 1;
							if (!(_prerequisite_index < _prerequisite_size)) {
								break;
							}
							_tmp30_ = vala_list_get (_prerequisite_list, _prerequisite_index);
							prerequisite = (ValaDataType*) _tmp30_;
							_tmp31_ = vala_data_type_get_data_type (prerequisite);
							_tmp32_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp31_, name, prefix_match, FALSE);
							_result_ = g_list_concat (_result_, _tmp32_);
							_vala_code_node_unref0 (prerequisite);
						}
						_vala_iterable_unref0 (_prerequisite_list);
					}
					_vala_code_node_unref0 (iface);
				} else {
					if (VALA_IS_LOCAL_VARIABLE (sym)) {
						ValaLocalVariable* _tmp33_;
						ValaLocalVariable* variable;
						ValaDataType* _tmp34_ = NULL;
						ValaTypeSymbol* _tmp35_ = NULL;
						GList* _tmp36_ = NULL;
						_tmp33_ = _vala_code_node_ref0 (VALA_LOCAL_VARIABLE (sym));
						variable = _tmp33_;
						_tmp34_ = vala_variable_get_variable_type ((ValaVariable*) variable);
						_tmp35_ = vala_data_type_get_data_type (_tmp34_);
						_tmp36_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp35_, name, prefix_match, FALSE);
						_result_ = g_list_concat (_result_, _tmp36_);
						_vala_code_node_unref0 (variable);
					} else {
						if (VALA_IS_FIELD (sym)) {
							ValaField* _tmp37_;
							ValaField* field;
							ValaDataType* _tmp38_ = NULL;
							ValaTypeSymbol* _tmp39_ = NULL;
							GList* _tmp40_ = NULL;
							_tmp37_ = _vala_code_node_ref0 (VALA_FIELD (sym));
							field = _tmp37_;
							_tmp38_ = vala_variable_get_variable_type ((ValaVariable*) field);
							_tmp39_ = vala_data_type_get_data_type (_tmp38_);
							_tmp40_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp39_, name, prefix_match, FALSE);
							_result_ = g_list_concat (_result_, _tmp40_);
							_vala_code_node_unref0 (field);
						} else {
							if (VALA_IS_PROPERTY (sym)) {
								ValaProperty* _tmp41_;
								ValaProperty* prop;
								ValaDataType* _tmp42_ = NULL;
								ValaTypeSymbol* _tmp43_ = NULL;
								GList* _tmp44_ = NULL;
								_tmp41_ = _vala_code_node_ref0 (VALA_PROPERTY (sym));
								prop = _tmp41_;
								_tmp42_ = vala_property_get_property_type (prop);
								_tmp43_ = vala_data_type_get_data_type (_tmp42_);
								_tmp44_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp43_, name, prefix_match, FALSE);
								_result_ = g_list_concat (_result_, _tmp44_);
								_vala_code_node_unref0 (prop);
							} else {
								if (VALA_IS_PARAMETER (sym)) {
									ValaParameter* _tmp45_;
									ValaParameter* fp;
									ValaDataType* _tmp46_ = NULL;
									ValaTypeSymbol* _tmp47_ = NULL;
									GList* _tmp48_ = NULL;
									_tmp45_ = _vala_code_node_ref0 (VALA_PARAMETER (sym));
									fp = _tmp45_;
									_tmp46_ = vala_variable_get_variable_type ((ValaVariable*) fp);
									_tmp47_ = vala_data_type_get_data_type (_tmp46_);
									_tmp48_ = vala_plugin_symbol_lookup_inherited (self, (ValaSymbol*) _tmp47_, name, prefix_match, FALSE);
									_result_ = g_list_concat (_result_, _tmp48_);
									_vala_code_node_unref0 (fp);
								}
							}
						}
					}
				}
			}
		}
	}
	result = _result_;
	_vala_map_unref0 (symbol_table);
	return result;
}


static void vala_plugin_update_file (ValaPlugin* self, ValaSourceFile* file) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	{
		ValaArrayList* _tmp0_ = NULL;
		ValaArrayList* nodes;
		ValaArrayList* _tmp12_ = NULL;
		ValaArrayList* _tmp13_;
		ValaUnresolvedSymbol* _tmp14_ = NULL;
		ValaUnresolvedSymbol* _tmp15_;
		ValaUsingDirective* _tmp16_ = NULL;
		ValaUsingDirective* _tmp17_;
		ValaUsingDirective* ns_ref;
		g_static_rec_mutex_lock (&self->priv->__lock_context);
		_tmp0_ = vala_array_list_new (VALA_TYPE_CODE_NODE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
		nodes = _tmp0_;
		{
			ValaList* _tmp1_ = NULL;
			ValaList* _node_list;
			gint _tmp2_;
			gint _node_size;
			gint _node_index;
			_tmp1_ = vala_source_file_get_nodes (file);
			_node_list = _tmp1_;
			_tmp2_ = vala_collection_get_size ((ValaCollection*) _node_list);
			_node_size = _tmp2_;
			_node_index = -1;
			while (TRUE) {
				gpointer _tmp3_ = NULL;
				ValaCodeNode* node;
				_node_index = _node_index + 1;
				if (!(_node_index < _node_size)) {
					break;
				}
				_tmp3_ = vala_list_get (_node_list, _node_index);
				node = (ValaCodeNode*) _tmp3_;
				vala_collection_add ((ValaCollection*) nodes, node);
				_vala_code_node_unref0 (node);
			}
			_vala_iterable_unref0 (_node_list);
		}
		{
			ValaArrayList* _tmp4_;
			ValaArrayList* _node_list;
			gint _tmp5_;
			gint _node_size;
			gint _node_index;
			_tmp4_ = _vala_iterable_ref0 (nodes);
			_node_list = _tmp4_;
			_tmp5_ = vala_collection_get_size ((ValaCollection*) _node_list);
			_node_size = _tmp5_;
			_node_index = -1;
			while (TRUE) {
				gpointer _tmp6_ = NULL;
				ValaCodeNode* node;
				_node_index = _node_index + 1;
				if (!(_node_index < _node_size)) {
					break;
				}
				_tmp6_ = vala_list_get ((ValaList*) _node_list, _node_index);
				node = (ValaCodeNode*) _tmp6_;
				vala_source_file_remove_node (file, node);
				if (VALA_IS_SYMBOL (node)) {
					ValaSymbol* _tmp7_;
					ValaSymbol* sym;
					ValaScope* _tmp8_ = NULL;
					ValaMethod* _tmp11_ = NULL;
					_tmp7_ = _vala_code_node_ref0 (VALA_SYMBOL (node));
					sym = _tmp7_;
					_tmp8_ = vala_symbol_get_owner (sym);
					if (_tmp8_ != NULL) {
						ValaScope* _tmp9_ = NULL;
						const gchar* _tmp10_ = NULL;
						_tmp9_ = vala_symbol_get_owner (sym);
						_tmp10_ = vala_symbol_get_name (sym);
						vala_scope_remove (_tmp9_, _tmp10_);
					}
					_tmp11_ = vala_code_context_get_entry_point (self->priv->context);
					if (VALA_SYMBOL (_tmp11_) == sym) {
						vala_code_context_set_entry_point (self->priv->context, NULL);
					}
					_vala_code_node_unref0 (sym);
				}
				_vala_code_node_unref0 (node);
			}
			_vala_iterable_unref0 (_node_list);
		}
		_tmp12_ = vala_array_list_new (VALA_TYPE_USING_DIRECTIVE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
		_tmp13_ = _tmp12_;
		vala_source_file_set_current_using_directives (file, (ValaList*) _tmp13_);
		_vala_iterable_unref0 (_tmp13_);
		_tmp14_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_using_directive_new ((ValaSymbol*) _tmp15_, NULL);
		_tmp17_ = _tmp16_;
		_vala_code_node_unref0 (_tmp15_);
		ns_ref = _tmp17_;
		vala_source_file_add_using_directive (file, ns_ref);
		anjuta_report_clear_error_indicators (self->priv->report);
		vala_plugin_parse (self);
		anjuta_report_update_errors (self->priv->report, self->current_editor);
		_vala_code_node_unref0 (ns_ref);
		_vala_iterable_unref0 (nodes);
		__finally8:
		g_static_rec_mutex_unlock (&self->priv->__lock_context);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void vala_plugin_class_init (ValaPluginClass * klass) {
	vala_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaPluginPrivate));
	ANJUTA_PLUGIN_CLASS (klass)->activate = vala_plugin_real_activate;
	ANJUTA_PLUGIN_CLASS (klass)->deactivate = vala_plugin_real_deactivate;
	G_OBJECT_CLASS (klass)->finalize = vala_plugin_finalize;
}


static void vala_plugin_instance_init (ValaPlugin * self) {
	GSettings* _tmp0_ = NULL;
	BlockLocator* _tmp1_ = NULL;
	ValaHashSet* _tmp2_ = NULL;
	self->priv = VALA_PLUGIN_GET_PRIVATE (self);
	_tmp0_ = g_settings_new ("org.gnome.anjuta.cpp");
	self->settings = _tmp0_;
	g_static_rec_mutex_init (&self->priv->__lock_context);
	_tmp1_ = block_locator_new ();
	self->priv->locator = _tmp1_;
	_tmp2_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	self->priv->current_sources = (ValaSet*) _tmp2_;
}


static void vala_plugin_finalize (GObject* obj) {
	ValaPlugin * self;
	self = VALA_PLUGIN (obj);
	_g_object_unref0 (self->settings);
	g_static_rec_mutex_free (&self->priv->__lock_context);
	_vala_code_context_unref0 (self->priv->context);
	_g_object_unref0 (self->priv->cancel);
	_vala_code_visitor_unref0 (self->priv->locator);
	_g_object_unref0 (self->priv->report);
	_g_object_unref0 (self->priv->provider);
	_vala_code_visitor_unref0 (self->priv->parser);
	_vala_code_visitor_unref0 (self->priv->genie_parser);
	_vala_iterable_unref0 (self->priv->current_sources);
	G_OBJECT_CLASS (vala_plugin_parent_class)->finalize (obj);
}


GType vala_plugin_get_type (void) {
	return vala_plugin_type_id;
}


GType vala_plugin_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (ValaPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaPlugin), 0, (GInstanceInitFunc) vala_plugin_instance_init, NULL };
	vala_plugin_type_id = g_type_module_register_type (module, ANJUTA_TYPE_PLUGIN, "ValaPlugin", &g_define_type_info, 0);
	return vala_plugin_type_id;
}


GType anjuta_glue_register_components (GTypeModule* module) {
	GType result = 0UL;
	g_return_val_if_fail (module != NULL, 0UL);
	block_locator_register_type (module);
	vala_plugin_register_type (module);
	vala_provider_register_type (module);
	anjuta_report_register_type (module);
	result = TYPE_VALA_PLUGIN;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



