/* sudoku-game.c generated by valac 0.26.0.49-3a6f, the Vala compiler
 * generated from sudoku-game.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <string.h>


#define TYPE_SUDOKU_GAME (sudoku_game_get_type ())
#define SUDOKU_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GAME, SudokuGame))
#define SUDOKU_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GAME, SudokuGameClass))
#define IS_SUDOKU_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GAME))
#define IS_SUDOKU_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GAME))
#define SUDOKU_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GAME, SudokuGameClass))

typedef struct _SudokuGame SudokuGame;
typedef struct _SudokuGameClass SudokuGameClass;
typedef struct _SudokuGamePrivate SudokuGamePrivate;

#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;

#define SUDOKU_GAME_TYPE_UNDO_ITEM (sudoku_game_undo_item_get_type ())
typedef struct _SudokuGameUndoItem SudokuGameUndoItem;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _SudokuBoardPrivate SudokuBoardPrivate;

#define TYPE_COORD (coord_get_type ())
typedef struct _Coord Coord;
#define _sudoku_game_undo_item_free0(var) ((var == NULL) ? NULL : (var = (sudoku_game_undo_item_free (var), NULL)))

struct _SudokuGame {
	GObject parent_instance;
	SudokuGamePrivate * priv;
	SudokuBoard* board;
	GTimer* timer;
};

struct _SudokuGameClass {
	GObjectClass parent_class;
};

struct _SudokuGameUndoItem {
	gint row;
	gint col;
	gint val;
};

struct _SudokuGamePrivate {
	guint clock_timeout;
	gboolean _paused;
	GeeList* undostack;
	GeeList* redostack;
};

struct _Coord {
	gint row;
	gint col;
};

struct _SudokuBoard {
	GObject parent_instance;
	SudokuBoardPrivate * priv;
	gint* cells;
	gint cells_length1;
	gint cells_length2;
	gboolean* is_fixed;
	gint is_fixed_length1;
	gint is_fixed_length2;
	GeeSet* broken_coords;
	GeeList* coords_for_col;
	GeeList* coords_for_row;
	GeeMap* coords_for_block;
};

struct _SudokuBoardClass {
	GObjectClass parent_class;
};


static gpointer sudoku_game_parent_class = NULL;

GType sudoku_game_get_type (void) G_GNUC_CONST;
GType sudoku_board_get_type (void) G_GNUC_CONST;
static GType sudoku_game_undo_item_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SudokuGameUndoItem* sudoku_game_undo_item_dup (const SudokuGameUndoItem* self);
static void sudoku_game_undo_item_free (SudokuGameUndoItem* self);
#define SUDOKU_GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_GAME, SudokuGamePrivate))
enum  {
	SUDOKU_GAME_DUMMY_PROPERTY,
	SUDOKU_GAME_PAUSED
};
gboolean sudoku_game_is_undostack_null (SudokuGame* self);
gboolean sudoku_game_is_redostack_null (SudokuGame* self);
SudokuGame* sudoku_game_new (SudokuBoard* board);
SudokuGame* sudoku_game_construct (GType object_type, SudokuBoard* board);
static void __lambda4_ (SudokuGame* self);
void sudoku_game_stop_clock (SudokuGame* self);
static void ___lambda4__sudoku_board_completed (SudokuBoard* _sender, gpointer self);
void sudoku_game_insert (SudokuGame* self, gint row, gint col, gint val);
gint sudoku_board_get (SudokuBoard* self, gint row, gint col);
void sudoku_game_update_undo (SudokuGame* self, gint row, gint col, gint old_val, gint new_val);
void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed);
void sudoku_game_remove (SudokuGame* self, gint row, gint col);
void sudoku_board_remove (SudokuBoard* self, gint row, gint col, gboolean is_fixed);
void sudoku_game_undo (SudokuGame* self);
static void sudoku_game_apply_stack (SudokuGame* self, GeeList* from, GeeList* to);
void sudoku_game_redo (SudokuGame* self);
void sudoku_game_reset (SudokuGame* self);
void sudoku_board_set_previous_played_time (SudokuBoard* self, gdouble value);
gint sudoku_board_get_rows (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
GType coord_get_type (void) G_GNUC_CONST;
Coord* coord_dup (const Coord* self);
void coord_free (Coord* self);
void sudoku_game_cell_changed_cb (SudokuGame* self, gint row, gint col, gint old_val, gint new_val);
static void sudoku_game_add_to_stack (SudokuGame* self, GeeList* stack, gint r, gint c, gint v);
gdouble sudoku_game_get_total_time_played (SudokuGame* self);
gdouble sudoku_board_get_previous_played_time (SudokuBoard* self);
static gboolean sudoku_game_timeout_cb (SudokuGame* self);
static gboolean _sudoku_game_timeout_cb_gsource_func (gpointer self);
void sudoku_game_start_clock (SudokuGame* self);
static void sudoku_game_set_paused (SudokuGame* self, gboolean value);
void sudoku_game_resume_clock (SudokuGame* self);
gboolean sudoku_game_get_paused (SudokuGame* self);
static void g_cclosure_user_marshal_VOID__INT_INT_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void sudoku_game_finalize (GObject* obj);
static void _vala_sudoku_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sudoku_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


gboolean sudoku_game_is_undostack_null (SudokuGame* self) {
	gboolean result = FALSE;
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->priv->undostack;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = _tmp1_;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	result = _tmp2_ == 0;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	return result;
#line 182 "sudoku-game.c"
}


gboolean sudoku_game_is_redostack_null (SudokuGame* self) {
	gboolean result = FALSE;
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->priv->redostack;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = _tmp1_;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	result = _tmp2_ == 0;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	return result;
#line 203 "sudoku-game.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	return self ? g_object_ref (self) : NULL;
#line 210 "sudoku-game.c"
}


static void __lambda4_ (SudokuGame* self) {
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_stop_clock (self);
#line 217 "sudoku-game.c"
}


static void ___lambda4__sudoku_board_completed (SudokuBoard* _sender, gpointer self) {
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	__lambda4_ ((SudokuGame*) self);
#line 224 "sudoku-game.c"
}


SudokuGame* sudoku_game_construct (GType object_type, SudokuBoard* board) {
	SudokuGame * self = NULL;
	SudokuBoard* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	GTimer* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
	SudokuBoard* _tmp5_ = NULL;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_val_if_fail (board != NULL, NULL);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self = (SudokuGame*) g_object_new (object_type, NULL);
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = board;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_g_object_unref0 (self->board);
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self->board = _tmp1_;
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = g_timer_new ();
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_g_timer_destroy0 (self->timer);
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self->timer = _tmp2_;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_ = gee_array_list_new (SUDOKU_GAME_TYPE_UNDO_ITEM, (GBoxedCopyFunc) sudoku_game_undo_item_dup, sudoku_game_undo_item_free, NULL, NULL, NULL);
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_g_object_unref0 (self->priv->undostack);
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self->priv->undostack = (GeeList*) _tmp3_;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp4_ = gee_array_list_new (SUDOKU_GAME_TYPE_UNDO_ITEM, (GBoxedCopyFunc) sudoku_game_undo_item_dup, sudoku_game_undo_item_free, NULL, NULL, NULL);
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_g_object_unref0 (self->priv->redostack);
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self->priv->redostack = (GeeList*) _tmp4_;
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp5_ = board;
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_signal_connect_object (_tmp5_, "completed", (GCallback) ___lambda4__sudoku_board_completed, self, 0);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	return self;
#line 272 "sudoku-game.c"
}


SudokuGame* sudoku_game_new (SudokuBoard* board) {
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	return sudoku_game_construct (TYPE_SUDOKU_GAME, board);
#line 279 "sudoku-game.c"
}


void sudoku_game_insert (SudokuGame* self, gint row, gint col, gint val) {
	gint old_val = 0;
	SudokuBoard* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	SudokuBoard* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->board;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = row;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = col;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_ = sudoku_board_get (_tmp0_, _tmp1_, _tmp2_);
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	old_val = _tmp3_;
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp4_ = row;
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp5_ = col;
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp6_ = val;
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_update_undo (self, _tmp4_, _tmp5_, old_val, _tmp6_);
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp7_ = self->board;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp8_ = row;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp9_ = col;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp10_ = val;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_board_insert (_tmp7_, _tmp8_, _tmp9_, _tmp10_, FALSE);
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp11_ = row;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp12_ = col;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp13_ = val;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_signal_emit_by_name (self, "cell-changed", _tmp11_, _tmp12_, old_val, _tmp13_);
#line 337 "sudoku-game.c"
}


void sudoku_game_remove (SudokuGame* self, gint row, gint col) {
	gint old_val = 0;
	SudokuBoard* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	SudokuBoard* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->board;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = row;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = col;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_ = sudoku_board_get (_tmp0_, _tmp1_, _tmp2_);
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	old_val = _tmp3_;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp4_ = row;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp5_ = col;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_update_undo (self, _tmp4_, _tmp5_, old_val, 0);
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp6_ = self->board;
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp7_ = row;
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp8_ = col;
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_board_remove (_tmp6_, _tmp7_, _tmp8_, FALSE);
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp9_ = row;
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp10_ = col;
#line 88 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_signal_emit_by_name (self, "cell-changed", _tmp9_, _tmp10_, old_val, 0);
#line 386 "sudoku-game.c"
}


void sudoku_game_undo (SudokuGame* self) {
	GeeList* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->priv->undostack;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = self->priv->redostack;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_apply_stack (self, _tmp0_, _tmp1_);
#line 401 "sudoku-game.c"
}


void sudoku_game_redo (SudokuGame* self) {
	GeeList* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->priv->redostack;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = self->priv->undostack;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_apply_stack (self, _tmp0_, _tmp1_);
#line 416 "sudoku-game.c"
}


void sudoku_game_reset (SudokuGame* self) {
	SudokuBoard* _tmp0_ = NULL;
	GTimer* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	SudokuBoard* _tmp30_ = NULL;
	GeeSet* _tmp31_ = NULL;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->board;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_board_set_previous_played_time (_tmp0_, (gdouble) 0);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = self->timer;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_timer_start (_tmp1_);
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = self->priv->undostack;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	gee_collection_clear ((GeeCollection*) _tmp2_);
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_ = self->priv->redostack;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	gee_collection_clear ((GeeCollection*) _tmp3_);
#line 445 "sudoku-game.c"
	{
		gint l1 = 0;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		l1 = 0;
#line 450 "sudoku-game.c"
		{
			gboolean _tmp4_ = FALSE;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			_tmp4_ = TRUE;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
			while (TRUE) {
#line 457 "sudoku-game.c"
				gint _tmp6_ = 0;
				SudokuBoard* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
				if (!_tmp4_) {
#line 464 "sudoku-game.c"
					gint _tmp5_ = 0;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
					_tmp5_ = l1;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
					l1 = _tmp5_ + 1;
#line 470 "sudoku-game.c"
				}
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
				_tmp4_ = FALSE;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
				_tmp6_ = l1;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
				_tmp7_ = self->board;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
				_tmp8_ = sudoku_board_get_rows (_tmp7_);
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
				_tmp9_ = _tmp8_;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
				if (!(_tmp6_ < _tmp9_)) {
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
					break;
#line 486 "sudoku-game.c"
				}
				{
					gint l2 = 0;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
					l2 = 0;
#line 492 "sudoku-game.c"
					{
						gboolean _tmp10_ = FALSE;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
						_tmp10_ = TRUE;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
						while (TRUE) {
#line 499 "sudoku-game.c"
							gint _tmp12_ = 0;
							SudokuBoard* _tmp13_ = NULL;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							SudokuBoard* _tmp16_ = NULL;
							gboolean* _tmp17_ = NULL;
							gint _tmp17__length1 = 0;
							gint _tmp17__length2 = 0;
							gint _tmp18_ = 0;
							gint _tmp19_ = 0;
							gboolean _tmp20_ = FALSE;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							if (!_tmp10_) {
#line 513 "sudoku-game.c"
								gint _tmp11_ = 0;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp11_ = l2;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								l2 = _tmp11_ + 1;
#line 519 "sudoku-game.c"
							}
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp10_ = FALSE;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp12_ = l2;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp13_ = self->board;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp14_ = sudoku_board_get_cols (_tmp13_);
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp15_ = _tmp14_;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							if (!(_tmp12_ < _tmp15_)) {
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								break;
#line 535 "sudoku-game.c"
							}
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp16_ = self->board;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp17_ = _tmp16_->is_fixed;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp17__length1 = _tmp16_->is_fixed_length1;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp17__length2 = _tmp16_->is_fixed_length2;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp18_ = l1;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp19_ = l2;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							_tmp20_ = _tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_];
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
							if (!_tmp20_) {
#line 553 "sudoku-game.c"
								SudokuBoard* _tmp21_ = NULL;
								gint _tmp22_ = 0;
								gint _tmp23_ = 0;
								gint _tmp24_ = 0;
								gint _tmp25_ = 0;
								SudokuBoard* _tmp26_ = NULL;
								gint _tmp27_ = 0;
								gint _tmp28_ = 0;
								gint _tmp29_ = 0;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp21_ = self->board;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp22_ = l1;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp23_ = l2;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								sudoku_board_remove (_tmp21_, _tmp22_, _tmp23_, FALSE);
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp24_ = l1;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp25_ = l2;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp26_ = self->board;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp27_ = l1;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp28_ = l2;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								_tmp29_ = sudoku_board_get (_tmp26_, _tmp27_, _tmp28_);
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
								g_signal_emit_by_name (self, "cell-changed", _tmp24_, _tmp25_, _tmp29_, 0);
#line 585 "sudoku-game.c"
							}
						}
					}
				}
			}
		}
	}
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp30_ = self->board;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp31_ = _tmp30_->broken_coords;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	gee_collection_clear ((GeeCollection*) _tmp31_);
#line 599 "sudoku-game.c"
}


void sudoku_game_cell_changed_cb (SudokuGame* self, gint row, gint col, gint old_val, gint new_val) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = row;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = col;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = old_val;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_ = new_val;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_signal_emit_by_name (self, "cell-changed", _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 620 "sudoku-game.c"
}


void sudoku_game_update_undo (SudokuGame* self, gint row, gint col, gint old_val, gint new_val) {
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GeeList* _tmp4_ = NULL;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->priv->undostack;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = row;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = col;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_ = old_val;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_add_to_stack (self, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp4_ = self->priv->redostack;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	gee_collection_clear ((GeeCollection*) _tmp4_);
#line 646 "sudoku-game.c"
}


static void sudoku_game_add_to_stack (SudokuGame* self, GeeList* stack, gint r, gint c, gint v) {
	SudokuGameUndoItem step = {0};
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	SudokuGameUndoItem _tmp3_ = {0};
	GeeList* _tmp4_ = NULL;
	SudokuGameUndoItem _tmp5_ = {0};
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (stack != NULL);
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = r;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = c;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = v;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_.row = _tmp0_;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_.col = _tmp1_;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_.val = _tmp2_;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	step = _tmp3_;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp4_ = stack;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp5_ = step;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	gee_collection_add ((GeeCollection*) _tmp4_, &_tmp5_);
#line 682 "sudoku-game.c"
}


static void sudoku_game_apply_stack (SudokuGame* self, GeeList* from, GeeList* to) {
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	SudokuGameUndoItem* top = NULL;
	GeeList* _tmp3_ = NULL;
	GeeList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gpointer _tmp7_ = NULL;
	gint old_val = 0;
	SudokuBoard* _tmp8_ = NULL;
	SudokuGameUndoItem* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	SudokuGameUndoItem* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	GeeList* _tmp14_ = NULL;
	SudokuGameUndoItem* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	SudokuGameUndoItem* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	SudokuBoard* _tmp20_ = NULL;
	SudokuGameUndoItem* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	SudokuGameUndoItem* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	SudokuGameUndoItem* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	SudokuGameUndoItem* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	SudokuGameUndoItem* _tmp36_ = NULL;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	SudokuGameUndoItem* _tmp39_ = NULL;
	gint _tmp40_ = 0;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (from != NULL);
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (to != NULL);
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = from;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = _tmp1_;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	if (_tmp2_ == 0) {
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		return;
#line 739 "sudoku-game.c"
	}
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_ = from;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp4_ = from;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp6_ = _tmp5_;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp7_ = gee_list_remove_at (_tmp3_, _tmp6_ - 1);
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	top = (SudokuGameUndoItem*) _tmp7_;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp8_ = self->board;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp9_ = top;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp10_ = (*_tmp9_).row;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp11_ = top;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp12_ = (*_tmp11_).col;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp13_ = sudoku_board_get (_tmp8_, _tmp10_, _tmp12_);
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	old_val = _tmp13_;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp14_ = to;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp15_ = top;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp16_ = (*_tmp15_).row;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp17_ = top;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp18_ = (*_tmp17_).col;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp19_ = old_val;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_add_to_stack (self, _tmp14_, _tmp16_, _tmp18_, _tmp19_);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp20_ = self->board;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp21_ = top;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp22_ = (*_tmp21_).row;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp23_ = top;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp24_ = (*_tmp23_).col;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_board_remove (_tmp20_, _tmp22_, _tmp24_, FALSE);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp25_ = top;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp26_ = (*_tmp25_).val;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	if (_tmp26_ != 0) {
#line 799 "sudoku-game.c"
		SudokuBoard* _tmp27_ = NULL;
		SudokuGameUndoItem* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		SudokuGameUndoItem* _tmp30_ = NULL;
		gint _tmp31_ = 0;
		SudokuGameUndoItem* _tmp32_ = NULL;
		gint _tmp33_ = 0;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp27_ = self->board;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp28_ = top;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp29_ = (*_tmp28_).row;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp30_ = top;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp31_ = (*_tmp30_).col;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp32_ = top;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp33_ = (*_tmp32_).val;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		sudoku_board_insert (_tmp27_, _tmp29_, _tmp31_, _tmp33_, FALSE);
#line 823 "sudoku-game.c"
	}
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp34_ = top;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp35_ = (*_tmp34_).row;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp36_ = top;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp37_ = (*_tmp36_).col;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp38_ = old_val;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp39_ = top;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp40_ = (*_tmp39_).val;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_signal_emit_by_name (self, "cell-changed", _tmp35_, _tmp37_, _tmp38_, _tmp40_);
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_sudoku_game_undo_item_free0 (top);
#line 843 "sudoku-game.c"
}


gdouble sudoku_game_get_total_time_played (SudokuGame* self) {
	gdouble result = 0.0;
	SudokuBoard* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	GTimer* _tmp3_ = NULL;
	gdouble _tmp4_ = 0.0;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->board;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = sudoku_board_get_previous_played_time (_tmp0_);
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = _tmp1_;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_ = self->timer;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp4_ = g_timer_elapsed (_tmp3_, NULL);
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	result = _tmp2_ + _tmp4_;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	return result;
#line 870 "sudoku-game.c"
}


static gboolean _sudoku_game_timeout_cb_gsource_func (gpointer self) {
	gboolean result;
	result = sudoku_game_timeout_cb ((SudokuGame*) self);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	return result;
#line 879 "sudoku-game.c"
}


static gboolean sudoku_game_timeout_cb (SudokuGame* self) {
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _sudoku_game_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self->priv->clock_timeout = _tmp0_;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = self->priv->clock_timeout;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_source_set_name_by_id (_tmp1_, "[gnome-sudoku] timeout_cb");
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_signal_emit_by_name (self, "tick");
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	result = FALSE;
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	return result;
#line 903 "sudoku-game.c"
}


void sudoku_game_start_clock (SudokuGame* self) {
	GTimer* _tmp0_ = NULL;
	GTimer* _tmp2_ = NULL;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->timer;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	if (_tmp0_ == NULL) {
#line 916 "sudoku-game.c"
		GTimer* _tmp1_ = NULL;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp1_ = g_timer_new ();
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_g_timer_destroy0 (self->timer);
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		self->timer = _tmp1_;
#line 924 "sudoku-game.c"
	}
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = self->timer;
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_timer_start (_tmp2_);
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_timeout_cb (self);
#line 932 "sudoku-game.c"
}


void sudoku_game_stop_clock (SudokuGame* self) {
	GTimer* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GTimer* _tmp3_ = NULL;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->timer;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = self->priv->clock_timeout;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	if (_tmp1_ != ((guint) 0)) {
#line 950 "sudoku-game.c"
		guint _tmp2_ = 0U;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		_tmp2_ = self->priv->clock_timeout;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		g_source_remove (_tmp2_);
#line 956 "sudoku-game.c"
	}
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self->priv->clock_timeout = (guint) 0;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_set_paused (self, TRUE);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp3_ = self->timer;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_timer_stop (_tmp3_);
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_signal_emit_by_name (self, "tick");
#line 968 "sudoku-game.c"
}


void sudoku_game_resume_clock (SudokuGame* self) {
	GTimer* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GTimer* _tmp2_ = NULL;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->timer;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp1_ = self->priv->clock_timeout;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail ((_tmp0_ != NULL) && (_tmp1_ == ((guint) 0)));
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp2_ = self->timer;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_timer_continue (_tmp2_);
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_set_paused (self, FALSE);
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_timeout_cb (self);
#line 992 "sudoku-game.c"
}


gboolean sudoku_game_get_paused (SudokuGame* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = self->priv->_paused;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	result = _tmp0_;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	return result;
#line 1007 "sudoku-game.c"
}


static void sudoku_game_set_paused (SudokuGame* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (self != NULL);
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_tmp0_ = value;
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self->priv->_paused = _tmp0_;
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_signal_emit_by_name (self, "paused-changed");
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_object_notify ((GObject *) self, "paused");
#line 1023 "sudoku-game.c"
}


static void g_cclosure_user_marshal_VOID__INT_INT_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT_INT_INT) (gpointer data1, gint arg_1, gint arg_2, gint arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__INT_INT_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_return_if_fail (n_param_values == 5);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		data1 = closure->data;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		data2 = param_values->data[0].v_pointer;
#line 1042 "sudoku-game.c"
	} else {
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		data1 = param_values->data[0].v_pointer;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		data2 = closure->data;
#line 1048 "sudoku-game.c"
	}
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	callback = (GMarshalFunc_VOID__INT_INT_INT_INT) (marshal_data ? marshal_data : cc->callback);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), g_value_get_int (param_values + 4), data2);
#line 1054 "sudoku-game.c"
}


static SudokuGameUndoItem* sudoku_game_undo_item_dup (const SudokuGameUndoItem* self) {
	SudokuGameUndoItem* dup;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	dup = g_new0 (SudokuGameUndoItem, 1);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	memcpy (dup, self, sizeof (SudokuGameUndoItem));
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	return dup;
#line 1066 "sudoku-game.c"
}


static void sudoku_game_undo_item_free (SudokuGameUndoItem* self) {
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_free (self);
#line 1073 "sudoku-game.c"
}


static GType sudoku_game_undo_item_get_type (void) {
	static volatile gsize sudoku_game_undo_item_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_game_undo_item_type_id__volatile)) {
		GType sudoku_game_undo_item_type_id;
		sudoku_game_undo_item_type_id = g_boxed_type_register_static ("SudokuGameUndoItem", (GBoxedCopyFunc) sudoku_game_undo_item_dup, (GBoxedFreeFunc) sudoku_game_undo_item_free);
		g_once_init_leave (&sudoku_game_undo_item_type_id__volatile, sudoku_game_undo_item_type_id);
	}
	return sudoku_game_undo_item_type_id__volatile;
}


static void sudoku_game_class_init (SudokuGameClass * klass) {
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	sudoku_game_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_type_class_add_private (klass, sizeof (SudokuGamePrivate));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_game_get_property;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_game_set_property;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_game_finalize;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_GAME_PAUSED, g_param_spec_boolean ("paused", "paused", "paused", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_signal_new ("tick", TYPE_SUDOKU_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_signal_new ("paused_changed", TYPE_SUDOKU_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	g_signal_new ("cell_changed", TYPE_SUDOKU_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT_INT_INT, G_TYPE_NONE, 4, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);
#line 1107 "sudoku-game.c"
}


static void sudoku_game_instance_init (SudokuGame * self) {
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self->priv = SUDOKU_GAME_GET_PRIVATE (self);
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self->priv->_paused = FALSE;
#line 1116 "sudoku-game.c"
}


static void sudoku_game_finalize (GObject* obj) {
	SudokuGame * self;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_GAME, SudokuGame);
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_g_object_unref0 (self->board);
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_g_timer_destroy0 (self->timer);
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_g_object_unref0 (self->priv->undostack);
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	_g_object_unref0 (self->priv->redostack);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	G_OBJECT_CLASS (sudoku_game_parent_class)->finalize (obj);
#line 1134 "sudoku-game.c"
}


GType sudoku_game_get_type (void) {
	static volatile gsize sudoku_game_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuGameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuGame), 0, (GInstanceInitFunc) sudoku_game_instance_init, NULL };
		GType sudoku_game_type_id;
		sudoku_game_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuGame", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_game_type_id__volatile, sudoku_game_type_id);
	}
	return sudoku_game_type_id__volatile;
}


static void _vala_sudoku_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SudokuGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_GAME, SudokuGame);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	switch (property_id) {
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		case SUDOKU_GAME_PAUSED:
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		g_value_set_boolean (value, sudoku_game_get_paused (self));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		break;
#line 1161 "sudoku-game.c"
		default:
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		break;
#line 1167 "sudoku-game.c"
	}
}


static void _vala_sudoku_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SudokuGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_GAME, SudokuGame);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
	switch (property_id) {
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		case SUDOKU_GAME_PAUSED:
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		sudoku_game_set_paused (self, g_value_get_boolean (value));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		break;
#line 1183 "sudoku-game.c"
		default:
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-game.vala"
		break;
#line 1189 "sudoku-game.c"
	}
}



