/* iagno.c generated by valac 0.26.0.30-a52f5a, the Vala compiler
 * generated from iagno.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <canberra-gtk.h>
#include <canberra.h>


#define TYPE_IAGNO (iagno_get_type ())
#define IAGNO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IAGNO, Iagno))
#define IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IAGNO, IagnoClass))
#define IS_IAGNO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IAGNO))
#define IS_IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IAGNO))
#define IAGNO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IAGNO, IagnoClass))

typedef struct _Iagno Iagno;
typedef struct _IagnoClass IagnoClass;
typedef struct _IagnoPrivate IagnoPrivate;

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;

#define TYPE_COMPUTER_PLAYER (computer_player_get_type ())
#define COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayer))
#define COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))
#define IS_COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_PLAYER))
#define IS_COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_PLAYER))
#define COMPUTER_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))

typedef struct _ComputerPlayer ComputerPlayer;
typedef struct _ComputerPlayerClass ComputerPlayerClass;

#define TYPE_PLAYER (player_get_type ())

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
typedef struct _Block3Data Block3Data;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _Iagno {
	GtkApplication parent_instance;
	IagnoPrivate * priv;
};

struct _IagnoClass {
	GtkApplicationClass parent_class;
};

typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;

struct _IagnoPrivate {
	GSettings* settings;
	gboolean is_fullscreen;
	gboolean is_maximized;
	gint window_width;
	gint window_height;
	GtkWindow* window;
	GtkHeaderBar* headerbar;
	GameView* view;
	GtkImage* mark_icon_dark;
	GtkImage* mark_icon_light;
	GtkLabel* dark_score_label;
	GtkLabel* light_score_label;
	GtkDialog* propbox;
	GtkStack* main_stack;
	GtkButton* back_button;
	GtkButton* undo_button;
	GSimpleAction* back_action;
	ComputerPlayer* computer;
	Player player_one;
	Game* game;
};

struct _Block3Data {
	int _ref_count_;
	Iagno* self;
	GtkBox* level_box;
};


static gpointer iagno_parent_class = NULL;
static gboolean iagno_fast_mode;
static gboolean iagno_fast_mode = FALSE;
static gboolean iagno_alternative_start;
static gboolean iagno_alternative_start = FALSE;
static gint iagno_computer_level;
static gint iagno_computer_level = 0;
static gint iagno_size;
static gint iagno_size = 8;
static gboolean iagno_begin_with_new_game_screen;
static gboolean iagno_begin_with_new_game_screen = FALSE;
static gchar* iagno_play_as;
static gchar* iagno_play_as = NULL;
static gboolean* iagno_sound;
static gboolean* iagno_sound = NULL;

GType iagno_get_type (void) G_GNUC_CONST;
GType game_view_get_type (void) G_GNUC_CONST;
GType computer_player_get_type (void) G_GNUC_CONST;
GType player_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define IAGNO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_IAGNO, IagnoPrivate))
enum  {
	IAGNO_DUMMY_PROPERTY
};
#define IAGNO_QUICK_MOVE_DELAY 0.4
#define IAGNO_MODERATE_MOVE_DELAY 1.0
#define IAGNO_SLOW_MOVE_DELAY 2.0
static void iagno_new_game_cb (Iagno* self);
static void _iagno_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_start_game_cb (Iagno* self);
static void _iagno_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_undo_move_cb (Iagno* self);
static void _iagno_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_back_cb (Iagno* self);
static void _iagno_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_preferences_cb (Iagno* self);
static void _iagno_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_help_cb (Iagno* self);
static void _iagno_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_about_cb (Iagno* self);
static void _iagno_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
gint iagno_main (gchar** args, int args_length1);
Iagno* iagno_new (void);
Iagno* iagno_construct (GType object_type);
static gint iagno_real_handle_local_options (GApplication* base, GVariantDict* options);
static gboolean* _bool_dup (gboolean* self);
static void iagno_real_startup (GApplication* base);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda7_ (Block3Data* _data3_);
static void ___lambda7__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static gboolean iagno_window_configure_event_cb (Iagno* self, GdkEventConfigure* event);
static gboolean _iagno_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
static gboolean iagno_window_state_event_cb (Iagno* self, GdkEventWindowState* event);
static gboolean _iagno_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
static void iagno_player_move_cb (Iagno* self, gint x, gint y);
static void _iagno_player_move_cb_game_view_move (GameView* _sender, gint x, gint y, gpointer self);
void game_view_set_theme (GameView* self, const gchar* value);
static void iagno_show_new_game_screen (Iagno* self);
static void iagno_start_game (Iagno* self);
static void iagno_real_activate (GApplication* base);
static void iagno_real_shutdown (GApplication* base);
static void iagno_show_game_board (Iagno* self);
Player game_get_current_color (Game* self);
gboolean game_get_is_complete (Game* self);
void computer_player_move_async (ComputerPlayer* self, gdouble delay_seconds, GAsyncReadyCallback _callback_, gpointer _user_data_);
void computer_player_move_finish (ComputerPlayer* self, GAsyncResult* _res_);
static void iagno_game_complete (Iagno* self, gboolean play_gameover_sound);
void computer_player_cancel_move (ComputerPlayer* self);
Game* game_new (gboolean alternative_start, gint tmp_size);
Game* game_construct (GType object_type, gboolean alternative_start, gint tmp_size);
static void iagno_turn_ended_cb (Iagno* self);
static void _iagno_turn_ended_cb_game_turn_ended (Game* _sender, gpointer self);
void game_view_set_game (GameView* self, Game* value);
ComputerPlayer* computer_player_new (Game* game, gint difficulty_level);
ComputerPlayer* computer_player_construct (GType object_type, Game* game, gint difficulty_level);
static void iagno_update_ui (Iagno* self);
gint game_get_number_of_moves (Game* self);
gint game_get_n_dark_tiles (Game* self);
gint game_get_n_light_tiles (Game* self);
void game_undo (Game* self, gint count);
gboolean game_get_current_player_can_move (Game* self);
static void iagno_play_sound (Iagno* self, const gchar* name);
static void iagno_prepare_move (Iagno* self);
static void iagno_pass (Iagno* self);
void game_pass (Game* self);
gint game_place_tile (Game* self, gint x, gint y, gboolean apply);
static gboolean iagno_propbox_close_cb (Iagno* self, GtkWidget* widget, GdkEventAny* event);
static void iagno_theme_changed_cb (Iagno* self, GtkComboBox* widget);
static void iagno_create_preferences_dialog (Iagno* self);
static gboolean _iagno_propbox_close_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void _iagno_theme_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void iagno_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry IAGNO_option_entries[11] = {{"alternative-start", (gchar) 0, 0, G_OPTION_ARG_NONE, &iagno_alternative_start, "Start with an alternative position", NULL}, {"fast-mode", 'f', 0, G_OPTION_ARG_NONE, &iagno_fast_mode, "Reduce delay before AI moves", NULL}, {"first", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Play first", NULL}, {"level", 'l', 0, G_OPTION_ARG_INT, &iagno_computer_level, "Set the level of the computer's AI", "LEVEL"}, {"mute", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Turn off the sound", NULL}, {"second", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Play second", NULL}, {"size", 's', 0, G_OPTION_ARG_INT, &iagno_size, "Size of the board (debug only)", "SIZE"}, {"two-players", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Two-players mode", NULL}, {"unmute", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Turn on the sound", NULL}, {"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Print release version and exit", NULL}, {NULL}};
static const GActionEntry IAGNO_app_actions[8] = {{"new-game", _iagno_new_game_cb_gsimple_action_activate_callback}, {"start-game", _iagno_start_game_cb_gsimple_action_activate_callback}, {"undo-move", _iagno_undo_move_cb_gsimple_action_activate_callback}, {"back", _iagno_back_cb_gsimple_action_activate_callback}, {"preferences", _iagno_preferences_cb_gsimple_action_activate_callback}, {"help", _iagno_help_cb_gsimple_action_activate_callback}, {"about", _iagno_about_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};

static void _iagno_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 73 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_new_game_cb ((Iagno*) self);
#line 235 "iagno.c"
}


static void _iagno_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 73 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_start_game_cb ((Iagno*) self);
#line 242 "iagno.c"
}


static void _iagno_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 73 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_undo_move_cb ((Iagno*) self);
#line 249 "iagno.c"
}


static void _iagno_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 73 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_back_cb ((Iagno*) self);
#line 256 "iagno.c"
}


static void _iagno_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 73 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_preferences_cb ((Iagno*) self);
#line 263 "iagno.c"
}


static void _iagno_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 73 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_help_cb ((Iagno*) self);
#line 270 "iagno.c"
}


static void _iagno_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 73 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_about_cb ((Iagno*) self);
#line 277 "iagno.c"
}


static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 73 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_application_quit ((GApplication*) self);
#line 284 "iagno.c"
}


gint iagno_main (gchar** args, int args_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	Iagno* _tmp1_ = NULL;
	Iagno* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 89 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	setlocale (LC_ALL, "");
#line 90 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 91 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 92 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	textdomain (GETTEXT_PACKAGE);
#line 94 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = _ ("Iagno");
#line 94 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_set_application_name (_tmp0_);
#line 96 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_window_set_default_icon_name ("iagno");
#line 98 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = iagno_new ();
#line 98 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = _tmp1_;
#line 98 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = args;
#line 98 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3__length1 = args_length1;
#line 98 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_ = g_application_run ((GApplication*) _tmp2_, _tmp3__length1, _tmp3_);
#line 98 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp5_ = _tmp4_;
#line 98 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (_tmp2_);
#line 98 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	result = _tmp5_;
#line 98 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return result;
#line 329 "iagno.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 87 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return iagno_main (argv, argc);
#line 339 "iagno.c"
}


Iagno* iagno_construct (GType object_type) {
	Iagno * self = NULL;
#line 103 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self = (Iagno*) g_object_new (object_type, "application-id", "org.gnome.iagno", "flags", G_APPLICATION_FLAGS_NONE, NULL);
#line 105 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_application_add_main_option_entries ((GApplication*) self, IAGNO_option_entries);
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return self;
#line 351 "iagno.c"
}


Iagno* iagno_new (void) {
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return iagno_construct (TYPE_IAGNO);
#line 358 "iagno.c"
}


static gboolean* _bool_dup (gboolean* self) {
	gboolean* dup;
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	dup = g_new0 (gboolean, 1);
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	memcpy (dup, self, sizeof (gboolean));
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return dup;
#line 370 "iagno.c"
}


static gpointer __bool_dup0 (gpointer self) {
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return self ? _bool_dup (self) : NULL;
#line 377 "iagno.c"
}


static gint iagno_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Iagno * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gint _tmp3_ = 0;
	GVariantDict* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GVariantDict* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gint _tmp15_ = 0;
	GVariantDict* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
#line 108 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self = (Iagno*) base;
#line 108 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_val_if_fail (options != NULL, 0);
#line 110 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = options;
#line 110 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
#line 110 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp1_) {
#line 405 "iagno.c"
		FILE* _tmp2_ = NULL;
#line 113 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp2_ = stderr;
#line 113 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		fprintf (_tmp2_, "%1$s %2$s\n", "iagno", VERSION);
#line 114 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		result = EXIT_SUCCESS;
#line 114 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		return result;
#line 415 "iagno.c"
	}
#line 117 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = iagno_size;
#line 117 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp3_ < 4) {
#line 421 "iagno.c"
		FILE* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 120 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp4_ = stderr;
#line 120 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp5_ = _ ("Size must be at least 4.");
#line 120 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		fprintf (_tmp4_, "%s\n", _tmp5_);
#line 121 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		result = EXIT_FAILURE;
#line 121 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		return result;
#line 434 "iagno.c"
	}
#line 124 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp6_ = options;
#line 124 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp7_ = g_variant_dict_contains (_tmp6_, "unmute");
#line 124 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp7_) {
#line 442 "iagno.c"
		gboolean _tmp8_ = FALSE;
		gboolean* _tmp9_ = NULL;
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp8_ = TRUE;
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp9_ = __bool_dup0 (&_tmp8_);
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_free0 (iagno_sound);
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		iagno_sound = _tmp9_;
#line 453 "iagno.c"
	}
#line 126 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp10_ = options;
#line 126 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp11_ = g_variant_dict_contains (_tmp10_, "mute");
#line 126 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp11_) {
#line 461 "iagno.c"
		gboolean _tmp12_ = FALSE;
		gboolean* _tmp13_ = NULL;
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp12_ = FALSE;
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp13_ = __bool_dup0 (&_tmp12_);
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_free0 (iagno_sound);
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		iagno_sound = _tmp13_;
#line 472 "iagno.c"
	}
#line 130 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp15_ = iagno_computer_level;
#line 130 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp15_ < 0) {
#line 130 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp14_ = TRUE;
#line 480 "iagno.c"
	} else {
		gint _tmp16_ = 0;
#line 130 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp16_ = iagno_computer_level;
#line 130 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp14_ = _tmp16_ > 3;
#line 487 "iagno.c"
	}
#line 130 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp14_) {
#line 491 "iagno.c"
		FILE* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
#line 131 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp17_ = stderr;
#line 131 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp18_ = _ ("Level should be between 1 (easy) and 3 (hard). Settings unchanged.");
#line 131 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		fprintf (_tmp17_, "%s\n", _tmp18_);
#line 500 "iagno.c"
	}
#line 133 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp19_ = options;
#line 133 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp20_ = g_variant_dict_contains (_tmp19_, "two-players");
#line 133 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp20_) {
#line 508 "iagno.c"
		gchar* _tmp21_ = NULL;
#line 134 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp21_ = g_strdup ("two-players");
#line 134 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_free0 (iagno_play_as);
#line 134 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		iagno_play_as = _tmp21_;
#line 516 "iagno.c"
	} else {
		GVariantDict* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
#line 135 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp22_ = options;
#line 135 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp23_ = g_variant_dict_contains (_tmp22_, "first");
#line 135 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		if (_tmp23_) {
#line 526 "iagno.c"
			gchar* _tmp24_ = NULL;
#line 136 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp24_ = g_strdup ("first");
#line 136 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_g_free0 (iagno_play_as);
#line 136 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			iagno_play_as = _tmp24_;
#line 534 "iagno.c"
		} else {
			GVariantDict* _tmp25_ = NULL;
			gboolean _tmp26_ = FALSE;
#line 137 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp25_ = options;
#line 137 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp26_ = g_variant_dict_contains (_tmp25_, "second");
#line 137 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			if (_tmp26_) {
#line 544 "iagno.c"
				gchar* _tmp27_ = NULL;
#line 138 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp27_ = g_strdup ("second");
#line 138 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_g_free0 (iagno_play_as);
#line 138 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				iagno_play_as = _tmp27_;
#line 552 "iagno.c"
			} else {
#line 140 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				iagno_begin_with_new_game_screen = TRUE;
#line 556 "iagno.c"
			}
		}
	}
#line 143 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	result = -1;
#line 143 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return result;
#line 564 "iagno.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 146 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 146 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return _data3_;
#line 573 "iagno.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 146 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 582 "iagno.c"
		Iagno* self;
#line 146 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		self = _data3_->self;
#line 146 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_object_unref0 (_data3_->level_box);
#line 146 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_object_unref0 (self);
#line 146 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_slice_free (Block3Data, _data3_);
#line 592 "iagno.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 174 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return self ? g_object_ref (self) : NULL;
#line 600 "iagno.c"
}


static void __lambda7_ (Block3Data* _data3_) {
	Iagno* self;
	GtkBox* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 175 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self = _data3_->self;
#line 176 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = _data3_->level_box;
#line 176 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = self->priv->settings;
#line 176 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = g_settings_get_string (_tmp1_, "play-as");
#line 176 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = _tmp2_;
#line 176 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, g_strcmp0 (_tmp3_, "two-players") != 0);
#line 176 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_free0 (_tmp3_);
#line 624 "iagno.c"
}


static void ___lambda7__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 175 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	__lambda7_ (self);
#line 631 "iagno.c"
}


static gboolean _iagno_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = iagno_window_configure_event_cb ((Iagno*) self, event);
#line 182 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return result;
#line 640 "iagno.c"
}


static gboolean _iagno_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = iagno_window_state_event_cb ((Iagno*) self, event);
#line 183 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return result;
#line 649 "iagno.c"
}


static void _iagno_player_move_cb_game_view_move (GameView* _sender, gint x, gint y, gpointer self) {
#line 198 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_player_move_cb ((Iagno*) self, x, y);
#line 656 "iagno.c"
}


static void iagno_real_startup (GApplication* base) {
	Iagno * self;
	Block3Data* _data3_;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gboolean* _tmp2_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gint _tmp11_ = 0;
	gchar* _tmp17_ = NULL;
	gchar** _tmp18_ = NULL;
	gchar** _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	gchar* _tmp20_ = NULL;
	gchar** _tmp21_ = NULL;
	gchar** _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	GSettings* _tmp23_ = NULL;
	GAction* _tmp24_ = NULL;
	GAction* _tmp25_ = NULL;
	GSettings* _tmp26_ = NULL;
	GAction* _tmp27_ = NULL;
	GAction* _tmp28_ = NULL;
	GSettings* _tmp29_ = NULL;
	GAction* _tmp30_ = NULL;
	GAction* _tmp31_ = NULL;
	GtkBuilder* _tmp32_ = NULL;
	GObject* _tmp33_ = NULL;
	GtkBox* _tmp34_ = NULL;
	GSettings* _tmp35_ = NULL;
	GtkBox* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	GtkBuilder* _tmp38_ = NULL;
	GObject* _tmp39_ = NULL;
	GtkWindow* _tmp40_ = NULL;
	GtkWindow* _tmp41_ = NULL;
	GtkWindow* _tmp42_ = NULL;
	GtkWindow* _tmp43_ = NULL;
	GSettings* _tmp44_ = NULL;
	gint _tmp45_ = 0;
	GSettings* _tmp46_ = NULL;
	gint _tmp47_ = 0;
	GSettings* _tmp48_ = NULL;
	gboolean _tmp49_ = FALSE;
	GtkWindow* _tmp51_ = NULL;
	GSettings* _tmp52_ = NULL;
	const gchar* _tmp53_ = NULL;
	GSettings* _tmp54_ = NULL;
	gint _tmp55_ = 0;
	GameView* _tmp56_ = NULL;
	GameView* _tmp57_ = NULL;
	gchar* tile_set = NULL;
	GSettings* _tmp58_ = NULL;
	gchar* _tmp59_ = NULL;
	GameView* _tmp60_ = NULL;
	const gchar* _tmp61_ = NULL;
	gchar* _tmp62_ = NULL;
	gchar* _tmp63_ = NULL;
	GameView* _tmp64_ = NULL;
	GameView* _tmp65_ = NULL;
	GtkBox* game_box = NULL;
	GtkBuilder* _tmp66_ = NULL;
	GObject* _tmp67_ = NULL;
	GtkBox* _tmp68_ = NULL;
	GtkBox* _tmp69_ = NULL;
	GameView* _tmp70_ = NULL;
	GtkBuilder* _tmp71_ = NULL;
	GObject* _tmp72_ = NULL;
	GtkHeaderBar* _tmp73_ = NULL;
	GtkBuilder* _tmp74_ = NULL;
	GObject* _tmp75_ = NULL;
	GtkLabel* _tmp76_ = NULL;
	GtkBuilder* _tmp77_ = NULL;
	GObject* _tmp78_ = NULL;
	GtkLabel* _tmp79_ = NULL;
	GtkBuilder* _tmp80_ = NULL;
	GObject* _tmp81_ = NULL;
	GtkImage* _tmp82_ = NULL;
	GtkBuilder* _tmp83_ = NULL;
	GObject* _tmp84_ = NULL;
	GtkImage* _tmp85_ = NULL;
	GtkBuilder* _tmp86_ = NULL;
	GObject* _tmp87_ = NULL;
	GtkStack* _tmp88_ = NULL;
	GtkBuilder* _tmp89_ = NULL;
	GObject* _tmp90_ = NULL;
	GtkButton* _tmp91_ = NULL;
	GtkBuilder* _tmp92_ = NULL;
	GObject* _tmp93_ = NULL;
	GtkButton* _tmp94_ = NULL;
	GAction* _tmp95_ = NULL;
	GSimpleAction* _tmp96_ = NULL;
	gboolean _tmp97_ = FALSE;
#line 146 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self = (Iagno*) base;
#line 146 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 146 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_data3_->_ref_count_ = 1;
#line 146 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_data3_->self = g_object_ref (self);
#line 148 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	G_APPLICATION_CLASS (iagno_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 149 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = gtk_builder_new_from_resource ("/org/gnome/iagno/ui/iagno.ui");
#line 149 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	builder = _tmp0_;
#line 152 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = g_settings_new ("org.gnome.iagno");
#line 152 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->settings);
#line 152 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->settings = _tmp1_;
#line 153 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = iagno_sound;
#line 153 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp2_ != NULL) {
#line 778 "iagno.c"
		GSettings* _tmp3_ = NULL;
		gboolean* _tmp4_ = NULL;
#line 154 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp3_ = self->priv->settings;
#line 154 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp4_ = iagno_sound;
#line 154 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_settings_set_boolean (_tmp3_, "sound", *_tmp4_);
#line 787 "iagno.c"
	}
#line 155 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp5_ = iagno_begin_with_new_game_screen;
#line 155 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (!_tmp5_) {
#line 793 "iagno.c"
		GSettings* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 156 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp6_ = self->priv->settings;
#line 156 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp7_ = iagno_play_as;
#line 156 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_settings_set_string (_tmp6_, "play-as", _tmp7_);
#line 802 "iagno.c"
	} else {
		GSettings* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 158 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp8_ = self->priv->settings;
#line 158 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp9_ = g_settings_get_string (_tmp8_, "play-as");
#line 158 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_free0 (iagno_play_as);
#line 158 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		iagno_play_as = _tmp9_;
#line 814 "iagno.c"
	}
#line 159 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp11_ = iagno_computer_level;
#line 159 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp11_ > 0) {
#line 820 "iagno.c"
		gint _tmp12_ = 0;
#line 159 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp12_ = iagno_computer_level;
#line 159 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp10_ = _tmp12_ <= 3;
#line 826 "iagno.c"
	} else {
#line 159 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp10_ = FALSE;
#line 830 "iagno.c"
	}
#line 159 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp10_) {
#line 834 "iagno.c"
		GSettings* _tmp13_ = NULL;
		gint _tmp14_ = 0;
#line 160 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp13_ = self->priv->settings;
#line 160 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp14_ = iagno_computer_level;
#line 160 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_settings_set_int (_tmp13_, "computer-level", _tmp14_);
#line 843 "iagno.c"
	} else {
		GSettings* _tmp15_ = NULL;
		gint _tmp16_ = 0;
#line 162 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp15_ = self->priv->settings;
#line 162 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp16_ = g_settings_get_int (_tmp15_, "computer-level");
#line 162 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		iagno_computer_level = _tmp16_;
#line 853 "iagno.c"
	}
#line 165 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_action_map_add_action_entries ((GActionMap*) self, IAGNO_app_actions, G_N_ELEMENTS (IAGNO_app_actions), self);
#line 166 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp17_ = g_strdup ("<Primary>n");
#line 166 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp18_ = g_new0 (gchar*, 1 + 1);
#line 166 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp18_[0] = _tmp17_;
#line 166 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp19_ = _tmp18_;
#line 166 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp19__length1 = 1;
#line 166 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.new-game", _tmp19_);
#line 166 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
#line 167 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp20_ = g_strdup ("<Primary>z");
#line 167 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp21_ = g_new0 (gchar*, 1 + 1);
#line 167 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp21_[0] = _tmp20_;
#line 167 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp22_ = _tmp21_;
#line 167 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp22__length1 = 1;
#line 167 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.undo-move", _tmp22_);
#line 167 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_free), NULL);
#line 168 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp23_ = self->priv->settings;
#line 168 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp24_ = g_settings_create_action (_tmp23_, "sound");
#line 168 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp25_ = _tmp24_;
#line 168 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp25_);
#line 168 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (_tmp25_);
#line 171 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp26_ = self->priv->settings;
#line 171 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp27_ = g_settings_create_action (_tmp26_, "play-as");
#line 171 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp28_ = _tmp27_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp28_);
#line 171 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (_tmp28_);
#line 172 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp29_ = self->priv->settings;
#line 172 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp30_ = g_settings_create_action (_tmp29_, "computer-level");
#line 172 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp31_ = _tmp30_;
#line 172 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp31_);
#line 172 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (_tmp31_);
#line 174 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp32_ = builder;
#line 174 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp33_ = gtk_builder_get_object (_tmp32_, "level-box");
#line 174 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, gtk_box_get_type ()) ? ((GtkBox*) _tmp33_) : NULL);
#line 174 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_data3_->level_box = _tmp34_;
#line 175 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp35_ = self->priv->settings;
#line 175 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_signal_connect_data (_tmp35_, "changed::play-as", (GCallback) ___lambda7__g_settings_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 178 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp36_ = _data3_->level_box;
#line 178 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp37_ = iagno_play_as;
#line 178 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp36_, g_strcmp0 (_tmp37_, "two-players") != 0);
#line 181 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp38_ = builder;
#line 181 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp39_ = gtk_builder_get_object (_tmp38_, "iagno-window");
#line 181 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp40_ = _g_object_ref0 ((GtkWindow*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, gtk_application_window_get_type ()) ? ((GtkApplicationWindow*) _tmp39_) : NULL));
#line 181 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->window);
#line 181 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->window = _tmp40_;
#line 182 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp41_ = self->priv->window;
#line 182 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_signal_connect_object ((GtkWidget*) _tmp41_, "configure-event", (GCallback) _iagno_window_configure_event_cb_gtk_widget_configure_event, self, 0);
#line 183 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp42_ = self->priv->window;
#line 183 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_signal_connect_object ((GtkWidget*) _tmp42_, "window-state-event", (GCallback) _iagno_window_state_event_cb_gtk_widget_window_state_event, self, 0);
#line 184 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp43_ = self->priv->window;
#line 184 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp44_ = self->priv->settings;
#line 184 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp45_ = g_settings_get_int (_tmp44_, "window-width");
#line 184 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp46_ = self->priv->settings;
#line 184 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp47_ = g_settings_get_int (_tmp46_, "window-height");
#line 184 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_window_set_default_size (_tmp43_, _tmp45_, _tmp47_);
#line 185 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp48_ = self->priv->settings;
#line 185 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp49_ = g_settings_get_boolean (_tmp48_, "window-is-maximized");
#line 185 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp49_) {
#line 969 "iagno.c"
		GtkWindow* _tmp50_ = NULL;
#line 186 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp50_ = self->priv->window;
#line 186 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		gtk_window_maximize (_tmp50_);
#line 975 "iagno.c"
	}
#line 187 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp51_ = self->priv->window;
#line 187 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_application_add_window ((GtkApplication*) self, _tmp51_);
#line 192 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_settings_sync ();
#line 193 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp52_ = self->priv->settings;
#line 193 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp53_ = iagno_play_as;
#line 193 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_settings_set_string (_tmp52_, "play-as", _tmp53_);
#line 194 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp54_ = self->priv->settings;
#line 194 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp55_ = iagno_computer_level;
#line 194 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_settings_set_int (_tmp54_, "computer-level", _tmp55_);
#line 197 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp56_ = game_view_new ();
#line 197 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp56_);
#line 197 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->view);
#line 197 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->view = _tmp56_;
#line 198 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp57_ = self->priv->view;
#line 198 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp57_, "move", (GCallback) _iagno_player_move_cb_game_view_move, self, 0);
#line 199 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp58_ = self->priv->settings;
#line 199 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp59_ = g_settings_get_string (_tmp58_, "tileset");
#line 199 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	tile_set = _tmp59_;
#line 200 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp60_ = self->priv->view;
#line 200 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp61_ = tile_set;
#line 200 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp62_ = g_build_filename (DATA_DIRECTORY, "themes", _tmp61_, NULL);
#line 200 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp63_ = _tmp62_;
#line 200 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	game_view_set_theme (_tmp60_, _tmp63_);
#line 200 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_free0 (_tmp63_);
#line 201 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp64_ = self->priv->view;
#line 201 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp64_, GTK_ALIGN_FILL);
#line 202 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp65_ = self->priv->view;
#line 202 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_show ((GtkWidget*) _tmp65_);
#line 204 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp66_ = builder;
#line 204 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp67_ = gtk_builder_get_object (_tmp66_, "game-box");
#line 204 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp68_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp67_, gtk_box_get_type ()) ? ((GtkBox*) _tmp67_) : NULL);
#line 204 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	game_box = _tmp68_;
#line 205 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp69_ = game_box;
#line 205 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp70_ = self->priv->view;
#line 205 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_box_pack_start (_tmp69_, (GtkWidget*) _tmp70_, TRUE, TRUE, (guint) 0);
#line 208 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp71_ = builder;
#line 208 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp72_ = gtk_builder_get_object (_tmp71_, "headerbar");
#line 208 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp73_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp72_, gtk_header_bar_get_type ()) ? ((GtkHeaderBar*) _tmp72_) : NULL);
#line 208 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 208 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->headerbar = _tmp73_;
#line 209 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp74_ = builder;
#line 209 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp75_ = gtk_builder_get_object (_tmp74_, "light-score-label");
#line 209 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp76_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp75_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp75_) : NULL);
#line 209 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->light_score_label);
#line 209 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->light_score_label = _tmp76_;
#line 210 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp77_ = builder;
#line 210 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp78_ = gtk_builder_get_object (_tmp77_, "dark-score-label");
#line 210 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp79_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp78_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp78_) : NULL);
#line 210 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->dark_score_label);
#line 210 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->dark_score_label = _tmp79_;
#line 211 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp80_ = builder;
#line 211 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp81_ = gtk_builder_get_object (_tmp80_, "mark-icon-dark");
#line 211 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp82_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp81_, gtk_image_get_type ()) ? ((GtkImage*) _tmp81_) : NULL);
#line 211 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->mark_icon_dark);
#line 211 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->mark_icon_dark = _tmp82_;
#line 212 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp83_ = builder;
#line 212 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp84_ = gtk_builder_get_object (_tmp83_, "mark-icon-light");
#line 212 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp85_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp84_, gtk_image_get_type ()) ? ((GtkImage*) _tmp84_) : NULL);
#line 212 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->mark_icon_light);
#line 212 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->mark_icon_light = _tmp85_;
#line 215 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp86_ = builder;
#line 215 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp87_ = gtk_builder_get_object (_tmp86_, "main_stack");
#line 215 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp88_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp87_, gtk_stack_get_type ()) ? ((GtkStack*) _tmp87_) : NULL);
#line 215 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->main_stack);
#line 215 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->main_stack = _tmp88_;
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp89_ = builder;
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp90_ = gtk_builder_get_object (_tmp89_, "back_button");
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp91_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp90_, gtk_button_get_type ()) ? ((GtkButton*) _tmp90_) : NULL);
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->back_button);
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->back_button = _tmp91_;
#line 217 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp92_ = builder;
#line 217 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp93_ = gtk_builder_get_object (_tmp92_, "undo_button");
#line 217 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp94_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp93_, gtk_button_get_type ()) ? ((GtkButton*) _tmp93_) : NULL);
#line 217 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->undo_button);
#line 217 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->undo_button = _tmp94_;
#line 219 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp95_ = g_action_map_lookup_action ((GActionMap*) self, "back");
#line 219 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp96_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, g_simple_action_get_type (), GSimpleAction));
#line 219 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->back_action);
#line 219 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->back_action = _tmp96_;
#line 221 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp97_ = iagno_begin_with_new_game_screen;
#line 221 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp97_) {
#line 222 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		iagno_show_new_game_screen (self);
#line 1141 "iagno.c"
	} else {
#line 224 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		iagno_start_game (self);
#line 1145 "iagno.c"
	}
#line 146 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (game_box);
#line 146 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_free0 (tile_set);
#line 146 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (builder);
#line 146 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	block3_data_unref (_data3_);
#line 146 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_data3_ = NULL;
#line 1157 "iagno.c"
}


static void iagno_real_activate (GApplication* base) {
	Iagno * self;
	GtkWindow* _tmp0_ = NULL;
#line 227 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self = (Iagno*) base;
#line 229 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->window;
#line 229 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_window_present (_tmp0_);
#line 1170 "iagno.c"
}


static void iagno_real_shutdown (GApplication* base) {
	Iagno * self;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 232 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self = (Iagno*) base;
#line 234 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	G_APPLICATION_CLASS (iagno_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 237 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->settings;
#line 237 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = self->priv->window_width;
#line 237 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_settings_set_int (_tmp0_, "window-width", _tmp1_);
#line 238 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = self->priv->settings;
#line 238 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = self->priv->window_height;
#line 238 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_settings_set_int (_tmp2_, "window-height", _tmp3_);
#line 239 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_ = self->priv->settings;
#line 239 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp5_ = self->priv->is_maximized;
#line 239 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp5_);
#line 1204 "iagno.c"
}


static gboolean iagno_window_configure_event_cb (Iagno* self, GdkEventConfigure* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 242 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 242 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 244 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = self->priv->is_maximized;
#line 244 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (!_tmp1_) {
#line 1220 "iagno.c"
		gboolean _tmp2_ = FALSE;
#line 244 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp2_ = self->priv->is_fullscreen;
#line 244 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp0_ = !_tmp2_;
#line 1226 "iagno.c"
	} else {
#line 244 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp0_ = FALSE;
#line 1230 "iagno.c"
	}
#line 244 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp0_) {
#line 1234 "iagno.c"
		GdkEventConfigure* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		GdkEventConfigure* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 246 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp3_ = event;
#line 246 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp4_ = _tmp3_->width;
#line 246 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		self->priv->window_width = _tmp4_;
#line 247 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp5_ = event;
#line 247 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp6_ = _tmp5_->height;
#line 247 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		self->priv->window_height = _tmp6_;
#line 1251 "iagno.c"
	}
#line 250 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	result = FALSE;
#line 250 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return result;
#line 1257 "iagno.c"
}


static gboolean iagno_window_state_event_cb (Iagno* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState* _tmp4_ = NULL;
	GdkWindowState _tmp5_ = 0;
#line 253 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 253 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 255 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = event;
#line 255 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = _tmp0_->changed_mask;
#line 255 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 1277 "iagno.c"
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
#line 256 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp2_ = event;
#line 256 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp3_ = _tmp2_->new_window_state;
#line 256 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 1286 "iagno.c"
	}
#line 257 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_ = event;
#line 257 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp5_ = _tmp4_->changed_mask;
#line 257 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if ((_tmp5_ & GDK_WINDOW_STATE_FULLSCREEN) != 0) {
#line 1294 "iagno.c"
		GdkEventWindowState* _tmp6_ = NULL;
		GdkWindowState _tmp7_ = 0;
#line 258 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp6_ = event;
#line 258 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp7_ = _tmp6_->new_window_state;
#line 258 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		self->priv->is_fullscreen = (_tmp7_ & GDK_WINDOW_STATE_FULLSCREEN) != 0;
#line 1303 "iagno.c"
	}
#line 259 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	result = FALSE;
#line 259 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return result;
#line 1309 "iagno.c"
}


static void iagno_start_game_cb (Iagno* self) {
	GtkButton* _tmp0_ = NULL;
#line 262 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 264 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->back_button;
#line 264 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, FALSE);
#line 265 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_start_game (self);
#line 1323 "iagno.c"
}


static void iagno_back_cb (Iagno* self) {
	GSimpleAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	Game* _tmp3_ = NULL;
	Player _tmp4_ = 0;
	Player _tmp5_ = 0;
	Player _tmp6_ = 0;
#line 268 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 270 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_show_game_board (self);
#line 271 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->back_action;
#line 271 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_simple_action_set_enabled (_tmp0_, FALSE);
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = self->priv->game;
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_ = game_get_current_color (_tmp3_);
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp5_ = _tmp4_;
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp6_ = self->priv->player_one;
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp5_ != _tmp6_) {
#line 1353 "iagno.c"
		ComputerPlayer* _tmp7_ = NULL;
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp7_ = self->priv->computer;
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp2_ = _tmp7_ != NULL;
#line 1359 "iagno.c"
	} else {
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp2_ = FALSE;
#line 1363 "iagno.c"
	}
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp2_) {
#line 1367 "iagno.c"
		Game* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp8_ = self->priv->game;
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp9_ = game_get_is_complete (_tmp8_);
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp10_ = _tmp9_;
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp1_ = !_tmp10_;
#line 1379 "iagno.c"
	} else {
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp1_ = FALSE;
#line 1383 "iagno.c"
	}
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp1_) {
#line 1387 "iagno.c"
		ComputerPlayer* _tmp11_ = NULL;
#line 274 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp11_ = self->priv->computer;
#line 274 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		computer_player_move_async (_tmp11_, IAGNO_SLOW_MOVE_DELAY, NULL, NULL);
#line 1393 "iagno.c"
	} else {
		Game* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
#line 275 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp12_ = self->priv->game;
#line 275 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp13_ = game_get_is_complete (_tmp12_);
#line 275 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp14_ = _tmp13_;
#line 275 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		if (_tmp14_) {
#line 276 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			iagno_game_complete (self, FALSE);
#line 1408 "iagno.c"
		}
	}
}


static void iagno_show_game_board (Iagno* self) {
	GtkStack* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
#line 279 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 281 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->main_stack;
#line 281 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_stack_set_visible_child_name (_tmp0_, "frame");
#line 282 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = self->priv->back_button;
#line 282 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, FALSE);
#line 283 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = self->priv->undo_button;
#line 283 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, TRUE);
#line 1432 "iagno.c"
}


static void iagno_show_new_game_screen (Iagno* self) {
	ComputerPlayer* _tmp0_ = NULL;
	GtkStack* _tmp2_ = NULL;
	GtkButton* _tmp3_ = NULL;
#line 286 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 288 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->computer;
#line 288 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp0_ != NULL) {
#line 1446 "iagno.c"
		ComputerPlayer* _tmp1_ = NULL;
#line 289 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp1_ = self->priv->computer;
#line 289 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		computer_player_cancel_move (_tmp1_);
#line 1452 "iagno.c"
	}
#line 291 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = self->priv->main_stack;
#line 291 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_stack_set_visible_child_name (_tmp2_, "start-box");
#line 292 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = self->priv->undo_button;
#line 292 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, FALSE);
#line 1462 "iagno.c"
}


static void iagno_new_game_cb (Iagno* self) {
	GtkHeaderBar* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
#line 295 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 297 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_show_new_game_screen (self);
#line 298 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->headerbar;
#line 298 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_header_bar_set_subtitle (_tmp0_, NULL);
#line 299 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = self->priv->back_button;
#line 299 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, TRUE);
#line 300 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = self->priv->back_action;
#line 300 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_simple_action_set_enabled (_tmp2_, TRUE);
#line 1486 "iagno.c"
}


static void _iagno_turn_ended_cb_game_turn_ended (Game* _sender, gpointer self) {
#line 314 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_turn_ended_cb ((Iagno*) self);
#line 1493 "iagno.c"
}


static void iagno_start_game (Iagno* self) {
	Game* _tmp0_ = NULL;
	ComputerPlayer* _tmp2_ = NULL;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_ = 0;
	Game* _tmp6_ = NULL;
	Game* _tmp7_ = NULL;
	GameView* _tmp8_ = NULL;
	Game* _tmp9_ = NULL;
	gchar* mode = NULL;
	GSettings* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	Player _tmp17_ = 0;
	const gchar* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	Player _tmp20_ = 0;
#line 303 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 305 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->game;
#line 305 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp0_ != NULL) {
#line 1520 "iagno.c"
		Game* _tmp1_ = NULL;
#line 306 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp1_ = self->priv->game;
#line 306 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
#line 1526 "iagno.c"
	}
#line 308 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = self->priv->computer;
#line 308 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp2_ != NULL) {
#line 1532 "iagno.c"
		ComputerPlayer* _tmp3_ = NULL;
#line 309 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp3_ = self->priv->computer;
#line 309 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		computer_player_cancel_move (_tmp3_);
#line 1538 "iagno.c"
	}
#line 311 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_show_game_board (self);
#line 313 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_ = iagno_alternative_start;
#line 313 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp5_ = iagno_size;
#line 313 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp6_ = game_new (_tmp4_, _tmp5_);
#line 313 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->game);
#line 313 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->game = _tmp6_;
#line 314 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp7_ = self->priv->game;
#line 314 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp7_, "turn-ended", (GCallback) _iagno_turn_ended_cb_game_turn_ended, self, 0);
#line 315 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp8_ = self->priv->view;
#line 315 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp9_ = self->priv->game;
#line 315 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	game_view_set_game (_tmp8_, _tmp9_);
#line 317 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp10_ = self->priv->settings;
#line 317 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp11_ = g_settings_get_string (_tmp10_, "play-as");
#line 317 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	mode = _tmp11_;
#line 318 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp12_ = mode;
#line 318 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (g_strcmp0 (_tmp12_, "two-players") == 0) {
#line 319 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_object_unref0 (self->priv->computer);
#line 319 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		self->priv->computer = NULL;
#line 1576 "iagno.c"
	} else {
		Game* _tmp13_ = NULL;
		GSettings* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		ComputerPlayer* _tmp16_ = NULL;
#line 321 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp13_ = self->priv->game;
#line 321 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp14_ = self->priv->settings;
#line 321 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp15_ = g_settings_get_int (_tmp14_, "computer-level");
#line 321 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp16_ = computer_player_new (_tmp13_, _tmp15_);
#line 321 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_object_unref0 (self->priv->computer);
#line 321 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		self->priv->computer = _tmp16_;
#line 1594 "iagno.c"
	}
#line 323 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp18_ = mode;
#line 323 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (g_strcmp0 (_tmp18_, "first") == 0) {
#line 323 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp17_ = PLAYER_DARK;
#line 1602 "iagno.c"
	} else {
#line 323 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp17_ = PLAYER_LIGHT;
#line 1606 "iagno.c"
	}
#line 323 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->player_one = _tmp17_;
#line 325 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_update_ui (self);
#line 327 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp20_ = self->priv->player_one;
#line 327 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp20_ != PLAYER_DARK) {
#line 1616 "iagno.c"
		ComputerPlayer* _tmp21_ = NULL;
#line 327 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp21_ = self->priv->computer;
#line 327 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp19_ = _tmp21_ != NULL;
#line 1622 "iagno.c"
	} else {
#line 327 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp19_ = FALSE;
#line 1626 "iagno.c"
	}
#line 327 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp19_) {
#line 1630 "iagno.c"
		ComputerPlayer* _tmp22_ = NULL;
#line 328 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp22_ = self->priv->computer;
#line 328 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		computer_player_move_async (_tmp22_, IAGNO_MODERATE_MOVE_DELAY, NULL, NULL);
#line 1636 "iagno.c"
	}
#line 303 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_free0 (mode);
#line 1640 "iagno.c"
}


static void iagno_update_ui (Iagno* self) {
	GtkHeaderBar* _tmp0_ = NULL;
	GSimpleAction* undo_action = NULL;
	GAction* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	Player _tmp4_ = 0;
	GtkLabel* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	Game* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	GtkLabel* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	Game* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	Game* _tmp36_ = NULL;
	Player _tmp37_ = 0;
	Player _tmp38_ = 0;
#line 331 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 333 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->headerbar;
#line 333 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_header_bar_set_subtitle (_tmp0_, NULL);
#line 335 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) self, "undo-move");
#line 335 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction));
#line 335 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	undo_action = _tmp2_;
#line 336 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_ = self->priv->player_one;
#line 336 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp4_ == PLAYER_DARK) {
#line 336 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp3_ = TRUE;
#line 1694 "iagno.c"
	} else {
		ComputerPlayer* _tmp5_ = NULL;
#line 336 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp5_ = self->priv->computer;
#line 336 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp3_ = _tmp5_ == NULL;
#line 1701 "iagno.c"
	}
#line 336 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp3_) {
#line 1705 "iagno.c"
		GSimpleAction* _tmp6_ = NULL;
		Game* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
#line 337 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp6_ = undo_action;
#line 337 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp7_ = self->priv->game;
#line 337 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp8_ = game_get_number_of_moves (_tmp7_);
#line 337 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp9_ = _tmp8_;
#line 337 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_simple_action_set_enabled (_tmp6_, _tmp9_ >= 1);
#line 1720 "iagno.c"
	} else {
		GSimpleAction* _tmp10_ = NULL;
		Game* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
#line 339 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp10_ = undo_action;
#line 339 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp11_ = self->priv->game;
#line 339 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp12_ = game_get_number_of_moves (_tmp11_);
#line 339 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp13_ = _tmp12_;
#line 339 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_simple_action_set_enabled (_tmp10_, _tmp13_ >= 2);
#line 1736 "iagno.c"
	}
#line 342 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp14_ = self->priv->dark_score_label;
#line 342 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp15_ = _ ("%.2d");
#line 342 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp16_ = self->priv->game;
#line 342 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp17_ = game_get_n_dark_tiles (_tmp16_);
#line 342 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp18_ = _tmp17_;
#line 342 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp19_ = g_strdup_printf (_tmp15_, _tmp18_);
#line 342 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp20_ = _tmp19_;
#line 342 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp21_ = g_strconcat ("<span font_weight='bold'>", _tmp20_, NULL);
#line 342 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp22_ = _tmp21_;
#line 342 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp23_ = g_strconcat (_tmp22_, "</span>", NULL);
#line 342 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp24_ = _tmp23_;
#line 342 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_label_set_markup (_tmp14_, _tmp24_);
#line 342 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_free0 (_tmp24_);
#line 342 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_free0 (_tmp22_);
#line 342 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_free0 (_tmp20_);
#line 343 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp25_ = self->priv->light_score_label;
#line 343 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp26_ = _ ("%.2d");
#line 343 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp27_ = self->priv->game;
#line 343 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp28_ = game_get_n_light_tiles (_tmp27_);
#line 343 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp29_ = _tmp28_;
#line 343 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp30_ = g_strdup_printf (_tmp26_, _tmp29_);
#line 343 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp31_ = _tmp30_;
#line 343 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp32_ = g_strconcat ("<span font_weight='bold'>", _tmp31_, NULL);
#line 343 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp33_ = _tmp32_;
#line 343 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp34_ = g_strconcat (_tmp33_, "</span>", NULL);
#line 343 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp35_ = _tmp34_;
#line 343 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_label_set_markup (_tmp25_, _tmp35_);
#line 343 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_free0 (_tmp35_);
#line 343 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_free0 (_tmp33_);
#line 343 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_free0 (_tmp31_);
#line 345 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp36_ = self->priv->game;
#line 345 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp37_ = game_get_current_color (_tmp36_);
#line 345 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp38_ = _tmp37_;
#line 345 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp38_ == PLAYER_DARK) {
#line 1806 "iagno.c"
		GtkImage* _tmp39_ = NULL;
		GtkImage* _tmp40_ = NULL;
#line 347 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp39_ = self->priv->mark_icon_light;
#line 347 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		gtk_widget_hide ((GtkWidget*) _tmp39_);
#line 348 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp40_ = self->priv->mark_icon_dark;
#line 348 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		gtk_widget_show ((GtkWidget*) _tmp40_);
#line 1817 "iagno.c"
	} else {
		Game* _tmp41_ = NULL;
		Player _tmp42_ = 0;
		Player _tmp43_ = 0;
#line 350 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp41_ = self->priv->game;
#line 350 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp42_ = game_get_current_color (_tmp41_);
#line 350 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp43_ = _tmp42_;
#line 350 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		if (_tmp43_ == PLAYER_LIGHT) {
#line 1830 "iagno.c"
			GtkImage* _tmp44_ = NULL;
			GtkImage* _tmp45_ = NULL;
#line 352 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp44_ = self->priv->mark_icon_dark;
#line 352 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			gtk_widget_hide ((GtkWidget*) _tmp44_);
#line 353 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp45_ = self->priv->mark_icon_light;
#line 353 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			gtk_widget_show ((GtkWidget*) _tmp45_);
#line 1841 "iagno.c"
		}
	}
#line 331 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (undo_action);
#line 1846 "iagno.c"
}


static void iagno_undo_move_cb (Iagno* self) {
	ComputerPlayer* _tmp0_ = NULL;
#line 357 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 359 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->computer;
#line 359 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp0_ == NULL) {
#line 1858 "iagno.c"
		Game* _tmp1_ = NULL;
		Game* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 361 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp1_ = self->priv->game;
#line 361 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		game_undo (_tmp1_, 1);
#line 362 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp2_ = self->priv->game;
#line 362 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp3_ = game_get_current_player_can_move (_tmp2_);
#line 362 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp4_ = _tmp3_;
#line 362 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		if (!_tmp4_) {
#line 1875 "iagno.c"
			Game* _tmp5_ = NULL;
#line 363 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp5_ = self->priv->game;
#line 363 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			game_undo (_tmp5_, 1);
#line 1881 "iagno.c"
		}
	} else {
		ComputerPlayer* _tmp6_ = NULL;
		Game* _tmp7_ = NULL;
		Player _tmp8_ = 0;
		Player _tmp9_ = 0;
		Player _tmp10_ = 0;
#line 367 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp6_ = self->priv->computer;
#line 367 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		computer_player_cancel_move (_tmp6_);
#line 370 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp7_ = self->priv->game;
#line 370 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp8_ = game_get_current_color (_tmp7_);
#line 370 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp9_ = _tmp8_;
#line 370 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp10_ = self->priv->player_one;
#line 370 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		if (_tmp9_ != _tmp10_) {
#line 1903 "iagno.c"
			Game* _tmp11_ = NULL;
#line 371 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp11_ = self->priv->game;
#line 371 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			game_undo (_tmp11_, 1);
#line 1909 "iagno.c"
		} else {
			Game* _tmp12_ = NULL;
#line 373 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp12_ = self->priv->game;
#line 373 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			game_undo (_tmp12_, 2);
#line 1916 "iagno.c"
		}
#line 376 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		while (TRUE) {
#line 1920 "iagno.c"
			Game* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_ = FALSE;
			Game* _tmp16_ = NULL;
#line 376 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp13_ = self->priv->game;
#line 376 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp14_ = game_get_current_player_can_move (_tmp13_);
#line 376 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp15_ = _tmp14_;
#line 376 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			if (!(!_tmp15_)) {
#line 376 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				break;
#line 1935 "iagno.c"
			}
#line 377 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp16_ = self->priv->game;
#line 377 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			game_undo (_tmp16_, 2);
#line 1941 "iagno.c"
		}
	}
#line 380 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_update_ui (self);
#line 381 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_play_sound (self, "flip-piece");
#line 1948 "iagno.c"
}


static void iagno_turn_ended_cb (Iagno* self) {
	Game* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 384 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 386 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_update_ui (self);
#line 387 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->game;
#line 387 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = game_get_current_player_can_move (_tmp0_);
#line 387 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = _tmp1_;
#line 387 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp2_) {
#line 388 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		iagno_prepare_move (self);
#line 1970 "iagno.c"
	} else {
		Game* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
#line 389 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp3_ = self->priv->game;
#line 389 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp4_ = game_get_is_complete (_tmp3_);
#line 389 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp5_ = _tmp4_;
#line 389 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		if (_tmp5_) {
#line 390 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			iagno_game_complete (self, TRUE);
#line 1985 "iagno.c"
		} else {
#line 392 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			iagno_pass (self);
#line 1989 "iagno.c"
		}
	}
}


static void iagno_prepare_move (Iagno* self) {
	gboolean _tmp0_ = FALSE;
	Game* _tmp1_ = NULL;
	Player _tmp2_ = 0;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
#line 395 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 398 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_play_sound (self, "flip-piece");
#line 405 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = self->priv->game;
#line 405 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = game_get_current_color (_tmp1_);
#line 405 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = _tmp2_;
#line 405 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_ = self->priv->player_one;
#line 405 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp3_ != _tmp4_) {
#line 2015 "iagno.c"
		ComputerPlayer* _tmp5_ = NULL;
#line 405 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp5_ = self->priv->computer;
#line 405 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp0_ = _tmp5_ != NULL;
#line 2021 "iagno.c"
	} else {
#line 405 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp0_ = FALSE;
#line 2025 "iagno.c"
	}
#line 405 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp0_) {
#line 2029 "iagno.c"
		gboolean _tmp6_ = FALSE;
#line 407 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp6_ = iagno_fast_mode;
#line 407 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		if (_tmp6_) {
#line 2035 "iagno.c"
			ComputerPlayer* _tmp7_ = NULL;
#line 408 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp7_ = self->priv->computer;
#line 408 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			computer_player_move_async (_tmp7_, IAGNO_QUICK_MOVE_DELAY, NULL, NULL);
#line 2041 "iagno.c"
		} else {
			ComputerPlayer* _tmp8_ = NULL;
#line 410 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp8_ = self->priv->computer;
#line 410 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			computer_player_move_async (_tmp8_, IAGNO_SLOW_MOVE_DELAY, NULL, NULL);
#line 2048 "iagno.c"
		}
	}
}


static void iagno_pass (Iagno* self) {
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Player _tmp2_ = 0;
	Player _tmp3_ = 0;
#line 414 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 417 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_play_sound (self, "flip-piece");
#line 419 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->game;
#line 419 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	game_pass (_tmp0_);
#line 420 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = self->priv->game;
#line 420 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = game_get_current_color (_tmp1_);
#line 420 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = _tmp2_;
#line 420 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp3_ == PLAYER_DARK) {
#line 2075 "iagno.c"
		GtkHeaderBar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 423 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp4_ = self->priv->headerbar;
#line 423 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp5_ = _ ("Light must pass, Dark’s move");
#line 423 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		gtk_header_bar_set_subtitle (_tmp4_, _tmp5_);
#line 2084 "iagno.c"
	} else {
		GtkHeaderBar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 428 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp6_ = self->priv->headerbar;
#line 428 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp7_ = _ ("Dark must pass, Light’s move");
#line 428 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		gtk_header_bar_set_subtitle (_tmp6_, _tmp7_);
#line 2094 "iagno.c"
	}
}


static void iagno_game_complete (Iagno* self, gboolean play_gameover_sound) {
	Game* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Game* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp18_ = FALSE;
#line 432 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 434 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->game;
#line 434 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = game_get_n_light_tiles (_tmp0_);
#line 434 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = _tmp1_;
#line 434 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = self->priv->game;
#line 434 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_ = game_get_n_dark_tiles (_tmp3_);
#line 434 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp5_ = _tmp4_;
#line 434 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp2_ > _tmp5_) {
#line 2123 "iagno.c"
		GtkHeaderBar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 437 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp6_ = self->priv->headerbar;
#line 437 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp7_ = _ ("Light wins!");
#line 437 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		gtk_header_bar_set_subtitle (_tmp6_, _tmp7_);
#line 2132 "iagno.c"
	} else {
		Game* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		Game* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
#line 439 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp8_ = self->priv->game;
#line 439 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp9_ = game_get_n_dark_tiles (_tmp8_);
#line 439 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp10_ = _tmp9_;
#line 439 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp11_ = self->priv->game;
#line 439 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp12_ = game_get_n_light_tiles (_tmp11_);
#line 439 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp13_ = _tmp12_;
#line 439 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		if (_tmp10_ > _tmp13_) {
#line 2154 "iagno.c"
			GtkHeaderBar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
#line 442 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp14_ = self->priv->headerbar;
#line 442 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp15_ = _ ("Dark wins!");
#line 442 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			gtk_header_bar_set_subtitle (_tmp14_, _tmp15_);
#line 2163 "iagno.c"
		} else {
			GtkHeaderBar* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
#line 447 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp16_ = self->priv->headerbar;
#line 447 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp17_ = _ ("The game is draw.");
#line 447 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			gtk_header_bar_set_subtitle (_tmp16_, _tmp17_);
#line 2173 "iagno.c"
		}
	}
#line 450 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp18_ = play_gameover_sound;
#line 450 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp18_) {
#line 451 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		iagno_play_sound (self, "gameover");
#line 2182 "iagno.c"
	}
}


static void iagno_play_sound (Iagno* self, const gchar* name) {
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GameView* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
#line 454 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 454 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (name != NULL);
#line 456 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->settings;
#line 456 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = g_settings_get_boolean (_tmp0_, "sound");
#line 456 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (!_tmp1_) {
#line 457 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		return;
#line 2209 "iagno.c"
	}
#line 459 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = self->priv->view;
#line 459 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = name;
#line 459 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_ = name;
#line 459 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp5_ = g_strdup_printf ("%s.ogg", _tmp4_);
#line 459 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp6_ = _tmp5_;
#line 459 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp7_ = g_build_filename (SOUND_DIRECTORY, _tmp6_, NULL);
#line 459 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp8_ = _tmp7_;
#line 459 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	ca_gtk_play_for_widget ((GtkWidget*) _tmp2_, (guint32) 0, CA_PROP_MEDIA_NAME, _tmp3_, CA_PROP_MEDIA_FILENAME, _tmp8_, NULL);
#line 459 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_free0 (_tmp8_);
#line 459 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_free0 (_tmp6_);
#line 2231 "iagno.c"
}


static void iagno_player_move_cb (Iagno* self, gint x, gint y) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Game* _tmp2_ = NULL;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
	Player _tmp5_ = 0;
	Game* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
#line 464 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 467 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = self->priv->game;
#line 467 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = game_get_current_color (_tmp2_);
#line 467 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_ = _tmp3_;
#line 467 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp5_ = self->priv->player_one;
#line 467 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp4_ != _tmp5_) {
#line 2258 "iagno.c"
		ComputerPlayer* _tmp6_ = NULL;
#line 467 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp6_ = self->priv->computer;
#line 467 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp1_ = _tmp6_ != NULL;
#line 2264 "iagno.c"
	} else {
#line 467 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp1_ = FALSE;
#line 2268 "iagno.c"
	}
#line 467 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp1_) {
#line 467 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp0_ = TRUE;
#line 2274 "iagno.c"
	} else {
		Game* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
#line 467 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp7_ = self->priv->game;
#line 467 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp8_ = game_get_current_player_can_move (_tmp7_);
#line 467 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp9_ = _tmp8_;
#line 467 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp0_ = !_tmp9_;
#line 2287 "iagno.c"
	}
#line 467 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp0_) {
#line 468 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		return;
#line 2293 "iagno.c"
	}
#line 470 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp10_ = self->priv->game;
#line 470 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp11_ = x;
#line 470 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp12_ = y;
#line 470 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp13_ = game_place_tile (_tmp10_, _tmp11_, _tmp12_, TRUE);
#line 470 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp13_ == 0) {
#line 2305 "iagno.c"
		GtkHeaderBar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
#line 473 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp14_ = self->priv->headerbar;
#line 473 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp15_ = _ ("You can’t move there!");
#line 473 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		gtk_header_bar_set_subtitle (_tmp14_, _tmp15_);
#line 2314 "iagno.c"
	}
}


static gboolean iagno_propbox_close_cb (Iagno* self, GtkWidget* widget, GdkEventAny* event) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_ = NULL;
#line 481 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 481 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 481 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 483 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = widget;
#line 483 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_hide (_tmp0_);
#line 484 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	result = TRUE;
#line 484 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return result;
#line 2336 "iagno.c"
}


static void iagno_theme_changed_cb (Iagno* self, GtkComboBox* widget) {
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	gchar* tile_set = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	GtkTreeIter _tmp7_ = {0};
	GSettings* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GameView* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
#line 487 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 487 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (widget != NULL);
#line 489 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = widget;
#line 489 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
#line 489 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 489 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	model = _tmp2_;
#line 491 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = widget;
#line 491 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp5_ = gtk_combo_box_get_active_iter (_tmp3_, &_tmp4_);
#line 491 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iter = _tmp4_;
#line 491 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (!_tmp5_) {
#line 492 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_object_unref0 (model);
#line 492 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		return;
#line 2382 "iagno.c"
	}
#line 494 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp6_ = model;
#line 494 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp7_ = iter;
#line 494 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_tree_model_get (_tmp6_, &_tmp7_, 1, &tile_set, -1);
#line 495 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp8_ = self->priv->settings;
#line 495 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp9_ = tile_set;
#line 495 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_settings_set_string (_tmp8_, "tileset", _tmp9_);
#line 496 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp10_ = self->priv->view;
#line 496 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp11_ = tile_set;
#line 496 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp12_ = g_build_filename (DATA_DIRECTORY, "themes", _tmp11_, NULL);
#line 496 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp13_ = _tmp12_;
#line 496 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	game_view_set_theme (_tmp10_, _tmp13_);
#line 496 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_free0 (_tmp13_);
#line 487 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_free0 (tile_set);
#line 487 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (model);
#line 2412 "iagno.c"
}


static gboolean _iagno_propbox_close_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = iagno_propbox_close_cb ((Iagno*) self, _sender, event);
#line 510 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	return result;
#line 2421 "iagno.c"
}


static void _g_free0_ (gpointer var) {
#line 522 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	var = (g_free (var), NULL);
#line 2428 "iagno.c"
}


static void _g_list_free__g_free0_ (GList* self) {
#line 522 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
#line 522 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_list_free (self);
#line 2437 "iagno.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1282 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1282 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1282 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 2450 "iagno.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 2481 "iagno.c"
				goto __catch3_g_regex_error;
			}
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return NULL;
#line 2490 "iagno.c"
		}
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 2506 "iagno.c"
				goto __catch3_g_regex_error;
			}
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return NULL;
#line 2517 "iagno.c"
		}
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 2531 "iagno.c"
	}
	goto __finally3;
	__catch3_g_regex_error:
	{
		GError* e = NULL;
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1287 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 2545 "iagno.c"
	}
	__finally3:
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return NULL;
#line 2556 "iagno.c"
	}
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 930 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 931 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 931 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 931 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
#line 931 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 933 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 933 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 2582 "iagno.c"
		gchar* _tmp4_ = NULL;
#line 934 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 934 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 934 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 2590 "iagno.c"
	} else {
#line 936 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = -1;
#line 936 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 2596 "iagno.c"
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1197 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1198 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1198 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 2620 "iagno.c"
		glong _tmp4_ = 0L;
#line 1199 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1199 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1199 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 2628 "iagno.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1201 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1201 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1201 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1201 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 2640 "iagno.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1208 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 2664 "iagno.c"
		glong _tmp2_ = 0L;
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 2670 "iagno.c"
	} else {
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 2674 "iagno.c"
	}
#line 1210 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 2678 "iagno.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1212 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1212 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1212 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1212 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 2690 "iagno.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1214 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1214 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1214 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 2700 "iagno.c"
	}
#line 1217 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1217 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 2706 "iagno.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1218 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1218 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1218 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1219 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1219 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 2720 "iagno.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1221 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1221 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1221 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 2730 "iagno.c"
	}
#line 1223 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1223 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 2736 "iagno.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1224 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1224 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1224 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 2745 "iagno.c"
	}
#line 1226 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1226 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1226 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1226 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1227 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 2765 "iagno.c"
}


static void _iagno_theme_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 553 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_theme_changed_cb ((Iagno*) self, _sender);
#line 2772 "iagno.c"
}


static void iagno_create_preferences_dialog (Iagno* self) {
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkWindow* _tmp2_ = NULL;
	GtkDialog* _tmp3_ = NULL;
	GtkBox* box = NULL;
	GtkDialog* _tmp4_ = NULL;
	GtkBox* _tmp5_ = NULL;
	GtkBox* _tmp6_ = NULL;
	GtkDialog* _tmp7_ = NULL;
	GtkDialog* _tmp8_ = NULL;
	GtkGrid* grid = NULL;
	GtkBuilder* _tmp9_ = NULL;
	GObject* _tmp10_ = NULL;
	GtkGrid* _tmp11_ = NULL;
	GtkBox* _tmp12_ = NULL;
	GtkGrid* _tmp13_ = NULL;
	GtkComboBox* theme_combo = NULL;
	GtkBuilder* _tmp14_ = NULL;
	GObject* _tmp15_ = NULL;
	GtkComboBox* _tmp16_ = NULL;
	GtkListStore* model = NULL;
	GtkBuilder* _tmp17_ = NULL;
	GObject* _tmp18_ = NULL;
	GtkListStore* _tmp19_ = NULL;
	GDir* dir = NULL;
	GList* dirlist = NULL;
	GtkTreeIter iter = {0};
	GList* _tmp35_ = NULL;
	GtkComboBox* _tmp60_ = NULL;
	GError * _inner_error_ = NULL;
#line 499 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 501 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = gtk_builder_new_from_resource ("/org/gnome/iagno/ui/iagno-preferences.ui");
#line 501 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	builder = _tmp0_;
#line 504 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = _ ("Preferences");
#line 504 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = self->priv->window;
#line 504 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp1_, _tmp2_, GTK_DIALOG_USE_HEADER_BAR, NULL, NULL);
#line 504 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp3_);
#line 504 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->propbox);
#line 504 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->propbox = _tmp3_;
#line 508 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_ = self->priv->propbox;
#line 508 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp5_ = (GtkBox*) gtk_dialog_get_content_area (_tmp4_);
#line 508 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_box_get_type (), GtkBox));
#line 508 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	box = _tmp6_;
#line 509 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp7_ = self->priv->propbox;
#line 509 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_window_set_resizable ((GtkWindow*) _tmp7_, FALSE);
#line 510 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp8_ = self->priv->propbox;
#line 510 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_signal_connect_object ((GtkWidget*) _tmp8_, "delete-event", (GCallback) _iagno_propbox_close_cb_gtk_widget_delete_event, self, 0);
#line 511 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp9_ = builder;
#line 511 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp10_ = gtk_builder_get_object (_tmp9_, "main-grid");
#line 511 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, gtk_grid_get_type ()) ? ((GtkGrid*) _tmp10_) : NULL);
#line 511 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	grid = _tmp11_;
#line 512 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp12_ = box;
#line 512 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp13_ = grid;
#line 512 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_box_pack_start (_tmp12_, (GtkWidget*) _tmp13_, TRUE, TRUE, (guint) 0);
#line 514 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp14_ = builder;
#line 514 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp15_ = gtk_builder_get_object (_tmp14_, "theme-combo");
#line 514 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, gtk_combo_box_get_type ()) ? ((GtkComboBox*) _tmp15_) : NULL);
#line 514 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	theme_combo = _tmp16_;
#line 515 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp17_ = builder;
#line 515 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp18_ = gtk_builder_get_object (_tmp17_, "liststore-theme");
#line 515 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, gtk_list_store_get_type ()) ? ((GtkListStore*) _tmp18_) : NULL);
#line 515 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	model = _tmp19_;
#line 517 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	dirlist = NULL;
#line 2874 "iagno.c"
	{
		GDir* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		GDir* _tmp23_ = NULL;
		GDir* _tmp24_ = NULL;
		GDir* _tmp25_ = NULL;
#line 522 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp21_ = g_build_filename (DATA_DIRECTORY, "themes", NULL);
#line 522 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp22_ = _tmp21_;
#line 522 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp23_ = g_dir_open (_tmp22_, (guint) 0, &_inner_error_);
#line 522 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp24_ = _tmp23_;
#line 522 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_free0 (_tmp22_);
#line 522 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp20_ = _tmp24_;
#line 522 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 522 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			if (_inner_error_->domain == G_FILE_ERROR) {
#line 2898 "iagno.c"
				goto __catch2_g_file_error;
			}
#line 522 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			__g_list_free__g_free0_0 (dirlist);
#line 522 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_g_dir_close0 (dir);
#line 522 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_g_object_unref0 (model);
#line 522 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_g_object_unref0 (theme_combo);
#line 522 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_g_object_unref0 (grid);
#line 522 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_g_object_unref0 (box);
#line 522 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_g_object_unref0 (builder);
#line 522 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 522 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			g_clear_error (&_inner_error_);
#line 522 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			return;
#line 2921 "iagno.c"
		}
#line 522 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp25_ = _tmp20_;
#line 522 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp20_ = NULL;
#line 522 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_dir_close0 (dir);
#line 522 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		dir = _tmp25_;
#line 523 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		while (TRUE) {
#line 2933 "iagno.c"
			gchar* filename = NULL;
			GDir* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
			const gchar* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
			GCompareFunc _tmp32_ = NULL;
#line 525 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp26_ = dir;
#line 525 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp27_ = g_dir_read_name (_tmp26_);
#line 525 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp28_ = g_strdup (_tmp27_);
#line 525 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			filename = _tmp28_;
#line 526 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp29_ = filename;
#line 526 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			if (_tmp29_ == NULL) {
#line 527 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_g_free0 (filename);
#line 527 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				break;
#line 2958 "iagno.c"
			}
#line 528 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp30_ = filename;
#line 528 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp31_ = g_strdup (_tmp30_);
#line 528 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp32_ = g_strcmp0;
#line 528 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			dirlist = g_list_insert_sorted (dirlist, _tmp31_, _tmp32_);
#line 523 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_g_free0 (filename);
#line 2970 "iagno.c"
		}
#line 520 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_dir_close0 (_tmp20_);
#line 2974 "iagno.c"
	}
	goto __finally2;
	__catch2_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
#line 520 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		e = _inner_error_;
#line 520 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_inner_error_ = NULL;
#line 533 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp33_ = e;
#line 533 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp34_ = _tmp33_->message;
#line 533 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_warning ("iagno.vala:533: Failed to load themes: %s", _tmp34_);
#line 520 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_error_free0 (e);
#line 2994 "iagno.c"
	}
	__finally2:
#line 520 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 520 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		__g_list_free__g_free0_0 (dirlist);
#line 520 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_dir_close0 (dir);
#line 520 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_object_unref0 (model);
#line 520 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_object_unref0 (theme_combo);
#line 520 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_object_unref0 (grid);
#line 520 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_object_unref0 (box);
#line 520 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_object_unref0 (builder);
#line 520 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 520 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_clear_error (&_inner_error_);
#line 520 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		return;
#line 3019 "iagno.c"
	}
#line 537 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp35_ = dirlist;
#line 3023 "iagno.c"
	{
		GList* filename_collection = NULL;
		GList* filename_it = NULL;
#line 537 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		filename_collection = _tmp35_;
#line 537 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		for (filename_it = filename_collection; filename_it != NULL; filename_it = filename_it->next) {
#line 3031 "iagno.c"
			gchar* _tmp36_ = NULL;
			gchar* filename = NULL;
#line 537 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			_tmp36_ = g_strdup ((const gchar*) filename_it->data);
#line 537 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
			filename = _tmp36_;
#line 3038 "iagno.c"
			{
				GtkListStore* _tmp37_ = NULL;
				GtkTreeIter _tmp38_ = {0};
				gchar* label_text = NULL;
				const gchar* _tmp39_ = NULL;
				gchar* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				gchar* _tmp42_ = NULL;
				gint extension_index = 0;
				const gchar* _tmp43_ = NULL;
				gint _tmp44_ = 0;
				gint _tmp45_ = 0;
				GtkListStore* _tmp49_ = NULL;
				GtkTreeIter _tmp50_ = {0};
				const gchar* _tmp51_ = NULL;
				const gchar* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				GSettings* _tmp54_ = NULL;
				gchar* _tmp55_ = NULL;
				gchar* _tmp56_ = NULL;
				gboolean _tmp57_ = FALSE;
#line 539 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp37_ = model;
#line 539 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				gtk_list_store_append (_tmp37_, &_tmp38_);
#line 539 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				iter = _tmp38_;
#line 542 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp39_ = filename;
#line 542 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp40_ = g_strdup (_tmp39_);
#line 542 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				label_text = _tmp40_;
#line 544 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp41_ = label_text;
#line 544 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp42_ = string_replace (_tmp41_, "_", " ");
#line 544 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_g_free0 (label_text);
#line 544 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				label_text = _tmp42_;
#line 545 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp43_ = label_text;
#line 545 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp44_ = string_last_index_of_char (_tmp43_, (gunichar) '.', 0);
#line 545 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				extension_index = _tmp44_;
#line 546 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp45_ = extension_index;
#line 546 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				if (_tmp45_ > 0) {
#line 3090 "iagno.c"
					const gchar* _tmp46_ = NULL;
					gint _tmp47_ = 0;
					gchar* _tmp48_ = NULL;
#line 547 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
					_tmp46_ = label_text;
#line 547 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
					_tmp47_ = extension_index;
#line 547 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
					_tmp48_ = string_substring (_tmp46_, (glong) 0, (glong) _tmp47_);
#line 547 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
					_g_free0 (label_text);
#line 547 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
					label_text = _tmp48_;
#line 3104 "iagno.c"
				}
#line 549 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp49_ = model;
#line 549 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp50_ = iter;
#line 549 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp51_ = label_text;
#line 549 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp52_ = filename;
#line 549 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				gtk_list_store_set (_tmp49_, &_tmp50_, 0, _tmp51_, 1, _tmp52_, -1);
#line 550 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp53_ = filename;
#line 550 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp54_ = self->priv->settings;
#line 550 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp55_ = g_settings_get_string (_tmp54_, "tileset");
#line 550 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp56_ = _tmp55_;
#line 550 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_tmp57_ = g_strcmp0 (_tmp53_, _tmp56_) == 0;
#line 550 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_g_free0 (_tmp56_);
#line 550 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				if (_tmp57_) {
#line 3130 "iagno.c"
					GtkComboBox* _tmp58_ = NULL;
					GtkTreeIter _tmp59_ = {0};
#line 551 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
					_tmp58_ = theme_combo;
#line 551 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
					_tmp59_ = iter;
#line 551 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
					gtk_combo_box_set_active_iter (_tmp58_, &_tmp59_);
#line 3139 "iagno.c"
				}
#line 537 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_g_free0 (label_text);
#line 537 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
				_g_free0 (filename);
#line 3145 "iagno.c"
			}
		}
	}
#line 553 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp60_ = theme_combo;
#line 553 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp60_, "changed", (GCallback) _iagno_theme_changed_cb_gtk_combo_box_changed, self, 0);
#line 499 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	__g_list_free__g_free0_0 (dirlist);
#line 499 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_dir_close0 (dir);
#line 499 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (model);
#line 499 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (theme_combo);
#line 499 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (grid);
#line 499 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (box);
#line 499 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (builder);
#line 3167 "iagno.c"
}


static void iagno_preferences_cb (Iagno* self) {
	GtkDialog* _tmp0_ = NULL;
	GtkDialog* _tmp1_ = NULL;
#line 560 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 562 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = self->priv->propbox;
#line 562 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (_tmp0_ == NULL) {
#line 563 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		iagno_create_preferences_dialog (self);
#line 3182 "iagno.c"
	}
#line 564 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = self->priv->propbox;
#line 564 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp1_);
#line 3188 "iagno.c"
}


static void iagno_help_cb (Iagno* self) {
	GError * _inner_error_ = NULL;
#line 567 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 3196 "iagno.c"
	{
		GtkWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
#line 571 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp0_ = self->priv->window;
#line 571 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp1_ = gtk_window_get_screen (_tmp0_);
#line 571 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 571 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		gtk_show_uri (_tmp1_, "help:iagno", _tmp2_, &_inner_error_);
#line 571 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3211 "iagno.c"
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 569 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		e = _inner_error_;
#line 569 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_inner_error_ = NULL;
#line 575 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp3_ = e;
#line 575 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_tmp4_ = _tmp3_->message;
#line 575 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_warning ("iagno.vala:575: Failed to show help: %s", _tmp4_);
#line 569 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		_g_error_free0 (e);
#line 3233 "iagno.c"
	}
	__finally4:
#line 569 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 569 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 569 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		g_clear_error (&_inner_error_);
#line 569 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
		return;
#line 3244 "iagno.c"
	}
}


static void iagno_about_cb (Iagno* self) {
	gchar** authors = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** documenters = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint documenters_length1 = 0;
	gint _documenters_size_ = 0;
	GtkWindow* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
#line 579 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 581 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp0_ = g_strdup ("Ian Peters");
#line 581 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp1_ = g_strdup ("Robert Ancell");
#line 581 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_ = g_new0 (gchar*, 3 + 1);
#line 581 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_[0] = _tmp0_;
#line 581 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_[1] = _tmp1_;
#line 581 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp2_[2] = NULL;
#line 581 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	authors = _tmp2_;
#line 581 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	authors_length1 = 3;
#line 581 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_authors_size_ = authors_length1;
#line 582 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp3_ = g_strdup ("Tiffany Antopolski");
#line 582 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_ = g_new0 (gchar*, 2 + 1);
#line 582 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_[0] = _tmp3_;
#line 582 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp4_[1] = NULL;
#line 582 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	documenters = _tmp4_;
#line 582 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	documenters_length1 = 2;
#line 582 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_documenters_size_ = documenters_length1;
#line 584 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp5_ = self->priv->window;
#line 584 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp6_ = _ ("Iagno");
#line 584 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp7_ = _ ("A disk flipping game derived from Reversi\n" \
"\n" \
"Iagno is a part of GNOME Games.");
#line 584 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_tmp8_ = _ ("translator-credits");
#line 584 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	gtk_show_about_dialog (_tmp5_, "name", _tmp6_, "version", VERSION, "copyright", "Copyright © 1998–2008 Ian Peters\n" \
"Copyright © 2013–2014 Michael Catanzaro", "license-type", GTK_LICENSE_GPL_2_0, "comments", _tmp7_, "authors", authors, "documenters", documenters, "translator-credits", _tmp8_, "logo-icon-name", "iagno", "website", "https://wiki.gnome.org/Apps/Iagno", NULL, NULL);
#line 579 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
#line 579 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
#line 3313 "iagno.c"
}


static void iagno_class_init (IagnoClass * klass) {
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	iagno_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	g_type_class_add_private (klass, sizeof (IagnoPrivate));
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	((GApplicationClass *) klass)->handle_local_options = iagno_real_handle_local_options;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	((GApplicationClass *) klass)->startup = iagno_real_startup;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	((GApplicationClass *) klass)->activate = iagno_real_activate;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	((GApplicationClass *) klass)->shutdown = iagno_real_shutdown;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	G_OBJECT_CLASS (klass)->finalize = iagno_finalize;
#line 3332 "iagno.c"
}


static void iagno_instance_init (Iagno * self) {
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv = IAGNO_GET_PRIVATE (self);
#line 50 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->computer = NULL;
#line 56 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self->priv->game = NULL;
#line 3343 "iagno.c"
}


static void iagno_finalize (GObject* obj) {
	Iagno * self;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IAGNO, Iagno);
#line 15 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->settings);
#line 34 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->window);
#line 35 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 36 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->view);
#line 37 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->mark_icon_dark);
#line 38 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->mark_icon_light);
#line 39 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->dark_score_label);
#line 40 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->light_score_label);
#line 41 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->propbox);
#line 42 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->main_stack);
#line 44 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->back_button);
#line 45 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->undo_button);
#line 47 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->back_action);
#line 50 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->computer);
#line 56 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->game);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/iagno.vala"
	G_OBJECT_CLASS (iagno_parent_class)->finalize (obj);
#line 3383 "iagno.c"
}


GType iagno_get_type (void) {
	static volatile gsize iagno_type_id__volatile = 0;
	if (g_once_init_enter (&iagno_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IagnoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) iagno_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Iagno), 0, (GInstanceInitFunc) iagno_instance_init, NULL };
		GType iagno_type_id;
		iagno_type_id = g_type_register_static (gtk_application_get_type (), "Iagno", &g_define_type_info, 0);
		g_once_init_leave (&iagno_type_id__volatile, iagno_type_id);
	}
	return iagno_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



