/* gitg-hook.c generated by valac 0.26.1, the Vala compiler
 * generated from gitg-hook.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2013 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gio/gunixinputstream.h>
#include <libgit2-glib/ggit.h>


#define GITG_TYPE_HOOK (gitg_hook_get_type ())
#define GITG_HOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_HOOK, GitgHook))
#define GITG_HOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_HOOK, GitgHookClass))
#define GITG_IS_HOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_HOOK))
#define GITG_IS_HOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_HOOK))
#define GITG_HOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_HOOK, GitgHookClass))

typedef struct _GitgHook GitgHook;
typedef struct _GitgHookClass GitgHookClass;
typedef struct _GitgHookPrivate GitgHookPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block26Data Block26Data;
typedef struct _Block27Data Block27Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _Block28Data Block28Data;
typedef struct _GitgHookRunData GitgHookRunData;

struct _GitgHook {
	GObject parent_instance;
	GitgHookPrivate * priv;
};

struct _GitgHookClass {
	GObjectClass parent_class;
};

struct _GitgHookPrivate {
	GeeHashMap* _environment;
	gchar* _name;
	gchar** d_arguments;
	gint d_arguments_length1;
	gint _d_arguments_size_;
	GFile* _working_directory;
	gchar** d_output;
	gint d_output_length1;
	gint _d_output_size_;
};

struct _Block26Data {
	int _ref_count_;
	GitgHook* self;
	GDataInputStream* stream;
};

struct _Block27Data {
	int _ref_count_;
	GitgHook* self;
	GMainLoop* m;
	GError* e;
	gint status;
};

struct _Block28Data {
	int _ref_count_;
	GitgHook* self;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	gint status;
	gpointer _async_data_;
};

struct _GitgHookRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgHook* self;
	GgitRepository* repository;
	gint result;
	Block28Data* _data28_;
	gchar** _tmp0_;
	gint _tmp1_;
	GFile* wd;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GgitRepository* _tmp5_;
	GFile* _tmp6_;
	GFile* script;
	GgitRepository* _tmp7_;
	GFile* _tmp8_;
	gchar** args;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar** _tmp10_;
	gint args_length1;
	gint _args_size_;
	gint _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	GFile* _tmp13_;
	gchar* _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar** a_collection;
	gint a_collection_length1;
	gint _a_collection_size_;
	gint a_it;
	gchar* _tmp16_;
	gchar* a;
	gchar** _tmp17_;
	gint _tmp17__length1;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar** env;
	gint _tmp20_;
	gchar** _tmp21_;
	gint env_length1;
	gint _env_size_;
	GPid pid;
	gint pstdout;
	gint pstderr;
	GFile* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	GPid _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	GError * _inner_error_;
};


static gpointer gitg_hook_parent_class = NULL;

GType gitg_hook_get_type (void) G_GNUC_CONST;
#define GITG_HOOK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_HOOK, GitgHookPrivate))
enum  {
	GITG_HOOK_DUMMY_PROPERTY,
	GITG_HOOK_ENVIRONMENT,
	GITG_HOOK_NAME,
	GITG_HOOK_WORKING_DIRECTORY,
	GITG_HOOK_OUTPUT
};
GitgHook* gitg_hook_new (const gchar* name);
GitgHook* gitg_hook_construct (GType object_type, const gchar* name);
void gitg_hook_add_argument (GitgHook* self, const gchar* arg);
static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value);
static gchar** gitg_hook_flat_environment (GitgHook* self, int* result_length1);
GeeHashMap* gitg_hook_get_environment (GitgHook* self);
static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value);
static void gitg_hook_stream_read_async (GitgHook* self, GDataInputStream* stream);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (void * _userdata_);
static void __lambda9_ (Block26Data* _data26_, GObject* obj, GAsyncResult* res);
static void _vala_array_add9 (gchar*** array, int* length, int* size, gchar* value);
static void ___lambda9__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gitg_hook_read_from_fd (GitgHook* self, gint fd);
static GFile* gitg_hook_hook_file (GitgHook* self, GgitRepository* repository);
const gchar* gitg_hook_get_name (GitgHook* self);
gboolean gitg_hook_exists_in (GitgHook* self, GgitRepository* repository);
gint gitg_hook_run_sync (GitgHook* self, GgitRepository* repository, GError** error);
static Block27Data* block27_data_ref (Block27Data* _data27_);
static void block27_data_unref (void * _userdata_);
void gitg_hook_run (GitgHook* self, GgitRepository* repository, GAsyncReadyCallback _callback_, gpointer _user_data_);
gint gitg_hook_run_finish (GitgHook* self, GAsyncResult* _res_, GError** error);
static void __lambda11_ (Block27Data* _data27_, GObject* obj, GAsyncResult* res);
static void ___lambda11__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gitg_hook_run_data_free (gpointer _data);
static gboolean gitg_hook_run_co (GitgHookRunData* _data_);
static Block28Data* block28_data_ref (Block28Data* _data28_);
static void block28_data_unref (void * _userdata_);
static gboolean _gitg_hook_run_co_gsource_func (gpointer self);
GFile* gitg_hook_get_working_directory (GitgHook* self);
static void _vala_array_add10 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add11 (gchar*** array, int* length, int* size, gchar* value);
static void __lambda10_ (Block28Data* _data28_, GPid p, gint st);
static void ___lambda10__gchild_watch_func (GPid pid, gint status, gpointer self);
void gitg_hook_set_environment (GitgHook* self, GeeHashMap* value);
void gitg_hook_set_name (GitgHook* self, const gchar* value);
void gitg_hook_set_working_directory (GitgHook* self, GFile* value);
gchar** gitg_hook_get_output (GitgHook* self, int* result_length1);
static gchar** _vala_array_dup12 (gchar** self, int length);
static GObject * gitg_hook_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gitg_hook_finalize (GObject* obj);
static void _vala_gitg_hook_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_hook_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GitgHook* gitg_hook_construct (GType object_type, const gchar* name) {
	GitgHook * self = NULL;
	const gchar* _tmp0_ = NULL;
#line 42 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 44 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp0_ = name;
#line 44 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	self = (GitgHook*) g_object_new (object_type, "name", _tmp0_, NULL);
#line 42 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	return self;
#line 233 "gitg-hook.c"
}


GitgHook* gitg_hook_new (const gchar* name) {
#line 42 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	return gitg_hook_construct (GITG_TYPE_HOOK, name);
#line 240 "gitg-hook.c"
}


static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value) {
#line 49 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	if ((*length) == (*size)) {
#line 49 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 49 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 251 "gitg-hook.c"
	}
#line 49 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	(*array)[(*length)++] = value;
#line 49 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	(*array)[*length] = NULL;
#line 257 "gitg-hook.c"
}


void gitg_hook_add_argument (GitgHook* self, const gchar* arg) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 47 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_return_if_fail (self != NULL);
#line 47 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_return_if_fail (arg != NULL);
#line 49 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp0_ = self->priv->d_arguments;
#line 49 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp0__length1 = self->priv->d_arguments_length1;
#line 49 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp1_ = arg;
#line 49 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 49 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_vala_array_add6 (&self->priv->d_arguments, &self->priv->d_arguments_length1, &self->priv->_d_arguments_size_, _tmp2_);
#line 280 "gitg-hook.c"
}


static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value) {
#line 68 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	if ((*length) == (*size)) {
#line 68 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 68 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 291 "gitg-hook.c"
	}
#line 68 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	(*array)[(*length)++] = value;
#line 68 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	(*array)[*length] = NULL;
#line 297 "gitg-hook.c"
}


static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value) {
#line 74 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	if ((*length) == (*size)) {
#line 74 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 74 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 308 "gitg-hook.c"
	}
#line 74 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	(*array)[(*length)++] = value;
#line 74 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	(*array)[*length] = NULL;
#line 314 "gitg-hook.c"
}


static gchar** gitg_hook_flat_environment (GitgHook* self, int* result_length1) {
	gchar** result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gchar** env = NULL;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint env_length1 = 0;
	gint _env_size_ = 0;
	gchar** ret = NULL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	GeeHashMap* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gchar** _tmp10_ = NULL;
	gint ret_length1 = 0;
	gint _ret_size_ = 0;
	gint _tmp11_ = 0;
	gchar** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	gchar** _tmp39_ = NULL;
	gint _tmp39__length1 = 0;
#line 52 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 54 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp0_ = self->priv->_environment;
#line 54 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp1_ = gee_abstract_map_get_size ((GeeMap*) _tmp0_);
#line 54 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp2_ = _tmp1_;
#line 54 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	if (_tmp2_ == 0) {
#line 352 "gitg-hook.c"
		gchar** _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
#line 56 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_tmp3_ = NULL;
#line 56 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_tmp3__length1 = 0;
#line 56 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		if (result_length1) {
#line 56 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			*result_length1 = _tmp3__length1;
#line 363 "gitg-hook.c"
		}
#line 56 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		result = _tmp3_;
#line 56 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		return result;
#line 369 "gitg-hook.c"
	}
#line 59 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp5_ = _tmp4_ = g_listenv ();
#line 59 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	env = _tmp5_;
#line 59 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	env_length1 = _vala_array_length (_tmp4_);
#line 59 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_env_size_ = env_length1;
#line 61 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp6_ = env;
#line 61 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp6__length1 = env_length1;
#line 61 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp7_ = self->priv->_environment;
#line 61 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp8_ = gee_abstract_map_get_size ((GeeMap*) _tmp7_);
#line 61 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp9_ = _tmp8_;
#line 61 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp10_ = g_new0 (gchar*, (_tmp6__length1 + _tmp9_) + 1);
#line 61 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	ret = _tmp10_;
#line 61 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	ret_length1 = _tmp6__length1 + _tmp9_;
#line 61 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_ret_size_ = ret_length1;
#line 62 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	ret_length1 = 0;
#line 62 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp11_ = ret_length1;
#line 64 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp12_ = env;
#line 64 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp12__length1 = env_length1;
#line 405 "gitg-hook.c"
	{
		gchar** e_collection = NULL;
		gint e_collection_length1 = 0;
		gint _e_collection_size_ = 0;
		gint e_it = 0;
#line 64 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		e_collection = _tmp12_;
#line 64 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		e_collection_length1 = _tmp12__length1;
#line 64 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		for (e_it = 0; e_it < _tmp12__length1; e_it = e_it + 1) {
#line 417 "gitg-hook.c"
			gchar* _tmp13_ = NULL;
			gchar* e = NULL;
#line 64 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_tmp13_ = g_strdup (e_collection[e_it]);
#line 64 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			e = _tmp13_;
#line 424 "gitg-hook.c"
			{
				GeeHashMap* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
#line 66 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
				_tmp14_ = self->priv->_environment;
#line 66 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
				_tmp15_ = e;
#line 66 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
				_tmp16_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp14_, _tmp15_);
#line 66 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
				if (!_tmp16_) {
#line 437 "gitg-hook.c"
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					const gchar* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					gchar* _tmp21_ = NULL;
#line 68 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
					_tmp17_ = ret;
#line 68 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
					_tmp17__length1 = ret_length1;
#line 68 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
					_tmp18_ = e;
#line 68 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
					_tmp19_ = e;
#line 68 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
					_tmp20_ = g_getenv (_tmp19_);
#line 68 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
					_tmp21_ = g_strdup_printf ("%s=%s", _tmp18_, _tmp20_);
#line 68 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
					_vala_array_add7 (&ret, &ret_length1, &_ret_size_, _tmp21_);
#line 458 "gitg-hook.c"
				}
#line 64 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
				_g_free0 (e);
#line 462 "gitg-hook.c"
			}
		}
	}
	{
		GeeIterator* _e_it = NULL;
		GeeHashMap* _tmp22_ = NULL;
		GeeSet* _tmp23_ = NULL;
		GeeSet* _tmp24_ = NULL;
		GeeSet* _tmp25_ = NULL;
		GeeIterator* _tmp26_ = NULL;
		GeeIterator* _tmp27_ = NULL;
#line 72 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_tmp22_ = self->priv->_environment;
#line 72 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_tmp23_ = gee_abstract_map_get_keys ((GeeMap*) _tmp22_);
#line 72 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_tmp24_ = _tmp23_;
#line 72 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_tmp25_ = _tmp24_;
#line 72 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_tmp26_ = gee_iterable_iterator ((GeeIterable*) _tmp25_);
#line 72 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_tmp27_ = _tmp26_;
#line 72 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_g_object_unref0 (_tmp25_);
#line 72 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_e_it = _tmp27_;
#line 72 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		while (TRUE) {
#line 492 "gitg-hook.c"
			GeeIterator* _tmp28_ = NULL;
			gboolean _tmp29_ = FALSE;
			gchar* e = NULL;
			GeeIterator* _tmp30_ = NULL;
			gpointer _tmp31_ = NULL;
			gchar** _tmp32_ = NULL;
			gint _tmp32__length1 = 0;
			const gchar* _tmp33_ = NULL;
			GeeHashMap* _tmp34_ = NULL;
			const gchar* _tmp35_ = NULL;
			gpointer _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
			gchar* _tmp38_ = NULL;
#line 72 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_tmp28_ = _e_it;
#line 72 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_tmp29_ = gee_iterator_next (_tmp28_);
#line 72 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			if (!_tmp29_) {
#line 72 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
				break;
#line 514 "gitg-hook.c"
			}
#line 72 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_tmp30_ = _e_it;
#line 72 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_tmp31_ = gee_iterator_get (_tmp30_);
#line 72 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			e = (gchar*) _tmp31_;
#line 74 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_tmp32_ = ret;
#line 74 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_tmp32__length1 = ret_length1;
#line 74 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_tmp33_ = e;
#line 74 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_tmp34_ = self->priv->_environment;
#line 74 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_tmp35_ = e;
#line 74 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_tmp36_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp34_, _tmp35_);
#line 74 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_tmp37_ = (gchar*) _tmp36_;
#line 74 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_tmp38_ = g_strdup_printf ("%s=%s", _tmp33_, _tmp37_);
#line 74 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_vala_array_add8 (&ret, &ret_length1, &_ret_size_, _tmp38_);
#line 74 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_g_free0 (_tmp37_);
#line 72 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_g_free0 (e);
#line 544 "gitg-hook.c"
		}
#line 72 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_g_object_unref0 (_e_it);
#line 548 "gitg-hook.c"
	}
#line 77 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp39_ = ret;
#line 77 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp39__length1 = ret_length1;
#line 77 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	if (result_length1) {
#line 77 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		*result_length1 = _tmp39__length1;
#line 558 "gitg-hook.c"
	}
#line 77 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	result = _tmp39_;
#line 77 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
#line 77 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	return result;
#line 566 "gitg-hook.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 80 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	return self ? g_object_ref (self) : NULL;
#line 573 "gitg-hook.c"
}


static Block26Data* block26_data_ref (Block26Data* _data26_) {
#line 80 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_atomic_int_inc (&_data26_->_ref_count_);
#line 80 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	return _data26_;
#line 582 "gitg-hook.c"
}


static void block26_data_unref (void * _userdata_) {
	Block26Data* _data26_;
	_data26_ = (Block26Data*) _userdata_;
#line 80 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	if (g_atomic_int_dec_and_test (&_data26_->_ref_count_)) {
#line 591 "gitg-hook.c"
		GitgHook* self;
#line 80 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		self = _data26_->self;
#line 80 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_g_object_unref0 (_data26_->stream);
#line 80 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_g_object_unref0 (self);
#line 80 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		g_slice_free (Block26Data, _data26_);
#line 601 "gitg-hook.c"
	}
}


static void _vala_array_add9 (gchar*** array, int* length, int* size, gchar* value) {
#line 91 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	if ((*length) == (*size)) {
#line 91 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 91 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 613 "gitg-hook.c"
	}
#line 91 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	(*array)[(*length)++] = value;
#line 91 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	(*array)[*length] = NULL;
#line 619 "gitg-hook.c"
}


static void __lambda9_ (Block26Data* _data26_, GObject* obj, GAsyncResult* res) {
	GitgHook* self;
	GError * _inner_error_ = NULL;
#line 82 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	self = _data26_->self;
#line 82 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_return_if_fail (res != NULL);
#line 630 "gitg-hook.c"
	{
		gchar* s = NULL;
		GDataInputStream* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
#line 85 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_tmp0_ = _data26_->stream;
#line 85 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_tmp1_ = res;
#line 85 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_tmp2_ = g_data_input_stream_read_line_finish (_tmp0_, _tmp1_, NULL, &_inner_error_);
#line 85 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		s = _tmp2_;
#line 85 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 646 "gitg-hook.c"
			goto __catch73_g_error;
		}
#line 87 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		if (s != NULL) {
#line 651 "gitg-hook.c"
			gboolean _tmp3_ = FALSE;
			GDataInputStream* _tmp6_ = NULL;
#line 89 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_tmp3_ = g_utf8_validate (s, (gssize) (-1), NULL);
#line 89 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			if (_tmp3_) {
#line 658 "gitg-hook.c"
				gchar** _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				gchar* _tmp5_ = NULL;
#line 91 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
				_tmp4_ = self->priv->d_output;
#line 91 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
				_tmp4__length1 = self->priv->d_output_length1;
#line 91 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
				_tmp5_ = g_strdup (s);
#line 91 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
				_vala_array_add9 (&self->priv->d_output, &self->priv->d_output_length1, &self->priv->_d_output_size_, _tmp5_);
#line 670 "gitg-hook.c"
			}
#line 95 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_tmp6_ = _data26_->stream;
#line 95 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			gitg_hook_stream_read_async (self, _tmp6_);
#line 676 "gitg-hook.c"
		}
#line 83 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_g_free0 (s);
#line 680 "gitg-hook.c"
	}
	goto __finally73;
	__catch73_g_error:
	{
#line 83 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		g_clear_error (&_inner_error_);
#line 83 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_inner_error_ = NULL;
#line 689 "gitg-hook.c"
	}
	__finally73:
#line 83 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 83 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 83 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		g_clear_error (&_inner_error_);
#line 83 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		return;
#line 700 "gitg-hook.c"
	}
}


static void ___lambda9__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 82 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	__lambda9_ (self, source_object, res);
#line 82 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	block26_data_unref (self);
#line 710 "gitg-hook.c"
}


static void gitg_hook_stream_read_async (GitgHook* self, GDataInputStream* stream) {
	Block26Data* _data26_;
	GDataInputStream* _tmp0_ = NULL;
	GDataInputStream* _tmp1_ = NULL;
	GDataInputStream* _tmp2_ = NULL;
#line 80 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_return_if_fail (self != NULL);
#line 80 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_return_if_fail (stream != NULL);
#line 80 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data26_ = g_slice_new0 (Block26Data);
#line 80 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data26_->_ref_count_ = 1;
#line 80 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data26_->self = g_object_ref (self);
#line 80 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp0_ = stream;
#line 80 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 80 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_g_object_unref0 (_data26_->stream);
#line 80 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data26_->stream = _tmp1_;
#line 82 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp2_ = _data26_->stream;
#line 82 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_data_input_stream_read_line_async (_tmp2_, G_PRIORITY_HIGH_IDLE, NULL, ___lambda9__gasync_ready_callback, block26_data_ref (_data26_));
#line 80 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	block26_data_unref (_data26_);
#line 80 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data26_ = NULL;
#line 745 "gitg-hook.c"
}


static void gitg_hook_read_from_fd (GitgHook* self, gint fd) {
	GUnixInputStream* stream = NULL;
	gint _tmp0_ = 0;
	GUnixInputStream* _tmp1_ = NULL;
	GDataInputStream* dstream = NULL;
	GDataInputStream* _tmp2_ = NULL;
#line 102 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_return_if_fail (self != NULL);
#line 104 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp0_ = fd;
#line 104 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp1_ = (GUnixInputStream*) g_unix_input_stream_new (_tmp0_, TRUE);
#line 104 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	stream = _tmp1_;
#line 105 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp2_ = g_data_input_stream_new ((GInputStream*) stream);
#line 105 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	dstream = _tmp2_;
#line 107 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	gitg_hook_stream_read_async (self, dstream);
#line 102 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_g_object_unref0 (dstream);
#line 102 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_g_object_unref0 (stream);
#line 773 "gitg-hook.c"
}


static GFile* gitg_hook_hook_file (GitgHook* self, GgitRepository* repository) {
	GFile* result = NULL;
	GFile* hooksdir = NULL;
	GgitRepository* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* script = NULL;
	const gchar* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
#line 110 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 110 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_return_val_if_fail (repository != NULL, NULL);
#line 112 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp0_ = repository;
#line 112 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp1_ = ggit_repository_get_location (_tmp0_);
#line 112 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp2_ = _tmp1_;
#line 112 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp3_ = g_file_get_child (_tmp2_, "hooks");
#line 112 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp4_ = _tmp3_;
#line 112 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_g_object_unref0 (_tmp2_);
#line 112 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	hooksdir = _tmp4_;
#line 113 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp5_ = self->priv->_name;
#line 113 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp6_ = g_file_resolve_relative_path (hooksdir, _tmp5_);
#line 113 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	script = _tmp6_;
#line 115 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	result = script;
#line 115 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_g_object_unref0 (hooksdir);
#line 115 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	return result;
#line 818 "gitg-hook.c"
}


gboolean gitg_hook_exists_in (GitgHook* self, GgitRepository* repository) {
	gboolean result = FALSE;
	GFile* script = NULL;
	GgitRepository* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 118 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 118 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_return_val_if_fail (repository != NULL, FALSE);
#line 120 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp0_ = repository;
#line 120 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp1_ = gitg_hook_hook_file (self, _tmp0_);
#line 120 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	script = _tmp1_;
#line 838 "gitg-hook.c"
	{
		GFileInfo* info = NULL;
		GFileInfo* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 124 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_tmp2_ = g_file_query_info (script, G_FILE_ATTRIBUTE_ACCESS_CAN_EXECUTE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 124 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		info = _tmp2_;
#line 124 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 849 "gitg-hook.c"
			goto __catch74_g_error;
		}
#line 127 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_tmp3_ = g_file_info_get_attribute_boolean (info, G_FILE_ATTRIBUTE_ACCESS_CAN_EXECUTE);
#line 127 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		result = _tmp3_;
#line 127 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_g_object_unref0 (info);
#line 127 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_g_object_unref0 (script);
#line 127 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		return result;
#line 862 "gitg-hook.c"
	}
	goto __finally74;
	__catch74_g_error:
	{
#line 122 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		g_clear_error (&_inner_error_);
#line 122 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_inner_error_ = NULL;
#line 131 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		result = FALSE;
#line 131 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_g_object_unref0 (script);
#line 131 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		return result;
#line 877 "gitg-hook.c"
	}
	__finally74:
#line 122 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_g_object_unref0 (script);
#line 122 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 122 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_clear_error (&_inner_error_);
#line 122 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	return FALSE;
#line 888 "gitg-hook.c"
}


static Block27Data* block27_data_ref (Block27Data* _data27_) {
#line 135 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_atomic_int_inc (&_data27_->_ref_count_);
#line 135 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	return _data27_;
#line 897 "gitg-hook.c"
}


static void block27_data_unref (void * _userdata_) {
	Block27Data* _data27_;
	_data27_ = (Block27Data*) _userdata_;
#line 135 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	if (g_atomic_int_dec_and_test (&_data27_->_ref_count_)) {
#line 906 "gitg-hook.c"
		GitgHook* self;
#line 135 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		self = _data27_->self;
#line 135 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_g_error_free0 (_data27_->e);
#line 135 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_g_main_loop_unref0 (_data27_->m);
#line 135 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_g_object_unref0 (self);
#line 135 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		g_slice_free (Block27Data, _data27_);
#line 918 "gitg-hook.c"
	}
}


static gpointer _g_error_copy0 (gpointer self) {
#line 148 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	return self ? g_error_copy (self) : NULL;
#line 926 "gitg-hook.c"
}


static void __lambda11_ (Block27Data* _data27_, GObject* obj, GAsyncResult* res) {
	GitgHook* self;
	GMainLoop* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 141 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	self = _data27_->self;
#line 141 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_return_if_fail (res != NULL);
#line 938 "gitg-hook.c"
	{
		gint _tmp0_ = 0;
		GAsyncResult* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_tmp1_ = res;
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_tmp2_ = gitg_hook_run_finish (self, _tmp1_, &_inner_error_);
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_tmp0_ = _tmp2_;
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			if (_inner_error_->domain == G_SPAWN_ERROR) {
#line 953 "gitg-hook.c"
				goto __catch75_g_spawn_error;
			}
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			g_clear_error (&_inner_error_);
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			return;
#line 962 "gitg-hook.c"
		}
#line 144 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_data27_->status = _tmp0_;
#line 966 "gitg-hook.c"
	}
	goto __finally75;
	__catch75_g_spawn_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
#line 142 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		err = _inner_error_;
#line 142 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_inner_error_ = NULL;
#line 148 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_tmp3_ = err;
#line 148 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_tmp4_ = _g_error_copy0 (_tmp3_);
#line 148 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_g_error_free0 (_data27_->e);
#line 148 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_data27_->e = _tmp4_;
#line 142 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_g_error_free0 (err);
#line 988 "gitg-hook.c"
	}
	__finally75:
#line 142 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 142 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 142 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		g_clear_error (&_inner_error_);
#line 142 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		return;
#line 999 "gitg-hook.c"
	}
#line 151 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp5_ = _data27_->m;
#line 151 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_main_loop_quit (_tmp5_);
#line 1005 "gitg-hook.c"
}


static void ___lambda11__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 141 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	__lambda11_ (self, source_object, res);
#line 141 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	block27_data_unref (self);
#line 1014 "gitg-hook.c"
}


gint gitg_hook_run_sync (GitgHook* self, GgitRepository* repository, GError** error) {
	gint result = 0;
	Block27Data* _data27_;
	GMainLoop* _tmp0_ = NULL;
	GgitRepository* _tmp1_ = NULL;
	GMainLoop* _tmp2_ = NULL;
	GError* _tmp3_ = NULL;
	gint _tmp6_ = 0;
	GError * _inner_error_ = NULL;
#line 135 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 135 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_return_val_if_fail (repository != NULL, 0);
#line 135 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data27_ = g_slice_new0 (Block27Data);
#line 135 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data27_->_ref_count_ = 1;
#line 135 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data27_->self = g_object_ref (self);
#line 137 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 137 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data27_->m = _tmp0_;
#line 138 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data27_->e = NULL;
#line 139 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data27_->status = 0;
#line 141 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp1_ = repository;
#line 141 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	gitg_hook_run (self, _tmp1_, ___lambda11__gasync_ready_callback, block27_data_ref (_data27_));
#line 154 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp2_ = _data27_->m;
#line 154 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_main_loop_run (_tmp2_);
#line 156 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp3_ = _data27_->e;
#line 156 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	if (_tmp3_ != NULL) {
#line 1057 "gitg-hook.c"
		GError* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_tmp4_ = _data27_->e;
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_tmp5_ = _g_error_copy0 (_tmp4_);
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_inner_error_ = _tmp5_;
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		if (_inner_error_->domain == G_SPAWN_ERROR) {
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			g_propagate_error (error, _inner_error_);
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			block27_data_unref (_data27_);
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_data27_ = NULL;
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			return 0;
#line 1076 "gitg-hook.c"
		} else {
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			block27_data_unref (_data27_);
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_data27_ = NULL;
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			g_clear_error (&_inner_error_);
#line 158 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			return 0;
#line 1088 "gitg-hook.c"
		}
	}
#line 161 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp6_ = _data27_->status;
#line 161 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	result = _tmp6_;
#line 161 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	block27_data_unref (_data27_);
#line 161 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data27_ = NULL;
#line 161 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	return result;
#line 1101 "gitg-hook.c"
}


static void gitg_hook_run_data_free (gpointer _data) {
	GitgHookRunData* _data_;
	_data_ = _data;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_g_object_unref0 (_data_->repository);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_g_object_unref0 (_data_->self);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_slice_free (GitgHookRunData, _data_);
#line 1114 "gitg-hook.c"
}


void gitg_hook_run (GitgHook* self, GgitRepository* repository, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgHookRunData* _data_;
	GitgHook* _tmp0_ = NULL;
	GgitRepository* _tmp1_ = NULL;
	GgitRepository* _tmp2_ = NULL;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_ = g_slice_new0 (GitgHookRunData);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_hook_run);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_hook_run_data_free);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->self = _tmp0_;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp1_ = repository;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_g_object_unref0 (_data_->repository);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->repository = _tmp2_;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	gitg_hook_run_co (_data_);
#line 1143 "gitg-hook.c"
}


gint gitg_hook_run_finish (GitgHook* self, GAsyncResult* _res_, GError** error) {
	gint result;
	GitgHookRunData* _data_;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		return 0;
#line 1154 "gitg-hook.c"
	}
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	result = _data_->result;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	return result;
#line 1162 "gitg-hook.c"
}


static Block28Data* block28_data_ref (Block28Data* _data28_) {
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_atomic_int_inc (&_data28_->_ref_count_);
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	return _data28_;
#line 1171 "gitg-hook.c"
}


static void block28_data_unref (void * _userdata_) {
	Block28Data* _data28_;
	_data28_ = (Block28Data*) _userdata_;
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	if (g_atomic_int_dec_and_test (&_data28_->_ref_count_)) {
#line 1180 "gitg-hook.c"
		GitgHook* self;
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		self = _data28_->self;
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		(_data28_->callback_target_destroy_notify == NULL) ? NULL : (_data28_->callback_target_destroy_notify (_data28_->callback_target), NULL);
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_data28_->callback = NULL;
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_data28_->callback_target = NULL;
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_data28_->callback_target_destroy_notify = NULL;
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_g_object_unref0 (self);
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		g_slice_free (Block28Data, _data28_);
#line 1196 "gitg-hook.c"
	}
}


static gboolean _gitg_hook_run_co_gsource_func (gpointer self) {
	gboolean result;
	result = gitg_hook_run_co (self);
#line 166 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	return result;
#line 1206 "gitg-hook.c"
}


static void _vala_array_add10 (gchar*** array, int* length, int* size, gchar* value) {
#line 187 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	if ((*length) == (*size)) {
#line 187 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 187 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1217 "gitg-hook.c"
	}
#line 187 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	(*array)[(*length)++] = value;
#line 187 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	(*array)[*length] = NULL;
#line 1223 "gitg-hook.c"
}


static void _vala_array_add11 (gchar*** array, int* length, int* size, gchar* value) {
#line 191 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	if ((*length) == (*size)) {
#line 191 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 191 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1234 "gitg-hook.c"
	}
#line 191 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	(*array)[(*length)++] = value;
#line 191 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	(*array)[*length] = NULL;
#line 1240 "gitg-hook.c"
}


static void __lambda10_ (Block28Data* _data28_, GPid p, gint st) {
	GitgHook* self;
	gint _tmp0_ = 0;
	GPid _tmp1_ = 0;
	GSourceFunc _tmp2_ = NULL;
	void* _tmp2__target = NULL;
#line 216 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	self = _data28_->self;
#line 217 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp0_ = st;
#line 217 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data28_->status = _tmp0_;
#line 219 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp1_ = p;
#line 219 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_spawn_close_pid (_tmp1_);
#line 220 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp2_ = _data28_->callback;
#line 220 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp2__target = _data28_->callback_target;
#line 220 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp2_ (_tmp2__target);
#line 1266 "gitg-hook.c"
}


static void ___lambda10__gchild_watch_func (GPid pid, gint status, gpointer self) {
#line 216 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	__lambda10_ (self, pid, status);
#line 1273 "gitg-hook.c"
}


static gboolean gitg_hook_run_co (GitgHookRunData* _data_) {
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	switch (_data_->_state_) {
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		case 0:
#line 1282 "gitg-hook.c"
		goto _state_0;
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		case 1:
#line 1286 "gitg-hook.c"
		goto _state_1;
		default:
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		g_assert_not_reached ();
#line 1291 "gitg-hook.c"
	}
	_state_0:
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_data28_ = g_slice_new0 (Block28Data);
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_data28_->_ref_count_ = 1;
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_data28_->self = g_object_ref (_data_->self);
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_data28_->_async_data_ = _data_;
#line 166 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_data28_->callback = _gitg_hook_run_co_gsource_func;
#line 166 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_data28_->callback_target = _data_;
#line 166 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_data28_->callback_target_destroy_notify = NULL;
#line 168 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp0_ = NULL;
#line 168 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp0_ = g_new0 (gchar*, 256 + 1);
#line 168 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->self->priv->d_output = (_vala_array_free (_data_->self->priv->d_output, _data_->self->priv->d_output_length1, (GDestroyNotify) g_free), NULL);
#line 168 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->self->priv->d_output = _data_->_tmp0_;
#line 168 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->self->priv->d_output_length1 = 256;
#line 168 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->self->priv->_d_output_size_ = _data_->self->priv->d_output_length1;
#line 169 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->self->priv->d_output_length1 = 0;
#line 169 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp1_ = 0;
#line 169 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp1_ = _data_->self->priv->d_output_length1;
#line 173 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp2_ = NULL;
#line 173 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp2_ = _data_->self->priv->_working_directory;
#line 173 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	if (_data_->_tmp2_ == NULL) {
#line 175 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_data_->_tmp3_ = NULL;
#line 175 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_data_->_tmp3_ = _data_->self->priv->_working_directory;
#line 175 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_data_->_tmp4_ = NULL;
#line 175 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
#line 175 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_g_object_unref0 (_data_->wd);
#line 175 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_data_->wd = _data_->_tmp4_;
#line 1344 "gitg-hook.c"
	} else {
#line 179 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_data_->_tmp5_ = NULL;
#line 179 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_data_->_tmp5_ = _data_->repository;
#line 179 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_data_->_tmp6_ = NULL;
#line 179 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_data_->_tmp6_ = ggit_repository_get_workdir (_data_->_tmp5_);
#line 179 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_g_object_unref0 (_data_->wd);
#line 179 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_data_->wd = _data_->_tmp6_;
#line 1358 "gitg-hook.c"
	}
#line 182 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp7_ = NULL;
#line 182 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp7_ = _data_->repository;
#line 182 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp8_ = NULL;
#line 182 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp8_ = gitg_hook_hook_file (_data_->self, _data_->_tmp7_);
#line 182 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->script = _data_->_tmp8_;
#line 183 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp9_ = NULL;
#line 183 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp9__length1 = 0;
#line 183 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp9_ = _data_->self->priv->d_arguments;
#line 183 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp9__length1 = _data_->self->priv->d_arguments_length1;
#line 183 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp10_ = NULL;
#line 183 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp10_ = g_new0 (gchar*, (_data_->_tmp9__length1 + 1) + 1);
#line 183 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->args_length1 = 0;
#line 183 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_args_size_ = 0;
#line 183 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->args = _data_->_tmp10_;
#line 183 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->args_length1 = _data_->_tmp9__length1 + 1;
#line 183 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_args_size_ = _data_->args_length1;
#line 185 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->args_length1 = 0;
#line 185 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp11_ = 0;
#line 185 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp11_ = _data_->args_length1;
#line 187 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp12_ = NULL;
#line 187 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp12__length1 = 0;
#line 187 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp12_ = _data_->args;
#line 187 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp12__length1 = _data_->args_length1;
#line 187 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp13_ = NULL;
#line 187 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp13_ = _data_->script;
#line 187 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp14_ = NULL;
#line 187 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp14_ = g_file_get_path (_data_->_tmp13_);
#line 187 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_vala_array_add10 (&_data_->args, &_data_->args_length1, &_data_->_args_size_, _data_->_tmp14_);
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp15_ = NULL;
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp15__length1 = 0;
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp15_ = _data_->self->priv->d_arguments;
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp15__length1 = _data_->self->priv->d_arguments_length1;
#line 1424 "gitg-hook.c"
	{
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_data_->a_collection_length1 = 0;
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_data_->_a_collection_size_ = 0;
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_data_->a_collection = _data_->_tmp15_;
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_data_->a_collection_length1 = _data_->_tmp15__length1;
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		for (_data_->a_it = 0; _data_->a_it < _data_->_tmp15__length1; _data_->a_it = _data_->a_it + 1) {
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_data_->_tmp16_ = NULL;
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_data_->_tmp16_ = g_strdup (_data_->a_collection[_data_->a_it]);
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_data_->a = _data_->_tmp16_;
#line 1442 "gitg-hook.c"
			{
#line 191 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
				_data_->_tmp17_ = NULL;
#line 191 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
				_data_->_tmp17__length1 = 0;
#line 191 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
				_data_->_tmp17_ = _data_->args;
#line 191 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
				_data_->_tmp17__length1 = _data_->args_length1;
#line 191 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
				_data_->_tmp18_ = NULL;
#line 191 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
				_data_->_tmp18_ = _data_->a;
#line 191 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
				_data_->_tmp19_ = NULL;
#line 191 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
				_data_->_tmp19_ = g_strdup (_data_->_tmp18_);
#line 191 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
				_vala_array_add11 (&_data_->args, &_data_->args_length1, &_data_->_args_size_, _data_->_tmp19_);
#line 189 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
				_g_free0 (_data_->a);
#line 1464 "gitg-hook.c"
			}
		}
	}
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp20_ = 0;
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp21_ = NULL;
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp21_ = gitg_hook_flat_environment (_data_->self, &_data_->_tmp20_);
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->env_length1 = 0;
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_env_size_ = 0;
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->env = _data_->_tmp21_;
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->env_length1 = _data_->_tmp20_;
#line 194 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_env_size_ = _data_->env_length1;
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp22_ = NULL;
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp22_ = _data_->wd;
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp23_ = NULL;
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp23_ = g_file_get_path (_data_->_tmp22_);
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp24_ = NULL;
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp24_ = _data_->_tmp23_;
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp25_ = NULL;
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp25__length1 = 0;
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp25_ = _data_->args;
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp25__length1 = _data_->args_length1;
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp26_ = 0;
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp27_ = 0;
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp28_ = 0;
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_spawn_async_with_pipes (_data_->_tmp24_, _data_->_tmp25_, _data_->env, G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_data_->_tmp26_, NULL, &_data_->_tmp27_, &_data_->_tmp28_, &_data_->_inner_error_);
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->pid = _data_->_tmp26_;
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->pstdout = _data_->_tmp27_;
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->pstderr = _data_->_tmp28_;
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_g_free0 (_data_->_tmp24_);
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		if (_data_->_inner_error_->domain == G_SPAWN_ERROR) {
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			g_error_free (_data_->_inner_error_);
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_data_->env = (_vala_array_free (_data_->env, _data_->env_length1, (GDestroyNotify) g_free), NULL);
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_g_object_unref0 (_data_->script);
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_g_object_unref0 (_data_->wd);
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			block28_data_unref (_data_->_data28_);
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_data_->_data28_ = NULL;
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			if (_data_->_state_ == 0) {
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1544 "gitg-hook.c"
			} else {
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1548 "gitg-hook.c"
			}
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			g_object_unref (_data_->_async_result);
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			return FALSE;
#line 1554 "gitg-hook.c"
		} else {
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_data_->env = (_vala_array_free (_data_->env, _data_->env_length1, (GDestroyNotify) g_free), NULL);
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_g_object_unref0 (_data_->script);
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_g_object_unref0 (_data_->wd);
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			block28_data_unref (_data_->_data28_);
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			_data_->_data28_ = NULL;
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			g_clear_error (&_data_->_inner_error_);
#line 201 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			return FALSE;
#line 1574 "gitg-hook.c"
		}
	}
#line 211 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	gitg_hook_read_from_fd (_data_->self, _data_->pstdout);
#line 212 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	gitg_hook_read_from_fd (_data_->self, _data_->pstderr);
#line 214 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_data28_->status = 0;
#line 216 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_child_watch_add_full (G_PRIORITY_LOW, _data_->pid, ___lambda10__gchild_watch_func, block28_data_ref (_data_->_data28_), block28_data_unref);
#line 223 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_state_ = 1;
#line 223 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	return FALSE;
#line 1589 "gitg-hook.c"
	_state_1:
	;
#line 225 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp29_ = 0;
#line 225 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_tmp29_ = _data_->_data28_->status;
#line 225 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->result = _data_->_tmp29_;
#line 225 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->env = (_vala_array_free (_data_->env, _data_->env_length1, (GDestroyNotify) g_free), NULL);
#line 225 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
#line 225 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_g_object_unref0 (_data_->script);
#line 225 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_g_object_unref0 (_data_->wd);
#line 225 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	block28_data_unref (_data_->_data28_);
#line 225 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_data28_ = NULL;
#line 225 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	if (_data_->_state_ == 0) {
#line 225 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1614 "gitg-hook.c"
	} else {
#line 225 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1618 "gitg-hook.c"
	}
#line 225 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_object_unref (_data_->_async_result);
#line 225 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	return FALSE;
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->env = (_vala_array_free (_data_->env, _data_->env_length1, (GDestroyNotify) g_free), NULL);
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_g_object_unref0 (_data_->script);
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_g_object_unref0 (_data_->wd);
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	block28_data_unref (_data_->_data28_);
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_data_->_data28_ = NULL;
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	if (_data_->_state_ == 0) {
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1640 "gitg-hook.c"
	} else {
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1644 "gitg-hook.c"
	}
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_object_unref (_data_->_async_result);
#line 164 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	return FALSE;
#line 1650 "gitg-hook.c"
}


GeeHashMap* gitg_hook_get_environment (GitgHook* self) {
	GeeHashMap* result;
	GeeHashMap* _tmp0_ = NULL;
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp0_ = self->priv->_environment;
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	result = _tmp0_;
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	return result;
#line 1665 "gitg-hook.c"
}


void gitg_hook_set_environment (GitgHook* self, GeeHashMap* value) {
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_return_if_fail (self != NULL);
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp0_ = value;
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_g_object_unref0 (self->priv->_environment);
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	self->priv->_environment = _tmp1_;
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_object_notify ((GObject *) self, "environment");
#line 1684 "gitg-hook.c"
}


const gchar* gitg_hook_get_name (GitgHook* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 26 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 26 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp0_ = self->priv->_name;
#line 26 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	result = _tmp0_;
#line 26 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	return result;
#line 1699 "gitg-hook.c"
}


void gitg_hook_set_name (GitgHook* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 26 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_return_if_fail (self != NULL);
#line 26 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp0_ = value;
#line 26 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 26 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_g_free0 (self->priv->_name);
#line 26 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	self->priv->_name = _tmp1_;
#line 26 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_object_notify ((GObject *) self, "name");
#line 1718 "gitg-hook.c"
}


GFile* gitg_hook_get_working_directory (GitgHook* self) {
	GFile* result;
	GFile* _tmp0_ = NULL;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp0_ = self->priv->_working_directory;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	result = _tmp0_;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	return result;
#line 1733 "gitg-hook.c"
}


void gitg_hook_set_working_directory (GitgHook* self, GFile* value) {
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_return_if_fail (self != NULL);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp0_ = value;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_g_object_unref0 (self->priv->_working_directory);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	self->priv->_working_directory = _tmp1_;
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_object_notify ((GObject *) self, "working-directory");
#line 1752 "gitg-hook.c"
}


static gchar** _vala_array_dup12 (gchar** self, int length) {
	gchar** result;
	int i;
#line 34 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	result = g_new0 (gchar*, length + 1);
#line 34 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	for (i = 0; i < length; i++) {
#line 1763 "gitg-hook.c"
		gchar* _tmp0_ = NULL;
#line 34 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		_tmp0_ = g_strdup (self[i]);
#line 34 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		result[i] = _tmp0_;
#line 1769 "gitg-hook.c"
	}
#line 34 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	return result;
#line 1773 "gitg-hook.c"
}


gchar** gitg_hook_get_output (GitgHook* self, int* result_length1) {
	gchar** result;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
#line 34 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 34 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp0_ = self->priv->d_output;
#line 34 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp0__length1 = self->priv->d_output_length1;
#line 34 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup12 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 34 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp1__length1 = _tmp0__length1;
#line 34 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp2_ = _tmp1_;
#line 34 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp2__length1 = _tmp1__length1;
#line 34 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	if (result_length1) {
#line 34 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		*result_length1 = _tmp2__length1;
#line 1803 "gitg-hook.c"
	}
#line 34 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	result = _tmp2_;
#line 34 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	return result;
#line 1809 "gitg-hook.c"
}


static GObject * gitg_hook_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GitgHook * self;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
#line 37 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	parent_class = G_OBJECT_CLASS (gitg_hook_parent_class);
#line 37 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 37 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_HOOK, GitgHook);
#line 39 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 39 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_tmp1_ = _tmp0_;
#line 39 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	gitg_hook_set_environment (self, _tmp1_);
#line 39 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_g_object_unref0 (_tmp1_);
#line 37 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	return obj;
#line 1835 "gitg-hook.c"
}


static void gitg_hook_class_init (GitgHookClass * klass) {
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	gitg_hook_parent_class = g_type_class_peek_parent (klass);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_type_class_add_private (klass, sizeof (GitgHookPrivate));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_hook_get_property;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_hook_set_property;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	G_OBJECT_CLASS (klass)->constructor = gitg_hook_constructor;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_hook_finalize;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HOOK_ENVIRONMENT, g_param_spec_object ("environment", "environment", "environment", GEE_TYPE_HASH_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HOOK_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HOOK_WORKING_DIRECTORY, g_param_spec_object ("working-directory", "working-directory", "working-directory", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_HOOK_OUTPUT, g_param_spec_boxed ("output", "output", "output", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1860 "gitg-hook.c"
}


static void gitg_hook_instance_init (GitgHook * self) {
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	self->priv = GITG_HOOK_GET_PRIVATE (self);
#line 1867 "gitg-hook.c"
}


static void gitg_hook_finalize (GObject* obj) {
	GitgHook * self;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_HOOK, GitgHook);
#line 25 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_g_object_unref0 (self->priv->_environment);
#line 26 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_g_free0 (self->priv->_name);
#line 27 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	self->priv->d_arguments = (_vala_array_free (self->priv->d_arguments, self->priv->d_arguments_length1, (GDestroyNotify) g_free), NULL);
#line 28 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	_g_object_unref0 (self->priv->_working_directory);
#line 30 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	self->priv->d_output = (_vala_array_free (self->priv->d_output, self->priv->d_output_length1, (GDestroyNotify) g_free), NULL);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	G_OBJECT_CLASS (gitg_hook_parent_class)->finalize (obj);
#line 1887 "gitg-hook.c"
}


GType gitg_hook_get_type (void) {
	static volatile gsize gitg_hook_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_hook_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgHookClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_hook_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgHook), 0, (GInstanceInitFunc) gitg_hook_instance_init, NULL };
		GType gitg_hook_type_id;
		gitg_hook_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgHook", &g_define_type_info, 0);
		g_once_init_leave (&gitg_hook_type_id__volatile, gitg_hook_type_id);
	}
	return gitg_hook_type_id__volatile;
}


static void _vala_gitg_hook_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgHook * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_HOOK, GitgHook);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	switch (property_id) {
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		case GITG_HOOK_ENVIRONMENT:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		g_value_set_object (value, gitg_hook_get_environment (self));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		break;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		case GITG_HOOK_NAME:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		g_value_set_string (value, gitg_hook_get_name (self));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		break;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		case GITG_HOOK_WORKING_DIRECTORY:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		g_value_set_object (value, gitg_hook_get_working_directory (self));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		break;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		case GITG_HOOK_OUTPUT:
#line 1928 "gitg-hook.c"
		{
			int length;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
			g_value_take_boxed (value, gitg_hook_get_output (self, &length));
#line 1933 "gitg-hook.c"
		}
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		break;
#line 1937 "gitg-hook.c"
		default:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		break;
#line 1943 "gitg-hook.c"
	}
}


static void _vala_gitg_hook_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgHook * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_HOOK, GitgHook);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
	switch (property_id) {
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		case GITG_HOOK_ENVIRONMENT:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		gitg_hook_set_environment (self, g_value_get_object (value));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		break;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		case GITG_HOOK_NAME:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		gitg_hook_set_name (self, g_value_get_string (value));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		break;
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		case GITG_HOOK_WORKING_DIRECTORY:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		gitg_hook_set_working_directory (self, g_value_get_object (value));
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		break;
#line 1971 "gitg-hook.c"
		default:
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/home/jesse/devel/gitg/libgitg/gitg-hook.vala"
		break;
#line 1977 "gitg-hook.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



