/* ai.c generated by valac 0.30.0, the Vala compiler
 * generated from ai.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright © 2014 Nikhar Agrawal
 *
 * This file is part of Four-in-a-row.
 *
 * Four-in-a-row is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * Four-in-a-row is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Four-in-a-row.  If not, see <http://www.gnu.org/licenses/>. */
/* Here NEG_INF is supposed to be the lowest possible int value. int.MIN
MAX_HEURIST_VALUE is the maximum value that the heuristic functions can return.
It is returned when AI wins. -1*MAX_HEURIST_VALUE is returned when Human wins
MAX_HEURIST_VALUE < NEG_INF/plies */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "ai.h"
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PLAYER (player_get_type ())

#define TYPE_DIFFICULTY (difficulty_get_type ())
#define _decision_tree_unref0(var) ((var == NULL) ? NULL : (var = (decision_tree_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecDecisionTree ParamSpecDecisionTree;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	PLAYER_NONE,
	PLAYER_HUMAN,
	PLAYER_AI
} Player;

typedef enum  {
	DIFFICULTY_EASY,
	DIFFICULTY_MEDIUM,
	DIFFICULTY_HARD
} Difficulty;

struct _DecisionTreePrivate {
	Player* board;
	gint board_length1;
	gint board_length2;
	gint plies;
	Player last_moving_player;
	gint next_move_in_column;
	Difficulty level;
};

struct _ParamSpecDecisionTree {
	GParamSpec parent_instance;
};


static gpointer decision_tree_parent_class = NULL;

#define NEG_INF -100000
#define MAX_HEURIST_VALUE 10000
#define BOARD_ROWS 6
#define BOARD_COLUMNS 7
GType player_get_type (void) G_GNUC_CONST;
GType difficulty_get_type (void) G_GNUC_CONST;
gint playgame (const gchar* moves_until_now);
#define DECISION_TREE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DECISION_TREE, DecisionTreePrivate))
enum  {
	DECISION_TREE_DUMMY_PROPERTY
};
static gint decision_tree_negamax (DecisionTree* self, gint height, gint alpha, gint beta);
static gboolean decision_tree_board_full (DecisionTree* self);
static gint decision_tree_heurist (DecisionTree* self);
static gboolean decision_tree_move (DecisionTree* self, gint column);
static gboolean decision_tree_victory (DecisionTree* self, gint column);
static void decision_tree_unmove (DecisionTree* self, gint column);
static gboolean decision_tree_vertical_win (DecisionTree* self, gint i, gint j);
static gboolean decision_tree_horizontal_win (DecisionTree* self, gint i, gint j);
static gboolean decision_tree_forward_diagonal_win (DecisionTree* self, gint i, gint j);
static gboolean decision_tree_backward_diagonal_win (DecisionTree* self, gint i, gint j);
static gint decision_tree_immediate_win (DecisionTree* self, Player p);
static void decision_tree_set_level (DecisionTree* self, const gchar* vstr);
static gint decision_tree_heurist_easy (DecisionTree* self);
static gint decision_tree_heurist_medium (DecisionTree* self);
static gint decision_tree_heurist_hard (DecisionTree* self);
static gint decision_tree_count_3_in_a_row (DecisionTree* self, Player p);
static gboolean decision_tree_all_adjacent_empty (DecisionTree* self, gint i, gint j);
static void decision_tree_finalize (DecisionTree* obj);


GType player_get_type (void) {
	static volatile gsize player_type_id__volatile = 0;
	if (g_once_init_enter (&player_type_id__volatile)) {
		static const GEnumValue values[] = {{PLAYER_NONE, "PLAYER_NONE", "none"}, {PLAYER_HUMAN, "PLAYER_HUMAN", "human"}, {PLAYER_AI, "PLAYER_AI", "ai"}, {0, NULL, NULL}};
		GType player_type_id;
		player_type_id = g_enum_register_static ("Player", values);
		g_once_init_leave (&player_type_id__volatile, player_type_id);
	}
	return player_type_id__volatile;
}


GType difficulty_get_type (void) {
	static volatile gsize difficulty_type_id__volatile = 0;
	if (g_once_init_enter (&difficulty_type_id__volatile)) {
		static const GEnumValue values[] = {{DIFFICULTY_EASY, "DIFFICULTY_EASY", "easy"}, {DIFFICULTY_MEDIUM, "DIFFICULTY_MEDIUM", "medium"}, {DIFFICULTY_HARD, "DIFFICULTY_HARD", "hard"}, {0, NULL, NULL}};
		GType difficulty_type_id;
		difficulty_type_id = g_enum_register_static ("Difficulty", values);
		g_once_init_leave (&difficulty_type_id__volatile, difficulty_type_id);
	}
	return difficulty_type_id__volatile;
}


gint playgame (const gchar* moves_until_now) {
	gint result = 0;
	DecisionTree* t = NULL;
	DecisionTree* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 32 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (moves_until_now != NULL, 0);
#line 34 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp0_ = decision_tree_new ();
#line 34 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	t = _tmp0_;
#line 35 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp1_ = moves_until_now;
#line 35 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp2_ = decision_tree_playgame (t, _tmp1_);
#line 35 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = _tmp2_;
#line 35 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_decision_tree_unref0 (t);
#line 35 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 154 "ai.c"
}


DecisionTree* decision_tree_construct (GType object_type) {
	DecisionTree* self = NULL;
#line 52 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self = (DecisionTree*) g_type_create_instance (object_type);
#line 162 "ai.c"
	{
		gint i = 0;
#line 54 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		i = 0;
#line 167 "ai.c"
		{
			gboolean _tmp0_ = FALSE;
#line 54 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp0_ = TRUE;
#line 54 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 174 "ai.c"
				gint _tmp2_ = 0;
#line 54 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp0_) {
#line 178 "ai.c"
					gint _tmp1_ = 0;
#line 54 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp1_ = i;
#line 54 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					i = _tmp1_ + 1;
#line 184 "ai.c"
				}
#line 54 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp0_ = FALSE;
#line 54 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp2_ = i;
#line 54 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!(_tmp2_ < BOARD_ROWS)) {
#line 54 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 194 "ai.c"
				}
				{
					gint j = 0;
#line 55 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					j = 0;
#line 200 "ai.c"
					{
						gboolean _tmp3_ = FALSE;
#line 55 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						_tmp3_ = TRUE;
#line 55 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						while (TRUE) {
#line 207 "ai.c"
							gint _tmp5_ = 0;
							Player* _tmp6_ = NULL;
							gint _tmp6__length1 = 0;
							gint _tmp6__length2 = 0;
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							Player _tmp9_ = 0;
#line 55 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (!_tmp3_) {
#line 217 "ai.c"
								gint _tmp4_ = 0;
#line 55 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp4_ = j;
#line 55 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								j = _tmp4_ + 1;
#line 223 "ai.c"
							}
#line 55 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp3_ = FALSE;
#line 55 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp5_ = j;
#line 55 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (!(_tmp5_ < BOARD_COLUMNS)) {
#line 55 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								break;
#line 233 "ai.c"
							}
#line 56 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp6_ = self->priv->board;
#line 56 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp6__length1 = self->priv->board_length1;
#line 56 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp6__length2 = self->priv->board_length2;
#line 56 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp7_ = i;
#line 56 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp8_ = j;
#line 56 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp6_[(_tmp7_ * _tmp6__length2) + _tmp8_] = PLAYER_NONE;
#line 56 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp9_ = _tmp6_[(_tmp7_ * _tmp6__length2) + _tmp8_];
#line 249 "ai.c"
						}
					}
				}
			}
		}
	}
#line 52 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return self;
#line 258 "ai.c"
}


DecisionTree* decision_tree_new (void) {
#line 52 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return decision_tree_construct (TYPE_DECISION_TREE);
#line 265 "ai.c"
}


void decision_tree_print_board (DecisionTree* self) {
	FILE* _tmp12_ = NULL;
#line 60 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_if_fail (self != NULL);
#line 273 "ai.c"
	{
		gint i = 0;
#line 62 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		i = 0;
#line 278 "ai.c"
		{
			gboolean _tmp0_ = FALSE;
#line 62 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp0_ = TRUE;
#line 62 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 285 "ai.c"
				gint _tmp2_ = 0;
				FILE* _tmp11_ = NULL;
#line 62 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp0_) {
#line 290 "ai.c"
					gint _tmp1_ = 0;
#line 62 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp1_ = i;
#line 62 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					i = _tmp1_ + 1;
#line 296 "ai.c"
				}
#line 62 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp0_ = FALSE;
#line 62 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp2_ = i;
#line 62 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!(_tmp2_ < BOARD_ROWS)) {
#line 62 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 306 "ai.c"
				}
				{
					gint j = 0;
#line 64 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					j = 0;
#line 312 "ai.c"
					{
						gboolean _tmp3_ = FALSE;
#line 64 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						_tmp3_ = TRUE;
#line 64 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						while (TRUE) {
#line 319 "ai.c"
							gint _tmp5_ = 0;
							FILE* _tmp6_ = NULL;
							Player* _tmp7_ = NULL;
							gint _tmp7__length1 = 0;
							gint _tmp7__length2 = 0;
							gint _tmp8_ = 0;
							gint _tmp9_ = 0;
							Player _tmp10_ = 0;
#line 64 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (!_tmp3_) {
#line 330 "ai.c"
								gint _tmp4_ = 0;
#line 64 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp4_ = j;
#line 64 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								j = _tmp4_ + 1;
#line 336 "ai.c"
							}
#line 64 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp3_ = FALSE;
#line 64 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp5_ = j;
#line 64 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (!(_tmp5_ < BOARD_COLUMNS)) {
#line 64 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								break;
#line 346 "ai.c"
							}
#line 65 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp6_ = stdout;
#line 65 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp7_ = self->priv->board;
#line 65 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp7__length1 = self->priv->board_length1;
#line 65 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp7__length2 = self->priv->board_length2;
#line 65 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp8_ = i;
#line 65 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp9_ = j;
#line 65 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp10_ = _tmp7_[(_tmp8_ * _tmp7__length2) + _tmp9_];
#line 65 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							fprintf (_tmp6_, "%d\t", (gint) _tmp10_);
#line 364 "ai.c"
						}
					}
				}
#line 66 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp11_ = stdout;
#line 66 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				fprintf (_tmp11_, "\n");
#line 372 "ai.c"
			}
		}
	}
#line 68 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp12_ = stdout;
#line 68 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	fprintf (_tmp12_, "\n");
#line 380 "ai.c"
}


static gint decision_tree_negamax (DecisionTree* self, gint height, gint alpha, gint beta) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint max = 0;
	gint next = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
#line 73 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 76 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp1_ = height;
#line 76 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp1_ == 0) {
#line 76 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp0_ = TRUE;
#line 400 "ai.c"
	} else {
		gboolean _tmp2_ = FALSE;
#line 76 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp2_ = decision_tree_board_full (self);
#line 76 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp0_ = _tmp2_;
#line 407 "ai.c"
	}
#line 76 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp0_) {
#line 411 "ai.c"
		Player _tmp3_ = 0;
#line 78 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp3_ = self->priv->last_moving_player;
#line 78 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		if (_tmp3_ == PLAYER_HUMAN) {
#line 417 "ai.c"
			gint _tmp4_ = 0;
#line 79 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp4_ = decision_tree_heurist (self);
#line 79 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			result = _tmp4_;
#line 79 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			return result;
#line 425 "ai.c"
		} else {
			Player _tmp5_ = 0;
#line 80 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp5_ = self->priv->last_moving_player;
#line 80 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			if (_tmp5_ == PLAYER_AI) {
#line 432 "ai.c"
				gint _tmp6_ = 0;
#line 81 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp6_ = decision_tree_heurist (self);
#line 81 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				result = -1 * _tmp6_;
#line 81 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				return result;
#line 440 "ai.c"
			} else {
#line 83 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				result = 0;
#line 83 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				return result;
#line 446 "ai.c"
			}
		}
	}
#line 88 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	max = NEG_INF;
#line 92 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	next = -1;
#line 454 "ai.c"
	{
		gint column = 0;
#line 94 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		column = 0;
#line 459 "ai.c"
		{
			gboolean _tmp7_ = FALSE;
#line 94 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp7_ = TRUE;
#line 94 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 466 "ai.c"
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gboolean _tmp11_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				gboolean _tmp14_ = FALSE;
				gint temp = 0;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
#line 94 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp7_) {
#line 483 "ai.c"
					gint _tmp8_ = 0;
#line 94 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp8_ = column;
#line 94 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					column = _tmp8_ + 1;
#line 489 "ai.c"
				}
#line 94 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp7_ = FALSE;
#line 94 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp9_ = column;
#line 94 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!(_tmp9_ < BOARD_COLUMNS)) {
#line 94 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 499 "ai.c"
				}
#line 97 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp10_ = column;
#line 97 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp11_ = decision_tree_move (self, _tmp10_);
#line 97 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp11_) {
#line 98 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					continue;
#line 509 "ai.c"
				}
#line 103 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp13_ = column;
#line 103 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp14_ = decision_tree_victory (self, _tmp13_);
#line 103 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp14_) {
#line 517 "ai.c"
					gint _tmp15_ = 0;
#line 103 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp15_ = height;
#line 103 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp12_ = MAX_HEURIST_VALUE * _tmp15_;
#line 523 "ai.c"
				} else {
					gint _tmp16_ = 0;
					gint _tmp17_ = 0;
					gint _tmp18_ = 0;
					gint _tmp19_ = 0;
#line 103 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp16_ = height;
#line 103 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp17_ = beta;
#line 103 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp18_ = alpha;
#line 103 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp19_ = decision_tree_negamax (self, _tmp16_ - 1, -1 * _tmp17_, -1 * _tmp18_);
#line 103 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp12_ = -1 * _tmp19_;
#line 539 "ai.c"
				}
#line 103 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				temp = _tmp12_;
#line 105 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp20_ = column;
#line 105 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				decision_tree_unmove (self, _tmp20_);
#line 107 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp21_ = temp;
#line 107 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp22_ = max;
#line 107 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp21_ > _tmp22_) {
#line 553 "ai.c"
					gint _tmp23_ = 0;
					gint _tmp24_ = 0;
#line 109 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp23_ = column;
#line 109 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					next = _tmp23_;
#line 110 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp24_ = temp;
#line 110 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					max = _tmp24_;
#line 564 "ai.c"
				}
#line 113 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp25_ = temp;
#line 113 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp26_ = alpha;
#line 113 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp25_ > _tmp26_) {
#line 572 "ai.c"
					gint _tmp27_ = 0;
#line 114 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp27_ = temp;
#line 114 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					alpha = _tmp27_;
#line 578 "ai.c"
				}
#line 116 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp28_ = alpha;
#line 116 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp29_ = beta;
#line 116 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp28_ >= _tmp29_) {
#line 117 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 588 "ai.c"
				}
			}
		}
	}
#line 121 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp30_ = height;
#line 121 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp31_ = self->priv->plies;
#line 121 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp30_ == _tmp31_) {
#line 599 "ai.c"
		gint _tmp32_ = 0;
#line 122 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp32_ = next;
#line 122 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		self->priv->next_move_in_column = _tmp32_;
#line 605 "ai.c"
	}
#line 124 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = max;
#line 124 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 611 "ai.c"
}


static gboolean decision_tree_victory (DecisionTree* self, gint column) {
	gboolean result = FALSE;
	gint row = 0;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gboolean _tmp13_ = FALSE;
#line 128 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 626 "ai.c"
	{
		gboolean _tmp0_ = FALSE;
#line 132 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		row = 0;
#line 132 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp0_ = TRUE;
#line 132 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		while (TRUE) {
#line 635 "ai.c"
			gboolean _tmp2_ = FALSE;
			gint _tmp3_ = 0;
#line 132 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			if (!_tmp0_) {
#line 640 "ai.c"
				gint _tmp1_ = 0;
#line 132 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp1_ = row;
#line 132 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				row = _tmp1_ + 1;
#line 646 "ai.c"
			}
#line 132 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp0_ = FALSE;
#line 132 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp3_ = row;
#line 132 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			if (_tmp3_ < BOARD_ROWS) {
#line 654 "ai.c"
				Player* _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				gint _tmp4__length2 = 0;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				Player _tmp7_ = 0;
#line 132 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp4_ = self->priv->board;
#line 132 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp4__length1 = self->priv->board_length1;
#line 132 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp4__length2 = self->priv->board_length2;
#line 132 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp5_ = row;
#line 132 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp6_ = column;
#line 132 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp7_ = _tmp4_[(_tmp5_ * _tmp4__length2) + _tmp6_];
#line 132 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp2_ = _tmp7_ == PLAYER_NONE;
#line 675 "ai.c"
			} else {
#line 132 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp2_ = FALSE;
#line 679 "ai.c"
			}
#line 132 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			if (!_tmp2_) {
#line 132 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				break;
#line 685 "ai.c"
			}
		}
	}
#line 134 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp11_ = row;
#line 134 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp12_ = column;
#line 134 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp13_ = decision_tree_vertical_win (self, _tmp11_, _tmp12_);
#line 134 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp13_) {
#line 134 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp10_ = TRUE;
#line 699 "ai.c"
	} else {
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gboolean _tmp16_ = FALSE;
#line 135 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp14_ = row;
#line 135 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp15_ = column;
#line 135 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp16_ = decision_tree_horizontal_win (self, _tmp14_, _tmp15_);
#line 135 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp10_ = _tmp16_;
#line 712 "ai.c"
	}
#line 134 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp10_) {
#line 134 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp9_ = TRUE;
#line 718 "ai.c"
	} else {
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		gboolean _tmp19_ = FALSE;
#line 136 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp17_ = row;
#line 136 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp18_ = column;
#line 136 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp19_ = decision_tree_forward_diagonal_win (self, _tmp17_, _tmp18_);
#line 136 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp9_ = _tmp19_;
#line 731 "ai.c"
	}
#line 134 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp9_) {
#line 134 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp8_ = TRUE;
#line 737 "ai.c"
	} else {
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		gboolean _tmp22_ = FALSE;
#line 137 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp20_ = row;
#line 137 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp21_ = column;
#line 137 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp22_ = decision_tree_backward_diagonal_win (self, _tmp20_, _tmp21_);
#line 137 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp8_ = _tmp22_;
#line 750 "ai.c"
	}
#line 134 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = _tmp8_;
#line 134 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 756 "ai.c"
}


static gboolean decision_tree_forward_diagonal_win (DecisionTree* self, gint i, gint j) {
	gboolean result = FALSE;
	gint count = 0;
	gint _tmp30_ = 0;
#line 140 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 142 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	count = 0;
#line 768 "ai.c"
	{
		gint k = 0;
		gint _tmp0_ = 0;
		gint l = 0;
		gint _tmp1_ = 0;
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp0_ = i;
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		k = _tmp0_;
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp1_ = j;
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		l = _tmp1_;
#line 782 "ai.c"
		{
			gboolean _tmp2_ = FALSE;
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp2_ = TRUE;
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 789 "ai.c"
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp8_ = 0;
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp2_) {
#line 795 "ai.c"
					gint _tmp3_ = 0;
					gint _tmp4_ = 0;
					gint _tmp5_ = 0;
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp3_ = k;
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					k = _tmp3_ - 1;
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp4_ = l;
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					l = _tmp4_ + 1;
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp5_ = count;
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					count = _tmp5_ + 1;
#line 811 "ai.c"
				}
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp2_ = FALSE;
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp8_ = k;
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp8_ >= 0) {
#line 819 "ai.c"
					gint _tmp9_ = 0;
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp9_ = l;
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp7_ = _tmp9_ < BOARD_COLUMNS;
#line 825 "ai.c"
				} else {
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp7_ = FALSE;
#line 829 "ai.c"
				}
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp7_) {
#line 833 "ai.c"
					Player* _tmp10_ = NULL;
					gint _tmp10__length1 = 0;
					gint _tmp10__length2 = 0;
					gint _tmp11_ = 0;
					gint _tmp12_ = 0;
					Player _tmp13_ = 0;
					Player _tmp14_ = 0;
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp10_ = self->priv->board;
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp10__length1 = self->priv->board_length1;
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp10__length2 = self->priv->board_length2;
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp11_ = k;
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp12_ = l;
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp13_ = _tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_];
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp14_ = self->priv->last_moving_player;
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp6_ = _tmp13_ == _tmp14_;
#line 857 "ai.c"
				} else {
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp6_ = FALSE;
#line 861 "ai.c"
				}
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp6_) {
#line 144 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 867 "ai.c"
				}
			}
		}
	}
	{
		gint k = 0;
		gint _tmp15_ = 0;
		gint l = 0;
		gint _tmp16_ = 0;
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp15_ = i;
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		k = _tmp15_ + 1;
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp16_ = j;
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		l = _tmp16_ - 1;
#line 885 "ai.c"
		{
			gboolean _tmp17_ = FALSE;
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp17_ = TRUE;
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 892 "ai.c"
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
				gint _tmp23_ = 0;
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp17_) {
#line 898 "ai.c"
					gint _tmp18_ = 0;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp18_ = k;
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					k = _tmp18_ + 1;
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp19_ = l;
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					l = _tmp19_ - 1;
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp20_ = count;
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					count = _tmp20_ + 1;
#line 914 "ai.c"
				}
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp17_ = FALSE;
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp23_ = k;
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp23_ < BOARD_ROWS) {
#line 922 "ai.c"
					gint _tmp24_ = 0;
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp24_ = l;
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp22_ = _tmp24_ >= 0;
#line 928 "ai.c"
				} else {
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp22_ = FALSE;
#line 932 "ai.c"
				}
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp22_) {
#line 936 "ai.c"
					Player* _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp25__length2 = 0;
					gint _tmp26_ = 0;
					gint _tmp27_ = 0;
					Player _tmp28_ = 0;
					Player _tmp29_ = 0;
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp25_ = self->priv->board;
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp25__length1 = self->priv->board_length1;
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp25__length2 = self->priv->board_length2;
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp26_ = k;
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp27_ = l;
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp29_ = self->priv->last_moving_player;
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp21_ = _tmp28_ == _tmp29_;
#line 960 "ai.c"
				} else {
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp21_ = FALSE;
#line 964 "ai.c"
				}
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp21_) {
#line 145 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 970 "ai.c"
				}
			}
		}
	}
#line 147 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp30_ = count;
#line 147 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = _tmp30_ >= 4;
#line 147 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 981 "ai.c"
}


static gboolean decision_tree_backward_diagonal_win (DecisionTree* self, gint i, gint j) {
	gboolean result = FALSE;
	gint count = 0;
	gint _tmp30_ = 0;
#line 150 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 152 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	count = 0;
#line 993 "ai.c"
	{
		gint k = 0;
		gint _tmp0_ = 0;
		gint l = 0;
		gint _tmp1_ = 0;
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp0_ = i;
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		k = _tmp0_;
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp1_ = j;
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		l = _tmp1_;
#line 1007 "ai.c"
		{
			gboolean _tmp2_ = FALSE;
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp2_ = TRUE;
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 1014 "ai.c"
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp8_ = 0;
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp2_) {
#line 1020 "ai.c"
					gint _tmp3_ = 0;
					gint _tmp4_ = 0;
					gint _tmp5_ = 0;
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp3_ = k;
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					k = _tmp3_ - 1;
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp4_ = l;
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					l = _tmp4_ - 1;
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp5_ = count;
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					count = _tmp5_ + 1;
#line 1036 "ai.c"
				}
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp2_ = FALSE;
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp8_ = k;
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp8_ >= 0) {
#line 1044 "ai.c"
					gint _tmp9_ = 0;
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp9_ = l;
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp7_ = _tmp9_ >= 0;
#line 1050 "ai.c"
				} else {
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp7_ = FALSE;
#line 1054 "ai.c"
				}
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp7_) {
#line 1058 "ai.c"
					Player* _tmp10_ = NULL;
					gint _tmp10__length1 = 0;
					gint _tmp10__length2 = 0;
					gint _tmp11_ = 0;
					gint _tmp12_ = 0;
					Player _tmp13_ = 0;
					Player _tmp14_ = 0;
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp10_ = self->priv->board;
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp10__length1 = self->priv->board_length1;
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp10__length2 = self->priv->board_length2;
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp11_ = k;
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp12_ = l;
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp13_ = _tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_];
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp14_ = self->priv->last_moving_player;
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp6_ = _tmp13_ == _tmp14_;
#line 1082 "ai.c"
				} else {
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp6_ = FALSE;
#line 1086 "ai.c"
				}
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp6_) {
#line 154 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 1092 "ai.c"
				}
			}
		}
	}
	{
		gint k = 0;
		gint _tmp15_ = 0;
		gint l = 0;
		gint _tmp16_ = 0;
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp15_ = i;
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		k = _tmp15_ + 1;
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp16_ = j;
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		l = _tmp16_ + 1;
#line 1110 "ai.c"
		{
			gboolean _tmp17_ = FALSE;
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp17_ = TRUE;
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 1117 "ai.c"
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
				gint _tmp23_ = 0;
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp17_) {
#line 1123 "ai.c"
					gint _tmp18_ = 0;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp18_ = k;
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					k = _tmp18_ + 1;
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp19_ = l;
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					l = _tmp19_ + 1;
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp20_ = count;
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					count = _tmp20_ + 1;
#line 1139 "ai.c"
				}
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp17_ = FALSE;
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp23_ = k;
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp23_ < BOARD_ROWS) {
#line 1147 "ai.c"
					gint _tmp24_ = 0;
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp24_ = l;
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp22_ = _tmp24_ < BOARD_COLUMNS;
#line 1153 "ai.c"
				} else {
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp22_ = FALSE;
#line 1157 "ai.c"
				}
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp22_) {
#line 1161 "ai.c"
					Player* _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp25__length2 = 0;
					gint _tmp26_ = 0;
					gint _tmp27_ = 0;
					Player _tmp28_ = 0;
					Player _tmp29_ = 0;
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp25_ = self->priv->board;
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp25__length1 = self->priv->board_length1;
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp25__length2 = self->priv->board_length2;
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp26_ = k;
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp27_ = l;
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp29_ = self->priv->last_moving_player;
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp21_ = _tmp28_ == _tmp29_;
#line 1185 "ai.c"
				} else {
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp21_ = FALSE;
#line 1189 "ai.c"
				}
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp21_) {
#line 155 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 1195 "ai.c"
				}
			}
		}
	}
#line 157 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp30_ = count;
#line 157 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = _tmp30_ >= 4;
#line 157 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 1206 "ai.c"
}


static gboolean decision_tree_horizontal_win (DecisionTree* self, gint i, gint j) {
	gboolean result = FALSE;
	gint count = 0;
	gint _tmp22_ = 0;
#line 160 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 162 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	count = 0;
#line 1218 "ai.c"
	{
		gint k = 0;
		gint _tmp0_ = 0;
#line 164 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp0_ = j;
#line 164 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		k = _tmp0_;
#line 1226 "ai.c"
		{
			gboolean _tmp1_ = FALSE;
#line 164 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp1_ = TRUE;
#line 164 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 1233 "ai.c"
				gboolean _tmp4_ = FALSE;
				gint _tmp5_ = 0;
#line 164 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp1_) {
#line 1238 "ai.c"
					gint _tmp2_ = 0;
					gint _tmp3_ = 0;
#line 164 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp2_ = k;
#line 164 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					k = _tmp2_ - 1;
#line 164 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp3_ = count;
#line 164 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					count = _tmp3_ + 1;
#line 1249 "ai.c"
				}
#line 164 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp1_ = FALSE;
#line 164 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp5_ = k;
#line 164 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp5_ >= 0) {
#line 1257 "ai.c"
					Player* _tmp6_ = NULL;
					gint _tmp6__length1 = 0;
					gint _tmp6__length2 = 0;
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
					Player _tmp9_ = 0;
					Player _tmp10_ = 0;
#line 164 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp6_ = self->priv->board;
#line 164 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp6__length1 = self->priv->board_length1;
#line 164 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp6__length2 = self->priv->board_length2;
#line 164 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp7_ = i;
#line 164 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp8_ = k;
#line 164 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp9_ = _tmp6_[(_tmp7_ * _tmp6__length2) + _tmp8_];
#line 164 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp10_ = self->priv->last_moving_player;
#line 164 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp4_ = _tmp9_ == _tmp10_;
#line 1281 "ai.c"
				} else {
#line 164 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp4_ = FALSE;
#line 1285 "ai.c"
				}
#line 164 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp4_) {
#line 164 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 1291 "ai.c"
				}
			}
		}
	}
	{
		gint k = 0;
		gint _tmp11_ = 0;
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp11_ = j;
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		k = _tmp11_ + 1;
#line 1303 "ai.c"
		{
			gboolean _tmp12_ = FALSE;
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp12_ = TRUE;
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 1310 "ai.c"
				gboolean _tmp15_ = FALSE;
				gint _tmp16_ = 0;
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp12_) {
#line 1315 "ai.c"
					gint _tmp13_ = 0;
					gint _tmp14_ = 0;
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp13_ = k;
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					k = _tmp13_ + 1;
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp14_ = count;
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					count = _tmp14_ + 1;
#line 1326 "ai.c"
				}
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp12_ = FALSE;
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp16_ = k;
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp16_ < BOARD_COLUMNS) {
#line 1334 "ai.c"
					Player* _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					gint _tmp17__length2 = 0;
					gint _tmp18_ = 0;
					gint _tmp19_ = 0;
					Player _tmp20_ = 0;
					Player _tmp21_ = 0;
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp17_ = self->priv->board;
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp17__length1 = self->priv->board_length1;
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp17__length2 = self->priv->board_length2;
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp18_ = i;
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp19_ = k;
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp20_ = _tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_];
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp21_ = self->priv->last_moving_player;
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp15_ = _tmp20_ == _tmp21_;
#line 1358 "ai.c"
				} else {
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp15_ = FALSE;
#line 1362 "ai.c"
				}
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp15_) {
#line 165 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 1368 "ai.c"
				}
			}
		}
	}
#line 167 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp22_ = count;
#line 167 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = _tmp22_ >= 4;
#line 167 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 1379 "ai.c"
}


static gboolean decision_tree_vertical_win (DecisionTree* self, gint i, gint j) {
	gboolean result = FALSE;
	gint count = 0;
	gint _tmp11_ = 0;
#line 170 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 172 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	count = 0;
#line 1391 "ai.c"
	{
		gint k = 0;
		gint _tmp0_ = 0;
#line 174 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp0_ = i;
#line 174 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		k = _tmp0_;
#line 1399 "ai.c"
		{
			gboolean _tmp1_ = FALSE;
#line 174 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp1_ = TRUE;
#line 174 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 1406 "ai.c"
				gboolean _tmp4_ = FALSE;
				gint _tmp5_ = 0;
#line 174 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp1_) {
#line 1411 "ai.c"
					gint _tmp2_ = 0;
					gint _tmp3_ = 0;
#line 174 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp2_ = k;
#line 174 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					k = _tmp2_ + 1;
#line 174 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp3_ = count;
#line 174 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					count = _tmp3_ + 1;
#line 1422 "ai.c"
				}
#line 174 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp1_ = FALSE;
#line 174 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp5_ = k;
#line 174 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp5_ < BOARD_ROWS) {
#line 1430 "ai.c"
					Player* _tmp6_ = NULL;
					gint _tmp6__length1 = 0;
					gint _tmp6__length2 = 0;
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
					Player _tmp9_ = 0;
					Player _tmp10_ = 0;
#line 174 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp6_ = self->priv->board;
#line 174 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp6__length1 = self->priv->board_length1;
#line 174 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp6__length2 = self->priv->board_length2;
#line 174 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp7_ = k;
#line 174 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp8_ = j;
#line 174 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp9_ = _tmp6_[(_tmp7_ * _tmp6__length2) + _tmp8_];
#line 174 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp10_ = self->priv->last_moving_player;
#line 174 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp4_ = _tmp9_ == _tmp10_;
#line 1454 "ai.c"
				} else {
#line 174 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp4_ = FALSE;
#line 1458 "ai.c"
				}
#line 174 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp4_) {
#line 174 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 1464 "ai.c"
				}
			}
		}
	}
#line 176 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp11_ = count;
#line 176 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = _tmp11_ >= 4;
#line 176 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 1475 "ai.c"
}


static gboolean decision_tree_board_full (DecisionTree* self) {
	gboolean result = FALSE;
#line 180 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1483 "ai.c"
	{
		gint i = 0;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		i = 0;
#line 1488 "ai.c"
		{
			gboolean _tmp0_ = FALSE;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp0_ = TRUE;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 1495 "ai.c"
				gint _tmp2_ = 0;
				Player* _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				gint _tmp3__length2 = 0;
				gint _tmp4_ = 0;
				Player _tmp5_ = 0;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp0_) {
#line 1504 "ai.c"
					gint _tmp1_ = 0;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp1_ = i;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					i = _tmp1_ + 1;
#line 1510 "ai.c"
				}
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp0_ = FALSE;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp2_ = i;
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!(_tmp2_ < BOARD_COLUMNS)) {
#line 182 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 1520 "ai.c"
				}
#line 183 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp3_ = self->priv->board;
#line 183 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp3__length1 = self->priv->board_length1;
#line 183 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp3__length2 = self->priv->board_length2;
#line 183 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp4_ = i;
#line 183 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp5_ = _tmp3_[(0 * _tmp3__length2) + _tmp4_];
#line 183 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp5_ == PLAYER_NONE) {
#line 184 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					result = FALSE;
#line 184 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					return result;
#line 1538 "ai.c"
				}
			}
		}
	}
#line 185 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = TRUE;
#line 185 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 1547 "ai.c"
}


static gboolean decision_tree_move (DecisionTree* self, gint column) {
	gboolean result = FALSE;
	gint row = 0;
	gint _tmp8_ = 0;
	Player _tmp9_ = 0;
	Player _tmp10_ = 0;
	Player player = 0;
	Player* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gint _tmp11__length2 = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	Player _tmp14_ = 0;
	Player _tmp15_ = 0;
	Player _tmp16_ = 0;
#line 189 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1568 "ai.c"
	{
		gboolean _tmp0_ = FALSE;
#line 193 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		row = BOARD_ROWS - 1;
#line 193 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp0_ = TRUE;
#line 193 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		while (TRUE) {
#line 1577 "ai.c"
			gboolean _tmp2_ = FALSE;
			gint _tmp3_ = 0;
#line 193 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			if (!_tmp0_) {
#line 1582 "ai.c"
				gint _tmp1_ = 0;
#line 193 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp1_ = row;
#line 193 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				row = _tmp1_ - 1;
#line 1588 "ai.c"
			}
#line 193 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp0_ = FALSE;
#line 193 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp3_ = row;
#line 193 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			if (_tmp3_ >= 0) {
#line 1596 "ai.c"
				Player* _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				gint _tmp4__length2 = 0;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				Player _tmp7_ = 0;
#line 193 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp4_ = self->priv->board;
#line 193 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp4__length1 = self->priv->board_length1;
#line 193 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp4__length2 = self->priv->board_length2;
#line 193 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp5_ = row;
#line 193 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp6_ = column;
#line 193 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp7_ = _tmp4_[(_tmp5_ * _tmp4__length2) + _tmp6_];
#line 193 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp2_ = _tmp7_ != PLAYER_NONE;
#line 1617 "ai.c"
			} else {
#line 193 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp2_ = FALSE;
#line 1621 "ai.c"
			}
#line 193 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			if (!_tmp2_) {
#line 193 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				break;
#line 1627 "ai.c"
			}
		}
	}
#line 195 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp8_ = row;
#line 195 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp8_ < 0) {
#line 196 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		result = FALSE;
#line 196 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		return result;
#line 1639 "ai.c"
	}
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp10_ = self->priv->last_moving_player;
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp10_ != PLAYER_AI) {
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp9_ = PLAYER_AI;
#line 1647 "ai.c"
	} else {
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp9_ = PLAYER_HUMAN;
#line 1651 "ai.c"
	}
#line 199 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	player = _tmp9_;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp11_ = self->priv->board;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp11__length1 = self->priv->board_length1;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp11__length2 = self->priv->board_length2;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp12_ = row;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp13_ = column;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp14_ = player;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_] = _tmp14_;
#line 200 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp15_ = _tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_];
#line 201 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp16_ = player;
#line 201 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv->last_moving_player = _tmp16_;
#line 203 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = TRUE;
#line 203 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 1679 "ai.c"
}


static void decision_tree_unmove (DecisionTree* self, gint column) {
	Player _tmp0_ = 0;
	gint row = 0;
	Player* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gint _tmp9__length2 = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	Player _tmp12_ = 0;
	Player _tmp13_ = 0;
	Player _tmp14_ = 0;
#line 207 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_if_fail (self != NULL);
#line 207 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp0_ = self->priv->last_moving_player;
#line 207 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_vala_return_if_fail (_tmp0_ != PLAYER_NONE, "last_moving_player != Player.NONE");
#line 1700 "ai.c"
	{
		gboolean _tmp1_ = FALSE;
#line 212 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		row = 0;
#line 212 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp1_ = TRUE;
#line 212 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		while (TRUE) {
#line 1709 "ai.c"
			gboolean _tmp3_ = FALSE;
			gint _tmp4_ = 0;
#line 212 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			if (!_tmp1_) {
#line 1714 "ai.c"
				gint _tmp2_ = 0;
#line 212 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp2_ = row;
#line 212 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				row = _tmp2_ + 1;
#line 1720 "ai.c"
			}
#line 212 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp1_ = FALSE;
#line 212 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp4_ = row;
#line 212 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			if (_tmp4_ < BOARD_ROWS) {
#line 1728 "ai.c"
				Player* _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gint _tmp5__length2 = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				Player _tmp8_ = 0;
#line 212 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp5_ = self->priv->board;
#line 212 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp5__length1 = self->priv->board_length1;
#line 212 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp5__length2 = self->priv->board_length2;
#line 212 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp6_ = row;
#line 212 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp7_ = column;
#line 212 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp8_ = _tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_];
#line 212 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp3_ = _tmp8_ == PLAYER_NONE;
#line 1749 "ai.c"
			} else {
#line 212 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp3_ = FALSE;
#line 1753 "ai.c"
			}
#line 212 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			if (!_tmp3_) {
#line 212 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				break;
#line 1759 "ai.c"
			}
		}
	}
#line 214 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp9_ = self->priv->board;
#line 214 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp9__length1 = self->priv->board_length1;
#line 214 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp9__length2 = self->priv->board_length2;
#line 214 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp10_ = row;
#line 214 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp11_ = column;
#line 214 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_] = PLAYER_NONE;
#line 214 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
#line 216 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp14_ = self->priv->last_moving_player;
#line 216 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp14_ == PLAYER_AI) {
#line 216 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp13_ = PLAYER_HUMAN;
#line 1783 "ai.c"
	} else {
#line 216 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp13_ = PLAYER_AI;
#line 1787 "ai.c"
	}
#line 216 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv->last_moving_player = _tmp13_;
#line 1791 "ai.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 996 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 1809 "ai.c"
}


void decision_tree_update_board (DecisionTree* self, const gchar* vstr) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Player _tmp3_ = 0;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	Player move = 0;
#line 220 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_if_fail (self != NULL);
#line 220 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_if_fail (vstr != NULL);
#line 222 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv->next_move_in_column = -1;
#line 225 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp0_ = vstr;
#line 225 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp1_ = strlen (_tmp0_);
#line 225 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp2_ = _tmp1_;
#line 225 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp2_ == 2) {
#line 225 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		return;
#line 1838 "ai.c"
	}
#line 227 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp4_ = vstr;
#line 227 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp5_ = strlen (_tmp4_);
#line 227 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp6_ = _tmp5_;
#line 227 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if ((_tmp6_ % 2) == 0) {
#line 227 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp3_ = PLAYER_AI;
#line 1850 "ai.c"
	} else {
#line 227 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp3_ = PLAYER_HUMAN;
#line 1854 "ai.c"
	}
#line 227 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	move = _tmp3_;
#line 1858 "ai.c"
	{
		gint i = 0;
#line 229 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		i = 1;
#line 1863 "ai.c"
		{
			gboolean _tmp7_ = FALSE;
#line 229 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp7_ = TRUE;
#line 229 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 1870 "ai.c"
				gint _tmp9_ = 0;
				const gchar* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gint column = 0;
				const gchar* _tmp13_ = NULL;
				gint _tmp14_ = 0;
				gchar _tmp15_ = '\0';
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				gint row = 0;
				Player* _tmp28_ = NULL;
				gint _tmp28__length1 = 0;
				gint _tmp28__length2 = 0;
				gint _tmp29_ = 0;
				gint _tmp30_ = 0;
				Player _tmp31_ = 0;
				Player _tmp32_ = 0;
				Player _tmp33_ = 0;
				Player _tmp34_ = 0;
#line 229 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp7_) {
#line 1895 "ai.c"
					gint _tmp8_ = 0;
#line 229 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp8_ = i;
#line 229 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					i = _tmp8_ + 1;
#line 1901 "ai.c"
				}
#line 229 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp7_ = FALSE;
#line 229 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp9_ = i;
#line 229 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp10_ = vstr;
#line 229 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp11_ = strlen (_tmp10_);
#line 229 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp12_ = _tmp11_;
#line 229 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!(_tmp9_ < (_tmp12_ - 1))) {
#line 229 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 1917 "ai.c"
				}
#line 231 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp13_ = vstr;
#line 231 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp14_ = i;
#line 231 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp15_ = string_get (_tmp13_, (glong) _tmp14_);
#line 231 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp16_ = g_strdup_printf ("%c", _tmp15_);
#line 231 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp17_ = _tmp16_;
#line 231 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp18_ = atoi (_tmp17_);
#line 231 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp19_ = _tmp18_ - 1;
#line 231 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_g_free0 (_tmp17_);
#line 231 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				column = _tmp19_;
#line 1937 "ai.c"
				{
					gboolean _tmp20_ = FALSE;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					row = BOARD_ROWS - 1;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp20_ = TRUE;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					while (TRUE) {
#line 1946 "ai.c"
						gboolean _tmp22_ = FALSE;
						gint _tmp23_ = 0;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						if (!_tmp20_) {
#line 1951 "ai.c"
							gint _tmp21_ = 0;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp21_ = row;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							row = _tmp21_ - 1;
#line 1957 "ai.c"
						}
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						_tmp20_ = FALSE;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						_tmp23_ = row;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						if (_tmp23_ >= 0) {
#line 1965 "ai.c"
							Player* _tmp24_ = NULL;
							gint _tmp24__length1 = 0;
							gint _tmp24__length2 = 0;
							gint _tmp25_ = 0;
							gint _tmp26_ = 0;
							Player _tmp27_ = 0;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp24_ = self->priv->board;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp24__length1 = self->priv->board_length1;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp24__length2 = self->priv->board_length2;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp25_ = row;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp26_ = column;
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp27_ = _tmp24_[(_tmp25_ * _tmp24__length2) + _tmp26_];
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp22_ = _tmp27_ != PLAYER_NONE;
#line 1986 "ai.c"
						} else {
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp22_ = FALSE;
#line 1990 "ai.c"
						}
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						if (!_tmp22_) {
#line 235 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							break;
#line 1996 "ai.c"
						}
					}
				}
#line 237 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp28_ = self->priv->board;
#line 237 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp28__length1 = self->priv->board_length1;
#line 237 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp28__length2 = self->priv->board_length2;
#line 237 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp29_ = row;
#line 237 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp30_ = column;
#line 237 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp31_ = move;
#line 237 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp28_[(_tmp29_ * _tmp28__length2) + _tmp30_] = _tmp31_;
#line 237 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp32_ = _tmp28_[(_tmp29_ * _tmp28__length2) + _tmp30_];
#line 239 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp34_ = move;
#line 239 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (_tmp34_ == PLAYER_HUMAN) {
#line 239 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp33_ = PLAYER_AI;
#line 2022 "ai.c"
				} else {
#line 239 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp33_ = PLAYER_HUMAN;
#line 2026 "ai.c"
				}
#line 239 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				move = _tmp33_;
#line 2030 "ai.c"
			}
		}
	}
#line 242 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv->last_moving_player = PLAYER_HUMAN;
#line 2036 "ai.c"
}


static gint decision_tree_immediate_win (DecisionTree* self, Player p) {
	gint result = 0;
	Player old_last_moving_player = 0;
	Player _tmp0_ = 0;
	Player _tmp1_ = 0;
	Player _tmp2_ = 0;
	gboolean player_wins = FALSE;
	gint i = 0;
	Player _tmp12_ = 0;
	gint _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
#line 247 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 249 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp0_ = self->priv->last_moving_player;
#line 249 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	old_last_moving_player = _tmp0_;
#line 251 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp2_ = p;
#line 251 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp2_ == PLAYER_AI) {
#line 251 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp1_ = PLAYER_HUMAN;
#line 2063 "ai.c"
	} else {
#line 251 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp1_ = PLAYER_AI;
#line 2067 "ai.c"
	}
#line 251 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv->last_moving_player = _tmp1_;
#line 253 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	player_wins = FALSE;
#line 2073 "ai.c"
	{
		gboolean _tmp3_ = FALSE;
#line 255 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		i = 0;
#line 255 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp3_ = TRUE;
#line 255 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		while (TRUE) {
#line 2082 "ai.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gboolean _tmp7_ = FALSE;
			gint _tmp8_ = 0;
			gboolean _tmp9_ = FALSE;
			gint _tmp10_ = 0;
			gboolean _tmp11_ = FALSE;
#line 255 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			if (!_tmp3_) {
#line 2092 "ai.c"
				gint _tmp4_ = 0;
#line 255 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp4_ = i;
#line 255 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				i = _tmp4_ + 1;
#line 2098 "ai.c"
			}
#line 255 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp3_ = FALSE;
#line 255 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp5_ = i;
#line 255 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			if (!(_tmp5_ < BOARD_COLUMNS)) {
#line 255 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				break;
#line 2108 "ai.c"
			}
#line 257 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp6_ = i;
#line 257 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp7_ = decision_tree_move (self, _tmp6_);
#line 257 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			if (!_tmp7_) {
#line 258 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				continue;
#line 2118 "ai.c"
			}
#line 260 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp8_ = i;
#line 260 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp9_ = decision_tree_victory (self, _tmp8_);
#line 260 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			player_wins = _tmp9_;
#line 261 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp10_ = i;
#line 261 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			decision_tree_unmove (self, _tmp10_);
#line 263 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp11_ = player_wins;
#line 263 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			if (_tmp11_) {
#line 264 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				break;
#line 2136 "ai.c"
			}
		}
	}
#line 267 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp12_ = old_last_moving_player;
#line 267 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv->last_moving_player = _tmp12_;
#line 270 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp14_ = player_wins;
#line 270 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp14_) {
#line 2148 "ai.c"
		gint _tmp15_ = 0;
#line 270 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp15_ = i;
#line 270 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp13_ = _tmp15_;
#line 2154 "ai.c"
	} else {
#line 270 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp13_ = -1;
#line 2158 "ai.c"
	}
#line 270 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = _tmp13_;
#line 270 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 2164 "ai.c"
}


gint decision_tree_playgame (DecisionTree* self, const gchar* vstr) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint temp = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
#line 274 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 274 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (vstr != NULL, 0);
#line 277 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp0_ = vstr;
#line 277 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	decision_tree_set_level (self, _tmp0_);
#line 280 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp1_ = vstr;
#line 280 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	decision_tree_update_board (self, _tmp1_);
#line 284 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp2_ = decision_tree_immediate_win (self, PLAYER_AI);
#line 284 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	temp = _tmp2_;
#line 285 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp3_ = temp;
#line 285 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp3_ != -1) {
#line 2199 "ai.c"
		gint _tmp4_ = 0;
#line 286 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp4_ = temp;
#line 286 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		result = _tmp4_ + 1;
#line 286 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		return result;
#line 2207 "ai.c"
	}
#line 290 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp5_ = decision_tree_immediate_win (self, PLAYER_HUMAN);
#line 290 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	temp = _tmp5_;
#line 291 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp6_ = temp;
#line 291 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp6_ != -1) {
#line 2217 "ai.c"
		gint _tmp7_ = 0;
#line 292 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp7_ = temp;
#line 292 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		result = _tmp7_ + 1;
#line 292 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		return result;
#line 2225 "ai.c"
	}
#line 295 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp8_ = self->priv->plies;
#line 295 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	decision_tree_negamax (self, _tmp8_, NEG_INF, -1 * NEG_INF);
#line 298 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp9_ = self->priv->next_move_in_column;
#line 298 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = _tmp9_ + 1;
#line 298 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 2237 "ai.c"
}


static gint decision_tree_heurist (DecisionTree* self) {
	gint result = 0;
	Difficulty _tmp0_ = 0;
#line 302 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 304 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp0_ = self->priv->level;
#line 304 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp0_ == DIFFICULTY_EASY) {
#line 2250 "ai.c"
		gint _tmp1_ = 0;
#line 305 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp1_ = decision_tree_heurist_easy (self);
#line 305 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		result = _tmp1_;
#line 305 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		return result;
#line 2258 "ai.c"
	} else {
		Difficulty _tmp2_ = 0;
#line 306 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp2_ = self->priv->level;
#line 306 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		if (_tmp2_ == DIFFICULTY_MEDIUM) {
#line 2265 "ai.c"
			gint _tmp3_ = 0;
#line 307 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp3_ = decision_tree_heurist_medium (self);
#line 307 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			result = _tmp3_;
#line 307 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			return result;
#line 2273 "ai.c"
		} else {
			gint _tmp4_ = 0;
#line 309 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp4_ = decision_tree_heurist_hard (self);
#line 309 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			result = _tmp4_;
#line 309 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			return result;
#line 2282 "ai.c"
		}
	}
}


static gint decision_tree_heurist_easy (DecisionTree* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 312 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 314 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp0_ = decision_tree_heurist_hard (self);
#line 314 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = -1 * _tmp0_;
#line 314 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 2299 "ai.c"
}


static gint decision_tree_heurist_medium (DecisionTree* self) {
	gint result = 0;
	gint32 _tmp0_ = 0;
#line 317 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 319 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp0_ = g_random_int_range ((gint32) 1, (gint32) 49);
#line 319 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = (gint) _tmp0_;
#line 319 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 2314 "ai.c"
}


static gint decision_tree_heurist_hard (DecisionTree* self) {
	gint result = 0;
	gint count = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint32 _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 322 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 324 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp0_ = decision_tree_count_3_in_a_row (self, PLAYER_AI);
#line 324 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp1_ = decision_tree_count_3_in_a_row (self, PLAYER_HUMAN);
#line 324 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	count = _tmp0_ - _tmp1_;
#line 325 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp3_ = count;
#line 325 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp3_ == 0) {
#line 2337 "ai.c"
		gint32 _tmp4_ = 0;
#line 325 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp4_ = g_random_int_range ((gint32) 1, (gint32) 49);
#line 325 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp2_ = _tmp4_;
#line 2343 "ai.c"
	} else {
		gint _tmp5_ = 0;
#line 325 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp5_ = count;
#line 325 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp2_ = (gint32) (_tmp5_ * 100);
#line 2350 "ai.c"
	}
#line 325 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = (gint) _tmp2_;
#line 325 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 2356 "ai.c"
}


static gint decision_tree_count_3_in_a_row (DecisionTree* self, Player p) {
	gint result = 0;
	gint count = 0;
	Player old_last_moving_player = 0;
	Player _tmp0_ = 0;
	Player _tmp1_ = 0;
	Player _tmp27_ = 0;
#line 330 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 332 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	count = 0;
#line 334 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp0_ = self->priv->last_moving_player;
#line 334 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	old_last_moving_player = _tmp0_;
#line 336 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp1_ = p;
#line 336 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv->last_moving_player = _tmp1_;
#line 2379 "ai.c"
	{
		gint j = 0;
#line 338 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		j = 0;
#line 2384 "ai.c"
		{
			gboolean _tmp2_ = FALSE;
#line 338 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp2_ = TRUE;
#line 338 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 2391 "ai.c"
				gint _tmp4_ = 0;
#line 338 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp2_) {
#line 2395 "ai.c"
					gint _tmp3_ = 0;
#line 338 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp3_ = j;
#line 338 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					j = _tmp3_ + 1;
#line 2401 "ai.c"
				}
#line 338 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp2_ = FALSE;
#line 338 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp4_ = j;
#line 338 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!(_tmp4_ < BOARD_COLUMNS)) {
#line 338 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 2411 "ai.c"
				}
				{
					gint i = 0;
#line 340 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					i = 0;
#line 2417 "ai.c"
					{
						gboolean _tmp5_ = FALSE;
#line 340 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						_tmp5_ = TRUE;
#line 340 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						while (TRUE) {
#line 2424 "ai.c"
							gint _tmp7_ = 0;
							Player* _tmp8_ = NULL;
							gint _tmp8__length1 = 0;
							gint _tmp8__length2 = 0;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							Player _tmp11_ = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gboolean _tmp14_ = FALSE;
							Player* _tmp15_ = NULL;
							gint _tmp15__length1 = 0;
							gint _tmp15__length2 = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							Player _tmp18_ = 0;
							Player _tmp19_ = 0;
							gint _tmp20_ = 0;
							gboolean _tmp21_ = FALSE;
							Player* _tmp23_ = NULL;
							gint _tmp23__length1 = 0;
							gint _tmp23__length2 = 0;
							gint _tmp24_ = 0;
							gint _tmp25_ = 0;
							Player _tmp26_ = 0;
#line 340 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (!_tmp5_) {
#line 2452 "ai.c"
								gint _tmp6_ = 0;
#line 340 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp6_ = i;
#line 340 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								i = _tmp6_ + 1;
#line 2458 "ai.c"
							}
#line 340 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp5_ = FALSE;
#line 340 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp7_ = i;
#line 340 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (!(_tmp7_ < BOARD_ROWS)) {
#line 340 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								break;
#line 2468 "ai.c"
							}
#line 342 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp8_ = self->priv->board;
#line 342 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp8__length1 = self->priv->board_length1;
#line 342 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp8__length2 = self->priv->board_length2;
#line 342 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp9_ = i;
#line 342 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp10_ = j;
#line 342 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
#line 342 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (_tmp11_ != PLAYER_NONE) {
#line 343 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								break;
#line 2486 "ai.c"
							}
#line 345 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp12_ = i;
#line 345 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp13_ = j;
#line 345 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp14_ = decision_tree_all_adjacent_empty (self, _tmp12_, _tmp13_);
#line 345 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (_tmp14_) {
#line 346 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								continue;
#line 2498 "ai.c"
							}
#line 348 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp15_ = self->priv->board;
#line 348 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp15__length1 = self->priv->board_length1;
#line 348 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp15__length2 = self->priv->board_length2;
#line 348 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp16_ = i;
#line 348 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp17_ = j;
#line 348 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp18_ = p;
#line 348 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_] = _tmp18_;
#line 348 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp19_ = _tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_];
#line 350 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp20_ = j;
#line 350 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp21_ = decision_tree_victory (self, _tmp20_);
#line 350 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (_tmp21_) {
#line 2522 "ai.c"
								gint _tmp22_ = 0;
#line 351 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp22_ = count;
#line 351 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								count = _tmp22_ + 1;
#line 2528 "ai.c"
							}
#line 353 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp23_ = self->priv->board;
#line 353 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp23__length1 = self->priv->board_length1;
#line 353 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp23__length2 = self->priv->board_length2;
#line 353 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp24_ = i;
#line 353 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp25_ = j;
#line 353 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp23_[(_tmp24_ * _tmp23__length2) + _tmp25_] = PLAYER_NONE;
#line 353 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp26_ = _tmp23_[(_tmp24_ * _tmp23__length2) + _tmp25_];
#line 2544 "ai.c"
						}
					}
				}
			}
		}
	}
#line 356 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp27_ = old_last_moving_player;
#line 356 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv->last_moving_player = _tmp27_;
#line 357 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = count;
#line 357 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 2559 "ai.c"
}


static gboolean decision_tree_all_adjacent_empty (DecisionTree* self, gint i, gint j) {
	gboolean result = FALSE;
#line 361 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 2567 "ai.c"
	{
		gint k = 0;
#line 363 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		k = -1;
#line 2572 "ai.c"
		{
			gboolean _tmp0_ = FALSE;
#line 363 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			_tmp0_ = TRUE;
#line 363 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 2579 "ai.c"
				gint _tmp2_ = 0;
#line 363 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!_tmp0_) {
#line 2583 "ai.c"
					gint _tmp1_ = 0;
#line 363 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					_tmp1_ = k;
#line 363 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					k = _tmp1_ + 1;
#line 2589 "ai.c"
				}
#line 363 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp0_ = FALSE;
#line 363 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				_tmp2_ = k;
#line 363 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
				if (!(_tmp2_ <= 1)) {
#line 363 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					break;
#line 2599 "ai.c"
				}
				{
					gint l = 0;
#line 365 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
					l = -1;
#line 2605 "ai.c"
					{
						gboolean _tmp3_ = FALSE;
#line 365 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						_tmp3_ = TRUE;
#line 365 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
						while (TRUE) {
#line 2612 "ai.c"
							gint _tmp5_ = 0;
							gboolean _tmp6_ = FALSE;
							gint _tmp7_ = 0;
							gboolean _tmp9_ = FALSE;
							gboolean _tmp10_ = FALSE;
							gboolean _tmp11_ = FALSE;
							gboolean _tmp12_ = FALSE;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
#line 365 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (!_tmp3_) {
#line 2624 "ai.c"
								gint _tmp4_ = 0;
#line 365 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp4_ = l;
#line 365 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								l = _tmp4_ + 1;
#line 2630 "ai.c"
							}
#line 365 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp3_ = FALSE;
#line 365 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp5_ = l;
#line 365 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (!(_tmp5_ <= 1)) {
#line 365 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								break;
#line 2640 "ai.c"
							}
#line 367 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp7_ = k;
#line 367 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (_tmp7_ == 0) {
#line 2646 "ai.c"
								gint _tmp8_ = 0;
#line 367 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp8_ = l;
#line 367 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp6_ = _tmp8_ == 0;
#line 2652 "ai.c"
							} else {
#line 367 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp6_ = FALSE;
#line 2656 "ai.c"
							}
#line 367 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (_tmp6_) {
#line 368 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								continue;
#line 2662 "ai.c"
							}
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp13_ = i;
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							_tmp14_ = k;
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if ((_tmp13_ + _tmp14_) >= 0) {
#line 2670 "ai.c"
								gint _tmp15_ = 0;
								gint _tmp16_ = 0;
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp15_ = i;
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp16_ = k;
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp12_ = (_tmp15_ + _tmp16_) < BOARD_ROWS;
#line 2679 "ai.c"
							} else {
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp12_ = FALSE;
#line 2683 "ai.c"
							}
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (_tmp12_) {
#line 2687 "ai.c"
								gint _tmp17_ = 0;
								gint _tmp18_ = 0;
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp17_ = j;
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp18_ = l;
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp11_ = (_tmp17_ + _tmp18_) >= 0;
#line 2696 "ai.c"
							} else {
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp11_ = FALSE;
#line 2700 "ai.c"
							}
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (_tmp11_) {
#line 2704 "ai.c"
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp19_ = j;
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp20_ = l;
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp10_ = (_tmp19_ + _tmp20_) < BOARD_COLUMNS;
#line 2713 "ai.c"
							} else {
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp10_ = FALSE;
#line 2717 "ai.c"
							}
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (_tmp10_) {
#line 2721 "ai.c"
								Player* _tmp21_ = NULL;
								gint _tmp21__length1 = 0;
								gint _tmp21__length2 = 0;
								gint _tmp22_ = 0;
								gint _tmp23_ = 0;
								gint _tmp24_ = 0;
								gint _tmp25_ = 0;
								Player _tmp26_ = 0;
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp21_ = self->priv->board;
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp21__length1 = self->priv->board_length1;
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp21__length2 = self->priv->board_length2;
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp22_ = i;
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp23_ = k;
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp24_ = j;
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp25_ = l;
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp26_ = _tmp21_[((_tmp22_ + _tmp23_) * _tmp21__length2) + (_tmp24_ + _tmp25_)];
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp9_ = _tmp26_ != PLAYER_NONE;
#line 2748 "ai.c"
							} else {
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								_tmp9_ = FALSE;
#line 2752 "ai.c"
							}
#line 369 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
							if (_tmp9_) {
#line 370 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								result = FALSE;
#line 370 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
								return result;
#line 2760 "ai.c"
							}
						}
					}
				}
			}
		}
	}
#line 374 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = TRUE;
#line 374 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 2772 "ai.c"
}


static void decision_tree_set_level (DecisionTree* self, const gchar* vstr) {
	const gchar* _tmp0_ = NULL;
	gchar _tmp1_ = '\0';
#line 378 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_if_fail (self != NULL);
#line 378 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_if_fail (vstr != NULL);
#line 380 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp0_ = vstr;
#line 380 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp1_ = string_get (_tmp0_, (glong) 0);
#line 380 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp1_ == 'a') {
#line 382 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		self->priv->level = DIFFICULTY_EASY;
#line 383 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		self->priv->plies = 4;
#line 2793 "ai.c"
	} else {
		const gchar* _tmp2_ = NULL;
		gchar _tmp3_ = '\0';
#line 385 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp2_ = vstr;
#line 385 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp3_ = string_get (_tmp2_, (glong) 0);
#line 385 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		if (_tmp3_ == 'b') {
#line 387 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			self->priv->level = DIFFICULTY_MEDIUM;
#line 388 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			self->priv->plies = 7;
#line 2807 "ai.c"
		} else {
#line 392 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			self->priv->level = DIFFICULTY_HARD;
#line 393 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			self->priv->plies = 7;
#line 2813 "ai.c"
		}
	}
}


gint decision_tree_playandcheck (DecisionTree* self, const gchar* vstr) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint temp = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
#line 398 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 398 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (vstr != NULL, 0);
#line 400 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp0_ = vstr;
#line 400 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	decision_tree_set_level (self, _tmp0_);
#line 401 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp1_ = vstr;
#line 401 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	decision_tree_update_board (self, _tmp1_);
#line 403 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp2_ = decision_tree_immediate_win (self, PLAYER_AI);
#line 403 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	temp = _tmp2_;
#line 404 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp3_ = temp;
#line 404 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp3_ != -1) {
#line 405 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		result = 1000;
#line 405 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		return result;
#line 2854 "ai.c"
	}
#line 407 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp4_ = decision_tree_immediate_win (self, PLAYER_HUMAN);
#line 407 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	temp = _tmp4_;
#line 408 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp5_ = temp;
#line 408 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (_tmp5_ != -1) {
#line 2864 "ai.c"
		gint _tmp6_ = 0;
#line 409 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		_tmp6_ = temp;
#line 409 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		result = _tmp6_ + 1;
#line 409 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		return result;
#line 2872 "ai.c"
	}
#line 411 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp7_ = self->priv->plies;
#line 411 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	decision_tree_negamax (self, _tmp7_, NEG_INF, -1 * NEG_INF);
#line 413 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp8_ = self->priv->next_move_in_column;
#line 413 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	result = _tmp8_ + 1;
#line 413 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return result;
#line 2884 "ai.c"
}


static void value_decision_tree_init (GValue* value) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	value->data[0].v_pointer = NULL;
#line 2891 "ai.c"
}


static void value_decision_tree_free_value (GValue* value) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (value->data[0].v_pointer) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		decision_tree_unref (value->data[0].v_pointer);
#line 2900 "ai.c"
	}
}


static void value_decision_tree_copy_value (const GValue* src_value, GValue* dest_value) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (src_value->data[0].v_pointer) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		dest_value->data[0].v_pointer = decision_tree_ref (src_value->data[0].v_pointer);
#line 2910 "ai.c"
	} else {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2914 "ai.c"
	}
}


static gpointer value_decision_tree_peek_pointer (const GValue* value) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return value->data[0].v_pointer;
#line 2922 "ai.c"
}


static gchar* value_decision_tree_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (collect_values[0].v_pointer) {
#line 2929 "ai.c"
		DecisionTree* object;
		object = collect_values[0].v_pointer;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		if (object->parent_instance.g_class == NULL) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2936 "ai.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2940 "ai.c"
		}
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		value->data[0].v_pointer = decision_tree_ref (object);
#line 2944 "ai.c"
	} else {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		value->data[0].v_pointer = NULL;
#line 2948 "ai.c"
	}
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return NULL;
#line 2952 "ai.c"
}


static gchar* value_decision_tree_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DecisionTree** object_p;
	object_p = collect_values[0].v_pointer;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (!object_p) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2963 "ai.c"
	}
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (!value->data[0].v_pointer) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		*object_p = NULL;
#line 2969 "ai.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		*object_p = value->data[0].v_pointer;
#line 2973 "ai.c"
	} else {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		*object_p = decision_tree_ref (value->data[0].v_pointer);
#line 2977 "ai.c"
	}
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return NULL;
#line 2981 "ai.c"
}


GParamSpec* param_spec_decision_tree (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecDecisionTree* spec;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DECISION_TREE), NULL);
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return G_PARAM_SPEC (spec);
#line 2995 "ai.c"
}


gpointer value_get_decision_tree (const GValue* value) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DECISION_TREE), NULL);
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return value->data[0].v_pointer;
#line 3004 "ai.c"
}


void value_set_decision_tree (GValue* value, gpointer v_object) {
	DecisionTree* old;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DECISION_TREE));
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	old = value->data[0].v_pointer;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (v_object) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DECISION_TREE));
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		value->data[0].v_pointer = v_object;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		decision_tree_ref (value->data[0].v_pointer);
#line 3024 "ai.c"
	} else {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		value->data[0].v_pointer = NULL;
#line 3028 "ai.c"
	}
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (old) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		decision_tree_unref (old);
#line 3034 "ai.c"
	}
}


void value_take_decision_tree (GValue* value, gpointer v_object) {
	DecisionTree* old;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DECISION_TREE));
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	old = value->data[0].v_pointer;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (v_object) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DECISION_TREE));
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		value->data[0].v_pointer = v_object;
#line 3053 "ai.c"
	} else {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		value->data[0].v_pointer = NULL;
#line 3057 "ai.c"
	}
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (old) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		decision_tree_unref (old);
#line 3063 "ai.c"
	}
}


static void decision_tree_class_init (DecisionTreeClass * klass) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	decision_tree_parent_class = g_type_class_peek_parent (klass);
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	((DecisionTreeClass *) klass)->finalize = decision_tree_finalize;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_type_class_add_private (klass, sizeof (DecisionTreePrivate));
#line 3075 "ai.c"
}


static void decision_tree_instance_init (DecisionTree * self) {
	Player* _tmp0_ = NULL;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv = DECISION_TREE_GET_PRIVATE (self);
#line 41 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	_tmp0_ = g_new0 (Player, BOARD_ROWS * BOARD_COLUMNS);
#line 41 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv->board = _tmp0_;
#line 41 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv->board_length1 = BOARD_ROWS;
#line 41 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv->board_length2 = BOARD_COLUMNS;
#line 43 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv->plies = 8;
#line 45 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv->last_moving_player = PLAYER_NONE;
#line 47 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv->next_move_in_column = -1;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->ref_count = 1;
#line 3099 "ai.c"
}


static void decision_tree_finalize (DecisionTree* obj) {
	DecisionTree * self;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DECISION_TREE, DecisionTree);
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_signal_handlers_destroy (self);
#line 41 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	self->priv->board = (g_free (self->priv->board), NULL);
#line 3111 "ai.c"
}


GType decision_tree_get_type (void) {
	static volatile gsize decision_tree_type_id__volatile = 0;
	if (g_once_init_enter (&decision_tree_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_decision_tree_init, value_decision_tree_free_value, value_decision_tree_copy_value, value_decision_tree_peek_pointer, "p", value_decision_tree_collect_value, "p", value_decision_tree_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DecisionTreeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) decision_tree_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DecisionTree), 0, (GInstanceInitFunc) decision_tree_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType decision_tree_type_id;
		decision_tree_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DecisionTree", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&decision_tree_type_id__volatile, decision_tree_type_id);
	}
	return decision_tree_type_id__volatile;
}


gpointer decision_tree_ref (gpointer instance) {
	DecisionTree* self;
	self = instance;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	g_atomic_int_inc (&self->ref_count);
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	return instance;
#line 3136 "ai.c"
}


void decision_tree_unref (gpointer instance) {
	DecisionTree* self;
	self = instance;
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		DECISION_TREE_GET_CLASS (self)->finalize (self);
#line 38 "/home/mcatanzaro/jhbuild/checkout/four-in-a-row/src/ai.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3149 "ai.c"
	}
}



