/* iagno.c generated by valac 0.30.0, the Vala compiler
 * generated from iagno.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This file is part of Iagno.
 *
 * Iagno is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Iagno is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Iagno. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <canberra-gtk.h>
#include <canberra.h>


#define TYPE_IAGNO (iagno_get_type ())
#define IAGNO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IAGNO, Iagno))
#define IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IAGNO, IagnoClass))
#define IS_IAGNO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IAGNO))
#define IS_IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IAGNO))
#define IAGNO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IAGNO, IagnoClass))

typedef struct _Iagno Iagno;
typedef struct _IagnoClass IagnoClass;
typedef struct _IagnoPrivate IagnoPrivate;

#define TYPE_GAME_WINDOW (game_window_get_type ())
#define GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_WINDOW, GameWindow))
#define GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_WINDOW, GameWindowClass))
#define IS_GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_WINDOW))
#define IS_GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_WINDOW))
#define GAME_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_WINDOW, GameWindowClass))

typedef struct _GameWindow GameWindow;
typedef struct _GameWindowClass GameWindowClass;

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;

#define TYPE_THEMES_DIALOG (themes_dialog_get_type ())
#define THEMES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEMES_DIALOG, ThemesDialog))
#define THEMES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEMES_DIALOG, ThemesDialogClass))
#define IS_THEMES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEMES_DIALOG))
#define IS_THEMES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEMES_DIALOG))
#define THEMES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEMES_DIALOG, ThemesDialogClass))

typedef struct _ThemesDialog ThemesDialog;
typedef struct _ThemesDialogClass ThemesDialogClass;

#define TYPE_COMPUTER_PLAYER (computer_player_get_type ())
#define COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayer))
#define COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))
#define IS_COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_PLAYER))
#define IS_COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_PLAYER))
#define COMPUTER_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))

typedef struct _ComputerPlayer ComputerPlayer;
typedef struct _ComputerPlayerClass ComputerPlayerClass;

#define TYPE_PLAYER (player_get_type ())

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define IAGNO_TYPE_SOUND (iagno_sound_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
typedef struct _Block3Data Block3Data;

#define TYPE_GAME_WINDOW_FLAGS (game_window_flags_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GameWindowPrivate GameWindowPrivate;

struct _Iagno {
	GtkApplication parent_instance;
	IagnoPrivate * priv;
};

struct _IagnoClass {
	GtkApplicationClass parent_class;
};

typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;

struct _IagnoPrivate {
	GSettings* settings;
	GameWindow* window;
	GameView* view;
	GtkLabel* dark_score_label;
	GtkLabel* light_score_label;
	ThemesDialog* themes_dialog;
	ComputerPlayer* computer;
	Player player_one;
	Game* game;
};

typedef enum  {
	IAGNO_SOUND_FLIP,
	IAGNO_SOUND_GAMEOVER
} IagnoSound;

struct _Block3Data {
	int _ref_count_;
	Iagno* self;
	GtkBox* level_box;
	GtkBox* color_box;
};

typedef enum  {
	GAME_WINDOW_FLAGS_SHOW_UNDO = 1 << 0,
	GAME_WINDOW_FLAGS_SHOW_REDO = 1 << 1,
	GAME_WINDOW_FLAGS_SHOW_HINT = 1 << 2,
	GAME_WINDOW_FLAGS_SHOW_START_BUTTON = 1 << 3
} GameWindowFlags;

struct _GameWindow {
	GtkApplicationWindow parent_instance;
	GameWindowPrivate * priv;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
};

struct _GameWindowClass {
	GtkApplicationWindowClass parent_class;
};


static gpointer iagno_parent_class = NULL;
static gboolean iagno_fast_mode;
static gboolean iagno_fast_mode = FALSE;
static gboolean iagno_alternative_start;
static gboolean iagno_alternative_start = FALSE;
static gchar* iagno_level;
static gchar* iagno_level = NULL;
static gint iagno_size;
static gint iagno_size = 8;
static gboolean* iagno_sound;
static gboolean* iagno_sound = NULL;
static gboolean iagno_two_players;
static gboolean iagno_two_players = FALSE;
static gboolean* iagno_play_first;
static gboolean* iagno_play_first = NULL;

GType iagno_get_type (void) G_GNUC_CONST;
GType game_window_get_type (void) G_GNUC_CONST;
GType game_view_get_type (void) G_GNUC_CONST;
GType themes_dialog_get_type (void) G_GNUC_CONST;
GType computer_player_get_type (void) G_GNUC_CONST;
GType player_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define IAGNO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_IAGNO, IagnoPrivate))
enum  {
	IAGNO_DUMMY_PROPERTY
};
static GType iagno_sound_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define IAGNO_QUICK_MOVE_DELAY 0.4
#define IAGNO_MODERATE_MOVE_DELAY 1.7
#define IAGNO_SLOW_MOVE_DELAY 2.0
static void iagno_theme_cb (Iagno* self);
static void _iagno_theme_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_help_cb (Iagno* self);
static void _iagno_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_about_cb (Iagno* self);
static void _iagno_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
gint iagno_main (gchar** args, int args_length1);
static Iagno* iagno_new (void);
static Iagno* iagno_construct (GType object_type);
static gint iagno_real_handle_local_options (GApplication* base, GVariantDict* options);
static gboolean* _bool_dup (gboolean* self);
static void iagno_real_startup (GApplication* base);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
static void iagno_player_move_cb (Iagno* self, gint x, gint y);
static void _iagno_player_move_cb_game_view_move (GameView* _sender, gint x, gint y, gpointer self);
void game_view_set_scoreboard (GameView* self, GtkDrawingArea* value);
void game_view_set_theme (GameView* self, const gchar* value);
GType game_window_flags_get_type (void) G_GNUC_CONST;
GameWindow* game_window_new (const gchar* css_resource, const gchar* name, gint width, gint height, gboolean maximized, gboolean start_now, GameWindowFlags flags, GtkBox* new_game_screen, GtkWidget* _view);
GameWindow* game_window_construct (GType object_type, const gchar* css_resource, const gchar* name, gint width, gint height, gboolean maximized, gboolean start_now, GameWindowFlags flags, GtkBox* new_game_screen, GtkWidget* _view);
void game_window_add_to_sidebox (GameWindow* self, GtkWidget* widget);
static void iagno_start_game (Iagno* self);
static void _iagno_start_game_game_window_play (GameWindow* _sender, gpointer self);
static void iagno_wait_cb (Iagno* self);
static void _iagno_wait_cb_game_window_wait (GameWindow* _sender, gpointer self);
static void iagno_back_cb (Iagno* self);
static void _iagno_back_cb_game_window_back (GameWindow* _sender, gpointer self);
static void iagno_undo_cb (Iagno* self);
static void _iagno_undo_cb_game_window_undo (GameWindow* _sender, gpointer self);
static void __lambda8_ (Block3Data* _data3_);
static void ___lambda8__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void iagno_real_activate (GApplication* base);
static void iagno_real_shutdown (GApplication* base);
void game_window_shutdown (GameWindow* self, GSettings* settings);
ThemesDialog* themes_dialog_new (GSettings* settings, GameView* view);
ThemesDialog* themes_dialog_construct (GType object_type, GSettings* settings, GameView* view);
Player game_get_current_color (Game* self);
gboolean game_get_is_complete (Game* self);
void computer_player_move_async (ComputerPlayer* self, gdouble delay_seconds, GAsyncReadyCallback _callback_, gpointer _user_data_);
void computer_player_move_finish (ComputerPlayer* self, GAsyncResult* _res_);
static void iagno_game_complete (Iagno* self, gboolean play_gameover_sound);
void computer_player_cancel_move (ComputerPlayer* self);
Game* game_new (gboolean alternative_start, gint tmp_size);
Game* game_construct (GType object_type, gboolean alternative_start, gint tmp_size);
static void iagno_turn_ended_cb (Iagno* self);
static void _iagno_turn_ended_cb_game_turn_ended (Game* _sender, gpointer self);
void game_view_set_game (GameView* self, Game* value);
ComputerPlayer* computer_player_new (Game* game, gint difficulty_level);
ComputerPlayer* computer_player_construct (GType object_type, Game* game, gint difficulty_level);
static void iagno_update_ui (Iagno* self);
void game_window_set_subtitle (GameWindow* self, const gchar* subtitle);
gint game_get_number_of_moves (Game* self);
gint game_get_n_dark_tiles (Game* self);
gint game_get_n_light_tiles (Game* self);
void game_undo (Game* self, gint count);
gboolean game_get_current_player_can_move (Game* self);
static void iagno_play_sound (Iagno* self, IagnoSound sound);
void game_view_update_scoreboard (GameView* self);
static void iagno_prepare_move (Iagno* self);
static void iagno_pass (Iagno* self);
void game_pass (Game* self);
void game_window_finish_game (GameWindow* self);
gint game_place_tile (Game* self, gint x, gint y, gboolean apply);
const gchar* game_view_get_sound_flip (GameView* self);
const gchar* game_view_get_sound_gameover (GameView* self);
static void iagno_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry IAGNO_option_entries[11] = {{"alternative-start", (gchar) 0, 0, G_OPTION_ARG_NONE, &iagno_alternative_start, "Start with an alternative position", NULL}, {"fast-mode", 'f', 0, G_OPTION_ARG_NONE, &iagno_fast_mode, "Reduce delay before AI moves", NULL}, {"first", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Play first", NULL}, {"level", 'l', 0, G_OPTION_ARG_STRING, &iagno_level, "Set the level of the computer's AI", "LEVEL"}, {"mute", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Turn off the sound", NULL}, {"second", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Play second", NULL}, {"size", 's', 0, G_OPTION_ARG_INT, &iagno_size, "Size of the board (debug only)", "SIZE"}, {"two-players", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Two-players mode", NULL}, {"unmute", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Turn on the sound", NULL}, {"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Print release version and exit", NULL}, {NULL}};
static const GActionEntry IAGNO_app_actions[4] = {{"theme", _iagno_theme_cb_gsimple_action_activate_callback}, {"help", _iagno_help_cb_gsimple_action_activate_callback}, {"about", _iagno_about_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};

static GType iagno_sound_get_type (void) {
	static volatile gsize iagno_sound_type_id__volatile = 0;
	if (g_once_init_enter (&iagno_sound_type_id__volatile)) {
		static const GEnumValue values[] = {{IAGNO_SOUND_FLIP, "IAGNO_SOUND_FLIP", "flip"}, {IAGNO_SOUND_GAMEOVER, "IAGNO_SOUND_GAMEOVER", "gameover"}, {0, NULL, NULL}};
		GType iagno_sound_type_id;
		iagno_sound_type_id = g_enum_register_static ("IagnoSound", values);
		g_once_init_leave (&iagno_sound_type_id__volatile, iagno_sound_type_id);
	}
	return iagno_sound_type_id__volatile;
}


static void _iagno_theme_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_theme_cb ((Iagno*) self);
#line 292 "iagno.c"
}


static void _iagno_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_help_cb ((Iagno*) self);
#line 299 "iagno.c"
}


static void _iagno_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_about_cb ((Iagno*) self);
#line 306 "iagno.c"
}


static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_application_quit ((GApplication*) self);
#line 313 "iagno.c"
}


gint iagno_main (gchar** args, int args_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	Iagno* _tmp1_ = NULL;
	Iagno* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 81 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	setlocale (LC_ALL, "");
#line 82 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 83 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 84 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	textdomain (GETTEXT_PACKAGE);
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = _ ("Iagno");
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_set_application_name (_tmp0_);
#line 87 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_window_set_default_icon_name ("iagno");
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = iagno_new ();
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = _tmp1_;
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = args;
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3__length1 = args_length1;
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = g_application_run ((GApplication*) _tmp2_, _tmp3__length1, _tmp3_);
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = _tmp4_;
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (_tmp2_);
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	result = _tmp5_;
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return result;
#line 358 "iagno.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 79 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return iagno_main (argv, argc);
#line 368 "iagno.c"
}


static Iagno* iagno_construct (GType object_type) {
	Iagno * self = NULL;
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = (Iagno*) g_object_new (object_type, "application-id", "org.gnome.iagno", "flags", G_APPLICATION_FLAGS_NONE, NULL);
#line 96 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_application_add_main_option_entries ((GApplication*) self, IAGNO_option_entries);
#line 92 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return self;
#line 380 "iagno.c"
}


static Iagno* iagno_new (void) {
#line 92 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return iagno_construct (TYPE_IAGNO);
#line 387 "iagno.c"
}


static gboolean* _bool_dup (gboolean* self) {
	gboolean* dup;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	dup = g_new0 (gboolean, 1);
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	memcpy (dup, self, sizeof (gboolean));
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return dup;
#line 399 "iagno.c"
}


static gpointer __bool_dup0 (gpointer self) {
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return self ? _bool_dup (self) : NULL;
#line 406 "iagno.c"
}


static gint iagno_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Iagno * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gint _tmp3_ = 0;
	GVariantDict* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GVariantDict* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
#line 99 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = (Iagno*) base;
#line 99 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_val_if_fail (options != NULL, 0);
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = options;
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
#line 101 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp1_) {
#line 430 "iagno.c"
		FILE* _tmp2_ = NULL;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp2_ = stdout;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		fprintf (_tmp2_, "%1$s %2$s\n", "iagno", VERSION);
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		result = EXIT_SUCCESS;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		return result;
#line 440 "iagno.c"
	}
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = iagno_size;
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp3_ < 4) {
#line 446 "iagno.c"
		FILE* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp4_ = stderr;
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp5_ = _ ("Size must be at least 4.");
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		fprintf (_tmp4_, "%s\n", _tmp5_);
#line 112 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		result = EXIT_FAILURE;
#line 112 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		return result;
#line 459 "iagno.c"
	}
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp6_ = options;
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp7_ = g_variant_dict_contains (_tmp6_, "mute");
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp7_) {
#line 467 "iagno.c"
		gboolean _tmp8_ = FALSE;
		gboolean* _tmp9_ = NULL;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = FALSE;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp9_ = __bool_dup0 (&_tmp8_);
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_free0 (iagno_sound);
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_sound = _tmp9_;
#line 478 "iagno.c"
	} else {
		GVariantDict* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp10_ = options;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp11_ = g_variant_dict_contains (_tmp10_, "unmute");
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp11_) {
#line 488 "iagno.c"
			gboolean _tmp12_ = FALSE;
			gboolean* _tmp13_ = NULL;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp12_ = TRUE;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp13_ = __bool_dup0 (&_tmp12_);
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_g_free0 (iagno_sound);
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			iagno_sound = _tmp13_;
#line 499 "iagno.c"
		}
	}
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp14_ = options;
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp15_ = g_variant_dict_contains (_tmp14_, "two-players");
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp15_) {
#line 121 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_two_players = TRUE;
#line 510 "iagno.c"
	} else {
		GVariantDict* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp16_ = options;
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp17_ = g_variant_dict_contains (_tmp16_, "first");
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp17_) {
#line 520 "iagno.c"
			gboolean _tmp18_ = FALSE;
			gboolean* _tmp19_ = NULL;
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp18_ = TRUE;
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp19_ = __bool_dup0 (&_tmp18_);
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_g_free0 (iagno_play_first);
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			iagno_play_first = _tmp19_;
#line 531 "iagno.c"
		} else {
			GVariantDict* _tmp20_ = NULL;
			gboolean _tmp21_ = FALSE;
#line 124 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp20_ = options;
#line 124 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp21_ = g_variant_dict_contains (_tmp20_, "second");
#line 124 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			if (_tmp21_) {
#line 541 "iagno.c"
				gboolean _tmp22_ = FALSE;
				gboolean* _tmp23_ = NULL;
#line 125 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				_tmp22_ = FALSE;
#line 125 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				_tmp23_ = __bool_dup0 (&_tmp22_);
#line 125 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				_g_free0 (iagno_play_first);
#line 125 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				iagno_play_first = _tmp23_;
#line 552 "iagno.c"
			}
		}
	}
#line 128 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	result = -1;
#line 128 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return result;
#line 560 "iagno.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return _data3_;
#line 569 "iagno.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 578 "iagno.c"
		Iagno* self;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		self = _data3_->self;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_object_unref0 (_data3_->color_box);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_object_unref0 (_data3_->level_box);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_object_unref0 (self);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_slice_free (Block3Data, _data3_);
#line 590 "iagno.c"
	}
}


static void _iagno_player_move_cb_game_view_move (GameView* _sender, gint x, gint y, gpointer self) {
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_player_move_cb ((Iagno*) self, x, y);
#line 598 "iagno.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return self ? g_object_ref (self) : NULL;
#line 605 "iagno.c"
}


static void _iagno_start_game_game_window_play (GameWindow* _sender, gpointer self) {
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_start_game ((Iagno*) self);
#line 612 "iagno.c"
}


static void _iagno_wait_cb_game_window_wait (GameWindow* _sender, gpointer self) {
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_wait_cb ((Iagno*) self);
#line 619 "iagno.c"
}


static void _iagno_back_cb_game_window_back (GameWindow* _sender, gpointer self) {
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_back_cb ((Iagno*) self);
#line 626 "iagno.c"
}


static void _iagno_undo_cb_game_window_undo (GameWindow* _sender, gpointer self) {
#line 188 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_undo_cb ((Iagno*) self);
#line 633 "iagno.c"
}


static void __lambda8_ (Block3Data* _data3_) {
	Iagno* self;
	gboolean solo = FALSE;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GtkBox* _tmp2_ = NULL;
	GtkBox* _tmp3_ = NULL;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = _data3_->self;
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->settings;
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = g_settings_get_int (_tmp0_, "num-players");
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	solo = _tmp1_ == 1;
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = _data3_->level_box;
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, solo);
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = _data3_->color_box;
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, solo);
#line 660 "iagno.c"
}


static void ___lambda8__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	__lambda8_ (self);
#line 667 "iagno.c"
}


static void iagno_real_startup (GApplication* base) {
	Iagno * self;
	Block3Data* _data3_;
	GSettings* _tmp0_ = NULL;
	gboolean* _tmp1_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean start_now = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean* _tmp11_ = NULL;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	const gchar* _tmp17_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp32_ = NULL;
	GameView* _tmp33_ = NULL;
	GameView* _tmp34_ = NULL;
	GtkDrawingArea* scoredrawing = NULL;
	GtkBuilder* _tmp35_ = NULL;
	GObject* _tmp36_ = NULL;
	GtkDrawingArea* _tmp37_ = NULL;
	GameView* _tmp38_ = NULL;
	GtkDrawingArea* _tmp39_ = NULL;
	GameView* _tmp40_ = NULL;
	GSettings* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	GSettings* _tmp45_ = NULL;
	gint _tmp46_ = 0;
	GSettings* _tmp47_ = NULL;
	gint _tmp48_ = 0;
	GSettings* _tmp49_ = NULL;
	gboolean _tmp50_ = FALSE;
	gboolean _tmp51_ = FALSE;
	GtkBuilder* _tmp52_ = NULL;
	GObject* _tmp53_ = NULL;
	GameView* _tmp54_ = NULL;
	GameWindow* _tmp55_ = NULL;
	GtkWidget* scoregrid = NULL;
	GtkBuilder* _tmp56_ = NULL;
	GObject* _tmp57_ = NULL;
	GtkWidget* _tmp58_ = NULL;
	GameWindow* _tmp59_ = NULL;
	GtkWidget* _tmp60_ = NULL;
	GameWindow* _tmp61_ = NULL;
	GameWindow* _tmp62_ = NULL;
	GameWindow* _tmp63_ = NULL;
	GameWindow* _tmp64_ = NULL;
	gchar* _tmp65_ = NULL;
	gchar** _tmp66_ = NULL;
	gchar** _tmp67_ = NULL;
	gint _tmp67__length1 = 0;
	gchar* _tmp68_ = NULL;
	gchar** _tmp69_ = NULL;
	gchar** _tmp70_ = NULL;
	gint _tmp70__length1 = 0;
	gchar* _tmp71_ = NULL;
	gchar** _tmp72_ = NULL;
	gchar** _tmp73_ = NULL;
	gint _tmp73__length1 = 0;
	gchar* _tmp74_ = NULL;
	gchar** _tmp75_ = NULL;
	gchar** _tmp76_ = NULL;
	gint _tmp76__length1 = 0;
	gchar* _tmp77_ = NULL;
	gchar** _tmp78_ = NULL;
	gchar** _tmp79_ = NULL;
	gint _tmp79__length1 = 0;
	GSettings* _tmp80_ = NULL;
	GAction* _tmp81_ = NULL;
	GAction* _tmp82_ = NULL;
	GSettings* _tmp83_ = NULL;
	GAction* _tmp84_ = NULL;
	GAction* _tmp85_ = NULL;
	GSettings* _tmp86_ = NULL;
	GAction* _tmp87_ = NULL;
	GAction* _tmp88_ = NULL;
	GSettings* _tmp89_ = NULL;
	GAction* _tmp90_ = NULL;
	GAction* _tmp91_ = NULL;
	GtkBuilder* _tmp92_ = NULL;
	GObject* _tmp93_ = NULL;
	GtkBox* _tmp94_ = NULL;
	GtkBuilder* _tmp95_ = NULL;
	GObject* _tmp96_ = NULL;
	GtkBox* _tmp97_ = NULL;
	GSettings* _tmp98_ = NULL;
	gboolean solo = FALSE;
	GSettings* _tmp99_ = NULL;
	gint _tmp100_ = 0;
	GtkBox* _tmp101_ = NULL;
	gboolean _tmp102_ = FALSE;
	GtkBox* _tmp103_ = NULL;
	gboolean _tmp104_ = FALSE;
	GtkBuilder* _tmp105_ = NULL;
	GObject* _tmp106_ = NULL;
	GtkLabel* _tmp107_ = NULL;
	GtkBuilder* _tmp108_ = NULL;
	GObject* _tmp109_ = NULL;
	GtkLabel* _tmp110_ = NULL;
	gboolean _tmp111_ = FALSE;
	GameWindow* _tmp112_ = NULL;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = (Iagno*) base;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_data3_->_ref_count_ = 1;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_data3_->self = g_object_ref (self);
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	G_APPLICATION_CLASS (iagno_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = g_settings_new ("org.gnome.iagno");
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->settings);
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->settings = _tmp0_;
#line 138 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = iagno_sound;
#line 138 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp1_ != NULL) {
#line 794 "iagno.c"
		GSettings* _tmp2_ = NULL;
		gboolean* _tmp3_ = NULL;
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp2_ = self->priv->settings;
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = iagno_sound;
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_settings_set_boolean (_tmp2_, "sound", *_tmp3_);
#line 803 "iagno.c"
	}
#line 141 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = iagno_two_players;
#line 141 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp5_ == TRUE) {
#line 141 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp4_ = TRUE;
#line 811 "iagno.c"
	} else {
		gboolean* _tmp6_ = NULL;
#line 141 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp6_ = iagno_play_first;
#line 141 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp4_ = _tmp6_ != NULL;
#line 818 "iagno.c"
	}
#line 141 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	start_now = _tmp4_;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp7_ = start_now;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp7_) {
#line 826 "iagno.c"
		gint _tmp8_ = 0;
		gboolean _tmp9_ = FALSE;
		GSettings* _tmp10_ = NULL;
#line 143 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp9_ = iagno_two_players;
#line 143 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp9_) {
#line 143 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp8_ = 2;
#line 836 "iagno.c"
		} else {
#line 143 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp8_ = 1;
#line 840 "iagno.c"
		}
#line 143 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp10_ = self->priv->settings;
#line 143 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_settings_set_int (_tmp10_, "num-players", _tmp8_);
#line 846 "iagno.c"
	}
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp11_ = iagno_play_first;
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp11_ != NULL) {
#line 852 "iagno.c"
		const gchar* _tmp12_ = NULL;
		gboolean* _tmp13_ = NULL;
		GSettings* _tmp14_ = NULL;
#line 146 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp13_ = iagno_play_first;
#line 146 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (*_tmp13_) {
#line 146 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp12_ = "dark";
#line 862 "iagno.c"
		} else {
#line 146 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp12_ = "light";
#line 866 "iagno.c"
		}
#line 146 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp14_ = self->priv->settings;
#line 146 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_settings_set_string (_tmp14_, "color", _tmp12_);
#line 872 "iagno.c"
	}
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp17_ = iagno_level;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (g_strcmp0 (_tmp17_, "1") == 0) {
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp16_ = TRUE;
#line 880 "iagno.c"
	} else {
		const gchar* _tmp18_ = NULL;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp18_ = iagno_level;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp16_ = g_strcmp0 (_tmp18_, "2") == 0;
#line 887 "iagno.c"
	}
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp16_) {
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp15_ = TRUE;
#line 893 "iagno.c"
	} else {
		const gchar* _tmp19_ = NULL;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp19_ = iagno_level;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp15_ = g_strcmp0 (_tmp19_, "3") == 0;
#line 900 "iagno.c"
	}
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp15_) {
#line 904 "iagno.c"
		GSettings* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		gint _tmp22_ = 0;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp20_ = self->priv->settings;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp21_ = iagno_level;
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp22_ = atoi (_tmp21_);
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_settings_set_int (_tmp20_, "computer-level", _tmp22_);
#line 916 "iagno.c"
	} else {
		const gchar* _tmp23_ = NULL;
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp23_ = iagno_level;
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (g_strcmp0 (_tmp23_, "one") == 0) {
#line 923 "iagno.c"
			GSettings* _tmp24_ = NULL;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp24_ = self->priv->settings;
#line 152 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			g_settings_set_int (_tmp24_, "computer-level", 1);
#line 929 "iagno.c"
		} else {
			const gchar* _tmp25_ = NULL;
#line 153 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp25_ = iagno_level;
#line 153 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			if (g_strcmp0 (_tmp25_, "two") == 0) {
#line 936 "iagno.c"
				GSettings* _tmp26_ = NULL;
#line 154 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				_tmp26_ = self->priv->settings;
#line 154 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				g_settings_set_int (_tmp26_, "computer-level", 2);
#line 942 "iagno.c"
			} else {
				const gchar* _tmp27_ = NULL;
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				_tmp27_ = iagno_level;
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				if (g_strcmp0 (_tmp27_, "three") == 0) {
#line 949 "iagno.c"
					GSettings* _tmp28_ = NULL;
#line 156 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
					_tmp28_ = self->priv->settings;
#line 156 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
					g_settings_set_int (_tmp28_, "computer-level", 3);
#line 955 "iagno.c"
				} else {
					const gchar* _tmp29_ = NULL;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
					_tmp29_ = iagno_level;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
					if (_tmp29_ != NULL) {
#line 962 "iagno.c"
						FILE* _tmp30_ = NULL;
						const gchar* _tmp31_ = NULL;
#line 158 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
						_tmp30_ = stderr;
#line 158 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
						_tmp31_ = _ ("Level should be between 1 (easy) and 3 (hard). Settings unchanged.");
#line 158 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
						fprintf (_tmp30_, "%s\n", _tmp31_);
#line 971 "iagno.c"
					}
				}
			}
		}
	}
#line 162 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp32_ = gtk_builder_new_from_resource ("/org/gnome/iagno/ui/iagno-screens.ui");
#line 162 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	builder = _tmp32_;
#line 164 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp33_ = game_view_new ();
#line 164 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp33_);
#line 164 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->view);
#line 164 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->view = _tmp33_;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp34_ = self->priv->view;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp34_, "move", (GCallback) _iagno_player_move_cb_game_view_move, self, 0);
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp35_ = builder;
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp36_ = gtk_builder_get_object (_tmp35_, "scoredrawing");
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp37_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_drawing_area_get_type (), GtkDrawingArea));
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	scoredrawing = _tmp37_;
#line 168 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp38_ = self->priv->view;
#line 168 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp39_ = scoredrawing;
#line 168 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_view_set_scoreboard (_tmp38_, _tmp39_);
#line 169 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp40_ = self->priv->view;
#line 169 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp41_ = self->priv->settings;
#line 169 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp42_ = g_settings_get_string (_tmp41_, "theme");
#line 169 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp43_ = _tmp42_;
#line 169 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_view_set_theme (_tmp40_, _tmp43_);
#line 169 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_free0 (_tmp43_);
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp44_ = _ ("Iagno");
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp45_ = self->priv->settings;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp46_ = g_settings_get_int (_tmp45_, "window-width");
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp47_ = self->priv->settings;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp48_ = g_settings_get_int (_tmp47_, "window-height");
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp49_ = self->priv->settings;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp50_ = g_settings_get_boolean (_tmp49_, "window-is-maximized");
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp51_ = start_now;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp52_ = builder;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp53_ = gtk_builder_get_object (_tmp52_, "new-game-screen");
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp54_ = self->priv->view;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp55_ = game_window_new ("/org/gnome/iagno/ui/iagno.css", _tmp44_, _tmp46_, _tmp48_, _tmp50_, _tmp51_, GAME_WINDOW_FLAGS_SHOW_UNDO | GAME_WINDOW_FLAGS_SHOW_START_BUTTON, G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, gtk_box_get_type (), GtkBox), (GtkWidget*) _tmp54_);
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp55_);
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->window);
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->window = _tmp55_;
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp56_ = builder;
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp57_ = gtk_builder_get_object (_tmp56_, "scoregrid");
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp58_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, gtk_widget_get_type (), GtkWidget));
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	scoregrid = _tmp58_;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp59_ = self->priv->window;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp60_ = scoregrid;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_window_add_to_sidebox (_tmp59_, _tmp60_);
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp61_ = self->priv->window;
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp61_, "play", (GCallback) _iagno_start_game_game_window_play, self, 0);
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp62_ = self->priv->window;
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp62_, "wait", (GCallback) _iagno_wait_cb_game_window_wait, self, 0);
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp63_ = self->priv->window;
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp63_, "back", (GCallback) _iagno_back_cb_game_window_back, self, 0);
#line 188 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp64_ = self->priv->window;
#line 188 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp64_, "undo", (GCallback) _iagno_undo_cb_game_window_undo, self, 0);
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_action_map_add_action_entries ((GActionMap*) self, IAGNO_app_actions, G_N_ELEMENTS (IAGNO_app_actions), self);
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp65_ = g_strdup ("<Primary>n");
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp66_ = g_new0 (gchar*, 1 + 1);
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp66_[0] = _tmp65_;
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp67_ = _tmp66_;
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp67__length1 = 1;
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.new-game", _tmp67_);
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp67_ = (_vala_array_free (_tmp67_, _tmp67__length1, (GDestroyNotify) g_free), NULL);
#line 193 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp68_ = g_strdup ("<Primary><Shift>n");
#line 193 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp69_ = g_new0 (gchar*, 1 + 1);
#line 193 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp69_[0] = _tmp68_;
#line 193 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp70_ = _tmp69_;
#line 193 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp70__length1 = 1;
#line 193 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.start-game", _tmp70_);
#line 193 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp70_ = (_vala_array_free (_tmp70_, _tmp70__length1, (GDestroyNotify) g_free), NULL);
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp71_ = g_strdup ("<Primary>z");
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp72_ = g_new0 (gchar*, 1 + 1);
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp72_[0] = _tmp71_;
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp73_ = _tmp72_;
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp73__length1 = 1;
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.undo", _tmp73_);
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp73_ = (_vala_array_free (_tmp73_, _tmp73__length1, (GDestroyNotify) g_free), NULL);
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp74_ = g_strdup ("<Primary><Shift>z");
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp75_ = g_new0 (gchar*, 1 + 1);
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp75_[0] = _tmp74_;
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp76_ = _tmp75_;
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp76__length1 = 1;
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.redo", _tmp76_);
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp76_ = (_vala_array_free (_tmp76_, _tmp76__length1, (GDestroyNotify) g_free), NULL);
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp77_ = g_strdup ("Escape");
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp78_ = g_new0 (gchar*, 1 + 1);
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp78_[0] = _tmp77_;
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp79_ = _tmp78_;
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp79__length1 = 1;
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.back", _tmp79_);
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp79_ = (_vala_array_free (_tmp79_, _tmp79__length1, (GDestroyNotify) g_free), NULL);
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp80_ = self->priv->settings;
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp81_ = g_settings_create_action (_tmp80_, "sound");
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp82_ = _tmp81_;
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp82_);
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (_tmp82_);
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp83_ = self->priv->settings;
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp84_ = g_settings_create_action (_tmp83_, "color");
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp85_ = _tmp84_;
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp85_);
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (_tmp85_);
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp86_ = self->priv->settings;
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp87_ = g_settings_create_action (_tmp86_, "num-players");
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp88_ = _tmp87_;
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp88_);
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (_tmp88_);
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp89_ = self->priv->settings;
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp90_ = g_settings_create_action (_tmp89_, "computer-level");
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp91_ = _tmp90_;
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp91_);
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (_tmp91_);
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp92_ = builder;
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp93_ = gtk_builder_get_object (_tmp92_, "difficulty-box");
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp94_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, gtk_box_get_type (), GtkBox));
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_data3_->level_box = _tmp94_;
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp95_ = builder;
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp96_ = gtk_builder_get_object (_tmp95_, "color-box");
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp97_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp96_, gtk_box_get_type (), GtkBox));
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_data3_->color_box = _tmp97_;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp98_ = self->priv->settings;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_signal_connect_data (_tmp98_, "changed::num-players", (GCallback) ___lambda8__g_settings_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp99_ = self->priv->settings;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp100_ = g_settings_get_int (_tmp99_, "num-players");
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	solo = _tmp100_ == 1;
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp101_ = _data3_->level_box;
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp102_ = solo;
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp101_, _tmp102_);
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp103_ = _data3_->color_box;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp104_ = solo;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp103_, _tmp104_);
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp105_ = builder;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp106_ = gtk_builder_get_object (_tmp105_, "light-score-label");
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp107_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp106_, gtk_label_get_type (), GtkLabel));
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->light_score_label);
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->light_score_label = _tmp107_;
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp108_ = builder;
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp109_ = gtk_builder_get_object (_tmp108_, "dark-score-label");
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp110_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, gtk_label_get_type (), GtkLabel));
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->dark_score_label);
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->dark_score_label = _tmp110_;
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp111_ = start_now;
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp111_) {
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_start_game (self);
#line 1255 "iagno.c"
	}
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp112_ = self->priv->window;
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp112_);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (scoregrid);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (scoredrawing);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (builder);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	block3_data_unref (_data3_);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_data3_ = NULL;
#line 1271 "iagno.c"
}


static void iagno_real_activate (GApplication* base) {
	Iagno * self;
	GameWindow* _tmp0_ = NULL;
#line 223 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = (Iagno*) base;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->window;
#line 225 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_window_present ((GtkWindow*) _tmp0_);
#line 1284 "iagno.c"
}


static void iagno_real_shutdown (GApplication* base) {
	Iagno * self;
	GameWindow* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = (Iagno*) base;
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->window;
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = self->priv->settings;
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_window_shutdown (_tmp0_, _tmp1_);
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	G_APPLICATION_CLASS (iagno_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 1302 "iagno.c"
}


static void iagno_theme_cb (Iagno* self) {
	ThemesDialog* _tmp0_ = NULL;
	ThemesDialog* _tmp6_ = NULL;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->themes_dialog;
#line 241 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp0_ == NULL) {
#line 1315 "iagno.c"
		GSettings* _tmp1_ = NULL;
		GameView* _tmp2_ = NULL;
		ThemesDialog* _tmp3_ = NULL;
		ThemesDialog* _tmp4_ = NULL;
		GameWindow* _tmp5_ = NULL;
#line 243 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = self->priv->settings;
#line 243 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp2_ = self->priv->view;
#line 243 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = themes_dialog_new (_tmp1_, _tmp2_);
#line 243 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_object_ref_sink (_tmp3_);
#line 243 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_object_unref0 (self->priv->themes_dialog);
#line 243 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		self->priv->themes_dialog = _tmp3_;
#line 244 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp4_ = self->priv->themes_dialog;
#line 244 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp5_ = self->priv->window;
#line 244 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		gtk_window_set_transient_for ((GtkWindow*) _tmp4_, (GtkWindow*) _tmp5_);
#line 1339 "iagno.c"
	}
#line 246 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp6_ = self->priv->themes_dialog;
#line 246 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_window_present ((GtkWindow*) _tmp6_);
#line 1345 "iagno.c"
}


static void iagno_help_cb (Iagno* self) {
	GError * _inner_error_ = NULL;
#line 249 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 1353 "iagno.c"
	{
		GameWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
#line 253 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp0_ = self->priv->window;
#line 253 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
#line 253 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 253 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		gtk_show_uri (_tmp1_, "help:iagno", _tmp2_, &_inner_error_);
#line 253 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1368 "iagno.c"
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 251 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		e = _inner_error_;
#line 251 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_inner_error_ = NULL;
#line 257 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = e;
#line 257 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp4_ = _tmp3_->message;
#line 257 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_warning ("iagno.vala:257: Failed to show help: %s", _tmp4_);
#line 251 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_error_free0 (e);
#line 1390 "iagno.c"
	}
	__finally5:
#line 251 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 251 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 251 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_clear_error (&_inner_error_);
#line 251 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		return;
#line 1401 "iagno.c"
	}
}


static void iagno_about_cb (Iagno* self) {
	gchar** authors = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** documenters = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint documenters_length1 = 0;
	gint _documenters_size_ = 0;
	GameWindow* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = g_strdup ("Ian Peters");
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = g_strdup ("Robert Ancell");
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = g_new0 (gchar*, 3 + 1);
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_[0] = _tmp0_;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_[1] = _tmp1_;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_[2] = NULL;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	authors = _tmp2_;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	authors_length1 = 3;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_authors_size_ = authors_length1;
#line 264 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = g_strdup ("Tiffany Antopolski");
#line 264 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = g_new0 (gchar*, 2 + 1);
#line 264 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_[0] = _tmp3_;
#line 264 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_[1] = NULL;
#line 264 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	documenters = _tmp4_;
#line 264 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	documenters_length1 = 2;
#line 264 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_documenters_size_ = documenters_length1;
#line 266 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = self->priv->window;
#line 266 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp6_ = _ ("Iagno");
#line 266 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp7_ = _ ("A disk flipping game derived from Reversi");
#line 266 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp8_ = _ ("translator-credits");
#line 266 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_show_about_dialog ((GtkWindow*) _tmp5_, "name", _tmp6_, "version", VERSION, "copyright", "Copyright © 1998–2008 Ian Peters\n" "Copyright © 2013–2015 Michael Catanzaro\n" "Copyright © 2014–2015 Arnaud Bonatti", "license-type", GTK_LICENSE_GPL_3_0, "comments", _tmp7_, "authors", authors, "documenters", documenters, "translator-credits", _tmp8_, "logo-icon-name", "iagno", "website", "https://wiki.gnome.org/Apps/Iagno", NULL, NULL);
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
#line 1470 "iagno.c"
}


static void iagno_back_cb (Iagno* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Game* _tmp2_ = NULL;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
	Player _tmp5_ = 0;
#line 288 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = self->priv->game;
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = game_get_current_color (_tmp2_);
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = _tmp3_;
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = self->priv->player_one;
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp4_ != _tmp5_) {
#line 1493 "iagno.c"
		ComputerPlayer* _tmp6_ = NULL;
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp6_ = self->priv->computer;
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = _tmp6_ != NULL;
#line 1499 "iagno.c"
	} else {
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = FALSE;
#line 1503 "iagno.c"
	}
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp1_) {
#line 1507 "iagno.c"
		Game* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = self->priv->game;
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = game_get_is_complete (_tmp7_);
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp9_ = _tmp8_;
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp0_ = !_tmp9_;
#line 1519 "iagno.c"
	} else {
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp0_ = FALSE;
#line 1523 "iagno.c"
	}
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp0_) {
#line 1527 "iagno.c"
		ComputerPlayer* _tmp10_ = NULL;
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp10_ = self->priv->computer;
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		computer_player_move_async (_tmp10_, IAGNO_SLOW_MOVE_DELAY, NULL, NULL);
#line 1533 "iagno.c"
	} else {
		Game* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp11_ = self->priv->game;
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp12_ = game_get_is_complete (_tmp11_);
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp13_ = _tmp12_;
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp13_) {
#line 293 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			iagno_game_complete (self, FALSE);
#line 1548 "iagno.c"
		}
	}
}


static void iagno_wait_cb (Iagno* self) {
	ComputerPlayer* _tmp0_ = NULL;
#line 296 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->computer;
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp0_ != NULL) {
#line 1562 "iagno.c"
		ComputerPlayer* _tmp1_ = NULL;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = self->priv->computer;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		computer_player_cancel_move (_tmp1_);
#line 1568 "iagno.c"
	}
}


static void _iagno_turn_ended_cb_game_turn_ended (Game* _sender, gpointer self) {
#line 311 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_turn_ended_cb ((Iagno*) self);
#line 1576 "iagno.c"
}


static void iagno_start_game (Iagno* self) {
	Game* _tmp0_ = NULL;
	ComputerPlayer* _tmp2_ = NULL;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_ = 0;
	Game* _tmp6_ = NULL;
	Game* _tmp7_ = NULL;
	GameView* _tmp8_ = NULL;
	Game* _tmp9_ = NULL;
	GSettings* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	GSettings* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gboolean _tmp18_ = FALSE;
	Player _tmp19_ = 0;
#line 302 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 304 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->game;
#line 304 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp0_ != NULL) {
#line 1601 "iagno.c"
		Game* _tmp1_ = NULL;
#line 305 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = self->priv->game;
#line 305 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
#line 1607 "iagno.c"
	}
#line 307 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = self->priv->computer;
#line 307 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp2_ != NULL) {
#line 1613 "iagno.c"
		ComputerPlayer* _tmp3_ = NULL;
#line 308 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = self->priv->computer;
#line 308 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		computer_player_cancel_move (_tmp3_);
#line 1619 "iagno.c"
	}
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = iagno_alternative_start;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = iagno_size;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp6_ = game_new (_tmp4_, _tmp5_);
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->game);
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->game = _tmp6_;
#line 311 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp7_ = self->priv->game;
#line 311 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp7_, "turn-ended", (GCallback) _iagno_turn_ended_cb_game_turn_ended, self, 0);
#line 312 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp8_ = self->priv->view;
#line 312 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp9_ = self->priv->game;
#line 312 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_view_set_game (_tmp8_, _tmp9_);
#line 314 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp10_ = self->priv->settings;
#line 314 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp11_ = g_settings_get_int (_tmp10_, "num-players");
#line 314 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp11_ == 2) {
#line 315 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_object_unref0 (self->priv->computer);
#line 315 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		self->priv->computer = NULL;
#line 1651 "iagno.c"
	} else {
		Game* _tmp12_ = NULL;
		GSettings* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		ComputerPlayer* _tmp15_ = NULL;
#line 317 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp12_ = self->priv->game;
#line 317 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp13_ = self->priv->settings;
#line 317 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp14_ = g_settings_get_int (_tmp13_, "computer-level");
#line 317 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp15_ = computer_player_new (_tmp12_, _tmp14_);
#line 317 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_object_unref0 (self->priv->computer);
#line 317 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		self->priv->computer = _tmp15_;
#line 1669 "iagno.c"
	}
#line 319 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp16_ = self->priv->settings;
#line 319 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp17_ = g_settings_get_enum (_tmp16_, "color");
#line 319 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp17_ == 1) {
#line 320 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		self->priv->player_one = PLAYER_LIGHT;
#line 1679 "iagno.c"
	} else {
#line 322 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		self->priv->player_one = PLAYER_DARK;
#line 1683 "iagno.c"
	}
#line 324 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_update_ui (self);
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp19_ = self->priv->player_one;
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp19_ != PLAYER_DARK) {
#line 1691 "iagno.c"
		ComputerPlayer* _tmp20_ = NULL;
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp20_ = self->priv->computer;
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp18_ = _tmp20_ != NULL;
#line 1697 "iagno.c"
	} else {
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp18_ = FALSE;
#line 1701 "iagno.c"
	}
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp18_) {
#line 1705 "iagno.c"
		ComputerPlayer* _tmp21_ = NULL;
#line 327 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp21_ = self->priv->computer;
#line 327 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		computer_player_move_async (_tmp21_, IAGNO_MODERATE_MOVE_DELAY, NULL, NULL);
#line 1711 "iagno.c"
	}
}


static void iagno_update_ui (Iagno* self) {
	GameWindow* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	Player _tmp2_ = 0;
	GtkLabel* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	Game* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	GtkLabel* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	Game* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
#line 330 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 332 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->window;
#line 332 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_window_set_subtitle (_tmp0_, NULL);
#line 334 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = self->priv->player_one;
#line 334 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp2_ == PLAYER_DARK) {
#line 334 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = TRUE;
#line 1746 "iagno.c"
	} else {
		ComputerPlayer* _tmp3_ = NULL;
#line 334 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = self->priv->computer;
#line 334 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = _tmp3_ == NULL;
#line 1753 "iagno.c"
	}
#line 334 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp1_) {
#line 1757 "iagno.c"
		GameWindow* _tmp4_ = NULL;
		GSimpleAction* _tmp5_ = NULL;
		Game* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 335 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp4_ = self->priv->window;
#line 335 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp5_ = _tmp4_->undo_action;
#line 335 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp6_ = self->priv->game;
#line 335 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = game_get_number_of_moves (_tmp6_);
#line 335 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = _tmp7_;
#line 335 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_simple_action_set_enabled (_tmp5_, _tmp8_ >= 1);
#line 1775 "iagno.c"
	} else {
		GameWindow* _tmp9_ = NULL;
		GSimpleAction* _tmp10_ = NULL;
		Game* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
#line 337 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp9_ = self->priv->window;
#line 337 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp10_ = _tmp9_->undo_action;
#line 337 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp11_ = self->priv->game;
#line 337 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp12_ = game_get_number_of_moves (_tmp11_);
#line 337 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp13_ = _tmp12_;
#line 337 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_simple_action_set_enabled (_tmp10_, _tmp13_ >= 2);
#line 1794 "iagno.c"
	}
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp14_ = self->priv->dark_score_label;
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp15_ = _ ("%.2d");
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp16_ = self->priv->game;
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp17_ = game_get_n_dark_tiles (_tmp16_);
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp18_ = _tmp17_;
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp19_ = g_strdup_printf (_tmp15_, _tmp18_);
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp20_ = _tmp19_;
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_label_set_text (_tmp14_, _tmp20_);
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_free0 (_tmp20_);
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp21_ = self->priv->light_score_label;
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp22_ = _ ("%.2d");
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp23_ = self->priv->game;
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp24_ = game_get_n_light_tiles (_tmp23_);
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp25_ = _tmp24_;
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp26_ = g_strdup_printf (_tmp22_, _tmp25_);
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp27_ = _tmp26_;
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_label_set_text (_tmp21_, _tmp27_);
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_free0 (_tmp27_);
#line 1832 "iagno.c"
}


static void iagno_undo_cb (Iagno* self) {
	ComputerPlayer* _tmp0_ = NULL;
	GameView* _tmp17_ = NULL;
#line 344 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 346 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->computer;
#line 346 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp0_ == NULL) {
#line 1845 "iagno.c"
		Game* _tmp1_ = NULL;
		Game* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 348 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = self->priv->game;
#line 348 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		game_undo (_tmp1_, 1);
#line 349 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp2_ = self->priv->game;
#line 349 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = game_get_current_player_can_move (_tmp2_);
#line 349 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp4_ = _tmp3_;
#line 349 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (!_tmp4_) {
#line 1862 "iagno.c"
			Game* _tmp5_ = NULL;
#line 350 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp5_ = self->priv->game;
#line 350 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			game_undo (_tmp5_, 1);
#line 1868 "iagno.c"
		}
	} else {
		ComputerPlayer* _tmp6_ = NULL;
		Game* _tmp7_ = NULL;
		Player _tmp8_ = 0;
		Player _tmp9_ = 0;
		Player _tmp10_ = 0;
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp6_ = self->priv->computer;
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		computer_player_cancel_move (_tmp6_);
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = self->priv->game;
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = game_get_current_color (_tmp7_);
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp9_ = _tmp8_;
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp10_ = self->priv->player_one;
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp9_ != _tmp10_) {
#line 1890 "iagno.c"
			Game* _tmp11_ = NULL;
#line 358 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp11_ = self->priv->game;
#line 358 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			game_undo (_tmp11_, 1);
#line 1896 "iagno.c"
		} else {
			Game* _tmp12_ = NULL;
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp12_ = self->priv->game;
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			game_undo (_tmp12_, 2);
#line 1903 "iagno.c"
		}
#line 363 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		while (TRUE) {
#line 1907 "iagno.c"
			Game* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_ = FALSE;
			Game* _tmp16_ = NULL;
#line 363 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp13_ = self->priv->game;
#line 363 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp14_ = game_get_current_player_can_move (_tmp13_);
#line 363 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp15_ = _tmp14_;
#line 363 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			if (!(!_tmp15_)) {
#line 363 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				break;
#line 1922 "iagno.c"
			}
#line 364 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp16_ = self->priv->game;
#line 364 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			game_undo (_tmp16_, 2);
#line 1928 "iagno.c"
		}
	}
#line 367 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_update_ui (self);
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_play_sound (self, IAGNO_SOUND_FLIP);
#line 369 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp17_ = self->priv->view;
#line 369 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_view_update_scoreboard (_tmp17_);
#line 1939 "iagno.c"
}


static void iagno_turn_ended_cb (Iagno* self) {
	Game* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 372 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 374 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_update_ui (self);
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->game;
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = game_get_current_player_can_move (_tmp0_);
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = _tmp1_;
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp2_) {
#line 376 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_prepare_move (self);
#line 1961 "iagno.c"
	} else {
		Game* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = self->priv->game;
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp4_ = game_get_is_complete (_tmp3_);
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp5_ = _tmp4_;
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp5_) {
#line 378 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			iagno_game_complete (self, TRUE);
#line 1976 "iagno.c"
		} else {
#line 380 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			iagno_pass (self);
#line 1980 "iagno.c"
		}
	}
}


static void iagno_prepare_move (Iagno* self) {
	GameView* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	Game* _tmp2_ = NULL;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
	Player _tmp5_ = 0;
#line 383 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 386 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_play_sound (self, IAGNO_SOUND_FLIP);
#line 387 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->view;
#line 387 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_view_update_scoreboard (_tmp0_);
#line 394 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = self->priv->game;
#line 394 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = game_get_current_color (_tmp2_);
#line 394 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = _tmp3_;
#line 394 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = self->priv->player_one;
#line 394 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp4_ != _tmp5_) {
#line 2011 "iagno.c"
		ComputerPlayer* _tmp6_ = NULL;
#line 394 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp6_ = self->priv->computer;
#line 394 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = _tmp6_ != NULL;
#line 2017 "iagno.c"
	} else {
#line 394 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = FALSE;
#line 2021 "iagno.c"
	}
#line 394 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp1_) {
#line 2025 "iagno.c"
		gdouble _tmp7_ = 0.0;
		gboolean _tmp8_ = FALSE;
		ComputerPlayer* _tmp9_ = NULL;
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = iagno_fast_mode;
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp8_) {
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp7_ = IAGNO_QUICK_MOVE_DELAY;
#line 2035 "iagno.c"
		} else {
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp7_ = IAGNO_SLOW_MOVE_DELAY;
#line 2039 "iagno.c"
		}
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp9_ = self->priv->computer;
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		computer_player_move_async (_tmp9_, _tmp7_, NULL, NULL);
#line 2045 "iagno.c"
	}
}


static void iagno_pass (Iagno* self) {
	GameView* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
#line 398 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 401 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_play_sound (self, IAGNO_SOUND_FLIP);
#line 402 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->view;
#line 402 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_view_update_scoreboard (_tmp0_);
#line 404 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = self->priv->game;
#line 404 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_pass (_tmp1_);
#line 405 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = self->priv->game;
#line 405 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = game_get_current_color (_tmp2_);
#line 405 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = _tmp3_;
#line 405 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp4_ == PLAYER_DARK) {
#line 2076 "iagno.c"
		GameWindow* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 408 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp5_ = self->priv->window;
#line 408 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp6_ = _ ("Light must pass, Dark’s move");
#line 408 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		game_window_set_subtitle (_tmp5_, _tmp6_);
#line 2085 "iagno.c"
	} else {
		GameWindow* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = self->priv->window;
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = _ ("Dark must pass, Light’s move");
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		game_window_set_subtitle (_tmp7_, _tmp8_);
#line 2095 "iagno.c"
	}
}


static void iagno_game_complete (Iagno* self, gboolean play_gameover_sound) {
	GameWindow* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	Game* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gboolean _tmp19_ = FALSE;
#line 417 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 419 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->window;
#line 419 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_window_finish_game (_tmp0_);
#line 421 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = self->priv->game;
#line 421 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = game_get_n_light_tiles (_tmp1_);
#line 421 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = _tmp2_;
#line 421 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = self->priv->game;
#line 421 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = game_get_n_dark_tiles (_tmp4_);
#line 421 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp6_ = _tmp5_;
#line 421 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp3_ > _tmp6_) {
#line 2129 "iagno.c"
		GameWindow* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 424 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = self->priv->window;
#line 424 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = _ ("Light wins!");
#line 424 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		game_window_set_subtitle (_tmp7_, _tmp8_);
#line 2138 "iagno.c"
	} else {
		Game* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		Game* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
#line 426 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp9_ = self->priv->game;
#line 426 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp10_ = game_get_n_dark_tiles (_tmp9_);
#line 426 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp11_ = _tmp10_;
#line 426 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp12_ = self->priv->game;
#line 426 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp13_ = game_get_n_light_tiles (_tmp12_);
#line 426 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp14_ = _tmp13_;
#line 426 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp11_ > _tmp14_) {
#line 2160 "iagno.c"
			GameWindow* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
#line 429 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp15_ = self->priv->window;
#line 429 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp16_ = _ ("Dark wins!");
#line 429 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			game_window_set_subtitle (_tmp15_, _tmp16_);
#line 2169 "iagno.c"
		} else {
			GameWindow* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp17_ = self->priv->window;
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp18_ = _ ("The game is draw.");
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			game_window_set_subtitle (_tmp17_, _tmp18_);
#line 2179 "iagno.c"
		}
	}
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp19_ = play_gameover_sound;
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp19_) {
#line 438 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_play_sound (self, IAGNO_SOUND_GAMEOVER);
#line 2188 "iagno.c"
	}
}


static void iagno_player_move_cb (Iagno* self, gint x, gint y) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Game* _tmp2_ = NULL;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
	Player _tmp5_ = 0;
	Game* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = self->priv->game;
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = game_get_current_color (_tmp2_);
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = _tmp3_;
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = self->priv->player_one;
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp4_ != _tmp5_) {
#line 2216 "iagno.c"
		ComputerPlayer* _tmp6_ = NULL;
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp6_ = self->priv->computer;
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = _tmp6_ != NULL;
#line 2222 "iagno.c"
	} else {
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = FALSE;
#line 2226 "iagno.c"
	}
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp1_) {
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp0_ = TRUE;
#line 2232 "iagno.c"
	} else {
		Game* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = self->priv->game;
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = game_get_current_player_can_move (_tmp7_);
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp9_ = _tmp8_;
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp0_ = !_tmp9_;
#line 2245 "iagno.c"
	}
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp0_) {
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		return;
#line 2251 "iagno.c"
	}
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp10_ = self->priv->game;
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp11_ = x;
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp12_ = y;
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp13_ = game_place_tile (_tmp10_, _tmp11_, _tmp12_, TRUE);
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp13_ == 0) {
#line 2263 "iagno.c"
		GameWindow* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
#line 450 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp14_ = self->priv->window;
#line 450 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp15_ = _ ("You can’t move there!");
#line 450 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		game_window_set_subtitle (_tmp14_, _tmp15_);
#line 2272 "iagno.c"
	}
}


static void iagno_play_sound (Iagno* self, IagnoSound sound) {
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* name = NULL;
	IagnoSound _tmp2_ = 0;
	gchar* path = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gint r = 0;
	GameView* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
#line 464 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 466 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->settings;
#line 466 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = g_settings_get_boolean (_tmp0_, "sound");
#line 466 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (!_tmp1_) {
#line 467 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		return;
#line 2301 "iagno.c"
	}
#line 470 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = sound;
#line 470 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	switch (_tmp2_) {
#line 470 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		case IAGNO_SOUND_FLIP:
#line 2309 "iagno.c"
		{
			GameView* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
#line 473 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp3_ = self->priv->view;
#line 473 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp4_ = game_view_get_sound_flip (_tmp3_);
#line 473 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp5_ = _tmp4_;
#line 473 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp6_ = g_strdup (_tmp5_);
#line 473 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_g_free0 (name);
#line 473 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			name = _tmp6_;
#line 474 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			break;
#line 2329 "iagno.c"
		}
#line 470 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		case IAGNO_SOUND_GAMEOVER:
#line 2333 "iagno.c"
		{
			GameView* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
#line 476 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp7_ = self->priv->view;
#line 476 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp8_ = game_view_get_sound_gameover (_tmp7_);
#line 476 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp9_ = _tmp8_;
#line 476 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp10_ = g_strdup (_tmp9_);
#line 476 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_g_free0 (name);
#line 476 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			name = _tmp10_;
#line 477 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			break;
#line 2353 "iagno.c"
		}
		default:
		{
#line 479 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_g_free0 (name);
#line 479 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			return;
#line 2361 "iagno.c"
		}
	}
#line 481 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp11_ = name;
#line 481 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp12_ = g_build_filename (SOUND_DIRECTORY, _tmp11_, NULL);
#line 481 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	path = _tmp12_;
#line 482 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp13_ = self->priv->view;
#line 482 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp14_ = name;
#line 482 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp15_ = path;
#line 482 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp16_ = ca_gtk_play_for_widget ((GtkWidget*) _tmp13_, (guint32) 0, CA_PROP_MEDIA_NAME, _tmp14_, CA_PROP_MEDIA_FILENAME, _tmp15_, NULL);
#line 482 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	r = _tmp16_;
#line 485 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp17_ = r;
#line 485 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp17_ != 0) {
#line 2384 "iagno.c"
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 486 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp18_ = name;
#line 486 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp19_ = path;
#line 486 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_warning ("iagno.vala:486: Error playing file: %s\nfilepath should be:%s\n", _tmp18_, _tmp19_);
#line 2393 "iagno.c"
	}
#line 464 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_free0 (path);
#line 464 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_free0 (name);
#line 2399 "iagno.c"
}


static void iagno_class_init (IagnoClass * klass) {
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_parent_class = g_type_class_peek_parent (klass);
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_type_class_add_private (klass, sizeof (IagnoPrivate));
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	((GApplicationClass *) klass)->handle_local_options = iagno_real_handle_local_options;
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	((GApplicationClass *) klass)->startup = iagno_real_startup;
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	((GApplicationClass *) klass)->activate = iagno_real_activate;
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	((GApplicationClass *) klass)->shutdown = iagno_real_shutdown;
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	G_OBJECT_CLASS (klass)->finalize = iagno_finalize;
#line 2418 "iagno.c"
}


static void iagno_instance_init (Iagno * self) {
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv = IAGNO_GET_PRIVATE (self);
#line 48 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->computer = NULL;
#line 54 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->game = NULL;
#line 2429 "iagno.c"
}


static void iagno_finalize (GObject* obj) {
	Iagno * self;
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IAGNO, Iagno);
#line 26 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->settings);
#line 41 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->window);
#line 42 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->view);
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->dark_score_label);
#line 44 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->light_score_label);
#line 45 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->themes_dialog);
#line 48 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->computer);
#line 54 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->game);
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	G_OBJECT_CLASS (iagno_parent_class)->finalize (obj);
#line 2455 "iagno.c"
}


GType iagno_get_type (void) {
	static volatile gsize iagno_type_id__volatile = 0;
	if (g_once_init_enter (&iagno_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IagnoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) iagno_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Iagno), 0, (GInstanceInitFunc) iagno_instance_init, NULL };
		GType iagno_type_id;
		iagno_type_id = g_type_register_static (gtk_application_get_type (), "Iagno", &g_define_type_info, 0);
		g_once_init_leave (&iagno_type_id__volatile, iagno_type_id);
	}
	return iagno_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



