/* rygel-playspeed-request.c generated by valac 0.30.0.3-b11d, the Vala compiler
 * generated from rygel-playspeed-request.vala, do not modify */

/*
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <libsoup/soup.h>


#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;
typedef struct _RygelPlaySpeedRequestPrivate RygelPlaySpeedRequestPrivate;

#define RYGEL_TYPE_PLAY_SPEED (rygel_play_speed_get_type ())
#define RYGEL_PLAY_SPEED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeed))
#define RYGEL_PLAY_SPEED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeedClass))
#define RYGEL_IS_PLAY_SPEED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED))
#define RYGEL_IS_PLAY_SPEED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED))
#define RYGEL_PLAY_SPEED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeedClass))

typedef struct _RygelPlaySpeed RygelPlaySpeed;
typedef struct _RygelPlaySpeedClass RygelPlaySpeedClass;
#define _rygel_play_speed_unref0(var) ((var == NULL) ? NULL : (var = (rygel_play_speed_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER (rygel_http_media_resource_handler_get_type ())
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandler))
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandlerClass))
#define RYGEL_IS_HTTP_MEDIA_RESOURCE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER))
#define RYGEL_IS_HTTP_MEDIA_RESOURCE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER))
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandlerClass))

typedef struct _RygelHTTPMediaResourceHandler RygelHTTPMediaResourceHandler;
typedef struct _RygelHTTPMediaResourceHandlerClass RygelHTTPMediaResourceHandlerClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;
typedef struct _RygelHTTPGetHandlerPrivate RygelHTTPGetHandlerPrivate;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelHTTPMediaResourceHandlerPrivate RygelHTTPMediaResourceHandlerPrivate;
typedef struct _RygelMediaResourcePrivate RygelMediaResourcePrivate;

typedef enum  {
	RYGEL_PLAY_SPEED_ERROR_INVALID_SPEED_FORMAT,
	RYGEL_PLAY_SPEED_ERROR_SPEED_NOT_PRESENT
} RygelPlaySpeedError;
#define RYGEL_PLAY_SPEED_ERROR rygel_play_speed_error_quark ()
struct _RygelPlaySpeedRequest {
	GObject parent_instance;
	RygelPlaySpeedRequestPrivate * priv;
};

struct _RygelPlaySpeedRequestClass {
	GObjectClass parent_class;
};

struct _RygelPlaySpeedRequestPrivate {
	RygelPlaySpeed* _speed;
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPGet {
	RygelHTTPRequest parent_instance;
	RygelHTTPGetPrivate * priv;
	RygelHTTPSeekRequest* seek;
	RygelPlaySpeedRequest* speed_request;
	RygelHTTPGetHandler* handler;
};

struct _RygelHTTPGetClass {
	RygelHTTPRequestClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPGetHandler {
	GObject parent_instance;
	RygelHTTPGetHandlerPrivate * priv;
};

struct _RygelHTTPGetHandlerClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
	gchar* (*get_default_transfer_mode) (RygelHTTPGetHandler* self);
	gboolean (*supports_transfer_mode) (RygelHTTPGetHandler* self, const gchar* mode);
	gint64 (*get_resource_size) (RygelHTTPGetHandler* self);
	gint64 (*get_resource_duration) (RygelHTTPGetHandler* self);
	gboolean (*supports_byte_seek) (RygelHTTPGetHandler* self);
	gboolean (*supports_time_seek) (RygelHTTPGetHandler* self);
	gboolean (*supports_playspeed) (RygelHTTPGetHandler* self);
	RygelHTTPResponse* (*render_body) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
};

struct _RygelHTTPMediaResourceHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPMediaResourceHandlerPrivate * priv;
	RygelMediaResource* media_resource;
};

struct _RygelHTTPMediaResourceHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelMediaResource {
	GObject parent_instance;
	RygelMediaResourcePrivate * priv;
	gchar** play_speeds;
	gint play_speeds_length1;
};

struct _RygelMediaResourceClass {
	GObjectClass parent_class;
};


static gpointer rygel_play_speed_request_parent_class = NULL;

GQuark rygel_play_speed_error_quark (void);
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
gpointer rygel_play_speed_ref (gpointer instance);
void rygel_play_speed_unref (gpointer instance);
GParamSpec* rygel_param_spec_play_speed (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_play_speed (GValue* value, gpointer v_object);
void rygel_value_take_play_speed (GValue* value, gpointer v_object);
gpointer rygel_value_get_play_speed (const GValue* value);
GType rygel_play_speed_get_type (void) G_GNUC_CONST;
#define RYGEL_PLAY_SPEED_REQUEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestPrivate))
enum  {
	RYGEL_PLAY_SPEED_REQUEST_DUMMY_PROPERTY,
	RYGEL_PLAY_SPEED_REQUEST_SPEED
};
#define RYGEL_PLAY_SPEED_REQUEST_PLAYSPEED_HEADER "PlaySpeed.dlna.org"
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
gboolean rygel_play_speed_request_supported (RygelHTTPGet* request);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
gboolean rygel_http_get_handler_supports_playspeed (RygelHTTPGetHandler* self);
gboolean rygel_play_speed_request_requested (RygelHTTPGet* request);
RygelPlaySpeedRequest* rygel_play_speed_request_new (gint numerator, guint denominator);
RygelPlaySpeedRequest* rygel_play_speed_request_construct (GType object_type, gint numerator, guint denominator);
RygelPlaySpeed* rygel_play_speed_new (gint numerator, guint denominator);
RygelPlaySpeed* rygel_play_speed_construct (GType object_type, gint numerator, guint denominator);
static void rygel_play_speed_request_set_speed (RygelPlaySpeedRequest* self, RygelPlaySpeed* value);
RygelPlaySpeedRequest* rygel_play_speed_request_new_from_string (const gchar* speed, GError** error);
RygelPlaySpeedRequest* rygel_play_speed_request_construct_from_string (GType object_type, const gchar* speed, GError** error);
RygelPlaySpeed* rygel_play_speed_new_from_string (const gchar* speed, GError** error);
RygelPlaySpeed* rygel_play_speed_construct_from_string (GType object_type, const gchar* speed, GError** error);
RygelPlaySpeedRequest* rygel_play_speed_request_new_from_request (RygelHTTPGet* request, GError** error);
RygelPlaySpeedRequest* rygel_play_speed_request_construct_from_request (GType object_type, RygelHTTPGet* request, GError** error);
RygelPlaySpeed* rygel_play_speed_request_get_speed (RygelPlaySpeedRequest* self);
gboolean rygel_play_speed_is_normal_rate (RygelPlaySpeed* self);
GType rygel_http_media_resource_handler_get_type (void) G_GNUC_CONST;
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
GQuark rygel_http_request_error_quark (void);
GType rygel_http_response_get_type (void) G_GNUC_CONST;
static gchar** _vala_array_dup6 (gchar** self, int length);
gboolean rygel_play_speed_request_equals (RygelPlaySpeedRequest* self, RygelPlaySpeedRequest* that);
gboolean rygel_play_speed_equals (RygelPlaySpeed* self, RygelPlaySpeed* that);
static void rygel_play_speed_request_finalize (GObject* obj);
static void _vala_rygel_play_speed_request_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_play_speed_request_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark rygel_play_speed_error_quark (void) {
	return g_quark_from_static_string ("rygel_play_speed_error-quark");
}


/**
     * Return true if playspeed is supported
     *
     * This method utilizes elements associated with the request to determine
     * if a PlaySpeed request is supported for the given request/resource.
     */
gboolean rygel_play_speed_request_supported (RygelHTTPGet* request) {
	gboolean result = FALSE;
	RygelHTTPGet* _tmp0_ = NULL;
	RygelHTTPGetHandler* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (request != NULL, FALSE);
	_tmp0_ = request;
	_tmp1_ = _tmp0_->handler;
	_tmp2_ = rygel_http_get_handler_supports_playspeed (_tmp1_);
	result = _tmp2_;
	return result;
}


gboolean rygel_play_speed_request_requested (RygelHTTPGet* request) {
	gboolean result = FALSE;
	RygelHTTPGet* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessageHeaders* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_val_if_fail (request != NULL, FALSE);
	_tmp0_ = request;
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
	_tmp2_ = _tmp1_->request_headers;
	_tmp3_ = soup_message_headers_get_one (_tmp2_, RYGEL_PLAY_SPEED_REQUEST_PLAYSPEED_HEADER);
	result = _tmp3_ != NULL;
	return result;
}


RygelPlaySpeedRequest* rygel_play_speed_request_construct (GType object_type, gint numerator, guint denominator) {
	RygelPlaySpeedRequest * self = NULL;
	gint _tmp0_ = 0;
	guint _tmp1_ = 0U;
	RygelPlaySpeed* _tmp2_ = NULL;
	RygelPlaySpeed* _tmp3_ = NULL;
	self = (RygelPlaySpeedRequest*) g_object_new (object_type, NULL);
	_tmp0_ = numerator;
	_tmp1_ = denominator;
	_tmp2_ = rygel_play_speed_new (_tmp0_, _tmp1_);
	_tmp3_ = _tmp2_;
	rygel_play_speed_request_set_speed (self, _tmp3_);
	_rygel_play_speed_unref0 (_tmp3_);
	return self;
}


RygelPlaySpeedRequest* rygel_play_speed_request_new (gint numerator, guint denominator) {
	return rygel_play_speed_request_construct (RYGEL_TYPE_PLAY_SPEED_REQUEST, numerator, denominator);
}


RygelPlaySpeedRequest* rygel_play_speed_request_construct_from_string (GType object_type, const gchar* speed, GError** error) {
	RygelPlaySpeedRequest * self = NULL;
	RygelPlaySpeed* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	RygelPlaySpeed* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (speed != NULL, NULL);
	self = (RygelPlaySpeedRequest*) g_object_new (object_type, NULL);
	_tmp1_ = speed;
	_tmp2_ = rygel_play_speed_new_from_string (_tmp1_, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_PLAY_SPEED_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	rygel_play_speed_request_set_speed (self, _tmp0_);
	_rygel_play_speed_unref0 (_tmp0_);
	return self;
}


RygelPlaySpeedRequest* rygel_play_speed_request_new_from_string (const gchar* speed, GError** error) {
	return rygel_play_speed_request_construct_from_string (RYGEL_TYPE_PLAY_SPEED_REQUEST, speed, error);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gchar** _vala_array_dup6 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


RygelPlaySpeedRequest* rygel_play_speed_request_construct_from_request (GType object_type, RygelHTTPGet* request, GError** error) {
	RygelPlaySpeedRequest * self = NULL;
	gchar* speed_string = NULL;
	RygelHTTPGet* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessageHeaders* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar** elements = NULL;
	const gchar* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gint elements_length1 = 0;
	gint _elements_size_ = 0;
	gboolean _tmp12_ = FALSE;
	gchar** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	RygelPlaySpeed* _tmp20_ = NULL;
	gchar** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	const gchar* _tmp22_ = NULL;
	RygelPlaySpeed* _tmp23_ = NULL;
	RygelPlaySpeed* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (request != NULL, NULL);
	self = (RygelPlaySpeedRequest*) g_object_new (object_type, NULL);
	_tmp0_ = request;
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
	_tmp2_ = _tmp1_->request_headers;
	_tmp3_ = soup_message_headers_get_one (_tmp2_, RYGEL_PLAY_SPEED_REQUEST_PLAYSPEED_HEADER);
	_tmp4_ = g_strdup (_tmp3_);
	speed_string = _tmp4_;
	_tmp5_ = speed_string;
	if (_tmp5_ == NULL) {
		gchar* msg = NULL;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		_tmp6_ = g_strdup ("Could not find playspeed header %s");
		msg = _tmp6_;
		_tmp7_ = msg;
		_tmp8_ = g_error_new (RYGEL_PLAY_SPEED_ERROR, RYGEL_PLAY_SPEED_ERROR_SPEED_NOT_PRESENT, _tmp7_, RYGEL_PLAY_SPEED_REQUEST_PLAYSPEED_HEADER);
		_inner_error_ = _tmp8_;
		if (_inner_error_->domain == RYGEL_PLAY_SPEED_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (msg);
			_g_free0 (speed_string);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			_g_free0 (speed_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (msg);
	}
	_tmp9_ = speed_string;
	_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, "=", 0);
	elements = _tmp11_;
	elements_length1 = _vala_array_length (_tmp10_);
	_elements_size_ = elements_length1;
	_tmp13_ = elements;
	_tmp13__length1 = elements_length1;
	if (_tmp13__length1 != 2) {
		_tmp12_ = TRUE;
	} else {
		gchar** _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		const gchar* _tmp15_ = NULL;
		_tmp14_ = elements;
		_tmp14__length1 = elements_length1;
		_tmp15_ = _tmp14_[0];
		_tmp12_ = g_strcmp0 (_tmp15_, "speed") != 0;
	}
	if (_tmp12_) {
		gchar* msg = NULL;
		gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		GError* _tmp19_ = NULL;
		_tmp16_ = g_strdup ("Ill-formed value for header %s: %s");
		msg = _tmp16_;
		_tmp17_ = msg;
		_tmp18_ = speed_string;
		_tmp19_ = g_error_new (RYGEL_PLAY_SPEED_ERROR, RYGEL_PLAY_SPEED_ERROR_INVALID_SPEED_FORMAT, _tmp17_, RYGEL_PLAY_SPEED_REQUEST_PLAYSPEED_HEADER, _tmp18_);
		_inner_error_ = _tmp19_;
		if (_inner_error_->domain == RYGEL_PLAY_SPEED_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (msg);
			elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (speed_string);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (speed_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (msg);
	}
	_tmp21_ = elements;
	_tmp21__length1 = elements_length1;
	_tmp22_ = _tmp21_[1];
	_tmp23_ = rygel_play_speed_new_from_string (_tmp22_, &_inner_error_);
	_tmp20_ = _tmp23_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_PLAY_SPEED_ERROR) {
			g_propagate_error (error, _inner_error_);
			elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (speed_string);
			_g_object_unref0 (self);
			return NULL;
		} else {
			elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (speed_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	rygel_play_speed_request_set_speed (self, _tmp20_);
	_tmp24_ = self->priv->_speed;
	_tmp25_ = rygel_play_speed_is_normal_rate (_tmp24_);
	if (!_tmp25_) {
		RygelHTTPGet* _tmp26_ = NULL;
		RygelHTTPGetHandler* _tmp27_ = NULL;
		_tmp26_ = request;
		_tmp27_ = _tmp26_->handler;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER)) {
			RygelMediaResource* resource = NULL;
			RygelHTTPGet* _tmp28_ = NULL;
			RygelHTTPGetHandler* _tmp29_ = NULL;
			RygelMediaResource* _tmp30_ = NULL;
			RygelMediaResource* _tmp31_ = NULL;
			gchar** speeds = NULL;
			RygelMediaResource* _tmp32_ = NULL;
			gchar** _tmp33_ = NULL;
			gint _tmp33__length1 = 0;
			gchar** _tmp34_ = NULL;
			gint _tmp34__length1 = 0;
			gint speeds_length1 = 0;
			gint _speeds_size_ = 0;
			gboolean found_speed = FALSE;
			gchar** _tmp35_ = NULL;
			gint _tmp35__length1 = 0;
			gboolean _tmp41_ = FALSE;
			_tmp28_ = request;
			_tmp29_ = _tmp28_->handler;
			_tmp30_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER) ? ((RygelHTTPMediaResourceHandler*) _tmp29_) : NULL)->media_resource;
			_tmp31_ = _g_object_ref0 (_tmp30_);
			resource = _tmp31_;
			_tmp32_ = resource;
			_tmp33_ = _tmp32_->play_speeds;
			_tmp33__length1 = _tmp32_->play_speeds_length1;
			_tmp34_ = (_tmp33_ != NULL) ? _vala_array_dup6 (_tmp33_, _tmp33__length1) : ((gpointer) _tmp33_);
			_tmp34__length1 = _tmp33__length1;
			speeds = _tmp34_;
			speeds_length1 = _tmp34__length1;
			_speeds_size_ = speeds_length1;
			found_speed = FALSE;
			_tmp35_ = speeds;
			_tmp35__length1 = speeds_length1;
			{
				gchar** speed_collection = NULL;
				gint speed_collection_length1 = 0;
				gint _speed_collection_size_ = 0;
				gint speed_it = 0;
				speed_collection = _tmp35_;
				speed_collection_length1 = _tmp35__length1;
				for (speed_it = 0; speed_it < _tmp35__length1; speed_it = speed_it + 1) {
					gchar* _tmp36_ = NULL;
					gchar* speed = NULL;
					_tmp36_ = g_strdup (speed_collection[speed_it]);
					speed = _tmp36_;
					{
						RygelPlaySpeedRequest* cur_speed = NULL;
						const gchar* _tmp37_ = NULL;
						RygelPlaySpeedRequest* _tmp38_ = NULL;
						RygelPlaySpeedRequest* _tmp39_ = NULL;
						gboolean _tmp40_ = FALSE;
						_tmp37_ = speed;
						_tmp38_ = rygel_play_speed_request_new_from_string (_tmp37_, &_inner_error_);
						cur_speed = _tmp38_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							if (_inner_error_->domain == RYGEL_PLAY_SPEED_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (speed);
								speeds = (_vala_array_free (speeds, speeds_length1, (GDestroyNotify) g_free), NULL);
								_g_object_unref0 (resource);
								_rygel_play_speed_unref0 (_tmp20_);
								elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (speed_string);
								_g_object_unref0 (self);
								return NULL;
							} else {
								_g_free0 (speed);
								speeds = (_vala_array_free (speeds, speeds_length1, (GDestroyNotify) g_free), NULL);
								_g_object_unref0 (resource);
								_rygel_play_speed_unref0 (_tmp20_);
								elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (speed_string);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						_tmp39_ = cur_speed;
						_tmp40_ = rygel_play_speed_request_equals (self, _tmp39_);
						if (_tmp40_) {
							found_speed = TRUE;
							_g_object_unref0 (cur_speed);
							_g_free0 (speed);
							break;
						}
						_g_object_unref0 (cur_speed);
						_g_free0 (speed);
					}
				}
			}
			_tmp41_ = found_speed;
			if (!_tmp41_) {
				const gchar* _tmp42_ = NULL;
				GError* _tmp43_ = NULL;
				_tmp42_ = speed_string;
				_tmp43_ = g_error_new (RYGEL_PLAY_SPEED_ERROR, RYGEL_PLAY_SPEED_ERROR_SPEED_NOT_PRESENT, "Unknown playspeed requested (%s)", _tmp42_);
				_inner_error_ = _tmp43_;
				if (_inner_error_->domain == RYGEL_PLAY_SPEED_ERROR) {
					g_propagate_error (error, _inner_error_);
					speeds = (_vala_array_free (speeds, speeds_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (resource);
					_rygel_play_speed_unref0 (_tmp20_);
					elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (speed_string);
					_g_object_unref0 (self);
					return NULL;
				} else {
					speeds = (_vala_array_free (speeds, speeds_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (resource);
					_rygel_play_speed_unref0 (_tmp20_);
					elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (speed_string);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			speeds = (_vala_array_free (speeds, speeds_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (resource);
		}
	}
	_rygel_play_speed_unref0 (_tmp20_);
	elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (speed_string);
	return self;
}


RygelPlaySpeedRequest* rygel_play_speed_request_new_from_request (RygelHTTPGet* request, GError** error) {
	return rygel_play_speed_request_construct_from_request (RYGEL_TYPE_PLAY_SPEED_REQUEST, request, error);
}


gboolean rygel_play_speed_request_equals (RygelPlaySpeedRequest* self, RygelPlaySpeedRequest* that) {
	gboolean result = FALSE;
	RygelPlaySpeedRequest* _tmp0_ = NULL;
	RygelPlaySpeed* _tmp1_ = NULL;
	RygelPlaySpeedRequest* _tmp2_ = NULL;
	RygelPlaySpeed* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (that != NULL, FALSE);
	_tmp0_ = that;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->_speed;
	_tmp2_ = that;
	_tmp3_ = _tmp2_->priv->_speed;
	_tmp4_ = rygel_play_speed_equals (_tmp1_, _tmp3_);
	result = _tmp4_;
	return result;
}


RygelPlaySpeed* rygel_play_speed_request_get_speed (RygelPlaySpeedRequest* self) {
	RygelPlaySpeed* result;
	RygelPlaySpeed* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_speed;
	result = _tmp0_;
	return result;
}


static gpointer _rygel_play_speed_ref0 (gpointer self) {
	return self ? rygel_play_speed_ref (self) : NULL;
}


static void rygel_play_speed_request_set_speed (RygelPlaySpeedRequest* self, RygelPlaySpeed* value) {
	RygelPlaySpeed* _tmp0_ = NULL;
	RygelPlaySpeed* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _rygel_play_speed_ref0 (_tmp0_);
	_rygel_play_speed_unref0 (self->priv->_speed);
	self->priv->_speed = _tmp1_;
	g_object_notify ((GObject *) self, "speed");
}


static void rygel_play_speed_request_class_init (RygelPlaySpeedRequestClass * klass) {
	rygel_play_speed_request_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelPlaySpeedRequestPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_play_speed_request_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_play_speed_request_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_play_speed_request_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAY_SPEED_REQUEST_SPEED, rygel_param_spec_play_speed ("speed", "speed", "speed", RYGEL_TYPE_PLAY_SPEED, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void rygel_play_speed_request_instance_init (RygelPlaySpeedRequest * self) {
	self->priv = RYGEL_PLAY_SPEED_REQUEST_GET_PRIVATE (self);
}


static void rygel_play_speed_request_finalize (GObject* obj) {
	RygelPlaySpeedRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest);
	_rygel_play_speed_unref0 (self->priv->_speed);
	G_OBJECT_CLASS (rygel_play_speed_request_parent_class)->finalize (obj);
}


/**
 * This class represents a DLNA PlaySpeed request (PlaySpeed.dlna.org)
 */
GType rygel_play_speed_request_get_type (void) {
	static volatile gsize rygel_play_speed_request_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_play_speed_request_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPlaySpeedRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_play_speed_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlaySpeedRequest), 0, (GInstanceInitFunc) rygel_play_speed_request_instance_init, NULL };
		GType rygel_play_speed_request_type_id;
		rygel_play_speed_request_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelPlaySpeedRequest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_play_speed_request_type_id__volatile, rygel_play_speed_request_type_id);
	}
	return rygel_play_speed_request_type_id__volatile;
}


static void _vala_rygel_play_speed_request_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelPlaySpeedRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest);
	switch (property_id) {
		case RYGEL_PLAY_SPEED_REQUEST_SPEED:
		rygel_value_set_play_speed (value, rygel_play_speed_request_get_speed (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_play_speed_request_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelPlaySpeedRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest);
	switch (property_id) {
		case RYGEL_PLAY_SPEED_REQUEST_SPEED:
		rygel_play_speed_request_set_speed (self, rygel_value_get_play_speed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



