/* iagno.c generated by valac 0.16.0, the Vala compiler
 * generated from iagno.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <games-file-list.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <games-settings.h>
#include <stdlib.h>
#include <string.h>
#include <games-preimage.h>
#include <games-stock.h>
#include <canberra-gtk.h>
#include <canberra.h>
#include <gdk/gdk.h>
#include <locale.h>


#define TYPE_IAGNO (iagno_get_type ())
#define IAGNO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IAGNO, Iagno))
#define IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IAGNO, IagnoClass))
#define IS_IAGNO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IAGNO))
#define IS_IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IAGNO))
#define IAGNO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IAGNO, IagnoClass))

typedef struct _Iagno Iagno;
typedef struct _IagnoClass IagnoClass;
typedef struct _IagnoPrivate IagnoPrivate;

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;

#define TYPE_COMPUTER_PLAYER (computer_player_get_type ())
#define COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayer))
#define COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))
#define IS_COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_PLAYER))
#define IS_COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_PLAYER))
#define COMPUTER_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))

typedef struct _ComputerPlayer ComputerPlayer;
typedef struct _ComputerPlayerClass ComputerPlayerClass;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _computer_player_unref0(var) ((var == NULL) ? NULL : (var = (computer_player_unref (var), NULL)))
#define _game_unref0(var) ((var == NULL) ? NULL : (var = (game_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GamePrivate GamePrivate;

#define TYPE_PLAYER (player_get_type ())
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _Iagno {
	GtkApplication parent_instance;
	IagnoPrivate * priv;
};

struct _IagnoClass {
	GtkApplicationClass parent_class;
};

struct _IagnoPrivate {
	GSettings* settings;
	GtkWindow* window;
	GtkInfoBar* infobar;
	GtkStatusbar* statusbar;
	guint statusbar_id;
	GameView* view;
	GtkLabel* infobar_label;
	GtkLabel* dark_label;
	GtkLabel* light_label;
	GtkLabel* dark_score_label;
	GtkLabel* light_score_label;
	GSimpleAction* undo_action;
	ComputerPlayer* light_computer;
	ComputerPlayer* dark_computer;
	guint computer_timer;
	Game* game;
	gboolean was_pass;
	GamesFileList* theme_file_list;
};

typedef enum  {
	PLAYER_NONE,
	PLAYER_LIGHT,
	PLAYER_DARK
} Player;

struct _Game {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GamePrivate * priv;
	Player* tiles;
	gint tiles_length1;
	gint tiles_length2;
	Player current_color;
};

struct _GameClass {
	GTypeClass parent_class;
	void (*finalize) (Game *self);
};


static gpointer iagno_parent_class = NULL;

GType iagno_get_type (void) G_GNUC_CONST;
GType game_view_get_type (void) G_GNUC_CONST;
gpointer computer_player_ref (gpointer instance);
void computer_player_unref (gpointer instance);
GParamSpec* param_spec_computer_player (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_computer_player (GValue* value, gpointer v_object);
void value_take_computer_player (GValue* value, gpointer v_object);
gpointer value_get_computer_player (const GValue* value);
GType computer_player_get_type (void) G_GNUC_CONST;
gpointer game_ref (gpointer instance);
void game_unref (gpointer instance);
GParamSpec* param_spec_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_game (GValue* value, gpointer v_object);
void value_take_game (GValue* value, gpointer v_object);
gpointer value_get_game (const GValue* value);
GType game_get_type (void) G_GNUC_CONST;
#define IAGNO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_IAGNO, IagnoPrivate))
enum  {
	IAGNO_DUMMY_PROPERTY
};
static void iagno_new_game_cb (Iagno* self);
static void _iagno_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_undo_move_cb (Iagno* self);
static void _iagno_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_preferences_cb (Iagno* self);
static void _iagno_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_help_cb (Iagno* self);
static void _iagno_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_about_cb (Iagno* self);
static void _iagno_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_quit_cb (Iagno* self);
static void _iagno_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_real_startup (GApplication* base);
Iagno* iagno_new (void);
Iagno* iagno_construct (GType object_type);
static void iagno_real_activate (GApplication* base);
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
void game_view_set_game (GameView* self, Game* value);
static void iagno_player_move_cb (Iagno* self, gint x, gint y);
static void _iagno_player_move_cb_game_view_move (GameView* _sender, gint x, gint y, gpointer self);
void game_view_set_show_grid (GameView* self, gboolean value);
void game_view_set_flip_final_result (GameView* self, gboolean value);
static GamesPreimage* iagno_load_theme_texture (Iagno* self, const gchar* filename, gboolean fail_on_error);
void game_view_set_theme (GameView* self, GamesPreimage* value);
static void iagno_start_game (Iagno* self);
Game* game_new (gint width, gint height);
Game* game_construct (GType object_type, gint width, gint height);
static void iagno_game_move_cb (Iagno* self);
static void _iagno_game_move_cb_game_move (Game* _sender, gpointer self);
static void iagno_game_complete_cb (Iagno* self);
static void _iagno_game_complete_cb_game_complete (Game* _sender, gpointer self);
ComputerPlayer* computer_player_new (Game* game, gint level);
ComputerPlayer* computer_player_construct (GType object_type, Game* game, gint level);
static void iagno_update_ui (Iagno* self);
void game_start (Game* self);
gboolean game_get_can_undo (Game* self);
GType player_get_type (void) G_GNUC_CONST;
static void iagno_show_message (Iagno* self, const gchar* message, GtkMessageType type);
gint game_get_n_dark_tiles (Game* self);
gint game_get_n_light_tiles (Game* self);
void game_undo (Game* self, gint count);
static void iagno_show_preferences_dialog (Iagno* self);
static void iagno_play_sound (Iagno* self, const gchar* name);
gboolean game_get_can_move (Game* self);
void game_pass (Game* self);
static gboolean iagno_computer_move_cb (Iagno* self);
static gboolean _iagno_computer_move_cb_gsource_func (gpointer self);
void computer_player_move (ComputerPlayer* self);
gint game_place_tile (Game* self, gint x, gint y);
static void iagno_dark_level_changed_cb (Iagno* self, GtkComboBox* combo);
static void iagno_light_level_changed_cb (Iagno* self, GtkComboBox* combo);
static void iagno_sound_select (Iagno* self, GtkToggleButton* widget);
static void iagno_grid_toggled_cb (Iagno* self, GtkToggleButton* widget);
gboolean game_view_get_show_grid (GameView* self);
static void iagno_flip_final_toggled_cb (Iagno* self, GtkToggleButton* widget);
gboolean game_view_get_flip_final_result (GameView* self);
static void iagno_propbox_response_cb (Iagno* self, GtkWidget* widget, gint response_id);
static gboolean iagno_propbox_close_cb (Iagno* self, GtkWidget* widget, GdkEventAny* event);
static void iagno_theme_changed_cb (Iagno* self, GtkComboBox* widget);
void game_view_redraw (GameView* self);
static void _iagno_propbox_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static gboolean _iagno_propbox_close_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void _iagno_dark_level_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void _iagno_light_level_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void _iagno_sound_select_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _iagno_grid_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _iagno_flip_final_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _iagno_theme_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
gint iagno_main (gchar** args, int args_length1);
static void iagno_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry IAGNO_app_actions[6] = {{"new-game", _iagno_new_game_cb_gsimple_action_activate_callback}, {"undo-move", _iagno_undo_move_cb_gsimple_action_activate_callback}, {"preferences", _iagno_preferences_cb_gsimple_action_activate_callback}, {"help", _iagno_help_cb_gsimple_action_activate_callback}, {"about", _iagno_about_cb_gsimple_action_activate_callback}, {"quit", _iagno_quit_cb_gsimple_action_activate_callback}};

static void _iagno_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_new_game_cb (self);
}


static void _iagno_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_undo_move_cb (self);
}


static void _iagno_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_preferences_cb (self);
}


static void _iagno_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_help_cb (self);
}


static void _iagno_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_about_cb (self);
}


static void _iagno_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_quit_cb (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void iagno_real_startup (GApplication* base) {
	Iagno * self;
	GAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_;
	self = (Iagno*) base;
	G_APPLICATION_CLASS (iagno_parent_class)->startup ((GApplication*) GTK_APPLICATION (self));
	g_action_map_add_action_entries ((GActionMap*) self, IAGNO_app_actions, G_N_ELEMENTS (IAGNO_app_actions), self);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "undo-move");
	_tmp1_ = _g_object_ref0 (G_IS_SIMPLE_ACTION (_tmp0_) ? ((GSimpleAction*) _tmp0_) : NULL);
	_g_object_unref0 (self->priv->undo_action);
	self->priv->undo_action = _tmp1_;
}


Iagno* iagno_construct (GType object_type) {
	Iagno * self = NULL;
	self = (Iagno*) g_object_new (object_type, "application-id", "org.gnome.iagno", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	return self;
}


Iagno* iagno_new (void) {
	return iagno_construct (TYPE_IAGNO);
}


static void _iagno_player_move_cb_game_view_move (GameView* _sender, gint x, gint y, gpointer self) {
	iagno_player_move_cb (self, x, y);
}


static void iagno_real_activate (GApplication* base) {
	Iagno * self;
	GtkWindow* _tmp0_;
	GSettings* _tmp2_;
	GtkBuilder* _tmp3_;
	GtkBuilder* builder;
	GtkBuilder* _tmp8_;
	GObject* _tmp9_ = NULL;
	GtkBuilder* _tmp10_;
	GObject* _tmp11_ = NULL;
	GtkWindow* _tmp12_;
	GtkBuilder* _tmp13_;
	GObject* _tmp14_ = NULL;
	GtkGrid* _tmp15_;
	GtkGrid* top_grid;
	GtkWindow* _tmp16_;
	const gchar* _tmp17_ = NULL;
	GtkWindow* _tmp18_;
	GtkWindow* _tmp19_;
	GSimpleAction* _tmp20_;
	GameView* _tmp21_;
	GameView* _tmp22_;
	GameView* _tmp23_;
	GameView* _tmp24_;
	GameView* _tmp25_;
	Game* _tmp26_;
	GameView* _tmp27_;
	GameView* _tmp28_;
	GSettings* _tmp29_;
	gboolean _tmp30_ = FALSE;
	GameView* _tmp31_;
	GSettings* _tmp32_;
	gboolean _tmp33_ = FALSE;
	GSettings* _tmp34_;
	gchar* _tmp35_ = NULL;
	gchar* tile_set;
	const gchar* _tmp36_;
	GamesPreimage* _tmp37_ = NULL;
	GamesPreimage* theme;
	GamesPreimage* _tmp38_;
	GameView* _tmp41_;
	GamesPreimage* _tmp42_;
	GameView* _tmp43_;
	GtkGrid* _tmp44_;
	GameView* _tmp45_;
	GtkInfoBar* _tmp46_;
	GtkInfoBar* _tmp47_;
	GtkGrid* _tmp48_;
	GtkInfoBar* _tmp49_;
	GtkLabel* _tmp50_;
	GtkLabel* _tmp51_;
	GtkLabel* _tmp52_;
	GtkInfoBar* _tmp53_;
	GtkLabel* _tmp54_;
	GtkStatusbar* _tmp55_;
	GtkStatusbar* _tmp56_;
	GtkStatusbar* _tmp57_;
	GtkBuilder* _tmp58_;
	GObject* _tmp59_ = NULL;
	GtkToolbar* _tmp60_;
	GtkToolbar* toolbar;
	GtkToolbar* _tmp61_;
	GtkToolbar* _tmp62_;
	GtkStyleContext* _tmp63_ = NULL;
	GtkToolbar* _tmp64_;
	GtkSeparatorToolItem* _tmp65_;
	GtkSeparatorToolItem* _tmp66_;
	GtkToolItem* _tmp67_;
	GtkToolItem* _tmp68_;
	GtkToolItem* status_item;
	GtkToolItem* _tmp69_;
	GtkToolItem* _tmp70_;
	GtkAlignment* _tmp71_;
	GtkAlignment* _tmp72_;
	GtkAlignment* status_alignment;
	GtkAlignment* _tmp73_;
	GtkStatusbar* _tmp74_;
	GtkToolItem* _tmp75_;
	GtkAlignment* _tmp76_;
	GtkToolbar* _tmp77_;
	GtkToolItem* _tmp78_;
	GtkToolbar* _tmp79_;
	GtkGrid* _tmp80_;
	GtkGrid* _tmp81_;
	GtkGrid* grid;
	GtkGrid* _tmp82_;
	GtkGrid* _tmp83_;
	GtkStatusbar* _tmp84_;
	GtkGrid* _tmp85_;
	const gchar* _tmp86_ = NULL;
	GtkLabel* _tmp87_;
	GtkLabel* _tmp88_;
	GtkLabel* _tmp89_;
	GtkGrid* _tmp90_;
	GtkLabel* _tmp91_;
	GtkLabel* _tmp92_;
	GtkLabel* _tmp93_;
	GtkLabel* _tmp94_;
	GtkGrid* _tmp95_;
	GtkLabel* _tmp96_;
	const gchar* _tmp97_ = NULL;
	GtkLabel* _tmp98_;
	GtkLabel* _tmp99_;
	GtkLabel* _tmp100_;
	GtkGrid* _tmp101_;
	GtkLabel* _tmp102_;
	GtkLabel* _tmp103_;
	GtkLabel* _tmp104_;
	GtkLabel* _tmp105_;
	GtkGrid* _tmp106_;
	GtkLabel* _tmp107_;
	GtkStatusbar* _tmp108_;
	guint _tmp109_ = 0U;
	GtkWindow* _tmp110_;
	GError * _inner_error_ = NULL;
	self = (Iagno*) base;
	_tmp0_ = self->priv->window;
	if (_tmp0_ != NULL) {
		GtkWindow* _tmp1_;
		_tmp1_ = self->priv->window;
		gtk_widget_show ((GtkWidget*) _tmp1_);
		return;
	}
	_tmp2_ = g_settings_new ("org.gnome.iagno");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp2_;
	_tmp3_ = gtk_builder_new ();
	builder = _tmp3_;
	{
		GtkBuilder* _tmp4_;
		_tmp4_ = builder;
		gtk_builder_add_from_file (_tmp4_, DATA_DIRECTORY "/iagno.ui", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = stderr;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "Could not load UI: %s\n", _tmp7_);
		_g_error_free0 (e);
		_g_object_unref0 (builder);
		return;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp8_ = builder;
	_tmp9_ = gtk_builder_get_object (_tmp8_, "iagno-menu");
	gtk_application_set_app_menu ((GtkApplication*) self, G_IS_MENU_MODEL (_tmp9_) ? ((GMenuModel*) _tmp9_) : NULL);
	_tmp10_ = builder;
	_tmp11_ = gtk_builder_get_object (_tmp10_, "window");
	_tmp12_ = _g_object_ref0 (GTK_IS_WINDOW (_tmp11_) ? ((GtkWindow*) _tmp11_) : NULL);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp12_;
	_tmp13_ = builder;
	_tmp14_ = gtk_builder_get_object (_tmp13_, "grid");
	_tmp15_ = _g_object_ref0 (GTK_IS_GRID (_tmp14_) ? ((GtkGrid*) _tmp14_) : NULL);
	top_grid = _tmp15_;
	_tmp16_ = self->priv->window;
	_tmp17_ = _ ("Iagno");
	gtk_window_set_title (_tmp16_, _tmp17_);
	_tmp18_ = self->priv->window;
	games_settings_bind_window_state ("/org/gnome/iagno/", _tmp18_);
	_tmp19_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, _tmp19_);
	_tmp20_ = self->priv->undo_action;
	g_simple_action_set_enabled (_tmp20_, TRUE);
	_tmp21_ = game_view_new ();
	_tmp22_ = g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp22_;
	_tmp23_ = self->priv->view;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp23_, TRUE);
	_tmp24_ = self->priv->view;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp24_, TRUE);
	_tmp25_ = self->priv->view;
	_tmp26_ = self->priv->game;
	game_view_set_game (_tmp25_, _tmp26_);
	_tmp27_ = self->priv->view;
	g_signal_connect_object (_tmp27_, "move", (GCallback) _iagno_player_move_cb_game_view_move, self, 0);
	_tmp28_ = self->priv->view;
	_tmp29_ = self->priv->settings;
	_tmp30_ = g_settings_get_boolean (_tmp29_, "show-grid");
	game_view_set_show_grid (_tmp28_, _tmp30_);
	_tmp31_ = self->priv->view;
	_tmp32_ = self->priv->settings;
	_tmp33_ = g_settings_get_boolean (_tmp32_, "flip-final-results");
	game_view_set_flip_final_result (_tmp31_, _tmp33_);
	_tmp34_ = self->priv->settings;
	_tmp35_ = g_settings_get_string (_tmp34_, "tileset");
	tile_set = _tmp35_;
	_tmp36_ = tile_set;
	_tmp37_ = iagno_load_theme_texture (self, _tmp36_, FALSE);
	theme = _tmp37_;
	_tmp38_ = theme;
	if (_tmp38_ == NULL) {
		const gchar* _tmp39_;
		GamesPreimage* _tmp40_ = NULL;
		_tmp39_ = tile_set;
		g_warning ("iagno.vala:100: Unable to load theme %s, falling back to default", _tmp39_);
		_tmp40_ = iagno_load_theme_texture (self, "black_and_white.svg", TRUE);
		_g_object_unref0 (theme);
		theme = _tmp40_;
	}
	_tmp41_ = self->priv->view;
	_tmp42_ = theme;
	game_view_set_theme (_tmp41_, _tmp42_);
	_tmp43_ = self->priv->view;
	gtk_widget_show ((GtkWidget*) _tmp43_);
	_tmp44_ = top_grid;
	_tmp45_ = self->priv->view;
	gtk_grid_attach (_tmp44_, (GtkWidget*) _tmp45_, 0, 3, 1, 1);
	_tmp46_ = (GtkInfoBar*) gtk_info_bar_new ();
	_tmp47_ = g_object_ref_sink (_tmp46_);
	_g_object_unref0 (self->priv->infobar);
	self->priv->infobar = _tmp47_;
	_tmp48_ = top_grid;
	_tmp49_ = self->priv->infobar;
	gtk_grid_attach (_tmp48_, (GtkWidget*) _tmp49_, 0, 2, 1, 1);
	_tmp50_ = (GtkLabel*) gtk_label_new ("");
	_tmp51_ = g_object_ref_sink (_tmp50_);
	_g_object_unref0 (self->priv->infobar_label);
	self->priv->infobar_label = _tmp51_;
	_tmp52_ = self->priv->infobar_label;
	gtk_widget_show ((GtkWidget*) _tmp52_);
	_tmp53_ = self->priv->infobar;
	_tmp54_ = self->priv->infobar_label;
	gtk_container_add ((GtkContainer*) _tmp53_, (GtkWidget*) _tmp54_);
	_tmp55_ = (GtkStatusbar*) gtk_statusbar_new ();
	_tmp56_ = g_object_ref_sink (_tmp55_);
	_g_object_unref0 (self->priv->statusbar);
	self->priv->statusbar = _tmp56_;
	_tmp57_ = self->priv->statusbar;
	gtk_widget_show ((GtkWidget*) _tmp57_);
	_tmp58_ = builder;
	_tmp59_ = gtk_builder_get_object (_tmp58_, "toolbar");
	_tmp60_ = _g_object_ref0 (GTK_IS_TOOLBAR (_tmp59_) ? ((GtkToolbar*) _tmp59_) : NULL);
	toolbar = _tmp60_;
	_tmp61_ = toolbar;
	gtk_toolbar_set_show_arrow (_tmp61_, FALSE);
	_tmp62_ = toolbar;
	_tmp63_ = gtk_widget_get_style_context ((GtkWidget*) _tmp62_);
	gtk_style_context_add_class (_tmp63_, GTK_STYLE_CLASS_PRIMARY_TOOLBAR);
	_tmp64_ = toolbar;
	_tmp65_ = (GtkSeparatorToolItem*) gtk_separator_tool_item_new ();
	_tmp66_ = g_object_ref_sink (_tmp65_);
	gtk_toolbar_insert (_tmp64_, (GtkToolItem*) _tmp66_, -1);
	_g_object_unref0 (_tmp66_);
	_tmp67_ = gtk_tool_item_new ();
	_tmp68_ = g_object_ref_sink (_tmp67_);
	status_item = _tmp68_;
	_tmp69_ = status_item;
	gtk_tool_item_set_visible_horizontal (_tmp69_, TRUE);
	_tmp70_ = status_item;
	gtk_tool_item_set_expand (_tmp70_, TRUE);
	_tmp71_ = (GtkAlignment*) gtk_alignment_new (1.0f, 0.5f, 0.0f, 0.0f);
	_tmp72_ = g_object_ref_sink (_tmp71_);
	status_alignment = _tmp72_;
	_tmp73_ = status_alignment;
	_tmp74_ = self->priv->statusbar;
	gtk_container_add ((GtkContainer*) _tmp73_, (GtkWidget*) _tmp74_);
	_tmp75_ = status_item;
	_tmp76_ = status_alignment;
	gtk_container_add ((GtkContainer*) _tmp75_, (GtkWidget*) _tmp76_);
	_tmp77_ = toolbar;
	_tmp78_ = status_item;
	gtk_toolbar_insert (_tmp77_, _tmp78_, -1);
	_tmp79_ = toolbar;
	gtk_widget_show_all ((GtkWidget*) _tmp79_);
	_tmp80_ = (GtkGrid*) gtk_grid_new ();
	_tmp81_ = g_object_ref_sink (_tmp80_);
	grid = _tmp81_;
	_tmp82_ = grid;
	gtk_grid_set_column_spacing (_tmp82_, (guint) 6);
	_tmp83_ = grid;
	gtk_widget_show ((GtkWidget*) _tmp83_);
	_tmp84_ = self->priv->statusbar;
	_tmp85_ = grid;
	gtk_box_pack_start ((GtkBox*) _tmp84_, (GtkWidget*) _tmp85_, FALSE, TRUE, (guint) 0);
	_tmp86_ = _ ("Dark:");
	_tmp87_ = (GtkLabel*) gtk_label_new (_tmp86_);
	_tmp88_ = g_object_ref_sink (_tmp87_);
	_g_object_unref0 (self->priv->dark_label);
	self->priv->dark_label = _tmp88_;
	_tmp89_ = self->priv->dark_label;
	gtk_widget_show ((GtkWidget*) _tmp89_);
	_tmp90_ = grid;
	_tmp91_ = self->priv->dark_label;
	gtk_grid_attach (_tmp90_, (GtkWidget*) _tmp91_, 1, 0, 1, 1);
	_tmp92_ = (GtkLabel*) gtk_label_new ("00");
	_tmp93_ = g_object_ref_sink (_tmp92_);
	_g_object_unref0 (self->priv->dark_score_label);
	self->priv->dark_score_label = _tmp93_;
	_tmp94_ = self->priv->dark_score_label;
	gtk_widget_show ((GtkWidget*) _tmp94_);
	_tmp95_ = grid;
	_tmp96_ = self->priv->dark_score_label;
	gtk_grid_attach (_tmp95_, (GtkWidget*) _tmp96_, 2, 0, 1, 1);
	_tmp97_ = _ ("Light:");
	_tmp98_ = (GtkLabel*) gtk_label_new (_tmp97_);
	_tmp99_ = g_object_ref_sink (_tmp98_);
	_g_object_unref0 (self->priv->light_label);
	self->priv->light_label = _tmp99_;
	_tmp100_ = self->priv->light_label;
	gtk_widget_show ((GtkWidget*) _tmp100_);
	_tmp101_ = grid;
	_tmp102_ = self->priv->light_label;
	gtk_grid_attach (_tmp101_, (GtkWidget*) _tmp102_, 4, 0, 1, 1);
	_tmp103_ = (GtkLabel*) gtk_label_new ("00");
	_tmp104_ = g_object_ref_sink (_tmp103_);
	_g_object_unref0 (self->priv->light_score_label);
	self->priv->light_score_label = _tmp104_;
	_tmp105_ = self->priv->light_score_label;
	gtk_widget_show ((GtkWidget*) _tmp105_);
	_tmp106_ = grid;
	_tmp107_ = self->priv->light_score_label;
	gtk_grid_attach (_tmp106_, (GtkWidget*) _tmp107_, 5, 0, 1, 1);
	_tmp108_ = self->priv->statusbar;
	_tmp109_ = gtk_statusbar_get_context_id (_tmp108_, "iagno");
	self->priv->statusbar_id = _tmp109_;
	iagno_start_game (self);
	_tmp110_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp110_);
	_g_object_unref0 (grid);
	_g_object_unref0 (status_alignment);
	_g_object_unref0 (status_item);
	_g_object_unref0 (toolbar);
	_g_object_unref0 (theme);
	_g_free0 (tile_set);
	_g_object_unref0 (top_grid);
	_g_object_unref0 (builder);
}


static GamesPreimage* iagno_load_theme_texture (Iagno* self, const gchar* filename, gboolean fail_on_error) {
	GamesPreimage* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* path;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = filename;
	_tmp1_ = g_build_filename (DATA_DIRECTORY, "themes", _tmp0_, NULL);
	path = _tmp1_;
	{
		GamesPreimage* _tmp2_;
		GamesPreimage* _tmp3_;
		_tmp2_ = games_preimage_new_from_file (path, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		result = _tmp3_;
		_g_free0 (path);
		return result;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = filename;
		g_warning ("iagno.vala:168: Failed to load theme %s: %s", _tmp4_, path);
		result = NULL;
		_g_error_free0 (e);
		_g_free0 (path);
		return result;
	}
	__finally1:
	_g_free0 (path);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static void iagno_quit_cb (Iagno* self) {
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void iagno_new_game_cb (Iagno* self) {
	g_return_if_fail (self != NULL);
	iagno_start_game (self);
}


static void _iagno_game_move_cb_game_move (Game* _sender, gpointer self) {
	iagno_game_move_cb (self);
}


static void _iagno_game_complete_cb_game_complete (Game* _sender, gpointer self) {
	iagno_game_complete_cb (self);
}


static void iagno_start_game (Iagno* self) {
	guint _tmp0_;
	Game* _tmp2_;
	Game* _tmp4_;
	Game* _tmp5_;
	Game* _tmp6_;
	GameView* _tmp7_;
	Game* _tmp8_;
	GSettings* _tmp9_;
	gint _tmp10_ = 0;
	gint dark_level;
	gint _tmp11_;
	GSettings* _tmp15_;
	gint _tmp16_ = 0;
	gint light_level;
	gint _tmp17_;
	Game* _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->computer_timer;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->computer_timer;
		g_source_remove (_tmp1_);
		self->priv->computer_timer = (guint) 0;
	}
	_tmp2_ = self->priv->game;
	if (_tmp2_ != NULL) {
		Game* _tmp3_;
		_tmp3_ = self->priv->game;
		g_signal_handlers_disconnect_by_func (_tmp3_, NULL, self);
	}
	_tmp4_ = game_new (8, 8);
	_game_unref0 (self->priv->game);
	self->priv->game = _tmp4_;
	_tmp5_ = self->priv->game;
	g_signal_connect_object (_tmp5_, "move", (GCallback) _iagno_game_move_cb_game_move, self, 0);
	_tmp6_ = self->priv->game;
	g_signal_connect_object (_tmp6_, "complete", (GCallback) _iagno_game_complete_cb_game_complete, self, 0);
	_tmp7_ = self->priv->view;
	_tmp8_ = self->priv->game;
	game_view_set_game (_tmp7_, _tmp8_);
	_tmp9_ = self->priv->settings;
	_tmp10_ = g_settings_get_int (_tmp9_, "black-level");
	dark_level = _tmp10_;
	_tmp11_ = dark_level;
	if (_tmp11_ > 0) {
		Game* _tmp12_;
		gint _tmp13_;
		ComputerPlayer* _tmp14_;
		_tmp12_ = self->priv->game;
		_tmp13_ = dark_level;
		_tmp14_ = computer_player_new (_tmp12_, _tmp13_);
		_computer_player_unref0 (self->priv->dark_computer);
		self->priv->dark_computer = _tmp14_;
	} else {
		_computer_player_unref0 (self->priv->dark_computer);
		self->priv->dark_computer = NULL;
	}
	_tmp15_ = self->priv->settings;
	_tmp16_ = g_settings_get_int (_tmp15_, "white-level");
	light_level = _tmp16_;
	_tmp17_ = light_level;
	if (_tmp17_ > 0) {
		Game* _tmp18_;
		gint _tmp19_;
		ComputerPlayer* _tmp20_;
		_tmp18_ = self->priv->game;
		_tmp19_ = light_level;
		_tmp20_ = computer_player_new (_tmp18_, _tmp19_);
		_computer_player_unref0 (self->priv->light_computer);
		self->priv->light_computer = _tmp20_;
	} else {
		_computer_player_unref0 (self->priv->light_computer);
		self->priv->light_computer = NULL;
	}
	iagno_update_ui (self);
	_tmp21_ = self->priv->game;
	game_start (_tmp21_);
}


static void iagno_update_ui (Iagno* self) {
	GtkInfoBar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ComputerPlayer* _tmp2_;
	gboolean _tmp4_;
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->infobar;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp2_ = self->priv->light_computer;
	if (_tmp2_ != NULL) {
		ComputerPlayer* _tmp3_;
		_tmp3_ = self->priv->dark_computer;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp4_ = _tmp1_;
	if (_tmp4_) {
		GSimpleAction* _tmp5_;
		_tmp5_ = self->priv->undo_action;
		g_simple_action_set_enabled (_tmp5_, FALSE);
	} else {
		GSimpleAction* _tmp6_;
		Game* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp6_ = self->priv->undo_action;
		_tmp7_ = self->priv->game;
		_tmp8_ = game_get_can_undo (_tmp7_);
		_tmp9_ = _tmp8_;
		g_simple_action_set_enabled (_tmp6_, _tmp9_);
	}
	_tmp10_ = self->priv->was_pass;
	if (_tmp10_) {
		Game* _tmp11_;
		Player _tmp12_;
		_tmp11_ = self->priv->game;
		_tmp12_ = _tmp11_->current_color;
		if (_tmp12_ == PLAYER_DARK) {
			const gchar* _tmp13_ = NULL;
			_tmp13_ = _ ("Light must pass, Dark's move");
			iagno_show_message (self, _tmp13_, GTK_MESSAGE_INFO);
		} else {
			const gchar* _tmp14_ = NULL;
			_tmp14_ = _ ("Dark must pass, Light's move");
			iagno_show_message (self, _tmp14_, GTK_MESSAGE_INFO);
		}
	} else {
		Game* _tmp15_;
		Player _tmp16_;
		_tmp15_ = self->priv->game;
		_tmp16_ = _tmp15_->current_color;
		if (_tmp16_ == PLAYER_DARK) {
			GtkLabel* _tmp17_;
			const gchar* _tmp18_ = NULL;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			GtkLabel* _tmp23_;
			const gchar* _tmp24_ = NULL;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			GtkLabel* _tmp29_;
			const gchar* _tmp30_ = NULL;
			Game* _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			gchar* _tmp34_ = NULL;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			GtkLabel* _tmp40_;
			const gchar* _tmp41_ = NULL;
			Game* _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
			gchar* _tmp45_ = NULL;
			gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			_tmp17_ = self->priv->dark_label;
			_tmp18_ = _ ("Dark:");
			_tmp19_ = g_strconcat ("<span font_weight='bold'>", _tmp18_, NULL);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strconcat (_tmp20_, "</span>", NULL);
			_tmp22_ = _tmp21_;
			gtk_label_set_markup (_tmp17_, _tmp22_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp20_);
			_tmp23_ = self->priv->light_label;
			_tmp24_ = _ ("Light:");
			_tmp25_ = g_strconcat ("<span font_weight='normal'>", _tmp24_, NULL);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_strconcat (_tmp26_, "</span>", NULL);
			_tmp28_ = _tmp27_;
			gtk_label_set_markup (_tmp23_, _tmp28_);
			_g_free0 (_tmp28_);
			_g_free0 (_tmp26_);
			_tmp29_ = self->priv->dark_score_label;
			_tmp30_ = _ ("%.2d");
			_tmp31_ = self->priv->game;
			_tmp32_ = game_get_n_dark_tiles (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = g_strdup_printf (_tmp30_, _tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = g_strconcat ("<span font_weight='bold'>", _tmp35_, NULL);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strconcat (_tmp37_, "</span>", NULL);
			_tmp39_ = _tmp38_;
			gtk_label_set_markup (_tmp29_, _tmp39_);
			_g_free0 (_tmp39_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp35_);
			_tmp40_ = self->priv->light_score_label;
			_tmp41_ = _ ("%.2d");
			_tmp42_ = self->priv->game;
			_tmp43_ = game_get_n_light_tiles (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = g_strdup_printf (_tmp41_, _tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = g_strconcat ("<span font_weight='normal'>", _tmp46_, NULL);
			_tmp48_ = _tmp47_;
			_tmp49_ = g_strconcat (_tmp48_, "</span>", NULL);
			_tmp50_ = _tmp49_;
			gtk_label_set_markup (_tmp40_, _tmp50_);
			_g_free0 (_tmp50_);
			_g_free0 (_tmp48_);
			_g_free0 (_tmp46_);
		} else {
			Game* _tmp51_;
			Player _tmp52_;
			_tmp51_ = self->priv->game;
			_tmp52_ = _tmp51_->current_color;
			if (_tmp52_ == PLAYER_LIGHT) {
				GtkLabel* _tmp53_;
				const gchar* _tmp54_ = NULL;
				gchar* _tmp55_;
				gchar* _tmp56_;
				gchar* _tmp57_;
				gchar* _tmp58_;
				GtkLabel* _tmp59_;
				const gchar* _tmp60_ = NULL;
				gchar* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				gchar* _tmp64_;
				GtkLabel* _tmp65_;
				const gchar* _tmp66_ = NULL;
				Game* _tmp67_;
				gint _tmp68_;
				gint _tmp69_;
				gchar* _tmp70_ = NULL;
				gchar* _tmp71_;
				gchar* _tmp72_;
				gchar* _tmp73_;
				gchar* _tmp74_;
				gchar* _tmp75_;
				GtkLabel* _tmp76_;
				const gchar* _tmp77_ = NULL;
				Game* _tmp78_;
				gint _tmp79_;
				gint _tmp80_;
				gchar* _tmp81_ = NULL;
				gchar* _tmp82_;
				gchar* _tmp83_;
				gchar* _tmp84_;
				gchar* _tmp85_;
				gchar* _tmp86_;
				_tmp53_ = self->priv->dark_label;
				_tmp54_ = _ ("Dark:");
				_tmp55_ = g_strconcat ("<span font_weight='normal'>", _tmp54_, NULL);
				_tmp56_ = _tmp55_;
				_tmp57_ = g_strconcat (_tmp56_, "</span>", NULL);
				_tmp58_ = _tmp57_;
				gtk_label_set_markup (_tmp53_, _tmp58_);
				_g_free0 (_tmp58_);
				_g_free0 (_tmp56_);
				_tmp59_ = self->priv->light_label;
				_tmp60_ = _ ("Light:");
				_tmp61_ = g_strconcat ("<span font_weight='bold'>", _tmp60_, NULL);
				_tmp62_ = _tmp61_;
				_tmp63_ = g_strconcat (_tmp62_, "</span>", NULL);
				_tmp64_ = _tmp63_;
				gtk_label_set_markup (_tmp59_, _tmp64_);
				_g_free0 (_tmp64_);
				_g_free0 (_tmp62_);
				_tmp65_ = self->priv->dark_score_label;
				_tmp66_ = _ ("%.2d");
				_tmp67_ = self->priv->game;
				_tmp68_ = game_get_n_dark_tiles (_tmp67_);
				_tmp69_ = _tmp68_;
				_tmp70_ = g_strdup_printf (_tmp66_, _tmp69_);
				_tmp71_ = _tmp70_;
				_tmp72_ = g_strconcat ("<span font_weight='normal'>", _tmp71_, NULL);
				_tmp73_ = _tmp72_;
				_tmp74_ = g_strconcat (_tmp73_, "</span>", NULL);
				_tmp75_ = _tmp74_;
				gtk_label_set_markup (_tmp65_, _tmp75_);
				_g_free0 (_tmp75_);
				_g_free0 (_tmp73_);
				_g_free0 (_tmp71_);
				_tmp76_ = self->priv->light_score_label;
				_tmp77_ = _ ("%.2d");
				_tmp78_ = self->priv->game;
				_tmp79_ = game_get_n_light_tiles (_tmp78_);
				_tmp80_ = _tmp79_;
				_tmp81_ = g_strdup_printf (_tmp77_, _tmp80_);
				_tmp82_ = _tmp81_;
				_tmp83_ = g_strconcat ("<span font_weight='bold'>", _tmp82_, NULL);
				_tmp84_ = _tmp83_;
				_tmp85_ = g_strconcat (_tmp84_, "</span>", NULL);
				_tmp86_ = _tmp85_;
				gtk_label_set_markup (_tmp76_, _tmp86_);
				_g_free0 (_tmp86_);
				_g_free0 (_tmp84_);
				_g_free0 (_tmp82_);
			}
		}
	}
}


static void iagno_undo_move_cb (Iagno* self) {
	guint _tmp0_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Game* _tmp4_;
	Player _tmp5_;
	gboolean _tmp7_;
	gboolean _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->computer_timer;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->computer_timer;
		g_source_remove (_tmp1_);
		self->priv->computer_timer = (guint) 0;
	}
	_tmp4_ = self->priv->game;
	_tmp5_ = _tmp4_->current_color;
	if (_tmp5_ == PLAYER_DARK) {
		ComputerPlayer* _tmp6_;
		_tmp6_ = self->priv->dark_computer;
		_tmp3_ = _tmp6_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp7_ = _tmp3_;
	if (_tmp7_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		Game* _tmp9_;
		Player _tmp10_;
		gboolean _tmp12_;
		_tmp9_ = self->priv->game;
		_tmp10_ = _tmp9_->current_color;
		if (_tmp10_ == PLAYER_LIGHT) {
			ComputerPlayer* _tmp11_;
			_tmp11_ = self->priv->light_computer;
			_tmp8_ = _tmp11_ != NULL;
		} else {
			_tmp8_ = FALSE;
		}
		_tmp12_ = _tmp8_;
		_tmp2_ = _tmp12_;
	}
	_tmp13_ = _tmp2_;
	if (_tmp13_) {
		Game* _tmp14_;
		_tmp14_ = self->priv->game;
		game_undo (_tmp14_, 1);
	} else {
		Game* _tmp15_;
		_tmp15_ = self->priv->game;
		game_undo (_tmp15_, 2);
	}
}


static void iagno_about_cb (Iagno* self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** authors;
	gint authors_length1;
	gint _authors_size_;
	gchar* _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** documenters;
	gint documenters_length1;
	gint _documenters_size_;
	GtkWindow* _tmp5_;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Ian Peters");
	_tmp1_ = g_strdup ("Robert Ancell");
	_tmp2_ = g_new0 (gchar*, 3 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	_tmp2_[2] = NULL;
	authors = _tmp2_;
	authors_length1 = 3;
	_authors_size_ = authors_length1;
	_tmp3_ = g_strdup ("Eric Baudais");
	_tmp4_ = g_new0 (gchar*, 2 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp4_[1] = NULL;
	documenters = _tmp4_;
	documenters_length1 = 2;
	_documenters_size_ = documenters_length1;
	_tmp5_ = self->priv->window;
	_tmp6_ = _ ("Iagno");
	_tmp7_ = _ ("Iagno");
	_tmp8_ = games_get_license (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _ ("A disk flipping game derived from Reversi.\n" \
"\n" \
"Iagno is a part of GNOME Games.");
	_tmp11_ = _ ("translator-credits");
	_tmp12_ = _ ("GNOME Games web site");
	gtk_show_about_dialog (_tmp5_, "name", _tmp6_, "version", VERSION, "copyright", "Copyright \xc2\xa9 1998-2008 Ian Peters", "license", _tmp9_, "comments", _tmp10_, "authors", authors, "documenters", documenters, "translator-credits", _tmp11_, "logo-icon-name", "iagno", "website-label", _tmp12_, "website", "http://www.gnome.org/projects/gnome-games/", "wrap-license", TRUE, NULL, NULL);
	_g_free0 (_tmp9_);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static void iagno_preferences_cb (Iagno* self) {
	g_return_if_fail (self != NULL);
	iagno_show_preferences_dialog (self);
}


static void iagno_show_message (Iagno* self, const gchar* message, GtkMessageType type) {
	GtkInfoBar* _tmp0_;
	GtkMessageType _tmp1_;
	GtkLabel* _tmp2_;
	const gchar* _tmp3_;
	GtkInfoBar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->infobar;
	_tmp1_ = type;
	gtk_info_bar_set_message_type (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->infobar_label;
	_tmp3_ = message;
	gtk_label_set_label (_tmp2_, _tmp3_);
	_tmp4_ = self->priv->infobar;
	gtk_widget_show ((GtkWidget*) _tmp4_);
}


static void iagno_help_cb (Iagno* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkWindow* _tmp0_;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen (_tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:iagno", _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("iagno.vala:312: Failed to show help: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gboolean _iagno_computer_move_cb_gsource_func (gpointer self) {
	gboolean result;
	result = iagno_computer_move_cb (self);
	return result;
}


static void iagno_game_move_cb (Iagno* self) {
	Game* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	Game* _tmp6_;
	Player _tmp7_;
	gboolean _tmp9_;
	gboolean _tmp15_;
	g_return_if_fail (self != NULL);
	iagno_play_sound (self, "flip-piece");
	_tmp0_ = self->priv->game;
	_tmp1_ = game_get_can_move (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		Game* _tmp3_;
		self->priv->was_pass = TRUE;
		_tmp3_ = self->priv->game;
		game_pass (_tmp3_);
		return;
	}
	iagno_update_ui (self);
	self->priv->was_pass = FALSE;
	_tmp6_ = self->priv->game;
	_tmp7_ = _tmp6_->current_color;
	if (_tmp7_ == PLAYER_LIGHT) {
		ComputerPlayer* _tmp8_;
		_tmp8_ = self->priv->light_computer;
		_tmp5_ = _tmp8_ != NULL;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp9_ = _tmp5_;
	if (_tmp9_) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp10_ = FALSE;
		Game* _tmp11_;
		Player _tmp12_;
		gboolean _tmp14_;
		_tmp11_ = self->priv->game;
		_tmp12_ = _tmp11_->current_color;
		if (_tmp12_ == PLAYER_DARK) {
			ComputerPlayer* _tmp13_;
			_tmp13_ = self->priv->dark_computer;
			_tmp10_ = _tmp13_ != NULL;
		} else {
			_tmp10_ = FALSE;
		}
		_tmp14_ = _tmp10_;
		_tmp4_ = _tmp14_;
	}
	_tmp15_ = _tmp4_;
	if (_tmp15_) {
		guint _tmp16_ = 0U;
		_tmp16_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, _iagno_computer_move_cb_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->computer_timer = _tmp16_;
	}
}


static gboolean iagno_computer_move_cb (Iagno* self) {
	gboolean result = FALSE;
	Game* _tmp0_;
	Player _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->game;
	_tmp1_ = _tmp0_->current_color;
	if (_tmp1_ == PLAYER_LIGHT) {
		ComputerPlayer* _tmp2_;
		_tmp2_ = self->priv->light_computer;
		computer_player_move (_tmp2_);
	} else {
		ComputerPlayer* _tmp3_;
		_tmp3_ = self->priv->dark_computer;
		computer_player_move (_tmp3_);
	}
	self->priv->computer_timer = (guint) 0;
	result = FALSE;
	return result;
}


static void iagno_game_complete_cb (Iagno* self) {
	Game* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	Game* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	Game* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	Game* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	Game* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	Game* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = game_get_n_light_tiles (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->game;
	_tmp4_ = game_get_n_dark_tiles (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp2_ > _tmp5_) {
		const gchar* _tmp6_ = NULL;
		_tmp6_ = _ ("Light player wins!");
		iagno_show_message (self, _tmp6_, GTK_MESSAGE_INFO);
	}
	_tmp7_ = self->priv->game;
	_tmp8_ = game_get_n_dark_tiles (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->game;
	_tmp11_ = game_get_n_light_tiles (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp9_ > _tmp12_) {
		const gchar* _tmp13_ = NULL;
		_tmp13_ = _ ("Dark player wins!");
		iagno_show_message (self, _tmp13_, GTK_MESSAGE_INFO);
	}
	_tmp14_ = self->priv->game;
	_tmp15_ = game_get_n_light_tiles (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = self->priv->game;
	_tmp18_ = game_get_n_dark_tiles (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp16_ == _tmp19_) {
		const gchar* _tmp20_ = NULL;
		_tmp20_ = _ ("The game was a draw.");
		iagno_show_message (self, _tmp20_, GTK_MESSAGE_INFO);
	}
	iagno_play_sound (self, "gameover");
}


static void iagno_play_sound (Iagno* self, const gchar* name) {
	GSettings* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GameView* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "sound");
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->view;
	_tmp3_ = name;
	_tmp4_ = name;
	_tmp5_ = g_strdup_printf ("%s.ogg", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_build_filename (SOUND_DIRECTORY, _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	ca_gtk_play_for_widget ((GtkWidget*) _tmp2_, (guint32) 0, CA_PROP_MEDIA_NAME, _tmp3_, CA_PROP_MEDIA_FILENAME, _tmp8_, NULL);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
}


static void iagno_player_move_cb (Iagno* self, gint x, gint y) {
	gboolean _tmp0_ = FALSE;
	Game* _tmp1_;
	Player _tmp2_;
	gboolean _tmp5_;
	gboolean _tmp6_ = FALSE;
	Game* _tmp7_;
	Player _tmp8_;
	gboolean _tmp11_;
	Game* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_ = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->game;
	_tmp2_ = _tmp1_->current_color;
	if (_tmp2_ == PLAYER_LIGHT) {
		GSettings* _tmp3_;
		gint _tmp4_ = 0;
		_tmp3_ = self->priv->settings;
		_tmp4_ = g_settings_get_int (_tmp3_, "white-level");
		_tmp0_ = _tmp4_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		return;
	}
	_tmp7_ = self->priv->game;
	_tmp8_ = _tmp7_->current_color;
	if (_tmp8_ == PLAYER_DARK) {
		GSettings* _tmp9_;
		gint _tmp10_ = 0;
		_tmp9_ = self->priv->settings;
		_tmp10_ = g_settings_get_int (_tmp9_, "black-level");
		_tmp6_ = _tmp10_ > 0;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp11_ = _tmp6_;
	if (_tmp11_) {
		return;
	}
	_tmp12_ = self->priv->game;
	_tmp13_ = x;
	_tmp14_ = y;
	_tmp15_ = game_place_tile (_tmp12_, _tmp13_, _tmp14_);
	if (_tmp15_ == 0) {
		const gchar* _tmp16_ = NULL;
		_tmp16_ = _ ("Invalid move.");
		iagno_show_message (self, _tmp16_, GTK_MESSAGE_ERROR);
	}
}


static void iagno_dark_level_changed_cb (Iagno* self, GtkComboBox* combo) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gint level = 0;
	GtkComboBox* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_;
	GSettings* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = combo;
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &level, -1);
	_tmp6_ = self->priv->settings;
	g_settings_set_int (_tmp6_, "black-level", level);
}


static void iagno_light_level_changed_cb (Iagno* self, GtkComboBox* combo) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gint level = 0;
	GtkComboBox* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_;
	GSettings* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = combo;
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &level, -1);
	_tmp6_ = self->priv->settings;
	g_settings_set_int (_tmp6_, "white-level", level);
}


static void iagno_sound_select (Iagno* self, GtkToggleButton* widget) {
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean play_sounds;
	GSettings* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	play_sounds = _tmp1_;
	_tmp2_ = self->priv->settings;
	g_settings_set_boolean (_tmp2_, "sound", play_sounds);
}


static void iagno_grid_toggled_cb (Iagno* self, GtkToggleButton* widget) {
	GameView* _tmp0_;
	GtkToggleButton* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GSettings* _tmp3_;
	GameView* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->view;
	_tmp1_ = widget;
	_tmp2_ = gtk_toggle_button_get_active (_tmp1_);
	game_view_set_show_grid (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->settings;
	_tmp4_ = self->priv->view;
	_tmp5_ = game_view_get_show_grid (_tmp4_);
	_tmp6_ = _tmp5_;
	g_settings_set_boolean (_tmp3_, "show-grid", _tmp6_);
}


static void iagno_flip_final_toggled_cb (Iagno* self, GtkToggleButton* widget) {
	GameView* _tmp0_;
	GtkToggleButton* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GSettings* _tmp3_;
	GameView* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->view;
	_tmp1_ = widget;
	_tmp2_ = gtk_toggle_button_get_active (_tmp1_);
	game_view_set_flip_final_result (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->settings;
	_tmp4_ = self->priv->view;
	_tmp5_ = game_view_get_flip_final_result (_tmp4_);
	_tmp6_ = _tmp5_;
	g_settings_set_boolean (_tmp3_, "flip-final-results", _tmp6_);
}


static void iagno_propbox_response_cb (Iagno* self, GtkWidget* widget, gint response_id) {
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	gtk_widget_hide (_tmp0_);
}


static gboolean iagno_propbox_close_cb (Iagno* self, GtkWidget* widget, GdkEventAny* event) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = widget;
	gtk_widget_hide (_tmp0_);
	result = TRUE;
	return result;
}


static void iagno_theme_changed_cb (Iagno* self, GtkComboBox* widget) {
	GamesFileList* _tmp0_;
	GtkComboBox* _tmp1_;
	gint _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* tile_set;
	GSettings* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GamesPreimage* _tmp8_ = NULL;
	GamesPreimage* theme;
	GamesPreimage* _tmp9_;
	GameView* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->theme_file_list;
	_tmp1_ = widget;
	_tmp2_ = gtk_combo_box_get_active (_tmp1_);
	_tmp3_ = games_file_list_get_nth (_tmp0_, _tmp2_);
	_tmp4_ = g_strdup (_tmp3_);
	tile_set = _tmp4_;
	_tmp5_ = self->priv->settings;
	_tmp6_ = tile_set;
	g_settings_set_string (_tmp5_, "tileset", _tmp6_);
	_tmp7_ = tile_set;
	_tmp8_ = iagno_load_theme_texture (self, _tmp7_, FALSE);
	theme = _tmp8_;
	_tmp9_ = theme;
	if (_tmp9_ == NULL) {
		const gchar* _tmp10_;
		_tmp10_ = tile_set;
		g_warning ("iagno.vala:434: Unable to load theme %s", _tmp10_);
	} else {
		GameView* _tmp11_;
		GamesPreimage* _tmp12_;
		_tmp11_ = self->priv->view;
		_tmp12_ = theme;
		game_view_set_theme (_tmp11_, _tmp12_);
	}
	_tmp13_ = self->priv->view;
	game_view_redraw (_tmp13_);
	_g_object_unref0 (theme);
	_g_free0 (tile_set);
}


static void _iagno_propbox_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	iagno_propbox_response_cb (self, _sender, response_id);
}


static gboolean _iagno_propbox_close_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = iagno_propbox_close_cb (self, _sender, event);
	return result;
}


static void _iagno_dark_level_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	iagno_dark_level_changed_cb (self, _sender);
}


static void _iagno_light_level_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	iagno_light_level_changed_cb (self, _sender);
}


static void _iagno_sound_select_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	iagno_sound_select (self, _sender);
}


static void _iagno_grid_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	iagno_grid_toggled_cb (self, _sender);
}


static void _iagno_flip_final_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	iagno_flip_final_toggled_cb (self, _sender);
}


static void _iagno_theme_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	iagno_theme_changed_cb (self, _sender);
}


static void iagno_show_preferences_dialog (Iagno* self) {
	const gchar* _tmp0_ = NULL;
	GtkWindow* _tmp1_;
	GtkDialog* _tmp2_;
	GtkDialog* _tmp3_;
	GtkDialog* propbox;
	GtkDialog* _tmp4_;
	GtkDialog* _tmp5_;
	GtkBox* _tmp6_ = NULL;
	GtkBox* _tmp7_;
	GtkBox* box;
	GtkBox* _tmp8_;
	GtkDialog* _tmp9_;
	GtkDialog* _tmp10_;
	GtkDialog* _tmp11_;
	GtkGrid* _tmp12_;
	GtkGrid* _tmp13_;
	GtkGrid* grid;
	GtkGrid* _tmp14_;
	GtkGrid* _tmp15_;
	GtkGrid* _tmp16_;
	GtkBox* _tmp17_;
	GtkGrid* _tmp18_;
	const gchar* _tmp19_ = NULL;
	GtkLabel* _tmp20_;
	GtkLabel* _tmp21_;
	GtkLabel* label;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	GtkGrid* _tmp24_;
	GtkLabel* _tmp25_;
	GtkComboBox* _tmp26_;
	GtkComboBox* _tmp27_;
	GtkComboBox* combo;
	GtkComboBox* _tmp28_;
	GtkCellRendererText* _tmp29_;
	GtkCellRendererText* _tmp30_;
	GtkCellRendererText* renderer;
	GtkComboBox* _tmp31_;
	GtkCellRendererText* _tmp32_;
	GtkComboBox* _tmp33_;
	GtkCellRendererText* _tmp34_;
	GtkListStore* _tmp35_;
	GtkListStore* model;
	GtkComboBox* _tmp36_;
	GtkListStore* _tmp37_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp38_;
	GtkTreeIter _tmp39_ = {0};
	GtkListStore* _tmp40_;
	GtkTreeIter _tmp41_;
	const gchar* _tmp42_ = NULL;
	GSettings* _tmp43_;
	gint _tmp44_ = 0;
	GtkListStore* _tmp47_;
	GtkTreeIter _tmp48_ = {0};
	GtkListStore* _tmp49_;
	GtkTreeIter _tmp50_;
	const gchar* _tmp51_ = NULL;
	GSettings* _tmp52_;
	gint _tmp53_ = 0;
	GtkListStore* _tmp56_;
	GtkTreeIter _tmp57_ = {0};
	GtkListStore* _tmp58_;
	GtkTreeIter _tmp59_;
	const gchar* _tmp60_ = NULL;
	GSettings* _tmp61_;
	gint _tmp62_ = 0;
	GtkListStore* _tmp65_;
	GtkTreeIter _tmp66_ = {0};
	GtkListStore* _tmp67_;
	GtkTreeIter _tmp68_;
	const gchar* _tmp69_ = NULL;
	GSettings* _tmp70_;
	gint _tmp71_ = 0;
	GtkGrid* _tmp74_;
	GtkComboBox* _tmp75_;
	const gchar* _tmp76_ = NULL;
	GtkLabel* _tmp77_;
	GtkLabel* _tmp78_;
	GtkLabel* _tmp79_;
	GtkLabel* _tmp80_;
	GtkGrid* _tmp81_;
	GtkLabel* _tmp82_;
	GtkComboBox* _tmp83_;
	GtkComboBox* _tmp84_;
	GtkComboBox* _tmp85_;
	GtkCellRendererText* _tmp86_;
	GtkCellRendererText* _tmp87_;
	GtkComboBox* _tmp88_;
	GtkCellRendererText* _tmp89_;
	GtkComboBox* _tmp90_;
	GtkCellRendererText* _tmp91_;
	GtkListStore* _tmp92_;
	GtkComboBox* _tmp93_;
	GtkListStore* _tmp94_;
	GtkListStore* _tmp95_;
	GtkTreeIter _tmp96_ = {0};
	GtkListStore* _tmp97_;
	GtkTreeIter _tmp98_;
	const gchar* _tmp99_ = NULL;
	GSettings* _tmp100_;
	gint _tmp101_ = 0;
	GtkListStore* _tmp104_;
	GtkTreeIter _tmp105_ = {0};
	GtkListStore* _tmp106_;
	GtkTreeIter _tmp107_;
	const gchar* _tmp108_ = NULL;
	GSettings* _tmp109_;
	gint _tmp110_ = 0;
	GtkListStore* _tmp113_;
	GtkTreeIter _tmp114_ = {0};
	GtkListStore* _tmp115_;
	GtkTreeIter _tmp116_;
	const gchar* _tmp117_ = NULL;
	GSettings* _tmp118_;
	gint _tmp119_ = 0;
	GtkListStore* _tmp122_;
	GtkTreeIter _tmp123_ = {0};
	GtkListStore* _tmp124_;
	GtkTreeIter _tmp125_;
	const gchar* _tmp126_ = NULL;
	GSettings* _tmp127_;
	gint _tmp128_ = 0;
	GtkGrid* _tmp131_;
	GtkComboBox* _tmp132_;
	const gchar* _tmp133_ = NULL;
	GtkCheckButton* _tmp134_;
	GtkCheckButton* _tmp135_;
	GtkCheckButton* enable_sounds_button;
	GSettings* _tmp136_;
	gboolean _tmp137_ = FALSE;
	GtkGrid* _tmp138_;
	const gchar* _tmp139_ = NULL;
	GtkCheckButton* _tmp140_;
	GtkCheckButton* _tmp141_;
	GtkCheckButton* grid_button;
	GSettings* _tmp142_;
	gboolean _tmp143_ = FALSE;
	GtkGrid* _tmp144_;
	const gchar* _tmp145_ = NULL;
	GtkCheckButton* _tmp146_;
	GtkCheckButton* _tmp147_;
	GtkCheckButton* flip_final_button;
	GSettings* _tmp148_;
	gboolean _tmp149_ = FALSE;
	GtkGrid* _tmp150_;
	const gchar* _tmp151_ = NULL;
	GtkLabel* _tmp152_;
	GtkLabel* _tmp153_;
	GtkLabel* _tmp154_;
	GtkLabel* _tmp155_;
	GtkGrid* _tmp156_;
	GtkLabel* _tmp157_;
	gchar* _tmp158_ = NULL;
	gchar* _tmp159_;
	GamesFileList* _tmp160_;
	GamesFileList* _tmp161_;
	GamesFileList* _tmp162_;
	GSettings* _tmp163_;
	gchar* _tmp164_ = NULL;
	gchar* _tmp165_;
	GtkWidget* _tmp166_ = NULL;
	GtkComboBox* _tmp167_;
	GtkComboBox* theme_combo;
	GtkLabel* _tmp168_;
	GtkGrid* _tmp169_;
	GtkDialog* _tmp170_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Iagno Preferences");
	_tmp1_ = self->priv->window;
	_tmp2_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp0_, _tmp1_, 0, GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE, NULL, NULL);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	propbox = _tmp3_;
	_tmp4_ = propbox;
	gtk_container_set_border_width ((GtkContainer*) _tmp4_, (guint) 5);
	_tmp5_ = propbox;
	_tmp6_ = gtk_dialog_get_content_area (_tmp5_);
	_tmp7_ = _g_object_ref0 (GTK_BOX (_tmp6_));
	box = _tmp7_;
	_tmp8_ = box;
	gtk_box_set_spacing (_tmp8_, 2);
	_tmp9_ = propbox;
	gtk_window_set_resizable ((GtkWindow*) _tmp9_, FALSE);
	_tmp10_ = propbox;
	g_signal_connect_object (_tmp10_, "response", (GCallback) _iagno_propbox_response_cb_gtk_dialog_response, self, 0);
	_tmp11_ = propbox;
	g_signal_connect_object ((GtkWidget*) _tmp11_, "delete-event", (GCallback) _iagno_propbox_close_cb_gtk_widget_delete_event, self, 0);
	_tmp12_ = (GtkGrid*) gtk_grid_new ();
	_tmp13_ = g_object_ref_sink (_tmp12_);
	grid = _tmp13_;
	_tmp14_ = grid;
	gtk_container_set_border_width ((GtkContainer*) _tmp14_, (guint) 6);
	_tmp15_ = grid;
	gtk_grid_set_row_spacing (_tmp15_, (guint) 6);
	_tmp16_ = grid;
	gtk_grid_set_column_spacing (_tmp16_, (guint) 18);
	_tmp17_ = box;
	_tmp18_ = grid;
	gtk_container_add ((GtkContainer*) _tmp17_, (GtkWidget*) _tmp18_);
	_tmp19_ = _ ("Dark Player:");
	_tmp20_ = (GtkLabel*) gtk_label_new (_tmp19_);
	_tmp21_ = g_object_ref_sink (_tmp20_);
	label = _tmp21_;
	_tmp22_ = label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp22_, 0.0f, 0.5f);
	_tmp23_ = label;
	g_object_set ((GtkWidget*) _tmp23_, "expand", TRUE, NULL);
	_tmp24_ = grid;
	_tmp25_ = label;
	gtk_grid_attach (_tmp24_, (GtkWidget*) _tmp25_, 0, 0, 1, 1);
	_tmp26_ = (GtkComboBox*) gtk_combo_box_new ();
	_tmp27_ = g_object_ref_sink (_tmp26_);
	combo = _tmp27_;
	_tmp28_ = combo;
	g_signal_connect_object (_tmp28_, "changed", (GCallback) _iagno_dark_level_changed_cb_gtk_combo_box_changed, self, 0);
	_tmp29_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp30_ = g_object_ref_sink (_tmp29_);
	renderer = _tmp30_;
	_tmp31_ = combo;
	_tmp32_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp31_, (GtkCellRenderer*) _tmp32_, TRUE);
	_tmp33_ = combo;
	_tmp34_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp33_, (GtkCellRenderer*) _tmp34_, "text", 0);
	_tmp35_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT);
	model = _tmp35_;
	_tmp36_ = combo;
	_tmp37_ = model;
	gtk_combo_box_set_model (_tmp36_, (GtkTreeModel*) _tmp37_);
	_tmp38_ = model;
	gtk_list_store_append (_tmp38_, &_tmp39_);
	iter = _tmp39_;
	_tmp40_ = model;
	_tmp41_ = iter;
	_tmp42_ = _ ("Human");
	gtk_list_store_set (_tmp40_, &_tmp41_, 0, _tmp42_, 1, 0, -1);
	_tmp43_ = self->priv->settings;
	_tmp44_ = g_settings_get_int (_tmp43_, "black-level");
	if (_tmp44_ == 0) {
		GtkComboBox* _tmp45_;
		GtkTreeIter _tmp46_;
		_tmp45_ = combo;
		_tmp46_ = iter;
		gtk_combo_box_set_active_iter (_tmp45_, &_tmp46_);
	}
	_tmp47_ = model;
	gtk_list_store_append (_tmp47_, &_tmp48_);
	iter = _tmp48_;
	_tmp49_ = model;
	_tmp50_ = iter;
	_tmp51_ = _ ("Level one");
	gtk_list_store_set (_tmp49_, &_tmp50_, 0, _tmp51_, 1, 1, -1);
	_tmp52_ = self->priv->settings;
	_tmp53_ = g_settings_get_int (_tmp52_, "black-level");
	if (_tmp53_ == 1) {
		GtkComboBox* _tmp54_;
		GtkTreeIter _tmp55_;
		_tmp54_ = combo;
		_tmp55_ = iter;
		gtk_combo_box_set_active_iter (_tmp54_, &_tmp55_);
	}
	_tmp56_ = model;
	gtk_list_store_append (_tmp56_, &_tmp57_);
	iter = _tmp57_;
	_tmp58_ = model;
	_tmp59_ = iter;
	_tmp60_ = _ ("Level two");
	gtk_list_store_set (_tmp58_, &_tmp59_, 0, _tmp60_, 1, 2, -1);
	_tmp61_ = self->priv->settings;
	_tmp62_ = g_settings_get_int (_tmp61_, "black-level");
	if (_tmp62_ == 2) {
		GtkComboBox* _tmp63_;
		GtkTreeIter _tmp64_;
		_tmp63_ = combo;
		_tmp64_ = iter;
		gtk_combo_box_set_active_iter (_tmp63_, &_tmp64_);
	}
	_tmp65_ = model;
	gtk_list_store_append (_tmp65_, &_tmp66_);
	iter = _tmp66_;
	_tmp67_ = model;
	_tmp68_ = iter;
	_tmp69_ = _ ("Level three");
	gtk_list_store_set (_tmp67_, &_tmp68_, 0, _tmp69_, 1, 3, -1);
	_tmp70_ = self->priv->settings;
	_tmp71_ = g_settings_get_int (_tmp70_, "black-level");
	if (_tmp71_ == 3) {
		GtkComboBox* _tmp72_;
		GtkTreeIter _tmp73_;
		_tmp72_ = combo;
		_tmp73_ = iter;
		gtk_combo_box_set_active_iter (_tmp72_, &_tmp73_);
	}
	_tmp74_ = grid;
	_tmp75_ = combo;
	gtk_grid_attach (_tmp74_, (GtkWidget*) _tmp75_, 1, 0, 1, 1);
	_tmp76_ = _ ("Light Player:");
	_tmp77_ = (GtkLabel*) gtk_label_new (_tmp76_);
	_tmp78_ = g_object_ref_sink (_tmp77_);
	_g_object_unref0 (label);
	label = _tmp78_;
	_tmp79_ = label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp79_, 0.0f, 0.5f);
	_tmp80_ = label;
	g_object_set ((GtkWidget*) _tmp80_, "expand", TRUE, NULL);
	_tmp81_ = grid;
	_tmp82_ = label;
	gtk_grid_attach (_tmp81_, (GtkWidget*) _tmp82_, 0, 1, 1, 1);
	_tmp83_ = (GtkComboBox*) gtk_combo_box_new ();
	_tmp84_ = g_object_ref_sink (_tmp83_);
	_g_object_unref0 (combo);
	combo = _tmp84_;
	_tmp85_ = combo;
	g_signal_connect_object (_tmp85_, "changed", (GCallback) _iagno_light_level_changed_cb_gtk_combo_box_changed, self, 0);
	_tmp86_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp87_ = g_object_ref_sink (_tmp86_);
	_g_object_unref0 (renderer);
	renderer = _tmp87_;
	_tmp88_ = combo;
	_tmp89_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp88_, (GtkCellRenderer*) _tmp89_, TRUE);
	_tmp90_ = combo;
	_tmp91_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp90_, (GtkCellRenderer*) _tmp91_, "text", 0);
	_tmp92_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT);
	_g_object_unref0 (model);
	model = _tmp92_;
	_tmp93_ = combo;
	_tmp94_ = model;
	gtk_combo_box_set_model (_tmp93_, (GtkTreeModel*) _tmp94_);
	_tmp95_ = model;
	gtk_list_store_append (_tmp95_, &_tmp96_);
	iter = _tmp96_;
	_tmp97_ = model;
	_tmp98_ = iter;
	_tmp99_ = _ ("Human");
	gtk_list_store_set (_tmp97_, &_tmp98_, 0, _tmp99_, 1, 0, -1);
	_tmp100_ = self->priv->settings;
	_tmp101_ = g_settings_get_int (_tmp100_, "white-level");
	if (_tmp101_ == 0) {
		GtkComboBox* _tmp102_;
		GtkTreeIter _tmp103_;
		_tmp102_ = combo;
		_tmp103_ = iter;
		gtk_combo_box_set_active_iter (_tmp102_, &_tmp103_);
	}
	_tmp104_ = model;
	gtk_list_store_append (_tmp104_, &_tmp105_);
	iter = _tmp105_;
	_tmp106_ = model;
	_tmp107_ = iter;
	_tmp108_ = _ ("Level one");
	gtk_list_store_set (_tmp106_, &_tmp107_, 0, _tmp108_, 1, 1, -1);
	_tmp109_ = self->priv->settings;
	_tmp110_ = g_settings_get_int (_tmp109_, "white-level");
	if (_tmp110_ == 1) {
		GtkComboBox* _tmp111_;
		GtkTreeIter _tmp112_;
		_tmp111_ = combo;
		_tmp112_ = iter;
		gtk_combo_box_set_active_iter (_tmp111_, &_tmp112_);
	}
	_tmp113_ = model;
	gtk_list_store_append (_tmp113_, &_tmp114_);
	iter = _tmp114_;
	_tmp115_ = model;
	_tmp116_ = iter;
	_tmp117_ = _ ("Level two");
	gtk_list_store_set (_tmp115_, &_tmp116_, 0, _tmp117_, 1, 2, -1);
	_tmp118_ = self->priv->settings;
	_tmp119_ = g_settings_get_int (_tmp118_, "white-level");
	if (_tmp119_ == 2) {
		GtkComboBox* _tmp120_;
		GtkTreeIter _tmp121_;
		_tmp120_ = combo;
		_tmp121_ = iter;
		gtk_combo_box_set_active_iter (_tmp120_, &_tmp121_);
	}
	_tmp122_ = model;
	gtk_list_store_append (_tmp122_, &_tmp123_);
	iter = _tmp123_;
	_tmp124_ = model;
	_tmp125_ = iter;
	_tmp126_ = _ ("Level three");
	gtk_list_store_set (_tmp124_, &_tmp125_, 0, _tmp126_, 1, 3, -1);
	_tmp127_ = self->priv->settings;
	_tmp128_ = g_settings_get_int (_tmp127_, "white-level");
	if (_tmp128_ == 3) {
		GtkComboBox* _tmp129_;
		GtkTreeIter _tmp130_;
		_tmp129_ = combo;
		_tmp130_ = iter;
		gtk_combo_box_set_active_iter (_tmp129_, &_tmp130_);
	}
	_tmp131_ = grid;
	_tmp132_ = combo;
	gtk_grid_attach (_tmp131_, (GtkWidget*) _tmp132_, 1, 1, 1, 1);
	_tmp133_ = _ ("E_nable sounds");
	_tmp134_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp133_);
	_tmp135_ = g_object_ref_sink (_tmp134_);
	enable_sounds_button = _tmp135_;
	_tmp136_ = self->priv->settings;
	_tmp137_ = g_settings_get_boolean (_tmp136_, "sound");
	gtk_toggle_button_set_active ((GtkToggleButton*) enable_sounds_button, _tmp137_);
	g_signal_connect_object ((GtkToggleButton*) enable_sounds_button, "toggled", (GCallback) _iagno_sound_select_gtk_toggle_button_toggled, self, 0);
	_tmp138_ = grid;
	gtk_grid_attach (_tmp138_, (GtkWidget*) enable_sounds_button, 0, 2, 2, 1);
	_tmp139_ = _ ("S_how grid");
	_tmp140_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp139_);
	_tmp141_ = g_object_ref_sink (_tmp140_);
	grid_button = _tmp141_;
	_tmp142_ = self->priv->settings;
	_tmp143_ = g_settings_get_boolean (_tmp142_, "show-grid");
	gtk_toggle_button_set_active ((GtkToggleButton*) grid_button, _tmp143_);
	g_signal_connect_object ((GtkToggleButton*) grid_button, "toggled", (GCallback) _iagno_grid_toggled_cb_gtk_toggle_button_toggled, self, 0);
	_tmp144_ = grid;
	gtk_grid_attach (_tmp144_, (GtkWidget*) grid_button, 0, 3, 2, 1);
	_tmp145_ = _ ("_Flip final results");
	_tmp146_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp145_);
	_tmp147_ = g_object_ref_sink (_tmp146_);
	flip_final_button = _tmp147_;
	_tmp148_ = self->priv->settings;
	_tmp149_ = g_settings_get_boolean (_tmp148_, "flip-final-results");
	gtk_toggle_button_set_active ((GtkToggleButton*) flip_final_button, _tmp149_);
	g_signal_connect_object ((GtkToggleButton*) flip_final_button, "toggled", (GCallback) _iagno_flip_final_toggled_cb_gtk_toggle_button_toggled, self, 0);
	_tmp150_ = grid;
	gtk_grid_attach (_tmp150_, (GtkWidget*) flip_final_button, 0, 4, 2, 1);
	_tmp151_ = _ ("_Tile set:");
	_tmp152_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp151_);
	_tmp153_ = g_object_ref_sink (_tmp152_);
	_g_object_unref0 (label);
	label = _tmp153_;
	_tmp154_ = label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp154_, 0.0f, 0.5f);
	_tmp155_ = label;
	g_object_set ((GtkWidget*) _tmp155_, "expand", TRUE, NULL);
	_tmp156_ = grid;
	_tmp157_ = label;
	gtk_grid_attach (_tmp156_, (GtkWidget*) _tmp157_, 0, 5, 1, 1);
	_tmp158_ = g_build_filename (DATA_DIRECTORY, "themes", NULL);
	_tmp159_ = _tmp158_;
	_tmp160_ = games_file_list_new_images (_tmp159_, NULL, NULL);
	_g_object_unref0 (self->priv->theme_file_list);
	self->priv->theme_file_list = _tmp160_;
	_g_free0 (_tmp159_);
	_tmp161_ = self->priv->theme_file_list;
	games_file_list_transform_basename (_tmp161_);
	_tmp162_ = self->priv->theme_file_list;
	_tmp163_ = self->priv->settings;
	_tmp164_ = g_settings_get_string (_tmp163_, "tileset");
	_tmp165_ = _tmp164_;
	_tmp166_ = games_file_list_create_widget (_tmp162_, _tmp165_, (guint) (GAMES_FILE_LIST_REMOVE_EXTENSION | GAMES_FILE_LIST_REPLACE_UNDERSCORES));
	_tmp167_ = GTK_COMBO_BOX (_tmp166_);
	_g_free0 (_tmp165_);
	theme_combo = _tmp167_;
	_tmp168_ = label;
	gtk_label_set_mnemonic_widget (_tmp168_, (GtkWidget*) theme_combo);
	g_signal_connect_object (theme_combo, "changed", (GCallback) _iagno_theme_changed_cb_gtk_combo_box_changed, self, 0);
	_tmp169_ = grid;
	gtk_grid_attach (_tmp169_, (GtkWidget*) theme_combo, 1, 5, 1, 1);
	_tmp170_ = propbox;
	gtk_widget_show_all ((GtkWidget*) _tmp170_);
	_g_object_unref0 (theme_combo);
	_g_object_unref0 (flip_final_button);
	_g_object_unref0 (grid_button);
	_g_object_unref0 (enable_sounds_button);
	_g_object_unref0 (model);
	_g_object_unref0 (renderer);
	_g_object_unref0 (combo);
	_g_object_unref0 (label);
	_g_object_unref0 (grid);
	_g_object_unref0 (box);
	_g_object_unref0 (propbox);
}


gint iagno_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* _tmp0_;
	GOptionContext* context;
	GOptionContext* _tmp1_;
	GOptionContext* _tmp2_;
	GOptionGroup* _tmp3_ = NULL;
	const gchar* _tmp8_ = NULL;
	Iagno* _tmp9_;
	Iagno* app;
	Iagno* _tmp10_;
	gint _tmp11_ = 0;
	gint _result_;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_option_context_new ("");
	context = _tmp0_;
	_tmp1_ = context;
	g_option_context_set_translation_domain (_tmp1_, GETTEXT_PACKAGE);
	_tmp2_ = context;
	_tmp3_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (_tmp2_, _tmp3_);
	{
		GOptionContext* _tmp4_;
		_tmp4_ = context;
		g_option_context_parse (_tmp4_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = stderr;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "%s\n", _tmp7_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp8_ = _ ("Iagno");
	g_set_application_name (_tmp8_);
	games_stock_init ();
	gtk_window_set_default_icon_name ("iagno");
	_tmp9_ = iagno_new ();
	app = _tmp9_;
	_tmp10_ = app;
	_tmp11_ = g_application_run ((GApplication*) _tmp10_, 0, NULL);
	_result_ = _tmp11_;
	result = _result_;
	_g_object_unref0 (app);
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return iagno_main (argv, argc);
}


static void iagno_class_init (IagnoClass * klass) {
	iagno_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (IagnoPrivate));
	G_APPLICATION_CLASS (klass)->startup = iagno_real_startup;
	G_APPLICATION_CLASS (klass)->activate = iagno_real_activate;
	G_OBJECT_CLASS (klass)->finalize = iagno_finalize;
}


static void iagno_instance_init (Iagno * self) {
	self->priv = IAGNO_GET_PRIVATE (self);
	self->priv->light_computer = NULL;
	self->priv->dark_computer = NULL;
	self->priv->computer_timer = (guint) 0;
	self->priv->game = NULL;
	self->priv->was_pass = FALSE;
	self->priv->theme_file_list = NULL;
}


static void iagno_finalize (GObject* obj) {
	Iagno * self;
	self = IAGNO (obj);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->infobar);
	_g_object_unref0 (self->priv->statusbar);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->infobar_label);
	_g_object_unref0 (self->priv->dark_label);
	_g_object_unref0 (self->priv->light_label);
	_g_object_unref0 (self->priv->dark_score_label);
	_g_object_unref0 (self->priv->light_score_label);
	_g_object_unref0 (self->priv->undo_action);
	_computer_player_unref0 (self->priv->light_computer);
	_computer_player_unref0 (self->priv->dark_computer);
	_game_unref0 (self->priv->game);
	_g_object_unref0 (self->priv->theme_file_list);
	G_OBJECT_CLASS (iagno_parent_class)->finalize (obj);
}


GType iagno_get_type (void) {
	static volatile gsize iagno_type_id__volatile = 0;
	if (g_once_init_enter (&iagno_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IagnoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) iagno_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Iagno), 0, (GInstanceInitFunc) iagno_instance_init, NULL };
		GType iagno_type_id;
		iagno_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "Iagno", &g_define_type_info, 0);
		g_once_init_leave (&iagno_type_id__volatile, iagno_type_id);
	}
	return iagno_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



