/* rygel-playbin-renderer.c generated by valac 0.16.1, the Vala compiler
 * generated from rygel-playbin-renderer.vala, do not modify */

/*
 * Copyright (C) 2012 Openismus GmbH.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_MEDIA_RENDERER_PLUGIN (rygel_media_renderer_plugin_get_type ())
#define RYGEL_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPlugin))
#define RYGEL_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_MEDIA_RENDERER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))

typedef struct _RygelMediaRendererPlugin RygelMediaRendererPlugin;
typedef struct _RygelMediaRendererPluginClass RygelMediaRendererPluginClass;
typedef struct _RygelMediaRendererPluginPrivate RygelMediaRendererPluginPrivate;

#define RYGEL_TYPE_MEDIA_PLAYER (rygel_media_player_get_type ())
#define RYGEL_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayer))
#define RYGEL_IS_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_PLAYER))
#define RYGEL_MEDIA_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayerIface))

typedef struct _RygelMediaPlayer RygelMediaPlayer;
typedef struct _RygelMediaPlayerIface RygelMediaPlayerIface;

#define RYGEL_PLAYBIN_TYPE_WRAPPING_PLUGIN (rygel_playbin_wrapping_plugin_get_type ())
#define RYGEL_PLAYBIN_WRAPPING_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_PLAYBIN_TYPE_WRAPPING_PLUGIN, RygelPlaybinWrappingPlugin))
#define RYGEL_PLAYBIN_WRAPPING_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_PLAYBIN_TYPE_WRAPPING_PLUGIN, RygelPlaybinWrappingPluginClass))
#define RYGEL_PLAYBIN_IS_WRAPPING_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_PLAYBIN_TYPE_WRAPPING_PLUGIN))
#define RYGEL_PLAYBIN_IS_WRAPPING_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_PLAYBIN_TYPE_WRAPPING_PLUGIN))
#define RYGEL_PLAYBIN_WRAPPING_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_PLAYBIN_TYPE_WRAPPING_PLUGIN, RygelPlaybinWrappingPluginClass))

typedef struct _RygelPlaybinWrappingPlugin RygelPlaybinWrappingPlugin;
typedef struct _RygelPlaybinWrappingPluginClass RygelPlaybinWrappingPluginClass;
typedef struct _RygelPlaybinWrappingPluginPrivate RygelPlaybinWrappingPluginPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_PLAYBIN_TYPE_PLAYER (rygel_playbin_player_get_type ())
#define RYGEL_PLAYBIN_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayer))
#define RYGEL_PLAYBIN_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerClass))
#define RYGEL_PLAYBIN_IS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_PLAYBIN_TYPE_PLAYER))
#define RYGEL_PLAYBIN_IS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_PLAYBIN_TYPE_PLAYER))
#define RYGEL_PLAYBIN_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerClass))

typedef struct _RygelPlaybinPlayer RygelPlaybinPlayer;
typedef struct _RygelPlaybinPlayerClass RygelPlaybinPlayerClass;

#define RYGEL_PLAYBIN_TYPE_RENDERER (rygel_playbin_renderer_get_type ())
#define RYGEL_PLAYBIN_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_PLAYBIN_TYPE_RENDERER, RygelPlaybinRenderer))
#define RYGEL_PLAYBIN_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_PLAYBIN_TYPE_RENDERER, RygelPlaybinRendererClass))
#define RYGEL_PLAYBIN_IS_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_PLAYBIN_TYPE_RENDERER))
#define RYGEL_PLAYBIN_IS_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_PLAYBIN_TYPE_RENDERER))
#define RYGEL_PLAYBIN_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_PLAYBIN_TYPE_RENDERER, RygelPlaybinRendererClass))

typedef struct _RygelPlaybinRenderer RygelPlaybinRenderer;
typedef struct _RygelPlaybinRendererClass RygelPlaybinRendererClass;
typedef struct _RygelPlaybinRendererPrivate RygelPlaybinRendererPrivate;

#define RYGEL_PLAYBIN_TYPE_PLUGIN (rygel_playbin_plugin_get_type ())
#define RYGEL_PLAYBIN_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_PLAYBIN_TYPE_PLUGIN, RygelPlaybinPlugin))
#define RYGEL_PLAYBIN_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_PLAYBIN_TYPE_PLUGIN, RygelPlaybinPluginClass))
#define RYGEL_PLAYBIN_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_PLAYBIN_TYPE_PLUGIN))
#define RYGEL_PLAYBIN_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_PLAYBIN_TYPE_PLUGIN))
#define RYGEL_PLAYBIN_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_PLAYBIN_TYPE_PLUGIN, RygelPlaybinPluginClass))

typedef struct _RygelPlaybinPlugin RygelPlaybinPlugin;
typedef struct _RygelPlaybinPluginClass RygelPlaybinPluginClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelMediaPlayerIface {
	GTypeInterface parent_iface;
	gboolean (*seek) (RygelMediaPlayer* self, GstClockTime time);
	gchar** (*get_protocols) (RygelMediaPlayer* self, int* result_length1);
	gchar** (*get_mime_types) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_state) (RygelMediaPlayer* self);
	void (*set_playback_state) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_uri) (RygelMediaPlayer* self);
	void (*set_uri) (RygelMediaPlayer* self, const gchar* value);
	gdouble (*get_volume) (RygelMediaPlayer* self);
	void (*set_volume) (RygelMediaPlayer* self, gdouble value);
	gint64 (*get_duration) (RygelMediaPlayer* self);
	gchar* (*get_metadata) (RygelMediaPlayer* self);
	void (*set_metadata) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_mime_type) (RygelMediaPlayer* self);
	void (*set_mime_type) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_content_features) (RygelMediaPlayer* self);
	void (*set_content_features) (RygelMediaPlayer* self, const gchar* value);
	gint64 (*get_position) (RygelMediaPlayer* self);
};

struct _RygelMediaRendererPlugin {
	RygelPlugin parent_instance;
	RygelMediaRendererPluginPrivate * priv;
};

struct _RygelMediaRendererPluginClass {
	RygelPluginClass parent_class;
	RygelMediaPlayer* (*get_player) (RygelMediaRendererPlugin* self);
};

struct _RygelPlaybinWrappingPlugin {
	RygelMediaRendererPlugin parent_instance;
	RygelPlaybinWrappingPluginPrivate * priv;
};

struct _RygelPlaybinWrappingPluginClass {
	RygelMediaRendererPluginClass parent_class;
};

struct _RygelPlaybinWrappingPluginPrivate {
	RygelMediaPlayer* player;
};

struct _RygelPlaybinRenderer {
	RygelMediaDevice parent_instance;
	RygelPlaybinRendererPrivate * priv;
};

struct _RygelPlaybinRendererClass {
	RygelMediaDeviceClass parent_class;
};


static gpointer rygel_playbin_wrapping_plugin_parent_class = NULL;
static gpointer rygel_playbin_renderer_parent_class = NULL;

GType rygel_media_renderer_plugin_get_type (void) G_GNUC_CONST;
GType rygel_media_player_get_type (void) G_GNUC_CONST;
GType rygel_playbin_wrapping_plugin_get_type (void) G_GNUC_CONST;
#define RYGEL_PLAYBIN_WRAPPING_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_PLAYBIN_TYPE_WRAPPING_PLUGIN, RygelPlaybinWrappingPluginPrivate))
enum  {
	RYGEL_PLAYBIN_WRAPPING_PLUGIN_DUMMY_PROPERTY
};
RygelPlaybinWrappingPlugin* rygel_playbin_wrapping_plugin_new (GstElement* playbin);
RygelPlaybinWrappingPlugin* rygel_playbin_wrapping_plugin_construct (GType object_type, GstElement* playbin);
RygelMediaRendererPlugin* rygel_media_renderer_plugin_new (const gchar* name, const gchar* title, const gchar* description);
RygelMediaRendererPlugin* rygel_media_renderer_plugin_construct (GType object_type, const gchar* name, const gchar* title, const gchar* description);
RygelPlaybinPlayer* rygel_playbin_player_new_wrap (GstElement* playbin);
RygelPlaybinPlayer* rygel_playbin_player_construct_wrap (GType object_type, GstElement* playbin);
GType rygel_playbin_player_get_type (void) G_GNUC_CONST;
static RygelMediaPlayer* rygel_playbin_wrapping_plugin_real_get_player (RygelMediaRendererPlugin* base);
static void rygel_playbin_wrapping_plugin_finalize (GObject* obj);
GType rygel_playbin_renderer_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_PLAYBIN_RENDERER_DUMMY_PROPERTY
};
RygelPlaybinRenderer* rygel_playbin_renderer_new (const gchar* title);
RygelPlaybinRenderer* rygel_playbin_renderer_construct (GType object_type, const gchar* title);
RygelPlaybinPlugin* rygel_playbin_plugin_new (void);
RygelPlaybinPlugin* rygel_playbin_plugin_construct (GType object_type);
GType rygel_playbin_plugin_get_type (void) G_GNUC_CONST;
static void rygel_playbin_renderer_prepare_upnp (RygelPlaybinRenderer* self, const gchar* title);
RygelPlaybinRenderer* rygel_playbin_renderer_new_wrap (GstElement* pipeline, const gchar* title);
RygelPlaybinRenderer* rygel_playbin_renderer_construct_wrap (GType object_type, GstElement* pipeline, const gchar* title);


RygelPlaybinWrappingPlugin* rygel_playbin_wrapping_plugin_construct (GType object_type, GstElement* playbin) {
	RygelPlaybinWrappingPlugin * self = NULL;
	const gchar* _tmp0_ = NULL;
	GstElement* _tmp1_;
	RygelPlaybinPlayer* _tmp2_;
	g_return_val_if_fail (playbin != NULL, NULL);
	_tmp0_ = _ ("LibRygel Renderer");
	self = (RygelPlaybinWrappingPlugin*) rygel_media_renderer_plugin_construct (object_type, "LibRygel-Renderer", _tmp0_, NULL);
	_tmp1_ = playbin;
	_tmp2_ = rygel_playbin_player_new_wrap (_tmp1_);
	_g_object_unref0 (self->priv->player);
	self->priv->player = (RygelMediaPlayer*) _tmp2_;
	return self;
}


RygelPlaybinWrappingPlugin* rygel_playbin_wrapping_plugin_new (GstElement* playbin) {
	return rygel_playbin_wrapping_plugin_construct (RYGEL_PLAYBIN_TYPE_WRAPPING_PLUGIN, playbin);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static RygelMediaPlayer* rygel_playbin_wrapping_plugin_real_get_player (RygelMediaRendererPlugin* base) {
	RygelPlaybinWrappingPlugin * self;
	RygelMediaPlayer* result = NULL;
	RygelMediaPlayer* _tmp0_;
	RygelMediaPlayer* _tmp1_;
	self = (RygelPlaybinWrappingPlugin*) base;
	_tmp0_ = self->priv->player;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rygel_playbin_wrapping_plugin_class_init (RygelPlaybinWrappingPluginClass * klass) {
	rygel_playbin_wrapping_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelPlaybinWrappingPluginPrivate));
	RYGEL_MEDIA_RENDERER_PLUGIN_CLASS (klass)->get_player = rygel_playbin_wrapping_plugin_real_get_player;
	G_OBJECT_CLASS (klass)->finalize = rygel_playbin_wrapping_plugin_finalize;
}


static void rygel_playbin_wrapping_plugin_instance_init (RygelPlaybinWrappingPlugin * self) {
	self->priv = RYGEL_PLAYBIN_WRAPPING_PLUGIN_GET_PRIVATE (self);
}


static void rygel_playbin_wrapping_plugin_finalize (GObject* obj) {
	RygelPlaybinWrappingPlugin * self;
	self = RYGEL_PLAYBIN_WRAPPING_PLUGIN (obj);
	_g_object_unref0 (self->priv->player);
	G_OBJECT_CLASS (rygel_playbin_wrapping_plugin_parent_class)->finalize (obj);
}


GType rygel_playbin_wrapping_plugin_get_type (void) {
	static volatile gsize rygel_playbin_wrapping_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_playbin_wrapping_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPlaybinWrappingPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_playbin_wrapping_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlaybinWrappingPlugin), 0, (GInstanceInitFunc) rygel_playbin_wrapping_plugin_instance_init, NULL };
		GType rygel_playbin_wrapping_plugin_type_id;
		rygel_playbin_wrapping_plugin_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, "RygelPlaybinWrappingPlugin", &g_define_type_info, 0);
		g_once_init_leave (&rygel_playbin_wrapping_plugin_type_id__volatile, rygel_playbin_wrapping_plugin_type_id);
	}
	return rygel_playbin_wrapping_plugin_type_id__volatile;
}


/**
     * Create a new instance of Renderer.
     *
     * Renderer will instantiate its own instance of GstPlayBin2.
     * The GstPlayBin2 can be accessed by using rygel_playbin_player_get_playbin().
     *
     * @param title Friendly name of the new UPnP renderer on the network.
     */
RygelPlaybinRenderer* rygel_playbin_renderer_construct (GType object_type, const gchar* title) {
	RygelPlaybinRenderer * self = NULL;
	RygelPlaybinPlugin* _tmp0_;
	RygelPlaybinPlugin* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (title != NULL, NULL);
	self = (RygelPlaybinRenderer*) rygel_media_device_construct (object_type);
	_tmp0_ = rygel_playbin_plugin_new ();
	_tmp1_ = _tmp0_;
	rygel_media_device_set_plugin ((RygelMediaDevice*) self, (RygelPlugin*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = title;
	rygel_playbin_renderer_prepare_upnp (self, _tmp2_);
	return self;
}


RygelPlaybinRenderer* rygel_playbin_renderer_new (const gchar* title) {
	return rygel_playbin_renderer_construct (RYGEL_PLAYBIN_TYPE_RENDERER, title);
}


/**
     * Create a new instance of Renderer, wrapping an existing GstPlayBin2
     * instance.
     *
     * @param pipeline Instance of GstPlayBin2 to wrap.
     * @param title Friendly name of the new UPnP renderer on the network.
     */
RygelPlaybinRenderer* rygel_playbin_renderer_construct_wrap (GType object_type, GstElement* pipeline, const gchar* title) {
	RygelPlaybinRenderer * self = NULL;
	GstElement* _tmp0_;
	RygelPlaybinWrappingPlugin* _tmp1_;
	RygelPlaybinWrappingPlugin* _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (pipeline != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	self = (RygelPlaybinRenderer*) rygel_media_device_construct (object_type);
	_tmp0_ = pipeline;
	_tmp1_ = rygel_playbin_wrapping_plugin_new (_tmp0_);
	_tmp2_ = _tmp1_;
	rygel_media_device_set_plugin ((RygelMediaDevice*) self, (RygelPlugin*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = title;
	rygel_playbin_renderer_prepare_upnp (self, _tmp3_);
	return self;
}


RygelPlaybinRenderer* rygel_playbin_renderer_new_wrap (GstElement* pipeline, const gchar* title) {
	return rygel_playbin_renderer_construct_wrap (RYGEL_PLAYBIN_TYPE_RENDERER, pipeline, title);
}


static void rygel_playbin_renderer_prepare_upnp (RygelPlaybinRenderer* self, const gchar* title) {
	RygelPlugin* _tmp0_;
	RygelPlugin* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = rygel_media_device_get_plugin ((RygelMediaDevice*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = title;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (_tmp1_->title);
	_tmp1_->title = _tmp3_;
	rygel_media_device_add_interface ((RygelMediaDevice*) self, "lo");
}


static void rygel_playbin_renderer_class_init (RygelPlaybinRendererClass * klass) {
	rygel_playbin_renderer_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_playbin_renderer_instance_init (RygelPlaybinRenderer * self) {
}


/**
 * A UPnP renderer that uses a GStreamer Playbin2 element.
 *
 * Using GstPlayBin2 as a model, it reflects any changes done externally, such as
 * changing the currently played URI, volume, pause/play etc., to UPnP.
 *
 * Likewise, the playbin can be modified externally using UPnP.
 *
 * You can retrieve the GstPlayBin2 by calling rygel_playbin_player_get_playbin()
 * on the default player - see rygel_playbin_player_get_default().
 * You should then set the "video-sink" and "audio-sink" properties of the
 * playbin.
 *
 * Call rygel_media_device_add_interface() on the Renderer to allow it
 * to be controlled by a control point and to retrieve data streams via that
 * network interface.
 *
 * See the standalone-renderer.c example.
 */
GType rygel_playbin_renderer_get_type (void) {
	static volatile gsize rygel_playbin_renderer_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_playbin_renderer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPlaybinRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_playbin_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlaybinRenderer), 0, (GInstanceInitFunc) rygel_playbin_renderer_instance_init, NULL };
		GType rygel_playbin_renderer_type_id;
		rygel_playbin_renderer_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_DEVICE, "RygelPlaybinRenderer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_playbin_renderer_type_id__volatile, rygel_playbin_renderer_type_id);
	}
	return rygel_playbin_renderer_type_id__volatile;
}



