/* rygel-media-export-metadata-extractor.c generated by valac 0.16.1, the Vala compiler
 * generated from rygel-media-export-metadata-extractor.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-dlna/gupnp-dlna-discoverer.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <rygel-core.h>
#include <gst/gst.h>
#include <libgupnp-dlna/gupnp-dlna-information.h>
#include <gst/pbutils/pbutils.h>
#include <glib/gi18n-lib.h>


#define RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR (rygel_media_export_metadata_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractor))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))

typedef struct _RygelMediaExportMetadataExtractor RygelMediaExportMetadataExtractor;
typedef struct _RygelMediaExportMetadataExtractorClass RygelMediaExportMetadataExtractorClass;
typedef struct _RygelMediaExportMetadataExtractorPrivate RygelMediaExportMetadataExtractorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelMediaExportMetadataExtractor {
	GObject parent_instance;
	RygelMediaExportMetadataExtractorPrivate * priv;
};

struct _RygelMediaExportMetadataExtractorClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportMetadataExtractorPrivate {
	GUPnPDLNADiscoverer* discoverer;
	GeeHashMap* file_hash;
	guint64 timeout;
	gboolean extract_metadata;
};


static gpointer rygel_media_export_metadata_extractor_parent_class = NULL;

GType rygel_media_export_metadata_extractor_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_DUMMY_PROPERTY
};
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_new (void);
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_construct (GType object_type);
void rygel_media_export_metadata_extractor_extract (RygelMediaExportMetadataExtractor* self, GFile* file);
static void rygel_media_export_metadata_extractor_on_done (RygelMediaExportMetadataExtractor* self, GUPnPDLNAInformation* dlna, GError* err);
static void _rygel_media_export_metadata_extractor_on_done_gupnp_dlna_discoverer_done (GUPnPDLNADiscoverer* _sender, GUPnPDLNAInformation* dlna, GError* err, gpointer self);
static void rygel_media_export_metadata_extractor_extract_basic_information (RygelMediaExportMetadataExtractor* self, GFile* file, GUPnPDLNAInformation* dlna);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void rygel_media_export_metadata_extractor_finalize (GObject* obj);


RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_construct (GType object_type) {
	RygelMediaExportMetadataExtractor * self = NULL;
	GeeHashMap* _tmp0_;
	RygelMetaConfig* _tmp1_ = NULL;
	RygelMetaConfig* config;
	gboolean _tmp4_;
	GError * _inner_error_ = NULL;
	self = (RygelMediaExportMetadataExtractor*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->file_hash);
	self->priv->file_hash = _tmp0_;
	_tmp1_ = rygel_meta_config_get_default ();
	config = _tmp1_;
	{
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
		_tmp2_ = rygel_configuration_get_bool ((RygelConfiguration*) config, "MediaExport", "extract-metadata", &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch22_g_error;
		}
		self->priv->extract_metadata = _tmp3_;
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		self->priv->extract_metadata = TRUE;
		_g_error_free0 (_error_);
	}
	__finally22:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = self->priv->extract_metadata;
	if (_tmp4_) {
	}
	_g_object_unref0 (config);
	return self;
}


RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_new (void) {
	return rygel_media_export_metadata_extractor_construct (RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR);
}


static void _rygel_media_export_metadata_extractor_on_done_gupnp_dlna_discoverer_done (GUPnPDLNADiscoverer* _sender, GUPnPDLNAInformation* dlna, GError* err, gpointer self) {
	rygel_media_export_metadata_extractor_on_done (self, dlna, err);
}


void rygel_media_export_metadata_extractor_extract (RygelMediaExportMetadataExtractor* self, GFile* file) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = self->priv->extract_metadata;
	if (_tmp0_) {
		GFile* _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* uri;
		GeeHashMap* _tmp3_;
		const gchar* _tmp4_;
		GFile* _tmp5_;
		guint64 _tmp6_;
		GstClockTime gst_timeout;
		GstClockTime _tmp7_;
		GUPnPDLNADiscoverer* _tmp8_;
		GUPnPDLNADiscoverer* _tmp9_;
		GUPnPDLNADiscoverer* _tmp10_;
		GUPnPDLNADiscoverer* _tmp11_;
		const gchar* _tmp12_;
		_tmp1_ = file;
		_tmp2_ = g_file_get_uri (_tmp1_);
		uri = _tmp2_;
		_tmp3_ = self->priv->file_hash;
		_tmp4_ = uri;
		_tmp5_ = file;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp3_, _tmp4_, _tmp5_);
		_tmp6_ = self->priv->timeout;
		gst_timeout = (GstClockTime) (_tmp6_ * GST_SECOND);
		_tmp7_ = gst_timeout;
		_tmp8_ = gupnp_dlna_discoverer_new (_tmp7_, TRUE, TRUE);
		_g_object_unref0 (self->priv->discoverer);
		self->priv->discoverer = _tmp8_;
		_tmp9_ = self->priv->discoverer;
		g_signal_connect_object (_tmp9_, "done", (GCallback) _rygel_media_export_metadata_extractor_on_done_gupnp_dlna_discoverer_done, self, 0);
		_tmp10_ = self->priv->discoverer;
		gst_discoverer_start ((GstDiscoverer*) _tmp10_);
		_tmp11_ = self->priv->discoverer;
		_tmp12_ = uri;
		gupnp_dlna_discoverer_discover_uri (_tmp11_, _tmp12_);
		_g_free0 (uri);
	} else {
		GFile* _tmp13_;
		_tmp13_ = file;
		rygel_media_export_metadata_extractor_extract_basic_information (self, _tmp13_, NULL);
	}
}


static void rygel_media_export_metadata_extractor_on_done (RygelMediaExportMetadataExtractor* self, GUPnPDLNAInformation* dlna, GError* err) {
	GUPnPDLNADiscoverer* _tmp0_;
	guint _tmp1_ = 0U;
	GeeHashMap* _tmp2_;
	GUPnPDLNAInformation* _tmp3_;
	GstDiscovererInfo* _tmp4_;
	GstDiscovererInfo* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gpointer _tmp7_ = NULL;
	GFile* file;
	GFile* _tmp8_;
	GeeHashMap* _tmp13_;
	GUPnPDLNAInformation* _tmp14_;
	GstDiscovererInfo* _tmp15_;
	GstDiscovererInfo* _tmp16_;
	const gchar* _tmp17_ = NULL;
	GUPnPDLNAInformation* _tmp18_;
	GstDiscovererInfo* _tmp19_;
	GstDiscovererInfo* _tmp20_;
	GstDiscovererResult _tmp21_ = 0;
	GFile* _tmp31_;
	GUPnPDLNAInformation* _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dlna != NULL);
	_tmp0_ = self->priv->discoverer;
	g_signal_parse_name ("done", GUPNP_TYPE_DLNA_DISCOVERER, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _rygel_media_export_metadata_extractor_on_done_gupnp_dlna_discoverer_done, self);
	_g_object_unref0 (self->priv->discoverer);
	self->priv->discoverer = NULL;
	_tmp2_ = self->priv->file_hash;
	_tmp3_ = dlna;
	_tmp4_ = gupnp_dlna_information_get_info (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = gst_discoverer_info_get_uri (_tmp5_);
	_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, _tmp6_);
	file = (GFile*) _tmp7_;
	_tmp8_ = file;
	if (_tmp8_ == NULL) {
		GUPnPDLNAInformation* _tmp9_;
		GstDiscovererInfo* _tmp10_;
		GstDiscovererInfo* _tmp11_;
		const gchar* _tmp12_ = NULL;
		_tmp9_ = dlna;
		_tmp10_ = gupnp_dlna_information_get_info (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = gst_discoverer_info_get_uri (_tmp11_);
		g_warning ("rygel-media-export-metadata-extractor.vala:96: File %s already handled" \
", ignoring event", _tmp12_);
		_g_object_unref0 (file);
		return;
	}
	_tmp13_ = self->priv->file_hash;
	_tmp14_ = dlna;
	_tmp15_ = gupnp_dlna_information_get_info (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = gst_discoverer_info_get_uri (_tmp16_);
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp13_, _tmp17_, NULL);
	_tmp18_ = dlna;
	_tmp19_ = gupnp_dlna_information_get_info (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = gst_discoverer_info_get_result (_tmp20_);
	if ((_tmp21_ & GST_DISCOVERER_TIMEOUT) != 0) {
		GFile* _tmp22_;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_;
		_tmp22_ = file;
		_tmp23_ = g_file_get_uri (_tmp22_);
		_tmp24_ = _tmp23_;
		g_debug ("rygel-media-export-metadata-extractor.vala:105: Extraction timed out o" \
"n %s", _tmp24_);
		_g_free0 (_tmp24_);
		dlna = NULL;
	} else {
		GUPnPDLNAInformation* _tmp25_;
		GstDiscovererInfo* _tmp26_;
		GstDiscovererInfo* _tmp27_;
		GstDiscovererResult _tmp28_ = 0;
		_tmp25_ = dlna;
		_tmp26_ = gupnp_dlna_information_get_info (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = gst_discoverer_info_get_result (_tmp27_);
		if ((_tmp28_ & GST_DISCOVERER_ERROR) != 0) {
			GFile* _tmp29_;
			GError* _tmp30_;
			_tmp29_ = file;
			_tmp30_ = err;
			g_signal_emit_by_name (self, "error", _tmp29_, _tmp30_);
			_g_object_unref0 (file);
			return;
		}
	}
	_tmp31_ = file;
	_tmp32_ = dlna;
	rygel_media_export_metadata_extractor_extract_basic_information (self, _tmp31_, _tmp32_);
	_g_object_unref0 (file);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void rygel_media_export_metadata_extractor_extract_basic_information (RygelMediaExportMetadataExtractor* self, GFile* file, GUPnPDLNAInformation* dlna) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	{
		GFileInfo* file_info = NULL;
		GFile* _tmp11_;
		GUPnPDLNAInformation* _tmp12_;
		{
			GFile* _tmp0_;
			GFileInfo* _tmp1_ = NULL;
			GFileInfo* _tmp2_;
			_tmp0_ = file;
			_tmp1_ = g_file_query_info (_tmp0_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE "," G_FILE_ATTRIBUTE_STANDARD_SIZE "," G_FILE_ATTRIBUTE_TIME_MODIFIED "," G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
			_tmp2_ = _tmp1_;
			if (_inner_error_ != NULL) {
				goto __catch24_g_error;
			}
			_g_object_unref0 (file_info);
			file_info = _tmp2_;
		}
		goto __finally24;
		__catch24_g_error:
		{
			GError* _error_ = NULL;
			const gchar* _tmp3_ = NULL;
			GFile* _tmp4_;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			GFile* _tmp7_;
			GError* _tmp8_;
			GError* _tmp9_;
			GError* _tmp10_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp3_ = _ ("Failed to query content type for '%s'");
			_tmp4_ = file;
			_tmp5_ = g_file_get_uri (_tmp4_);
			_tmp6_ = _tmp5_;
			g_warning (_tmp3_, _tmp6_);
			_g_free0 (_tmp6_);
			_tmp7_ = file;
			_tmp8_ = _error_;
			g_signal_emit_by_name (self, "error", _tmp7_, _tmp8_);
			_tmp9_ = _error_;
			_tmp10_ = _g_error_copy0 (_tmp9_);
			_inner_error_ = _tmp10_;
			_g_error_free0 (_error_);
			goto __finally24;
		}
		__finally24:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file_info);
			goto __catch23_g_error;
		}
		_tmp11_ = file;
		_tmp12_ = dlna;
		g_signal_emit_by_name (self, "extraction-done", _tmp11_, _tmp12_, file_info);
		_g_object_unref0 (file_info);
	}
	goto __finally23;
	__catch23_g_error:
	{
		GError* _error_ = NULL;
		GFile* _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		GError* _tmp16_;
		const gchar* _tmp17_;
		GFile* _tmp18_;
		GError* _tmp19_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = file;
		_tmp14_ = g_file_get_uri (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = _error_;
		_tmp17_ = _tmp16_->message;
		g_debug ("rygel-media-export-metadata-extractor.vala:147: Failed to extract basi" \
"c metadata from %s: %s", _tmp15_, _tmp17_);
		_g_free0 (_tmp15_);
		_tmp18_ = file;
		_tmp19_ = _error_;
		g_signal_emit_by_name (self, "error", _tmp18_, _tmp19_);
		_g_error_free0 (_error_);
	}
	__finally23:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_object (param_values + 3), data2);
}


static void g_cclosure_user_marshal_VOID__OBJECT_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_pointer (param_values + 2), data2);
}


static void rygel_media_export_metadata_extractor_class_init (RygelMediaExportMetadataExtractorClass * klass) {
	rygel_media_export_metadata_extractor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportMetadataExtractorPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_metadata_extractor_finalize;
	g_signal_new ("extraction_done", RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT, G_TYPE_NONE, 3, G_TYPE_FILE, GUPNP_TYPE_DLNA_INFORMATION, g_file_info_get_type ());
	/**
	     * Signalize that an error occured during metadata extraction
	     */
	g_signal_new ("error", RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_POINTER, G_TYPE_NONE, 2, G_TYPE_FILE, G_TYPE_POINTER);
}


static void rygel_media_export_metadata_extractor_instance_init (RygelMediaExportMetadataExtractor * self) {
	self->priv = RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_PRIVATE (self);
	self->priv->timeout = (guint64) 10;
}


static void rygel_media_export_metadata_extractor_finalize (GObject* obj) {
	RygelMediaExportMetadataExtractor * self;
	self = RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR (obj);
	_g_object_unref0 (self->priv->discoverer);
	_g_object_unref0 (self->priv->file_hash);
	G_OBJECT_CLASS (rygel_media_export_metadata_extractor_parent_class)->finalize (obj);
}


/**
 * Metadata extractor based on Gstreamer. Just set the URI of the media on the
 * uri property, it will extact the metadata for you and emit signal
 * metadata_available for each key/value pair extracted.
 */
GType rygel_media_export_metadata_extractor_get_type (void) {
	static volatile gsize rygel_media_export_metadata_extractor_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_metadata_extractor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportMetadataExtractorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_metadata_extractor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportMetadataExtractor), 0, (GInstanceInitFunc) rygel_media_export_metadata_extractor_instance_init, NULL };
		GType rygel_media_export_metadata_extractor_type_id;
		rygel_media_export_metadata_extractor_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportMetadataExtractor", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_metadata_extractor_type_id__volatile, rygel_media_export_metadata_extractor_type_id);
	}
	return rygel_media_export_metadata_extractor_type_id__volatile;
}



