/* alarm.c generated by valac 0.18.0.77-c8a68, the Vala compiler
 * generated from alarm.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <libgd/gd.h>
#include <gio/gio.h>


#define CLOCKS_ALARM_TYPE_ITEM (clocks_alarm_item_get_type ())
#define CLOCKS_ALARM_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem))
#define CLOCKS_ALARM_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItemClass))
#define CLOCKS_ALARM_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_ALARM_TYPE_ITEM))
#define CLOCKS_ALARM_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_ALARM_TYPE_ITEM))
#define CLOCKS_ALARM_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItemClass))

typedef struct _ClocksAlarmItem ClocksAlarmItem;
typedef struct _ClocksAlarmItemClass ClocksAlarmItemClass;
typedef struct _ClocksAlarmItemPrivate ClocksAlarmItemPrivate;

#define CLOCKS_UTILS_TYPE_WEEKDAYS (clocks_utils_weekdays_get_type ())
#define CLOCKS_UTILS_WEEKDAYS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdays))
#define CLOCKS_UTILS_WEEKDAYS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdaysClass))
#define CLOCKS_UTILS_IS_WEEKDAYS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_WEEKDAYS))
#define CLOCKS_UTILS_IS_WEEKDAYS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_WEEKDAYS))
#define CLOCKS_UTILS_WEEKDAYS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdaysClass))

typedef struct _ClocksUtilsWeekdays ClocksUtilsWeekdays;
typedef struct _ClocksUtilsWeekdaysClass ClocksUtilsWeekdaysClass;

#define CLOCKS_ALARM_ITEM_TYPE_STATE (clocks_alarm_item_state_get_type ())

#define CLOCKS_UTILS_TYPE_BELL (clocks_utils_bell_get_type ())
#define CLOCKS_UTILS_BELL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBell))
#define CLOCKS_UTILS_BELL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBellClass))
#define CLOCKS_UTILS_IS_BELL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_BELL))
#define CLOCKS_UTILS_IS_BELL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_BELL))
#define CLOCKS_UTILS_BELL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBellClass))

typedef struct _ClocksUtilsBell ClocksUtilsBell;
typedef struct _ClocksUtilsBellClass ClocksUtilsBellClass;
#define _clocks_utils_weekdays_unref0(var) ((var == NULL) ? NULL : (var = (clocks_utils_weekdays_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CLOCKS_UTILS_TYPE_WALL_CLOCK (clocks_utils_wall_clock_get_type ())
#define CLOCKS_UTILS_WALL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClock))
#define CLOCKS_UTILS_WALL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockClass))
#define CLOCKS_UTILS_IS_WALL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK))
#define CLOCKS_UTILS_IS_WALL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_WALL_CLOCK))
#define CLOCKS_UTILS_WALL_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockClass))

typedef struct _ClocksUtilsWallClock ClocksUtilsWallClock;
typedef struct _ClocksUtilsWallClockClass ClocksUtilsWallClockClass;

#define CLOCKS_UTILS_WEEKDAYS_TYPE_DAY (clocks_utils_weekdays_day_get_type ())
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))

#define CLOCKS_ALARM_TYPE_SETUP_DIALOG (clocks_alarm_setup_dialog_get_type ())
#define CLOCKS_ALARM_SETUP_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_ALARM_TYPE_SETUP_DIALOG, ClocksAlarmSetupDialog))
#define CLOCKS_ALARM_SETUP_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_ALARM_TYPE_SETUP_DIALOG, ClocksAlarmSetupDialogClass))
#define CLOCKS_ALARM_IS_SETUP_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_ALARM_TYPE_SETUP_DIALOG))
#define CLOCKS_ALARM_IS_SETUP_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_ALARM_TYPE_SETUP_DIALOG))
#define CLOCKS_ALARM_SETUP_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_ALARM_TYPE_SETUP_DIALOG, ClocksAlarmSetupDialogClass))

typedef struct _ClocksAlarmSetupDialog ClocksAlarmSetupDialog;
typedef struct _ClocksAlarmSetupDialogClass ClocksAlarmSetupDialogClass;
typedef struct _ClocksAlarmSetupDialogPrivate ClocksAlarmSetupDialogPrivate;

#define CLOCKS_UTILS_WALL_CLOCK_TYPE_FORMAT (clocks_utils_wall_clock_format_get_type ())

#define CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON (clocks_am_pm_toggle_button_get_type ())
#define CLOCKS_AM_PM_TOGGLE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON, ClocksAmPmToggleButton))
#define CLOCKS_AM_PM_TOGGLE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON, ClocksAmPmToggleButtonClass))
#define CLOCKS_IS_AM_PM_TOGGLE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON))
#define CLOCKS_IS_AM_PM_TOGGLE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON))
#define CLOCKS_AM_PM_TOGGLE_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_AM_PM_TOGGLE_BUTTON, ClocksAmPmToggleButtonClass))

typedef struct _ClocksAmPmToggleButton ClocksAmPmToggleButton;
typedef struct _ClocksAmPmToggleButtonClass ClocksAmPmToggleButtonClass;

#define CLOCKS_AM_PM_TOGGLE_BUTTON_TYPE_AM_PM (clocks_am_pm_toggle_button_am_pm_get_type ())

#define CLOCKS_ALARM_TYPE_STANDALONE_PANEL (clocks_alarm_standalone_panel_get_type ())
#define CLOCKS_ALARM_STANDALONE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_ALARM_TYPE_STANDALONE_PANEL, ClocksAlarmStandalonePanel))
#define CLOCKS_ALARM_STANDALONE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_ALARM_TYPE_STANDALONE_PANEL, ClocksAlarmStandalonePanelClass))
#define CLOCKS_ALARM_IS_STANDALONE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_ALARM_TYPE_STANDALONE_PANEL))
#define CLOCKS_ALARM_IS_STANDALONE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_ALARM_TYPE_STANDALONE_PANEL))
#define CLOCKS_ALARM_STANDALONE_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_ALARM_TYPE_STANDALONE_PANEL, ClocksAlarmStandalonePanelClass))

typedef struct _ClocksAlarmStandalonePanel ClocksAlarmStandalonePanel;
typedef struct _ClocksAlarmStandalonePanelClass ClocksAlarmStandalonePanelClass;
typedef struct _ClocksAlarmStandalonePanelPrivate ClocksAlarmStandalonePanelPrivate;

#define CLOCKS_TYPE_CLOCK (clocks_clock_get_type ())
#define CLOCKS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CLOCK, ClocksClock))
#define CLOCKS_IS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CLOCK))
#define CLOCKS_CLOCK_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CLOCK, ClocksClockIface))

typedef struct _ClocksClock ClocksClock;
typedef struct _ClocksClockIface ClocksClockIface;

#define CLOCKS_TYPE_TOOLBAR (clocks_toolbar_get_type ())
#define CLOCKS_TOOLBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_TOOLBAR, ClocksToolbar))
#define CLOCKS_TOOLBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_TOOLBAR, ClocksToolbarClass))
#define CLOCKS_IS_TOOLBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_TOOLBAR))
#define CLOCKS_IS_TOOLBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_TOOLBAR))
#define CLOCKS_TOOLBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_TOOLBAR, ClocksToolbarClass))

typedef struct _ClocksToolbar ClocksToolbar;
typedef struct _ClocksToolbarClass ClocksToolbarClass;

#define CLOCKS_ALARM_TYPE_MAIN_PANEL (clocks_alarm_main_panel_get_type ())
#define CLOCKS_ALARM_MAIN_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_ALARM_TYPE_MAIN_PANEL, ClocksAlarmMainPanel))
#define CLOCKS_ALARM_MAIN_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_ALARM_TYPE_MAIN_PANEL, ClocksAlarmMainPanelClass))
#define CLOCKS_ALARM_IS_MAIN_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_ALARM_TYPE_MAIN_PANEL))
#define CLOCKS_ALARM_IS_MAIN_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_ALARM_TYPE_MAIN_PANEL))
#define CLOCKS_ALARM_MAIN_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_ALARM_TYPE_MAIN_PANEL, ClocksAlarmMainPanelClass))

typedef struct _ClocksAlarmMainPanel ClocksAlarmMainPanel;
typedef struct _ClocksAlarmMainPanelClass ClocksAlarmMainPanelClass;
typedef struct _ClocksAlarmMainPanelPrivate ClocksAlarmMainPanelPrivate;

#define CLOCKS_TYPE_ICON_VIEW (clocks_icon_view_get_type ())
#define CLOCKS_ICON_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_ICON_VIEW, ClocksIconView))
#define CLOCKS_ICON_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_ICON_VIEW, ClocksIconViewClass))
#define CLOCKS_IS_ICON_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_ICON_VIEW))
#define CLOCKS_IS_ICON_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_ICON_VIEW))
#define CLOCKS_ICON_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_ICON_VIEW, ClocksIconViewClass))

typedef struct _ClocksIconView ClocksIconView;
typedef struct _ClocksIconViewClass ClocksIconViewClass;

#define CLOCKS_TYPE_CONTENT_VIEW (clocks_content_view_get_type ())
#define CLOCKS_CONTENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CONTENT_VIEW, ClocksContentView))
#define CLOCKS_CONTENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_CONTENT_VIEW, ClocksContentViewClass))
#define CLOCKS_IS_CONTENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CONTENT_VIEW))
#define CLOCKS_IS_CONTENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_CONTENT_VIEW))
#define CLOCKS_CONTENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_CONTENT_VIEW, ClocksContentViewClass))

typedef struct _ClocksContentView ClocksContentView;
typedef struct _ClocksContentViewClass ClocksContentViewClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _Block3Data Block3Data;

#define CLOCKS_ICON_VIEW_TYPE_COLUMN (clocks_icon_view_column_get_type ())

#define CLOCKS_TYPE_DIGITAL_CLOCK_RENDERER (clocks_digital_clock_renderer_get_type ())
#define CLOCKS_DIGITAL_CLOCK_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_DIGITAL_CLOCK_RENDERER, ClocksDigitalClockRenderer))
#define CLOCKS_DIGITAL_CLOCK_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_DIGITAL_CLOCK_RENDERER, ClocksDigitalClockRendererClass))
#define CLOCKS_IS_DIGITAL_CLOCK_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_DIGITAL_CLOCK_RENDERER))
#define CLOCKS_IS_DIGITAL_CLOCK_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_DIGITAL_CLOCK_RENDERER))
#define CLOCKS_DIGITAL_CLOCK_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_DIGITAL_CLOCK_RENDERER, ClocksDigitalClockRendererClass))

typedef struct _ClocksDigitalClockRenderer ClocksDigitalClockRenderer;
typedef struct _ClocksDigitalClockRendererClass ClocksDigitalClockRendererClass;
typedef struct _Block4Data Block4Data;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define __g_list_free__gtk_tree_path_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_tree_path_free0_ (var), NULL)))

#define CLOCKS_TOOLBAR_TYPE_MODE (clocks_toolbar_mode_get_type ())
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))

struct _ClocksAlarmItem {
	GObject parent_instance;
	ClocksAlarmItemPrivate * priv;
};

struct _ClocksAlarmItemClass {
	GObjectClass parent_class;
	void (*ring) (ClocksAlarmItem* self);
};

typedef enum  {
	CLOCKS_ALARM_ITEM_STATE_READY,
	CLOCKS_ALARM_ITEM_STATE_RINGING,
	CLOCKS_ALARM_ITEM_STATE_SNOOZING
} ClocksAlarmItemState;

struct _ClocksAlarmItemPrivate {
	gint _hour;
	gint _minute;
	ClocksUtilsWeekdays* _days;
	ClocksAlarmItemState _state;
	gchar* _name;
	gboolean _active;
	GDateTime* alarm_time;
	GDateTime* snooze_time;
	GDateTime* ring_end_time;
	ClocksUtilsBell* bell;
};

typedef enum  {
	CLOCKS_UTILS_WEEKDAYS_DAY_MON,
	CLOCKS_UTILS_WEEKDAYS_DAY_TUE,
	CLOCKS_UTILS_WEEKDAYS_DAY_WED,
	CLOCKS_UTILS_WEEKDAYS_DAY_THU,
	CLOCKS_UTILS_WEEKDAYS_DAY_FRI,
	CLOCKS_UTILS_WEEKDAYS_DAY_SAT,
	CLOCKS_UTILS_WEEKDAYS_DAY_SUN
} ClocksUtilsWeekdaysDay;

struct _ClocksAlarmSetupDialog {
	GtkDialog parent_instance;
	ClocksAlarmSetupDialogPrivate * priv;
};

struct _ClocksAlarmSetupDialogClass {
	GtkDialogClass parent_class;
};

typedef enum  {
	CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWELVE,
	CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWENTYFOUR
} ClocksUtilsWallClockFormat;

struct _ClocksAlarmSetupDialogPrivate {
	ClocksUtilsWallClockFormat format;
	GtkSpinButton* h_spinbutton;
	GtkSpinButton* m_spinbutton;
	GtkEntry* name_entry;
	ClocksAmPmToggleButton* am_pm_button;
	GtkToggleButton** day_buttons;
	gint day_buttons_length1;
	gint _day_buttons_size_;
	GtkSwitch* active_switch;
};

typedef enum  {
	CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_AM,
	CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_PM
} ClocksAmPmToggleButtonAmPm;

struct _ClocksAlarmStandalonePanel {
	GtkEventBox parent_instance;
	ClocksAlarmStandalonePanelPrivate * priv;
};

struct _ClocksAlarmStandalonePanelClass {
	GtkEventBoxClass parent_class;
};

struct _ClocksAlarmStandalonePanelPrivate {
	ClocksAlarmItem* _alarm;
	GtkLabel* time_label;
	GtkButton* stop_button;
	GtkButton* snooze_button;
};

struct _ClocksClockIface {
	GTypeInterface parent_iface;
	void (*activate_new) (ClocksClock* self);
	void (*activate_select_all) (ClocksClock* self);
	void (*activate_select_none) (ClocksClock* self);
	void (*update_toolbar) (ClocksClock* self);
	const gchar* (*get_label) (ClocksClock* self);
	void (*set_label) (ClocksClock* self, const gchar* value);
	ClocksToolbar* (*get_toolbar) (ClocksClock* self);
	void (*set_toolbar) (ClocksClock* self, ClocksToolbar* value);
};

struct _ClocksAlarmMainPanel {
	GdStack parent_instance;
	ClocksAlarmMainPanelPrivate * priv;
};

struct _ClocksAlarmMainPanelClass {
	GdStackClass parent_class;
	void (*ring) (ClocksAlarmMainPanel* self);
};

struct _ClocksAlarmMainPanelPrivate {
	gchar* _label;
	ClocksToolbar* _toolbar;
	GList* alarms;
	GSettings* settings;
	ClocksIconView* icon_view;
	ClocksContentView* content_view;
	ClocksAlarmStandalonePanel* standalone;
};

struct _Block3Data {
	int _ref_count_;
	ClocksAlarmMainPanel * self;
	gulong id;
	ClocksToolbar* toolbar;
};

typedef enum  {
	CLOCKS_ICON_VIEW_COLUMN_SELECTED,
	CLOCKS_ICON_VIEW_COLUMN_LABEL,
	CLOCKS_ICON_VIEW_COLUMN_ITEM,
	CLOCKS_ICON_VIEW_COLUMN_COLUMNS
} ClocksIconViewColumn;

struct _Block4Data {
	int _ref_count_;
	ClocksAlarmMainPanel * self;
	ClocksAlarmItem* alarm;
	gboolean saved_active;
};

typedef enum  {
	CLOCKS_TOOLBAR_MODE_NORMAL,
	CLOCKS_TOOLBAR_MODE_SELECTION,
	CLOCKS_TOOLBAR_MODE_STANDALONE
} ClocksToolbarMode;


static gpointer clocks_alarm_item_parent_class = NULL;
static gpointer clocks_alarm_setup_dialog_parent_class = NULL;
static gpointer clocks_alarm_standalone_panel_parent_class = NULL;
static gpointer clocks_alarm_main_panel_parent_class = NULL;
static ClocksClockIface* clocks_alarm_main_panel_clocks_clock_parent_iface = NULL;

GType clocks_alarm_item_get_type (void) G_GNUC_CONST;
gpointer clocks_utils_weekdays_ref (gpointer instance);
void clocks_utils_weekdays_unref (gpointer instance);
GParamSpec* clocks_utils_param_spec_weekdays (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void clocks_utils_value_set_weekdays (GValue* value, gpointer v_object);
void clocks_utils_value_take_weekdays (GValue* value, gpointer v_object);
gpointer clocks_utils_value_get_weekdays (const GValue* value);
GType clocks_utils_weekdays_get_type (void) G_GNUC_CONST;
GType clocks_alarm_item_state_get_type (void) G_GNUC_CONST;
GType clocks_utils_bell_get_type (void) G_GNUC_CONST;
#define CLOCKS_ALARM_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItemPrivate))
enum  {
	CLOCKS_ALARM_ITEM_DUMMY_PROPERTY,
	CLOCKS_ALARM_ITEM_NAME,
	CLOCKS_ALARM_ITEM_HOUR,
	CLOCKS_ALARM_ITEM_MINUTE,
	CLOCKS_ALARM_ITEM_DAYS,
	CLOCKS_ALARM_ITEM_REPEAT_LABEL,
	CLOCKS_ALARM_ITEM_STATE,
	CLOCKS_ALARM_ITEM_TIME_LABEL,
	CLOCKS_ALARM_ITEM_SNOOZE_TIME_LABEL,
	CLOCKS_ALARM_ITEM_ACTIVE
};
#define CLOCKS_ALARM_ITEM_SNOOZE_MINUTES 9
#define CLOCKS_ALARM_ITEM_RING_MINUTES 3
ClocksAlarmItem* clocks_alarm_item_new (void);
ClocksAlarmItem* clocks_alarm_item_construct (GType object_type);
ClocksUtilsBell* clocks_utils_bell_new (const gchar* soundid, const gchar* title, const gchar* msg);
ClocksUtilsBell* clocks_utils_bell_construct (GType object_type, const gchar* soundid, const gchar* title, const gchar* msg);
ClocksUtilsWeekdays* clocks_utils_weekdays_new (void);
ClocksUtilsWeekdays* clocks_utils_weekdays_construct (GType object_type);
void clocks_alarm_item_set_days (ClocksAlarmItem* self, ClocksUtilsWeekdays* value);
ClocksAlarmItem* clocks_alarm_item_new_with_data (const gchar* name, gboolean active, gint hour, gint minute, ClocksUtilsWeekdays* days);
ClocksAlarmItem* clocks_alarm_item_construct_with_data (GType object_type, const gchar* name, gboolean active, gint hour, gint minute, ClocksUtilsWeekdays* days);
void clocks_alarm_item_reset (ClocksAlarmItem* self);
static void clocks_alarm_item_update_alarm_time (ClocksAlarmItem* self);
static void clocks_alarm_item_update_snooze_time (ClocksAlarmItem* self, GDateTime* start_time);
static void clocks_alarm_item_set_state (ClocksAlarmItem* self, ClocksAlarmItemState value);
GType clocks_utils_wall_clock_get_type (void) G_GNUC_CONST;
ClocksUtilsWallClock* clocks_utils_wall_clock_get_default (void);
GDateTime* clocks_utils_wall_clock_get_date_time (ClocksUtilsWallClock* self);
GTimeZone* clocks_utils_wall_clock_get_timezone (ClocksUtilsWallClock* self);
gint clocks_alarm_item_get_hour (ClocksAlarmItem* self);
gint clocks_alarm_item_get_minute (ClocksAlarmItem* self);
ClocksUtilsWeekdays* clocks_alarm_item_get_days (ClocksAlarmItem* self);
gboolean clocks_utils_weekdays_get_empty (ClocksUtilsWeekdays* self);
GType clocks_utils_weekdays_day_get_type (void) G_GNUC_CONST;
gboolean clocks_utils_weekdays_get (ClocksUtilsWeekdays* self, ClocksUtilsWeekdaysDay d);
static void clocks_alarm_item_start_ringing (ClocksAlarmItem* self, GDateTime* now);
void clocks_alarm_item_snooze (ClocksAlarmItem* self);
void clocks_utils_bell_stop (ClocksUtilsBell* self);
void clocks_alarm_item_stop (ClocksAlarmItem* self);
gboolean clocks_alarm_item_tick (ClocksAlarmItem* self);
gboolean clocks_alarm_item_get_active (ClocksAlarmItem* self);
ClocksAlarmItemState clocks_alarm_item_get_state (ClocksAlarmItem* self);
void clocks_alarm_item_serialize (ClocksAlarmItem* self, GVariantBuilder* builder);
const gchar* clocks_alarm_item_get_name (ClocksAlarmItem* self);
GVariant* clocks_utils_weekdays_serialize (ClocksUtilsWeekdays* self);
ClocksAlarmItem* clocks_alarm_item_deserialize (GVariant* alarm_variant);
ClocksUtilsWeekdays* clocks_utils_weekdays_deserialize (GVariant* days_variant);
void clocks_alarm_item_set_name (ClocksAlarmItem* self, const gchar* value);
void clocks_alarm_item_set_hour (ClocksAlarmItem* self, gint value);
void clocks_alarm_item_set_minute (ClocksAlarmItem* self, gint value);
gchar* clocks_alarm_item_get_repeat_label (ClocksAlarmItem* self);
gchar* clocks_utils_weekdays_get_label (ClocksUtilsWeekdays* self);
gchar* clocks_alarm_item_get_time_label (ClocksAlarmItem* self);
gchar* clocks_utils_wall_clock_format_time (ClocksUtilsWallClock* self, GDateTime* date_time);
gchar* clocks_alarm_item_get_snooze_time_label (ClocksAlarmItem* self);
void clocks_alarm_item_set_active (ClocksAlarmItem* self, gboolean value);
static void clocks_alarm_item_real_ring (ClocksAlarmItem* self);
void clocks_utils_bell_ring (ClocksUtilsBell* self);
static void clocks_alarm_item_finalize (GObject* obj);
static void _vala_clocks_alarm_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_clocks_alarm_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType clocks_alarm_setup_dialog_get_type (void) G_GNUC_CONST;
GType clocks_utils_wall_clock_format_get_type (void) G_GNUC_CONST;
GType clocks_am_pm_toggle_button_get_type (void) G_GNUC_CONST;
#define CLOCKS_ALARM_SETUP_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_ALARM_TYPE_SETUP_DIALOG, ClocksAlarmSetupDialogPrivate))
enum  {
	CLOCKS_ALARM_SETUP_DIALOG_DUMMY_PROPERTY
};
ClocksAlarmSetupDialog* clocks_alarm_setup_dialog_new (GtkWindow* parent, ClocksAlarmItem* alarm);
ClocksAlarmSetupDialog* clocks_alarm_setup_dialog_construct (GType object_type, GtkWindow* parent, ClocksAlarmItem* alarm);
ClocksUtilsWallClockFormat clocks_utils_wall_clock_get_format (ClocksUtilsWallClock* self);
ClocksAmPmToggleButton* clocks_am_pm_toggle_button_new (void);
ClocksAmPmToggleButton* clocks_am_pm_toggle_button_construct (GType object_type);
GtkBuilder* clocks_utils_load_ui (const gchar* ui);
static gboolean clocks_alarm_setup_dialog_show_leading_zeros (ClocksAlarmSetupDialog* self, GtkSpinButton* spin_button);
static gboolean _clocks_alarm_setup_dialog_show_leading_zeros_gtk_spin_button_output (GtkSpinButton* _sender, gpointer self);
gchar* clocks_utils_weekdays_abbreviation (ClocksUtilsWeekdaysDay d);
ClocksUtilsWeekdaysDay clocks_utils_weekdays_get_first_weekday (void);
void clocks_alarm_setup_dialog_set_from_alarm (ClocksAlarmSetupDialog* self, ClocksAlarmItem* alarm);
GType clocks_am_pm_toggle_button_am_pm_get_type (void) G_GNUC_CONST;
void clocks_am_pm_toggle_button_set_choice (ClocksAmPmToggleButton* self, ClocksAmPmToggleButtonAmPm value);
void clocks_alarm_setup_dialog_apply_to_alarm (ClocksAlarmSetupDialog* self, ClocksAlarmItem* alarm);
ClocksAmPmToggleButtonAmPm clocks_am_pm_toggle_button_get_choice (ClocksAmPmToggleButton* self);
void clocks_utils_weekdays_set (ClocksUtilsWeekdays* self, ClocksUtilsWeekdaysDay d, gboolean on);
static void clocks_alarm_setup_dialog_finalize (GObject* obj);
GType clocks_alarm_standalone_panel_get_type (void) G_GNUC_CONST;
#define CLOCKS_ALARM_STANDALONE_PANEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_ALARM_TYPE_STANDALONE_PANEL, ClocksAlarmStandalonePanelPrivate))
enum  {
	CLOCKS_ALARM_STANDALONE_PANEL_DUMMY_PROPERTY,
	CLOCKS_ALARM_STANDALONE_PANEL_ALARM
};
ClocksAlarmStandalonePanel* clocks_alarm_standalone_panel_new (void);
ClocksAlarmStandalonePanel* clocks_alarm_standalone_panel_construct (GType object_type);
static void __lambda28_ (ClocksAlarmStandalonePanel* self);
ClocksAlarmItem* clocks_alarm_standalone_panel_get_alarm (ClocksAlarmStandalonePanel* self);
static void ___lambda28__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda29_ (ClocksAlarmStandalonePanel* self);
static void ___lambda29__gtk_button_clicked (GtkButton* _sender, gpointer self);
void clocks_alarm_standalone_panel_update (ClocksAlarmStandalonePanel* self);
void clocks_alarm_standalone_panel_set_alarm (ClocksAlarmStandalonePanel* self, ClocksAlarmItem* value);
static void clocks_alarm_standalone_panel_finalize (GObject* obj);
static void _vala_clocks_alarm_standalone_panel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_clocks_alarm_standalone_panel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType clocks_toolbar_get_type (void) G_GNUC_CONST;
GType clocks_clock_get_type (void) G_GNUC_CONST;
GType clocks_alarm_main_panel_get_type (void) G_GNUC_CONST;
GType clocks_icon_view_get_type (void) G_GNUC_CONST;
GType clocks_content_view_get_type (void) G_GNUC_CONST;
#define CLOCKS_ALARM_MAIN_PANEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_ALARM_TYPE_MAIN_PANEL, ClocksAlarmMainPanelPrivate))
enum  {
	CLOCKS_ALARM_MAIN_PANEL_DUMMY_PROPERTY,
	CLOCKS_ALARM_MAIN_PANEL_LABEL,
	CLOCKS_ALARM_MAIN_PANEL_TOOLBAR
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
ClocksAlarmMainPanel* clocks_alarm_main_panel_new (ClocksToolbar* toolbar);
ClocksAlarmMainPanel* clocks_alarm_main_panel_construct (GType object_type, ClocksToolbar* toolbar);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda30_ (ClocksAlarmMainPanel* self, GtkCellLayout* column, GtkCellRenderer* cell, GtkTreeModel* model, GtkTreeIter* iter);
GType clocks_icon_view_column_get_type (void) G_GNUC_CONST;
GType clocks_digital_clock_renderer_get_type (void) G_GNUC_CONST;
void clocks_digital_clock_renderer_set_text (ClocksDigitalClockRenderer* self, const gchar* value);
void clocks_digital_clock_renderer_set_subtext (ClocksDigitalClockRenderer* self, const gchar* value);
void clocks_digital_clock_renderer_set_css_class (ClocksDigitalClockRenderer* self, const gchar* value);
static void ___lambda30__gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self);
ClocksIconView* clocks_icon_view_new (GtkCellLayoutDataFunc thumb_data_func, void* thumb_data_func_target, GDestroyNotify thumb_data_func_target_destroy_notify);
ClocksIconView* clocks_icon_view_construct (GType object_type, GtkCellLayoutDataFunc thumb_data_func, void* thumb_data_func_target, GDestroyNotify thumb_data_func_target_destroy_notify);
static void __lambda31_ (ClocksAlarmMainPanel* self, GtkTreePath* path);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void ___lambda33_ (Block4Data* _data4_, GtkDialog* dialog, gint response);
static void clocks_alarm_main_panel_save (ClocksAlarmMainPanel* self);
static void ____lambda33__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void ___lambda31__gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self);
ClocksContentView* clocks_content_view_new (GtkWidget* e, ClocksIconView* iv, ClocksToolbar* t);
ClocksContentView* clocks_content_view_construct (GType object_type, GtkWidget* e, ClocksIconView* iv, ClocksToolbar* t);
static void __lambda34_ (ClocksAlarmMainPanel* self);
GList* clocks_icon_view_get_selected_items (ClocksIconView* self);
static void _gtk_tree_path_free0_ (gpointer var);
static void _g_list_free__gtk_tree_path_free0_ (GList* self);
void clocks_icon_view_remove_selected (ClocksIconView* self);
static void ___lambda34__clocks_content_view_delete_selected (ClocksContentView* _sender, gpointer self);
static void __lambda35_ (ClocksAlarmMainPanel* self);
static void ___lambda35__clocks_alarm_standalone_panel_dismiss (ClocksAlarmStandalonePanel* _sender, gpointer self);
static void clocks_alarm_main_panel_load (ClocksAlarmMainPanel* self);
static void __lambda36_ (Block3Data* _data3_);
GType clocks_toolbar_mode_get_type (void) G_GNUC_CONST;
void clocks_toolbar_set_mode (ClocksToolbar* self, ClocksToolbarMode value);
static void ___lambda36__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda37_ (Block3Data* _data3_);
static void ___lambda37__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static void __lambda38_ (ClocksAlarmMainPanel* self);
static void ___lambda38__clocks_utils_wall_clock_tick (ClocksUtilsWallClock* _sender, gpointer self);
void clocks_icon_view_add_item (ClocksIconView* self, const gchar* name, GObject* item);
static void clocks_alarm_main_panel_real_activate_new (ClocksClock* base);
static void __lambda39_ (ClocksAlarmMainPanel* self, GtkDialog* dialog, gint response);
static void ___lambda39__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void clocks_alarm_main_panel_real_activate_select_all (ClocksClock* base);
void clocks_icon_view_select_all (ClocksIconView* self);
static void clocks_alarm_main_panel_real_activate_select_none (ClocksClock* base);
void clocks_icon_view_unselect_all (ClocksIconView* self);
static void clocks_alarm_main_panel_real_update_toolbar (ClocksClock* base);
ClocksToolbar* clocks_clock_get_toolbar (ClocksClock* self);
ClocksToolbarMode clocks_toolbar_get_mode (ClocksToolbar* self);
GtkButton* clocks_toolbar_add_button (ClocksToolbar* self, const gchar* icon_name, const gchar* label, gboolean pack_start);
static void ___lambda40_ (ClocksAlarmMainPanel* self);
void clocks_clock_activate_new (ClocksClock* self);
static void ____lambda40__gtk_button_clicked (GtkButton* _sender, gpointer self);
void clocks_content_view_update_toolbar (ClocksContentView* self);
static void clocks_alarm_main_panel_real_ring (ClocksAlarmMainPanel* self);
static void clocks_alarm_main_panel_finalize (GObject* obj);
const gchar* clocks_clock_get_label (ClocksClock* self);
static void _vala_clocks_alarm_main_panel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void clocks_clock_set_label (ClocksClock* self, const gchar* value);
void clocks_clock_set_toolbar (ClocksClock* self, ClocksToolbar* value);
static void _vala_clocks_alarm_main_panel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType clocks_alarm_item_state_get_type (void) {
	static volatile gsize clocks_alarm_item_state_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_alarm_item_state_type_id__volatile)) {
		static const GEnumValue values[] = {{CLOCKS_ALARM_ITEM_STATE_READY, "CLOCKS_ALARM_ITEM_STATE_READY", "ready"}, {CLOCKS_ALARM_ITEM_STATE_RINGING, "CLOCKS_ALARM_ITEM_STATE_RINGING", "ringing"}, {CLOCKS_ALARM_ITEM_STATE_SNOOZING, "CLOCKS_ALARM_ITEM_STATE_SNOOZING", "snoozing"}, {0, NULL, NULL}};
		GType clocks_alarm_item_state_type_id;
		clocks_alarm_item_state_type_id = g_enum_register_static ("ClocksAlarmItemState", values);
		g_once_init_leave (&clocks_alarm_item_state_type_id__volatile, clocks_alarm_item_state_type_id);
	}
	return clocks_alarm_item_state_type_id__volatile;
}


ClocksAlarmItem* clocks_alarm_item_construct (GType object_type) {
	ClocksAlarmItem * self = NULL;
	const gchar* _tmp0_ = NULL;
	ClocksUtilsBell* _tmp1_;
	ClocksUtilsWeekdays* _tmp2_;
	ClocksUtilsWeekdays* _tmp3_;
	self = (ClocksAlarmItem*) g_object_new (object_type, NULL);
	_tmp0_ = _ ("Alarm");
	_tmp1_ = clocks_utils_bell_new ("alarm-clock-elapsed", _tmp0_, "");
	_g_object_unref0 (self->priv->bell);
	self->priv->bell = _tmp1_;
	_tmp2_ = clocks_utils_weekdays_new ();
	_tmp3_ = _tmp2_;
	clocks_alarm_item_set_days (self, _tmp3_);
	_clocks_utils_weekdays_unref0 (_tmp3_);
	return self;
}


ClocksAlarmItem* clocks_alarm_item_new (void) {
	return clocks_alarm_item_construct (CLOCKS_ALARM_TYPE_ITEM);
}


ClocksAlarmItem* clocks_alarm_item_construct_with_data (GType object_type, const gchar* name, gboolean active, gint hour, gint minute, ClocksUtilsWeekdays* days) {
	ClocksAlarmItem * self = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ClocksUtilsWeekdays* _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	ClocksUtilsBell* _tmp7_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (days != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = active;
	_tmp2_ = hour;
	_tmp3_ = minute;
	_tmp4_ = days;
	self = (ClocksAlarmItem*) g_object_new (object_type, "name", _tmp0_, "active", _tmp1_, "hour", _tmp2_, "minute", _tmp3_, "days", _tmp4_, NULL);
	_tmp5_ = _ ("Alarm");
	_tmp6_ = name;
	_tmp7_ = clocks_utils_bell_new ("alarm-clock-elapsed", _tmp5_, _tmp6_);
	_g_object_unref0 (self->priv->bell);
	self->priv->bell = _tmp7_;
	clocks_alarm_item_reset (self);
	return self;
}


ClocksAlarmItem* clocks_alarm_item_new_with_data (const gchar* name, gboolean active, gint hour, gint minute, ClocksUtilsWeekdays* days) {
	return clocks_alarm_item_construct_with_data (CLOCKS_ALARM_TYPE_ITEM, name, active, hour, minute, days);
}


void clocks_alarm_item_reset (ClocksAlarmItem* self) {
	GDateTime* _tmp0_;
	g_return_if_fail (self != NULL);
	clocks_alarm_item_update_alarm_time (self);
	_tmp0_ = self->priv->alarm_time;
	clocks_alarm_item_update_snooze_time (self, _tmp0_);
	clocks_alarm_item_set_state (self, CLOCKS_ALARM_ITEM_STATE_READY);
}


static gpointer _g_date_time_ref0 (gpointer self) {
	return self ? g_date_time_ref (self) : NULL;
}


static void clocks_alarm_item_update_alarm_time (ClocksAlarmItem* self) {
	ClocksUtilsWallClock* _tmp0_ = NULL;
	ClocksUtilsWallClock* wallclock;
	ClocksUtilsWallClock* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* now;
	ClocksUtilsWallClock* _tmp5_;
	GTimeZone* _tmp6_;
	GTimeZone* _tmp7_;
	GDateTime* _tmp8_;
	gint _tmp9_ = 0;
	GDateTime* _tmp10_;
	gint _tmp11_ = 0;
	GDateTime* _tmp12_;
	gint _tmp13_ = 0;
	gint _tmp14_;
	gint _tmp15_;
	GDateTime* _tmp16_;
	GDateTime* dt;
	ClocksUtilsWeekdays* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	GDateTime* _tmp36_;
	GDateTime* _tmp37_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clocks_utils_wall_clock_get_default ();
	wallclock = _tmp0_;
	_tmp1_ = wallclock;
	_tmp2_ = clocks_utils_wall_clock_get_date_time (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_date_time_ref0 (_tmp3_);
	now = _tmp4_;
	_tmp5_ = wallclock;
	_tmp6_ = clocks_utils_wall_clock_get_timezone (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = now;
	_tmp9_ = g_date_time_get_year (_tmp8_);
	_tmp10_ = now;
	_tmp11_ = g_date_time_get_month (_tmp10_);
	_tmp12_ = now;
	_tmp13_ = g_date_time_get_day_of_month (_tmp12_);
	_tmp14_ = self->priv->_hour;
	_tmp15_ = self->priv->_minute;
	_tmp16_ = g_date_time_new (_tmp7_, _tmp9_, _tmp11_, _tmp13_, _tmp14_, _tmp15_, (gdouble) 0);
	dt = _tmp16_;
	_tmp17_ = self->priv->_days;
	_tmp18_ = clocks_utils_weekdays_get_empty (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_) {
		GDateTime* _tmp20_;
		GDateTime* _tmp21_;
		gint _tmp22_ = 0;
		_tmp20_ = dt;
		_tmp21_ = now;
		_tmp22_ = g_date_time_compare (_tmp20_, _tmp21_);
		if (_tmp22_ <= 0) {
			GDateTime* _tmp23_;
			GDateTime* _tmp24_ = NULL;
			_tmp23_ = dt;
			_tmp24_ = g_date_time_add_days (_tmp23_, 1);
			_g_date_time_unref0 (dt);
			dt = _tmp24_;
		}
	} else {
		while (TRUE) {
			gboolean _tmp25_ = FALSE;
			GDateTime* _tmp26_;
			GDateTime* _tmp27_;
			gint _tmp28_ = 0;
			gboolean _tmp33_;
			GDateTime* _tmp34_;
			GDateTime* _tmp35_ = NULL;
			_tmp26_ = dt;
			_tmp27_ = now;
			_tmp28_ = g_date_time_compare (_tmp26_, _tmp27_);
			if (_tmp28_ <= 0) {
				_tmp25_ = TRUE;
			} else {
				ClocksUtilsWeekdays* _tmp29_;
				GDateTime* _tmp30_;
				gint _tmp31_ = 0;
				gboolean _tmp32_ = FALSE;
				_tmp29_ = self->priv->_days;
				_tmp30_ = dt;
				_tmp31_ = g_date_time_get_day_of_week (_tmp30_);
				_tmp32_ = clocks_utils_weekdays_get (_tmp29_, (ClocksUtilsWeekdaysDay) (_tmp31_ - 1));
				_tmp25_ = !_tmp32_;
			}
			_tmp33_ = _tmp25_;
			if (!_tmp33_) {
				break;
			}
			_tmp34_ = dt;
			_tmp35_ = g_date_time_add_days (_tmp34_, 1);
			_g_date_time_unref0 (dt);
			dt = _tmp35_;
		}
	}
	_tmp36_ = dt;
	_tmp37_ = _g_date_time_ref0 (_tmp36_);
	_g_date_time_unref0 (self->priv->alarm_time);
	self->priv->alarm_time = _tmp37_;
	_g_date_time_unref0 (dt);
	_g_date_time_unref0 (now);
	_g_object_unref0 (wallclock);
}


static void clocks_alarm_item_update_snooze_time (ClocksAlarmItem* self, GDateTime* start_time) {
	GDateTime* _tmp0_;
	GDateTime* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (start_time != NULL);
	_tmp0_ = start_time;
	_tmp1_ = g_date_time_add_minutes (_tmp0_, CLOCKS_ALARM_ITEM_SNOOZE_MINUTES);
	_g_date_time_unref0 (self->priv->snooze_time);
	self->priv->snooze_time = _tmp1_;
}


static void clocks_alarm_item_start_ringing (ClocksAlarmItem* self, GDateTime* now) {
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (now != NULL);
	_tmp0_ = now;
	clocks_alarm_item_update_snooze_time (self, _tmp0_);
	_tmp1_ = now;
	_tmp2_ = g_date_time_add_minutes (_tmp1_, CLOCKS_ALARM_ITEM_RING_MINUTES);
	_g_date_time_unref0 (self->priv->ring_end_time);
	self->priv->ring_end_time = _tmp2_;
	clocks_alarm_item_set_state (self, CLOCKS_ALARM_ITEM_STATE_RINGING);
	g_signal_emit_by_name (self, "ring");
}


void clocks_alarm_item_snooze (ClocksAlarmItem* self) {
	ClocksUtilsBell* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bell;
	clocks_utils_bell_stop (_tmp0_);
	clocks_alarm_item_set_state (self, CLOCKS_ALARM_ITEM_STATE_SNOOZING);
}


void clocks_alarm_item_stop (ClocksAlarmItem* self) {
	ClocksUtilsBell* _tmp0_;
	GDateTime* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bell;
	clocks_utils_bell_stop (_tmp0_);
	_tmp1_ = self->priv->alarm_time;
	clocks_alarm_item_update_snooze_time (self, _tmp1_);
	clocks_alarm_item_set_state (self, CLOCKS_ALARM_ITEM_STATE_READY);
}


gboolean clocks_alarm_item_tick (ClocksAlarmItem* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ClocksAlarmItemState _tmp2_;
	ClocksAlarmItemState last_state;
	ClocksUtilsWallClock* _tmp3_ = NULL;
	ClocksUtilsWallClock* wallclock;
	ClocksUtilsWallClock* _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* now;
	gboolean _tmp8_ = FALSE;
	ClocksAlarmItemState _tmp9_;
	gboolean _tmp13_;
	gboolean _tmp14_ = FALSE;
	ClocksAlarmItemState _tmp15_;
	gboolean _tmp19_;
	gboolean _tmp21_ = FALSE;
	ClocksAlarmItemState _tmp22_;
	gboolean _tmp26_;
	ClocksAlarmItemState _tmp28_;
	ClocksAlarmItemState _tmp29_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = clocks_alarm_item_get_active (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->_state;
	last_state = _tmp2_;
	_tmp3_ = clocks_utils_wall_clock_get_default ();
	wallclock = _tmp3_;
	_tmp4_ = wallclock;
	_tmp5_ = clocks_utils_wall_clock_get_date_time (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_date_time_ref0 (_tmp6_);
	now = _tmp7_;
	_tmp9_ = self->priv->_state;
	if (_tmp9_ == CLOCKS_ALARM_ITEM_STATE_RINGING) {
		GDateTime* _tmp10_;
		GDateTime* _tmp11_;
		gint _tmp12_ = 0;
		_tmp10_ = now;
		_tmp11_ = self->priv->ring_end_time;
		_tmp12_ = g_date_time_compare (_tmp10_, _tmp11_);
		_tmp8_ = _tmp12_ > 0;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp13_ = _tmp8_;
	if (_tmp13_) {
		clocks_alarm_item_stop (self);
	}
	_tmp15_ = self->priv->_state;
	if (_tmp15_ == CLOCKS_ALARM_ITEM_STATE_SNOOZING) {
		GDateTime* _tmp16_;
		GDateTime* _tmp17_;
		gint _tmp18_ = 0;
		_tmp16_ = now;
		_tmp17_ = self->priv->snooze_time;
		_tmp18_ = g_date_time_compare (_tmp16_, _tmp17_);
		_tmp14_ = _tmp18_ > 0;
	} else {
		_tmp14_ = FALSE;
	}
	_tmp19_ = _tmp14_;
	if (_tmp19_) {
		GDateTime* _tmp20_;
		_tmp20_ = now;
		clocks_alarm_item_start_ringing (self, _tmp20_);
	}
	_tmp22_ = self->priv->_state;
	if (_tmp22_ == CLOCKS_ALARM_ITEM_STATE_READY) {
		GDateTime* _tmp23_;
		GDateTime* _tmp24_;
		gint _tmp25_ = 0;
		_tmp23_ = now;
		_tmp24_ = self->priv->alarm_time;
		_tmp25_ = g_date_time_compare (_tmp23_, _tmp24_);
		_tmp21_ = _tmp25_ > 0;
	} else {
		_tmp21_ = FALSE;
	}
	_tmp26_ = _tmp21_;
	if (_tmp26_) {
		GDateTime* _tmp27_;
		_tmp27_ = now;
		clocks_alarm_item_start_ringing (self, _tmp27_);
		clocks_alarm_item_update_alarm_time (self);
	}
	_tmp28_ = self->priv->_state;
	_tmp29_ = last_state;
	result = _tmp28_ != _tmp29_;
	_g_date_time_unref0 (now);
	_g_object_unref0 (wallclock);
	return result;
}


void clocks_alarm_item_serialize (ClocksAlarmItem* self, GVariantBuilder* builder) {
	GVariantBuilder* _tmp0_;
	GVariantType* _tmp1_;
	GVariantType* _tmp2_;
	GVariantBuilder* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	GVariantBuilder* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	GVariant* _tmp11_;
	GVariant* _tmp12_;
	GVariantBuilder* _tmp13_;
	gint _tmp14_;
	GVariant* _tmp15_;
	GVariant* _tmp16_;
	GVariantBuilder* _tmp17_;
	gint _tmp18_;
	GVariant* _tmp19_;
	GVariant* _tmp20_;
	GVariantBuilder* _tmp21_;
	ClocksUtilsWeekdays* _tmp22_;
	GVariant* _tmp23_ = NULL;
	GVariant* _tmp24_;
	GVariantBuilder* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = builder;
	_tmp1_ = g_variant_type_new ("a{sv}");
	_tmp2_ = _tmp1_;
	g_variant_builder_open (_tmp0_, _tmp2_);
	_g_variant_type_free0 (_tmp2_);
	_tmp3_ = builder;
	_tmp4_ = clocks_alarm_item_get_name (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_variant_new_string (_tmp5_);
	g_variant_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	g_variant_builder_add (_tmp3_, "{sv}", "name", _tmp7_, NULL);
	_g_variant_unref0 (_tmp7_);
	_tmp8_ = builder;
	_tmp9_ = clocks_alarm_item_get_active (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_variant_new_boolean (_tmp10_);
	g_variant_ref_sink (_tmp11_);
	_tmp12_ = _tmp11_;
	g_variant_builder_add (_tmp8_, "{sv}", "active", _tmp12_, NULL);
	_g_variant_unref0 (_tmp12_);
	_tmp13_ = builder;
	_tmp14_ = self->priv->_hour;
	_tmp15_ = g_variant_new_int32 ((gint32) _tmp14_);
	g_variant_ref_sink (_tmp15_);
	_tmp16_ = _tmp15_;
	g_variant_builder_add (_tmp13_, "{sv}", "hour", _tmp16_, NULL);
	_g_variant_unref0 (_tmp16_);
	_tmp17_ = builder;
	_tmp18_ = self->priv->_minute;
	_tmp19_ = g_variant_new_int32 ((gint32) _tmp18_);
	g_variant_ref_sink (_tmp19_);
	_tmp20_ = _tmp19_;
	g_variant_builder_add (_tmp17_, "{sv}", "minute", _tmp20_, NULL);
	_g_variant_unref0 (_tmp20_);
	_tmp21_ = builder;
	_tmp22_ = self->priv->_days;
	_tmp23_ = clocks_utils_weekdays_serialize (_tmp22_);
	_tmp24_ = _tmp23_;
	g_variant_builder_add (_tmp21_, "{sv}", "days", _tmp24_, NULL);
	_g_variant_unref0 (_tmp24_);
	_tmp25_ = builder;
	g_variant_builder_close (_tmp25_);
}


ClocksAlarmItem* clocks_alarm_item_deserialize (GVariant* alarm_variant) {
	ClocksAlarmItem* result = NULL;
	gchar* name;
	gboolean active;
	gint hour;
	gint minute;
	ClocksUtilsWeekdays* _tmp0_;
	ClocksUtilsWeekdays* days;
	gboolean _tmp48_ = FALSE;
	gboolean _tmp49_ = FALSE;
	const gchar* _tmp50_;
	gboolean _tmp52_;
	gboolean _tmp54_;
	g_return_val_if_fail (alarm_variant != NULL, NULL);
	name = NULL;
	active = TRUE;
	hour = -1;
	minute = -1;
	_tmp0_ = clocks_utils_weekdays_new ();
	days = _tmp0_;
	{
		GVariant* _tmp1_;
		GVariantIter* _tmp2_ = NULL;
		GVariantIter* _v_it;
		GVariant* v = NULL;
		_tmp1_ = alarm_variant;
		_tmp2_ = g_variant_iter_new (_tmp1_);
		_v_it = _tmp2_;
		while (TRUE) {
			GVariantIter* _tmp3_;
			GVariant* _tmp4_ = NULL;
			GVariant* _tmp5_;
			GVariant* _tmp6_;
			GVariant* _tmp7_ = NULL;
			GVariant* _tmp8_;
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* key;
			const gchar* _tmp12_;
			_tmp3_ = _v_it;
			_tmp4_ = g_variant_iter_next_value (_tmp3_);
			_g_variant_unref0 (v);
			v = _tmp4_;
			_tmp5_ = v;
			if (!(_tmp5_ != NULL)) {
				break;
			}
			_tmp6_ = v;
			_tmp7_ = g_variant_get_child_value (_tmp6_, (gsize) 0);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_variant_get_string (_tmp8_, NULL);
			_tmp10_ = g_strdup (_tmp9_);
			_tmp11_ = _tmp10_;
			_g_variant_unref0 (_tmp8_);
			key = _tmp11_;
			_tmp12_ = key;
			if (g_strcmp0 (_tmp12_, "name") == 0) {
				GVariant* _tmp13_;
				GVariant* _tmp14_ = NULL;
				GVariant* _tmp15_;
				GVariant* _tmp16_ = NULL;
				GVariant* _tmp17_;
				const gchar* _tmp18_ = NULL;
				gchar* _tmp19_;
				_tmp13_ = v;
				_tmp14_ = g_variant_get_child_value (_tmp13_, (gsize) 1);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_variant_get_child_value (_tmp15_, (gsize) 0);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_variant_get_string (_tmp17_, NULL);
				_tmp19_ = g_strdup (_tmp18_);
				_g_free0 (name);
				name = _tmp19_;
				_g_variant_unref0 (_tmp17_);
				_g_variant_unref0 (_tmp15_);
			} else {
				const gchar* _tmp20_;
				_tmp20_ = key;
				if (g_strcmp0 (_tmp20_, "active") == 0) {
					GVariant* _tmp21_;
					GVariant* _tmp22_ = NULL;
					GVariant* _tmp23_;
					GVariant* _tmp24_ = NULL;
					GVariant* _tmp25_;
					gboolean _tmp26_ = FALSE;
					_tmp21_ = v;
					_tmp22_ = g_variant_get_child_value (_tmp21_, (gsize) 1);
					_tmp23_ = _tmp22_;
					_tmp24_ = g_variant_get_child_value (_tmp23_, (gsize) 0);
					_tmp25_ = _tmp24_;
					_tmp26_ = g_variant_get_boolean (_tmp25_);
					active = _tmp26_;
					_g_variant_unref0 (_tmp25_);
					_g_variant_unref0 (_tmp23_);
				} else {
					const gchar* _tmp27_;
					_tmp27_ = key;
					if (g_strcmp0 (_tmp27_, "hour") == 0) {
						GVariant* _tmp28_;
						GVariant* _tmp29_ = NULL;
						GVariant* _tmp30_;
						GVariant* _tmp31_ = NULL;
						GVariant* _tmp32_;
						gint32 _tmp33_ = 0;
						_tmp28_ = v;
						_tmp29_ = g_variant_get_child_value (_tmp28_, (gsize) 1);
						_tmp30_ = _tmp29_;
						_tmp31_ = g_variant_get_child_value (_tmp30_, (gsize) 0);
						_tmp32_ = _tmp31_;
						_tmp33_ = g_variant_get_int32 (_tmp32_);
						hour = (gint) _tmp33_;
						_g_variant_unref0 (_tmp32_);
						_g_variant_unref0 (_tmp30_);
					} else {
						const gchar* _tmp34_;
						_tmp34_ = key;
						if (g_strcmp0 (_tmp34_, "minute") == 0) {
							GVariant* _tmp35_;
							GVariant* _tmp36_ = NULL;
							GVariant* _tmp37_;
							GVariant* _tmp38_ = NULL;
							GVariant* _tmp39_;
							gint32 _tmp40_ = 0;
							_tmp35_ = v;
							_tmp36_ = g_variant_get_child_value (_tmp35_, (gsize) 1);
							_tmp37_ = _tmp36_;
							_tmp38_ = g_variant_get_child_value (_tmp37_, (gsize) 0);
							_tmp39_ = _tmp38_;
							_tmp40_ = g_variant_get_int32 (_tmp39_);
							minute = (gint) _tmp40_;
							_g_variant_unref0 (_tmp39_);
							_g_variant_unref0 (_tmp37_);
						} else {
							const gchar* _tmp41_;
							_tmp41_ = key;
							if (g_strcmp0 (_tmp41_, "days") == 0) {
								GVariant* _tmp42_;
								GVariant* _tmp43_ = NULL;
								GVariant* _tmp44_;
								GVariant* _tmp45_ = NULL;
								GVariant* _tmp46_;
								ClocksUtilsWeekdays* _tmp47_ = NULL;
								_tmp42_ = v;
								_tmp43_ = g_variant_get_child_value (_tmp42_, (gsize) 1);
								_tmp44_ = _tmp43_;
								_tmp45_ = g_variant_get_child_value (_tmp44_, (gsize) 0);
								_tmp46_ = _tmp45_;
								_tmp47_ = clocks_utils_weekdays_deserialize (_tmp46_);
								_clocks_utils_weekdays_unref0 (days);
								days = _tmp47_;
								_g_variant_unref0 (_tmp46_);
								_g_variant_unref0 (_tmp44_);
							}
						}
					}
				}
			}
			_g_free0 (key);
		}
		_g_variant_unref0 (v);
		_g_variant_iter_free0 (_v_it);
	}
	_tmp50_ = name;
	if (_tmp50_ != NULL) {
		gint _tmp51_;
		_tmp51_ = hour;
		_tmp49_ = _tmp51_ >= 0;
	} else {
		_tmp49_ = FALSE;
	}
	_tmp52_ = _tmp49_;
	if (_tmp52_) {
		gint _tmp53_;
		_tmp53_ = minute;
		_tmp48_ = _tmp53_ >= 0;
	} else {
		_tmp48_ = FALSE;
	}
	_tmp54_ = _tmp48_;
	if (_tmp54_) {
		const gchar* _tmp55_;
		gboolean _tmp56_;
		gint _tmp57_;
		gint _tmp58_;
		ClocksUtilsWeekdays* _tmp59_;
		ClocksAlarmItem* _tmp60_;
		_tmp55_ = name;
		_tmp56_ = active;
		_tmp57_ = hour;
		_tmp58_ = minute;
		_tmp59_ = days;
		_tmp60_ = clocks_alarm_item_new_with_data (_tmp55_, _tmp56_, _tmp57_, _tmp58_, _tmp59_);
		result = _tmp60_;
		_clocks_utils_weekdays_unref0 (days);
		_g_free0 (name);
		return result;
	} else {
		const gchar* _tmp61_ = NULL;
		const gchar* _tmp62_;
		const gchar* _tmp64_;
		_tmp62_ = name;
		if (_tmp62_ != NULL) {
			const gchar* _tmp63_;
			_tmp63_ = name;
			_tmp61_ = _tmp63_;
		} else {
			_tmp61_ = "name missing";
		}
		_tmp64_ = _tmp61_;
		g_warning ("alarm.vala:228: Invalid alarm %s", _tmp64_);
	}
	result = NULL;
	_clocks_utils_weekdays_unref0 (days);
	_g_free0 (name);
	return result;
}


const gchar* clocks_alarm_item_get_name (ClocksAlarmItem* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


void clocks_alarm_item_set_name (ClocksAlarmItem* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	ClocksUtilsBell* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	_tmp2_ = _ ("Alarm");
	_tmp3_ = self->priv->_name;
	_tmp4_ = clocks_utils_bell_new ("alarm-clock-elapsed", _tmp2_, _tmp3_);
	_g_object_unref0 (self->priv->bell);
	self->priv->bell = _tmp4_;
	g_object_notify ((GObject *) self, "name");
}


gint clocks_alarm_item_get_hour (ClocksAlarmItem* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_hour;
	result = _tmp0_;
	return result;
}


void clocks_alarm_item_set_hour (ClocksAlarmItem* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_hour = _tmp0_;
	g_object_notify ((GObject *) self, "hour");
}


gint clocks_alarm_item_get_minute (ClocksAlarmItem* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_minute;
	result = _tmp0_;
	return result;
}


void clocks_alarm_item_set_minute (ClocksAlarmItem* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_minute = _tmp0_;
	g_object_notify ((GObject *) self, "minute");
}


ClocksUtilsWeekdays* clocks_alarm_item_get_days (ClocksAlarmItem* self) {
	ClocksUtilsWeekdays* result;
	ClocksUtilsWeekdays* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_days;
	result = _tmp0_;
	return result;
}


static gpointer _clocks_utils_weekdays_ref0 (gpointer self) {
	return self ? clocks_utils_weekdays_ref (self) : NULL;
}


void clocks_alarm_item_set_days (ClocksAlarmItem* self, ClocksUtilsWeekdays* value) {
	ClocksUtilsWeekdays* _tmp0_;
	ClocksUtilsWeekdays* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _clocks_utils_weekdays_ref0 (_tmp0_);
	_clocks_utils_weekdays_unref0 (self->priv->_days);
	self->priv->_days = _tmp1_;
	g_object_notify ((GObject *) self, "days");
}


gchar* clocks_alarm_item_get_repeat_label (ClocksAlarmItem* self) {
	gchar* result;
	ClocksUtilsWeekdays* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_days;
	_tmp1_ = clocks_utils_weekdays_get_label (_tmp0_);
	result = _tmp1_;
	return result;
}


ClocksAlarmItemState clocks_alarm_item_get_state (ClocksAlarmItem* self) {
	ClocksAlarmItemState result;
	ClocksAlarmItemState _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_state;
	result = _tmp0_;
	return result;
}


static void clocks_alarm_item_set_state (ClocksAlarmItem* self, ClocksAlarmItemState value) {
	ClocksAlarmItemState _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_state = _tmp0_;
	g_object_notify ((GObject *) self, "state");
}


gchar* clocks_alarm_item_get_time_label (ClocksAlarmItem* self) {
	gchar* result;
	ClocksUtilsWallClock* _tmp0_ = NULL;
	ClocksUtilsWallClock* _tmp1_;
	GDateTime* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = clocks_utils_wall_clock_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->alarm_time;
	_tmp3_ = clocks_utils_wall_clock_format_time (_tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}


gchar* clocks_alarm_item_get_snooze_time_label (ClocksAlarmItem* self) {
	gchar* result;
	ClocksUtilsWallClock* _tmp0_ = NULL;
	ClocksUtilsWallClock* _tmp1_;
	GDateTime* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = clocks_utils_wall_clock_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->snooze_time;
	_tmp3_ = clocks_utils_wall_clock_format_time (_tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}


gboolean clocks_alarm_item_get_active (ClocksAlarmItem* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_active;
	result = _tmp0_;
	return result;
}


void clocks_alarm_item_set_active (ClocksAlarmItem* self, gboolean value) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = self->priv->_active;
	if (_tmp0_ != _tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = value;
		self->priv->_active = _tmp2_;
		_tmp3_ = self->priv->_active;
		if (_tmp3_) {
			clocks_alarm_item_reset (self);
		} else {
			ClocksAlarmItemState _tmp4_;
			_tmp4_ = self->priv->_state;
			if (_tmp4_ == CLOCKS_ALARM_ITEM_STATE_RINGING) {
				clocks_alarm_item_stop (self);
			}
		}
	}
	g_object_notify ((GObject *) self, "active");
}


static void clocks_alarm_item_real_ring (ClocksAlarmItem* self) {
	ClocksUtilsBell* _tmp0_;
	_tmp0_ = self->priv->bell;
	clocks_utils_bell_ring (_tmp0_);
}


static void clocks_alarm_item_class_init (ClocksAlarmItemClass * klass) {
	clocks_alarm_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksAlarmItemPrivate));
	CLOCKS_ALARM_ITEM_CLASS (klass)->ring = clocks_alarm_item_real_ring;
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_alarm_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_alarm_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_alarm_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_HOUR, g_param_spec_int ("hour", "hour", "hour", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_MINUTE, g_param_spec_int ("minute", "minute", "minute", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_DAYS, clocks_utils_param_spec_weekdays ("days", "days", "days", CLOCKS_UTILS_TYPE_WEEKDAYS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_REPEAT_LABEL, g_param_spec_string ("repeat-label", "repeat-label", "repeat-label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_STATE, g_param_spec_enum ("state", "state", "state", CLOCKS_ALARM_ITEM_TYPE_STATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_TIME_LABEL, g_param_spec_string ("time-label", "time-label", "time-label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_SNOOZE_TIME_LABEL, g_param_spec_string ("snooze-time-label", "snooze-time-label", "snooze-time-label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_ITEM_ACTIVE, g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("ring", CLOCKS_ALARM_TYPE_ITEM, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ClocksAlarmItemClass, ring), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void clocks_alarm_item_instance_init (ClocksAlarmItem * self) {
	self->priv = CLOCKS_ALARM_ITEM_GET_PRIVATE (self);
}


static void clocks_alarm_item_finalize (GObject* obj) {
	ClocksAlarmItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem);
	_clocks_utils_weekdays_unref0 (self->priv->_days);
	_g_free0 (self->priv->_name);
	_g_date_time_unref0 (self->priv->alarm_time);
	_g_date_time_unref0 (self->priv->snooze_time);
	_g_date_time_unref0 (self->priv->ring_end_time);
	_g_object_unref0 (self->priv->bell);
	G_OBJECT_CLASS (clocks_alarm_item_parent_class)->finalize (obj);
}


GType clocks_alarm_item_get_type (void) {
	static volatile gsize clocks_alarm_item_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_alarm_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksAlarmItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_alarm_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksAlarmItem), 0, (GInstanceInitFunc) clocks_alarm_item_instance_init, NULL };
		GType clocks_alarm_item_type_id;
		clocks_alarm_item_type_id = g_type_register_static (G_TYPE_OBJECT, "ClocksAlarmItem", &g_define_type_info, 0);
		g_once_init_leave (&clocks_alarm_item_type_id__volatile, clocks_alarm_item_type_id);
	}
	return clocks_alarm_item_type_id__volatile;
}


static void _vala_clocks_alarm_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksAlarmItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem);
	switch (property_id) {
		case CLOCKS_ALARM_ITEM_NAME:
		g_value_set_string (value, clocks_alarm_item_get_name (self));
		break;
		case CLOCKS_ALARM_ITEM_HOUR:
		g_value_set_int (value, clocks_alarm_item_get_hour (self));
		break;
		case CLOCKS_ALARM_ITEM_MINUTE:
		g_value_set_int (value, clocks_alarm_item_get_minute (self));
		break;
		case CLOCKS_ALARM_ITEM_DAYS:
		clocks_utils_value_set_weekdays (value, clocks_alarm_item_get_days (self));
		break;
		case CLOCKS_ALARM_ITEM_REPEAT_LABEL:
		g_value_take_string (value, clocks_alarm_item_get_repeat_label (self));
		break;
		case CLOCKS_ALARM_ITEM_STATE:
		g_value_set_enum (value, clocks_alarm_item_get_state (self));
		break;
		case CLOCKS_ALARM_ITEM_TIME_LABEL:
		g_value_take_string (value, clocks_alarm_item_get_time_label (self));
		break;
		case CLOCKS_ALARM_ITEM_SNOOZE_TIME_LABEL:
		g_value_take_string (value, clocks_alarm_item_get_snooze_time_label (self));
		break;
		case CLOCKS_ALARM_ITEM_ACTIVE:
		g_value_set_boolean (value, clocks_alarm_item_get_active (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_alarm_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksAlarmItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem);
	switch (property_id) {
		case CLOCKS_ALARM_ITEM_NAME:
		clocks_alarm_item_set_name (self, g_value_get_string (value));
		break;
		case CLOCKS_ALARM_ITEM_HOUR:
		clocks_alarm_item_set_hour (self, g_value_get_int (value));
		break;
		case CLOCKS_ALARM_ITEM_MINUTE:
		clocks_alarm_item_set_minute (self, g_value_get_int (value));
		break;
		case CLOCKS_ALARM_ITEM_DAYS:
		clocks_alarm_item_set_days (self, clocks_utils_value_get_weekdays (value));
		break;
		case CLOCKS_ALARM_ITEM_STATE:
		clocks_alarm_item_set_state (self, g_value_get_enum (value));
		break;
		case CLOCKS_ALARM_ITEM_ACTIVE:
		clocks_alarm_item_set_active (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _clocks_alarm_setup_dialog_show_leading_zeros_gtk_spin_button_output (GtkSpinButton* _sender, gpointer self) {
	gboolean result;
	result = clocks_alarm_setup_dialog_show_leading_zeros (self, _sender);
	return result;
}


ClocksAlarmSetupDialog* clocks_alarm_setup_dialog_construct (GType object_type, GtkWindow* parent, ClocksAlarmItem* alarm) {
	ClocksAlarmSetupDialog * self = NULL;
	GtkWindow* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	ClocksUtilsWallClock* _tmp3_ = NULL;
	ClocksUtilsWallClock* _tmp4_;
	ClocksUtilsWallClockFormat _tmp5_;
	ClocksUtilsWallClockFormat _tmp6_;
	ClocksAmPmToggleButton* _tmp7_;
	GtkBuilder* _tmp8_ = NULL;
	GtkBuilder* builder;
	GtkBuilder* _tmp9_;
	GObject* _tmp10_ = NULL;
	GtkGrid* _tmp11_;
	GtkGrid* grid;
	GtkBuilder* _tmp12_;
	GObject* _tmp13_ = NULL;
	GtkAlignment* _tmp14_;
	GtkAlignment* am_pm_alignment;
	GtkBuilder* _tmp15_;
	GObject* _tmp16_ = NULL;
	GtkSizeGroup* _tmp17_;
	GtkSizeGroup* am_pm_sizegroup;
	GtkBuilder* _tmp18_;
	GObject* _tmp19_ = NULL;
	GtkBox* _tmp20_;
	GtkBox* day_buttons_box;
	GtkBuilder* _tmp21_;
	GObject* _tmp22_ = NULL;
	GtkSpinButton* _tmp23_;
	GtkBuilder* _tmp24_;
	GObject* _tmp25_ = NULL;
	GtkSpinButton* _tmp26_;
	GtkBuilder* _tmp27_;
	GObject* _tmp28_ = NULL;
	GtkEntry* _tmp29_;
	GtkBuilder* _tmp30_;
	GObject* _tmp31_ = NULL;
	GtkSwitch* _tmp32_;
	GtkSpinButton* _tmp33_;
	GtkSpinButton* _tmp34_;
	ClocksUtilsWallClockFormat _tmp35_;
	GtkToggleButton** _tmp45_ = NULL;
	ClocksUtilsWeekdaysDay _tmp60_ = 0;
	ClocksUtilsWeekdaysDay first_weekday;
	GtkBox* _tmp71_ = NULL;
	GtkGrid* _tmp72_;
	ClocksAlarmItem* _tmp73_;
	g_return_val_if_fail (parent != NULL, NULL);
	_tmp0_ = parent;
	_tmp1_ = _ ("New Alarm");
	self = (ClocksAlarmSetupDialog*) g_object_new (object_type, "transient-for", _tmp0_, "modal", TRUE, "title", _tmp1_, NULL);
	_tmp2_ = _ ("_Done");
	gtk_dialog_add_buttons ((GtkDialog*) self, GTK_STOCK_CANCEL, 0, _tmp2_, 1, NULL);
	gtk_dialog_set_default_response ((GtkDialog*) self, 1);
	_tmp3_ = clocks_utils_wall_clock_get_default ();
	_tmp4_ = _tmp3_;
	_tmp5_ = clocks_utils_wall_clock_get_format (_tmp4_);
	_tmp6_ = _tmp5_;
	self->priv->format = _tmp6_;
	_g_object_unref0 (_tmp4_);
	_tmp7_ = clocks_am_pm_toggle_button_new ();
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->am_pm_button);
	self->priv->am_pm_button = _tmp7_;
	_tmp8_ = clocks_utils_load_ui ("alarm.ui");
	builder = _tmp8_;
	_tmp9_ = builder;
	_tmp10_ = gtk_builder_get_object (_tmp9_, "setup_dialog_content");
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, GTK_TYPE_GRID) ? ((GtkGrid*) _tmp10_) : NULL);
	grid = _tmp11_;
	_tmp12_ = builder;
	_tmp13_ = gtk_builder_get_object (_tmp12_, "am_pm_alignment");
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, GTK_TYPE_ALIGNMENT) ? ((GtkAlignment*) _tmp13_) : NULL);
	am_pm_alignment = _tmp14_;
	_tmp15_ = builder;
	_tmp16_ = gtk_builder_get_object (_tmp15_, "am_pm_sizegroup");
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, GTK_TYPE_SIZE_GROUP) ? ((GtkSizeGroup*) _tmp16_) : NULL);
	am_pm_sizegroup = _tmp17_;
	_tmp18_ = builder;
	_tmp19_ = gtk_builder_get_object (_tmp18_, "day_buttons_box");
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, GTK_TYPE_BOX) ? ((GtkBox*) _tmp19_) : NULL);
	day_buttons_box = _tmp20_;
	_tmp21_ = builder;
	_tmp22_ = gtk_builder_get_object (_tmp21_, "h_spinbutton");
	_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, GTK_TYPE_SPIN_BUTTON) ? ((GtkSpinButton*) _tmp22_) : NULL);
	_g_object_unref0 (self->priv->h_spinbutton);
	self->priv->h_spinbutton = _tmp23_;
	_tmp24_ = builder;
	_tmp25_ = gtk_builder_get_object (_tmp24_, "m_spinbutton");
	_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, GTK_TYPE_SPIN_BUTTON) ? ((GtkSpinButton*) _tmp25_) : NULL);
	_g_object_unref0 (self->priv->m_spinbutton);
	self->priv->m_spinbutton = _tmp26_;
	_tmp27_ = builder;
	_tmp28_ = gtk_builder_get_object (_tmp27_, "name_entry");
	_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, GTK_TYPE_ENTRY) ? ((GtkEntry*) _tmp28_) : NULL);
	_g_object_unref0 (self->priv->name_entry);
	self->priv->name_entry = _tmp29_;
	_tmp30_ = builder;
	_tmp31_ = gtk_builder_get_object (_tmp30_, "active_switch");
	_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, GTK_TYPE_SWITCH) ? ((GtkSwitch*) _tmp31_) : NULL);
	_g_object_unref0 (self->priv->active_switch);
	self->priv->active_switch = _tmp32_;
	_tmp33_ = self->priv->h_spinbutton;
	g_signal_connect_object (_tmp33_, "output", (GCallback) _clocks_alarm_setup_dialog_show_leading_zeros_gtk_spin_button_output, self, 0);
	_tmp34_ = self->priv->m_spinbutton;
	g_signal_connect_object (_tmp34_, "output", (GCallback) _clocks_alarm_setup_dialog_show_leading_zeros_gtk_spin_button_output, self, 0);
	_tmp35_ = self->priv->format;
	if (_tmp35_ == CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWENTYFOUR) {
		GtkSpinButton* _tmp36_;
		_tmp36_ = self->priv->h_spinbutton;
		gtk_spin_button_set_range (_tmp36_, (gdouble) 0, (gdouble) 23);
	} else {
		GtkSpinButton* _tmp37_;
		GtkSizeGroup* _tmp38_;
		ClocksAmPmToggleButton* _tmp39_;
		GtkAlignment* _tmp40_;
		GtkAlignment* _tmp41_;
		GtkWidget* _tmp42_ = NULL;
		GtkAlignment* _tmp43_;
		ClocksAmPmToggleButton* _tmp44_;
		_tmp37_ = self->priv->h_spinbutton;
		gtk_spin_button_set_range (_tmp37_, (gdouble) 1, (gdouble) 12);
		_tmp38_ = am_pm_sizegroup;
		_tmp39_ = self->priv->am_pm_button;
		gtk_size_group_add_widget (_tmp38_, (GtkWidget*) _tmp39_);
		_tmp40_ = am_pm_alignment;
		_tmp41_ = am_pm_alignment;
		_tmp42_ = gtk_bin_get_child ((GtkBin*) _tmp41_);
		gtk_container_remove ((GtkContainer*) _tmp40_, _tmp42_);
		_tmp43_ = am_pm_alignment;
		_tmp44_ = self->priv->am_pm_button;
		gtk_container_add ((GtkContainer*) _tmp43_, (GtkWidget*) _tmp44_);
	}
	_tmp45_ = g_new0 (GtkToggleButton*, 7 + 1);
	self->priv->day_buttons = (_vala_array_free (self->priv->day_buttons, self->priv->day_buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->day_buttons = _tmp45_;
	self->priv->day_buttons_length1 = 7;
	self->priv->_day_buttons_size_ = self->priv->day_buttons_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp46_;
			_tmp46_ = TRUE;
			while (TRUE) {
				gboolean _tmp47_;
				gint _tmp49_;
				gint _tmp50_;
				gchar* _tmp51_ = NULL;
				gchar* _tmp52_;
				GtkToggleButton* _tmp53_;
				GtkToggleButton* _tmp54_;
				GtkToggleButton* button;
				GtkToggleButton** _tmp55_;
				gint _tmp55__length1;
				gint _tmp56_;
				GtkToggleButton* _tmp57_;
				GtkToggleButton* _tmp58_;
				GtkToggleButton* _tmp59_;
				_tmp47_ = _tmp46_;
				if (!_tmp47_) {
					gint _tmp48_;
					_tmp48_ = i;
					i = _tmp48_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp49_ = i;
				if (!(_tmp49_ < 7)) {
					break;
				}
				_tmp50_ = i;
				_tmp51_ = clocks_utils_weekdays_abbreviation ((ClocksUtilsWeekdaysDay) _tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = (GtkToggleButton*) gtk_toggle_button_new_with_label (_tmp52_);
				g_object_ref_sink (_tmp53_);
				_tmp54_ = _tmp53_;
				_g_free0 (_tmp52_);
				button = _tmp54_;
				_tmp55_ = self->priv->day_buttons;
				_tmp55__length1 = self->priv->day_buttons_length1;
				_tmp56_ = i;
				_tmp57_ = button;
				_tmp58_ = _g_object_ref0 (_tmp57_);
				_g_object_unref0 (_tmp55_[_tmp56_]);
				_tmp55_[_tmp56_] = _tmp58_;
				_tmp59_ = _tmp55_[_tmp56_];
				_g_object_unref0 (button);
			}
		}
	}
	_tmp60_ = clocks_utils_weekdays_get_first_weekday ();
	first_weekday = _tmp60_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp61_;
			_tmp61_ = TRUE;
			while (TRUE) {
				gboolean _tmp62_;
				gint _tmp64_;
				ClocksUtilsWeekdaysDay _tmp65_;
				gint _tmp66_;
				ClocksUtilsWeekdaysDay day_number;
				GtkBox* _tmp67_;
				GtkToggleButton** _tmp68_;
				gint _tmp68__length1;
				ClocksUtilsWeekdaysDay _tmp69_;
				GtkToggleButton* _tmp70_;
				_tmp62_ = _tmp61_;
				if (!_tmp62_) {
					gint _tmp63_;
					_tmp63_ = i;
					i = _tmp63_ + 1;
				}
				_tmp61_ = FALSE;
				_tmp64_ = i;
				if (!(_tmp64_ < 7)) {
					break;
				}
				_tmp65_ = first_weekday;
				_tmp66_ = i;
				day_number = (_tmp65_ + _tmp66_) % 7;
				_tmp67_ = day_buttons_box;
				_tmp68_ = self->priv->day_buttons;
				_tmp68__length1 = self->priv->day_buttons_length1;
				_tmp69_ = day_number;
				_tmp70_ = _tmp68_[_tmp69_];
				gtk_box_pack_start (_tmp67_, (GtkWidget*) _tmp70_, TRUE, TRUE, (guint) 0);
			}
		}
	}
	_tmp71_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp72_ = grid;
	gtk_container_add ((GtkContainer*) _tmp71_, (GtkWidget*) _tmp72_);
	_tmp73_ = alarm;
	clocks_alarm_setup_dialog_set_from_alarm (self, _tmp73_);
	_g_object_unref0 (day_buttons_box);
	_g_object_unref0 (am_pm_sizegroup);
	_g_object_unref0 (am_pm_alignment);
	_g_object_unref0 (grid);
	_g_object_unref0 (builder);
	return self;
}


ClocksAlarmSetupDialog* clocks_alarm_setup_dialog_new (GtkWindow* parent, ClocksAlarmItem* alarm) {
	return clocks_alarm_setup_dialog_construct (CLOCKS_ALARM_TYPE_SETUP_DIALOG, parent, alarm);
}


void clocks_alarm_setup_dialog_set_from_alarm (ClocksAlarmSetupDialog* self, ClocksAlarmItem* alarm) {
	gchar* name = NULL;
	gboolean active = FALSE;
	gint hour = 0;
	gint minute = 0;
	ClocksUtilsWeekdays* days = NULL;
	ClocksAlarmItem* _tmp0_;
	ClocksUtilsWallClockFormat _tmp28_;
	GtkSpinButton* _tmp34_;
	gint _tmp35_;
	GtkSpinButton* _tmp36_;
	gint _tmp37_;
	GtkEntry* _tmp38_;
	const gchar* _tmp39_;
	ClocksUtilsWeekdays* _tmp40_;
	GtkSwitch* _tmp51_;
	gboolean _tmp52_;
	g_return_if_fail (self != NULL);
	_tmp0_ = alarm;
	if (_tmp0_ == NULL) {
		ClocksUtilsWallClock* _tmp1_ = NULL;
		ClocksUtilsWallClock* wc;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		ClocksUtilsWallClock* _tmp4_;
		GDateTime* _tmp5_;
		GDateTime* _tmp6_;
		gint _tmp7_ = 0;
		ClocksUtilsWallClock* _tmp8_;
		GDateTime* _tmp9_;
		GDateTime* _tmp10_;
		gint _tmp11_ = 0;
		_tmp1_ = clocks_utils_wall_clock_get_default ();
		wc = _tmp1_;
		_tmp2_ = _ ("Alarm");
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (name);
		name = _tmp3_;
		_tmp4_ = wc;
		_tmp5_ = clocks_utils_wall_clock_get_date_time (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_date_time_get_hour (_tmp6_);
		hour = _tmp7_;
		_tmp8_ = wc;
		_tmp9_ = clocks_utils_wall_clock_get_date_time (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_date_time_get_minute (_tmp10_);
		minute = _tmp11_;
		days = NULL;
		active = TRUE;
		_g_object_unref0 (wc);
	} else {
		ClocksAlarmItem* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		ClocksAlarmItem* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		ClocksAlarmItem* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		ClocksAlarmItem* _tmp22_;
		ClocksUtilsWeekdays* _tmp23_;
		ClocksUtilsWeekdays* _tmp24_;
		ClocksAlarmItem* _tmp25_;
		gboolean _tmp26_;
		gboolean _tmp27_;
		_tmp12_ = alarm;
		_tmp13_ = clocks_alarm_item_get_name (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (name);
		name = _tmp15_;
		_tmp16_ = alarm;
		_tmp17_ = clocks_alarm_item_get_hour (_tmp16_);
		_tmp18_ = _tmp17_;
		hour = _tmp18_;
		_tmp19_ = alarm;
		_tmp20_ = clocks_alarm_item_get_minute (_tmp19_);
		_tmp21_ = _tmp20_;
		minute = _tmp21_;
		_tmp22_ = alarm;
		_tmp23_ = clocks_alarm_item_get_days (_tmp22_);
		_tmp24_ = _tmp23_;
		days = _tmp24_;
		_tmp25_ = alarm;
		_tmp26_ = clocks_alarm_item_get_active (_tmp25_);
		_tmp27_ = _tmp26_;
		active = _tmp27_;
	}
	_tmp28_ = self->priv->format;
	if (_tmp28_ == CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWELVE) {
		gint _tmp29_;
		gint _tmp33_;
		_tmp29_ = hour;
		if (_tmp29_ < 12) {
			ClocksAmPmToggleButton* _tmp30_;
			_tmp30_ = self->priv->am_pm_button;
			clocks_am_pm_toggle_button_set_choice (_tmp30_, CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_AM);
		} else {
			ClocksAmPmToggleButton* _tmp31_;
			gint _tmp32_;
			_tmp31_ = self->priv->am_pm_button;
			clocks_am_pm_toggle_button_set_choice (_tmp31_, CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_PM);
			_tmp32_ = hour;
			hour = _tmp32_ - 12;
		}
		_tmp33_ = hour;
		if (_tmp33_ == 0) {
			hour = 12;
		}
	}
	_tmp34_ = self->priv->h_spinbutton;
	_tmp35_ = hour;
	gtk_spin_button_set_value (_tmp34_, (gdouble) _tmp35_);
	_tmp36_ = self->priv->m_spinbutton;
	_tmp37_ = minute;
	gtk_spin_button_set_value (_tmp36_, (gdouble) _tmp37_);
	_tmp38_ = self->priv->name_entry;
	_tmp39_ = name;
	gtk_entry_set_text (_tmp38_, _tmp39_);
	_tmp40_ = days;
	if (_tmp40_ != NULL) {
		{
			gint i;
			i = 0;
			{
				gboolean _tmp41_;
				_tmp41_ = TRUE;
				while (TRUE) {
					gboolean _tmp42_;
					gint _tmp44_;
					GtkToggleButton** _tmp45_;
					gint _tmp45__length1;
					gint _tmp46_;
					GtkToggleButton* _tmp47_;
					ClocksUtilsWeekdays* _tmp48_;
					gint _tmp49_;
					gboolean _tmp50_ = FALSE;
					_tmp42_ = _tmp41_;
					if (!_tmp42_) {
						gint _tmp43_;
						_tmp43_ = i;
						i = _tmp43_ + 1;
					}
					_tmp41_ = FALSE;
					_tmp44_ = i;
					if (!(_tmp44_ < 7)) {
						break;
					}
					_tmp45_ = self->priv->day_buttons;
					_tmp45__length1 = self->priv->day_buttons_length1;
					_tmp46_ = i;
					_tmp47_ = _tmp45_[_tmp46_];
					_tmp48_ = days;
					_tmp49_ = i;
					_tmp50_ = clocks_utils_weekdays_get (_tmp48_, (ClocksUtilsWeekdaysDay) _tmp49_);
					gtk_toggle_button_set_active (_tmp47_, _tmp50_);
				}
			}
		}
	}
	_tmp51_ = self->priv->active_switch;
	_tmp52_ = active;
	gtk_switch_set_active (_tmp51_, _tmp52_);
	_g_free0 (name);
}


void clocks_alarm_setup_dialog_apply_to_alarm (ClocksAlarmSetupDialog* self, ClocksAlarmItem* alarm) {
	GtkEntry* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* name;
	GtkSwitch* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean active;
	GtkSpinButton* _tmp6_;
	gint _tmp7_ = 0;
	gint hour;
	GtkSpinButton* _tmp8_;
	gint _tmp9_ = 0;
	gint minute;
	ClocksUtilsWallClockFormat _tmp10_;
	ClocksAlarmItem* _tmp23_;
	const gchar* _tmp24_;
	ClocksAlarmItem* _tmp25_;
	gboolean _tmp26_;
	ClocksAlarmItem* _tmp27_;
	gint _tmp28_;
	ClocksAlarmItem* _tmp29_;
	gint _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (alarm != NULL);
	_tmp0_ = self->priv->name_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	name = _tmp2_;
	_tmp3_ = self->priv->active_switch;
	_tmp4_ = gtk_switch_get_active (_tmp3_);
	_tmp5_ = _tmp4_;
	active = _tmp5_;
	_tmp6_ = self->priv->h_spinbutton;
	_tmp7_ = gtk_spin_button_get_value_as_int (_tmp6_);
	hour = _tmp7_;
	_tmp8_ = self->priv->m_spinbutton;
	_tmp9_ = gtk_spin_button_get_value_as_int (_tmp8_);
	minute = _tmp9_;
	_tmp10_ = self->priv->format;
	if (_tmp10_ == CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWELVE) {
		ClocksAmPmToggleButton* _tmp11_;
		ClocksAmPmToggleButtonAmPm _tmp12_;
		ClocksAmPmToggleButtonAmPm _tmp13_;
		ClocksAmPmToggleButtonAmPm choice;
		gboolean _tmp14_ = FALSE;
		ClocksAmPmToggleButtonAmPm _tmp15_;
		gboolean _tmp17_;
		_tmp11_ = self->priv->am_pm_button;
		_tmp12_ = clocks_am_pm_toggle_button_get_choice (_tmp11_);
		_tmp13_ = _tmp12_;
		choice = _tmp13_;
		_tmp15_ = choice;
		if (_tmp15_ == CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_AM) {
			gint _tmp16_;
			_tmp16_ = hour;
			_tmp14_ = _tmp16_ == 12;
		} else {
			_tmp14_ = FALSE;
		}
		_tmp17_ = _tmp14_;
		if (_tmp17_) {
			hour = 0;
		} else {
			gboolean _tmp18_ = FALSE;
			ClocksAmPmToggleButtonAmPm _tmp19_;
			gboolean _tmp21_;
			_tmp19_ = choice;
			if (_tmp19_ == CLOCKS_AM_PM_TOGGLE_BUTTON_AM_PM_PM) {
				gint _tmp20_;
				_tmp20_ = hour;
				_tmp18_ = _tmp20_ != 12;
			} else {
				_tmp18_ = FALSE;
			}
			_tmp21_ = _tmp18_;
			if (_tmp21_) {
				gint _tmp22_;
				_tmp22_ = hour;
				hour = _tmp22_ + 12;
			}
		}
	}
	_tmp23_ = alarm;
	_tmp24_ = name;
	clocks_alarm_item_set_name (_tmp23_, _tmp24_);
	_tmp25_ = alarm;
	_tmp26_ = active;
	clocks_alarm_item_set_active (_tmp25_, _tmp26_);
	_tmp27_ = alarm;
	_tmp28_ = hour;
	clocks_alarm_item_set_hour (_tmp27_, _tmp28_);
	_tmp29_ = alarm;
	_tmp30_ = minute;
	clocks_alarm_item_set_minute (_tmp29_, _tmp30_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp31_;
			_tmp31_ = TRUE;
			while (TRUE) {
				gboolean _tmp32_;
				gint _tmp34_;
				ClocksAlarmItem* _tmp35_;
				ClocksUtilsWeekdays* _tmp36_;
				ClocksUtilsWeekdays* _tmp37_;
				gint _tmp38_;
				GtkToggleButton** _tmp39_;
				gint _tmp39__length1;
				gint _tmp40_;
				GtkToggleButton* _tmp41_;
				gboolean _tmp42_;
				gboolean _tmp43_;
				_tmp32_ = _tmp31_;
				if (!_tmp32_) {
					gint _tmp33_;
					_tmp33_ = i;
					i = _tmp33_ + 1;
				}
				_tmp31_ = FALSE;
				_tmp34_ = i;
				if (!(_tmp34_ < 7)) {
					break;
				}
				_tmp35_ = alarm;
				_tmp36_ = clocks_alarm_item_get_days (_tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = i;
				_tmp39_ = self->priv->day_buttons;
				_tmp39__length1 = self->priv->day_buttons_length1;
				_tmp40_ = i;
				_tmp41_ = _tmp39_[_tmp40_];
				_tmp42_ = gtk_toggle_button_get_active (_tmp41_);
				_tmp43_ = _tmp42_;
				clocks_utils_weekdays_set (_tmp37_, (ClocksUtilsWeekdaysDay) _tmp38_, _tmp43_);
			}
		}
	}
	_g_free0 (name);
}


static gboolean clocks_alarm_setup_dialog_show_leading_zeros (ClocksAlarmSetupDialog* self, GtkSpinButton* spin_button) {
	gboolean result = FALSE;
	GtkSpinButton* _tmp0_;
	GtkSpinButton* _tmp1_;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (spin_button != NULL, FALSE);
	_tmp0_ = spin_button;
	_tmp1_ = spin_button;
	_tmp2_ = gtk_spin_button_get_value_as_int (_tmp1_);
	_tmp3_ = g_strdup_printf ("%02i", _tmp2_);
	_tmp4_ = _tmp3_;
	gtk_entry_set_text ((GtkEntry*) _tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
	result = TRUE;
	return result;
}


static void clocks_alarm_setup_dialog_class_init (ClocksAlarmSetupDialogClass * klass) {
	clocks_alarm_setup_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksAlarmSetupDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = clocks_alarm_setup_dialog_finalize;
}


static void clocks_alarm_setup_dialog_instance_init (ClocksAlarmSetupDialog * self) {
	self->priv = CLOCKS_ALARM_SETUP_DIALOG_GET_PRIVATE (self);
}


static void clocks_alarm_setup_dialog_finalize (GObject* obj) {
	ClocksAlarmSetupDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_ALARM_TYPE_SETUP_DIALOG, ClocksAlarmSetupDialog);
	_g_object_unref0 (self->priv->h_spinbutton);
	_g_object_unref0 (self->priv->m_spinbutton);
	_g_object_unref0 (self->priv->name_entry);
	_g_object_unref0 (self->priv->am_pm_button);
	self->priv->day_buttons = (_vala_array_free (self->priv->day_buttons, self->priv->day_buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->active_switch);
	G_OBJECT_CLASS (clocks_alarm_setup_dialog_parent_class)->finalize (obj);
}


GType clocks_alarm_setup_dialog_get_type (void) {
	static volatile gsize clocks_alarm_setup_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_alarm_setup_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksAlarmSetupDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_alarm_setup_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksAlarmSetupDialog), 0, (GInstanceInitFunc) clocks_alarm_setup_dialog_instance_init, NULL };
		GType clocks_alarm_setup_dialog_type_id;
		clocks_alarm_setup_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "ClocksAlarmSetupDialog", &g_define_type_info, 0);
		g_once_init_leave (&clocks_alarm_setup_dialog_type_id__volatile, clocks_alarm_setup_dialog_type_id);
	}
	return clocks_alarm_setup_dialog_type_id__volatile;
}


static void __lambda28_ (ClocksAlarmStandalonePanel* self) {
	ClocksAlarmItem* _tmp0_;
	_tmp0_ = self->priv->_alarm;
	clocks_alarm_item_stop (_tmp0_);
	g_signal_emit_by_name (self, "dismiss");
}


static void ___lambda28__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda28_ (self);
}


static void __lambda29_ (ClocksAlarmStandalonePanel* self) {
	ClocksAlarmItem* _tmp0_;
	_tmp0_ = self->priv->_alarm;
	clocks_alarm_item_snooze (_tmp0_);
	g_signal_emit_by_name (self, "dismiss");
}


static void ___lambda29__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda29_ (self);
}


ClocksAlarmStandalonePanel* clocks_alarm_standalone_panel_construct (GType object_type) {
	ClocksAlarmStandalonePanel * self = NULL;
	GtkStyleContext* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GtkBuilder* _tmp2_ = NULL;
	GtkBuilder* builder;
	GObject* _tmp3_ = NULL;
	GtkGrid* _tmp4_;
	GtkGrid* grid;
	GObject* _tmp5_ = NULL;
	GtkLabel* _tmp6_;
	GObject* _tmp7_ = NULL;
	GtkButton* _tmp8_;
	GObject* _tmp9_ = NULL;
	GtkButton* _tmp10_;
	GtkButton* _tmp11_;
	GtkButton* _tmp12_;
	self = (ClocksAlarmStandalonePanel*) g_object_new (object_type, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "view");
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp1_, "content-view");
	_tmp2_ = clocks_utils_load_ui ("alarm.ui");
	builder = _tmp2_;
	_tmp3_ = gtk_builder_get_object (builder, "ringing_panel");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GTK_TYPE_GRID) ? ((GtkGrid*) _tmp3_) : NULL);
	grid = _tmp4_;
	_tmp5_ = gtk_builder_get_object (builder, "time_label");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp5_) : NULL);
	_g_object_unref0 (self->priv->time_label);
	self->priv->time_label = _tmp6_;
	_tmp7_ = gtk_builder_get_object (builder, "stop_button");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp7_) : NULL);
	_g_object_unref0 (self->priv->stop_button);
	self->priv->stop_button = _tmp8_;
	_tmp9_ = gtk_builder_get_object (builder, "snooze_button");
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp9_) : NULL);
	_g_object_unref0 (self->priv->snooze_button);
	self->priv->snooze_button = _tmp10_;
	_tmp11_ = self->priv->stop_button;
	g_signal_connect_object (_tmp11_, "clicked", (GCallback) ___lambda28__gtk_button_clicked, self, 0);
	_tmp12_ = self->priv->snooze_button;
	g_signal_connect_object (_tmp12_, "clicked", (GCallback) ___lambda29__gtk_button_clicked, self, 0);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) grid);
	_g_object_unref0 (grid);
	_g_object_unref0 (builder);
	return self;
}


ClocksAlarmStandalonePanel* clocks_alarm_standalone_panel_new (void) {
	return clocks_alarm_standalone_panel_construct (CLOCKS_ALARM_TYPE_STANDALONE_PANEL);
}


void clocks_alarm_standalone_panel_update (ClocksAlarmStandalonePanel* self) {
	ClocksAlarmItem* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_alarm;
	if (_tmp0_ != NULL) {
		GtkLabel* _tmp1_;
		ClocksAlarmItem* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = self->priv->time_label;
		_tmp2_ = self->priv->_alarm;
		_tmp3_ = clocks_alarm_item_get_time_label (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		gtk_label_set_text (_tmp1_, _tmp5_);
		_g_free0 (_tmp5_);
	}
}


ClocksAlarmItem* clocks_alarm_standalone_panel_get_alarm (ClocksAlarmStandalonePanel* self) {
	ClocksAlarmItem* result;
	ClocksAlarmItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_alarm;
	result = _tmp0_;
	return result;
}


void clocks_alarm_standalone_panel_set_alarm (ClocksAlarmStandalonePanel* self, ClocksAlarmItem* value) {
	ClocksAlarmItem* _tmp0_;
	ClocksAlarmItem* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_alarm);
	self->priv->_alarm = _tmp1_;
	g_object_notify ((GObject *) self, "alarm");
}


static void clocks_alarm_standalone_panel_class_init (ClocksAlarmStandalonePanelClass * klass) {
	clocks_alarm_standalone_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksAlarmStandalonePanelPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_alarm_standalone_panel_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_alarm_standalone_panel_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_alarm_standalone_panel_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_STANDALONE_PANEL_ALARM, g_param_spec_object ("alarm", "alarm", "alarm", CLOCKS_ALARM_TYPE_ITEM, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("dismiss", CLOCKS_ALARM_TYPE_STANDALONE_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void clocks_alarm_standalone_panel_instance_init (ClocksAlarmStandalonePanel * self) {
	self->priv = CLOCKS_ALARM_STANDALONE_PANEL_GET_PRIVATE (self);
}


static void clocks_alarm_standalone_panel_finalize (GObject* obj) {
	ClocksAlarmStandalonePanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_ALARM_TYPE_STANDALONE_PANEL, ClocksAlarmStandalonePanel);
	_g_object_unref0 (self->priv->_alarm);
	_g_object_unref0 (self->priv->time_label);
	_g_object_unref0 (self->priv->stop_button);
	_g_object_unref0 (self->priv->snooze_button);
	G_OBJECT_CLASS (clocks_alarm_standalone_panel_parent_class)->finalize (obj);
}


GType clocks_alarm_standalone_panel_get_type (void) {
	static volatile gsize clocks_alarm_standalone_panel_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_alarm_standalone_panel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksAlarmStandalonePanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_alarm_standalone_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksAlarmStandalonePanel), 0, (GInstanceInitFunc) clocks_alarm_standalone_panel_instance_init, NULL };
		GType clocks_alarm_standalone_panel_type_id;
		clocks_alarm_standalone_panel_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "ClocksAlarmStandalonePanel", &g_define_type_info, 0);
		g_once_init_leave (&clocks_alarm_standalone_panel_type_id__volatile, clocks_alarm_standalone_panel_type_id);
	}
	return clocks_alarm_standalone_panel_type_id__volatile;
}


static void _vala_clocks_alarm_standalone_panel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksAlarmStandalonePanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_ALARM_TYPE_STANDALONE_PANEL, ClocksAlarmStandalonePanel);
	switch (property_id) {
		case CLOCKS_ALARM_STANDALONE_PANEL_ALARM:
		g_value_set_object (value, clocks_alarm_standalone_panel_get_alarm (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_alarm_standalone_panel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksAlarmStandalonePanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_ALARM_TYPE_STANDALONE_PANEL, ClocksAlarmStandalonePanel);
	switch (property_id) {
		case CLOCKS_ALARM_STANDALONE_PANEL_ALARM:
		clocks_alarm_standalone_panel_set_alarm (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		ClocksAlarmMainPanel * self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->toolbar);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void __lambda30_ (ClocksAlarmMainPanel* self, GtkCellLayout* column, GtkCellRenderer* cell, GtkTreeModel* model, GtkTreeIter* iter) {
	ClocksAlarmItem* alarm = NULL;
	GtkTreeModel* _tmp0_;
	GtkTreeIter _tmp1_;
	GtkCellRenderer* _tmp2_;
	ClocksDigitalClockRenderer* _tmp3_;
	ClocksDigitalClockRenderer* renderer;
	ClocksAlarmItem* _tmp4_;
	ClocksAlarmItemState _tmp5_;
	ClocksAlarmItemState _tmp6_;
	g_return_if_fail (column != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = model;
	_tmp1_ = *iter;
	gtk_tree_model_get (_tmp0_, &_tmp1_, CLOCKS_ICON_VIEW_COLUMN_ITEM, &alarm, -1);
	_tmp2_ = cell;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, CLOCKS_TYPE_DIGITAL_CLOCK_RENDERER, ClocksDigitalClockRenderer));
	renderer = _tmp3_;
	_tmp4_ = alarm;
	_tmp5_ = clocks_alarm_item_get_state (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == CLOCKS_ALARM_ITEM_STATE_SNOOZING) {
		ClocksDigitalClockRenderer* _tmp7_;
		ClocksAlarmItem* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		ClocksDigitalClockRenderer* _tmp12_;
		ClocksAlarmItem* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		ClocksDigitalClockRenderer* _tmp19_;
		_tmp7_ = renderer;
		_tmp8_ = alarm;
		_tmp9_ = clocks_alarm_item_get_snooze_time_label (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_;
		clocks_digital_clock_renderer_set_text (_tmp7_, _tmp11_);
		_g_free0 (_tmp11_);
		_tmp12_ = renderer;
		_tmp13_ = alarm;
		_tmp14_ = clocks_alarm_item_get_time_label (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strdup_printf ("(%s)", _tmp16_);
		_tmp18_ = _tmp17_;
		clocks_digital_clock_renderer_set_subtext (_tmp12_, _tmp18_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
		_tmp19_ = renderer;
		clocks_digital_clock_renderer_set_css_class (_tmp19_, "snoozing");
	} else {
		ClocksDigitalClockRenderer* _tmp20_;
		ClocksAlarmItem* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		ClocksDigitalClockRenderer* _tmp25_;
		ClocksAlarmItem* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		const gchar* _tmp30_ = NULL;
		ClocksAlarmItem* _tmp31_;
		gboolean _tmp32_;
		gboolean _tmp33_;
		ClocksDigitalClockRenderer* _tmp34_;
		const gchar* _tmp35_;
		_tmp20_ = renderer;
		_tmp21_ = alarm;
		_tmp22_ = clocks_alarm_item_get_time_label (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = _tmp23_;
		clocks_digital_clock_renderer_set_text (_tmp20_, _tmp24_);
		_g_free0 (_tmp24_);
		_tmp25_ = renderer;
		_tmp26_ = alarm;
		_tmp27_ = clocks_alarm_item_get_repeat_label (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = _tmp28_;
		clocks_digital_clock_renderer_set_subtext (_tmp25_, _tmp29_);
		_g_free0 (_tmp29_);
		_tmp31_ = alarm;
		_tmp32_ = clocks_alarm_item_get_active (_tmp31_);
		_tmp33_ = _tmp32_;
		if (_tmp33_) {
			_tmp30_ = "active";
		} else {
			_tmp30_ = "inactive";
		}
		_tmp34_ = renderer;
		_tmp35_ = _tmp30_;
		clocks_digital_clock_renderer_set_css_class (_tmp34_, _tmp35_);
	}
	_g_object_unref0 (renderer);
	_g_object_unref0 (alarm);
}


static void ___lambda30__gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self) {
	__lambda30_ (self, cell_layout, cell, tree_model, iter);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		ClocksAlarmMainPanel * self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->alarm);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void ___lambda33_ (Block4Data* _data4_, GtkDialog* dialog, gint response) {
	ClocksAlarmMainPanel * self;
	gint _tmp0_;
	GtkDialog* _tmp6_;
	self = _data4_->self;
	g_return_if_fail (dialog != NULL);
	_tmp0_ = response;
	if (_tmp0_ == 1) {
		GtkDialog* _tmp1_;
		ClocksAlarmItem* _tmp2_;
		ClocksAlarmItem* _tmp3_;
		_tmp1_ = dialog;
		_tmp2_ = _data4_->alarm;
		clocks_alarm_setup_dialog_apply_to_alarm (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CLOCKS_ALARM_TYPE_SETUP_DIALOG, ClocksAlarmSetupDialog), _tmp2_);
		_tmp3_ = _data4_->alarm;
		clocks_alarm_item_reset (_tmp3_);
		clocks_alarm_main_panel_save (self);
	} else {
		ClocksAlarmItem* _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = _data4_->alarm;
		_tmp5_ = _data4_->saved_active;
		clocks_alarm_item_set_active (_tmp4_, _tmp5_);
	}
	_tmp6_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp6_);
}


static void ____lambda33__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	___lambda33_ (self, _sender, response_id);
}


static void __lambda31_ (ClocksAlarmMainPanel* self, GtkTreePath* path) {
	ClocksIconView* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkListStore* _tmp3_;
	GtkListStore* list_store;
	GtkTreeIter i = {0};
	GtkListStore* _tmp4_;
	GtkTreePath* _tmp5_;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->icon_view;
	_tmp1_ = gtk_icon_view_get_model ((GtkIconView*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GTK_TYPE_LIST_STORE, GtkListStore));
	list_store = _tmp3_;
	_tmp4_ = list_store;
	_tmp5_ = path;
	_tmp7_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp4_, &_tmp6_, _tmp5_);
	i = _tmp6_;
	if (_tmp7_) {
		Block4Data* _data4_;
		GtkListStore* _tmp8_;
		GtkTreeIter _tmp9_;
		GtkWidget* _tmp10_ = NULL;
		ClocksAlarmItem* _tmp11_;
		ClocksAlarmSetupDialog* _tmp12_;
		ClocksAlarmSetupDialog* dialog;
		ClocksAlarmItem* _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp15_;
		ClocksAlarmItem* _tmp16_;
		ClocksAlarmSetupDialog* _tmp17_;
		ClocksAlarmSetupDialog* _tmp18_;
		_data4_ = g_slice_new0 (Block4Data);
		_data4_->_ref_count_ = 1;
		_data4_->self = g_object_ref (self);
		_tmp8_ = list_store;
		_tmp9_ = i;
		gtk_tree_model_get ((GtkTreeModel*) _tmp8_, &_tmp9_, CLOCKS_ICON_VIEW_COLUMN_ITEM, &_data4_->alarm, -1);
		_tmp10_ = gtk_widget_get_toplevel ((GtkWidget*) self);
		_tmp11_ = _data4_->alarm;
		_tmp12_ = clocks_alarm_setup_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GTK_TYPE_WINDOW, GtkWindow), _tmp11_);
		g_object_ref_sink (_tmp12_);
		dialog = _tmp12_;
		_tmp13_ = _data4_->alarm;
		_tmp14_ = clocks_alarm_item_get_active (_tmp13_);
		_tmp15_ = _tmp14_;
		_data4_->saved_active = _tmp15_;
		_tmp16_ = _data4_->alarm;
		clocks_alarm_item_set_active (_tmp16_, FALSE);
		_tmp17_ = dialog;
		g_signal_connect_data ((GtkDialog*) _tmp17_, "response", (GCallback) ____lambda33__gtk_dialog_response, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
		_tmp18_ = dialog;
		gtk_widget_show_all ((GtkWidget*) _tmp18_);
		_g_object_unref0 (dialog);
		block4_data_unref (_data4_);
		_data4_ = NULL;
	}
	_g_object_unref0 (list_store);
}


static void ___lambda31__gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self) {
	__lambda31_ (self, path);
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static void _gtk_tree_path_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL));
}


static void _g_list_free__gtk_tree_path_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_tree_path_free0_, NULL);
	g_list_free (self);
}


static void __lambda34_ (ClocksAlarmMainPanel* self) {
	ClocksIconView* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkListStore* _tmp3_;
	GtkListStore* list_store;
	ClocksIconView* _tmp4_;
	GList* _tmp5_ = NULL;
	ClocksIconView* _tmp14_;
	_tmp0_ = self->priv->icon_view;
	_tmp1_ = gtk_icon_view_get_model ((GtkIconView*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GTK_TYPE_LIST_STORE, GtkListStore));
	list_store = _tmp3_;
	_tmp4_ = self->priv->icon_view;
	_tmp5_ = clocks_icon_view_get_selected_items (_tmp4_);
	{
		GList* path_collection = NULL;
		GList* path_it = NULL;
		path_collection = _tmp5_;
		for (path_it = path_collection; path_it != NULL; path_it = path_it->next) {
			GtkTreePath* _tmp6_;
			GtkTreePath* path = NULL;
			_tmp6_ = _gtk_tree_path_copy0 ((GtkTreePath*) path_it->data);
			path = _tmp6_;
			{
				GtkTreeIter i = {0};
				GtkListStore* _tmp7_;
				GtkTreePath* _tmp8_;
				GtkTreeIter _tmp9_ = {0};
				gboolean _tmp10_ = FALSE;
				_tmp7_ = list_store;
				_tmp8_ = path;
				_tmp10_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp7_, &_tmp9_, _tmp8_);
				i = _tmp9_;
				if (_tmp10_) {
					ClocksAlarmItem* location = NULL;
					GtkListStore* _tmp11_;
					GtkTreeIter _tmp12_;
					ClocksAlarmItem* _tmp13_;
					_tmp11_ = list_store;
					_tmp12_ = i;
					gtk_tree_model_get ((GtkTreeModel*) _tmp11_, &_tmp12_, CLOCKS_ICON_VIEW_COLUMN_ITEM, &location, -1);
					_tmp13_ = location;
					self->priv->alarms = g_list_remove (self->priv->alarms, _tmp13_);
					_g_object_unref0 (location);
				}
				_gtk_tree_path_free0 (path);
			}
		}
		__g_list_free__gtk_tree_path_free0_0 (path_collection);
	}
	_tmp14_ = self->priv->icon_view;
	clocks_icon_view_remove_selected (_tmp14_);
	clocks_alarm_main_panel_save (self);
	_g_object_unref0 (list_store);
}


static void ___lambda34__clocks_content_view_delete_selected (ClocksContentView* _sender, gpointer self) {
	__lambda34_ (self);
}


static void __lambda35_ (ClocksAlarmMainPanel* self) {
	ClocksContentView* _tmp0_;
	_tmp0_ = self->priv->content_view;
	gd_stack_set_visible_child ((GdStack*) self, (GtkWidget*) _tmp0_);
}


static void ___lambda35__clocks_alarm_standalone_panel_dismiss (ClocksAlarmStandalonePanel* _sender, gpointer self) {
	__lambda35_ (self);
}


static void __lambda36_ (Block3Data* _data3_) {
	ClocksAlarmMainPanel * self;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	ClocksContentView* _tmp2_;
	self = _data3_->self;
	_tmp0_ = gd_stack_get_visible_child ((GdStack*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->content_view;
	if (_tmp1_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GTK_TYPE_WIDGET, GtkWidget)) {
		ClocksToolbar* _tmp3_;
		_tmp3_ = _data3_->toolbar;
		clocks_toolbar_set_mode (_tmp3_, CLOCKS_TOOLBAR_MODE_NORMAL);
	} else {
		GtkWidget* _tmp4_;
		GtkWidget* _tmp5_;
		ClocksAlarmStandalonePanel* _tmp6_;
		_tmp4_ = gd_stack_get_visible_child ((GdStack*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->standalone;
		if (_tmp5_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GTK_TYPE_WIDGET, GtkWidget)) {
			ClocksToolbar* _tmp7_;
			_tmp7_ = _data3_->toolbar;
			clocks_toolbar_set_mode (_tmp7_, CLOCKS_TOOLBAR_MODE_STANDALONE);
		}
	}
}


static void ___lambda36__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda36_ (self);
}


static void __lambda37_ (Block3Data* _data3_) {
	ClocksAlarmMainPanel * self;
	self = _data3_->self;
	g_signal_handler_disconnect ((GObject*) self, _data3_->id);
	_data3_->id = (gulong) 0;
}


static void ___lambda37__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	__lambda37_ (self);
}


static void __lambda38_ (ClocksAlarmMainPanel* self) {
	GList* _tmp0_;
	_tmp0_ = self->priv->alarms;
	{
		GList* a_collection = NULL;
		GList* a_it = NULL;
		a_collection = _tmp0_;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			ClocksAlarmItem* _tmp1_;
			ClocksAlarmItem* a = NULL;
			_tmp1_ = _g_object_ref0 ((ClocksAlarmItem*) a_it->data);
			a = _tmp1_;
			{
				ClocksAlarmItem* _tmp2_;
				gboolean _tmp3_ = FALSE;
				_tmp2_ = a;
				_tmp3_ = clocks_alarm_item_tick (_tmp2_);
				if (_tmp3_) {
					ClocksAlarmItem* _tmp4_;
					ClocksAlarmItemState _tmp5_;
					ClocksAlarmItemState _tmp6_;
					_tmp4_ = a;
					_tmp5_ = clocks_alarm_item_get_state (_tmp4_);
					_tmp6_ = _tmp5_;
					if (_tmp6_ == CLOCKS_ALARM_ITEM_STATE_RINGING) {
						ClocksAlarmStandalonePanel* _tmp7_;
						ClocksAlarmItem* _tmp8_;
						ClocksAlarmStandalonePanel* _tmp9_;
						_tmp7_ = self->priv->standalone;
						_tmp8_ = a;
						clocks_alarm_standalone_panel_set_alarm (_tmp7_, _tmp8_);
						_tmp9_ = self->priv->standalone;
						clocks_alarm_standalone_panel_update (_tmp9_);
						g_signal_emit_by_name (self, "ring");
					} else {
						ClocksAlarmStandalonePanel* _tmp10_;
						ClocksAlarmItem* _tmp11_;
						ClocksAlarmItem* _tmp12_;
						ClocksAlarmItem* _tmp13_;
						_tmp10_ = self->priv->standalone;
						_tmp11_ = clocks_alarm_standalone_panel_get_alarm (_tmp10_);
						_tmp12_ = _tmp11_;
						_tmp13_ = a;
						if (_tmp12_ == _tmp13_) {
							ClocksAlarmStandalonePanel* _tmp14_;
							_tmp14_ = self->priv->standalone;
							clocks_alarm_standalone_panel_update (_tmp14_);
						}
					}
				}
				_g_object_unref0 (a);
			}
		}
	}
}


static void ___lambda38__clocks_utils_wall_clock_tick (ClocksUtilsWallClock* _sender, gpointer self) {
	__lambda38_ (self);
}


ClocksAlarmMainPanel* clocks_alarm_main_panel_construct (GType object_type, ClocksToolbar* toolbar) {
	ClocksAlarmMainPanel * self = NULL;
	Block3Data* _data3_;
	ClocksToolbar* _tmp0_;
	ClocksToolbar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	ClocksToolbar* _tmp3_;
	GSettings* _tmp4_;
	ClocksIconView* _tmp5_;
	ClocksIconView* _tmp6_;
	GtkBuilder* _tmp7_ = NULL;
	GtkBuilder* builder;
	GObject* _tmp8_ = NULL;
	GtkWidget* _tmp9_;
	GtkWidget* empty_view;
	ClocksIconView* _tmp10_;
	ClocksToolbar* _tmp11_;
	ClocksContentView* _tmp12_;
	ClocksContentView* _tmp13_;
	ClocksContentView* _tmp14_;
	ClocksAlarmStandalonePanel* _tmp15_;
	ClocksAlarmStandalonePanel* _tmp16_;
	ClocksAlarmStandalonePanel* _tmp17_;
	gulong _tmp18_ = 0UL;
	ClocksToolbar* _tmp19_;
	ClocksContentView* _tmp20_;
	ClocksUtilsWallClock* _tmp21_ = NULL;
	ClocksUtilsWallClock* _tmp22_;
	g_return_val_if_fail (toolbar != NULL, NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_tmp0_ = toolbar;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data3_->toolbar);
	_data3_->toolbar = _tmp1_;
	_tmp2_ = _ ("Alarm");
	_tmp3_ = _data3_->toolbar;
	self = (ClocksAlarmMainPanel*) g_object_new (object_type, "label", _tmp2_, "toolbar", _tmp3_, NULL);
	_data3_->self = g_object_ref (self);
	__g_list_free__g_object_unref0_0 (self->priv->alarms);
	self->priv->alarms = NULL;
	_tmp4_ = g_settings_new ("org.gnome.clocks");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp4_;
	_tmp5_ = clocks_icon_view_new (___lambda30__gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->icon_view);
	self->priv->icon_view = _tmp5_;
	_tmp6_ = self->priv->icon_view;
	g_signal_connect_object ((GtkIconView*) _tmp6_, "item-activated", (GCallback) ___lambda31__gtk_icon_view_item_activated, self, 0);
	_tmp7_ = clocks_utils_load_ui ("alarm.ui");
	builder = _tmp7_;
	_tmp8_ = gtk_builder_get_object (builder, "empty_panel");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, GTK_TYPE_WIDGET) ? ((GtkWidget*) _tmp8_) : NULL);
	empty_view = _tmp9_;
	_tmp10_ = self->priv->icon_view;
	_tmp11_ = _data3_->toolbar;
	_tmp12_ = clocks_content_view_new (empty_view, _tmp10_, _tmp11_);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->content_view);
	self->priv->content_view = _tmp12_;
	_tmp13_ = self->priv->content_view;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp13_);
	_tmp14_ = self->priv->content_view;
	g_signal_connect_object (_tmp14_, "delete-selected", (GCallback) ___lambda34__clocks_content_view_delete_selected, self, 0);
	_tmp15_ = clocks_alarm_standalone_panel_new ();
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->standalone);
	self->priv->standalone = _tmp15_;
	_tmp16_ = self->priv->standalone;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp16_);
	_tmp17_ = self->priv->standalone;
	g_signal_connect_object (_tmp17_, "dismiss", (GCallback) ___lambda35__clocks_alarm_standalone_panel_dismiss, self, 0);
	clocks_alarm_main_panel_load (self);
	_tmp18_ = g_signal_connect_data ((GObject*) self, "notify::visible-child", (GCallback) ___lambda36__g_object_notify, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_data3_->id = _tmp18_;
	_tmp19_ = _data3_->toolbar;
	g_signal_connect_data ((GtkWidget*) _tmp19_, "destroy", (GCallback) ___lambda37__gtk_widget_destroy, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp20_ = self->priv->content_view;
	gd_stack_set_visible_child ((GdStack*) self, (GtkWidget*) _tmp20_);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp21_ = clocks_utils_wall_clock_get_default ();
	_tmp22_ = _tmp21_;
	g_signal_connect_object (_tmp22_, "tick", (GCallback) ___lambda38__clocks_utils_wall_clock_tick, self, 0);
	_g_object_unref0 (_tmp22_);
	_g_object_unref0 (empty_view);
	_g_object_unref0 (builder);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return self;
}


ClocksAlarmMainPanel* clocks_alarm_main_panel_new (ClocksToolbar* toolbar) {
	return clocks_alarm_main_panel_construct (CLOCKS_ALARM_TYPE_MAIN_PANEL, toolbar);
}


static void clocks_alarm_main_panel_load (ClocksAlarmMainPanel* self) {
	g_return_if_fail (self != NULL);
	{
		GSettings* _tmp0_;
		GVariant* _tmp1_ = NULL;
		GVariant* _tmp2_;
		GVariantIter* _tmp3_ = NULL;
		GVariantIter* _tmp4_;
		GVariantIter* _a_it;
		GVariant* a = NULL;
		_tmp0_ = self->priv->settings;
		_tmp1_ = g_settings_get_value (_tmp0_, "alarms");
		_tmp2_ = _tmp1_;
		_tmp3_ = g_variant_iter_new (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_variant_unref0 (_tmp2_);
		_a_it = _tmp4_;
		while (TRUE) {
			GVariantIter* _tmp5_;
			GVariant* _tmp6_ = NULL;
			GVariant* _tmp7_;
			GVariant* _tmp8_;
			ClocksAlarmItem* _tmp9_ = NULL;
			ClocksAlarmItem* alarm;
			ClocksAlarmItem* _tmp10_;
			_tmp5_ = _a_it;
			_tmp6_ = g_variant_iter_next_value (_tmp5_);
			_g_variant_unref0 (a);
			a = _tmp6_;
			_tmp7_ = a;
			if (!(_tmp7_ != NULL)) {
				break;
			}
			_tmp8_ = a;
			_tmp9_ = clocks_alarm_item_deserialize (_tmp8_);
			alarm = _tmp9_;
			_tmp10_ = alarm;
			if (_tmp10_ != NULL) {
				ClocksAlarmItem* _tmp11_;
				ClocksAlarmItem* _tmp12_;
				ClocksIconView* _tmp13_;
				ClocksAlarmItem* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				ClocksAlarmItem* _tmp17_;
				_tmp11_ = alarm;
				_tmp12_ = _g_object_ref0 (_tmp11_);
				self->priv->alarms = g_list_prepend (self->priv->alarms, _tmp12_);
				_tmp13_ = self->priv->icon_view;
				_tmp14_ = alarm;
				_tmp15_ = clocks_alarm_item_get_name (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = alarm;
				clocks_icon_view_add_item (_tmp13_, _tmp16_, (GObject*) _tmp17_);
			}
			_g_object_unref0 (alarm);
		}
		_g_variant_unref0 (a);
		_g_variant_iter_free0 (_a_it);
	}
	self->priv->alarms = g_list_reverse (self->priv->alarms);
}


static void clocks_alarm_main_panel_save (ClocksAlarmMainPanel* self) {
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* builder;
	GList* _tmp4_;
	GSettings* _tmp8_;
	GVariantBuilder* _tmp9_;
	GVariant* _tmp10_ = NULL;
	GVariant* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_variant_type_new ("aa{sv}");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	builder = _tmp3_;
	_tmp4_ = self->priv->alarms;
	{
		GList* i_collection = NULL;
		GList* i_it = NULL;
		i_collection = _tmp4_;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			ClocksAlarmItem* _tmp5_;
			ClocksAlarmItem* i = NULL;
			_tmp5_ = _g_object_ref0 ((ClocksAlarmItem*) i_it->data);
			i = _tmp5_;
			{
				ClocksAlarmItem* _tmp6_;
				GVariantBuilder* _tmp7_;
				_tmp6_ = i;
				_tmp7_ = builder;
				clocks_alarm_item_serialize (_tmp6_, _tmp7_);
				_g_object_unref0 (i);
			}
		}
	}
	_tmp8_ = self->priv->settings;
	_tmp9_ = builder;
	_tmp10_ = g_variant_builder_end (_tmp9_);
	g_variant_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	g_settings_set_value (_tmp8_, "alarms", _tmp11_);
	_g_variant_unref0 (_tmp11_);
	_g_variant_builder_unref0 (builder);
}


static void __lambda39_ (ClocksAlarmMainPanel* self, GtkDialog* dialog, gint response) {
	gint _tmp0_;
	GtkDialog* _tmp12_;
	g_return_if_fail (dialog != NULL);
	_tmp0_ = response;
	if (_tmp0_ == 1) {
		ClocksAlarmItem* _tmp1_;
		ClocksAlarmItem* alarm;
		GtkDialog* _tmp2_;
		ClocksAlarmItem* _tmp3_;
		ClocksAlarmItem* _tmp4_;
		ClocksAlarmItem* _tmp5_;
		ClocksIconView* _tmp6_;
		ClocksAlarmItem* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		ClocksAlarmItem* _tmp10_;
		ClocksAlarmItem* _tmp11_;
		_tmp1_ = clocks_alarm_item_new ();
		alarm = _tmp1_;
		_tmp2_ = dialog;
		_tmp3_ = alarm;
		clocks_alarm_setup_dialog_apply_to_alarm (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, CLOCKS_ALARM_TYPE_SETUP_DIALOG, ClocksAlarmSetupDialog), _tmp3_);
		_tmp4_ = alarm;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		self->priv->alarms = g_list_append (self->priv->alarms, _tmp5_);
		_tmp6_ = self->priv->icon_view;
		_tmp7_ = alarm;
		_tmp8_ = clocks_alarm_item_get_name (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = alarm;
		clocks_icon_view_add_item (_tmp6_, _tmp9_, (GObject*) _tmp10_);
		_tmp11_ = alarm;
		clocks_alarm_item_reset (_tmp11_);
		clocks_alarm_main_panel_save (self);
		_g_object_unref0 (alarm);
	}
	_tmp12_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp12_);
}


static void ___lambda39__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda39_ (self, _sender, response_id);
}


static void clocks_alarm_main_panel_real_activate_new (ClocksClock* base) {
	ClocksAlarmMainPanel * self;
	GtkWidget* _tmp0_ = NULL;
	ClocksAlarmSetupDialog* _tmp1_;
	ClocksAlarmSetupDialog* dialog;
	self = (ClocksAlarmMainPanel*) base;
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = clocks_alarm_setup_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GTK_TYPE_WINDOW, GtkWindow), NULL);
	g_object_ref_sink (_tmp1_);
	dialog = _tmp1_;
	g_signal_connect_object ((GtkDialog*) dialog, "response", (GCallback) ___lambda39__gtk_dialog_response, self, 0);
	gtk_widget_show_all ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}


static void clocks_alarm_main_panel_real_activate_select_all (ClocksClock* base) {
	ClocksAlarmMainPanel * self;
	ClocksIconView* _tmp0_;
	self = (ClocksAlarmMainPanel*) base;
	_tmp0_ = self->priv->icon_view;
	clocks_icon_view_select_all (_tmp0_);
}


static void clocks_alarm_main_panel_real_activate_select_none (ClocksClock* base) {
	ClocksAlarmMainPanel * self;
	ClocksIconView* _tmp0_;
	self = (ClocksAlarmMainPanel*) base;
	_tmp0_ = self->priv->icon_view;
	clocks_icon_view_unselect_all (_tmp0_);
}


static void ___lambda40_ (ClocksAlarmMainPanel* self) {
	clocks_clock_activate_new ((ClocksClock*) self);
}


static void ____lambda40__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda40_ (self);
}


static void clocks_alarm_main_panel_real_update_toolbar (ClocksClock* base) {
	ClocksAlarmMainPanel * self;
	ClocksToolbar* _tmp0_;
	ClocksToolbar* _tmp1_;
	ClocksToolbarMode _tmp2_;
	ClocksToolbarMode _tmp3_;
	self = (ClocksAlarmMainPanel*) base;
	_tmp0_ = clocks_clock_get_toolbar ((ClocksClock*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = clocks_toolbar_get_mode (_tmp1_);
	_tmp3_ = _tmp2_;
	switch (_tmp3_) {
		case CLOCKS_TOOLBAR_MODE_NORMAL:
		{
			ClocksToolbar* _tmp4_;
			ClocksToolbar* _tmp5_;
			const gchar* _tmp6_ = NULL;
			GtkButton* _tmp7_ = NULL;
			GtkButton* new_button;
			GtkButton* _tmp8_;
			ClocksContentView* _tmp9_;
			_tmp4_ = clocks_clock_get_toolbar ((ClocksClock*) self);
			_tmp5_ = _tmp4_;
			_tmp6_ = _ ("New");
			_tmp7_ = clocks_toolbar_add_button (_tmp5_, NULL, _tmp6_, TRUE);
			new_button = _tmp7_;
			_tmp8_ = new_button;
			g_signal_connect_object (_tmp8_, "clicked", (GCallback) ____lambda40__gtk_button_clicked, self, 0);
			_tmp9_ = self->priv->content_view;
			clocks_content_view_update_toolbar (_tmp9_);
			_g_object_unref0 (new_button);
			break;
		}
		case CLOCKS_TOOLBAR_MODE_SELECTION:
		{
			ClocksContentView* _tmp10_;
			_tmp10_ = self->priv->content_view;
			clocks_content_view_update_toolbar (_tmp10_);
			break;
		}
		case CLOCKS_TOOLBAR_MODE_STANDALONE:
		{
			ClocksToolbar* _tmp11_;
			ClocksToolbar* _tmp12_;
			ClocksToolbar* _tmp13_;
			ClocksToolbar* _tmp14_;
			ClocksAlarmStandalonePanel* _tmp15_;
			ClocksAlarmItem* _tmp16_;
			ClocksAlarmItem* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_;
			_tmp11_ = clocks_clock_get_toolbar ((ClocksClock*) self);
			_tmp12_ = _tmp11_;
			gd_main_toolbar_set_labels_menu ((GdMainToolbar*) _tmp12_, NULL);
			_tmp13_ = clocks_clock_get_toolbar ((ClocksClock*) self);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->standalone;
			_tmp16_ = clocks_alarm_standalone_panel_get_alarm (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = clocks_alarm_item_get_name (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_markup_escape_text (_tmp19_, (gssize) (-1));
			_tmp21_ = _tmp20_;
			gd_main_toolbar_set_labels ((GdMainToolbar*) _tmp14_, _tmp21_, NULL);
			_g_free0 (_tmp21_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static const gchar* clocks_alarm_main_panel_real_get_label (ClocksClock* base) {
	const gchar* result;
	ClocksAlarmMainPanel* self;
	const gchar* _tmp0_;
	self = (ClocksAlarmMainPanel*) base;
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}


static void clocks_alarm_main_panel_real_set_label (ClocksClock* base, const gchar* value) {
	ClocksAlarmMainPanel* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (ClocksAlarmMainPanel*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_label);
	self->priv->_label = _tmp1_;
	g_object_notify ((GObject *) self, "label");
}


static ClocksToolbar* clocks_alarm_main_panel_real_get_toolbar (ClocksClock* base) {
	ClocksToolbar* result;
	ClocksAlarmMainPanel* self;
	ClocksToolbar* _tmp0_;
	self = (ClocksAlarmMainPanel*) base;
	_tmp0_ = self->priv->_toolbar;
	result = _tmp0_;
	return result;
}


static void clocks_alarm_main_panel_real_set_toolbar (ClocksClock* base, ClocksToolbar* value) {
	ClocksAlarmMainPanel* self;
	ClocksToolbar* _tmp0_;
	ClocksToolbar* _tmp1_;
	self = (ClocksAlarmMainPanel*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_toolbar);
	self->priv->_toolbar = _tmp1_;
	g_object_notify ((GObject *) self, "toolbar");
}


static void clocks_alarm_main_panel_real_ring (ClocksAlarmMainPanel* self) {
	ClocksAlarmStandalonePanel* _tmp0_;
	_tmp0_ = self->priv->standalone;
	gd_stack_set_visible_child ((GdStack*) self, (GtkWidget*) _tmp0_);
}


static void clocks_alarm_main_panel_class_init (ClocksAlarmMainPanelClass * klass) {
	clocks_alarm_main_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksAlarmMainPanelPrivate));
	CLOCKS_ALARM_MAIN_PANEL_CLASS (klass)->ring = clocks_alarm_main_panel_real_ring;
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_alarm_main_panel_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_alarm_main_panel_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_alarm_main_panel_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_MAIN_PANEL_LABEL, g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_MAIN_PANEL_TOOLBAR, g_param_spec_object ("toolbar", "toolbar", "toolbar", CLOCKS_TYPE_TOOLBAR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_signal_new ("ring", CLOCKS_ALARM_TYPE_MAIN_PANEL, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ClocksAlarmMainPanelClass, ring), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void clocks_alarm_main_panel_clocks_clock_interface_init (ClocksClockIface * iface) {
	clocks_alarm_main_panel_clocks_clock_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate_new = (void (*)(ClocksClock*)) clocks_alarm_main_panel_real_activate_new;
	iface->activate_select_all = (void (*)(ClocksClock*)) clocks_alarm_main_panel_real_activate_select_all;
	iface->activate_select_none = (void (*)(ClocksClock*)) clocks_alarm_main_panel_real_activate_select_none;
	iface->update_toolbar = (void (*)(ClocksClock*)) clocks_alarm_main_panel_real_update_toolbar;
	iface->get_label = clocks_alarm_main_panel_real_get_label;
	iface->set_label = clocks_alarm_main_panel_real_set_label;
	iface->get_toolbar = clocks_alarm_main_panel_real_get_toolbar;
	iface->set_toolbar = clocks_alarm_main_panel_real_set_toolbar;
}


static void clocks_alarm_main_panel_instance_init (ClocksAlarmMainPanel * self) {
	self->priv = CLOCKS_ALARM_MAIN_PANEL_GET_PRIVATE (self);
}


static void clocks_alarm_main_panel_finalize (GObject* obj) {
	ClocksAlarmMainPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_ALARM_TYPE_MAIN_PANEL, ClocksAlarmMainPanel);
	_g_free0 (self->priv->_label);
	_g_object_unref0 (self->priv->_toolbar);
	__g_list_free__g_object_unref0_0 (self->priv->alarms);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->icon_view);
	_g_object_unref0 (self->priv->content_view);
	_g_object_unref0 (self->priv->standalone);
	G_OBJECT_CLASS (clocks_alarm_main_panel_parent_class)->finalize (obj);
}


GType clocks_alarm_main_panel_get_type (void) {
	static volatile gsize clocks_alarm_main_panel_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_alarm_main_panel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksAlarmMainPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_alarm_main_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksAlarmMainPanel), 0, (GInstanceInitFunc) clocks_alarm_main_panel_instance_init, NULL };
		static const GInterfaceInfo clocks_clock_info = { (GInterfaceInitFunc) clocks_alarm_main_panel_clocks_clock_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType clocks_alarm_main_panel_type_id;
		clocks_alarm_main_panel_type_id = g_type_register_static (gd_stack_get_type (), "ClocksAlarmMainPanel", &g_define_type_info, 0);
		g_type_add_interface_static (clocks_alarm_main_panel_type_id, CLOCKS_TYPE_CLOCK, &clocks_clock_info);
		g_once_init_leave (&clocks_alarm_main_panel_type_id__volatile, clocks_alarm_main_panel_type_id);
	}
	return clocks_alarm_main_panel_type_id__volatile;
}


static void _vala_clocks_alarm_main_panel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksAlarmMainPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_ALARM_TYPE_MAIN_PANEL, ClocksAlarmMainPanel);
	switch (property_id) {
		case CLOCKS_ALARM_MAIN_PANEL_LABEL:
		g_value_set_string (value, clocks_clock_get_label ((ClocksClock*) self));
		break;
		case CLOCKS_ALARM_MAIN_PANEL_TOOLBAR:
		g_value_set_object (value, clocks_clock_get_toolbar ((ClocksClock*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_alarm_main_panel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksAlarmMainPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_ALARM_TYPE_MAIN_PANEL, ClocksAlarmMainPanel);
	switch (property_id) {
		case CLOCKS_ALARM_MAIN_PANEL_LABEL:
		clocks_clock_set_label ((ClocksClock*) self, g_value_get_string (value));
		break;
		case CLOCKS_ALARM_MAIN_PANEL_TOOLBAR:
		clocks_clock_set_toolbar ((ClocksClock*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



