/* rygel-media-renderer-plugin.c generated by valac 0.18.1, the Vala compiler
 * generated from rygel-media-renderer-plugin.vala, do not modify */

/*
 * Copyright (C) 2008,2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <config.h>
#include <libgupnp/gupnp.h>


#define RYGEL_TYPE_MEDIA_RENDERER_PLUGIN (rygel_media_renderer_plugin_get_type ())
#define RYGEL_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPlugin))
#define RYGEL_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_MEDIA_RENDERER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))

typedef struct _RygelMediaRendererPlugin RygelMediaRendererPlugin;
typedef struct _RygelMediaRendererPluginClass RygelMediaRendererPluginClass;
typedef struct _RygelMediaRendererPluginPrivate RygelMediaRendererPluginPrivate;

#define RYGEL_TYPE_MEDIA_PLAYER (rygel_media_player_get_type ())
#define RYGEL_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayer))
#define RYGEL_IS_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_PLAYER))
#define RYGEL_MEDIA_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayerIface))

typedef struct _RygelMediaPlayer RygelMediaPlayer;
typedef struct _RygelMediaPlayerIface RygelMediaPlayerIface;

#define RYGEL_TYPE_PLAYER_CONTROLLER (rygel_player_controller_get_type ())
#define RYGEL_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerController))
#define RYGEL_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerControllerClass))
#define RYGEL_IS_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAYER_CONTROLLER))
#define RYGEL_IS_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAYER_CONTROLLER))
#define RYGEL_PLAYER_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerControllerClass))

typedef struct _RygelPlayerController RygelPlayerController;
typedef struct _RygelPlayerControllerClass RygelPlayerControllerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_SINK_CONNECTION_MANAGER (rygel_sink_connection_manager_get_type ())
#define RYGEL_SINK_CONNECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SINK_CONNECTION_MANAGER, RygelSinkConnectionManager))
#define RYGEL_SINK_CONNECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SINK_CONNECTION_MANAGER, RygelSinkConnectionManagerClass))
#define RYGEL_IS_SINK_CONNECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SINK_CONNECTION_MANAGER))
#define RYGEL_IS_SINK_CONNECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SINK_CONNECTION_MANAGER))
#define RYGEL_SINK_CONNECTION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SINK_CONNECTION_MANAGER, RygelSinkConnectionManagerClass))

typedef struct _RygelSinkConnectionManager RygelSinkConnectionManager;
typedef struct _RygelSinkConnectionManagerClass RygelSinkConnectionManagerClass;

#define RYGEL_TYPE_AV_TRANSPORT (rygel_av_transport_get_type ())
#define RYGEL_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport))
#define RYGEL_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportClass))
#define RYGEL_IS_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AV_TRANSPORT))
#define RYGEL_IS_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AV_TRANSPORT))
#define RYGEL_AV_TRANSPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportClass))

typedef struct _RygelAVTransport RygelAVTransport;
typedef struct _RygelAVTransportClass RygelAVTransportClass;
#define _rygel_resource_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_resource_info_unref (var), NULL)))

#define RYGEL_TYPE_RENDERING_CONTROL (rygel_rendering_control_get_type ())
#define RYGEL_RENDERING_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControl))
#define RYGEL_RENDERING_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControlClass))
#define RYGEL_IS_RENDERING_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RENDERING_CONTROL))
#define RYGEL_IS_RENDERING_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RENDERING_CONTROL))
#define RYGEL_RENDERING_CONTROL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControlClass))

typedef struct _RygelRenderingControl RygelRenderingControl;
typedef struct _RygelRenderingControlClass RygelRenderingControlClass;

struct _RygelMediaPlayerIface {
	GTypeInterface parent_iface;
	gboolean (*seek) (RygelMediaPlayer* self, gint64 time);
	gchar** (*get_protocols) (RygelMediaPlayer* self, int* result_length1);
	gchar** (*get_mime_types) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_state) (RygelMediaPlayer* self);
	void (*set_playback_state) (RygelMediaPlayer* self, const gchar* value);
	gchar** (*get_allowed_playback_speeds) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_speed) (RygelMediaPlayer* self);
	void (*set_playback_speed) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_uri) (RygelMediaPlayer* self);
	void (*set_uri) (RygelMediaPlayer* self, const gchar* value);
	gdouble (*get_volume) (RygelMediaPlayer* self);
	void (*set_volume) (RygelMediaPlayer* self, gdouble value);
	gint64 (*get_duration) (RygelMediaPlayer* self);
	gchar* (*get_metadata) (RygelMediaPlayer* self);
	void (*set_metadata) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_mime_type) (RygelMediaPlayer* self);
	void (*set_mime_type) (RygelMediaPlayer* self, const gchar* value);
	gboolean (*get_can_seek) (RygelMediaPlayer* self);
	gchar* (*get_content_features) (RygelMediaPlayer* self);
	void (*set_content_features) (RygelMediaPlayer* self, const gchar* value);
	gint64 (*get_position) (RygelMediaPlayer* self);
};

struct _RygelMediaRendererPlugin {
	RygelPlugin parent_instance;
	RygelMediaRendererPluginPrivate * priv;
};

struct _RygelMediaRendererPluginClass {
	RygelPluginClass parent_class;
	RygelMediaPlayer* (*get_player) (RygelMediaRendererPlugin* self);
};

struct _RygelMediaRendererPluginPrivate {
	gchar* sink_protocol_info;
	RygelPlayerController* controller;
};


static gpointer rygel_media_renderer_plugin_parent_class = NULL;

GType rygel_media_renderer_plugin_get_type (void) G_GNUC_CONST;
GType rygel_media_player_get_type (void) G_GNUC_CONST;
GType rygel_player_controller_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_RENDERER_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginPrivate))
enum  {
	RYGEL_MEDIA_RENDERER_PLUGIN_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_RENDERER_PLUGIN_MEDIA_RENDERER_DESC_PATH DATA_DIR "/xml/MediaRenderer2.xml"
#define RYGEL_MEDIA_RENDERER_PLUGIN_DMR "urn:schemas-upnp-org:device:MediaRenderer"
RygelMediaRendererPlugin* rygel_media_renderer_plugin_new (const gchar* name, const gchar* title, const gchar* description, RygelPluginCapabilities capabilities);
RygelMediaRendererPlugin* rygel_media_renderer_plugin_construct (GType object_type, const gchar* name, const gchar* title, const gchar* description, RygelPluginCapabilities capabilities);
static void rygel_media_renderer_plugin_real_constructed (GObject* base);
GType rygel_sink_connection_manager_get_type (void) G_GNUC_CONST;
#define RYGEL_AV_TRANSPORT_UPNP_ID "urn:upnp-org:serviceId:AVTransport"
#define RYGEL_AV_TRANSPORT_UPNP_TYPE "urn:schemas-upnp-org:service:AVTransport:2"
#define RYGEL_AV_TRANSPORT_DESCRIPTION_PATH "xml/AVTransport2.xml"
GType rygel_av_transport_get_type (void) G_GNUC_CONST;
#define RYGEL_RENDERING_CONTROL_UPNP_ID "urn:upnp-org:serviceId:RenderingControl"
#define RYGEL_RENDERING_CONTROL_UPNP_TYPE "urn:schemas-upnp-org:service:RenderingControl:2"
#define RYGEL_RENDERING_CONTROL_DESCRIPTION_PATH "xml/RenderingControl2.xml"
GType rygel_rendering_control_get_type (void) G_GNUC_CONST;
RygelMediaPlayer* rygel_media_renderer_plugin_get_player (RygelMediaRendererPlugin* self);
static RygelMediaPlayer* rygel_media_renderer_plugin_real_get_player (RygelMediaRendererPlugin* self);
RygelPlayerController* rygel_media_renderer_plugin_get_controller (RygelMediaRendererPlugin* self);
gchar* rygel_media_renderer_plugin_get_protocol_info (RygelMediaRendererPlugin* self);
RygelPlayerController* rygel_player_controller_new (RygelMediaPlayer* player, const gchar* protocol_info);
RygelPlayerController* rygel_player_controller_construct (GType object_type, RygelMediaPlayer* player, const gchar* protocol_info);
static void rygel_media_renderer_plugin_real_apply_hacks (RygelPlugin* base, RygelRootDevice* device, const gchar* description_path, GError** error);
gchar** rygel_media_player_get_protocols (RygelMediaPlayer* self, int* result_length1);
gchar** rygel_media_player_get_mime_types (RygelMediaPlayer* self, int* result_length1);
static void rygel_media_renderer_plugin_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
     * Create an instance of the plugin.
     *
     * @param name The non-human-readable name for the plugin and its renderer, used in UPnP messages and in the Rygel configuration file.
     * @param title An optional human-readable name (friendlyName) of the UPnP renderer provided by the plugin. If the title is empty then the name will be used.
     * @param description An optional human-readable description (modelDescription) of the UPnP renderer provided by the plugin.
     */
RygelMediaRendererPlugin* rygel_media_renderer_plugin_construct (GType object_type, const gchar* name, const gchar* title, const gchar* description, RygelPluginCapabilities capabilities) {
	RygelMediaRendererPlugin * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	RygelPluginCapabilities _tmp3_;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = title;
	_tmp2_ = description;
	_tmp3_ = capabilities;
	self = (RygelMediaRendererPlugin*) g_object_new (object_type, "desc-path", RYGEL_MEDIA_RENDERER_PLUGIN_MEDIA_RENDERER_DESC_PATH, "name", _tmp0_, "title", _tmp1_, "description", _tmp2_, "capabilities", _tmp3_, NULL);
	return self;
}


RygelMediaRendererPlugin* rygel_media_renderer_plugin_new (const gchar* name, const gchar* title, const gchar* description, RygelPluginCapabilities capabilities) {
	return rygel_media_renderer_plugin_construct (RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, name, title, description, capabilities);
}


static void rygel_media_renderer_plugin_real_constructed (GObject* base) {
	RygelMediaRendererPlugin * self;
	RygelResourceInfo* _tmp0_;
	RygelResourceInfo* resource;
	RygelResourceInfo* _tmp1_;
	RygelResourceInfo* _tmp2_;
	RygelResourceInfo* _tmp3_;
	RygelResourceInfo* _tmp4_;
	RygelResourceInfo* _tmp5_;
	self = (RygelMediaRendererPlugin*) base;
	G_OBJECT_CLASS (rygel_media_renderer_plugin_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_PLUGIN, RygelPlugin));
	_tmp0_ = rygel_resource_info_new (RYGEL_CONNECTION_MANAGER_UPNP_ID, RYGEL_CONNECTION_MANAGER_UPNP_TYPE, RYGEL_CONNECTION_MANAGER_DESCRIPTION_PATH, RYGEL_TYPE_SINK_CONNECTION_MANAGER);
	resource = _tmp0_;
	_tmp1_ = resource;
	rygel_plugin_add_resource ((RygelPlugin*) self, _tmp1_);
	_tmp2_ = rygel_resource_info_new (RYGEL_AV_TRANSPORT_UPNP_ID, RYGEL_AV_TRANSPORT_UPNP_TYPE, RYGEL_AV_TRANSPORT_DESCRIPTION_PATH, RYGEL_TYPE_AV_TRANSPORT);
	_rygel_resource_info_unref0 (resource);
	resource = _tmp2_;
	_tmp3_ = resource;
	rygel_plugin_add_resource ((RygelPlugin*) self, _tmp3_);
	_tmp4_ = rygel_resource_info_new (RYGEL_RENDERING_CONTROL_UPNP_ID, RYGEL_RENDERING_CONTROL_UPNP_TYPE, RYGEL_RENDERING_CONTROL_DESCRIPTION_PATH, RYGEL_TYPE_RENDERING_CONTROL);
	_rygel_resource_info_unref0 (resource);
	resource = _tmp4_;
	_tmp5_ = resource;
	rygel_plugin_add_resource ((RygelPlugin*) self, _tmp5_);
	_rygel_resource_info_unref0 (resource);
}


static RygelMediaPlayer* rygel_media_renderer_plugin_real_get_player (RygelMediaRendererPlugin* self) {
	RygelMediaPlayer* result = NULL;
	result = NULL;
	return result;
}


RygelMediaPlayer* rygel_media_renderer_plugin_get_player (RygelMediaRendererPlugin* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_RENDERER_PLUGIN_GET_CLASS (self)->get_player (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelPlayerController* rygel_media_renderer_plugin_get_controller (RygelMediaRendererPlugin* self) {
	RygelPlayerController* result = NULL;
	RygelPlayerController* _tmp0_;
	RygelPlayerController* _tmp6_;
	RygelPlayerController* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->controller;
	if (_tmp0_ == NULL) {
		RygelMediaPlayer* _tmp1_ = NULL;
		RygelMediaPlayer* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		RygelPlayerController* _tmp5_;
		_tmp1_ = rygel_media_renderer_plugin_get_player (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = rygel_media_renderer_plugin_get_protocol_info (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = rygel_player_controller_new (_tmp2_, _tmp4_);
		_g_object_unref0 (self->priv->controller);
		self->priv->controller = _tmp5_;
		_g_free0 (_tmp4_);
		_g_object_unref0 (_tmp2_);
	}
	_tmp6_ = self->priv->controller;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}


static void rygel_media_renderer_plugin_real_apply_hacks (RygelPlugin* base, RygelRootDevice* device, const gchar* description_path, GError** error) {
	RygelMediaRendererPlugin * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** services;
	gint services_length1;
	gint _services_size_;
	RygelV1Hacks* _tmp4_;
	RygelV1Hacks* v1_hacks;
	RygelRootDevice* _tmp5_;
	const gchar* _tmp6_;
	GError * _inner_error_ = NULL;
	self = (RygelMediaRendererPlugin*) base;
	g_return_if_fail (device != NULL);
	g_return_if_fail (description_path != NULL);
	_tmp0_ = g_strdup (RYGEL_AV_TRANSPORT_UPNP_TYPE);
	_tmp1_ = g_strdup (RYGEL_RENDERING_CONTROL_UPNP_TYPE);
	_tmp2_ = g_strdup (RYGEL_CONNECTION_MANAGER_UPNP_TYPE);
	_tmp3_ = g_new0 (gchar*, 3 + 1);
	_tmp3_[0] = _tmp0_;
	_tmp3_[1] = _tmp1_;
	_tmp3_[2] = _tmp2_;
	services = _tmp3_;
	services_length1 = 3;
	_services_size_ = services_length1;
	_tmp4_ = rygel_v1_hacks_new (RYGEL_MEDIA_RENDERER_PLUGIN_DMR, services, services_length1);
	v1_hacks = _tmp4_;
	_tmp5_ = device;
	_tmp6_ = description_path;
	rygel_v1_hacks_apply_on_device (v1_hacks, _tmp5_, _tmp6_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (v1_hacks);
		services = (_vala_array_free (services, services_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_g_object_unref0 (v1_hacks);
	services = (_vala_array_free (services, services_length1, (GDestroyNotify) g_free), NULL);
}


gchar* rygel_media_renderer_plugin_get_protocol_info (RygelMediaRendererPlugin* self) {
	gchar* result = NULL;
	RygelMediaPlayer* _tmp0_ = NULL;
	RygelMediaPlayer* player;
	RygelMediaPlayer* _tmp1_;
	const gchar* _tmp3_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_media_renderer_plugin_get_player (self);
	player = _tmp0_;
	_tmp1_ = player;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("");
		result = _tmp2_;
		_g_object_unref0 (player);
		return result;
	}
	_tmp3_ = self->priv->sink_protocol_info;
	if (_tmp3_ == NULL) {
		gchar* _tmp4_;
		RygelMediaPlayer* _tmp5_;
		gint _tmp6_ = 0;
		gchar** _tmp7_ = NULL;
		gchar** protocols;
		gint protocols_length1;
		gint _protocols_size_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		RygelMediaPlayer* _tmp10_;
		gint _tmp11_ = 0;
		gchar** _tmp12_ = NULL;
		gchar** mime_types;
		gint mime_types_length1;
		gint _mime_types_size_;
		gchar** _tmp13_;
		gint _tmp13__length1;
		_tmp4_ = g_strdup ("");
		_g_free0 (self->priv->sink_protocol_info);
		self->priv->sink_protocol_info = _tmp4_;
		_tmp5_ = player;
		_tmp7_ = rygel_media_player_get_protocols (_tmp5_, &_tmp6_);
		protocols = _tmp7_;
		protocols_length1 = _tmp6_;
		_protocols_size_ = protocols_length1;
		_tmp8_ = self->priv->sink_protocol_info;
		_tmp9_ = g_strconcat (_tmp8_, "http-get:*:text/xml:DLNA.ORG_PN=DIDL_S,", NULL);
		_g_free0 (self->priv->sink_protocol_info);
		self->priv->sink_protocol_info = _tmp9_;
		_tmp10_ = player;
		_tmp12_ = rygel_media_player_get_mime_types (_tmp10_, &_tmp11_);
		mime_types = _tmp12_;
		mime_types_length1 = _tmp11_;
		_mime_types_size_ = mime_types_length1;
		_tmp13_ = protocols;
		_tmp13__length1 = protocols_length1;
		{
			gchar** protocol_collection = NULL;
			gint protocol_collection_length1 = 0;
			gint _protocol_collection_size_ = 0;
			gint protocol_it = 0;
			protocol_collection = _tmp13_;
			protocol_collection_length1 = _tmp13__length1;
			for (protocol_it = 0; protocol_it < _tmp13__length1; protocol_it = protocol_it + 1) {
				gchar* _tmp14_;
				gchar* protocol = NULL;
				_tmp14_ = g_strdup (protocol_collection[protocol_it]);
				protocol = _tmp14_;
				{
					gchar** _tmp15_;
					gint _tmp15__length1;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					gchar** _tmp20_;
					gint _tmp20__length1;
					_tmp15_ = protocols;
					_tmp15__length1 = protocols_length1;
					_tmp16_ = _tmp15_[0];
					_tmp17_ = protocol;
					if (g_strcmp0 (_tmp16_, _tmp17_) != 0) {
						const gchar* _tmp18_;
						gchar* _tmp19_;
						_tmp18_ = self->priv->sink_protocol_info;
						_tmp19_ = g_strconcat (_tmp18_, ",", NULL);
						_g_free0 (self->priv->sink_protocol_info);
						self->priv->sink_protocol_info = _tmp19_;
					}
					_tmp20_ = mime_types;
					_tmp20__length1 = mime_types_length1;
					{
						gchar** mime_type_collection = NULL;
						gint mime_type_collection_length1 = 0;
						gint _mime_type_collection_size_ = 0;
						gint mime_type_it = 0;
						mime_type_collection = _tmp20_;
						mime_type_collection_length1 = _tmp20__length1;
						for (mime_type_it = 0; mime_type_it < _tmp20__length1; mime_type_it = mime_type_it + 1) {
							gchar* _tmp21_;
							gchar* mime_type = NULL;
							_tmp21_ = g_strdup (mime_type_collection[mime_type_it]);
							mime_type = _tmp21_;
							{
								gchar** _tmp22_;
								gint _tmp22__length1;
								const gchar* _tmp23_;
								const gchar* _tmp24_;
								const gchar* _tmp27_;
								const gchar* _tmp28_;
								gchar* _tmp29_;
								gchar* _tmp30_;
								const gchar* _tmp31_;
								gchar* _tmp32_;
								gchar* _tmp33_;
								gchar* _tmp34_;
								gchar* _tmp35_;
								gchar* _tmp36_;
								_tmp22_ = mime_types;
								_tmp22__length1 = mime_types_length1;
								_tmp23_ = _tmp22_[0];
								_tmp24_ = mime_type;
								if (g_strcmp0 (_tmp23_, _tmp24_) != 0) {
									const gchar* _tmp25_;
									gchar* _tmp26_;
									_tmp25_ = self->priv->sink_protocol_info;
									_tmp26_ = g_strconcat (_tmp25_, ",", NULL);
									_g_free0 (self->priv->sink_protocol_info);
									self->priv->sink_protocol_info = _tmp26_;
								}
								_tmp27_ = self->priv->sink_protocol_info;
								_tmp28_ = protocol;
								_tmp29_ = g_strconcat (_tmp28_, ":*:", NULL);
								_tmp30_ = _tmp29_;
								_tmp31_ = mime_type;
								_tmp32_ = g_strconcat (_tmp30_, _tmp31_, NULL);
								_tmp33_ = _tmp32_;
								_tmp34_ = g_strconcat (_tmp33_, ":*", NULL);
								_tmp35_ = _tmp34_;
								_tmp36_ = g_strconcat (_tmp27_, _tmp35_, NULL);
								_g_free0 (self->priv->sink_protocol_info);
								self->priv->sink_protocol_info = _tmp36_;
								_g_free0 (_tmp35_);
								_g_free0 (_tmp33_);
								_g_free0 (_tmp30_);
								_g_free0 (mime_type);
							}
						}
					}
					_g_free0 (protocol);
				}
			}
		}
		mime_types = (_vala_array_free (mime_types, mime_types_length1, (GDestroyNotify) g_free), NULL);
		protocols = (_vala_array_free (protocols, protocols_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp37_ = self->priv->sink_protocol_info;
	_tmp38_ = g_strdup (_tmp37_);
	result = _tmp38_;
	_g_object_unref0 (player);
	return result;
}


static void rygel_media_renderer_plugin_class_init (RygelMediaRendererPluginClass * klass) {
	rygel_media_renderer_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaRendererPluginPrivate));
	G_OBJECT_CLASS (klass)->constructed = rygel_media_renderer_plugin_real_constructed;
	RYGEL_MEDIA_RENDERER_PLUGIN_CLASS (klass)->get_player = rygel_media_renderer_plugin_real_get_player;
	RYGEL_PLUGIN_CLASS (klass)->apply_hacks = rygel_media_renderer_plugin_real_apply_hacks;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_renderer_plugin_finalize;
}


static void rygel_media_renderer_plugin_instance_init (RygelMediaRendererPlugin * self) {
	self->priv = RYGEL_MEDIA_RENDERER_PLUGIN_GET_PRIVATE (self);
}


static void rygel_media_renderer_plugin_finalize (GObject* obj) {
	RygelMediaRendererPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPlugin);
	_g_free0 (self->priv->sink_protocol_info);
	_g_object_unref0 (self->priv->controller);
	G_OBJECT_CLASS (rygel_media_renderer_plugin_parent_class)->finalize (obj);
}


/**
 * This is the base class for every Rygel UPnP renderer plugin.
 *
 * This class is useful when implementing Rygel renderer plugins.
 *
 * Renderer plugins should also implement their own #RygelMediaPlayer
 * and return an instance of it from their get_player() implementation.
 */
GType rygel_media_renderer_plugin_get_type (void) {
	static volatile gsize rygel_media_renderer_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_renderer_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaRendererPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_renderer_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaRendererPlugin), 0, (GInstanceInitFunc) rygel_media_renderer_plugin_instance_init, NULL };
		GType rygel_media_renderer_plugin_type_id;
		rygel_media_renderer_plugin_type_id = g_type_register_static (RYGEL_TYPE_PLUGIN, "RygelMediaRendererPlugin", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_renderer_plugin_type_id__volatile, rygel_media_renderer_plugin_type_id);
	}
	return rygel_media_renderer_plugin_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



