/* rygel-http-byte-seek-test.c generated by valac 0.18.1, the Vala compiler
 * generated from rygel-http-byte-seek-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshan.ali@nokia.com>
 *                               <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>


#define RYGEL_TYPE_HTTP_IDENTITY_HANDLER (rygel_http_identity_handler_get_type ())
#define RYGEL_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandler))
#define RYGEL_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_HTTP_IDENTITY_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))

typedef struct _RygelHTTPIdentityHandler RygelHTTPIdentityHandler;
typedef struct _RygelHTTPIdentityHandlerClass RygelHTTPIdentityHandlerClass;
typedef struct _RygelHTTPIdentityHandlerPrivate RygelHTTPIdentityHandlerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_BYTE_SEEK_TEST (rygel_http_byte_seek_test_get_type ())
#define RYGEL_HTTP_BYTE_SEEK_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST, RygelHTTPByteSeekTest))
#define RYGEL_HTTP_BYTE_SEEK_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST, RygelHTTPByteSeekTestClass))
#define RYGEL_IS_HTTP_BYTE_SEEK_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST))
#define RYGEL_IS_HTTP_BYTE_SEEK_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST))
#define RYGEL_HTTP_BYTE_SEEK_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST, RygelHTTPByteSeekTestClass))

typedef struct _RygelHTTPByteSeekTest RygelHTTPByteSeekTest;
typedef struct _RygelHTTPByteSeekTestClass RygelHTTPByteSeekTestClass;
typedef struct _RygelHTTPByteSeekTestPrivate RygelHTTPByteSeekTestPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_HTTP_BYTE_SEEK (rygel_http_byte_seek_get_type ())
#define RYGEL_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeek))
#define RYGEL_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))
#define RYGEL_IS_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_IS_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_HTTP_BYTE_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))

typedef struct _RygelHTTPByteSeek RygelHTTPByteSeek;
typedef struct _RygelHTTPByteSeekClass RygelHTTPByteSeekClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	RYGEL_TEST_ERROR_SKIP
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
struct _RygelHTTPIdentityHandler {
	GObject parent_instance;
	RygelHTTPIdentityHandlerPrivate * priv;
};

struct _RygelHTTPIdentityHandlerClass {
	GObjectClass parent_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gint64 size;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelThumbnail {
	GObject parent_instance;
	RygelThumbnailPrivate * priv;
	gint64 size;
};

struct _RygelThumbnailClass {
	GObjectClass parent_class;
};

struct _RygelSubtitle {
	GObject parent_instance;
	RygelSubtitlePrivate * priv;
	gint64 size;
};

struct _RygelSubtitleClass {
	GObjectClass parent_class;
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelHTTPGet {
	GObject parent_instance;
	RygelHTTPGetPrivate * priv;
	SoupMessage* msg;
	RygelMediaObject* object;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPIdentityHandler* handler;
};

struct _RygelHTTPGetClass {
	GObjectClass parent_class;
};

struct _RygelHTTPByteSeekTest {
	GObject parent_instance;
	RygelHTTPByteSeekTestPrivate * priv;
};

struct _RygelHTTPByteSeekTestClass {
	GObjectClass parent_class;
};

struct _RygelHTTPByteSeekTestPrivate {
	GRegex* range_regex;
};

typedef enum  {
	RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekError;
#define RYGEL_HTTP_SEEK_ERROR rygel_http_seek_error_quark ()

static gpointer rygel_http_identity_handler_parent_class = NULL;
static gpointer rygel_media_object_parent_class = NULL;
static gpointer rygel_media_item_parent_class = NULL;
static gpointer rygel_thumbnail_parent_class = NULL;
static gpointer rygel_subtitle_parent_class = NULL;
static gpointer rygel_media_container_parent_class = NULL;
static gpointer rygel_http_get_parent_class = NULL;
static gpointer rygel_http_byte_seek_test_parent_class = NULL;

GQuark rygel_test_error_quark (void);
GType rygel_http_identity_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_IDENTITY_HANDLER_DUMMY_PROPERTY
};
RygelHTTPIdentityHandler* rygel_http_identity_handler_new (void);
RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_OBJECT_DUMMY_PROPERTY
};
RygelMediaObject* rygel_media_object_new (void);
RygelMediaObject* rygel_media_object_construct (GType object_type);
static void rygel_media_object_finalize (GObject* obj);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
RygelMediaItem* rygel_media_item_new (void);
RygelMediaItem* rygel_media_item_construct (GType object_type);
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_THUMBNAIL_DUMMY_PROPERTY
};
RygelThumbnail* rygel_thumbnail_new (void);
RygelThumbnail* rygel_thumbnail_construct (GType object_type);
static void rygel_thumbnail_finalize (GObject* obj);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_SUBTITLE_DUMMY_PROPERTY
};
RygelSubtitle* rygel_subtitle_new (void);
RygelSubtitle* rygel_subtitle_construct (GType object_type);
static void rygel_subtitle_finalize (GObject* obj);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_CONTAINER_DUMMY_PROPERTY
};
RygelMediaContainer* rygel_media_container_new (void);
RygelMediaContainer* rygel_media_container_construct (GType object_type);
GType rygel_http_get_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_GET_DUMMY_PROPERTY
};
#define RYGEL_HTTP_GET_ITEM_URI "http://DoesntMatterWhatThisIs"
RygelHTTPGet* rygel_http_get_new (RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_new_seek_start (gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct_seek_start (GType object_type, gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
static void rygel_http_get_add_headers (RygelHTTPGet* self, gint64 start, gint64 stop);
RygelHTTPGet* rygel_http_get_new_seek_stop (gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct_seek_stop (GType object_type, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_new_seek_start_stop (gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_construct_seek_start_stop (GType object_type, gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle);
RygelHTTPGet* rygel_http_get_new_inverted_range (void);
RygelHTTPGet* rygel_http_get_construct_inverted_range (GType object_type);
RygelHTTPGet* rygel_http_get_new_invalid_range (void);
RygelHTTPGet* rygel_http_get_construct_invalid_range (GType object_type);
static void rygel_http_get_finalize (GObject* obj);
GType rygel_http_byte_seek_test_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_BYTE_SEEK_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST, RygelHTTPByteSeekTestPrivate))
enum  {
	RYGEL_HTTP_BYTE_SEEK_TEST_DUMMY_PROPERTY
};
gint rygel_http_byte_seek_test_main (gchar** args, int args_length1);
static RygelHTTPByteSeekTest* rygel_http_byte_seek_test_new (void);
static RygelHTTPByteSeekTest* rygel_http_byte_seek_test_construct (GType object_type);
GQuark rygel_http_seek_error_quark (void);
void rygel_http_byte_seek_test_run (RygelHTTPByteSeekTest* self, GError** error);
static void rygel_http_byte_seek_test_test_no_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_byte_seek_test_test_start_only_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_byte_seek_test_test_stop_only_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
static void rygel_http_byte_seek_test_test_start_stop_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error);
RygelHTTPByteSeek* rygel_http_byte_seek_new (RygelHTTPGet* request, GError** error);
RygelHTTPByteSeek* rygel_http_byte_seek_construct (GType object_type, RygelHTTPGet* request, GError** error);
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_http_byte_seek_get_type (void) G_GNUC_CONST;
static void rygel_http_byte_seek_test_test_seek (RygelHTTPByteSeekTest* self, RygelHTTPGet* request, gint64 start, gint64 stop, GError** error);
gboolean rygel_http_byte_seek_needed (RygelHTTPGet* request);
void rygel_http_seek_add_response_headers (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_total_length (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_length (RygelHTTPSeek* self);
gboolean rygel_http_byte_seek_requested (RygelHTTPGet* request);
static void rygel_http_byte_seek_test_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type) {
	RygelHTTPIdentityHandler * self = NULL;
	self = (RygelHTTPIdentityHandler*) g_object_new (object_type, NULL);
	return self;
}


RygelHTTPIdentityHandler* rygel_http_identity_handler_new (void) {
	return rygel_http_identity_handler_construct (RYGEL_TYPE_HTTP_IDENTITY_HANDLER);
}


static void rygel_http_identity_handler_class_init (RygelHTTPIdentityHandlerClass * klass) {
	rygel_http_identity_handler_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_http_identity_handler_instance_init (RygelHTTPIdentityHandler * self) {
}


GType rygel_http_identity_handler_get_type (void) {
	static volatile gsize rygel_http_identity_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_identity_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPIdentityHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_identity_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPIdentityHandler), 0, (GInstanceInitFunc) rygel_http_identity_handler_instance_init, NULL };
		GType rygel_http_identity_handler_type_id;
		rygel_http_identity_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPIdentityHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_identity_handler_type_id__volatile, rygel_http_identity_handler_type_id);
	}
	return rygel_http_identity_handler_type_id__volatile;
}


RygelMediaObject* rygel_media_object_construct (GType object_type) {
	RygelMediaObject * self = NULL;
	self = (RygelMediaObject*) g_object_new (object_type, NULL);
	return self;
}


RygelMediaObject* rygel_media_object_new (void) {
	return rygel_media_object_construct (RYGEL_TYPE_MEDIA_OBJECT);
}


static void rygel_media_object_class_init (RygelMediaObjectClass * klass) {
	rygel_media_object_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_media_object_finalize;
}


static void rygel_media_object_instance_init (RygelMediaObject * self) {
	self->size = (gint64) 2048;
}


static void rygel_media_object_finalize (GObject* obj) {
	RygelMediaObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject);
	G_OBJECT_CLASS (rygel_media_object_parent_class)->finalize (obj);
}


GType rygel_media_object_get_type (void) {
	static volatile gsize rygel_media_object_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObject), 0, (GInstanceInitFunc) rygel_media_object_instance_init, NULL };
		GType rygel_media_object_type_id;
		rygel_media_object_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaObject", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_object_type_id__volatile, rygel_media_object_type_id);
	}
	return rygel_media_object_type_id__volatile;
}


RygelMediaItem* rygel_media_item_construct (GType object_type) {
	RygelMediaItem * self = NULL;
	self = (RygelMediaItem*) rygel_media_object_construct (object_type);
	return self;
}


RygelMediaItem* rygel_media_item_new (void) {
	return rygel_media_item_construct (RYGEL_TYPE_MEDIA_ITEM);
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
}


GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


RygelThumbnail* rygel_thumbnail_construct (GType object_type) {
	RygelThumbnail * self = NULL;
	self = (RygelThumbnail*) g_object_new (object_type, NULL);
	return self;
}


RygelThumbnail* rygel_thumbnail_new (void) {
	return rygel_thumbnail_construct (RYGEL_TYPE_THUMBNAIL);
}


static void rygel_thumbnail_class_init (RygelThumbnailClass * klass) {
	rygel_thumbnail_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_thumbnail_finalize;
}


static void rygel_thumbnail_instance_init (RygelThumbnail * self) {
	self->size = (gint64) 1024;
}


static void rygel_thumbnail_finalize (GObject* obj) {
	RygelThumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_THUMBNAIL, RygelThumbnail);
	G_OBJECT_CLASS (rygel_thumbnail_parent_class)->finalize (obj);
}


GType rygel_thumbnail_get_type (void) {
	static volatile gsize rygel_thumbnail_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_thumbnail_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnail), 0, (GInstanceInitFunc) rygel_thumbnail_instance_init, NULL };
		GType rygel_thumbnail_type_id;
		rygel_thumbnail_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelThumbnail", &g_define_type_info, 0);
		g_once_init_leave (&rygel_thumbnail_type_id__volatile, rygel_thumbnail_type_id);
	}
	return rygel_thumbnail_type_id__volatile;
}


RygelSubtitle* rygel_subtitle_construct (GType object_type) {
	RygelSubtitle * self = NULL;
	self = (RygelSubtitle*) g_object_new (object_type, NULL);
	return self;
}


RygelSubtitle* rygel_subtitle_new (void) {
	return rygel_subtitle_construct (RYGEL_TYPE_SUBTITLE);
}


static void rygel_subtitle_class_init (RygelSubtitleClass * klass) {
	rygel_subtitle_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_subtitle_finalize;
}


static void rygel_subtitle_instance_init (RygelSubtitle * self) {
	self->size = (gint64) 512;
}


static void rygel_subtitle_finalize (GObject* obj) {
	RygelSubtitle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_SUBTITLE, RygelSubtitle);
	G_OBJECT_CLASS (rygel_subtitle_parent_class)->finalize (obj);
}


GType rygel_subtitle_get_type (void) {
	static volatile gsize rygel_subtitle_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_subtitle_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSubtitleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_subtitle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSubtitle), 0, (GInstanceInitFunc) rygel_subtitle_instance_init, NULL };
		GType rygel_subtitle_type_id;
		rygel_subtitle_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSubtitle", &g_define_type_info, 0);
		g_once_init_leave (&rygel_subtitle_type_id__volatile, rygel_subtitle_type_id);
	}
	return rygel_subtitle_type_id__volatile;
}


RygelMediaContainer* rygel_media_container_construct (GType object_type) {
	RygelMediaContainer * self = NULL;
	self = (RygelMediaContainer*) rygel_media_object_construct (object_type);
	return self;
}


RygelMediaContainer* rygel_media_container_new (void) {
	return rygel_media_container_construct (RYGEL_TYPE_MEDIA_CONTAINER);
}


static void rygel_media_container_class_init (RygelMediaContainerClass * klass) {
	rygel_media_container_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_media_container_instance_init (RygelMediaContainer * self) {
}


GType rygel_media_container_get_type (void) {
	static volatile gsize rygel_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaContainer), 0, (GInstanceInitFunc) rygel_media_container_instance_init, NULL };
		GType rygel_media_container_type_id;
		rygel_media_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_container_type_id__volatile, rygel_media_container_type_id);
	}
	return rygel_media_container_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	SoupMessage* _tmp0_;
	RygelMediaItem* _tmp1_;
	RygelHTTPIdentityHandler* _tmp2_;
	RygelThumbnail* _tmp3_;
	RygelThumbnail* _tmp4_;
	RygelSubtitle* _tmp5_;
	RygelSubtitle* _tmp6_;
	self = (RygelHTTPGet*) g_object_new (object_type, NULL);
	_tmp0_ = soup_message_new ("HTTP", RYGEL_HTTP_GET_ITEM_URI);
	_g_object_unref0 (self->msg);
	self->msg = _tmp0_;
	_tmp1_ = rygel_media_item_new ();
	_g_object_unref0 (self->object);
	self->object = (RygelMediaObject*) _tmp1_;
	_tmp2_ = rygel_http_identity_handler_new ();
	_g_object_unref0 (self->handler);
	self->handler = _tmp2_;
	_tmp3_ = thumbnail;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->thumbnail);
	self->thumbnail = _tmp4_;
	_tmp5_ = subtitle;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (self->subtitle);
	self->subtitle = _tmp6_;
	return self;
}


RygelHTTPGet* rygel_http_get_new (RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	return rygel_http_get_construct (RYGEL_TYPE_HTTP_GET, thumbnail, subtitle);
}


RygelHTTPGet* rygel_http_get_construct_seek_start (GType object_type, gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	gint64 _tmp2_;
	_tmp0_ = thumbnail;
	_tmp1_ = subtitle;
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, _tmp0_, _tmp1_);
	_tmp2_ = start;
	rygel_http_get_add_headers (self, _tmp2_, (gint64) (-1));
	return self;
}


RygelHTTPGet* rygel_http_get_new_seek_start (gint64 start, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	return rygel_http_get_construct_seek_start (RYGEL_TYPE_HTTP_GET, start, thumbnail, subtitle);
}


RygelHTTPGet* rygel_http_get_construct_seek_stop (GType object_type, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	gint64 _tmp2_;
	_tmp0_ = thumbnail;
	_tmp1_ = subtitle;
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, _tmp0_, _tmp1_);
	_tmp2_ = stop;
	rygel_http_get_add_headers (self, (gint64) 0, _tmp2_);
	return self;
}


RygelHTTPGet* rygel_http_get_new_seek_stop (gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	return rygel_http_get_construct_seek_stop (RYGEL_TYPE_HTTP_GET, stop, thumbnail, subtitle);
}


RygelHTTPGet* rygel_http_get_construct_seek_start_stop (GType object_type, gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	RygelHTTPGet * self = NULL;
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	_tmp0_ = thumbnail;
	_tmp1_ = subtitle;
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, _tmp0_, _tmp1_);
	_tmp2_ = start;
	_tmp3_ = stop;
	rygel_http_get_add_headers (self, _tmp2_, _tmp3_);
	return self;
}


RygelHTTPGet* rygel_http_get_new_seek_start_stop (gint64 start, gint64 stop, RygelThumbnail* thumbnail, RygelSubtitle* subtitle) {
	return rygel_http_get_construct_seek_start_stop (RYGEL_TYPE_HTTP_GET, start, stop, thumbnail, subtitle);
}


RygelHTTPGet* rygel_http_get_construct_inverted_range (GType object_type) {
	RygelHTTPGet * self = NULL;
	SoupMessage* _tmp0_;
	SoupMessageHeaders* _tmp1_;
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, NULL, NULL);
	_tmp0_ = self->msg;
	_tmp1_ = _tmp0_->request_headers;
	soup_message_headers_append (_tmp1_, "Range", "bytes=34-0");
	return self;
}


RygelHTTPGet* rygel_http_get_new_inverted_range (void) {
	return rygel_http_get_construct_inverted_range (RYGEL_TYPE_HTTP_GET);
}


RygelHTTPGet* rygel_http_get_construct_invalid_range (GType object_type) {
	RygelHTTPGet * self = NULL;
	SoupMessage* _tmp0_;
	SoupMessageHeaders* _tmp1_;
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type, NULL, NULL);
	_tmp0_ = self->msg;
	_tmp1_ = _tmp0_->request_headers;
	soup_message_headers_append (_tmp1_, "Range", "bytes=a-b");
	return self;
}


RygelHTTPGet* rygel_http_get_new_invalid_range (void) {
	return rygel_http_get_construct_invalid_range (RYGEL_TYPE_HTTP_GET);
}


static void rygel_http_get_add_headers (RygelHTTPGet* self, gint64 start, gint64 stop) {
	SoupMessage* _tmp0_;
	SoupMessageHeaders* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->msg;
	_tmp1_ = _tmp0_->request_headers;
	_tmp2_ = start;
	_tmp3_ = stop;
	soup_message_headers_set_range (_tmp1_, _tmp2_, _tmp3_);
}


static void rygel_http_get_class_init (RygelHTTPGetClass * klass) {
	rygel_http_get_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_finalize;
}


static void rygel_http_get_instance_init (RygelHTTPGet * self) {
}


static void rygel_http_get_finalize (GObject* obj) {
	RygelHTTPGet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_GET, RygelHTTPGet);
	_g_object_unref0 (self->msg);
	_g_object_unref0 (self->object);
	_g_object_unref0 (self->thumbnail);
	_g_object_unref0 (self->subtitle);
	_g_object_unref0 (self->handler);
	G_OBJECT_CLASS (rygel_http_get_parent_class)->finalize (obj);
}


GType rygel_http_get_get_type (void) {
	static volatile gsize rygel_http_get_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGet), 0, (GInstanceInitFunc) rygel_http_get_instance_init, NULL };
		GType rygel_http_get_type_id;
		rygel_http_get_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPGet", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_type_id__volatile, rygel_http_get_type_id);
	}
	return rygel_http_get_type_id__volatile;
}


gint rygel_http_byte_seek_test_main (gchar** args, int args_length1) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		RygelHTTPByteSeekTest* _tmp0_;
		RygelHTTPByteSeekTest* test;
		RygelHTTPByteSeekTest* _tmp1_;
		_tmp0_ = rygel_http_byte_seek_test_new ();
		test = _tmp0_;
		_tmp1_ = test;
		rygel_http_byte_seek_test_run (_tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (test);
			goto __catch0_g_error;
		}
		_g_object_unref0 (test);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _error_;
		_tmp3_ = _tmp2_->message;
		g_critical ("rygel-http-byte-seek-test.vala:119: %s", _tmp3_);
		result = -1;
		_g_error_free0 (_error_);
		return result;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return rygel_http_byte_seek_test_main (argv, argc);
}


void rygel_http_byte_seek_test_run (RygelHTTPByteSeekTest* self, GError** error) {
	RygelThumbnail* _tmp0_;
	RygelThumbnail** _tmp1_ = NULL;
	RygelThumbnail** thumbnails;
	gint thumbnails_length1;
	gint _thumbnails_size_;
	RygelSubtitle* _tmp2_;
	RygelSubtitle** _tmp3_ = NULL;
	RygelSubtitle** subtitles;
	gint subtitles_length1;
	gint _subtitles_size_;
	RygelThumbnail** _tmp4_;
	gint _tmp4__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = rygel_thumbnail_new ();
	_tmp1_ = g_new0 (RygelThumbnail*, 2 + 1);
	_tmp1_[0] = NULL;
	_tmp1_[1] = _tmp0_;
	thumbnails = _tmp1_;
	thumbnails_length1 = 2;
	_thumbnails_size_ = thumbnails_length1;
	_tmp2_ = rygel_subtitle_new ();
	_tmp3_ = g_new0 (RygelSubtitle*, 2 + 1);
	_tmp3_[0] = NULL;
	_tmp3_[1] = _tmp2_;
	subtitles = _tmp3_;
	subtitles_length1 = 2;
	_subtitles_size_ = subtitles_length1;
	_tmp4_ = thumbnails;
	_tmp4__length1 = thumbnails_length1;
	{
		RygelThumbnail** thumbnail_collection = NULL;
		gint thumbnail_collection_length1 = 0;
		gint _thumbnail_collection_size_ = 0;
		gint thumbnail_it = 0;
		thumbnail_collection = _tmp4_;
		thumbnail_collection_length1 = _tmp4__length1;
		for (thumbnail_it = 0; thumbnail_it < _tmp4__length1; thumbnail_it = thumbnail_it + 1) {
			RygelThumbnail* _tmp5_;
			RygelThumbnail* thumbnail = NULL;
			_tmp5_ = _g_object_ref0 (thumbnail_collection[thumbnail_it]);
			thumbnail = _tmp5_;
			{
				RygelSubtitle** _tmp6_;
				gint _tmp6__length1;
				_tmp6_ = subtitles;
				_tmp6__length1 = subtitles_length1;
				{
					RygelSubtitle** subtitle_collection = NULL;
					gint subtitle_collection_length1 = 0;
					gint _subtitle_collection_size_ = 0;
					gint subtitle_it = 0;
					subtitle_collection = _tmp6_;
					subtitle_collection_length1 = _tmp6__length1;
					for (subtitle_it = 0; subtitle_it < _tmp6__length1; subtitle_it = subtitle_it + 1) {
						RygelSubtitle* _tmp7_;
						RygelSubtitle* subtitle = NULL;
						_tmp7_ = _g_object_ref0 (subtitle_collection[subtitle_it]);
						subtitle = _tmp7_;
						{
							RygelThumbnail* _tmp8_;
							RygelSubtitle* _tmp9_;
							RygelThumbnail* _tmp10_;
							RygelSubtitle* _tmp11_;
							RygelThumbnail* _tmp12_;
							RygelSubtitle* _tmp13_;
							RygelThumbnail* _tmp14_;
							RygelSubtitle* _tmp15_;
							_tmp8_ = thumbnail;
							_tmp9_ = subtitle;
							rygel_http_byte_seek_test_test_no_seek (self, _tmp8_, _tmp9_, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									return;
								} else {
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_tmp10_ = thumbnail;
							_tmp11_ = subtitle;
							rygel_http_byte_seek_test_test_start_only_seek (self, _tmp10_, _tmp11_, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									return;
								} else {
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_tmp12_ = thumbnail;
							_tmp13_ = subtitle;
							rygel_http_byte_seek_test_test_stop_only_seek (self, _tmp12_, _tmp13_, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									return;
								} else {
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_tmp14_ = thumbnail;
							_tmp15_ = subtitle;
							rygel_http_byte_seek_test_test_start_stop_seek (self, _tmp14_, _tmp15_, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									return;
								} else {
									_g_object_unref0 (subtitle);
									_g_object_unref0 (thumbnail);
									subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
									thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_g_object_unref0 (subtitle);
						}
					}
				}
				_g_object_unref0 (thumbnail);
			}
		}
	}
	{
		RygelHTTPGet* _tmp16_;
		RygelHTTPGet* _tmp17_;
		RygelHTTPByteSeek* _tmp18_;
		RygelHTTPByteSeek* _tmp19_;
		_tmp16_ = rygel_http_get_new_inverted_range ();
		_tmp17_ = _tmp16_;
		_tmp18_ = rygel_http_byte_seek_new (_tmp17_, &_inner_error_);
		_tmp19_ = _tmp18_;
		_g_object_unref0 (_tmp19_);
		_g_object_unref0 (_tmp17_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
				goto __catch1_rygel_http_seek_error;
			}
			subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
			thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		g_assert_not_reached ();
	}
	goto __finally1;
	__catch1_rygel_http_seek_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
			thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
			return;
		} else {
			subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
			thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	{
		RygelHTTPGet* _tmp20_;
		RygelHTTPGet* _tmp21_;
		RygelHTTPByteSeek* _tmp22_;
		RygelHTTPByteSeek* _tmp23_;
		_tmp20_ = rygel_http_get_new_invalid_range ();
		_tmp21_ = _tmp20_;
		_tmp22_ = rygel_http_byte_seek_new (_tmp21_, &_inner_error_);
		_tmp23_ = _tmp22_;
		_g_object_unref0 (_tmp23_);
		_g_object_unref0 (_tmp21_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
				goto __catch2_rygel_http_seek_error;
			}
			subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
			thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		g_assert_not_reached ();
	}
	goto __finally2;
	__catch2_rygel_http_seek_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
			thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
			return;
		} else {
			subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
			thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	subtitles = (_vala_array_free (subtitles, subtitles_length1, (GDestroyNotify) g_object_unref), NULL);
	thumbnails = (_vala_array_free (thumbnails, thumbnails_length1, (GDestroyNotify) g_object_unref), NULL);
}


static RygelHTTPByteSeekTest* rygel_http_byte_seek_test_construct (GType object_type) {
	RygelHTTPByteSeekTest * self = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelHTTPByteSeekTest*) g_object_new (object_type, NULL);
	{
		GRegex* _tmp0_;
		GRegex* _tmp1_;
		_tmp0_ = g_regex_new ("bytes +[0-9]+-[0-9]+/[0-9]+", G_REGEX_CASELESS, 0, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (self->priv->range_regex);
		self->priv->range_regex = _tmp1_;
	}
	goto __finally3;
	__catch3_g_regex_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


static RygelHTTPByteSeekTest* rygel_http_byte_seek_test_new (void) {
	return rygel_http_byte_seek_test_construct (RYGEL_TYPE_HTTP_BYTE_SEEK_TEST);
}


static void rygel_http_byte_seek_test_test_no_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	RygelHTTPGet* _tmp2_;
	RygelHTTPGet* request;
	gint64 size = 0LL;
	RygelHTTPGet* _tmp3_;
	RygelThumbnail* _tmp4_;
	RygelHTTPGet* _tmp16_;
	gint64 _tmp17_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = thumbnail;
	_tmp1_ = subtitle;
	_tmp2_ = rygel_http_get_new (_tmp0_, _tmp1_);
	request = _tmp2_;
	_tmp3_ = request;
	_tmp4_ = _tmp3_->thumbnail;
	if (_tmp4_ != NULL) {
		RygelHTTPGet* _tmp5_;
		RygelThumbnail* _tmp6_;
		gint64 _tmp7_;
		_tmp5_ = request;
		_tmp6_ = _tmp5_->thumbnail;
		_tmp7_ = _tmp6_->size;
		size = _tmp7_;
	} else {
		RygelHTTPGet* _tmp8_;
		RygelSubtitle* _tmp9_;
		_tmp8_ = request;
		_tmp9_ = _tmp8_->subtitle;
		if (_tmp9_ != NULL) {
			RygelHTTPGet* _tmp10_;
			RygelSubtitle* _tmp11_;
			gint64 _tmp12_;
			_tmp10_ = request;
			_tmp11_ = _tmp10_->subtitle;
			_tmp12_ = _tmp11_->size;
			size = _tmp12_;
		} else {
			RygelHTTPGet* _tmp13_;
			RygelMediaObject* _tmp14_;
			gint64 _tmp15_;
			_tmp13_ = request;
			_tmp14_ = _tmp13_->object;
			_tmp15_ = _tmp14_->size;
			size = _tmp15_;
		}
	}
	_tmp16_ = request;
	_tmp17_ = size;
	rygel_http_byte_seek_test_test_seek (self, _tmp16_, (gint64) 0, _tmp17_ - 1, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (request);
			return;
		} else {
			_g_object_unref0 (request);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (request);
}


static void rygel_http_byte_seek_test_test_start_only_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	RygelHTTPGet* _tmp2_;
	RygelHTTPGet* request;
	gint64 size = 0LL;
	RygelHTTPGet* _tmp3_;
	RygelThumbnail* _tmp4_;
	RygelHTTPGet* _tmp16_;
	gint64 _tmp17_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = thumbnail;
	_tmp1_ = subtitle;
	_tmp2_ = rygel_http_get_new_seek_start ((gint64) 128, _tmp0_, _tmp1_);
	request = _tmp2_;
	_tmp3_ = request;
	_tmp4_ = _tmp3_->thumbnail;
	if (_tmp4_ != NULL) {
		RygelHTTPGet* _tmp5_;
		RygelThumbnail* _tmp6_;
		gint64 _tmp7_;
		_tmp5_ = request;
		_tmp6_ = _tmp5_->thumbnail;
		_tmp7_ = _tmp6_->size;
		size = _tmp7_;
	} else {
		RygelHTTPGet* _tmp8_;
		RygelSubtitle* _tmp9_;
		_tmp8_ = request;
		_tmp9_ = _tmp8_->subtitle;
		if (_tmp9_ != NULL) {
			RygelHTTPGet* _tmp10_;
			RygelSubtitle* _tmp11_;
			gint64 _tmp12_;
			_tmp10_ = request;
			_tmp11_ = _tmp10_->subtitle;
			_tmp12_ = _tmp11_->size;
			size = _tmp12_;
		} else {
			RygelHTTPGet* _tmp13_;
			RygelMediaObject* _tmp14_;
			gint64 _tmp15_;
			_tmp13_ = request;
			_tmp14_ = _tmp13_->object;
			_tmp15_ = _tmp14_->size;
			size = _tmp15_;
		}
	}
	_tmp16_ = request;
	_tmp17_ = size;
	rygel_http_byte_seek_test_test_seek (self, _tmp16_, (gint64) 128, _tmp17_ - 1, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (request);
			return;
		} else {
			_g_object_unref0 (request);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (request);
}


static void rygel_http_byte_seek_test_test_stop_only_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	RygelHTTPGet* _tmp2_;
	RygelHTTPGet* request;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = thumbnail;
	_tmp1_ = subtitle;
	_tmp2_ = rygel_http_get_new_seek_stop ((gint64) 128, _tmp0_, _tmp1_);
	request = _tmp2_;
	rygel_http_byte_seek_test_test_seek (self, request, (gint64) 0, (gint64) 128, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (request);
			return;
		} else {
			_g_object_unref0 (request);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (request);
}


static void rygel_http_byte_seek_test_test_start_stop_seek (RygelHTTPByteSeekTest* self, RygelThumbnail* thumbnail, RygelSubtitle* subtitle, GError** error) {
	RygelThumbnail* _tmp0_;
	RygelSubtitle* _tmp1_;
	RygelHTTPGet* _tmp2_;
	RygelHTTPGet* request;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = thumbnail;
	_tmp1_ = subtitle;
	_tmp2_ = rygel_http_get_new_seek_start_stop ((gint64) 128, (gint64) 256, _tmp0_, _tmp1_);
	request = _tmp2_;
	rygel_http_byte_seek_test_test_seek (self, request, (gint64) 128, (gint64) 256, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (request);
			return;
		} else {
			_g_object_unref0 (request);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (request);
}


static void rygel_http_byte_seek_test_test_seek (RygelHTTPByteSeekTest* self, RygelHTTPGet* request, gint64 start, gint64 stop, GError** error) {
	RygelHTTPGet* _tmp0_;
	gboolean _tmp1_ = FALSE;
	RygelHTTPGet* _tmp2_;
	RygelHTTPByteSeek* _tmp3_;
	RygelHTTPByteSeek* seek;
	gint64 _tmp4_;
	gint64 _tmp5_;
	gint64 _tmp6_;
	gint64 _tmp7_;
	gint64 _tmp8_;
	gint64 _tmp9_;
	RygelHTTPGet* _tmp10_;
	RygelThumbnail* _tmp11_;
	RygelHTTPGet* _tmp29_;
	SoupMessage* _tmp30_;
	SoupMessageHeaders* _tmp31_;
	const gchar* _tmp32_ = NULL;
	RygelHTTPGet* _tmp48_;
	SoupMessage* _tmp49_;
	SoupMessageHeaders* _tmp50_;
	gint64 _tmp51_ = 0LL;
	gint64 _tmp52_;
	gint64 _tmp53_;
	RygelHTTPGet* _tmp54_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (request != NULL);
	_tmp0_ = request;
	_tmp1_ = rygel_http_byte_seek_needed (_tmp0_);
	_vala_assert (_tmp1_, "HTTPByteSeek.needed (request)");
	_tmp2_ = request;
	_tmp3_ = rygel_http_byte_seek_new (_tmp2_, &_inner_error_);
	seek = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	rygel_http_seek_add_response_headers ((RygelHTTPSeek*) seek);
	_vala_assert (seek != NULL, "seek != null");
	_tmp4_ = rygel_http_seek_get_start ((RygelHTTPSeek*) seek);
	_tmp5_ = _tmp4_;
	_tmp6_ = start;
	_vala_assert (_tmp5_ == _tmp6_, "seek.start == start");
	_tmp7_ = rygel_http_seek_get_stop ((RygelHTTPSeek*) seek);
	_tmp8_ = _tmp7_;
	_tmp9_ = stop;
	_vala_assert (_tmp8_ == _tmp9_, "seek.stop == stop");
	_tmp10_ = request;
	_tmp11_ = _tmp10_->thumbnail;
	if (_tmp11_ != NULL) {
		gint64 _tmp12_;
		gint64 _tmp13_;
		RygelHTTPGet* _tmp14_;
		RygelThumbnail* _tmp15_;
		gint64 _tmp16_;
		_tmp12_ = rygel_http_seek_get_total_length ((RygelHTTPSeek*) seek);
		_tmp13_ = _tmp12_;
		_tmp14_ = request;
		_tmp15_ = _tmp14_->thumbnail;
		_tmp16_ = _tmp15_->size;
		_vala_assert (_tmp13_ == _tmp16_, "seek.total_length == request.thumbnail.size");
	} else {
		RygelHTTPGet* _tmp17_;
		RygelSubtitle* _tmp18_;
		_tmp17_ = request;
		_tmp18_ = _tmp17_->subtitle;
		if (_tmp18_ != NULL) {
			gint64 _tmp19_;
			gint64 _tmp20_;
			RygelHTTPGet* _tmp21_;
			RygelSubtitle* _tmp22_;
			gint64 _tmp23_;
			_tmp19_ = rygel_http_seek_get_total_length ((RygelHTTPSeek*) seek);
			_tmp20_ = _tmp19_;
			_tmp21_ = request;
			_tmp22_ = _tmp21_->subtitle;
			_tmp23_ = _tmp22_->size;
			_vala_assert (_tmp20_ == _tmp23_, "seek.total_length == request.subtitle.size");
		} else {
			gint64 _tmp24_;
			gint64 _tmp25_;
			RygelHTTPGet* _tmp26_;
			RygelMediaObject* _tmp27_;
			gint64 _tmp28_;
			_tmp24_ = rygel_http_seek_get_total_length ((RygelHTTPSeek*) seek);
			_tmp25_ = _tmp24_;
			_tmp26_ = request;
			_tmp27_ = _tmp26_->object;
			_tmp28_ = _tmp27_->size;
			_vala_assert (_tmp25_ == _tmp28_, "seek.total_length == request.object.size");
		}
	}
	_tmp29_ = request;
	_tmp30_ = _tmp29_->msg;
	_tmp31_ = _tmp30_->request_headers;
	_tmp32_ = soup_message_headers_get_one (_tmp31_, "Range");
	if (_tmp32_ != NULL) {
		RygelHTTPGet* _tmp33_;
		SoupMessage* _tmp34_;
		SoupMessageHeaders* _tmp35_;
		const gchar* _tmp36_ = NULL;
		gchar* _tmp37_;
		gchar* header;
		const gchar* _tmp38_;
		RygelHTTPGet* _tmp39_;
		SoupMessage* _tmp40_;
		SoupMessageHeaders* _tmp41_;
		const gchar* _tmp42_ = NULL;
		gchar* _tmp43_;
		const gchar* _tmp44_;
		GRegex* _tmp45_;
		const gchar* _tmp46_;
		gboolean _tmp47_ = FALSE;
		_tmp33_ = request;
		_tmp34_ = _tmp33_->msg;
		_tmp35_ = _tmp34_->response_headers;
		_tmp36_ = soup_message_headers_get_one (_tmp35_, "Accept-Ranges");
		_tmp37_ = g_strdup (_tmp36_);
		header = _tmp37_;
		_tmp38_ = header;
		_vala_assert (g_strcmp0 (_tmp38_, "bytes") == 0, "header == \"bytes\"");
		_tmp39_ = request;
		_tmp40_ = _tmp39_->msg;
		_tmp41_ = _tmp40_->response_headers;
		_tmp42_ = soup_message_headers_get_one (_tmp41_, "Content-Range");
		_tmp43_ = g_strdup (_tmp42_);
		_g_free0 (header);
		header = _tmp43_;
		_tmp44_ = header;
		_vala_assert (_tmp44_ != NULL, "header != null");
		_tmp45_ = self->priv->range_regex;
		_tmp46_ = header;
		_tmp47_ = g_regex_match (_tmp45_, _tmp46_, 0, NULL);
		_vala_assert (_tmp47_, "this.range_regex.match (header)");
		_g_free0 (header);
	}
	_tmp48_ = request;
	_tmp49_ = _tmp48_->msg;
	_tmp50_ = _tmp49_->response_headers;
	_tmp51_ = soup_message_headers_get_content_length (_tmp50_);
	_tmp52_ = rygel_http_seek_get_length ((RygelHTTPSeek*) seek);
	_tmp53_ = _tmp52_;
	_vala_assert (_tmp51_ == _tmp53_, "request.msg.response_headers.get_content_length () ==                 seek.length");
	_tmp54_ = request;
	rygel_http_byte_seek_requested (_tmp54_);
	_g_object_unref0 (seek);
}


static void rygel_http_byte_seek_test_class_init (RygelHTTPByteSeekTestClass * klass) {
	rygel_http_byte_seek_test_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPByteSeekTestPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_http_byte_seek_test_finalize;
}


static void rygel_http_byte_seek_test_instance_init (RygelHTTPByteSeekTest * self) {
	self->priv = RYGEL_HTTP_BYTE_SEEK_TEST_GET_PRIVATE (self);
}


static void rygel_http_byte_seek_test_finalize (GObject* obj) {
	RygelHTTPByteSeekTest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_BYTE_SEEK_TEST, RygelHTTPByteSeekTest);
	_g_regex_unref0 (self->priv->range_regex);
	G_OBJECT_CLASS (rygel_http_byte_seek_test_parent_class)->finalize (obj);
}


GType rygel_http_byte_seek_test_get_type (void) {
	static volatile gsize rygel_http_byte_seek_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_byte_seek_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPByteSeekTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_byte_seek_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPByteSeekTest), 0, (GInstanceInitFunc) rygel_http_byte_seek_test_instance_init, NULL };
		GType rygel_http_byte_seek_test_type_id;
		rygel_http_byte_seek_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPByteSeekTest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_byte_seek_test_type_id__volatile, rygel_http_byte_seek_test_type_id);
	}
	return rygel_http_byte_seek_test_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



