/* geocoding.c generated by valac 0.21.1.40-3bbfb, the Vala compiler
 * generated from geocoding.vala, do not modify */

/*
 * Copyright (C) 2013  Evgeny Bobkin <evgen.ibqn@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <libgweather/gweather.h>
#include <geocode-glib/geocode-glib.h>


#define CLOCKS_GEO_TYPE_MANAGER (clocks_geo_manager_get_type ())
#define CLOCKS_GEO_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_GEO_TYPE_MANAGER, ClocksGeoManager))
#define CLOCKS_GEO_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_GEO_TYPE_MANAGER))
#define CLOCKS_GEO_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_GEO_TYPE_MANAGER, ClocksGeoManagerIface))

typedef struct _ClocksGeoManager ClocksGeoManager;
typedef struct _ClocksGeoManagerIface ClocksGeoManagerIface;

#define CLOCKS_GEO_TYPE_MANAGER_PROXY (clocks_geo_manager_proxy_get_type ())
typedef GDBusProxy ClocksGeoManagerProxy;
typedef GDBusProxyClass ClocksGeoManagerProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define CLOCKS_GEO_TYPE_CLIENT (clocks_geo_client_get_type ())
#define CLOCKS_GEO_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_GEO_TYPE_CLIENT, ClocksGeoClient))
#define CLOCKS_GEO_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_GEO_TYPE_CLIENT))
#define CLOCKS_GEO_CLIENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_GEO_TYPE_CLIENT, ClocksGeoClientIface))

typedef struct _ClocksGeoClient ClocksGeoClient;
typedef struct _ClocksGeoClientIface ClocksGeoClientIface;

#define CLOCKS_GEO_TYPE_CLIENT_PROXY (clocks_geo_client_proxy_get_type ())
typedef GDBusProxy ClocksGeoClientProxy;
typedef GDBusProxyClass ClocksGeoClientProxyClass;

#define CLOCKS_GEO_TYPE_LOCATION (clocks_geo_location_get_type ())
#define CLOCKS_GEO_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_GEO_TYPE_LOCATION, ClocksGeoLocation))
#define CLOCKS_GEO_IS_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_GEO_TYPE_LOCATION))
#define CLOCKS_GEO_LOCATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_GEO_TYPE_LOCATION, ClocksGeoLocationIface))

typedef struct _ClocksGeoLocation ClocksGeoLocation;
typedef struct _ClocksGeoLocationIface ClocksGeoLocationIface;

#define CLOCKS_GEO_TYPE_LOCATION_PROXY (clocks_geo_location_proxy_get_type ())
typedef GDBusProxy ClocksGeoLocationProxy;
typedef GDBusProxyClass ClocksGeoLocationProxyClass;

#define CLOCKS_GEO_TYPE_INFO (clocks_geo_info_get_type ())
#define CLOCKS_GEO_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_GEO_TYPE_INFO, ClocksGeoInfo))
#define CLOCKS_GEO_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_GEO_TYPE_INFO, ClocksGeoInfoClass))
#define CLOCKS_GEO_IS_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_GEO_TYPE_INFO))
#define CLOCKS_GEO_IS_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_GEO_TYPE_INFO))
#define CLOCKS_GEO_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_GEO_TYPE_INFO, ClocksGeoInfoClass))

typedef struct _ClocksGeoInfo ClocksGeoInfo;
typedef struct _ClocksGeoInfoClass ClocksGeoInfoClass;
typedef struct _ClocksGeoInfoPrivate ClocksGeoInfoPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GWeatherLocation_free0(var) ((var == NULL) ? NULL : (var = (_vala_GWeatherLocation_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ClocksGeoInfoSeekData ClocksGeoInfoSeekData;
typedef struct _ClocksGeoInfoOnLocationUpdatedData ClocksGeoInfoOnLocationUpdatedData;
typedef struct _ClocksGeoInfoSeekCountryCodeData ClocksGeoInfoSeekCountryCodeData;
typedef struct _ClocksGeoInfoSearchLocationsData ClocksGeoInfoSearchLocationsData;
#define __vala_GWeatherTimezone_free0(var) ((var == NULL) ? NULL : (var = (_vala_GWeatherTimezone_free (var), NULL)))

struct _ClocksGeoManagerIface {
	GTypeInterface parent_iface;
	void (*get_client) (ClocksGeoManager* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*get_client_finish) (ClocksGeoManager* self, GAsyncResult* _res_, gchar** client_path, GError** error);
};

struct _ClocksGeoClientIface {
	GTypeInterface parent_iface;
	void (*start) (ClocksGeoClient* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*start_finish) (ClocksGeoClient* self, GAsyncResult* _res_, GError** error);
	gchar* (*get_location) (ClocksGeoClient* self);
	guint (*get_distance_threshold) (ClocksGeoClient* self);
	void (*set_distance_threshold) (ClocksGeoClient* self, guint value);
};

struct _ClocksGeoLocationIface {
	GTypeInterface parent_iface;
	gdouble (*get_latitude) (ClocksGeoLocation* self);
	gdouble (*get_longitude) (ClocksGeoLocation* self);
	gdouble (*get_accuracy) (ClocksGeoLocation* self);
	gchar* (*get_description) (ClocksGeoLocation* self);
};

struct _ClocksGeoInfo {
	GObject parent_instance;
	ClocksGeoInfoPrivate * priv;
};

struct _ClocksGeoInfoClass {
	GObjectClass parent_class;
};

struct _ClocksGeoInfoPrivate {
	ClocksGeoLocation* _geo_location;
	GWeatherLocation* found_location;
	gchar* country_code;
	ClocksGeoManager* manager;
	ClocksGeoClient* client;
	gdouble minimal_distance;
};

struct _ClocksGeoInfoSeekData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ClocksGeoInfo* self;
	gchar* client_path;
	ClocksGeoManager* _tmp0_;
	ClocksGeoManager* _tmp1_;
	GError* e;
	GError* _tmp2_;
	const gchar* _tmp3_;
	ClocksGeoManager* _tmp4_;
	gchar* _tmp5_;
	GError* _vala1_e;
	GError* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	ClocksGeoClient* _tmp9_;
	const gchar* _tmp10_;
	ClocksGeoClient* _tmp11_;
	GError* _vala2_e;
	GError* _tmp12_;
	const gchar* _tmp13_;
	ClocksGeoClient* _tmp14_;
	ClocksGeoClient* _tmp15_;
	GError* _vala3_e;
	GError* _tmp16_;
	const gchar* _tmp17_;
	GError * _inner_error_;
};

struct _ClocksGeoInfoOnLocationUpdatedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ClocksGeoInfo* self;
	gchar* old_path;
	gchar* new_path;
	ClocksGeoLocation* _tmp0_;
	const gchar* _tmp1_;
	ClocksGeoLocation* _tmp2_;
	ClocksGeoLocation* _tmp3_;
	GError* e;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GWeatherLocation* _tmp6_;
	GWeatherLocation* _tmp7_;
	GWeatherLocation* _tmp8_;
	GError * _inner_error_;
};

struct _ClocksGeoInfoSeekCountryCodeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ClocksGeoInfo* self;
	GeocodeLocation* location;
	ClocksGeoLocation* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	ClocksGeoLocation* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	GeocodeLocation* _tmp6_;
	GeocodeReverse* reverse;
	GeocodeReverse* _tmp7_;
	GeocodePlace* place;
	GeocodePlace* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GError* e;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GError * _inner_error_;
};

struct _ClocksGeoInfoSearchLocationsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ClocksGeoInfo* self;
	GWeatherLocation* location;
	const gchar* _tmp0_;
	gchar* loc_country_code;
	GWeatherLocation* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GWeatherLocation** locations;
	GWeatherLocation* _tmp7_;
	GWeatherLocation** _tmp8_;
	GWeatherLocation** _tmp9_;
	GWeatherLocation** _tmp10_;
	gint _tmp10__length1;
	gint locations_length1;
	gint _locations_size_;
	GWeatherLocation** _tmp11_;
	gint _tmp11__length1;
	gint i;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GWeatherLocation** _tmp16_;
	gint _tmp16__length1;
	GWeatherLocation** _tmp17_;
	gint _tmp17__length1;
	gint _tmp18_;
	GWeatherLocation* _tmp19_;
	GWeatherLocationLevel _tmp20_;
	GWeatherLocation** _tmp21_;
	gint _tmp21__length1;
	gint _tmp22_;
	GWeatherLocation* _tmp23_;
	gboolean _tmp24_;
	gdouble latitude;
	gdouble longitude;
	gdouble distance;
	GWeatherLocation** _tmp25_;
	gint _tmp25__length1;
	gint _tmp26_;
	GWeatherLocation* _tmp27_;
	gdouble _tmp28_;
	gdouble _tmp29_;
	ClocksGeoLocation* _tmp30_;
	gdouble _tmp31_;
	gdouble _tmp32_;
	ClocksGeoLocation* _tmp33_;
	gdouble _tmp34_;
	gdouble _tmp35_;
	gdouble _tmp36_;
	gdouble _tmp37_;
	gdouble _tmp38_;
	gdouble _tmp39_;
	gdouble _tmp40_;
	GWeatherLocation** _tmp41_;
	gint _tmp41__length1;
	gint _tmp42_;
	GWeatherLocation* _tmp43_;
	GWeatherLocation* _tmp44_;
	gdouble _tmp45_;
	GWeatherLocation** _tmp46_;
	gint _tmp46__length1;
	gint _tmp47_;
	GWeatherLocation* _tmp48_;
};


static gpointer clocks_geo_info_parent_class = NULL;

GType clocks_geo_manager_proxy_get_type (void) G_GNUC_CONST;
guint clocks_geo_manager_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType clocks_geo_manager_get_type (void) G_GNUC_CONST;
void clocks_geo_manager_get_client (ClocksGeoManager* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void clocks_geo_manager_get_client_finish (ClocksGeoManager* self, GAsyncResult* _res_, gchar** client_path, GError** error);
static void clocks_geo_manager_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void clocks_geo_manager_proxy_get_client_async (ClocksGeoManager* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void clocks_geo_manager_proxy_get_client_finish (ClocksGeoManager* self, GAsyncResult* _res_, gchar** client_path, GError** error);
static void clocks_geo_manager_proxy_clocks_geo_manager_interface_init (ClocksGeoManagerIface* iface);
static void _dbus_clocks_geo_manager_get_client (ClocksGeoManager* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_clocks_geo_manager_get_client_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void clocks_geo_manager_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* clocks_geo_manager_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean clocks_geo_manager_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _clocks_geo_manager_unregister_object (gpointer user_data);
GType clocks_geo_client_proxy_get_type (void) G_GNUC_CONST;
guint clocks_geo_client_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType clocks_geo_client_get_type (void) G_GNUC_CONST;
void clocks_geo_client_start (ClocksGeoClient* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void clocks_geo_client_start_finish (ClocksGeoClient* self, GAsyncResult* _res_, GError** error);
gchar* clocks_geo_client_get_location (ClocksGeoClient* self);
guint clocks_geo_client_get_distance_threshold (ClocksGeoClient* self);
void clocks_geo_client_set_distance_threshold (ClocksGeoClient* self, guint value);
static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void clocks_geo_client_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_clocks_geo_client_location_updated (ClocksGeoClient* self, GVariant* parameters);
static void clocks_geo_client_proxy_start_async (ClocksGeoClient* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void clocks_geo_client_proxy_start_finish (ClocksGeoClient* self, GAsyncResult* _res_, GError** error);
static gchar* clocks_geo_client_dbus_proxy_get_location (ClocksGeoClient* self);
static guint clocks_geo_client_dbus_proxy_get_distance_threshold (ClocksGeoClient* self);
static void clocks_geo_client_dbus_proxy_set_distance_threshold (ClocksGeoClient* self, guint value);
static void clocks_geo_client_proxy_clocks_geo_client_interface_init (ClocksGeoClientIface* iface);
static void _dbus_clocks_geo_client_start (ClocksGeoClient* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_clocks_geo_client_start_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void clocks_geo_client_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* clocks_geo_client_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static GVariant* _dbus_clocks_geo_client_get_location (ClocksGeoClient* self);
static GVariant* _dbus_clocks_geo_client_get_distance_threshold (ClocksGeoClient* self);
static gboolean clocks_geo_client_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_clocks_geo_client_set_distance_threshold (ClocksGeoClient* self, GVariant* _value);
static void _dbus_clocks_geo_client_location_updated (GObject* _sender, const gchar* old_path, const gchar* new_path, gpointer* _data);
static void _clocks_geo_client_unregister_object (gpointer user_data);
GType clocks_geo_location_get_type (void) G_GNUC_CONST;
GType clocks_geo_location_proxy_get_type (void) G_GNUC_CONST;
guint clocks_geo_location_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
gdouble clocks_geo_location_get_latitude (ClocksGeoLocation* self);
gdouble clocks_geo_location_get_longitude (ClocksGeoLocation* self);
gdouble clocks_geo_location_get_accuracy (ClocksGeoLocation* self);
gchar* clocks_geo_location_get_description (ClocksGeoLocation* self);
static void clocks_geo_location_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static gdouble clocks_geo_location_dbus_proxy_get_latitude (ClocksGeoLocation* self);
static gdouble clocks_geo_location_dbus_proxy_get_longitude (ClocksGeoLocation* self);
static gdouble clocks_geo_location_dbus_proxy_get_accuracy (ClocksGeoLocation* self);
static gchar* clocks_geo_location_dbus_proxy_get_description (ClocksGeoLocation* self);
static void clocks_geo_location_proxy_clocks_geo_location_interface_init (ClocksGeoLocationIface* iface);
static void clocks_geo_location_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* clocks_geo_location_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static GVariant* _dbus_clocks_geo_location_get_latitude (ClocksGeoLocation* self);
static GVariant* _dbus_clocks_geo_location_get_longitude (ClocksGeoLocation* self);
static GVariant* _dbus_clocks_geo_location_get_accuracy (ClocksGeoLocation* self);
static GVariant* _dbus_clocks_geo_location_get_description (ClocksGeoLocation* self);
static gboolean clocks_geo_location_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _clocks_geo_location_unregister_object (gpointer user_data);
GType clocks_geo_info_get_type (void) G_GNUC_CONST;
#define CLOCKS_GEO_INFO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_GEO_TYPE_INFO, ClocksGeoInfoPrivate))
enum  {
	CLOCKS_GEO_INFO_DUMMY_PROPERTY,
	CLOCKS_GEO_INFO_GEO_LOCATION
};
static void _vala_GWeatherLocation_free (GWeatherLocation* self);
ClocksGeoInfo* clocks_geo_info_new (void);
ClocksGeoInfo* clocks_geo_info_construct (GType object_type);
static void clocks_geo_info_seek_data_free (gpointer _data);
void clocks_geo_info_seek (ClocksGeoInfo* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void clocks_geo_info_seek_finish (ClocksGeoInfo* self, GAsyncResult* _res_);
static gboolean clocks_geo_info_seek_co (ClocksGeoInfoSeekData* _data_);
static void clocks_geo_info_seek_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void clocks_geo_info_on_location_updated (ClocksGeoInfo* self, const gchar* old_path, const gchar* new_path, GAsyncReadyCallback _callback_, gpointer _user_data_);
void clocks_geo_info_on_location_updated_finish (ClocksGeoInfo* self, GAsyncResult* _res_);
static void _clocks_geo_info_on_location_updated_clocks_geo_client_location_updated (ClocksGeoClient* _sender, const gchar* old_path, const gchar* new_path, gpointer self);
static void clocks_geo_info_on_location_updated_data_free (gpointer _data);
static gboolean clocks_geo_info_on_location_updated_co (ClocksGeoInfoOnLocationUpdatedData* _data_);
static void clocks_geo_info_on_location_updated_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void clocks_geo_info_set_geo_location (ClocksGeoInfo* self, ClocksGeoLocation* value);
static void clocks_geo_info_seek_country_code (ClocksGeoInfo* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void clocks_geo_info_seek_country_code_finish (ClocksGeoInfo* self, GAsyncResult* _res_);
static void clocks_geo_info_search_locations (ClocksGeoInfo* self, GWeatherLocation* location, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void clocks_geo_info_search_locations_finish (ClocksGeoInfo* self, GAsyncResult* _res_);
static void clocks_geo_info_seek_country_code_data_free (gpointer _data);
static gboolean clocks_geo_info_seek_country_code_co (ClocksGeoInfoSeekCountryCodeData* _data_);
ClocksGeoLocation* clocks_geo_info_get_geo_location (ClocksGeoInfo* self);
static void clocks_geo_info_seek_country_code_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gdouble clocks_geo_info_deg_to_rad (ClocksGeoInfo* self, gdouble deg);
static gdouble clocks_geo_info_get_distance (ClocksGeoInfo* self, gdouble latitude1, gdouble longitude1, gdouble latitude2, gdouble longitude2);
static void clocks_geo_info_search_locations_data_free (gpointer _data);
static GWeatherLocation* _vala_GWeatherLocation_copy (GWeatherLocation* self);
static gboolean clocks_geo_info_search_locations_co (ClocksGeoInfoSearchLocationsData* _data_);
static GWeatherLocation** _vala_array_dup1 (GWeatherLocation** self, int length);
static void clocks_geo_info_search_locations_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean clocks_geo_info_is_location_similar (ClocksGeoInfo* self, GWeatherLocation* location);
static GWeatherTimezone* _vala_GWeatherTimezone_copy (GWeatherTimezone* self);
static void _vala_GWeatherTimezone_free (GWeatherTimezone* self);
static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void clocks_geo_info_finalize (GObject* obj);
static void _vala_clocks_geo_info_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_clocks_geo_info_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GDBusArgInfo _clocks_geo_manager_dbus_arg_info_get_client_client_path = {-1, "client_path", "s"};
static const GDBusArgInfo * const _clocks_geo_manager_dbus_arg_info_get_client_in[] = {NULL};
static const GDBusArgInfo * const _clocks_geo_manager_dbus_arg_info_get_client_out[] = {&_clocks_geo_manager_dbus_arg_info_get_client_client_path, NULL};
static const GDBusMethodInfo _clocks_geo_manager_dbus_method_info_get_client = {-1, "GetClient", (GDBusArgInfo **) (&_clocks_geo_manager_dbus_arg_info_get_client_in), (GDBusArgInfo **) (&_clocks_geo_manager_dbus_arg_info_get_client_out)};
static const GDBusMethodInfo * const _clocks_geo_manager_dbus_method_info[] = {&_clocks_geo_manager_dbus_method_info_get_client, NULL};
static const GDBusSignalInfo * const _clocks_geo_manager_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _clocks_geo_manager_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _clocks_geo_manager_dbus_interface_info = {-1, "org.freedesktop.GeoClue2.Manager", (GDBusMethodInfo **) (&_clocks_geo_manager_dbus_method_info), (GDBusSignalInfo **) (&_clocks_geo_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_clocks_geo_manager_dbus_property_info)};
static const GDBusInterfaceVTable _clocks_geo_manager_dbus_interface_vtable = {clocks_geo_manager_dbus_interface_method_call, clocks_geo_manager_dbus_interface_get_property, clocks_geo_manager_dbus_interface_set_property};
static const GDBusArgInfo * const _clocks_geo_client_dbus_arg_info_start_in[] = {NULL};
static const GDBusArgInfo * const _clocks_geo_client_dbus_arg_info_start_out[] = {NULL};
static const GDBusMethodInfo _clocks_geo_client_dbus_method_info_start = {-1, "Start", (GDBusArgInfo **) (&_clocks_geo_client_dbus_arg_info_start_in), (GDBusArgInfo **) (&_clocks_geo_client_dbus_arg_info_start_out)};
static const GDBusMethodInfo * const _clocks_geo_client_dbus_method_info[] = {&_clocks_geo_client_dbus_method_info_start, NULL};
static const GDBusArgInfo _clocks_geo_client_dbus_arg_info_location_updated_old_path = {-1, "old_path", "s"};
static const GDBusArgInfo _clocks_geo_client_dbus_arg_info_location_updated_new_path = {-1, "new_path", "s"};
static const GDBusArgInfo * const _clocks_geo_client_dbus_arg_info_location_updated[] = {&_clocks_geo_client_dbus_arg_info_location_updated_old_path, &_clocks_geo_client_dbus_arg_info_location_updated_new_path, NULL};
static const GDBusSignalInfo _clocks_geo_client_dbus_signal_info_location_updated = {-1, "LocationUpdated", (GDBusArgInfo **) (&_clocks_geo_client_dbus_arg_info_location_updated)};
static const GDBusSignalInfo * const _clocks_geo_client_dbus_signal_info[] = {&_clocks_geo_client_dbus_signal_info_location_updated, NULL};
static const GDBusPropertyInfo _clocks_geo_client_dbus_property_info_location = {-1, "Location", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _clocks_geo_client_dbus_property_info_distance_threshold = {-1, "DistanceThreshold", "u", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE};
static const GDBusPropertyInfo * const _clocks_geo_client_dbus_property_info[] = {&_clocks_geo_client_dbus_property_info_location, &_clocks_geo_client_dbus_property_info_distance_threshold, NULL};
static const GDBusInterfaceInfo _clocks_geo_client_dbus_interface_info = {-1, "org.freedesktop.GeoClue2.Client", (GDBusMethodInfo **) (&_clocks_geo_client_dbus_method_info), (GDBusSignalInfo **) (&_clocks_geo_client_dbus_signal_info), (GDBusPropertyInfo **) (&_clocks_geo_client_dbus_property_info)};
static const GDBusInterfaceVTable _clocks_geo_client_dbus_interface_vtable = {clocks_geo_client_dbus_interface_method_call, clocks_geo_client_dbus_interface_get_property, clocks_geo_client_dbus_interface_set_property};
static const GDBusMethodInfo * const _clocks_geo_location_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _clocks_geo_location_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _clocks_geo_location_dbus_property_info_latitude = {-1, "Latitude", "d", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _clocks_geo_location_dbus_property_info_longitude = {-1, "Longitude", "d", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _clocks_geo_location_dbus_property_info_accuracy = {-1, "Accuracy", "d", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _clocks_geo_location_dbus_property_info_description = {-1, "Description", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo * const _clocks_geo_location_dbus_property_info[] = {&_clocks_geo_location_dbus_property_info_latitude, &_clocks_geo_location_dbus_property_info_longitude, &_clocks_geo_location_dbus_property_info_accuracy, &_clocks_geo_location_dbus_property_info_description, NULL};
static const GDBusInterfaceInfo _clocks_geo_location_dbus_interface_info = {-1, "org.freedesktop.GeoClue2.Location", (GDBusMethodInfo **) (&_clocks_geo_location_dbus_method_info), (GDBusSignalInfo **) (&_clocks_geo_location_dbus_signal_info), (GDBusPropertyInfo **) (&_clocks_geo_location_dbus_property_info)};
static const GDBusInterfaceVTable _clocks_geo_location_dbus_interface_vtable = {clocks_geo_location_dbus_interface_method_call, clocks_geo_location_dbus_interface_get_property, clocks_geo_location_dbus_interface_set_property};

void clocks_geo_manager_get_client (ClocksGeoManager* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	CLOCKS_GEO_MANAGER_GET_INTERFACE (self)->get_client (self, _callback_, _user_data_);
}


void clocks_geo_manager_get_client_finish (ClocksGeoManager* self, GAsyncResult* _res_, gchar** client_path, GError** error) {
	CLOCKS_GEO_MANAGER_GET_INTERFACE (self)->get_client_finish (self, _res_, client_path, error);
}


static void clocks_geo_manager_base_init (ClocksGeoManagerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType clocks_geo_manager_get_type (void) {
	static volatile gsize clocks_geo_manager_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_geo_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksGeoManagerIface), (GBaseInitFunc) clocks_geo_manager_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType clocks_geo_manager_type_id;
		clocks_geo_manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "ClocksGeoManager", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (clocks_geo_manager_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (clocks_geo_manager_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) clocks_geo_manager_proxy_get_type);
		g_type_set_qdata (clocks_geo_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.GeoClue2.Manager");
		g_type_set_qdata (clocks_geo_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) clocks_geo_manager_register_object);
		g_once_init_leave (&clocks_geo_manager_type_id__volatile, clocks_geo_manager_type_id);
	}
	return clocks_geo_manager_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (ClocksGeoManagerProxy, clocks_geo_manager_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (CLOCKS_GEO_TYPE_MANAGER, clocks_geo_manager_proxy_clocks_geo_manager_interface_init) )
static void clocks_geo_manager_proxy_class_init (ClocksGeoManagerProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = clocks_geo_manager_proxy_g_signal;
}


static void clocks_geo_manager_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void clocks_geo_manager_proxy_init (ClocksGeoManagerProxy* self) {
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void clocks_geo_manager_proxy_get_client_async (ClocksGeoManager* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.GeoClue2.Manager", "GetClient");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void clocks_geo_manager_proxy_get_client_finish (ClocksGeoManager* self, GAsyncResult* _res_, gchar** client_path, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _vala_client_path;
	GVariant* _tmp0_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_vala_client_path = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	*client_path = _vala_client_path;
	g_object_unref (_reply_message);
}


static void clocks_geo_manager_proxy_clocks_geo_manager_interface_init (ClocksGeoManagerIface* iface) {
	iface->get_client = clocks_geo_manager_proxy_get_client_async;
	iface->get_client_finish = clocks_geo_manager_proxy_get_client_finish;
}


static void _dbus_clocks_geo_manager_get_client (ClocksGeoManager* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	clocks_geo_manager_get_client (self, (GAsyncReadyCallback) _dbus_clocks_geo_manager_get_client_ready, invocation);
}


static void _dbus_clocks_geo_manager_get_client_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* client_path = NULL;
	invocation = _user_data_;
	clocks_geo_manager_get_client_finish ((ClocksGeoManager*) source_object, _res_, &client_path, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (client_path));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (client_path);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void clocks_geo_manager_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetClient") == 0) {
		_dbus_clocks_geo_manager_get_client (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* clocks_geo_manager_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean clocks_geo_manager_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint clocks_geo_manager_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_clocks_geo_manager_dbus_interface_info), &_clocks_geo_manager_dbus_interface_vtable, data, _clocks_geo_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _clocks_geo_manager_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


void clocks_geo_client_start (ClocksGeoClient* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	CLOCKS_GEO_CLIENT_GET_INTERFACE (self)->start (self, _callback_, _user_data_);
}


void clocks_geo_client_start_finish (ClocksGeoClient* self, GAsyncResult* _res_, GError** error) {
	CLOCKS_GEO_CLIENT_GET_INTERFACE (self)->start_finish (self, _res_, error);
}


gchar* clocks_geo_client_get_location (ClocksGeoClient* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return CLOCKS_GEO_CLIENT_GET_INTERFACE (self)->get_location (self);
}


guint clocks_geo_client_get_distance_threshold (ClocksGeoClient* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return CLOCKS_GEO_CLIENT_GET_INTERFACE (self)->get_distance_threshold (self);
}


void clocks_geo_client_set_distance_threshold (ClocksGeoClient* self, guint value) {
	g_return_if_fail (self != NULL);
	CLOCKS_GEO_CLIENT_GET_INTERFACE (self)->set_distance_threshold (self, value);
}


static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
}


static void clocks_geo_client_base_init (ClocksGeoClientIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("location_updated", CLOCKS_GEO_TYPE_CLIENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	}
}


GType clocks_geo_client_get_type (void) {
	static volatile gsize clocks_geo_client_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_geo_client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksGeoClientIface), (GBaseInitFunc) clocks_geo_client_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType clocks_geo_client_type_id;
		clocks_geo_client_type_id = g_type_register_static (G_TYPE_INTERFACE, "ClocksGeoClient", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (clocks_geo_client_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (clocks_geo_client_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) clocks_geo_client_proxy_get_type);
		g_type_set_qdata (clocks_geo_client_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.GeoClue2.Client");
		g_type_set_qdata (clocks_geo_client_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) clocks_geo_client_register_object);
		g_once_init_leave (&clocks_geo_client_type_id__volatile, clocks_geo_client_type_id);
	}
	return clocks_geo_client_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (ClocksGeoClientProxy, clocks_geo_client_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (CLOCKS_GEO_TYPE_CLIENT, clocks_geo_client_proxy_clocks_geo_client_interface_init) )
static void clocks_geo_client_proxy_class_init (ClocksGeoClientProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = clocks_geo_client_proxy_g_signal;
}


static void _dbus_handle_clocks_geo_client_location_updated (ClocksGeoClient* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* old_path = NULL;
	GVariant* _tmp1_;
	gchar* new_path = NULL;
	GVariant* _tmp2_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	old_path = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	new_path = g_variant_dup_string (_tmp2_, NULL);
	g_variant_unref (_tmp2_);
	g_signal_emit_by_name (self, "location-updated", old_path, new_path);
	_g_free0 (old_path);
	_g_free0 (new_path);
}


static void clocks_geo_client_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "LocationUpdated") == 0) {
		_dbus_handle_clocks_geo_client_location_updated ((ClocksGeoClient*) proxy, parameters);
	}
}


static void clocks_geo_client_proxy_init (ClocksGeoClientProxy* self) {
}


static void clocks_geo_client_proxy_start_async (ClocksGeoClient* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.GeoClue2.Client", "Start");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void clocks_geo_client_proxy_start_finish (ClocksGeoClient* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static gchar* clocks_geo_client_dbus_proxy_get_location (ClocksGeoClient* self) {
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Location");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.GeoClue2.Client"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Location"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}


static guint clocks_geo_client_dbus_proxy_get_distance_threshold (ClocksGeoClient* self) {
	GVariant *_inner_reply;
	guint _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "DistanceThreshold");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.GeoClue2.Client"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("DistanceThreshold"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return 0U;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static void clocks_geo_client_dbus_proxy_set_distance_threshold (ClocksGeoClient* self, guint value) {
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.GeoClue2.Client"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("DistanceThreshold"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}


static void clocks_geo_client_proxy_clocks_geo_client_interface_init (ClocksGeoClientIface* iface) {
	iface->start = clocks_geo_client_proxy_start_async;
	iface->start_finish = clocks_geo_client_proxy_start_finish;
	iface->get_location = clocks_geo_client_dbus_proxy_get_location;
	iface->get_distance_threshold = clocks_geo_client_dbus_proxy_get_distance_threshold;
	iface->set_distance_threshold = clocks_geo_client_dbus_proxy_set_distance_threshold;
}


static void _dbus_clocks_geo_client_start (ClocksGeoClient* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	clocks_geo_client_start (self, (GAsyncReadyCallback) _dbus_clocks_geo_client_start_ready, invocation);
}


static void _dbus_clocks_geo_client_start_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	clocks_geo_client_start_finish ((ClocksGeoClient*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void clocks_geo_client_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Start") == 0) {
		_dbus_clocks_geo_client_start (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* _dbus_clocks_geo_client_get_location (ClocksGeoClient* self) {
	gchar* result;
	GVariant* _reply;
	result = clocks_geo_client_get_location (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}


static GVariant* _dbus_clocks_geo_client_get_distance_threshold (ClocksGeoClient* self) {
	guint result;
	GVariant* _reply;
	result = clocks_geo_client_get_distance_threshold (self);
	_reply = g_variant_new_uint32 (result);
	return _reply;
}


static GVariant* clocks_geo_client_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Location") == 0) {
		return _dbus_clocks_geo_client_get_location (object);
	} else if (strcmp (property_name, "DistanceThreshold") == 0) {
		return _dbus_clocks_geo_client_get_distance_threshold (object);
	}
	return NULL;
}


static void _dbus_clocks_geo_client_set_distance_threshold (ClocksGeoClient* self, GVariant* _value) {
	guint value = 0U;
	value = g_variant_get_uint32 (_value);
	clocks_geo_client_set_distance_threshold (self, value);
}


static gboolean clocks_geo_client_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "DistanceThreshold") == 0) {
		_dbus_clocks_geo_client_set_distance_threshold (object, value);
		return TRUE;
	}
	return FALSE;
}


static void _dbus_clocks_geo_client_location_updated (GObject* _sender, const gchar* old_path, const gchar* new_path, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (old_path));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (new_path));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.GeoClue2.Client", "LocationUpdated", _arguments, NULL);
}


guint clocks_geo_client_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_clocks_geo_client_dbus_interface_info), &_clocks_geo_client_dbus_interface_vtable, data, _clocks_geo_client_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "location-updated", (GCallback) _dbus_clocks_geo_client_location_updated, data);
	return result;
}


static void _clocks_geo_client_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_clocks_geo_client_location_updated, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


gdouble clocks_geo_location_get_latitude (ClocksGeoLocation* self) {
	g_return_val_if_fail (self != NULL, 0.0);
	return CLOCKS_GEO_LOCATION_GET_INTERFACE (self)->get_latitude (self);
}


gdouble clocks_geo_location_get_longitude (ClocksGeoLocation* self) {
	g_return_val_if_fail (self != NULL, 0.0);
	return CLOCKS_GEO_LOCATION_GET_INTERFACE (self)->get_longitude (self);
}


gdouble clocks_geo_location_get_accuracy (ClocksGeoLocation* self) {
	g_return_val_if_fail (self != NULL, 0.0);
	return CLOCKS_GEO_LOCATION_GET_INTERFACE (self)->get_accuracy (self);
}


gchar* clocks_geo_location_get_description (ClocksGeoLocation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return CLOCKS_GEO_LOCATION_GET_INTERFACE (self)->get_description (self);
}


static void clocks_geo_location_base_init (ClocksGeoLocationIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType clocks_geo_location_get_type (void) {
	static volatile gsize clocks_geo_location_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_geo_location_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksGeoLocationIface), (GBaseInitFunc) clocks_geo_location_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType clocks_geo_location_type_id;
		clocks_geo_location_type_id = g_type_register_static (G_TYPE_INTERFACE, "ClocksGeoLocation", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (clocks_geo_location_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (clocks_geo_location_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) clocks_geo_location_proxy_get_type);
		g_type_set_qdata (clocks_geo_location_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.GeoClue2.Location");
		g_type_set_qdata (clocks_geo_location_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) clocks_geo_location_register_object);
		g_once_init_leave (&clocks_geo_location_type_id__volatile, clocks_geo_location_type_id);
	}
	return clocks_geo_location_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (ClocksGeoLocationProxy, clocks_geo_location_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (CLOCKS_GEO_TYPE_LOCATION, clocks_geo_location_proxy_clocks_geo_location_interface_init) )
static void clocks_geo_location_proxy_class_init (ClocksGeoLocationProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = clocks_geo_location_proxy_g_signal;
}


static void clocks_geo_location_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void clocks_geo_location_proxy_init (ClocksGeoLocationProxy* self) {
}


static gdouble clocks_geo_location_dbus_proxy_get_latitude (ClocksGeoLocation* self) {
	GVariant *_inner_reply;
	gdouble _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Latitude");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.GeoClue2.Location"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Latitude"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return 0.0;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_double (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static gdouble clocks_geo_location_dbus_proxy_get_longitude (ClocksGeoLocation* self) {
	GVariant *_inner_reply;
	gdouble _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Longitude");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.GeoClue2.Location"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Longitude"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return 0.0;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_double (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static gdouble clocks_geo_location_dbus_proxy_get_accuracy (ClocksGeoLocation* self) {
	GVariant *_inner_reply;
	gdouble _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Accuracy");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.GeoClue2.Location"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Accuracy"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return 0.0;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_double (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static gchar* clocks_geo_location_dbus_proxy_get_description (ClocksGeoLocation* self) {
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Description");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.GeoClue2.Location"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Description"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}


static void clocks_geo_location_proxy_clocks_geo_location_interface_init (ClocksGeoLocationIface* iface) {
	iface->get_latitude = clocks_geo_location_dbus_proxy_get_latitude;
	iface->get_longitude = clocks_geo_location_dbus_proxy_get_longitude;
	iface->get_accuracy = clocks_geo_location_dbus_proxy_get_accuracy;
	iface->get_description = clocks_geo_location_dbus_proxy_get_description;
}


static void clocks_geo_location_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}


static GVariant* _dbus_clocks_geo_location_get_latitude (ClocksGeoLocation* self) {
	gdouble result;
	GVariant* _reply;
	result = clocks_geo_location_get_latitude (self);
	_reply = g_variant_new_double (result);
	return _reply;
}


static GVariant* _dbus_clocks_geo_location_get_longitude (ClocksGeoLocation* self) {
	gdouble result;
	GVariant* _reply;
	result = clocks_geo_location_get_longitude (self);
	_reply = g_variant_new_double (result);
	return _reply;
}


static GVariant* _dbus_clocks_geo_location_get_accuracy (ClocksGeoLocation* self) {
	gdouble result;
	GVariant* _reply;
	result = clocks_geo_location_get_accuracy (self);
	_reply = g_variant_new_double (result);
	return _reply;
}


static GVariant* _dbus_clocks_geo_location_get_description (ClocksGeoLocation* self) {
	gchar* result;
	GVariant* _reply;
	result = clocks_geo_location_get_description (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}


static GVariant* clocks_geo_location_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Latitude") == 0) {
		return _dbus_clocks_geo_location_get_latitude (object);
	} else if (strcmp (property_name, "Longitude") == 0) {
		return _dbus_clocks_geo_location_get_longitude (object);
	} else if (strcmp (property_name, "Accuracy") == 0) {
		return _dbus_clocks_geo_location_get_accuracy (object);
	} else if (strcmp (property_name, "Description") == 0) {
		return _dbus_clocks_geo_location_get_description (object);
	}
	return NULL;
}


static gboolean clocks_geo_location_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint clocks_geo_location_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_clocks_geo_location_dbus_interface_info), &_clocks_geo_location_dbus_interface_vtable, data, _clocks_geo_location_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _clocks_geo_location_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _vala_GWeatherLocation_free (GWeatherLocation* self) {
	g_boxed_free (gweather_location_get_type (), self);
}


ClocksGeoInfo* clocks_geo_info_construct (GType object_type) {
	ClocksGeoInfo * self = NULL;
	self = (ClocksGeoInfo*) g_object_new (object_type, NULL);
	_g_free0 (self->priv->country_code);
	self->priv->country_code = NULL;
	__vala_GWeatherLocation_free0 (self->priv->found_location);
	self->priv->found_location = NULL;
	self->priv->minimal_distance = 1000.0;
	return self;
}


ClocksGeoInfo* clocks_geo_info_new (void) {
	return clocks_geo_info_construct (CLOCKS_GEO_TYPE_INFO);
}


static void clocks_geo_info_seek_data_free (gpointer _data) {
	ClocksGeoInfoSeekData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ClocksGeoInfoSeekData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void clocks_geo_info_seek (ClocksGeoInfo* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ClocksGeoInfoSeekData* _data_;
	ClocksGeoInfo* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ClocksGeoInfoSeekData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, clocks_geo_info_seek);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, clocks_geo_info_seek_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	clocks_geo_info_seek_co (_data_);
}


void clocks_geo_info_seek_finish (ClocksGeoInfo* self, GAsyncResult* _res_) {
	ClocksGeoInfoSeekData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void clocks_geo_info_seek_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ClocksGeoInfoSeekData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	clocks_geo_info_seek_co (_data_);
}


static void _clocks_geo_info_on_location_updated_clocks_geo_client_location_updated (ClocksGeoClient* _sender, const gchar* old_path, const gchar* new_path, gpointer self) {
	clocks_geo_info_on_location_updated (self, old_path, new_path, NULL, NULL);
}


static gboolean clocks_geo_info_seek_co (ClocksGeoInfoSeekData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->client_path = NULL;
	{
		_data_->_state_ = 1;
		g_async_initable_new_async (CLOCKS_GEO_TYPE_MANAGER_PROXY, 0, NULL, clocks_geo_info_seek_ready, _data_, "g-flags", 0, "g-name", "org.freedesktop.GeoClue2", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freedesktop/GeoClue2/Manager", "g-interface-name", "org.freedesktop.GeoClue2.Manager", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp0_ = (ClocksGeoManager*) _data_->_tmp1_;
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				goto __catch8_g_io_error;
			}
			_g_free0 (_data_->client_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (_data_->self->priv->manager);
		_data_->self->priv->manager = _data_->_tmp0_;
	}
	goto __finally8;
	__catch8_g_io_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->e;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->_tmp2_->message;
		g_warning ("geocoding.vala:73: Failed to connect to GeoClue2 Manager service: %s", _data_->_tmp3_);
		_g_error_free0 (_data_->e);
		_g_free0 (_data_->client_path);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally8:
	if (_data_->_inner_error_ != NULL) {
		_g_free0 (_data_->client_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	{
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->self->priv->manager;
		_data_->_tmp5_ = NULL;
		_data_->_state_ = 2;
		clocks_geo_manager_get_client (_data_->_tmp4_, clocks_geo_info_seek_ready, _data_);
		return FALSE;
		_state_2:
		clocks_geo_manager_get_client_finish (_data_->_tmp4_, _data_->_res_, &_data_->_tmp5_, &_data_->_inner_error_);
		_g_free0 (_data_->client_path);
		_data_->client_path = _data_->_tmp5_;
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				goto __catch9_g_io_error;
			}
			_g_free0 (_data_->client_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	goto __finally9;
	__catch9_g_io_error:
	{
		_data_->_vala1_e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->_vala1_e;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->_tmp6_->message;
		g_warning ("geocoding.vala:80: Failed to connect to GeoClue2 Manager service: %s", _data_->_tmp7_);
		_g_error_free0 (_data_->_vala1_e);
		_g_free0 (_data_->client_path);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally9:
	if (_data_->_inner_error_ != NULL) {
		_g_free0 (_data_->client_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->client_path;
	if (_data_->_tmp8_ == NULL) {
		g_warning ("geocoding.vala:85: The client path is not set");
		_g_free0 (_data_->client_path);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->client_path;
		_data_->_state_ = 3;
		g_async_initable_new_async (CLOCKS_GEO_TYPE_CLIENT_PROXY, 0, NULL, clocks_geo_info_seek_ready, _data_, "g-flags", 0, "g-name", "org.freedesktop.GeoClue2", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _data_->_tmp10_, "g-interface-name", "org.freedesktop.GeoClue2.Client", NULL);
		return FALSE;
		_state_3:
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp9_ = (ClocksGeoClient*) _data_->_tmp11_;
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				goto __catch10_g_io_error;
			}
			_g_free0 (_data_->client_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (_data_->self->priv->client);
		_data_->self->priv->client = _data_->_tmp9_;
	}
	goto __finally10;
	__catch10_g_io_error:
	{
		_data_->_vala2_e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->_vala2_e;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->_tmp12_->message;
		g_warning ("geocoding.vala:94: Failed to connect to GeoClue2 Client service: %s", _data_->_tmp13_);
		_g_error_free0 (_data_->_vala2_e);
		_g_free0 (_data_->client_path);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally10:
	if (_data_->_inner_error_ != NULL) {
		_g_free0 (_data_->client_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->self->priv->client;
	g_signal_connect_object (_data_->_tmp14_, "location-updated", (GCallback) _clocks_geo_info_on_location_updated_clocks_geo_client_location_updated, _data_->self, 0);
	{
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->self->priv->client;
		_data_->_state_ = 4;
		clocks_geo_client_start (_data_->_tmp15_, clocks_geo_info_seek_ready, _data_);
		return FALSE;
		_state_4:
		clocks_geo_client_start_finish (_data_->_tmp15_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				goto __catch11_g_io_error;
			}
			_g_free0 (_data_->client_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	goto __finally11;
	__catch11_g_io_error:
	{
		_data_->_vala3_e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _data_->_vala3_e;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->_tmp16_->message;
		g_warning ("geocoding.vala:103: Failed to start client: %s", _data_->_tmp17_);
		_g_error_free0 (_data_->_vala3_e);
		_g_free0 (_data_->client_path);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally11:
	if (_data_->_inner_error_ != NULL) {
		_g_free0 (_data_->client_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_g_free0 (_data_->client_path);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void clocks_geo_info_on_location_updated_data_free (gpointer _data) {
	ClocksGeoInfoOnLocationUpdatedData* _data_;
	_data_ = _data;
	_g_free0 (_data_->old_path);
	_g_free0 (_data_->new_path);
	_g_object_unref0 (_data_->self);
	g_slice_free (ClocksGeoInfoOnLocationUpdatedData, _data_);
}


void clocks_geo_info_on_location_updated (ClocksGeoInfo* self, const gchar* old_path, const gchar* new_path, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ClocksGeoInfoOnLocationUpdatedData* _data_;
	ClocksGeoInfo* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	_data_ = g_slice_new0 (ClocksGeoInfoOnLocationUpdatedData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, clocks_geo_info_on_location_updated);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, clocks_geo_info_on_location_updated_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = old_path;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->old_path);
	_data_->old_path = _tmp2_;
	_tmp3_ = new_path;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->new_path);
	_data_->new_path = _tmp4_;
	clocks_geo_info_on_location_updated_co (_data_);
}


void clocks_geo_info_on_location_updated_finish (ClocksGeoInfo* self, GAsyncResult* _res_) {
	ClocksGeoInfoOnLocationUpdatedData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void clocks_geo_info_on_location_updated_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ClocksGeoInfoOnLocationUpdatedData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	clocks_geo_info_on_location_updated_co (_data_);
}


static gboolean clocks_geo_info_on_location_updated_co (ClocksGeoInfoOnLocationUpdatedData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->new_path;
		_data_->_state_ = 1;
		g_async_initable_new_async (CLOCKS_GEO_TYPE_LOCATION_PROXY, 0, NULL, clocks_geo_info_on_location_updated_ready, _data_, "g-flags", 0, "g-name", "org.freedesktop.GeoClue2", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _data_->_tmp1_, "g-interface-name", "org.freedesktop.GeoClue2.Location", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp0_ = (ClocksGeoLocation*) _data_->_tmp2_;
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				goto __catch12_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->_tmp0_;
		clocks_geo_info_set_geo_location (_data_->self, _data_->_tmp3_);
		_g_object_unref0 (_data_->_tmp3_);
	}
	goto __finally12;
	__catch12_g_io_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->e;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		g_warning ("geocoding.vala:114: Failed to connect to GeoClue2 Location service: %s", _data_->_tmp5_);
		_g_error_free0 (_data_->e);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally12:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_state_ = 2;
	clocks_geo_info_seek_country_code (_data_->self, clocks_geo_info_on_location_updated_ready, _data_);
	return FALSE;
	_state_2:
	clocks_geo_info_seek_country_code_finish (_data_->self, _data_->_res_);
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = gweather_location_get_world ();
	_data_->_state_ = 3;
	clocks_geo_info_search_locations (_data_->self, _data_->_tmp6_, clocks_geo_info_on_location_updated_ready, _data_);
	return FALSE;
	_state_3:
	clocks_geo_info_search_locations_finish (_data_->self, _data_->_res_);
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->self->priv->found_location;
	if (_data_->_tmp7_ != NULL) {
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->self->priv->found_location;
		g_signal_emit_by_name (_data_->self, "location-changed", _data_->_tmp8_);
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void clocks_geo_info_seek_country_code_data_free (gpointer _data) {
	ClocksGeoInfoSeekCountryCodeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ClocksGeoInfoSeekCountryCodeData, _data_);
}


static void clocks_geo_info_seek_country_code (ClocksGeoInfo* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ClocksGeoInfoSeekCountryCodeData* _data_;
	ClocksGeoInfo* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ClocksGeoInfoSeekCountryCodeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, clocks_geo_info_seek_country_code);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, clocks_geo_info_seek_country_code_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	clocks_geo_info_seek_country_code_co (_data_);
}


static void clocks_geo_info_seek_country_code_finish (ClocksGeoInfo* self, GAsyncResult* _res_) {
	ClocksGeoInfoSeekCountryCodeData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void clocks_geo_info_seek_country_code_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ClocksGeoInfoSeekCountryCodeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	clocks_geo_info_seek_country_code_co (_data_);
}


static gboolean clocks_geo_info_seek_country_code_co (ClocksGeoInfoSeekCountryCodeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->_geo_location;
	_data_->_tmp1_ = 0.0;
	_data_->_tmp1_ = clocks_geo_location_get_latitude (_data_->_tmp0_);
	_data_->_tmp2_ = 0.0;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->self->priv->_geo_location;
	_data_->_tmp4_ = 0.0;
	_data_->_tmp4_ = clocks_geo_location_get_longitude (_data_->_tmp3_);
	_data_->_tmp5_ = 0.0;
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = geocode_location_new (_data_->_tmp2_, _data_->_tmp5_, (gdouble) GEOCODE_LOCATION_ACCURACY_UNKNOWN);
	_data_->location = _data_->_tmp6_;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = geocode_reverse_new_for_location (_data_->location);
	_data_->reverse = _data_->_tmp7_;
	{
		_data_->_state_ = 1;
		geocode_reverse_resolve_async (_data_->reverse, NULL, clocks_geo_info_seek_country_code_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = geocode_reverse_resolve_finish (_data_->reverse, _data_->_res_, &_data_->_inner_error_);
		_data_->place = _data_->_tmp8_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch13_g_error;
		}
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = geocode_place_get_country_code (_data_->place);
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = g_strdup (_data_->_tmp9_);
		_g_free0 (_data_->self->priv->country_code);
		_data_->self->priv->country_code = _data_->_tmp10_;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->self->priv->country_code;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = g_utf8_strup (_data_->_tmp11_, (gssize) (-1));
		_g_free0 (_data_->self->priv->country_code);
		_data_->self->priv->country_code = _data_->_tmp12_;
		_g_object_unref0 (_data_->place);
	}
	goto __finally13;
	__catch13_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->e;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->_tmp13_->message;
		g_warning ("geocoding.vala:139: Failed to obtain country code: %s", _data_->_tmp14_);
		_g_error_free0 (_data_->e);
	}
	__finally13:
	if (_data_->_inner_error_ != NULL) {
		_g_object_unref0 (_data_->reverse);
		_g_object_unref0 (_data_->location);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (_data_->reverse);
	_g_object_unref0 (_data_->location);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gdouble clocks_geo_info_deg_to_rad (ClocksGeoInfo* self, gdouble deg) {
	gdouble result = 0.0;
	gdouble _tmp0_ = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = deg;
	result = (G_PI / 180.0) * _tmp0_;
	return result;
}


static gdouble clocks_geo_info_get_distance (ClocksGeoInfo* self, gdouble latitude1, gdouble longitude1, gdouble latitude2, gdouble longitude2) {
	gdouble result = 0.0;
	static const gdouble earth_radius = 6372.795;
	gdouble lat1 = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble lat2 = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble lon1 = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble lon2 = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	gdouble _tmp13_ = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = latitude1;
	_tmp1_ = clocks_geo_info_deg_to_rad (self, _tmp0_);
	lat1 = _tmp1_;
	_tmp2_ = latitude2;
	_tmp3_ = clocks_geo_info_deg_to_rad (self, _tmp2_);
	lat2 = _tmp3_;
	_tmp4_ = longitude1;
	_tmp5_ = clocks_geo_info_deg_to_rad (self, _tmp4_);
	lon1 = _tmp5_;
	_tmp6_ = longitude2;
	_tmp7_ = clocks_geo_info_deg_to_rad (self, _tmp6_);
	lon2 = _tmp7_;
	_tmp8_ = cos (lat1);
	_tmp9_ = cos (lat2);
	_tmp10_ = cos (lon1 - lon2);
	_tmp11_ = sin (lat1);
	_tmp12_ = sin (lat2);
	_tmp13_ = acos (((_tmp8_ * _tmp9_) * _tmp10_) + (_tmp11_ * _tmp12_));
	result = _tmp13_ * earth_radius;
	return result;
}


static void clocks_geo_info_search_locations_data_free (gpointer _data) {
	ClocksGeoInfoSearchLocationsData* _data_;
	_data_ = _data;
	__vala_GWeatherLocation_free0 (_data_->location);
	_g_object_unref0 (_data_->self);
	g_slice_free (ClocksGeoInfoSearchLocationsData, _data_);
}


static GWeatherLocation* _vala_GWeatherLocation_copy (GWeatherLocation* self) {
	return g_boxed_copy (gweather_location_get_type (), self);
}


static gpointer __vala_GWeatherLocation_copy0 (gpointer self) {
	return self ? _vala_GWeatherLocation_copy (self) : NULL;
}


static void clocks_geo_info_search_locations (ClocksGeoInfo* self, GWeatherLocation* location, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ClocksGeoInfoSearchLocationsData* _data_;
	ClocksGeoInfo* _tmp0_ = NULL;
	GWeatherLocation* _tmp1_ = NULL;
	GWeatherLocation* _tmp2_ = NULL;
	_data_ = g_slice_new0 (ClocksGeoInfoSearchLocationsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, clocks_geo_info_search_locations);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, clocks_geo_info_search_locations_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = location;
	_tmp2_ = __vala_GWeatherLocation_copy0 (_tmp1_);
	__vala_GWeatherLocation_free0 (_data_->location);
	_data_->location = _tmp2_;
	clocks_geo_info_search_locations_co (_data_);
}


static void clocks_geo_info_search_locations_finish (ClocksGeoInfo* self, GAsyncResult* _res_) {
	ClocksGeoInfoSearchLocationsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static GWeatherLocation** _vala_array_dup1 (GWeatherLocation** self, int length) {
	GWeatherLocation** result;
	int i;
	result = g_new0 (GWeatherLocation*, length + 1);
	for (i = 0; i < length; i++) {
		GWeatherLocation* _tmp0_ = NULL;
		_tmp0_ = __vala_GWeatherLocation_copy0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void clocks_geo_info_search_locations_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ClocksGeoInfoSearchLocationsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	clocks_geo_info_search_locations_co (_data_);
}


static gboolean clocks_geo_info_search_locations_co (ClocksGeoInfoSearchLocationsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->country_code;
	if (_data_->_tmp0_ != NULL) {
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->location;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = gweather_location_get_country (_data_->_tmp1_);
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
		_data_->loc_country_code = _data_->_tmp3_;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->loc_country_code;
		if (_data_->_tmp4_ != NULL) {
			_data_->_tmp5_ = NULL;
			_data_->_tmp5_ = _data_->loc_country_code;
			_data_->_tmp6_ = NULL;
			_data_->_tmp6_ = _data_->self->priv->country_code;
			if (g_strcmp0 (_data_->_tmp5_, _data_->_tmp6_) != 0) {
				_g_free0 (_data_->loc_country_code);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_g_free0 (_data_->loc_country_code);
	}
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->location;
	_data_->_tmp8_ = NULL;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->_tmp8_ = gweather_location_get_children (_data_->_tmp7_);
	_data_->_tmp10_ = NULL;
	_data_->_tmp10__length1 = 0;
	_data_->_tmp10_ = (_data_->_tmp9_ != NULL) ? _vala_array_dup1 (_data_->_tmp9_, _vala_array_length (_data_->_tmp8_)) : ((gpointer) _data_->_tmp9_);
	_data_->_tmp10__length1 = _vala_array_length (_data_->_tmp8_);
	_data_->locations_length1 = 0;
	_data_->_locations_size_ = 0;
	_data_->locations = _data_->_tmp10_;
	_data_->locations_length1 = _data_->_tmp10__length1;
	_data_->_locations_size_ = _data_->locations_length1;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11__length1 = 0;
	_data_->_tmp11_ = _data_->locations;
	_data_->_tmp11__length1 = _data_->locations_length1;
	if (_data_->_tmp11_ != NULL) {
		{
			_data_->i = 0;
			{
				_data_->_tmp12_ = TRUE;
				while (TRUE) {
					_data_->_tmp13_ = FALSE;
					_data_->_tmp13_ = _data_->_tmp12_;
					if (!_data_->_tmp13_) {
						_data_->_tmp14_ = 0;
						_data_->_tmp14_ = _data_->i;
						_data_->i = _data_->_tmp14_ + 1;
					}
					_data_->_tmp12_ = FALSE;
					_data_->_tmp15_ = 0;
					_data_->_tmp15_ = _data_->i;
					_data_->_tmp16_ = NULL;
					_data_->_tmp16__length1 = 0;
					_data_->_tmp16_ = _data_->locations;
					_data_->_tmp16__length1 = _data_->locations_length1;
					if (!(_data_->_tmp15_ < _data_->_tmp16__length1)) {
						break;
					}
					_data_->_tmp17_ = NULL;
					_data_->_tmp17__length1 = 0;
					_data_->_tmp17_ = _data_->locations;
					_data_->_tmp17__length1 = _data_->locations_length1;
					_data_->_tmp18_ = 0;
					_data_->_tmp18_ = _data_->i;
					_data_->_tmp19_ = NULL;
					_data_->_tmp19_ = _data_->_tmp17_[_data_->_tmp18_];
					_data_->_tmp20_ = 0;
					_data_->_tmp20_ = gweather_location_get_level (_data_->_tmp19_);
					if (_data_->_tmp20_ == GWEATHER_LOCATION_CITY) {
						_data_->_tmp21_ = NULL;
						_data_->_tmp21__length1 = 0;
						_data_->_tmp21_ = _data_->locations;
						_data_->_tmp21__length1 = _data_->locations_length1;
						_data_->_tmp22_ = 0;
						_data_->_tmp22_ = _data_->i;
						_data_->_tmp23_ = NULL;
						_data_->_tmp23_ = _data_->_tmp21_[_data_->_tmp22_];
						_data_->_tmp24_ = FALSE;
						_data_->_tmp24_ = gweather_location_has_coords (_data_->_tmp23_);
						if (_data_->_tmp24_) {
							_data_->_tmp25_ = NULL;
							_data_->_tmp25__length1 = 0;
							_data_->_tmp25_ = _data_->locations;
							_data_->_tmp25__length1 = _data_->locations_length1;
							_data_->_tmp26_ = 0;
							_data_->_tmp26_ = _data_->i;
							_data_->_tmp27_ = NULL;
							_data_->_tmp27_ = _data_->_tmp25_[_data_->_tmp26_];
							_data_->_tmp28_ = 0.0;
							_data_->_tmp29_ = 0.0;
							gweather_location_get_coords (_data_->_tmp27_, &_data_->_tmp28_, &_data_->_tmp29_);
							_data_->latitude = _data_->_tmp28_;
							_data_->longitude = _data_->_tmp29_;
							_data_->_tmp30_ = NULL;
							_data_->_tmp30_ = _data_->self->priv->_geo_location;
							_data_->_tmp31_ = 0.0;
							_data_->_tmp31_ = clocks_geo_location_get_latitude (_data_->_tmp30_);
							_data_->_tmp32_ = 0.0;
							_data_->_tmp32_ = _data_->_tmp31_;
							_data_->_tmp33_ = NULL;
							_data_->_tmp33_ = _data_->self->priv->_geo_location;
							_data_->_tmp34_ = 0.0;
							_data_->_tmp34_ = clocks_geo_location_get_longitude (_data_->_tmp33_);
							_data_->_tmp35_ = 0.0;
							_data_->_tmp35_ = _data_->_tmp34_;
							_data_->_tmp36_ = 0.0;
							_data_->_tmp36_ = _data_->latitude;
							_data_->_tmp37_ = 0.0;
							_data_->_tmp37_ = _data_->longitude;
							_data_->_tmp38_ = 0.0;
							_data_->_tmp38_ = clocks_geo_info_get_distance (_data_->self, _data_->_tmp32_, _data_->_tmp35_, _data_->_tmp36_, _data_->_tmp37_);
							_data_->distance = _data_->_tmp38_;
							_data_->_tmp39_ = 0.0;
							_data_->_tmp39_ = _data_->distance;
							_data_->_tmp40_ = 0.0;
							_data_->_tmp40_ = _data_->self->priv->minimal_distance;
							if (_data_->_tmp39_ < _data_->_tmp40_) {
								_data_->_tmp41_ = NULL;
								_data_->_tmp41__length1 = 0;
								_data_->_tmp41_ = _data_->locations;
								_data_->_tmp41__length1 = _data_->locations_length1;
								_data_->_tmp42_ = 0;
								_data_->_tmp42_ = _data_->i;
								_data_->_tmp43_ = NULL;
								_data_->_tmp43_ = _data_->_tmp41_[_data_->_tmp42_];
								_data_->_tmp44_ = NULL;
								_data_->_tmp44_ = __vala_GWeatherLocation_copy0 (_data_->_tmp43_);
								__vala_GWeatherLocation_free0 (_data_->self->priv->found_location);
								_data_->self->priv->found_location = _data_->_tmp44_;
								_data_->_tmp45_ = 0.0;
								_data_->_tmp45_ = _data_->distance;
								_data_->self->priv->minimal_distance = _data_->_tmp45_;
							}
						}
					}
					_data_->_tmp46_ = NULL;
					_data_->_tmp46__length1 = 0;
					_data_->_tmp46_ = _data_->locations;
					_data_->_tmp46__length1 = _data_->locations_length1;
					_data_->_tmp47_ = 0;
					_data_->_tmp47_ = _data_->i;
					_data_->_tmp48_ = NULL;
					_data_->_tmp48_ = _data_->_tmp46_[_data_->_tmp47_];
					_data_->_state_ = 1;
					clocks_geo_info_search_locations (_data_->self, _data_->_tmp48_, clocks_geo_info_search_locations_ready, _data_);
					return FALSE;
					_state_1:
					clocks_geo_info_search_locations_finish (_data_->self, _data_->_res_);
				}
			}
		}
	}
	_data_->locations = (_vala_array_free (_data_->locations, _data_->locations_length1, (GDestroyNotify) _vala_GWeatherLocation_free), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static GWeatherTimezone* _vala_GWeatherTimezone_copy (GWeatherTimezone* self) {
	return g_boxed_copy (gweather_timezone_get_type (), self);
}


static gpointer __vala_GWeatherTimezone_copy0 (gpointer self) {
	return self ? _vala_GWeatherTimezone_copy (self) : NULL;
}


static void _vala_GWeatherTimezone_free (GWeatherTimezone* self) {
	g_boxed_free (gweather_timezone_get_type (), self);
}


gboolean clocks_geo_info_is_location_similar (ClocksGeoInfo* self, GWeatherLocation* location) {
	gboolean result = FALSE;
	GWeatherLocation* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (location != NULL, FALSE);
	_tmp0_ = self->priv->found_location;
	if (_tmp0_ != NULL) {
		gchar* country_code = NULL;
		GWeatherLocation* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* found_country_code = NULL;
		GWeatherLocation* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_ = NULL;
		gboolean _tmp11_ = FALSE;
		_tmp1_ = location;
		_tmp2_ = gweather_location_get_country (_tmp1_);
		_tmp3_ = g_strdup (_tmp2_);
		country_code = _tmp3_;
		_tmp4_ = self->priv->found_location;
		_tmp5_ = gweather_location_get_country (_tmp4_);
		_tmp6_ = g_strdup (_tmp5_);
		found_country_code = _tmp6_;
		_tmp8_ = country_code;
		if (_tmp8_ != NULL) {
			const gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			_tmp9_ = country_code;
			_tmp10_ = found_country_code;
			_tmp7_ = g_strcmp0 (_tmp9_, _tmp10_) == 0;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp11_ = _tmp7_;
		if (_tmp11_) {
			GWeatherTimezone* timezone = NULL;
			GWeatherLocation* _tmp12_ = NULL;
			GWeatherTimezone* _tmp13_ = NULL;
			GWeatherTimezone* _tmp14_ = NULL;
			GWeatherTimezone* found_timezone = NULL;
			GWeatherLocation* _tmp15_ = NULL;
			GWeatherTimezone* _tmp16_ = NULL;
			GWeatherTimezone* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
			GWeatherTimezone* _tmp19_ = NULL;
			gboolean _tmp21_ = FALSE;
			_tmp12_ = location;
			_tmp13_ = gweather_location_get_timezone (_tmp12_);
			_tmp14_ = __vala_GWeatherTimezone_copy0 (_tmp13_);
			timezone = _tmp14_;
			_tmp15_ = self->priv->found_location;
			_tmp16_ = gweather_location_get_timezone (_tmp15_);
			_tmp17_ = __vala_GWeatherTimezone_copy0 (_tmp16_);
			found_timezone = _tmp17_;
			_tmp19_ = timezone;
			if (_tmp19_ != NULL) {
				GWeatherTimezone* _tmp20_ = NULL;
				_tmp20_ = found_timezone;
				_tmp18_ = _tmp20_ != NULL;
			} else {
				_tmp18_ = FALSE;
			}
			_tmp21_ = _tmp18_;
			if (_tmp21_) {
				gchar* tzid = NULL;
				GWeatherTimezone* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				gchar* found_tzid = NULL;
				GWeatherTimezone* _tmp25_ = NULL;
				const gchar* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				_tmp22_ = timezone;
				_tmp23_ = gweather_timezone_get_tzid (_tmp22_);
				_tmp24_ = g_strdup (_tmp23_);
				tzid = _tmp24_;
				_tmp25_ = found_timezone;
				_tmp26_ = gweather_timezone_get_tzid (_tmp25_);
				_tmp27_ = g_strdup (_tmp26_);
				found_tzid = _tmp27_;
				_tmp28_ = tzid;
				_tmp29_ = found_tzid;
				if (g_strcmp0 (_tmp28_, _tmp29_) == 0) {
					result = TRUE;
					_g_free0 (found_tzid);
					_g_free0 (tzid);
					__vala_GWeatherTimezone_free0 (found_timezone);
					__vala_GWeatherTimezone_free0 (timezone);
					_g_free0 (found_country_code);
					_g_free0 (country_code);
					return result;
				}
				_g_free0 (found_tzid);
				_g_free0 (tzid);
			}
			__vala_GWeatherTimezone_free0 (found_timezone);
			__vala_GWeatherTimezone_free0 (timezone);
		}
		_g_free0 (found_country_code);
		_g_free0 (country_code);
	}
	result = FALSE;
	return result;
}


ClocksGeoLocation* clocks_geo_info_get_geo_location (ClocksGeoInfo* self) {
	ClocksGeoLocation* result;
	ClocksGeoLocation* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_geo_location;
	result = _tmp0_;
	return result;
}


static void clocks_geo_info_set_geo_location (ClocksGeoInfo* self, ClocksGeoLocation* value) {
	ClocksGeoLocation* _tmp0_ = NULL;
	ClocksGeoLocation* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_geo_location);
	self->priv->_geo_location = _tmp1_;
	g_object_notify ((GObject *) self, "geo-location");
}


static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), data2);
}


static void clocks_geo_info_class_init (ClocksGeoInfoClass * klass) {
	clocks_geo_info_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksGeoInfoPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_geo_info_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_geo_info_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_geo_info_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_GEO_INFO_GEO_LOCATION, g_param_spec_object ("geo-location", "geo-location", "geo-location", CLOCKS_GEO_TYPE_LOCATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("location_changed", CLOCKS_GEO_TYPE_INFO, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, gweather_location_get_type ());
}


static void clocks_geo_info_instance_init (ClocksGeoInfo * self) {
	self->priv = CLOCKS_GEO_INFO_GET_PRIVATE (self);
	self->priv->_geo_location = NULL;
}


static void clocks_geo_info_finalize (GObject* obj) {
	ClocksGeoInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_GEO_TYPE_INFO, ClocksGeoInfo);
	_g_object_unref0 (self->priv->_geo_location);
	__vala_GWeatherLocation_free0 (self->priv->found_location);
	_g_free0 (self->priv->country_code);
	_g_object_unref0 (self->priv->manager);
	_g_object_unref0 (self->priv->client);
	G_OBJECT_CLASS (clocks_geo_info_parent_class)->finalize (obj);
}


GType clocks_geo_info_get_type (void) {
	static volatile gsize clocks_geo_info_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_geo_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksGeoInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_geo_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksGeoInfo), 0, (GInstanceInitFunc) clocks_geo_info_instance_init, NULL };
		GType clocks_geo_info_type_id;
		clocks_geo_info_type_id = g_type_register_static (G_TYPE_OBJECT, "ClocksGeoInfo", &g_define_type_info, 0);
		g_once_init_leave (&clocks_geo_info_type_id__volatile, clocks_geo_info_type_id);
	}
	return clocks_geo_info_type_id__volatile;
}


static void _vala_clocks_geo_info_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksGeoInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_GEO_TYPE_INFO, ClocksGeoInfo);
	switch (property_id) {
		case CLOCKS_GEO_INFO_GEO_LOCATION:
		g_value_set_object (value, clocks_geo_info_get_geo_location (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_geo_info_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksGeoInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_GEO_TYPE_INFO, ClocksGeoInfo);
	switch (property_id) {
		case CLOCKS_GEO_INFO_GEO_LOCATION:
		clocks_geo_info_set_geo_location (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



