#!/usr/bin/perl -w
use strict;
use Gtk2::TestHelper tests => 2;

# $Id: GdkRgb.t,v 1.3 2008/10/05 12:49:34 kaffeetisch Exp $

my $window = Gtk2::Window -> new();
$window -> realize();

my $gc = Gtk2::Gdk::GC -> new($window -> window());
my $cmap = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            0, 1, 2, 3, 4, 5];

$window -> window() -> draw_indexed_image($gc, 5, 5, 10, 10, "normal", "abcd", 5, $cmap);

eval {
  $window -> window() -> draw_indexed_image($gc, 5, 5, 10, 10, "normal", "abcd", 5, [@$cmap, 6]);
};

like($@, qr/a cmap may not consist of more than 256 colors/);

SKIP: {
  skip("new 2.6 stuff", 1)
    unless Gtk2 -> CHECK_VERSION(2, 6, 0);

  my $cmap = Gtk2::Gdk::Colormap -> get_system();
  like(Gtk2::Gdk::Rgb -> colormap_ditherable($cmap), qr/^(?:1|)$/);
}

__END__

Copyright (C) 2003-2005 by the gtk2-perl team (see the file AUTHORS for the
full list).  See LICENSE for more information.
