/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-07-31 16:40:12 EDT
 */

package org.gnu.gdk;
import org.gnu.glib.GObject;
/**
 * A DragContext holds information about a drag in process.  It is used
 * on both source and destination sides.
 */
public class DragContext extends GObject 
{
	/**
	 * Construct a DragContext.
	 */
	public DragContext() {
		handle = gdk_drag_context_new();
	}

	/**
	 * Construct a DragContext using native resources. Used internally by
	 * java-gnome
	 */
	public DragContext( int handle ){
		this.handle = handle;
	}
	
	/**
	 * Return the source window.
	 */
	public Window getSource() {
		return new Window(getSourceWindow(handle));
	}
	
	/**
	 * Return the destination window.
	 */
	public Window getDestination() {
		return new Window(getDestWindow(handle));
	}
	
	/**
	 * Return the Drag Protocol
	 */
	public DragProtocol getProtocol() {
		return DragProtocol.intern(getProtocol(handle));
	}
	
	/**
	 * Returns true if the context is used on the source side.
	 */
	public boolean isSource() {
		return getIsSource(handle);
	}
	
	/**
	 * Return the action suggested by the source.
	 */
	public DragAction getSuggestedAction() {
		return DragAction.intern(getSuggestedAction(handle));
	}
	
	/**
	 * Return the action chosen by the destination.
	 */
	public DragAction getAction() {
		return DragAction.intern(getAction(handle));
	}
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int getProtocol (int obj);
    native static final protected boolean getIsSource (int obj);
    native static final protected int getSourceWindow (int obj);
    native static final protected int getDestWindow (int obj);
    native static final protected int getActions (int obj);
    native static final protected int getSuggestedAction (int obj);
    native static final protected int getAction (int obj);
    native static final protected int gdk_drag_context_get_type ();
    native static final protected int gdk_drag_context_new ();
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

