/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-07-31 16:40:16 EDT
 */

package org.gnu.gdk;
import org.gnu.glib.Boxed;
public class PixbufAnimation extends Boxed 
{
	/**
	 * Construct a new Pixbuf animation from an image file.
	 * @param filename The name of the image file.
	 */
	public PixbufAnimation(String filename) {
		int error = 0;
		this.handle = gdk_pixbuf_animation_new_from_file(filename, error);
	}
	
	/**
	 * Create a new pixbuf from a handle to a native resource.  For
	 * internal use.
	 * @param handle The handle to the native resoufce
	 */
	public PixbufAnimation(int handle) {
		this.handle = handle;
	}
	
	/**
	 * Return the width of the pixbuf.
	 * @return The width
	 */
	public int width() {
		return gdk_pixbuf_animation_get_width(handle);
	}

	/**
	 * Return the height of the pixbuf.
	 * @return The height
	 */
	public int height() {
		return gdk_pixbuf_animation_get_height(handle);
	}
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gdk_pixbuf_animation_get_type ();
    native static final protected int gdk_pixbuf_animation_new_from_file (String filename, int 
        error);
    native static final protected int gdk_pixbuf_animation_get_width (int animation);
    native static final protected int gdk_pixbuf_animation_get_height (int animation);
    native static final protected boolean gdk_pixbuf_animation_is_static_image (int animation);
    native static final protected int gdk_pixbuf_animation_get_static_image (int animation);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

