/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:40 EDT
 */

package org.gnu.gtk;

import org.gnu.gdk.Bitmap;
import org.gnu.gdk.Pixbuf;
import org.gnu.gdk.PixbufAnimation;
import org.gnu.gdk.Pixmap;
import org.gnu.glib.Type;

/**
 * The Image widget displays an image.  Various kinds of objects can be
 * displayed as an image; most typically you would create a
 * {@link org.gnu.gdk.Pixbuf} from a file and then display that.  
 * <p>
 * If the file isn't loaded successfully, the image will contain a
 * "broken image" icon similar to that used in many web browsers.
 */
public class Image extends Misc {

	/**
	 * Construct a new image passing the filename of an image.
	 * 
	 * @param filename The filename for the image to load.
	 */
	public Image(String filename) {
		handle = Image.gtk_image_new_from_file(filename);
		initializeEventHandlers();
	}

	/**
	 * Create an Image widget displaying a <i>image</i> and a <i>mask</i>.
	 * A org.gnu.gdk.Image is a client-side image buffer in the pixel format
	 * of the current display.
	 * 
	 * @param image The org.gnu.gdk.Image to use for this object creation.
	 * @param mask The org.gnu.gdk.Mask to apply to the image.
	 */
	public Image(org.gnu.gdk.Image image, Bitmap mask) {
		handle = Image.gtk_image_new_from_image(image.getHandle(), mask.getHandle());
		initializeEventHandlers();
	}

	/**
	 * Creates an Image from a {@link org.gnu.gdk.Pixbuf}.
	 * 
	 * @param pixbuf The Pixbuf to use for the Image creation.
	 */
	public Image(Pixbuf pixbuf) {
		handle = Image.gtk_image_new_from_pixbuf(pixbuf.getHandle());
		initializeEventHandlers();
	}

	/**
	 * Create an Image from a {@link org.gnu.gdk.Pixmap}.
	 * 
	 * @param pixmap The Pixmap to use for the Image creation.
	 * @param mask The mask to apply to the created Image.
	 */
	public Image(Pixmap pixmap, Bitmap mask) {
		handle = Image.gtk_image_new_from_pixmap(pixmap.getHandle(), mask.getHandle());
		initializeEventHandlers();
	}

	/**
	 * Creates an Image displaying the given PixbufAnimation.
	 * 
	 * @param animation The PixbufAnimation to use for this object creation.
	 */
	public Image(PixbufAnimation animation) {
		handle = Image.gtk_image_new_from_animation(animation.getHandle());
		initializeEventHandlers();
	}

	/**
	 * Construct an Image from a handle to a native resource.
	 */
	public Image(int handle) {
	    super(handle);
	}
	
	/**
	 * Creates an Image displaying an IconSet.
	 * 
	 * @param iconSet The IconSet to use for the Image.
	 * @param size The IconSize to use for the Image.
	 */
	public Image(IconSet iconSet, IconSize size) {
		handle = Image.gtk_image_new_from_icon_set(iconSet.getHandle(), size.getValue());
		initializeEventHandlers();
	}

	/**
	 * Create an Image displaying a Stock icon.
	 * 
	 * @param stockId The id of the Stock icon to display.
	 * @param size The size of the icon.
	 */
	public Image(GtkStockItem stockId, IconSize size) {
		handle = Image.gtk_image_new_from_stock(stockId.getString(), size.getValue());
		initializeEventHandlers();
	}
	
	protected void noopInit() {}
	
	/**
	 * Gets the type of representation being used by the Image to store
	 * image data.
	 */
	public ImageType getStorageType() {
		return ImageType.intern(gtk_image_get_storage_type(handle));
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_image_get_type());
	}

	/**
	 * Constructs a new Image. This will be displayed as a "no image" icon until
	 * an image is set using one of the set* methods.
	 */
	public Image(){
		handle = Image.gtk_image_new();
		initializeEventHandlers();
	}
	
	/**
	 * Sets the image to the given {@link org.gnu.gdk.Pixmap}.
	 * 
	 * @param pixmap The Pixmap to use for the Image.
	 * @param mask The mask to apply to the Image.
	 */
	public void set(Pixmap pixmap, Bitmap mask) {
		gtk_image_set_from_pixmap(handle, pixmap.getHandle(), mask.getHandle());
	}
	
	/**
	 * Sets the image widget to displaying a <i>image</i> and a <i>mask</i>.
	 * A org.gnu.gdk.Image is a client-side image buffer in the pixel format
	 * of the current display.
	 * 
	 * @param image The org.gnu.gdk.Image to use for this object.
	 * @param mask The org.gnu.gdk.Mask to apply to the image.
	 */
	public void set(org.gnu.gdk.Image image, Bitmap mask) {
		Image.gtk_image_set_from_image(handle, image.getHandle(), mask.getHandle());
	}

	/**
	 * Sets the Image from a {@link org.gnu.gdk.Pixbuf}.
	 * 
	 * @param pixbuf The Pixbuf to use for the Image.
	 */
	public void set(Pixbuf pixbuf) {
		Image.gtk_image_set_from_pixbuf(handle, pixbuf.getHandle());
	}
	/**
	 * Sets to image to the given PixbufAnimation.
	 * 
	 * @param animation The PixbufAnimation to use for this object.
	 */
	public void set(PixbufAnimation animation) {
		Image.gtk_image_set_from_animation(handle, animation.getHandle());
	}
	
	/**
	 * Sets the image to displayian IconSet.
	 * 
	 * @param iconSet The IconSet to use for the Image.
	 * @param size The IconSize to use for the Image.
	 */
	public void set(IconSet iconSet, IconSize size) {
		Image.gtk_image_set_from_icon_set(handle, iconSet.getHandle(), size.getValue());
	}

	/**
	 * Set the image to a Stock icon.
	 * 
	 * @param stockId The id of the Stock icon to display.
	 * @param size The size of the icon.
	 */
	public void set(GtkStockItem stockId, IconSize size) {
		Image.gtk_image_set_from_stock(handle, stockId.getString(), size.getValue());
	}

	/**
	 * Sets the image from a file
	 * 
	 * @param filename The filename for the image to load.
	 */
	public void set(String filename) {
		Image.gtk_image_set_from_file(handle, filename);
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gtk_image_get_type();
	native static final protected int gtk_image_new();
	native static final protected int gtk_image_new_from_pixmap(int pixmap, int mask);
	native static final protected int gtk_image_new_from_image(int image, int mask);
	native static final protected int gtk_image_new_from_file(String filename);
	native static final protected int gtk_image_new_from_pixbuf(int pixbuf);
	native static final protected int gtk_image_new_from_stock(String stockId, int size);
	native static final protected int gtk_image_new_from_icon_set(int iconSet, int size);
	native static final protected int gtk_image_new_from_animation(int animation);
	native static final protected void gtk_image_set_from_pixmap(int image, int pixmap, int mask);
	native static final protected void gtk_image_set_from_image(int image, int gdkImage, int mask);
	native static final protected void gtk_image_set_from_file(int image, String filename);
	native static final protected void gtk_image_set_from_pixbuf(int image, int pixbuf);
	native static final protected void gtk_image_set_from_stock(int image, String stockId, int size);
	native static final protected void gtk_image_set_from_icon_set(int image, int iconSet, int size);
	native static final protected void gtk_image_set_from_animation(int image, int animation);
	native static final protected int gtk_image_get_storage_type(int image);
	native static final protected void gtk_image_get_pixmap(int image, int pixmap, int mask);
	native static final protected void gtk_image_get_image(int image, int gdkImage, int mask);
	native static final protected int gtk_image_get_pixbuf(int image);
	native static final protected void gtk_image_get_stock(int image, String[] stockId, int[] size);
	native static final protected void gtk_image_get_icon_set(int image, int[] iconSet, int[] size);
	native static final protected int gtk_image_get_animation(int image);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
