/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:29 EDT
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * This is a MenuItem that displays an Image.
 */
public class ImageMenuItem extends MenuItem 
{
	/**
	 * Construct a new ImageMenuItem.
	 */
	public ImageMenuItem() {
		handle = gtk_image_menu_item_new();
		initializeEventHandlers();
	}
	
	/**
	 * Construct a new ImageMenuItem with a label.
	 */
	public ImageMenuItem(String label, boolean hasMnemonic) {
		if (hasMnemonic) {
			handle = gtk_image_menu_item_new_with_mnemonic(label);
		} else {
			handle = gtk_image_menu_item_new_with_label(label);
		}
		initializeEventHandlers();
	}
	
	/**
	 * Construct a new ImageMenuItem using a stock icon.
	 */
	public ImageMenuItem(String stockID, AccelGroup group) {
		handle = gtk_image_menu_item_new_from_stock(stockID, group.getHandle());
		initializeEventHandlers();
	}
	
	/**
	 * Construct a ImageMenuItem using a handle to a native resource.
	 */
	public ImageMenuItem(int handle) {
	    super(handle);
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_image_menu_item_get_type());
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_image_menu_item_get_type ();
    native static final protected int gtk_image_menu_item_new ();
    native static final protected int gtk_image_menu_item_new_with_label (String label);
    native static final protected int gtk_image_menu_item_new_with_mnemonic (String label);
    native static final protected int gtk_image_menu_item_new_from_stock (String stockId, int 
        accelGroup);
    native static final protected void gtk_image_menu_item_set_image (int image_menu_item, int 
        image);
    native static final protected int gtk_image_menu_item_get_image (int image_menu_item);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

