/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

/**
 * @author Jeffrey S. Morgan
 *
 * This is the listener interface for receiving activate events
 * from a menu item
 * 
 * @see MenuItemEvent
 * @see org.gnu.gtk.MenuItem
 */
public interface MenuItemListener {

	/**
	 * This method is called when the MenuItem activate
	 * event occurs.
	 */
	public void menuItemEvent(MenuItemEvent event);
}
