/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

/**
 * An event thrown when a cell has been selected in a {@link org.gnu.gtk.TreeView} widget. 
 */
public class TreeViewColumnEvent extends GtkEvent {

	public static class Type extends GtkEventType{
		private Type(int id, String name){
			super(id, name);
		}

		/**
		 * This event indicates that the menu item has been activated.
		 */
		public static final Type CLICKED = new Type(1, "CLICKED");
	}

	/**
	 * Creates a new selection Event. This is used internally by java-gnome. Users
	 * only have to deal with listeners.
	 */
	public TreeViewColumnEvent(Object source) {
		super(source, Type.CLICKED);
	}
}
