// Generated by gmmproc 2.37.7 -- DO NOT MODIFY!

// Needed before gtkmm/private/application_p.h is included.
typedef struct _GtkWindow GtkWindow;
 

#include <glibmm.h>

#include <gtkmm/application.h>
#include <gtkmm/private/application_p.h>


/* Copyright 2003 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/vectorutils.h>

#include <gtk/gtk.h>
#include <gtkmm/window.h>
#include <glibmm/init.h>
#include <giomm/init.h>
#include <pangomm/wrap_init.h>
#ifdef GTKMM_ATKMM_ENABLED
#include <atkmm/wrap_init.h>
#endif //GTKMM_ATKMM_ENABLED
#include <gdkmm/wrap_init.h>
#include <gtkmm/wrap_init.h>

namespace
{

static void init_gtkmm_internals()
{
  static bool init_done = false;

  if(!init_done)
  {
    Glib::init();
    Gio::init();

    // Populate the map of GTypes to C++ wrap_new() functions.
    Pango::wrap_init();
#ifdef GTKMM_ATKMM_ENABLED
    Atk::wrap_init();
#endif //GTKMM_ATKMM_ENABLED
    Gdk::wrap_init();
    Gtk::wrap_init();

    init_done = true;
  }
}

} // anonymous namespace

namespace Gtk
{

const Glib::Class& Application::custom_class_init()
{
  init_gtkmm_internals();
  return application_class_.init();
}

Application::Application(const Glib::ustring& application_id, Gio::ApplicationFlags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  //Note that GApplication complains about "" but allows NULL (0), so we avoid passing "".
  Glib::ObjectBase(0),
  Gio::Application(Glib::ConstructParams(custom_class_init(), "application_id", (application_id.empty() ? 0 : application_id.c_str()), "flags", GApplicationFlags(flags), static_cast<char*>(0))),
  m_argc(0),
  m_argv(0)
{
}

Application::Application(int& argc, char**& argv, const Glib::ustring& application_id, Gio::ApplicationFlags flags)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  //Note that GApplication complains about "" but allows NULL (0), so we avoid passing "".
  Glib::ObjectBase(0),
  Gio::Application(Glib::ConstructParams(custom_class_init(), "application_id", (application_id.empty() ? 0 : application_id.c_str()), "flags", GApplicationFlags(flags), static_cast<char*>(0))),
  m_argc(argc),
  m_argv(argv)
{
  gtk_init(&argc, &argv);
}

Glib::RefPtr<Application> Application::create(const Glib::ustring& application_id, Gio::ApplicationFlags flags)
{
  return Glib::RefPtr<Application>( new Application(application_id, flags) );
}

Glib::RefPtr<Application> Application::create(int& argc, char**& argv, const Glib::ustring& application_id, Gio::ApplicationFlags flags)
{
  return Glib::RefPtr<Application>( new Application(argc, argv, application_id, flags) );
}

void Application::on_window_hide(Window* window)
{
  //Tell GtkApplication to forget the window.
  //This can cause run() to return, if it is the last window.
  //Otherwise, GtkApplication waits for the window to be _destroyed_,
  //which is just not something that it should care about:
  //See https://bugzilla.gnome.org/show_bug.cgi?id=639931
  if(window && window->get_application()) //We check that it's still in an application anyway.
    remove_window(*window);
}

void Application::add_window(Window& window)
{
  //Respond to window hiding, not destruction:
  //See https://bugzilla.gnome.org/show_bug.cgi?id=639931
  window.signal_hide().connect(
    sigc::bind(
      sigc::mem_fun(*this, &Application::on_window_hide),
      &window));

  gtk_application_add_window(gobj(), (window).gobj());
}

int Application::run(int argc, char** argv)
{
  return Gio::Application::run(argc, argv);
}

int Application::run(Window& window, int argc, char** argv)
{
  //We cannot add and show the window until the GApplication::activate signal
  //has been emitted, or we will crash because the application has not been
  //registered. (At least if window is an ApplicationWindow.)
  signal_activate().connect(
    sigc::bind(
      sigc::mem_fun(*this, &Application::on_activate_add_and_show_main_window),
      &window));

  const int result = Gio::Application::run(argc, argv);
  return result;
}


int Application::run(Window& window)
{
  g_assert(m_argc);
  g_assert(m_argv);

  //We cannot add and show the window until the GApplication::activate signal
  //has been emitted, or we will crash because the application has not been
  //registered. (At least if window is an ApplicationWindow.)
  signal_activate().connect(
    sigc::bind(
      sigc::mem_fun(*this, &Application::on_activate_add_and_show_main_window),
      &window));

  const int result = Gio::Application::run(m_argc, m_argv);
  return result;
}

int Application::run()
{
  g_assert(m_argc);
  g_assert(m_argv);

  const int result = Gio::Application::run(m_argc, m_argv);
  return result;
}

void Application::on_activate_add_and_show_main_window(Window* window)
{
  if(window)
  {
    add_window(*window);
    window->show();
  }
}


} // namespace Gtk

namespace
{


static void Application_signal_window_added_callback(GtkApplication* self, GtkWindow* p0,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,Window* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Application_signal_window_added_info =
{
  "window-added",
  (GCallback) &Application_signal_window_added_callback,
  (GCallback) &Application_signal_window_added_callback
};


static void Application_signal_window_removed_callback(GtkApplication* self, GtkWindow* p0,void* data)
{
  using namespace Gtk;
  typedef sigc::slot< void,Window* > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Application_signal_window_removed_info =
{
  "window-removed",
  (GCallback) &Application_signal_window_removed_callback,
  (GCallback) &Application_signal_window_removed_callback
};


} // anonymous namespace

// static
GType Glib::Value<Gtk::ApplicationInhibitFlags>::value_type()
{
  return gtk_application_inhibit_flags_get_type();
}


namespace Glib
{

Glib::RefPtr<Gtk::Application> wrap(GtkApplication* object, bool take_copy)
{
  return Glib::RefPtr<Gtk::Application>( dynamic_cast<Gtk::Application*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& Application_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Application_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_application_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Application_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


  klass->window_added = &window_added_callback;
  klass->window_removed = &window_removed_callback;
}


void Application_Class::window_added_callback(GtkApplication* self, GtkWindow* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_window_added(Glib::wrap(p0)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->window_added)
    (*base->window_added)(self, p0);
}
void Application_Class::window_removed_callback(GtkApplication* self, GtkWindow* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_window_removed(Glib::wrap(p0)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->window_removed)
    (*base->window_removed)(self, p0);
}


Glib::ObjectBase* Application_Class::wrap_new(GObject* object)
{
  return new Application((GtkApplication*)object);
}


/* The implementation: */

GtkApplication* Application::gobj_copy()
{
  reference();
  return gobj();
}

Application::Application(const Glib::ConstructParams& construct_params)
:
  Gio::Application(construct_params)
{

}

Application::Application(GtkApplication* castitem)
:
  Gio::Application((GApplication*)(castitem))
{}


Application::~Application()
{}


Application::CppClassType Application::application_class_; // initialize static member

GType Application::get_type()
{
  return application_class_.init().get_type();
}


GType Application::get_base_type()
{
  return gtk_application_get_type();
}


std::vector<Window*> Application::get_windows()
{
  return Glib::ListHandler<Window*>::list_to_vector(gtk_application_get_windows(gobj()), Glib::OWNERSHIP_NONE);
}

std::vector<const Window*> Application::get_windows() const
{
  return Glib::ListHandler<const Window*>::list_to_vector(gtk_application_get_windows(const_cast<GtkApplication*>(gobj())), Glib::OWNERSHIP_NONE);
}

void Application::remove_window(Window& window)
{
  gtk_application_remove_window(gobj(), (window).gobj());
}

Glib::RefPtr<Gio::MenuModel> Application::get_app_menu()
{
  Glib::RefPtr<Gio::MenuModel> retvalue = Glib::wrap(gtk_application_get_app_menu(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gio::MenuModel> Application::get_app_menu() const
{
  return const_cast<Application*>(this)->get_app_menu();
}

void Application::set_app_menu(const Glib::RefPtr<Gio::MenuModel>& app_menu)
{
  gtk_application_set_app_menu(gobj(), Glib::unwrap(app_menu));
}

Glib::RefPtr<Gio::MenuModel> Application::get_menubar()
{
  Glib::RefPtr<Gio::MenuModel> retvalue = Glib::wrap(gtk_application_get_menubar(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gio::MenuModel> Application::get_menubar() const
{
  return const_cast<Application*>(this)->get_menubar();
}

void Application::set_menubar(const Glib::RefPtr<Gio::MenuModel>& menubar)
{
  gtk_application_set_menubar(gobj(), Glib::unwrap(menubar));
}

void Application::add_accelerator(const Glib::ustring& accelerator, const Glib::ustring& action_name, GVariant * parameter)
{
  gtk_application_add_accelerator(gobj(), accelerator.c_str(), action_name.c_str(), parameter);
}

void Application::remove_accelerator(const Glib::ustring& action_name, GVariant* parameter)
{
  gtk_application_remove_accelerator(gobj(), action_name.c_str(), parameter);
}

guint Application::inhibit(Window& window, ApplicationInhibitFlags flags, const Glib::ustring& reason)
{
  return gtk_application_inhibit(gobj(), (window).gobj(), ((GtkApplicationInhibitFlags)(flags)), reason.c_str());
}

void Application::uninhibit(guint cookie)
{
  gtk_application_uninhibit(gobj(), cookie);
}

bool Application::is_inhibited(ApplicationInhibitFlags flags) const
{
  return gtk_application_is_inhibited(const_cast<GtkApplication*>(gobj()), ((GtkApplicationInhibitFlags)(flags)));
}

Window* Application::get_window_by_id(guint id)
{
  Window* retvalue = Glib::wrap(gtk_application_get_window_by_id(gobj(), id));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

const Window* Application::get_window_by_id(guint id) const
{
  return const_cast<Application*>(this)->get_window_by_id(id);
}

Window* Application::get_active_window()
{
  Window* retvalue = Glib::wrap(gtk_application_get_active_window(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

const Window* Application::get_active_window() const
{
  return const_cast<Application*>(this)->get_active_window();
}


Glib::SignalProxy1< void,Window* > Application::signal_window_added()
{
  return Glib::SignalProxy1< void,Window* >(this, &Application_signal_window_added_info);
}


Glib::SignalProxy1< void,Window* > Application::signal_window_removed()
{
  return Glib::SignalProxy1< void,Window* >(this, &Application_signal_window_removed_info);
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< Glib::RefPtr<Gio::MenuModel> > Application::property_app_menu() 
{
  return Glib::PropertyProxy< Glib::RefPtr<Gio::MenuModel> >(this, "app-menu");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::MenuModel> > Application::property_app_menu() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::MenuModel> >(this, "app-menu");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< Glib::RefPtr<Gio::MenuModel> > Application::property_menubar() 
{
  return Glib::PropertyProxy< Glib::RefPtr<Gio::MenuModel> >(this, "menubar");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::MenuModel> > Application::property_menubar() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::MenuModel> >(this, "menubar");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< bool > Application::property_register_session() 
{
  return Glib::PropertyProxy< bool >(this, "register-session");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< bool > Application::property_register_session() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "register-session");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Window* > Application::property_active_window() const
{
  return Glib::PropertyProxy_ReadOnly< Window* >(this, "active-window");
}
#endif //GLIBMM_PROPERTIES_ENABLED


void Gtk::Application::on_window_added(Window* window)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->window_added)
    (*base->window_added)(gobj(),(GtkWindow*)Glib::unwrap(window));
}
void Gtk::Application::on_window_removed(Window* window)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->window_removed)
    (*base->window_removed)(gobj(),(GtkWindow*)Glib::unwrap(window));
}


} // namespace Gtk


