// Generated by gmmproc 2.55.2 -- DO NOT MODIFY!
#ifndef _GDKMM_EVENT_H
#define _GDKMM_EVENT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <glibmm/object.h>
#include <glibmm/refptr.h>
#include <glibmm/value.h>

/* Shadow DELETE macro (from winnt.h).
 * It interferes with Gdk::Event::Type::DELETE.
 */
#if defined(DELETE) && !defined(GTKMM_MACRO_SHADOW_DELETE)
enum { GTKMM_MACRO_DEFINITION_DELETE = DELETE };
#undef DELETE
enum { DELETE = GTKMM_MACRO_DEFINITION_DELETE };
#define DELETE DELETE
#define GTKMM_MACRO_SHADOW_DELETE 1
#endif

#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GdkEvent = union _GdkEvent;
using GdkEventClass = struct _GdkEventClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#ifndef DOXYGEN_SHOULD_SKIP_THIS
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gdk
{ class Event_Class; } // namespace Gdk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gdk
{
class Device;
class Display;
class Seat;
class Window;

/** Functions for handling events from the window system.
 *
 * In GTK+ applications the events are handled automatically in
 * gtk_main_do_event() and passed on to the appropriate widgets,
 * so %Gdk::Event and its subclasses are rarely needed.
 */

class Event : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Event;
  using CppClassType = Event_Class;
  using BaseObjectType = GdkEvent;
  using BaseClassType = GdkEventClass;

  // noncopyable
  Event(const Event&) = delete;
  Event& operator=(const Event&) = delete;

private:  friend class Event_Class;
  static CppClassType event_class_;

protected:
  explicit Event(const Glib::ConstructParams& construct_params);
  explicit Event(GdkEvent* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Event(Event&& src) noexcept;
  Event& operator=(Event&& src) noexcept;

  ~Event() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkEvent*       gobj()       { return reinterpret_cast<GdkEvent*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdkEvent* gobj() const { return reinterpret_cast<GdkEvent*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdkEvent* gobj_copy();

private:

     
public:
  /** @addtogroup gdkmmEnums gdkmm Enums and Flags */

  /** 
   *  @var Type NOTHING
   * A special code to indicate a null event.
   * 
   *  @var Type DELETE
   * The window manager has requested that the toplevel window be
   * hidden or destroyed, usually when the user clicks on a special icon in the
   * title bar.
   * 
   *  @var Type DESTROY
   * The window has been destroyed.
   * 
   *  @var Type EXPOSE
   * All or part of the window has become visible and needs to be
   * redrawn.
   * 
   *  @var Type MOTION_NOTIFY
   * The pointer (usually a mouse) has moved.
   * 
   *  @var Type BUTTON_PRESS
   * A mouse button has been pressed.
   * 
   *  @var Type BUTTON_RELEASE
   * A mouse button has been released.
   * 
   *  @var Type KEY_PRESS
   * A key has been pressed.
   * 
   *  @var Type KEY_RELEASE
   * A key has been released.
   * 
   *  @var Type ENTER_NOTIFY
   * The pointer has entered the window.
   * 
   *  @var Type LEAVE_NOTIFY
   * The pointer has left the window.
   * 
   *  @var Type FOCUS_CHANGE
   * The keyboard focus has entered or left the window.
   * 
   *  @var Type CONFIGURE
   * The size, position or stacking order of the window has changed.
   * Note that GTK+ discards these events for Gdk::Window::Type::CHILD windows.
   * 
   *  @var Type MAP
   * The window has been mapped.
   * 
   *  @var Type UNMAP
   * The window has been unmapped.
   * 
   *  @var Type PROXIMITY_IN
   * An input device has moved into contact with a sensing
   * surface (e.g. a touchscreen or graphics tablet).
   * 
   *  @var Type PROXIMITY_OUT
   * An input device has moved out of contact with a sensing
   * surface.
   * 
   *  @var Type DRAG_ENTER
   * The mouse has entered the window while a drag is in progress.
   * 
   *  @var Type DRAG_LEAVE
   * The mouse has left the window while a drag is in progress.
   * 
   *  @var Type DRAG_MOTION
   * The mouse has moved in the window while a drag is in
   * progress.
   * 
   *  @var Type DROP_START
   * A drop operation onto the window has started.
   * 
   *  @var Type SCROLL
   * The scroll wheel was turned.
   * 
   *  @var Type GRAB_BROKEN
   * A pointer or keyboard grab was broken. This event type
   * was added in 2.8.
   * 
   *  @var Type TOUCH_BEGIN
   * A new touch event sequence has just started. This event
   * type was added in 3.4.
   * 
   *  @var Type TOUCH_UPDATE
   * A touch event sequence has been updated. This event type
   * was added in 3.4.
   * 
   *  @var Type TOUCH_END
   * A touch event sequence has finished. This event type
   * was added in 3.4.
   * 
   *  @var Type TOUCH_CANCEL
   * A touch event sequence has been canceled. This event type
   * was added in 3.4.
   * 
   *  @var Type TOUCHPAD_SWIPE
   * A touchpad swipe gesture event, the current state
   * is determined by its phase field. This event type was added in 3.18.
   * 
   *  @var Type TOUCHPAD_PINCH
   * A touchpad pinch gesture event, the current state
   * is determined by its phase field. This event type was added in 3.18.
   * 
   *  @var Type PAD_BUTTON_PRESS
   * A tablet pad button press event. This event type
   * was added in 3.22.
   * 
   *  @var Type PAD_BUTTON_RELEASE
   * A tablet pad button release event. This event type
   * was added in 3.22.
   * 
   *  @var Type PAD_RING
   * A tablet pad axis event from a "ring". This event type was
   * added in 3.22.
   * 
   *  @var Type PAD_STRIP
   * A tablet pad axis event from a "strip". This event type was
   * added in 3.22.
   * 
   *  @var Type PAD_GROUP_MODE
   * A tablet pad group mode change. This event type was
   * added in 3.22.
   * 
   *  @var Type EVENT_LAST
   * Marks the end of the GdkEventType enumeration. Added in 2.18.
   * 
   *  @enum Type
   * 
   * Specifies the type of the event.
   * 
   * Do not confuse these events with the signals that GTK+ widgets emit.
   * Although many of these events result in corresponding signals being emitted,
   * the events are often transformed or filtered along the way.
   *
   * @ingroup gdkmmEnums
   */
  enum class Type
  {
    NOTHING,
    DELETE,
    DESTROY,
    EXPOSE,
    MOTION_NOTIFY,
    BUTTON_PRESS,
    BUTTON_RELEASE,
    KEY_PRESS,
    KEY_RELEASE,
    ENTER_NOTIFY,
    LEAVE_NOTIFY,
    FOCUS_CHANGE,
    CONFIGURE,
    MAP,
    UNMAP,
    PROXIMITY_IN,
    PROXIMITY_OUT,
    DRAG_ENTER,
    DRAG_LEAVE,
    DRAG_MOTION,
    DROP_START,
    SCROLL,
    GRAB_BROKEN,
    TOUCH_BEGIN,
    TOUCH_UPDATE,
    TOUCH_END,
    TOUCH_CANCEL,
    TOUCHPAD_SWIPE,
    TOUCHPAD_PINCH,
    PAD_BUTTON_PRESS,
    PAD_BUTTON_RELEASE,
    PAD_RING,
    PAD_STRIP,
    PAD_GROUP_MODE,
    EVENT_LAST
  };


protected:
    explicit Event(Type event_type);


public:
  /** Creates a new event of the given type. All fields are set to 0.
   */
  
  static Glib::RefPtr<Event> create(Type event_type);

  
  /** Copies a Gdk::Event, copying or incrementing the reference count of the
   * resources associated with it (e.g.\ Gdk::Window’s and strings).
   * 
   * @return A copy of @a event. Free with Glib::object_unref().
   */
  Glib::RefPtr<Event> copy() const;

  
  /** Retrieves the type of the event.
   * 
   * @return A Gdk::Event::Type.
   */
  Type get_event_type() const;

  
  /** Extracts the Gdk::Window associated with an event.
   * 
   * @return The Gdk::Window associated with the event.
   */
  Glib::RefPtr<Gdk::Window> get_window();
  
  /** Extracts the Gdk::Window associated with an event.
   * 
   * @return The Gdk::Window associated with the event.
   */
  Glib::RefPtr<const Gdk::Window> get_window() const;

  
  /**
   * Returns @c true if the event was sent explicitly (e.g. using @c XSendEvent)
   */
  bool is_sent() const;

  
  /** Sets whether a trace of received events is output.
   * Note that GTK+ must be compiled with debugging (that is,
   * configured using the `--enable-debug` option)
   * to use this option.
   * 
   * @param show_events <tt>true</tt> to output event debugging information.
   */
  static void set_show_events(bool show_events =  true);
  
  /** Gets whether event debugging output is enabled.
   * 
   * @return <tt>true</tt> if event debugging output is enabled.
   */
  static bool get_show_events();

  
  /** Sets the device for @a event to @a device. The event must
   * have been allocated by GTK+, for instance, by
   * copy().
   * 
   * @newin{3,94}
   * 
   * @param device A Gdk::Device.
   */
  void set_device(const Glib::RefPtr<Device>& device);
  
  /** If the event contains a “device” field, this function will return
   * it, else it will return <tt>nullptr</tt>.
   * 
   * @newin{3,94}
   * 
   * @return A Gdk::Device, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<Device> get_device();
  
  /** If the event contains a “device” field, this function will return
   * it, else it will return <tt>nullptr</tt>.
   * 
   * @newin{3,94}
   * 
   * @return A Gdk::Device, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<const Device> get_device() const;

  
  /** Sets the slave device for @a event to @a device.
   * 
   * The event must have been allocated by GTK+,
   * for instance by copy().
   * 
   * @newin{3,94}
   * 
   * @param device A Gdk::Device.
   */
  void set_source_device(const Glib::RefPtr<Device>& device);
  
  /** This function returns the hardware (slave) Gdk::Device that has
   * triggered the event, falling back to the virtual (master) device
   * (as in get_device()) if the event wasn’t caused by
   * interaction with a hardware device. This may happen for example
   * in synthesized crossing events after a Gdk::Window updates its
   * geometry or a grab is acquired/released.
   * 
   * If the event does not contain a device field, this function will
   * return <tt>nullptr</tt>.
   * 
   * @newin{3,94}
   * 
   * @return A Gdk::Device, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<Device> get_source_device();
  
  /** This function returns the hardware (slave) Gdk::Device that has
   * triggered the event, falling back to the virtual (master) device
   * (as in get_device()) if the event wasn’t caused by
   * interaction with a hardware device. This may happen for example
   * in synthesized crossing events after a Gdk::Window updates its
   * geometry or a grab is acquired/released.
   * 
   * If the event does not contain a device field, this function will
   * return <tt>nullptr</tt>.
   * 
   * @newin{3,94}
   * 
   * @return A Gdk::Device, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<const Device> get_source_device() const;

  
  /** Sets the display that an event is associated with.
   * 
   * @param display A Gdk::Display.
   */
  void set_display(const Glib::RefPtr<Display>& display);
  
  /** Retrieves the Gdk::Display associated to the @a event.
   * 
   * @return A Gdk::Display.
   */
  Glib::RefPtr<Display> get_display();
  
  /** Retrieves the Gdk::Display associated to the @a event.
   * 
   * @return A Gdk::Display.
   */
  Glib::RefPtr<const Display> get_display() const;

  
  /** Returns the Gdk::Seat this event was generated for.
   * 
   * @newin{3,90}
   * 
   * @return The Gdk::Seat of this event.
   */
  Glib::RefPtr<Seat> get_seat();
  
  /** Returns the Gdk::Seat this event was generated for.
   * 
   * @newin{3,90}
   * 
   * @return The Gdk::Seat of this event.
   */
  Glib::RefPtr<const Seat> get_seat() const;

  /** Event type.
   *
   * Default value: Gdk::Event::Type::NOTHING
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Type > property_event_type() const;


  // Belong to subclasses:
  

public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::Event::Type> : public Glib::Value_Enum<Gdk::Event::Type>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gdk::Event
   */
  Glib::RefPtr<Gdk::Event> wrap(GdkEvent* object, bool take_copy = false);
}


#endif /* _GDKMM_EVENT_H */

