/* valaerrordomain.c generated by valac, the Vala compiler
 * generated from valaerrordomain.vala, do not modify */

/* valaerrordomain.vala
 *
 * Copyright (C) 2008-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaErrorDomainPrivate {
	ValaList* codes;
	ValaList* methods;
};

static gint ValaErrorDomain_private_offset;
static gpointer vala_error_domain_parent_class = NULL;

static void vala_error_domain_real_add_method (ValaSymbol* base,
                                        ValaMethod* m);
static void vala_error_domain_real_accept (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor);
static void vala_error_domain_real_accept_children (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor);
static gboolean vala_error_domain_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_error_domain_real_check (ValaCodeNode* base,
                                       ValaCodeContext* context);
static void vala_error_domain_finalize (ValaCodeNode * obj);

static inline gpointer
vala_error_domain_get_instance_private (ValaErrorDomain* self)
{
	return G_STRUCT_MEMBER_P (self, ValaErrorDomain_private_offset);
}

/**
 * Creates a new error domain.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @return                 newly created error domain
 */
ValaErrorDomain*
vala_error_domain_construct (GType object_type,
                             const gchar* name,
                             ValaSourceReference* source_reference,
                             ValaComment* comment)
{
	ValaErrorDomain* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaErrorDomain*) vala_typesymbol_construct (object_type, name, source_reference, comment);
	return self;
}

ValaErrorDomain*
vala_error_domain_new (const gchar* name,
                       ValaSourceReference* source_reference,
                       ValaComment* comment)
{
	return vala_error_domain_construct (VALA_TYPE_ERROR_DOMAIN, name, source_reference, comment);
}

/**
 * Appends the specified code to the list of error codes.
 *
 * @param ecode an error code
 */
void
vala_error_domain_add_code (ValaErrorDomain* self,
                            ValaErrorCode* ecode)
{
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ecode != NULL);
	_tmp0_ = self->priv->codes;
	vala_collection_add ((ValaCollection*) _tmp0_, ecode);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) ecode);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) ecode);
}

/**
 * Adds the specified method as a member to this error domain.
 *
 * @param m a method
 */
static void
vala_error_domain_real_add_method (ValaSymbol* base,
                                   ValaMethod* m)
{
	ValaErrorDomain * self;
	ValaMemberBinding _tmp2_;
	ValaMemberBinding _tmp3_;
	ValaList* _tmp16_;
	ValaScope* _tmp17_;
	ValaScope* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	self = (ValaErrorDomain*) base;
	g_return_if_fail (m != NULL);
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp1_ = _tmp0_;
		vala_report_error (_tmp1_, "construction methods may only be declared within classes and structs");
		vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		return;
	}
	_tmp2_ = vala_method_get_binding (m);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaErrorType* _tmp4_;
		ValaErrorType* _tmp5_;
		ValaParameter* _tmp6_;
		ValaParameter* _tmp7_;
		ValaScope* _tmp8_;
		ValaScope* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		ValaParameter* _tmp14_;
		ValaParameter* _tmp15_;
		_tmp4_ = vala_error_type_new (self, NULL, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_parameter_new ("this", (ValaDataType*) _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		vala_method_set_this_parameter (m, _tmp7_);
		_vala_code_node_unref0 (_tmp7_);
		_vala_code_node_unref0 (_tmp5_);
		_tmp8_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_method_get_this_parameter (m);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_method_get_this_parameter (m);
		_tmp15_ = _tmp14_;
		vala_scope_add (_tmp9_, _tmp13_, (ValaSymbol*) _tmp15_);
	}
	_tmp16_ = self->priv->methods;
	vala_collection_add ((ValaCollection*) _tmp16_, m);
	_tmp17_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_symbol_get_name ((ValaSymbol*) m);
	_tmp20_ = _tmp19_;
	vala_scope_add (_tmp18_, _tmp20_, (ValaSymbol*) m);
}

/**
 * Returns a copy of the list of error codes.
 *
 * @return list of error codes
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_error_domain_get_codes (ValaErrorDomain* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->codes;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Returns a copy of the list of methods.
 *
 * @return list of methods
 */
ValaList*
vala_error_domain_get_methods (ValaErrorDomain* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->methods;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
vala_error_domain_real_accept (ValaCodeNode* base,
                               ValaCodeVisitor* visitor)
{
	ValaErrorDomain * self;
	self = (ValaErrorDomain*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_error_domain (visitor, self);
}

static void
vala_error_domain_real_accept_children (ValaCodeNode* base,
                                        ValaCodeVisitor* visitor)
{
	ValaErrorDomain * self;
	self = (ValaErrorDomain*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _ecode_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _ecode_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _ecode_index = 0;
		_tmp0_ = self->priv->codes;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_ecode_list = _tmp1_;
		_tmp2_ = _ecode_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_ecode_size = _tmp4_;
		_ecode_index = -1;
		while (TRUE) {
			ValaErrorCode* ecode = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaErrorCode* _tmp7_;
			_ecode_index = _ecode_index + 1;
			if (!(_ecode_index < _ecode_size)) {
				break;
			}
			_tmp5_ = _ecode_list;
			_tmp6_ = vala_list_get (_tmp5_, _ecode_index);
			ecode = (ValaErrorCode*) _tmp6_;
			_tmp7_ = ecode;
			vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
			_vala_code_node_unref0 (ecode);
		}
		_vala_iterable_unref0 (_ecode_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _m_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _m_index = 0;
		_tmp8_ = self->priv->methods;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_m_list = _tmp9_;
		_tmp10_ = _m_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_m_size = _tmp12_;
		_m_index = -1;
		while (TRUE) {
			ValaMethod* m = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaMethod* _tmp15_;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp13_ = _m_list;
			_tmp14_ = vala_list_get (_tmp13_, _m_index);
			m = (ValaMethod*) _tmp14_;
			_tmp15_ = m;
			vala_code_node_accept ((ValaCodeNode*) _tmp15_, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
}

static gboolean
vala_error_domain_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaErrorDomain * self;
	gboolean result = FALSE;
	self = (ValaErrorDomain*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_error_domain_real_check (ValaCodeNode* base,
                              ValaCodeContext* context)
{
	ValaErrorDomain * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gboolean _tmp29_;
	gboolean _tmp30_;
	self = (ValaErrorDomain*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = self->priv->codes;
	_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ <= 0) {
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup_printf ("Error domain `%s' requires at least one code", _tmp10_);
		_tmp12_ = _tmp11_;
		vala_report_error (_tmp8_, _tmp12_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	{
		ValaList* _ecode_list = NULL;
		ValaList* _tmp13_;
		ValaList* _tmp14_;
		gint _ecode_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _ecode_index = 0;
		_tmp13_ = self->priv->codes;
		_tmp14_ = _vala_iterable_ref0 (_tmp13_);
		_ecode_list = _tmp14_;
		_tmp15_ = _ecode_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_ecode_size = _tmp17_;
		_ecode_index = -1;
		while (TRUE) {
			ValaErrorCode* ecode = NULL;
			ValaList* _tmp18_;
			gpointer _tmp19_;
			ValaErrorCode* _tmp20_;
			_ecode_index = _ecode_index + 1;
			if (!(_ecode_index < _ecode_size)) {
				break;
			}
			_tmp18_ = _ecode_list;
			_tmp19_ = vala_list_get (_tmp18_, _ecode_index);
			ecode = (ValaErrorCode*) _tmp19_;
			_tmp20_ = ecode;
			vala_code_node_check ((ValaCodeNode*) _tmp20_, context);
			_vala_code_node_unref0 (ecode);
		}
		_vala_iterable_unref0 (_ecode_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp21_;
		ValaList* _tmp22_;
		gint _m_size = 0;
		ValaList* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _m_index = 0;
		_tmp21_ = self->priv->methods;
		_tmp22_ = _vala_iterable_ref0 (_tmp21_);
		_m_list = _tmp22_;
		_tmp23_ = _m_list;
		_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
		_tmp25_ = _tmp24_;
		_m_size = _tmp25_;
		_m_index = -1;
		while (TRUE) {
			ValaMethod* m = NULL;
			ValaList* _tmp26_;
			gpointer _tmp27_;
			ValaMethod* _tmp28_;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp26_ = _m_list;
			_tmp27_ = vala_list_get (_tmp26_, _m_index);
			m = (ValaMethod*) _tmp27_;
			_tmp28_ = m;
			vala_code_node_check ((ValaCodeNode*) _tmp28_, context);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	_tmp29_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp30_ = _tmp29_;
	result = !_tmp30_;
	return result;
}

static void
vala_error_domain_class_init (ValaErrorDomainClass * klass,
                              gpointer klass_data)
{
	vala_error_domain_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_error_domain_finalize;
	g_type_class_adjust_private_offset (klass, &ValaErrorDomain_private_offset);
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_error_domain_real_add_method;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_error_domain_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_error_domain_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_error_domain_real_is_reference_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_error_domain_real_check;
}

static void
vala_error_domain_instance_init (ValaErrorDomain * self,
                                 gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_error_domain_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_ERROR_CODE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->codes = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->methods = (ValaList*) _tmp3_;
}

static void
vala_error_domain_finalize (ValaCodeNode * obj)
{
	ValaErrorDomain * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain);
	_vala_iterable_unref0 (self->priv->codes);
	_vala_iterable_unref0 (self->priv->methods);
	VALA_CODE_NODE_CLASS (vala_error_domain_parent_class)->finalize (obj);
}

/**
 * Represents an error domain declaration in the source code.
 */
GType
vala_error_domain_get_type (void)
{
	static volatile gsize vala_error_domain_type_id__volatile = 0;
	if (g_once_init_enter (&vala_error_domain_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaErrorDomainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_error_domain_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaErrorDomain), 0, (GInstanceInitFunc) vala_error_domain_instance_init, NULL };
		GType vala_error_domain_type_id;
		vala_error_domain_type_id = g_type_register_static (VALA_TYPE_TYPESYMBOL, "ValaErrorDomain", &g_define_type_info, 0);
		ValaErrorDomain_private_offset = g_type_add_instance_private (vala_error_domain_type_id, sizeof (ValaErrorDomainPrivate));
		g_once_init_leave (&vala_error_domain_type_id__volatile, vala_error_domain_type_id);
	}
	return vala_error_domain_type_id__volatile;
}

