/* valapropertyaccessor.c generated by valac, the Vala compiler
 * generated from valapropertyaccessor.vala, do not modify */

/* valapropertyaccessor.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaPropertyAccessorPrivate {
	gboolean _readable;
	gboolean _writable;
	gboolean _construction;
	gboolean _automatic_body;
	ValaParameter* _value_parameter;
	ValaDataType* _value_type;
};

static gint ValaPropertyAccessor_private_offset;
static gpointer vala_property_accessor_parent_class = NULL;

static void vala_property_accessor_set_readable (ValaPropertyAccessor* self,
                                          gboolean value);
static void vala_property_accessor_set_writable (ValaPropertyAccessor* self,
                                          gboolean value);
static void vala_property_accessor_set_construction (ValaPropertyAccessor* self,
                                              gboolean value);
static void vala_property_accessor_set_value_type (ValaPropertyAccessor* self,
                                            ValaDataType* value);
static void vala_property_accessor_real_accept (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static void vala_property_accessor_real_accept_children (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static gboolean vala_property_accessor_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context);
static void vala_property_accessor_set_value_parameter (ValaPropertyAccessor* self,
                                                 ValaParameter* value);
static void vala_property_accessor_set_automatic_body (ValaPropertyAccessor* self,
                                                gboolean value);
static void vala_property_accessor_real_replace_type (ValaCodeNode* base,
                                               ValaDataType* old_type,
                                               ValaDataType* new_type);
static void vala_property_accessor_finalize (ValaCodeNode * obj);

static inline gpointer
vala_property_accessor_get_instance_private (ValaPropertyAccessor* self)
{
	return G_STRUCT_MEMBER_P (self, ValaPropertyAccessor_private_offset);
}

/**
 * Creates a new property accessor.
 *
 * @param readable           true if get accessor, false otherwise
 * @param writable           true if set accessor, false otherwise
 * @param construction       true if construct accessor, false otherwise
 * @param body               accessor body
 * @param source_reference   reference to source code
 * @return                   newly created property accessor
 */
ValaPropertyAccessor*
vala_property_accessor_construct (GType object_type,
                                  gboolean readable,
                                  gboolean writable,
                                  gboolean construction,
                                  ValaDataType* value_type,
                                  ValaBlock* body,
                                  ValaSourceReference* source_reference,
                                  ValaComment* comment)
{
	ValaPropertyAccessor* self = NULL;
	self = (ValaPropertyAccessor*) vala_subroutine_construct (object_type, NULL, source_reference, comment);
	vala_property_accessor_set_readable (self, readable);
	vala_property_accessor_set_writable (self, writable);
	vala_property_accessor_set_construction (self, construction);
	vala_property_accessor_set_value_type (self, value_type);
	vala_subroutine_set_body ((ValaSubroutine*) self, body);
	vala_symbol_set_access ((ValaSymbol*) self, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	return self;
}

ValaPropertyAccessor*
vala_property_accessor_new (gboolean readable,
                            gboolean writable,
                            gboolean construction,
                            ValaDataType* value_type,
                            ValaBlock* body,
                            ValaSourceReference* source_reference,
                            ValaComment* comment)
{
	return vala_property_accessor_construct (VALA_TYPE_PROPERTY_ACCESSOR, readable, writable, construction, value_type, body, source_reference, comment);
}

static void
vala_property_accessor_real_accept (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaPropertyAccessor * self;
	self = (ValaPropertyAccessor*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_property_accessor (visitor, self);
}

static void
vala_property_accessor_real_accept_children (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaPropertyAccessor * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaLocalVariable* _tmp2_;
	ValaLocalVariable* _tmp3_;
	ValaBlock* _tmp6_;
	ValaBlock* _tmp7_;
	self = (ValaPropertyAccessor*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_property_accessor_get_value_type (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaLocalVariable* _tmp4_;
		ValaLocalVariable* _tmp5_;
		_tmp4_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
	_tmp6_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaBlock* _tmp8_;
		ValaBlock* _tmp9_;
		_tmp8_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp9_ = _tmp8_;
		vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
	}
}

/**
 * Get the method representing this property accessor
 * @return   null if the accessor is neither readable nor writable
 */
ValaMethod*
vala_property_accessor_get_method (ValaPropertyAccessor* self)
{
	ValaMethod* result = NULL;
	ValaMethod* m = NULL;
	gboolean _tmp0_;
	ValaMethod* _tmp32_;
	g_return_val_if_fail (self != NULL, NULL);
	m = NULL;
	_tmp0_ = self->priv->_readable;
	if (_tmp0_) {
		ValaProperty* _tmp1_;
		ValaProperty* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaSourceReference* _tmp10_;
		ValaComment* _tmp11_;
		ValaComment* _tmp12_;
		ValaMethod* _tmp13_;
		_tmp1_ = vala_property_accessor_get_prop (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_symbol_get_name ((ValaSymbol*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("get_%s", _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_property_accessor_get_value_type (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_symbol_get_comment ((ValaSymbol*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_method_new (_tmp6_, _tmp8_, _tmp10_, _tmp12_);
		_vala_code_node_unref0 (m);
		m = _tmp13_;
		_g_free0 (_tmp6_);
	} else {
		gboolean _tmp14_;
		_tmp14_ = self->priv->_writable;
		if (_tmp14_) {
			ValaProperty* _tmp15_;
			ValaProperty* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			ValaVoidType* _tmp21_;
			ValaVoidType* _tmp22_;
			ValaSourceReference* _tmp23_;
			ValaSourceReference* _tmp24_;
			ValaComment* _tmp25_;
			ValaComment* _tmp26_;
			ValaMethod* _tmp27_;
			ValaMethod* _tmp28_;
			ValaParameter* _tmp29_;
			ValaParameter* _tmp30_;
			ValaParameter* _tmp31_;
			_tmp15_ = vala_property_accessor_get_prop (self);
			_tmp16_ = _tmp15_;
			_tmp17_ = vala_symbol_get_name ((ValaSymbol*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strdup_printf ("set_%s", _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_void_type_new (NULL);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp24_ = _tmp23_;
			_tmp25_ = vala_symbol_get_comment ((ValaSymbol*) self);
			_tmp26_ = _tmp25_;
			_tmp27_ = vala_method_new (_tmp20_, (ValaDataType*) _tmp22_, _tmp24_, _tmp26_);
			_vala_code_node_unref0 (m);
			m = _tmp27_;
			_vala_code_node_unref0 (_tmp22_);
			_g_free0 (_tmp20_);
			_tmp28_ = m;
			_tmp29_ = self->priv->_value_parameter;
			_tmp30_ = vala_parameter_copy (_tmp29_);
			_tmp31_ = _tmp30_;
			vala_callable_add_parameter ((ValaCallable*) _tmp28_, _tmp31_);
			_vala_code_node_unref0 (_tmp31_);
		}
	}
	_tmp32_ = m;
	if (_tmp32_ != NULL) {
		ValaMethod* _tmp33_;
		ValaProperty* _tmp34_;
		ValaProperty* _tmp35_;
		ValaScope* _tmp36_;
		ValaScope* _tmp37_;
		ValaMethod* _tmp38_;
		ValaSymbolAccessibility _tmp39_;
		ValaSymbolAccessibility _tmp40_;
		ValaMethod* _tmp41_;
		ValaProperty* _tmp42_;
		ValaProperty* _tmp43_;
		ValaMemberBinding _tmp44_;
		ValaMemberBinding _tmp45_;
		ValaMethod* _tmp46_;
		ValaProperty* _tmp47_;
		ValaProperty* _tmp48_;
		gboolean _tmp49_;
		gboolean _tmp50_;
		ValaMethod* _tmp51_;
		ValaProperty* _tmp52_;
		ValaProperty* _tmp53_;
		gboolean _tmp54_;
		gboolean _tmp55_;
		_tmp33_ = m;
		_tmp34_ = vala_property_accessor_get_prop (self);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_symbol_get_owner ((ValaSymbol*) _tmp35_);
		_tmp37_ = _tmp36_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp33_, _tmp37_);
		_tmp38_ = m;
		_tmp39_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp40_ = _tmp39_;
		vala_symbol_set_access ((ValaSymbol*) _tmp38_, _tmp40_);
		_tmp41_ = m;
		_tmp42_ = vala_property_accessor_get_prop (self);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_property_get_binding (_tmp43_);
		_tmp45_ = _tmp44_;
		vala_method_set_binding (_tmp41_, _tmp45_);
		_tmp46_ = m;
		_tmp47_ = vala_property_accessor_get_prop (self);
		_tmp48_ = _tmp47_;
		_tmp49_ = vala_property_get_is_abstract (_tmp48_);
		_tmp50_ = _tmp49_;
		vala_method_set_is_abstract (_tmp46_, _tmp50_);
		_tmp51_ = m;
		_tmp52_ = vala_property_accessor_get_prop (self);
		_tmp53_ = _tmp52_;
		_tmp54_ = vala_property_get_is_virtual (_tmp53_);
		_tmp55_ = _tmp54_;
		vala_method_set_is_virtual (_tmp51_, _tmp55_);
	}
	result = m;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_property_accessor_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context)
{
	ValaPropertyAccessor * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSemanticAnalyzer* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaSymbol* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaSemanticAnalyzer* _tmp11_;
	ValaSemanticAnalyzer* _tmp12_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_;
	ValaProperty* _tmp89_;
	ValaProperty* _tmp90_;
	ValaSourceFileType _tmp91_;
	ValaSourceFileType _tmp92_;
	gboolean _tmp148_ = FALSE;
	gboolean _tmp149_ = FALSE;
	gboolean _tmp150_ = FALSE;
	ValaProperty* _tmp151_;
	ValaProperty* _tmp152_;
	gboolean _tmp153_;
	gboolean _tmp154_;
	gboolean _tmp173_ = FALSE;
	gboolean _tmp174_;
	gboolean _tmp196_ = FALSE;
	ValaBlock* _tmp197_;
	ValaBlock* _tmp198_;
	ValaBlock* _tmp211_;
	ValaBlock* _tmp212_;
	ValaSemanticAnalyzer* _tmp249_;
	ValaSemanticAnalyzer* _tmp250_;
	ValaSymbol* _tmp251_;
	gboolean _tmp252_;
	gboolean _tmp253_;
	self = (ValaPropertyAccessor*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_property_accessor_get_value_type (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp6_ = vala_code_context_get_analyzer (context);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_semantic_analyzer_get_current_symbol (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _vala_code_node_ref0 (_tmp9_);
	old_symbol = _tmp10_;
	_tmp11_ = vala_code_context_get_analyzer (context);
	_tmp12_ = _tmp11_;
	vala_semantic_analyzer_set_current_symbol (_tmp12_, (ValaSymbol*) self);
	_tmp14_ = self->priv->_writable;
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		gboolean _tmp15_;
		_tmp15_ = self->priv->_construction;
		_tmp13_ = _tmp15_;
	}
	if (_tmp13_) {
		ValaDataType* _tmp16_;
		ValaDataType* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaParameter* _tmp20_;
		ValaParameter* _tmp21_;
		_tmp16_ = vala_property_accessor_get_value_type (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_parameter_new ("value", _tmp17_, _tmp19_);
		_tmp21_ = _tmp20_;
		vala_property_accessor_set_value_parameter (self, _tmp21_);
		_vala_code_node_unref0 (_tmp21_);
	}
	_tmp23_ = self->priv->_readable;
	if (_tmp23_) {
		ValaProperty* _tmp24_;
		ValaProperty* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaSemanticAnalyzer* _tmp28_;
		ValaSemanticAnalyzer* _tmp29_;
		ValaClass* _tmp30_;
		_tmp24_ = vala_property_accessor_get_prop (self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_code_context_get_analyzer (context);
		_tmp29_ = _tmp28_;
		_tmp30_ = _tmp29_->object_type;
		_tmp22_ = vala_typesymbol_is_subtype_of (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol), (ValaTypeSymbol*) _tmp30_);
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		ValaProperty* _tmp31_;
		ValaProperty* _tmp32_;
		ValaAttribute* _tmp33_;
		_tmp31_ = vala_property_accessor_get_prop (self);
		_tmp32_ = _tmp31_;
		_tmp33_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp32_, "NoAccessorMethod");
		if (_tmp33_ != NULL) {
			ValaDataType* _tmp34_;
			ValaDataType* _tmp35_;
			_tmp34_ = vala_property_accessor_get_value_type (self);
			_tmp35_ = _tmp34_;
			if (vala_data_type_is_real_struct_type (_tmp35_)) {
				gboolean _tmp36_ = FALSE;
				ValaSourceReference* _tmp37_;
				ValaSourceReference* _tmp38_;
				_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp38_ = _tmp37_;
				if (_tmp38_ == NULL) {
					_tmp36_ = TRUE;
				} else {
					ValaSourceReference* _tmp39_;
					ValaSourceReference* _tmp40_;
					ValaSourceFile* _tmp41_;
					ValaSourceFile* _tmp42_;
					_tmp39_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp40_ = _tmp39_;
					_tmp41_ = vala_source_reference_get_file (_tmp40_);
					_tmp42_ = _tmp41_;
					_tmp36_ = _tmp42_ == NULL;
				}
				if (_tmp36_) {
				} else {
					gboolean _tmp43_ = FALSE;
					ValaDataType* _tmp44_;
					ValaDataType* _tmp45_;
					gboolean _tmp46_;
					gboolean _tmp47_;
					_tmp44_ = vala_property_accessor_get_value_type (self);
					_tmp45_ = _tmp44_;
					_tmp46_ = vala_data_type_get_value_owned (_tmp45_);
					_tmp47_ = _tmp46_;
					if (!_tmp47_) {
						ValaSourceReference* _tmp48_;
						ValaSourceReference* _tmp49_;
						ValaSourceFile* _tmp50_;
						ValaSourceFile* _tmp51_;
						ValaSourceFileType _tmp52_;
						ValaSourceFileType _tmp53_;
						_tmp48_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp49_ = _tmp48_;
						_tmp50_ = vala_source_reference_get_file (_tmp49_);
						_tmp51_ = _tmp50_;
						_tmp52_ = vala_source_file_get_file_type (_tmp51_);
						_tmp53_ = _tmp52_;
						_tmp43_ = _tmp53_ == VALA_SOURCE_FILE_TYPE_SOURCE;
					} else {
						_tmp43_ = FALSE;
					}
					if (_tmp43_) {
						ValaSourceReference* _tmp54_;
						ValaSourceReference* _tmp55_;
						ValaProperty* _tmp56_;
						ValaProperty* _tmp57_;
						gchar* _tmp58_;
						gchar* _tmp59_;
						gchar* _tmp60_;
						gchar* _tmp61_;
						_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp55_ = _tmp54_;
						_tmp56_ = vala_property_accessor_get_prop (self);
						_tmp57_ = _tmp56_;
						_tmp58_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp57_);
						_tmp59_ = _tmp58_;
						_tmp60_ = g_strdup_printf ("unowned return value for getter of property `%s' not supported without" \
" accessor", _tmp59_);
						_tmp61_ = _tmp60_;
						vala_report_error (_tmp55_, _tmp61_);
						_g_free0 (_tmp61_);
						_g_free0 (_tmp59_);
					}
				}
			} else {
				gboolean _tmp62_ = FALSE;
				ValaDataType* _tmp63_;
				ValaDataType* _tmp64_;
				gboolean _tmp65_;
				gboolean _tmp66_;
				_tmp63_ = vala_property_accessor_get_value_type (self);
				_tmp64_ = _tmp63_;
				_tmp65_ = vala_data_type_get_value_owned (_tmp64_);
				_tmp66_ = _tmp65_;
				if (_tmp66_) {
					gboolean _tmp67_ = FALSE;
					ValaSourceReference* _tmp68_;
					ValaSourceReference* _tmp69_;
					_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp69_ = _tmp68_;
					if (_tmp69_ == NULL) {
						_tmp67_ = TRUE;
					} else {
						ValaSourceReference* _tmp70_;
						ValaSourceReference* _tmp71_;
						ValaSourceFile* _tmp72_;
						ValaSourceFile* _tmp73_;
						_tmp70_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp71_ = _tmp70_;
						_tmp72_ = vala_source_reference_get_file (_tmp71_);
						_tmp73_ = _tmp72_;
						_tmp67_ = _tmp73_ == NULL;
					}
					_tmp62_ = _tmp67_;
				} else {
					_tmp62_ = FALSE;
				}
				if (_tmp62_) {
					gboolean _tmp74_ = FALSE;
					gboolean _tmp75_ = FALSE;
					ValaDataType* _tmp76_;
					ValaDataType* _tmp77_;
					_tmp76_ = vala_property_accessor_get_value_type (self);
					_tmp77_ = _tmp76_;
					if (VALA_IS_DELEGATE_TYPE (_tmp77_)) {
						_tmp75_ = TRUE;
					} else {
						ValaDataType* _tmp78_;
						ValaDataType* _tmp79_;
						_tmp78_ = vala_property_accessor_get_value_type (self);
						_tmp79_ = _tmp78_;
						_tmp75_ = VALA_IS_POINTER_TYPE (_tmp79_);
					}
					if (_tmp75_) {
						_tmp74_ = TRUE;
					} else {
						gboolean _tmp80_ = FALSE;
						ValaDataType* _tmp81_;
						ValaDataType* _tmp82_;
						_tmp81_ = vala_property_accessor_get_value_type (self);
						_tmp82_ = _tmp81_;
						if (VALA_IS_VALUE_TYPE (_tmp82_)) {
							ValaDataType* _tmp83_;
							ValaDataType* _tmp84_;
							gboolean _tmp85_;
							gboolean _tmp86_;
							_tmp83_ = vala_property_accessor_get_value_type (self);
							_tmp84_ = _tmp83_;
							_tmp85_ = vala_data_type_get_nullable (_tmp84_);
							_tmp86_ = _tmp85_;
							_tmp80_ = !_tmp86_;
						} else {
							_tmp80_ = FALSE;
						}
						_tmp74_ = _tmp80_;
					}
					if (_tmp74_) {
						ValaDataType* _tmp87_;
						ValaDataType* _tmp88_;
						_tmp87_ = vala_property_accessor_get_value_type (self);
						_tmp88_ = _tmp87_;
						vala_data_type_set_value_owned (_tmp88_, FALSE);
					}
				}
			}
		}
	}
	_tmp89_ = vala_property_accessor_get_prop (self);
	_tmp90_ = _tmp89_;
	_tmp91_ = vala_symbol_get_source_type ((ValaSymbol*) _tmp90_);
	_tmp92_ = _tmp91_;
	if (_tmp92_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		gboolean _tmp93_ = FALSE;
		gboolean _tmp94_ = FALSE;
		ValaBlock* _tmp95_;
		ValaBlock* _tmp96_;
		_tmp95_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp96_ = _tmp95_;
		if (_tmp96_ == NULL) {
			ValaProperty* _tmp97_;
			ValaProperty* _tmp98_;
			gboolean _tmp99_;
			gboolean _tmp100_;
			_tmp97_ = vala_property_accessor_get_prop (self);
			_tmp98_ = _tmp97_;
			_tmp99_ = vala_property_get_interface_only (_tmp98_);
			_tmp100_ = _tmp99_;
			_tmp94_ = !_tmp100_;
		} else {
			_tmp94_ = FALSE;
		}
		if (_tmp94_) {
			ValaProperty* _tmp101_;
			ValaProperty* _tmp102_;
			gboolean _tmp103_;
			gboolean _tmp104_;
			_tmp101_ = vala_property_accessor_get_prop (self);
			_tmp102_ = _tmp101_;
			_tmp103_ = vala_property_get_is_abstract (_tmp102_);
			_tmp104_ = _tmp103_;
			_tmp93_ = !_tmp104_;
		} else {
			_tmp93_ = FALSE;
		}
		if (_tmp93_) {
			ValaSourceReference* _tmp105_;
			ValaSourceReference* _tmp106_;
			ValaBlock* _tmp107_;
			ValaBlock* _tmp108_;
			ValaMemberAccess* ma = NULL;
			ValaProperty* _tmp109_;
			ValaProperty* _tmp110_;
			const gchar* _tmp111_;
			const gchar* _tmp112_;
			gchar* _tmp113_;
			gchar* _tmp114_;
			ValaSourceReference* _tmp115_;
			ValaSourceReference* _tmp116_;
			ValaMemberAccess* _tmp117_;
			ValaMemberAccess* _tmp118_;
			gboolean _tmp119_;
			vala_property_accessor_set_automatic_body (self, TRUE);
			_tmp105_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp106_ = _tmp105_;
			_tmp107_ = vala_block_new (_tmp106_);
			_tmp108_ = _tmp107_;
			vala_subroutine_set_body ((ValaSubroutine*) self, _tmp108_);
			_vala_code_node_unref0 (_tmp108_);
			_tmp109_ = vala_property_accessor_get_prop (self);
			_tmp110_ = _tmp109_;
			_tmp111_ = vala_symbol_get_name ((ValaSymbol*) _tmp110_);
			_tmp112_ = _tmp111_;
			_tmp113_ = g_strdup_printf ("_%s", _tmp112_);
			_tmp114_ = _tmp113_;
			_tmp115_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp116_ = _tmp115_;
			_tmp117_ = vala_member_access_new_simple (_tmp114_, _tmp116_);
			_tmp118_ = _tmp117_;
			_g_free0 (_tmp114_);
			ma = _tmp118_;
			_tmp119_ = self->priv->_readable;
			if (_tmp119_) {
				ValaBlock* _tmp120_;
				ValaBlock* _tmp121_;
				ValaMemberAccess* _tmp122_;
				ValaSourceReference* _tmp123_;
				ValaSourceReference* _tmp124_;
				ValaReturnStatement* _tmp125_;
				ValaReturnStatement* _tmp126_;
				_tmp120_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp121_ = _tmp120_;
				_tmp122_ = ma;
				_tmp123_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp124_ = _tmp123_;
				_tmp125_ = vala_return_statement_new ((ValaExpression*) _tmp122_, _tmp124_);
				_tmp126_ = _tmp125_;
				vala_block_add_statement (_tmp121_, (ValaStatement*) _tmp126_);
				_vala_code_node_unref0 (_tmp126_);
			} else {
				ValaExpression* value = NULL;
				ValaSourceReference* _tmp127_;
				ValaSourceReference* _tmp128_;
				ValaMemberAccess* _tmp129_;
				ValaDataType* _tmp130_;
				ValaDataType* _tmp131_;
				gboolean _tmp132_;
				gboolean _tmp133_;
				ValaAssignment* assignment = NULL;
				ValaMemberAccess* _tmp138_;
				ValaExpression* _tmp139_;
				ValaSourceReference* _tmp140_;
				ValaSourceReference* _tmp141_;
				ValaAssignment* _tmp142_;
				ValaBlock* _tmp143_;
				ValaBlock* _tmp144_;
				ValaAssignment* _tmp145_;
				ValaExpressionStatement* _tmp146_;
				ValaExpressionStatement* _tmp147_;
				_tmp127_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp128_ = _tmp127_;
				_tmp129_ = vala_member_access_new_simple ("value", _tmp128_);
				value = (ValaExpression*) _tmp129_;
				_tmp130_ = vala_property_accessor_get_value_type (self);
				_tmp131_ = _tmp130_;
				_tmp132_ = vala_data_type_get_value_owned (_tmp131_);
				_tmp133_ = _tmp132_;
				if (_tmp133_) {
					ValaExpression* _tmp134_;
					ValaSourceReference* _tmp135_;
					ValaSourceReference* _tmp136_;
					ValaReferenceTransferExpression* _tmp137_;
					_tmp134_ = value;
					_tmp135_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp136_ = _tmp135_;
					_tmp137_ = vala_reference_transfer_expression_new (_tmp134_, _tmp136_);
					_vala_code_node_unref0 (value);
					value = (ValaExpression*) _tmp137_;
				}
				_tmp138_ = ma;
				_tmp139_ = value;
				_tmp140_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp141_ = _tmp140_;
				_tmp142_ = vala_assignment_new ((ValaExpression*) _tmp138_, _tmp139_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp141_);
				assignment = _tmp142_;
				_tmp143_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp144_ = _tmp143_;
				_tmp145_ = assignment;
				_tmp146_ = vala_expression_statement_new ((ValaExpression*) _tmp145_, NULL);
				_tmp147_ = _tmp146_;
				vala_block_add_statement (_tmp144_, (ValaStatement*) _tmp147_);
				_vala_code_node_unref0 (_tmp147_);
				_vala_code_node_unref0 (assignment);
				_vala_code_node_unref0 (value);
			}
			_vala_code_node_unref0 (ma);
		}
	}
	_tmp151_ = vala_property_accessor_get_prop (self);
	_tmp152_ = _tmp151_;
	_tmp153_ = vala_property_get_is_abstract (_tmp152_);
	_tmp154_ = _tmp153_;
	if (_tmp154_) {
		_tmp150_ = TRUE;
	} else {
		ValaProperty* _tmp155_;
		ValaProperty* _tmp156_;
		gboolean _tmp157_;
		gboolean _tmp158_;
		_tmp155_ = vala_property_accessor_get_prop (self);
		_tmp156_ = _tmp155_;
		_tmp157_ = vala_property_get_is_virtual (_tmp156_);
		_tmp158_ = _tmp157_;
		_tmp150_ = _tmp158_;
	}
	if (_tmp150_) {
		_tmp149_ = TRUE;
	} else {
		ValaProperty* _tmp159_;
		ValaProperty* _tmp160_;
		gboolean _tmp161_;
		gboolean _tmp162_;
		_tmp159_ = vala_property_accessor_get_prop (self);
		_tmp160_ = _tmp159_;
		_tmp161_ = vala_property_get_overrides (_tmp160_);
		_tmp162_ = _tmp161_;
		_tmp149_ = _tmp162_;
	}
	if (_tmp149_) {
		ValaSymbolAccessibility _tmp163_;
		ValaSymbolAccessibility _tmp164_;
		_tmp163_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp164_ = _tmp163_;
		_tmp148_ = _tmp164_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
	} else {
		_tmp148_ = FALSE;
	}
	if (_tmp148_) {
		ValaSourceReference* _tmp165_;
		ValaSourceReference* _tmp166_;
		ValaProperty* _tmp167_;
		ValaProperty* _tmp168_;
		gchar* _tmp169_;
		gchar* _tmp170_;
		gchar* _tmp171_;
		gchar* _tmp172_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp165_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp166_ = _tmp165_;
		_tmp167_ = vala_property_accessor_get_prop (self);
		_tmp168_ = _tmp167_;
		_tmp169_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp168_);
		_tmp170_ = _tmp169_;
		_tmp171_ = g_strdup_printf ("Property `%s' with private accessor cannot be marked as abstract, virt" \
"ual or override", _tmp170_);
		_tmp172_ = _tmp171_;
		vala_report_error (_tmp166_, _tmp172_);
		_g_free0 (_tmp172_);
		_g_free0 (_tmp170_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		return result;
	}
	_tmp174_ = self->priv->_construction;
	if (_tmp174_) {
		ValaProperty* _tmp175_;
		ValaProperty* _tmp176_;
		ValaSymbol* _tmp177_;
		ValaSymbol* _tmp178_;
		ValaSemanticAnalyzer* _tmp179_;
		ValaSemanticAnalyzer* _tmp180_;
		ValaClass* _tmp181_;
		_tmp175_ = vala_property_accessor_get_prop (self);
		_tmp176_ = _tmp175_;
		_tmp177_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp176_);
		_tmp178_ = _tmp177_;
		_tmp179_ = vala_code_context_get_analyzer (context);
		_tmp180_ = _tmp179_;
		_tmp181_ = _tmp180_->object_type;
		_tmp173_ = !vala_typesymbol_is_subtype_of (G_TYPE_CHECK_INSTANCE_CAST (_tmp178_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol), (ValaTypeSymbol*) _tmp181_);
	} else {
		_tmp173_ = FALSE;
	}
	if (_tmp173_) {
		ValaSourceReference* _tmp182_;
		ValaSourceReference* _tmp183_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp182_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp183_ = _tmp182_;
		vala_report_error (_tmp183_, "construct properties require `GLib.Object'");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		return result;
	} else {
		gboolean _tmp184_ = FALSE;
		gboolean _tmp185_;
		_tmp185_ = self->priv->_construction;
		if (_tmp185_) {
			ValaSemanticAnalyzer* _tmp186_;
			ValaSemanticAnalyzer* _tmp187_;
			ValaProperty* _tmp188_;
			ValaProperty* _tmp189_;
			_tmp186_ = vala_code_context_get_analyzer (context);
			_tmp187_ = _tmp186_;
			_tmp188_ = vala_property_accessor_get_prop (self);
			_tmp189_ = _tmp188_;
			_tmp184_ = !vala_semantic_analyzer_is_gobject_property (_tmp187_, _tmp189_);
		} else {
			_tmp184_ = FALSE;
		}
		if (_tmp184_) {
			gboolean _tmp190_;
			gboolean _tmp191_;
			_tmp190_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp191_ = _tmp190_;
			if (_tmp191_) {
				ValaSourceReference* _tmp192_;
				ValaSourceReference* _tmp193_;
				_tmp192_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp193_ = _tmp192_;
				vala_report_warning (_tmp193_, "construct properties not supported for specified property type");
			} else {
				ValaSourceReference* _tmp194_;
				ValaSourceReference* _tmp195_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp194_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp195_ = _tmp194_;
				vala_report_error (_tmp195_, "construct properties not supported for specified property type");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				return result;
			}
		}
	}
	_tmp197_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp198_ = _tmp197_;
	if (_tmp198_ != NULL) {
		ValaProperty* _tmp199_;
		ValaProperty* _tmp200_;
		gboolean _tmp201_;
		gboolean _tmp202_;
		_tmp199_ = vala_property_accessor_get_prop (self);
		_tmp200_ = _tmp199_;
		_tmp201_ = vala_property_get_is_abstract (_tmp200_);
		_tmp202_ = _tmp201_;
		_tmp196_ = _tmp202_;
	} else {
		_tmp196_ = FALSE;
	}
	if (_tmp196_) {
		ValaSourceReference* _tmp203_;
		ValaSourceReference* _tmp204_;
		ValaProperty* _tmp205_;
		ValaProperty* _tmp206_;
		gchar* _tmp207_;
		gchar* _tmp208_;
		gchar* _tmp209_;
		gchar* _tmp210_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp203_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp204_ = _tmp203_;
		_tmp205_ = vala_property_accessor_get_prop (self);
		_tmp206_ = _tmp205_;
		_tmp207_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp206_);
		_tmp208_ = _tmp207_;
		_tmp209_ = g_strdup_printf ("Accessor of abstract property `%s' cannot have body", _tmp208_);
		_tmp210_ = _tmp209_;
		vala_report_error (_tmp204_, _tmp210_);
		_g_free0 (_tmp210_);
		_g_free0 (_tmp208_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		return result;
	}
	_tmp211_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp212_ = _tmp211_;
	if (_tmp212_ != NULL) {
		gboolean _tmp213_ = FALSE;
		gboolean _tmp214_;
		ValaBlock* _tmp224_;
		ValaBlock* _tmp225_;
		ValaArrayList* error_types = NULL;
		GEqualFunc _tmp226_;
		ValaArrayList* _tmp227_;
		ValaBlock* _tmp228_;
		ValaBlock* _tmp229_;
		ValaArrayList* _tmp230_;
		_tmp214_ = self->priv->_writable;
		if (_tmp214_) {
			_tmp213_ = TRUE;
		} else {
			gboolean _tmp215_;
			_tmp215_ = self->priv->_construction;
			_tmp213_ = _tmp215_;
		}
		if (_tmp213_) {
			ValaBlock* _tmp216_;
			ValaBlock* _tmp217_;
			ValaScope* _tmp218_;
			ValaScope* _tmp219_;
			ValaParameter* _tmp220_;
			const gchar* _tmp221_;
			const gchar* _tmp222_;
			ValaParameter* _tmp223_;
			_tmp216_ = vala_subroutine_get_body ((ValaSubroutine*) self);
			_tmp217_ = _tmp216_;
			_tmp218_ = vala_symbol_get_scope ((ValaSymbol*) _tmp217_);
			_tmp219_ = _tmp218_;
			_tmp220_ = self->priv->_value_parameter;
			_tmp221_ = vala_symbol_get_name ((ValaSymbol*) _tmp220_);
			_tmp222_ = _tmp221_;
			_tmp223_ = self->priv->_value_parameter;
			vala_scope_add (_tmp219_, _tmp222_, (ValaSymbol*) _tmp223_);
		}
		_tmp224_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp225_ = _tmp224_;
		vala_code_node_check ((ValaCodeNode*) _tmp225_, context);
		_tmp226_ = g_direct_equal;
		_tmp227_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp226_);
		error_types = _tmp227_;
		_tmp228_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp229_ = _tmp228_;
		_tmp230_ = error_types;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp229_, (ValaCollection*) _tmp230_, NULL);
		{
			ValaArrayList* _body_error_type_list = NULL;
			ValaArrayList* _tmp231_;
			ValaArrayList* _tmp232_;
			gint _body_error_type_size = 0;
			ValaArrayList* _tmp233_;
			gint _tmp234_;
			gint _tmp235_;
			gint _body_error_type_index = 0;
			_tmp231_ = error_types;
			_tmp232_ = _vala_iterable_ref0 (_tmp231_);
			_body_error_type_list = _tmp232_;
			_tmp233_ = _body_error_type_list;
			_tmp234_ = vala_collection_get_size ((ValaCollection*) _tmp233_);
			_tmp235_ = _tmp234_;
			_body_error_type_size = _tmp235_;
			_body_error_type_index = -1;
			while (TRUE) {
				ValaDataType* body_error_type = NULL;
				ValaArrayList* _tmp236_;
				gpointer _tmp237_;
				ValaDataType* _tmp238_;
				gboolean _tmp239_;
				gboolean _tmp240_;
				_body_error_type_index = _body_error_type_index + 1;
				if (!(_body_error_type_index < _body_error_type_size)) {
					break;
				}
				_tmp236_ = _body_error_type_list;
				_tmp237_ = vala_list_get ((ValaList*) _tmp236_, _body_error_type_index);
				body_error_type = (ValaDataType*) _tmp237_;
				_tmp238_ = body_error_type;
				_tmp239_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp238_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
				_tmp240_ = _tmp239_;
				if (!_tmp240_) {
					ValaDataType* _tmp241_;
					ValaSourceReference* _tmp242_;
					ValaSourceReference* _tmp243_;
					ValaDataType* _tmp244_;
					gchar* _tmp245_;
					gchar* _tmp246_;
					gchar* _tmp247_;
					gchar* _tmp248_;
					_tmp241_ = body_error_type;
					_tmp242_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp241_);
					_tmp243_ = _tmp242_;
					_tmp244_ = body_error_type;
					_tmp245_ = vala_code_node_to_string ((ValaCodeNode*) _tmp244_);
					_tmp246_ = _tmp245_;
					_tmp247_ = g_strdup_printf ("unhandled error `%s'", _tmp246_);
					_tmp248_ = _tmp247_;
					vala_report_warning (_tmp243_, _tmp248_);
					_g_free0 (_tmp248_);
					_g_free0 (_tmp246_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
		_vala_iterable_unref0 (error_types);
	}
	_tmp249_ = vala_code_context_get_analyzer (context);
	_tmp250_ = _tmp249_;
	_tmp251_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp250_, _tmp251_);
	_tmp252_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp253_ = _tmp252_;
	result = !_tmp253_;
	_vala_code_node_unref0 (old_symbol);
	return result;
}

static void
vala_property_accessor_real_replace_type (ValaCodeNode* base,
                                          ValaDataType* old_type,
                                          ValaDataType* new_type)
{
	ValaPropertyAccessor * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaPropertyAccessor*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_property_accessor_get_value_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_property_accessor_set_value_type (self, new_type);
	}
}

ValaProperty*
vala_property_accessor_get_prop (ValaPropertyAccessor* self)
{
	ValaProperty* result;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	result = VALA_IS_PROPERTY (_tmp1_) ? ((ValaProperty*) _tmp1_) : NULL;
	return result;
}

ValaDataType*
vala_property_accessor_get_value_type (ValaPropertyAccessor* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value_type;
	result = _tmp0_;
	return result;
}

static void
vala_property_accessor_set_value_type (ValaPropertyAccessor* self,
                                       ValaDataType* value)
{
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_value_type);
	self->priv->_value_type = _tmp0_;
	if (value != NULL) {
		ValaDataType* _tmp1_;
		_tmp1_ = self->priv->_value_type;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
	}
}

gboolean
vala_property_accessor_get_readable (ValaPropertyAccessor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_readable;
	return result;
}

static void
vala_property_accessor_set_readable (ValaPropertyAccessor* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_readable = value;
}

gboolean
vala_property_accessor_get_writable (ValaPropertyAccessor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_writable;
	return result;
}

static void
vala_property_accessor_set_writable (ValaPropertyAccessor* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_writable = value;
}

gboolean
vala_property_accessor_get_construction (ValaPropertyAccessor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_construction;
	return result;
}

static void
vala_property_accessor_set_construction (ValaPropertyAccessor* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_construction = value;
}

gboolean
vala_property_accessor_get_automatic_body (ValaPropertyAccessor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_automatic_body;
	return result;
}

static void
vala_property_accessor_set_automatic_body (ValaPropertyAccessor* self,
                                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_automatic_body = value;
}

static gboolean
vala_property_accessor_real_get_has_result (ValaSubroutine* base)
{
	gboolean result;
	ValaPropertyAccessor* self;
	gboolean _tmp0_;
	self = (ValaPropertyAccessor*) base;
	_tmp0_ = self->priv->_readable;
	result = _tmp0_;
	return result;
}

ValaParameter*
vala_property_accessor_get_value_parameter (ValaPropertyAccessor* self)
{
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value_parameter;
	result = _tmp0_;
	return result;
}

static void
vala_property_accessor_set_value_parameter (ValaPropertyAccessor* self,
                                            ValaParameter* value)
{
	ValaParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_value_parameter);
	self->priv->_value_parameter = _tmp0_;
}

static void
vala_property_accessor_class_init (ValaPropertyAccessorClass * klass,
                                   gpointer klass_data)
{
	vala_property_accessor_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_property_accessor_finalize;
	g_type_class_adjust_private_offset (klass, &ValaPropertyAccessor_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_property_accessor_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_property_accessor_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_property_accessor_real_check;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_property_accessor_real_replace_type;
	VALA_SUBROUTINE_CLASS (klass)->get_has_result = vala_property_accessor_real_get_has_result;
}

static void
vala_property_accessor_instance_init (ValaPropertyAccessor * self,
                                      gpointer klass)
{
	self->priv = vala_property_accessor_get_instance_private (self);
}

static void
vala_property_accessor_finalize (ValaCodeNode * obj)
{
	ValaPropertyAccessor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor);
	_vala_code_node_unref0 (self->priv->_value_parameter);
	_vala_code_node_unref0 (self->priv->_value_type);
	VALA_CODE_NODE_CLASS (vala_property_accessor_parent_class)->finalize (obj);
}

/**
 * Represents a get or set accessor of a property in the source code.
 */
GType
vala_property_accessor_get_type (void)
{
	static volatile gsize vala_property_accessor_type_id__volatile = 0;
	if (g_once_init_enter (&vala_property_accessor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaPropertyAccessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_property_accessor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaPropertyAccessor), 0, (GInstanceInitFunc) vala_property_accessor_instance_init, NULL };
		GType vala_property_accessor_type_id;
		vala_property_accessor_type_id = g_type_register_static (VALA_TYPE_SUBROUTINE, "ValaPropertyAccessor", &g_define_type_info, 0);
		ValaPropertyAccessor_private_offset = g_type_add_instance_private (vala_property_accessor_type_id, sizeof (ValaPropertyAccessorPrivate));
		g_once_init_leave (&vala_property_accessor_type_id__volatile, vala_property_accessor_type_id);
	}
	return vala_property_accessor_type_id__volatile;
}

