/* arrayqueue.c generated by valac 0.15.0.90-e9553, the Vala compiler
 * generated from arrayqueue.vala, do not modify */

/* arrayqueue.vala
 *
 * Copyright (C) 2012  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>


#define GEE_TYPE_TRAVERSABLE (gee_traversable_get_type ())
#define GEE_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversable))
#define GEE_IS_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TRAVERSABLE))
#define GEE_TRAVERSABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversableIface))

typedef struct _GeeTraversable GeeTraversable;
typedef struct _GeeTraversableIface GeeTraversableIface;

#define GEE_TRAVERSABLE_TYPE_STREAM (gee_traversable_stream_get_type ())

#define GEE_TYPE_LAZY (gee_lazy_get_type ())
#define GEE_LAZY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LAZY, GeeLazy))
#define GEE_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LAZY, GeeLazyClass))
#define GEE_IS_LAZY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LAZY))
#define GEE_IS_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LAZY))
#define GEE_LAZY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LAZY, GeeLazyClass))

typedef struct _GeeLazy GeeLazy;
typedef struct _GeeLazyClass GeeLazyClass;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;

#define GEE_TYPE_QUEUE (gee_queue_get_type ())
#define GEE_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_QUEUE, GeeQueue))
#define GEE_IS_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_QUEUE))
#define GEE_QUEUE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_QUEUE, GeeQueueIface))

typedef struct _GeeQueue GeeQueue;
typedef struct _GeeQueueIface GeeQueueIface;

#define GEE_TYPE_ABSTRACT_QUEUE (gee_abstract_queue_get_type ())
#define GEE_ABSTRACT_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_QUEUE, GeeAbstractQueue))
#define GEE_ABSTRACT_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_QUEUE, GeeAbstractQueueClass))
#define GEE_IS_ABSTRACT_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_QUEUE))
#define GEE_IS_ABSTRACT_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_QUEUE))
#define GEE_ABSTRACT_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_QUEUE, GeeAbstractQueueClass))

typedef struct _GeeAbstractQueue GeeAbstractQueue;
typedef struct _GeeAbstractQueueClass GeeAbstractQueueClass;
typedef struct _GeeAbstractQueuePrivate GeeAbstractQueuePrivate;

#define GEE_TYPE_DEQUE (gee_deque_get_type ())
#define GEE_DEQUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_DEQUE, GeeDeque))
#define GEE_IS_DEQUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_DEQUE))
#define GEE_DEQUE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_DEQUE, GeeDequeIface))

typedef struct _GeeDeque GeeDeque;
typedef struct _GeeDequeIface GeeDequeIface;

#define GEE_TYPE_ARRAY_QUEUE (gee_array_queue_get_type ())
#define GEE_ARRAY_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ARRAY_QUEUE, GeeArrayQueue))
#define GEE_ARRAY_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ARRAY_QUEUE, GeeArrayQueueClass))
#define GEE_IS_ARRAY_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ARRAY_QUEUE))
#define GEE_IS_ARRAY_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ARRAY_QUEUE))
#define GEE_ARRAY_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ARRAY_QUEUE, GeeArrayQueueClass))

typedef struct _GeeArrayQueue GeeArrayQueue;
typedef struct _GeeArrayQueueClass GeeArrayQueueClass;
typedef struct _GeeArrayQueuePrivate GeeArrayQueuePrivate;

#define GEE_ARRAY_QUEUE_TYPE_ITERATOR (gee_array_queue_iterator_get_type ())
#define GEE_ARRAY_QUEUE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_ARRAY_QUEUE_TYPE_ITERATOR, GeeArrayQueueIterator))
#define GEE_ARRAY_QUEUE_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_ARRAY_QUEUE_TYPE_ITERATOR, GeeArrayQueueIteratorClass))
#define GEE_ARRAY_QUEUE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_ARRAY_QUEUE_TYPE_ITERATOR))
#define GEE_ARRAY_QUEUE_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_ARRAY_QUEUE_TYPE_ITERATOR))
#define GEE_ARRAY_QUEUE_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_ARRAY_QUEUE_TYPE_ITERATOR, GeeArrayQueueIteratorClass))

typedef struct _GeeArrayQueueIterator GeeArrayQueueIterator;
typedef struct _GeeArrayQueueIteratorClass GeeArrayQueueIteratorClass;
typedef struct _GeeArrayQueueIteratorPrivate GeeArrayQueueIteratorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

typedef void (*GeeForallFunc) (gpointer g, void* user_data);
typedef enum  {
	GEE_TRAVERSABLE_STREAM_YIELD,
	GEE_TRAVERSABLE_STREAM_CONTINUE,
	GEE_TRAVERSABLE_STREAM_END
} GeeTraversableStream;

typedef GeeTraversableStream (*GeeStreamFunc) (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, void* user_data);
struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
	gboolean (*get_valid) (GeeIterator* self);
	gboolean (*get_read_only) (GeeIterator* self);
};

typedef gpointer (*GeeFoldFunc) (gpointer g, gpointer a, void* user_data);
typedef gpointer (*GeeMapFunc) (gpointer g, void* user_data);
typedef gboolean (*GeePredicate) (gconstpointer g, void* user_data);
struct _GeeTraversableIface {
	GTypeInterface parent_iface;
	void (*foreach) (GeeTraversable* self, GeeForallFunc f, void* f_target);
	GeeIterator* (*stream) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	gpointer (*fold) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target);
	GeeIterator* (*scan) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*filter) (GeeTraversable* self, GeePredicate f, void* f_target, GDestroyNotify f_target_destroy_notify);
	GeeIterator* (*chop) (GeeTraversable* self, gint offset, gint length);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	gboolean (*get_read_only) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	gpointer* (*to_array) (GeeAbstractCollection* self, int* result_length1);
	gboolean (*add_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeAbstractCollection* self, GeeCollection* collection);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	void (*foreach) (GeeAbstractCollection* self, GeeForallFunc f, void* f_target);
	GeeIterator* (*stream) (GeeAbstractCollection* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	GeeIterator* (*filter) (GeeAbstractCollection* self, GeePredicate f, void* f_target, GDestroyNotify f_target_destroy_notify);
	GeeIterator* (*chop) (GeeAbstractCollection* self, gint offset, gint length);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_is_empty) (GeeAbstractCollection* self);
	gboolean (*get_read_only) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeQueueIface {
	GTypeInterface parent_iface;
	gboolean (*offer) (GeeQueue* self, gconstpointer element);
	gpointer (*peek) (GeeQueue* self);
	gpointer (*poll) (GeeQueue* self);
	gint (*drain) (GeeQueue* self, GeeCollection* recipient, gint amount);
	gint (*get_capacity) (GeeQueue* self);
	gint (*get_remaining_capacity) (GeeQueue* self);
	gboolean (*get_is_full) (GeeQueue* self);
};

struct _GeeAbstractQueue {
	GeeAbstractCollection parent_instance;
	GeeAbstractQueuePrivate * priv;
};

struct _GeeAbstractQueueClass {
	GeeAbstractCollectionClass parent_class;
	gboolean (*offer) (GeeAbstractQueue* self, gconstpointer element);
	gpointer (*peek) (GeeAbstractQueue* self);
	gpointer (*poll) (GeeAbstractQueue* self);
	gint (*drain) (GeeAbstractQueue* self, GeeCollection* recipient, gint amount);
	gint (*get_capacity) (GeeAbstractQueue* self);
	gint (*get_remaining_capacity) (GeeAbstractQueue* self);
	gboolean (*get_is_full) (GeeAbstractQueue* self);
};

struct _GeeDequeIface {
	GTypeInterface parent_iface;
	gboolean (*offer_head) (GeeDeque* self, gconstpointer element);
	gpointer (*peek_head) (GeeDeque* self);
	gpointer (*poll_head) (GeeDeque* self);
	gint (*drain_head) (GeeDeque* self, GeeCollection* recipient, gint amount);
	gboolean (*offer_tail) (GeeDeque* self, gconstpointer element);
	gpointer (*peek_tail) (GeeDeque* self);
	gpointer (*poll_tail) (GeeDeque* self);
	gint (*drain_tail) (GeeDeque* self, GeeCollection* recipient, gint amount);
};

struct _GeeArrayQueue {
	GeeAbstractQueue parent_instance;
	GeeArrayQueuePrivate * priv;
};

struct _GeeArrayQueueClass {
	GeeAbstractQueueClass parent_class;
};

typedef gboolean (*GeeEqualDataFunc) (void* a, void* b, void* user_data);
struct _GeeArrayQueuePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeEqualDataFunc _equal_func;
	gpointer _equal_func_target;
	GDestroyNotify _equal_func_target_destroy_notify;
	gpointer* _items;
	gint _items_length1;
	gint __items_size_;
	gint _start;
	gint _length;
	gint _stamp;
};

struct _GeeArrayQueueIterator {
	GObject parent_instance;
	GeeArrayQueueIteratorPrivate * priv;
};

struct _GeeArrayQueueIteratorClass {
	GObjectClass parent_class;
};

struct _GeeArrayQueueIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeArrayQueue* _queue;
	gint _stamp;
	gint _offset;
	gboolean _removed;
};


static gpointer gee_array_queue_parent_class = NULL;
static gpointer gee_array_queue_iterator_parent_class = NULL;
static GeeTraversableIface* gee_array_queue_iterator_gee_traversable_parent_iface = NULL;
static GeeIteratorIface* gee_array_queue_iterator_gee_iterator_parent_iface = NULL;
static GeeDequeIface* gee_array_queue_gee_deque_parent_iface = NULL;

GType gee_traversable_stream_get_type (void) G_GNUC_CONST;
gpointer gee_lazy_ref (gpointer instance);
void gee_lazy_unref (gpointer instance);
GParamSpec* gee_param_spec_lazy (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gee_value_set_lazy (GValue* value, gpointer v_object);
void gee_value_take_lazy (GValue* value, gpointer v_object);
gpointer gee_value_get_lazy (const GValue* value);
GType gee_lazy_get_type (void) G_GNUC_CONST;
GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_traversable_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
GType gee_queue_get_type (void) G_GNUC_CONST;
GType gee_abstract_queue_get_type (void) G_GNUC_CONST;
GType gee_deque_get_type (void) G_GNUC_CONST;
GType gee_array_queue_get_type (void) G_GNUC_CONST;
#define GEE_ARRAY_QUEUE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_ARRAY_QUEUE, GeeArrayQueuePrivate))
enum  {
	GEE_ARRAY_QUEUE_DUMMY_PROPERTY,
	GEE_ARRAY_QUEUE_G_TYPE,
	GEE_ARRAY_QUEUE_G_DUP_FUNC,
	GEE_ARRAY_QUEUE_G_DESTROY_FUNC,
	GEE_ARRAY_QUEUE_SIZE,
	GEE_ARRAY_QUEUE_IS_EMPTY,
	GEE_ARRAY_QUEUE_READ_ONLY,
	GEE_ARRAY_QUEUE_CAPACITY,
	GEE_ARRAY_QUEUE_REMAINING_CAPACITY,
	GEE_ARRAY_QUEUE_IS_FULL
};
GeeArrayQueue* gee_array_queue_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify);
GeeArrayQueue* gee_array_queue_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify);
GeeAbstractQueue* gee_abstract_queue_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GeeEqualDataFunc gee_functions_get_equal_func_for (GType t, void** result_target, GDestroyNotify* result_target_destroy_notify);
static void gee_array_queue_set_equal_func (GeeArrayQueue* self, GeeEqualDataFunc value, gpointer value_target);
static GeeIterator* gee_array_queue_real_iterator (GeeAbstractCollection* base);
static GeeArrayQueueIterator* gee_array_queue_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayQueue* queue);
static GeeArrayQueueIterator* gee_array_queue_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayQueue* queue);
static GType gee_array_queue_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean gee_array_queue_real_contains (GeeAbstractCollection* base, gconstpointer item);
static gint gee_array_queue_find_index (GeeArrayQueue* self, gconstpointer item);
static gboolean gee_array_queue_real_remove (GeeAbstractCollection* base, gconstpointer item);
static void gee_array_queue_remove_at (GeeArrayQueue* self, gint index);
static void gee_array_queue_real_clear (GeeAbstractCollection* base);
static gboolean gee_array_queue_real_offer (GeeAbstractQueue* base, gconstpointer element);
gboolean gee_deque_offer_tail (GeeDeque* self, gconstpointer element);
static gpointer gee_array_queue_real_peek (GeeAbstractQueue* base);
gpointer gee_deque_peek_head (GeeDeque* self);
static gpointer gee_array_queue_real_poll (GeeAbstractQueue* base);
gpointer gee_deque_poll_head (GeeDeque* self);
static gboolean gee_array_queue_real_offer_head (GeeDeque* base, gconstpointer element);
static void gee_array_queue_grow_if_needed (GeeArrayQueue* self);
static gpointer gee_array_queue_real_peek_head (GeeDeque* base);
static gpointer gee_array_queue_real_poll_head (GeeDeque* base);
static gint gee_array_queue_real_drain_head (GeeDeque* base, GeeCollection* recipient, gint amount);
gint gee_abstract_queue_drain (GeeAbstractQueue* self, GeeCollection* recipient, gint amount);
static gboolean gee_array_queue_real_offer_tail (GeeDeque* base, gconstpointer element);
static gpointer gee_array_queue_real_peek_tail (GeeDeque* base);
static gpointer gee_array_queue_real_poll_tail (GeeDeque* base);
static gint gee_array_queue_real_drain_tail (GeeDeque* base, GeeCollection* recipient, gint amount);
gpointer gee_deque_poll_tail (GeeDeque* self);
gboolean gee_collection_add (GeeCollection* self, gconstpointer item);
GeeEqualDataFunc gee_array_queue_get_equal_func (GeeArrayQueue* self, gpointer* result_target);
#define GEE_QUEUE_UNBOUNDED_CAPACITY (-1)
#define GEE_ARRAY_QUEUE_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_ARRAY_QUEUE_TYPE_ITERATOR, GeeArrayQueueIteratorPrivate))
enum  {
	GEE_ARRAY_QUEUE_ITERATOR_DUMMY_PROPERTY,
	GEE_ARRAY_QUEUE_ITERATOR_G_TYPE,
	GEE_ARRAY_QUEUE_ITERATOR_G_DUP_FUNC,
	GEE_ARRAY_QUEUE_ITERATOR_G_DESTROY_FUNC,
	GEE_ARRAY_QUEUE_ITERATOR_VALID,
	GEE_ARRAY_QUEUE_ITERATOR_READ_ONLY
};
static gboolean gee_array_queue_iterator_real_next (GeeIterator* base);
gboolean gee_iterator_has_next (GeeIterator* self);
static gboolean gee_array_queue_iterator_real_has_next (GeeIterator* base);
static gpointer gee_array_queue_iterator_real_get (GeeIterator* base);
static void gee_array_queue_iterator_real_remove (GeeIterator* base);
static void gee_array_queue_iterator_real_foreach (GeeTraversable* base, GeeForallFunc f, void* f_target);
gboolean gee_iterator_get_valid (GeeIterator* self);
static GeeIterator* gee_array_queue_iterator_real_stream (GeeTraversable* base, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
GeeIterator* gee_iterator_stream_impl (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeIterator* _self_, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
static GeeIterator* gee_array_queue_iterator_real_filter (GeeTraversable* base, GeePredicate f, void* f_target, GDestroyNotify f_target_destroy_notify);
GeeIterator* gee_traversable_filter_impl (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTraversable* input, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify);
static GeeIterator* gee_array_queue_iterator_real_chop (GeeTraversable* base, gint offset, gint length);
GeeIterator* gee_traversable_chop_impl (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTraversable* input, gint offset, gint length);
static void gee_array_queue_iterator_finalize (GObject* obj);
gboolean gee_iterator_get_read_only (GeeIterator* self);
static void _vala_gee_array_queue_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_array_queue_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void gee_array_queue_finalize (GObject* obj);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
gboolean gee_abstract_collection_get_is_empty (GeeAbstractCollection* self);
gboolean gee_abstract_collection_get_read_only (GeeAbstractCollection* self);
gint gee_abstract_queue_get_capacity (GeeAbstractQueue* self);
gint gee_abstract_queue_get_remaining_capacity (GeeAbstractQueue* self);
gboolean gee_abstract_queue_get_is_full (GeeAbstractQueue* self);
static void _vala_gee_array_queue_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_array_queue_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_move (gpointer array, gsize element_size, gint src, gint dest, gint length);


/**
 * Constructs a new, empty array queue.
 *
 * If not provided, the function parameter is requested to the
 * {@link Functions} function factory methods.
 *
 * @param equal_func an optional element equality testing function
 */
GeeArrayQueue* gee_array_queue_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify) {
	GeeArrayQueue * self = NULL;
	GeeEqualDataFunc _tmp0_;
	void* _tmp0__target;
	GeeEqualDataFunc _tmp4_;
	void* _tmp4__target;
	gpointer* _tmp5_ = NULL;
	self = (GeeArrayQueue*) gee_abstract_queue_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = equal_func;
	_tmp0__target = equal_func_target;
	if (_tmp0_ == NULL) {
		void* _tmp1_ = NULL;
		GDestroyNotify _tmp2_ = NULL;
		GeeEqualDataFunc _tmp3_ = NULL;
		_tmp3_ = gee_functions_get_equal_func_for (g_type, &_tmp1_, &_tmp2_);
		(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
		equal_func = NULL;
		equal_func_target = NULL;
		equal_func_target_destroy_notify = NULL;
		equal_func = _tmp3_;
		equal_func_target = _tmp1_;
		equal_func_target_destroy_notify = _tmp2_;
	}
	_tmp4_ = equal_func;
	_tmp4__target = equal_func_target;
	gee_array_queue_set_equal_func (self, _tmp4_, _tmp4__target);
	_tmp5_ = g_new0 (gpointer, 10);
	self->priv->_items = (_vala_array_free (self->priv->_items, self->priv->_items_length1, (GDestroyNotify) g_destroy_func), NULL);
	self->priv->_items = _tmp5_;
	self->priv->_items_length1 = 10;
	self->priv->__items_size_ = self->priv->_items_length1;
	(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	return self;
}


GeeArrayQueue* gee_array_queue_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify) {
	return gee_array_queue_construct (GEE_TYPE_ARRAY_QUEUE, g_type, g_dup_func, g_destroy_func, equal_func, equal_func_target, equal_func_target_destroy_notify);
}


/**
 * {@inheritDoc}
 */
static GeeIterator* gee_array_queue_real_iterator (GeeAbstractCollection* base) {
	GeeArrayQueue * self;
	GeeIterator* result = NULL;
	GeeArrayQueueIterator* _tmp0_;
	self = (GeeArrayQueue*) base;
	_tmp0_ = gee_array_queue_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
	result = (GeeIterator*) _tmp0_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_array_queue_real_contains (GeeAbstractCollection* base, gconstpointer item) {
	GeeArrayQueue * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_;
	gint _tmp1_ = 0;
	self = (GeeArrayQueue*) base;
	_tmp0_ = item;
	_tmp1_ = gee_array_queue_find_index (self, _tmp0_);
	result = _tmp1_ != (-1);
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_array_queue_real_remove (GeeAbstractCollection* base, gconstpointer item) {
	GeeArrayQueue * self;
	gboolean result = FALSE;
	gint _tmp0_;
	gconstpointer _tmp1_;
	gint _tmp2_ = 0;
	gint index;
	gint _tmp3_;
	self = (GeeArrayQueue*) base;
	_tmp0_ = self->priv->_stamp;
	self->priv->_stamp = _tmp0_ + 1;
	_tmp1_ = item;
	_tmp2_ = gee_array_queue_find_index (self, _tmp1_);
	index = _tmp2_;
	_tmp3_ = index;
	if (_tmp3_ == (-1)) {
		result = FALSE;
		return result;
	} else {
		gint _tmp4_;
		_tmp4_ = index;
		gee_array_queue_remove_at (self, _tmp4_);
		result = TRUE;
		return result;
	}
}


/**
 * {@inheritDoc}
 */
static void gee_array_queue_real_clear (GeeAbstractCollection* base) {
	GeeArrayQueue * self;
	gint _tmp0_;
	gint _tmp11_;
	self = (GeeArrayQueue*) base;
	_tmp0_ = self->priv->_stamp;
	self->priv->_stamp = _tmp0_ + 1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				gint _tmp5_;
				gpointer* _tmp6_;
				gint _tmp6__length1;
				gint _tmp7_;
				gint _tmp8_;
				gpointer* _tmp9_;
				gint _tmp9__length1;
				gpointer _tmp10_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = self->priv->_length;
				if (!(_tmp4_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->_items;
				_tmp6__length1 = self->priv->_items_length1;
				_tmp7_ = self->priv->_start;
				_tmp8_ = i;
				_tmp9_ = self->priv->_items;
				_tmp9__length1 = self->priv->_items_length1;
				((_tmp6_[(_tmp7_ + _tmp8_) % _tmp9__length1] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp6_[(_tmp7_ + _tmp8_) % _tmp9__length1] = (self->priv->g_destroy_func (_tmp6_[(_tmp7_ + _tmp8_) % _tmp9__length1]), NULL));
				_tmp6_[(_tmp7_ + _tmp8_) % _tmp9__length1] = NULL;
				_tmp10_ = _tmp6_[(_tmp7_ + _tmp8_) % _tmp9__length1];
			}
		}
	}
	self->priv->_length = 0;
	_tmp11_ = self->priv->_length;
	self->priv->_start = _tmp11_;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_array_queue_real_offer (GeeAbstractQueue* base, gconstpointer element) {
	GeeArrayQueue * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_;
	gboolean _tmp1_ = FALSE;
	self = (GeeArrayQueue*) base;
	_tmp0_ = element;
	_tmp1_ = gee_deque_offer_tail ((GeeDeque*) self, _tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_array_queue_real_peek (GeeAbstractQueue* base) {
	GeeArrayQueue * self;
	gpointer result = NULL;
	gpointer _tmp0_ = NULL;
	self = (GeeArrayQueue*) base;
	_tmp0_ = gee_deque_peek_head ((GeeDeque*) self);
	result = _tmp0_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_array_queue_real_poll (GeeAbstractQueue* base) {
	GeeArrayQueue * self;
	gpointer result = NULL;
	gpointer _tmp0_ = NULL;
	self = (GeeArrayQueue*) base;
	_tmp0_ = gee_deque_poll_head ((GeeDeque*) self);
	result = _tmp0_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_array_queue_real_offer_head (GeeDeque* base, gconstpointer element) {
	GeeArrayQueue * self;
	gboolean result = FALSE;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	gpointer* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	gpointer* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gconstpointer _tmp6_;
	gpointer _tmp7_;
	gpointer _tmp8_;
	gint _tmp9_;
	self = (GeeArrayQueue*) base;
	gee_array_queue_grow_if_needed (self);
	_tmp0_ = self->priv->_items;
	_tmp0__length1 = self->priv->_items_length1;
	_tmp1_ = self->priv->_start;
	_tmp2_ = self->priv->_items;
	_tmp2__length1 = self->priv->_items_length1;
	self->priv->_start = ((_tmp0__length1 + _tmp1_) - 1) % _tmp2__length1;
	_tmp3_ = self->priv->_length;
	self->priv->_length = _tmp3_ + 1;
	_tmp4_ = self->priv->_items;
	_tmp4__length1 = self->priv->_items_length1;
	_tmp5_ = self->priv->_start;
	_tmp6_ = element;
	_tmp7_ = ((_tmp6_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp6_) : ((gpointer) _tmp6_);
	((_tmp4_[_tmp5_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp4_[_tmp5_] = (self->priv->g_destroy_func (_tmp4_[_tmp5_]), NULL));
	_tmp4_[_tmp5_] = _tmp7_;
	_tmp8_ = _tmp4_[_tmp5_];
	_tmp9_ = self->priv->_stamp;
	self->priv->_stamp = _tmp9_ + 1;
	result = TRUE;
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_array_queue_real_peek_head (GeeDeque* base) {
	GeeArrayQueue * self;
	gpointer result = NULL;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	gconstpointer _tmp2_;
	gpointer _tmp3_;
	self = (GeeArrayQueue*) base;
	_tmp0_ = self->priv->_items;
	_tmp0__length1 = self->priv->_items_length1;
	_tmp1_ = self->priv->_start;
	_tmp2_ = _tmp0_[_tmp1_];
	_tmp3_ = ((_tmp2_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp2_) : ((gpointer) _tmp2_);
	result = _tmp3_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_array_queue_real_poll_head (GeeDeque* base) {
	GeeArrayQueue * self;
	gpointer result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	self = (GeeArrayQueue*) base;
	_tmp0_ = self->priv->_stamp;
	self->priv->_stamp = _tmp0_ + 1;
	_tmp1_ = self->priv->_length;
	if (_tmp1_ == 0) {
		self->priv->_start = 0;
		result = NULL;
		return result;
	} else {
		gint _tmp2_;
		gpointer* _tmp3_;
		gint _tmp3__length1;
		gint _tmp4_;
		gpointer _tmp5_;
		gpointer _result_;
		gint _tmp6_;
		gpointer* _tmp7_;
		gint _tmp7__length1;
		gpointer _tmp8_;
		_tmp2_ = self->priv->_length;
		self->priv->_length = _tmp2_ - 1;
		_tmp3_ = self->priv->_items;
		_tmp3__length1 = self->priv->_items_length1;
		_tmp4_ = self->priv->_start;
		_tmp5_ = _tmp3_[_tmp4_];
		_tmp3_[_tmp4_] = NULL;
		_result_ = _tmp5_;
		_tmp6_ = self->priv->_start;
		_tmp7_ = self->priv->_items;
		_tmp7__length1 = self->priv->_items_length1;
		self->priv->_start = (_tmp6_ + 1) % _tmp7__length1;
		_tmp8_ = _result_;
		_result_ = NULL;
		result = _tmp8_;
		((_result_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_result_ = (self->priv->g_destroy_func (_result_), NULL));
		return result;
	}
}


/**
 * {@inheritDoc}
 */
static gint gee_array_queue_real_drain_head (GeeDeque* base, GeeCollection* recipient, gint amount) {
	GeeArrayQueue * self;
	gint result = 0;
	GeeCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_ = 0;
	self = (GeeArrayQueue*) base;
	g_return_val_if_fail (recipient != NULL, 0);
	_tmp0_ = recipient;
	_tmp1_ = amount;
	_tmp2_ = gee_abstract_queue_drain ((GeeAbstractQueue*) self, _tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_array_queue_real_offer_tail (GeeDeque* base, gconstpointer element) {
	GeeArrayQueue * self;
	gboolean result = FALSE;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	gint _tmp2_;
	gpointer* _tmp3_;
	gint _tmp3__length1;
	gconstpointer _tmp4_;
	gpointer _tmp5_;
	gpointer _tmp6_;
	gint _tmp7_;
	self = (GeeArrayQueue*) base;
	gee_array_queue_grow_if_needed (self);
	_tmp0_ = self->priv->_items;
	_tmp0__length1 = self->priv->_items_length1;
	_tmp1_ = self->priv->_start;
	_tmp2_ = self->priv->_length;
	self->priv->_length = _tmp2_ + 1;
	_tmp3_ = self->priv->_items;
	_tmp3__length1 = self->priv->_items_length1;
	_tmp4_ = element;
	_tmp5_ = ((_tmp4_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp4_) : ((gpointer) _tmp4_);
	((_tmp0_[(_tmp1_ + _tmp2_) % _tmp3__length1] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp0_[(_tmp1_ + _tmp2_) % _tmp3__length1] = (self->priv->g_destroy_func (_tmp0_[(_tmp1_ + _tmp2_) % _tmp3__length1]), NULL));
	_tmp0_[(_tmp1_ + _tmp2_) % _tmp3__length1] = _tmp5_;
	_tmp6_ = _tmp0_[(_tmp1_ + _tmp2_) % _tmp3__length1];
	_tmp7_ = self->priv->_stamp;
	self->priv->_stamp = _tmp7_ + 1;
	result = TRUE;
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_array_queue_real_peek_tail (GeeDeque* base) {
	GeeArrayQueue * self;
	gpointer result = NULL;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gpointer* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	gint _tmp3_;
	gpointer* _tmp4_;
	gint _tmp4__length1;
	gconstpointer _tmp5_;
	gpointer _tmp6_;
	self = (GeeArrayQueue*) base;
	_tmp0_ = self->priv->_items;
	_tmp0__length1 = self->priv->_items_length1;
	_tmp1_ = self->priv->_items;
	_tmp1__length1 = self->priv->_items_length1;
	_tmp2_ = self->priv->_start;
	_tmp3_ = self->priv->_length;
	_tmp4_ = self->priv->_items;
	_tmp4__length1 = self->priv->_items_length1;
	_tmp5_ = _tmp0_[(((_tmp1__length1 + _tmp2_) + _tmp3_) - 1) % _tmp4__length1];
	_tmp6_ = ((_tmp5_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp5_) : ((gpointer) _tmp5_);
	result = _tmp6_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_array_queue_real_poll_tail (GeeDeque* base) {
	GeeArrayQueue * self;
	gpointer result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	self = (GeeArrayQueue*) base;
	_tmp0_ = self->priv->_stamp;
	self->priv->_stamp = _tmp0_ + 1;
	_tmp1_ = self->priv->_length;
	if (_tmp1_ == 0) {
		self->priv->_start = 0;
		result = NULL;
		return result;
	} else {
		gpointer* _tmp2_;
		gint _tmp2__length1;
		gpointer* _tmp3_;
		gint _tmp3__length1;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gpointer* _tmp7_;
		gint _tmp7__length1;
		gpointer _tmp8_;
		_tmp2_ = self->priv->_items;
		_tmp2__length1 = self->priv->_items_length1;
		_tmp3_ = self->priv->_items;
		_tmp3__length1 = self->priv->_items_length1;
		_tmp4_ = self->priv->_start;
		_tmp5_ = self->priv->_length;
		self->priv->_length = _tmp5_ - 1;
		_tmp6_ = self->priv->_length;
		_tmp7_ = self->priv->_items;
		_tmp7__length1 = self->priv->_items_length1;
		_tmp8_ = _tmp2_[((_tmp3__length1 + _tmp4_) + _tmp6_) % _tmp7__length1];
		_tmp2_[((_tmp3__length1 + _tmp4_) + _tmp6_) % _tmp7__length1] = NULL;
		result = _tmp8_;
		return result;
	}
}


/**
 * {@inheritDoc}
 */
static gint gee_array_queue_real_drain_tail (GeeDeque* base, GeeCollection* recipient, gint amount) {
	GeeArrayQueue * self;
	gint result = 0;
	gpointer item;
	gint drained;
	self = (GeeArrayQueue*) base;
	g_return_val_if_fail (recipient != NULL, 0);
	item = NULL;
	drained = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gint _tmp2_;
		gboolean _tmp5_;
		gboolean _tmp8_;
		GeeCollection* _tmp9_;
		gconstpointer _tmp10_;
		gint _tmp11_;
		_tmp2_ = amount;
		if (_tmp2_ == (-1)) {
			_tmp1_ = TRUE;
		} else {
			gint _tmp3_;
			gint _tmp4_;
			_tmp3_ = amount;
			amount = _tmp3_ - 1;
			_tmp4_ = amount;
			_tmp1_ = _tmp4_ >= 0;
		}
		_tmp5_ = _tmp1_;
		if (_tmp5_) {
			gpointer _tmp6_ = NULL;
			gconstpointer _tmp7_;
			_tmp6_ = gee_deque_poll_tail ((GeeDeque*) self);
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
			item = _tmp6_;
			_tmp7_ = item;
			_tmp0_ = _tmp7_ != NULL;
		} else {
			_tmp0_ = FALSE;
		}
		_tmp8_ = _tmp0_;
		if (!_tmp8_) {
			break;
		}
		_tmp9_ = recipient;
		_tmp10_ = item;
		gee_collection_add (_tmp9_, _tmp10_);
		_tmp11_ = drained;
		drained = _tmp11_ + 1;
	}
	result = drained;
	((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
	return result;
}


/**
 * {@inheritDoc}
 */
static void gee_array_queue_grow_if_needed (GeeArrayQueue* self) {
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_items;
	_tmp0__length1 = self->priv->_items_length1;
	_tmp1_ = self->priv->_length;
	if (_tmp0__length1 < (_tmp1_ + 1)) {
		gpointer* _tmp2_;
		gint _tmp2__length1;
		gint _tmp3_ = 0;
		_tmp2_ = self->priv->_items;
		_tmp2__length1 = self->priv->_items_length1;
		_tmp3_ = 2 * _tmp2__length1;
		self->priv->_items = g_renew (gpointer, self->priv->_items, 2 * _tmp2__length1);
		(_tmp3_ > self->priv->_items_length1) ? memset (self->priv->_items + self->priv->_items_length1, 0, sizeof (gpointer) * (_tmp3_ - self->priv->_items_length1)) : NULL;
		self->priv->_items_length1 = _tmp3_;
		self->priv->__items_size_ = _tmp3_;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp4_;
				_tmp4_ = TRUE;
				while (TRUE) {
					gboolean _tmp5_;
					gint _tmp7_;
					gint _tmp8_;
					gpointer* _tmp9_;
					gint _tmp9__length1;
					gint _tmp10_;
					gint _tmp11_;
					gpointer* _tmp12_;
					gint _tmp12__length1;
					gint _tmp13_;
					gpointer _tmp14_;
					gpointer _tmp15_;
					_tmp5_ = _tmp4_;
					if (!_tmp5_) {
						gint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp4_ = FALSE;
					_tmp7_ = i;
					_tmp8_ = self->priv->_start;
					if (!(_tmp7_ < _tmp8_)) {
						break;
					}
					_tmp9_ = self->priv->_items;
					_tmp9__length1 = self->priv->_items_length1;
					_tmp10_ = self->priv->_length;
					_tmp11_ = i;
					_tmp12_ = self->priv->_items;
					_tmp12__length1 = self->priv->_items_length1;
					_tmp13_ = i;
					_tmp14_ = _tmp12_[_tmp13_];
					_tmp12_[_tmp13_] = NULL;
					((_tmp9_[_tmp10_ + _tmp11_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp9_[_tmp10_ + _tmp11_] = (self->priv->g_destroy_func (_tmp9_[_tmp10_ + _tmp11_]), NULL));
					_tmp9_[_tmp10_ + _tmp11_] = _tmp14_;
					_tmp15_ = _tmp9_[_tmp10_ + _tmp11_];
				}
			}
		}
	}
}


static gint gee_array_queue_find_index (GeeArrayQueue* self, gconstpointer item) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint _tmp0_;
		gint i;
		_tmp0_ = self->priv->_start;
		i = _tmp0_;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				gpointer* _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				gint _tmp7_;
				gint _tmp8_ = 0;
				GeeEqualDataFunc _tmp9_;
				void* _tmp9__target;
				GeeEqualDataFunc _tmp10_;
				void* _tmp10__target;
				gconstpointer _tmp11_;
				gpointer* _tmp12_;
				gint _tmp12__length1;
				gint _tmp13_;
				gconstpointer _tmp14_;
				gboolean _tmp15_ = FALSE;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = self->priv->_items;
				_tmp5__length1 = self->priv->_items_length1;
				_tmp6_ = self->priv->_start;
				_tmp7_ = self->priv->_length;
				_tmp8_ = MIN (_tmp5__length1, _tmp6_ + _tmp7_);
				if (!(_tmp4_ < _tmp8_)) {
					break;
				}
				_tmp9_ = gee_array_queue_get_equal_func (self, &_tmp9__target);
				_tmp10_ = _tmp9_;
				_tmp10__target = _tmp9__target;
				_tmp11_ = item;
				_tmp12_ = self->priv->_items;
				_tmp12__length1 = self->priv->_items_length1;
				_tmp13_ = i;
				_tmp14_ = _tmp12_[_tmp13_];
				_tmp15_ = _tmp10_ (_tmp11_, _tmp14_, _tmp10__target);
				if (_tmp15_) {
					result = i;
					return result;
				}
			}
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp16_;
			_tmp16_ = TRUE;
			while (TRUE) {
				gboolean _tmp17_;
				gint _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				gpointer* _tmp22_;
				gint _tmp22__length1;
				GeeEqualDataFunc _tmp23_;
				void* _tmp23__target;
				GeeEqualDataFunc _tmp24_;
				void* _tmp24__target;
				gconstpointer _tmp25_;
				gpointer* _tmp26_;
				gint _tmp26__length1;
				gint _tmp27_;
				gconstpointer _tmp28_;
				gboolean _tmp29_ = FALSE;
				_tmp17_ = _tmp16_;
				if (!_tmp17_) {
					gint _tmp18_;
					_tmp18_ = i;
					i = _tmp18_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp19_ = i;
				_tmp20_ = self->priv->_start;
				_tmp21_ = self->priv->_length;
				_tmp22_ = self->priv->_items;
				_tmp22__length1 = self->priv->_items_length1;
				if (!(_tmp19_ < ((_tmp20_ + _tmp21_) - _tmp22__length1))) {
					break;
				}
				_tmp23_ = gee_array_queue_get_equal_func (self, &_tmp23__target);
				_tmp24_ = _tmp23_;
				_tmp24__target = _tmp23__target;
				_tmp25_ = item;
				_tmp26_ = self->priv->_items;
				_tmp26__length1 = self->priv->_items_length1;
				_tmp27_ = i;
				_tmp28_ = _tmp26_[_tmp27_];
				_tmp29_ = _tmp24_ (_tmp25_, _tmp28_, _tmp24__target);
				if (_tmp29_) {
					result = i;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}


static void gee_array_queue_remove_at (GeeArrayQueue* self, gint index) {
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	gint _tmp2_;
	gpointer* _tmp3_;
	gint _tmp3__length1;
	gint end;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_items;
	_tmp0__length1 = self->priv->_items_length1;
	_tmp1_ = self->priv->_start;
	_tmp2_ = self->priv->_length;
	_tmp3_ = self->priv->_items;
	_tmp3__length1 = self->priv->_items_length1;
	end = ((((_tmp0__length1 + _tmp1_) + _tmp2_) - 1) % _tmp3__length1) + 1;
	_tmp4_ = index;
	_tmp5_ = self->priv->_start;
	if (_tmp4_ == _tmp5_) {
		gpointer* _tmp6_;
		gint _tmp6__length1;
		gint _tmp7_;
		gpointer _tmp8_;
		gint _tmp9_;
		_tmp6_ = self->priv->_items;
		_tmp6__length1 = self->priv->_items_length1;
		_tmp7_ = self->priv->_start;
		self->priv->_start = _tmp7_ + 1;
		((_tmp6_[_tmp7_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp6_[_tmp7_] = (self->priv->g_destroy_func (_tmp6_[_tmp7_]), NULL));
		_tmp6_[_tmp7_] = NULL;
		_tmp8_ = _tmp6_[_tmp7_];
		_tmp9_ = self->priv->_length;
		self->priv->_length = _tmp9_ - 1;
		return;
	} else {
		gboolean _tmp10_ = FALSE;
		gint _tmp11_;
		gint _tmp12_;
		gboolean _tmp15_;
		_tmp11_ = index;
		_tmp12_ = self->priv->_start;
		if (_tmp11_ > _tmp12_) {
			gint _tmp13_;
			gint _tmp14_;
			_tmp13_ = end;
			_tmp14_ = self->priv->_start;
			_tmp10_ = _tmp13_ <= _tmp14_;
		} else {
			_tmp10_ = FALSE;
		}
		_tmp15_ = _tmp10_;
		if (_tmp15_) {
			gpointer* _tmp16_;
			gint _tmp16__length1;
			gint _tmp17_;
			gpointer _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			gpointer* _tmp21_;
			gint _tmp21__length1;
			gpointer* _tmp22_;
			gint _tmp22__length1;
			gpointer* _tmp23_;
			gint _tmp23__length1;
			gpointer* _tmp24_;
			gint _tmp24__length1;
			gpointer _tmp25_;
			gpointer _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			_tmp16_ = self->priv->_items;
			_tmp16__length1 = self->priv->_items_length1;
			_tmp17_ = index;
			((_tmp16_[_tmp17_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp16_[_tmp17_] = (self->priv->g_destroy_func (_tmp16_[_tmp17_]), NULL));
			_tmp16_[_tmp17_] = NULL;
			_tmp18_ = _tmp16_[_tmp17_];
			_tmp19_ = index;
			_tmp20_ = index;
			_tmp21_ = self->priv->_items;
			_tmp21__length1 = self->priv->_items_length1;
			_vala_array_move (self->priv->_items, sizeof (gpointer), _tmp19_ + 1, _tmp20_, _tmp21__length1 - 1);
			_tmp22_ = self->priv->_items;
			_tmp22__length1 = self->priv->_items_length1;
			_tmp23_ = self->priv->_items;
			_tmp23__length1 = self->priv->_items_length1;
			_tmp24_ = self->priv->_items;
			_tmp24__length1 = self->priv->_items_length1;
			_tmp25_ = _tmp24_[0];
			_tmp24_[0] = NULL;
			((_tmp22_[_tmp23__length1 - 1] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp22_[_tmp23__length1 - 1] = (self->priv->g_destroy_func (_tmp22_[_tmp23__length1 - 1]), NULL));
			_tmp22_[_tmp23__length1 - 1] = _tmp25_;
			_tmp26_ = _tmp22_[_tmp23__length1 - 1];
			_tmp27_ = end;
			_vala_array_move (self->priv->_items, sizeof (gpointer), 1, 0, _tmp27_ - 1);
			_tmp28_ = self->priv->_length;
			self->priv->_length = _tmp28_ - 1;
		} else {
			gpointer* _tmp29_;
			gint _tmp29__length1;
			gint _tmp30_;
			gpointer _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			gint _tmp35_;
			gint _tmp36_;
			_tmp29_ = self->priv->_items;
			_tmp29__length1 = self->priv->_items_length1;
			_tmp30_ = index;
			((_tmp29_[_tmp30_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp29_[_tmp30_] = (self->priv->g_destroy_func (_tmp29_[_tmp30_]), NULL));
			_tmp29_[_tmp30_] = NULL;
			_tmp31_ = _tmp29_[_tmp30_];
			_tmp32_ = index;
			_tmp33_ = index;
			_tmp34_ = end;
			_tmp35_ = index;
			_vala_array_move (self->priv->_items, sizeof (gpointer), _tmp32_ + 1, _tmp33_, _tmp34_ - (_tmp35_ + 1));
			_tmp36_ = self->priv->_length;
			self->priv->_length = _tmp36_ - 1;
		}
	}
}


GeeEqualDataFunc gee_array_queue_get_equal_func (GeeArrayQueue* self, gpointer* result_target) {
	GeeEqualDataFunc result;
	GeeEqualDataFunc _tmp0_;
	void* _tmp0__target;
	GeeEqualDataFunc _tmp1_;
	void* _tmp1__target;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equal_func;
	_tmp0__target = self->priv->_equal_func_target;
	_tmp1_ = _tmp0_;
	_tmp1__target = _tmp0__target;
	*result_target = _tmp1__target;
	result = _tmp1_;
	return result;
}


static void gee_array_queue_set_equal_func (GeeArrayQueue* self, GeeEqualDataFunc value, gpointer value_target) {
	GeeEqualDataFunc _tmp0_;
	void* _tmp0__target;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp0__target = value_target;
	(self->priv->_equal_func_target_destroy_notify == NULL) ? NULL : (self->priv->_equal_func_target_destroy_notify (self->priv->_equal_func_target), NULL);
	self->priv->_equal_func = NULL;
	self->priv->_equal_func_target = NULL;
	self->priv->_equal_func_target_destroy_notify = NULL;
	self->priv->_equal_func = _tmp0_;
	self->priv->_equal_func_target = _tmp0__target;
	self->priv->_equal_func_target_destroy_notify = NULL;
}


static gint gee_array_queue_real_get_size (GeeAbstractCollection* base) {
	gint result;
	GeeArrayQueue* self;
	gint _tmp0_;
	self = (GeeArrayQueue*) base;
	_tmp0_ = self->priv->_length;
	result = _tmp0_;
	return result;
}


static gboolean gee_array_queue_real_get_is_empty (GeeAbstractCollection* base) {
	gboolean result;
	GeeArrayQueue* self;
	gint _tmp0_;
	self = (GeeArrayQueue*) base;
	_tmp0_ = self->priv->_length;
	result = _tmp0_ == 0;
	return result;
}


static gboolean gee_array_queue_real_get_read_only (GeeAbstractCollection* base) {
	gboolean result;
	GeeArrayQueue* self;
	self = (GeeArrayQueue*) base;
	result = FALSE;
	return result;
}


static gint gee_array_queue_real_get_capacity (GeeAbstractQueue* base) {
	gint result;
	GeeArrayQueue* self;
	self = (GeeArrayQueue*) base;
	result = GEE_QUEUE_UNBOUNDED_CAPACITY;
	return result;
}


static gint gee_array_queue_real_get_remaining_capacity (GeeAbstractQueue* base) {
	gint result;
	GeeArrayQueue* self;
	self = (GeeArrayQueue*) base;
	result = GEE_QUEUE_UNBOUNDED_CAPACITY;
	return result;
}


static gboolean gee_array_queue_real_get_is_full (GeeAbstractQueue* base) {
	gboolean result;
	GeeArrayQueue* self;
	self = (GeeArrayQueue*) base;
	result = FALSE;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GeeArrayQueueIterator* gee_array_queue_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayQueue* queue) {
	GeeArrayQueueIterator * self = NULL;
	GeeArrayQueue* _tmp0_;
	GeeArrayQueue* _tmp1_;
	GeeArrayQueue* _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (queue != NULL, NULL);
	self = (GeeArrayQueueIterator*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = queue;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_queue);
	self->priv->_queue = _tmp1_;
	_tmp2_ = self->priv->_queue;
	_tmp3_ = _tmp2_->priv->_stamp;
	self->priv->_stamp = _tmp3_;
	return self;
}


static GeeArrayQueueIterator* gee_array_queue_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayQueue* queue) {
	return gee_array_queue_iterator_construct (GEE_ARRAY_QUEUE_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, queue);
}


static gboolean gee_array_queue_iterator_real_next (GeeIterator* base) {
	GeeArrayQueueIterator * self;
	gboolean result = FALSE;
	GeeArrayQueue* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_ = FALSE;
	self = (GeeArrayQueueIterator*) base;
	_tmp0_ = self->priv->_queue;
	_tmp1_ = _tmp0_->priv->_stamp;
	_tmp2_ = self->priv->_stamp;
	g_assert (_tmp1_ == _tmp2_);
	_tmp3_ = gee_iterator_has_next ((GeeIterator*) self);
	if (_tmp3_) {
		gint _tmp4_;
		_tmp4_ = self->priv->_offset;
		self->priv->_offset = _tmp4_ + 1;
		self->priv->_removed = FALSE;
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static gboolean gee_array_queue_iterator_real_has_next (GeeIterator* base) {
	GeeArrayQueueIterator * self;
	gboolean result = FALSE;
	GeeArrayQueue* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayQueue* _tmp4_;
	gint _tmp5_;
	self = (GeeArrayQueueIterator*) base;
	_tmp0_ = self->priv->_queue;
	_tmp1_ = _tmp0_->priv->_stamp;
	_tmp2_ = self->priv->_stamp;
	g_assert (_tmp1_ == _tmp2_);
	_tmp3_ = self->priv->_offset;
	_tmp4_ = self->priv->_queue;
	_tmp5_ = _tmp4_->priv->_length;
	result = (_tmp3_ + 1) < _tmp5_;
	return result;
}


static gpointer gee_array_queue_iterator_real_get (GeeIterator* base) {
	GeeArrayQueueIterator * self;
	gpointer result = NULL;
	GeeArrayQueue* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_;
	GeeArrayQueue* _tmp5_;
	gpointer* _tmp6_;
	gint _tmp6__length1;
	GeeArrayQueue* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GeeArrayQueue* _tmp10_;
	gpointer* _tmp11_;
	gint _tmp11__length1;
	gconstpointer _tmp12_;
	gpointer _tmp13_;
	self = (GeeArrayQueueIterator*) base;
	_tmp0_ = self->priv->_queue;
	_tmp1_ = _tmp0_->priv->_stamp;
	_tmp2_ = self->priv->_stamp;
	g_assert (_tmp1_ == _tmp2_);
	_tmp3_ = self->priv->_offset;
	g_assert (_tmp3_ != (-1));
	_tmp4_ = self->priv->_removed;
	g_assert (!_tmp4_);
	_tmp5_ = self->priv->_queue;
	_tmp6_ = _tmp5_->priv->_items;
	_tmp6__length1 = _tmp5_->priv->_items_length1;
	_tmp7_ = self->priv->_queue;
	_tmp8_ = _tmp7_->priv->_start;
	_tmp9_ = self->priv->_offset;
	_tmp10_ = self->priv->_queue;
	_tmp11_ = _tmp10_->priv->_items;
	_tmp11__length1 = _tmp10_->priv->_items_length1;
	_tmp12_ = _tmp6_[(_tmp8_ + _tmp9_) % _tmp11__length1];
	_tmp13_ = ((_tmp12_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp12_) : ((gpointer) _tmp12_);
	result = _tmp13_;
	return result;
}


static void gee_array_queue_iterator_real_remove (GeeIterator* base) {
	GeeArrayQueueIterator * self;
	GeeArrayQueue* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayQueue* _tmp3_;
	GeeArrayQueue* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GeeArrayQueue* _tmp7_;
	gpointer* _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_;
	self = (GeeArrayQueueIterator*) base;
	_tmp0_ = self->priv->_queue;
	_tmp1_ = _tmp0_->priv->_stamp;
	_tmp0_->priv->_stamp = _tmp1_ + 1;
	_tmp2_ = self->priv->_stamp;
	self->priv->_stamp = _tmp2_ + 1;
	g_assert (_tmp1_ == _tmp2_);
	_tmp3_ = self->priv->_queue;
	_tmp4_ = self->priv->_queue;
	_tmp5_ = _tmp4_->priv->_start;
	_tmp6_ = self->priv->_offset;
	_tmp7_ = self->priv->_queue;
	_tmp8_ = _tmp7_->priv->_items;
	_tmp8__length1 = _tmp7_->priv->_items_length1;
	gee_array_queue_remove_at (_tmp3_, (_tmp5_ + _tmp6_) % _tmp8__length1);
	_tmp9_ = self->priv->_offset;
	self->priv->_offset = _tmp9_ - 1;
	self->priv->_removed = TRUE;
}


static void gee_array_queue_iterator_real_foreach (GeeTraversable* base, GeeForallFunc f, void* f_target) {
	GeeArrayQueueIterator * self;
	GeeArrayQueue* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	self = (GeeArrayQueueIterator*) base;
	_tmp0_ = self->priv->_queue;
	_tmp1_ = _tmp0_->priv->_stamp;
	_tmp2_ = self->priv->_stamp;
	g_assert (_tmp1_ == _tmp2_);
	_tmp3_ = gee_iterator_get_valid ((GeeIterator*) self);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		gint _tmp5_;
		_tmp5_ = self->priv->_offset;
		self->priv->_offset = _tmp5_ + 1;
		self->priv->_removed = FALSE;
	}
	{
		gint _tmp6_;
		gint i;
		_tmp6_ = self->priv->_offset;
		i = _tmp6_;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_;
				gint _tmp10_;
				GeeArrayQueue* _tmp11_;
				gint _tmp12_;
				GeeForallFunc _tmp13_;
				void* _tmp13__target;
				GeeArrayQueue* _tmp14_;
				gpointer* _tmp15_;
				gint _tmp15__length1;
				GeeArrayQueue* _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				GeeArrayQueue* _tmp19_;
				gpointer* _tmp20_;
				gint _tmp20__length1;
				gconstpointer _tmp21_;
				gpointer _tmp22_;
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp10_ = i;
				_tmp11_ = self->priv->_queue;
				_tmp12_ = _tmp11_->priv->_length;
				if (!(_tmp10_ < _tmp12_)) {
					break;
				}
				_tmp13_ = f;
				_tmp13__target = f_target;
				_tmp14_ = self->priv->_queue;
				_tmp15_ = _tmp14_->priv->_items;
				_tmp15__length1 = _tmp14_->priv->_items_length1;
				_tmp16_ = self->priv->_queue;
				_tmp17_ = _tmp16_->priv->_start;
				_tmp18_ = i;
				_tmp19_ = self->priv->_queue;
				_tmp20_ = _tmp19_->priv->_items;
				_tmp20__length1 = _tmp19_->priv->_items_length1;
				_tmp21_ = _tmp15_[(_tmp17_ + _tmp18_) % _tmp20__length1];
				_tmp22_ = ((_tmp21_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp21_) : ((gpointer) _tmp21_);
				_tmp13_ (_tmp22_, _tmp13__target);
			}
		}
	}
}


static GeeIterator* gee_array_queue_iterator_real_stream (GeeTraversable* base, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify) {
	GeeArrayQueueIterator * self;
	GeeIterator* result = NULL;
	GeeStreamFunc _tmp0_;
	void* _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	GeeIterator* _tmp1_ = NULL;
	self = (GeeArrayQueueIterator*) base;
	_tmp0_ = f;
	_tmp0__target = f_target;
	_tmp0__target_destroy_notify = f_target_destroy_notify;
	f_target_destroy_notify = NULL;
	_tmp1_ = gee_iterator_stream_impl (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, (GeeIterator*) self, _tmp0_, _tmp0__target, _tmp0__target_destroy_notify);
	result = _tmp1_;
	(f_target_destroy_notify == NULL) ? NULL : (f_target_destroy_notify (f_target), NULL);
	f = NULL;
	f_target = NULL;
	f_target_destroy_notify = NULL;
	return result;
}


static GeeIterator* gee_array_queue_iterator_real_filter (GeeTraversable* base, GeePredicate f, void* f_target, GDestroyNotify f_target_destroy_notify) {
	GeeArrayQueueIterator * self;
	GeeIterator* result = NULL;
	GeePredicate _tmp0_;
	void* _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	GeeIterator* _tmp1_ = NULL;
	self = (GeeArrayQueueIterator*) base;
	_tmp0_ = f;
	_tmp0__target = f_target;
	_tmp0__target_destroy_notify = f_target_destroy_notify;
	f_target_destroy_notify = NULL;
	_tmp1_ = gee_traversable_filter_impl (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, (GeeTraversable*) self, _tmp0_, _tmp0__target, _tmp0__target_destroy_notify);
	result = _tmp1_;
	(f_target_destroy_notify == NULL) ? NULL : (f_target_destroy_notify (f_target), NULL);
	f = NULL;
	f_target = NULL;
	f_target_destroy_notify = NULL;
	return result;
}


static GeeIterator* gee_array_queue_iterator_real_chop (GeeTraversable* base, gint offset, gint length) {
	GeeArrayQueueIterator * self;
	GeeIterator* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	GeeIterator* _tmp2_ = NULL;
	self = (GeeArrayQueueIterator*) base;
	_tmp0_ = offset;
	_tmp1_ = length;
	_tmp2_ = gee_traversable_chop_impl (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, (GeeTraversable*) self, _tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static gboolean gee_array_queue_iterator_real_get_valid (GeeIterator* base) {
	gboolean result;
	GeeArrayQueueIterator* self;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp3_;
	self = (GeeArrayQueueIterator*) base;
	_tmp1_ = self->priv->_offset;
	if (_tmp1_ != (-1)) {
		gboolean _tmp2_;
		_tmp2_ = self->priv->_removed;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	result = _tmp3_;
	return result;
}


static gboolean gee_array_queue_iterator_real_get_read_only (GeeIterator* base) {
	gboolean result;
	GeeArrayQueueIterator* self;
	self = (GeeArrayQueueIterator*) base;
	result = FALSE;
	return result;
}


static void gee_array_queue_iterator_class_init (GeeArrayQueueIteratorClass * klass) {
	gee_array_queue_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeArrayQueueIteratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_array_queue_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_array_queue_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_array_queue_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_ITERATOR_VALID, g_param_spec_boolean ("valid", "valid", "valid", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_ITERATOR_READ_ONLY, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gee_array_queue_iterator_gee_traversable_interface_init (GeeTraversableIface * iface) {
	gee_array_queue_iterator_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
	iface->foreach = (void (*)(GeeTraversable*, GeeForallFunc, void*)) gee_array_queue_iterator_real_foreach;
	iface->stream = (GeeIterator* (*)(GeeTraversable*, GType, GBoxedCopyFunc, GDestroyNotify, GeeStreamFunc, void*, GDestroyNotify)) gee_array_queue_iterator_real_stream;
	iface->filter = (GeeIterator* (*)(GeeTraversable*, GeePredicate, void*, GDestroyNotify)) gee_array_queue_iterator_real_filter;
	iface->chop = (GeeIterator* (*)(GeeTraversable*, gint, gint)) gee_array_queue_iterator_real_chop;
}


static void gee_array_queue_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
	gee_array_queue_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = (gboolean (*)(GeeIterator*)) gee_array_queue_iterator_real_next;
	iface->has_next = (gboolean (*)(GeeIterator*)) gee_array_queue_iterator_real_has_next;
	iface->get = (gpointer (*)(GeeIterator*)) gee_array_queue_iterator_real_get;
	iface->remove = (void (*)(GeeIterator*)) gee_array_queue_iterator_real_remove;
	iface->get_valid = gee_array_queue_iterator_real_get_valid;
	iface->get_read_only = gee_array_queue_iterator_real_get_read_only;
}


static void gee_array_queue_iterator_instance_init (GeeArrayQueueIterator * self) {
	self->priv = GEE_ARRAY_QUEUE_ITERATOR_GET_PRIVATE (self);
	self->priv->_offset = -1;
	self->priv->_removed = FALSE;
}


static void gee_array_queue_iterator_finalize (GObject* obj) {
	GeeArrayQueueIterator * self;
	self = GEE_ARRAY_QUEUE_ITERATOR (obj);
	_g_object_unref0 (self->priv->_queue);
	G_OBJECT_CLASS (gee_array_queue_iterator_parent_class)->finalize (obj);
}


static GType gee_array_queue_iterator_get_type (void) {
	static volatile gsize gee_array_queue_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_array_queue_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeArrayQueueIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_array_queue_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeArrayQueueIterator), 0, (GInstanceInitFunc) gee_array_queue_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) gee_array_queue_iterator_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_array_queue_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_array_queue_iterator_type_id;
		gee_array_queue_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeArrayQueueIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_array_queue_iterator_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
		g_type_add_interface_static (gee_array_queue_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
		g_once_init_leave (&gee_array_queue_iterator_type_id__volatile, gee_array_queue_iterator_type_id);
	}
	return gee_array_queue_iterator_type_id__volatile;
}


static void _vala_gee_array_queue_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeArrayQueueIterator * self;
	self = GEE_ARRAY_QUEUE_ITERATOR (object);
	switch (property_id) {
		case GEE_ARRAY_QUEUE_ITERATOR_VALID:
		g_value_set_boolean (value, gee_iterator_get_valid ((GeeIterator*) self));
		break;
		case GEE_ARRAY_QUEUE_ITERATOR_READ_ONLY:
		g_value_set_boolean (value, gee_iterator_get_read_only ((GeeIterator*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gee_array_queue_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeArrayQueueIterator * self;
	self = GEE_ARRAY_QUEUE_ITERATOR (object);
	switch (property_id) {
		case GEE_ARRAY_QUEUE_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_ARRAY_QUEUE_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_ARRAY_QUEUE_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_array_queue_class_init (GeeArrayQueueClass * klass) {
	gee_array_queue_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeArrayQueuePrivate));
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_array_queue_real_iterator;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_array_queue_real_contains;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_array_queue_real_remove;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_array_queue_real_clear;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->offer = gee_array_queue_real_offer;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->peek = gee_array_queue_real_peek;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->poll = gee_array_queue_real_poll;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_array_queue_real_get_size;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_is_empty = gee_array_queue_real_get_is_empty;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_read_only = gee_array_queue_real_get_read_only;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->get_capacity = gee_array_queue_real_get_capacity;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->get_remaining_capacity = gee_array_queue_real_get_remaining_capacity;
	GEE_ABSTRACT_QUEUE_CLASS (klass)->get_is_full = gee_array_queue_real_get_is_full;
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_array_queue_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_array_queue_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_array_queue_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_IS_EMPTY, g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_READ_ONLY, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_CAPACITY, g_param_spec_int ("capacity", "capacity", "capacity", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_REMAINING_CAPACITY, g_param_spec_int ("remaining-capacity", "remaining-capacity", "remaining-capacity", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_IS_FULL, g_param_spec_boolean ("is-full", "is-full", "is-full", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gee_array_queue_gee_deque_interface_init (GeeDequeIface * iface) {
	gee_array_queue_gee_deque_parent_iface = g_type_interface_peek_parent (iface);
	iface->offer_head = (gboolean (*)(GeeDeque*, gconstpointer)) gee_array_queue_real_offer_head;
	iface->peek_head = (gpointer (*)(GeeDeque*)) gee_array_queue_real_peek_head;
	iface->poll_head = (gpointer (*)(GeeDeque*)) gee_array_queue_real_poll_head;
	iface->drain_head = (gint (*)(GeeDeque*, GeeCollection*, gint)) gee_array_queue_real_drain_head;
	iface->offer_tail = (gboolean (*)(GeeDeque*, gconstpointer)) gee_array_queue_real_offer_tail;
	iface->peek_tail = (gpointer (*)(GeeDeque*)) gee_array_queue_real_peek_tail;
	iface->poll_tail = (gpointer (*)(GeeDeque*)) gee_array_queue_real_poll_tail;
	iface->drain_tail = (gint (*)(GeeDeque*, GeeCollection*, gint)) gee_array_queue_real_drain_tail;
}


static void gee_array_queue_instance_init (GeeArrayQueue * self) {
	self->priv = GEE_ARRAY_QUEUE_GET_PRIVATE (self);
	self->priv->_start = 0;
	self->priv->_length = 0;
	self->priv->_stamp = 0;
}


static void gee_array_queue_finalize (GObject* obj) {
	GeeArrayQueue * self;
	self = GEE_ARRAY_QUEUE (obj);
	(self->priv->_equal_func_target_destroy_notify == NULL) ? NULL : (self->priv->_equal_func_target_destroy_notify (self->priv->_equal_func_target), NULL);
	self->priv->_equal_func = NULL;
	self->priv->_equal_func_target = NULL;
	self->priv->_equal_func_target_destroy_notify = NULL;
	self->priv->_items = (_vala_array_free (self->priv->_items, self->priv->_items_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
	G_OBJECT_CLASS (gee_array_queue_parent_class)->finalize (obj);
}


/**
 * Resizable array implementation of the {@link Dequeu} interface.
 *
 * The storage array grows automatically when needed.
 *
 * This implementation is pretty good for lookups at the end or random.
 * Because they are stored in an array this structure does not fit for deleting
 * arbitrary elements. For an alternative implementation see {@link LinkedList}.
 *
 * @see LinkedList
 */
GType gee_array_queue_get_type (void) {
	static volatile gsize gee_array_queue_type_id__volatile = 0;
	if (g_once_init_enter (&gee_array_queue_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeArrayQueueClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_array_queue_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeArrayQueue), 0, (GInstanceInitFunc) gee_array_queue_instance_init, NULL };
		static const GInterfaceInfo gee_deque_info = { (GInterfaceInitFunc) gee_array_queue_gee_deque_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_array_queue_type_id;
		gee_array_queue_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_QUEUE, "GeeArrayQueue", &g_define_type_info, 0);
		g_type_add_interface_static (gee_array_queue_type_id, GEE_TYPE_DEQUE, &gee_deque_info);
		g_once_init_leave (&gee_array_queue_type_id__volatile, gee_array_queue_type_id);
	}
	return gee_array_queue_type_id__volatile;
}


static void _vala_gee_array_queue_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeArrayQueue * self;
	self = GEE_ARRAY_QUEUE (object);
	switch (property_id) {
		case GEE_ARRAY_QUEUE_SIZE:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		case GEE_ARRAY_QUEUE_IS_EMPTY:
		g_value_set_boolean (value, gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) self));
		break;
		case GEE_ARRAY_QUEUE_READ_ONLY:
		g_value_set_boolean (value, gee_abstract_collection_get_read_only ((GeeAbstractCollection*) self));
		break;
		case GEE_ARRAY_QUEUE_CAPACITY:
		g_value_set_int (value, gee_abstract_queue_get_capacity ((GeeAbstractQueue*) self));
		break;
		case GEE_ARRAY_QUEUE_REMAINING_CAPACITY:
		g_value_set_int (value, gee_abstract_queue_get_remaining_capacity ((GeeAbstractQueue*) self));
		break;
		case GEE_ARRAY_QUEUE_IS_FULL:
		g_value_set_boolean (value, gee_abstract_queue_get_is_full ((GeeAbstractQueue*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gee_array_queue_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeArrayQueue * self;
	self = GEE_ARRAY_QUEUE (object);
	switch (property_id) {
		case GEE_ARRAY_QUEUE_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_ARRAY_QUEUE_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_ARRAY_QUEUE_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static void _vala_array_move (gpointer array, gsize element_size, gint src, gint dest, gint length) {
	g_memmove (((char*) array) + (dest * element_size), ((char*) array) + (src * element_size), length * element_size);
	if ((src < dest) && ((src + length) > dest)) {
		memset (((char*) array) + (src * element_size), 0, (dest - src) * element_size);
	} else if ((src > dest) && (src < (dest + length))) {
		memset (((char*) array) + ((dest + length) * element_size), 0, (src - dest) * element_size);
	} else if (src != dest) {
		memset (((char*) array) + (src * element_size), 0, length * element_size);
	}
}



